#!/bin/sh
# MetaCard 2.4 stack
# The following is not ASCII text,
# so now would be a good time to q out of more
exec mc $0 "$@"
                                                                                                                                  J mtp.mc  $-- This stack and all of the scripting in it is 1998 MetaCard Corporation.  All Rights Reserved.

------------------------------------------- General Info ----------------------------------
-- global studentInfo
-- -- item 1 = name of student
-- -- item 2 = level of student
-- -- item 3 = student password
-- -- item 4 = line number for student
-- -- item 5 = highest card number achieved

------------------------------------------- Card and Stack functions ----------------------------------
on openCard
  global studentInfo
  put the number of this card into theNum
  if (item 5 of studentInfo < theNum) or  (item 5 of studentInfo = theNum) then
    if there is a button "next" then
      hide button "next"
    end if
  else
    if there is a button "next" then
      show button "next"
    end if
  end if
end openCard

on closeCard
  global studentInfo
  if item 5 of studentInfo < the number of this card then
    put the number of this card into item 5 of studentInfo
  end if
  
end closeCard

on openStack
  go card "Title Screen"
end openStack

on closeStack
  save this stack
end closeStack
------------------------------------------- Prep user's script for comparison  ----------------------------------
on doCleanUp -- get rid of extra spaces before each line
  global storeMe
  --spaces
  repeat with i = 1 to the number of lines of storeMe
    repeat
      if the first char of line i of storeMe = " " then
        delete the first char of line i of storeMe
      else
        exit repeat
      end if
    end repeat
  end repeat
end doCleanUp
------------------------------------------- Compare user's script with real one  ----------------------------------
on checkIt
  -- did they type anything yet?
  if field "practice" = "" then
    answer "You have to type the script into the Practice field first."
    exit to MetaCard
  end if
  -- clean up both real and user scripts (remove extra spaces)
  repeat
    if word 1 of line 1 of field "practice" = "" then
      delete line 1 of field "practice"
    else
      exit repeat
    end if
  end repeat
  global storeMe
  put field "practice" into storeMe
  doCleanUp
  put storeMe into userScript
  put field "example" into storeMe
  doCleanUp
  put storeMe into realScript
  
  --compare real and user scripts line by line...
  repeat with i = 1 to the number of lines of realScript
    if line i of userScript <> line i of realScript then
      answer "There is a problem with line" && i & "."
      
      -- 1.  Extra char?
      if the number of chars of line i of userScript > the number of chars of line i of realScript then
        answer "There are too many characters in line" && i & ". Perhaps you've got an extra letter or space?"
        answer "Also, make sure you're using real quotes, and not two aphostrophes side by side!"
        -- locate and hilite the extra char
        -- how many spaces at the beginning of the bad line?
        put 1 into ct
        repeat
          if char ct of line i of field "practice" = " " then
            add 1 to ct
          else
            exit repeat
          end if
        end repeat
        subtract 1 from ct -- now ct = the number of spaces before the bad line
        repeat with j = 1 to the number of chars of line i of userScript
          if char j of line i of userScript is not char j of line i of realScript then
            select char (j + ct) of line i of field "practice"
            exit repeat
          end if
        end repeat
        exit to MetaCard
      end if
      
      -- 2.  Not enough chars?
      if the number of chars of line i of userScript < the number of chars of line i of realScript then
        answer "There are not enough characters in line" && i & ". Perhaps you've left out a letter or space?"
        answer "Check the spelling of each word in the line."
        -- locate and hilite the extra char
        -- how many spaces at the beginning of the bad line?
        put 1 into ct
        repeat
          if char ct of line i of field "practice" = " " then
            add 1 to ct
          else
            exit repeat
          end if
        end repeat
        subtract 1 from ct -- now ct = the number of spaces before the bad line
        repeat with j = 1 to the number of chars of line i of userScript
          if char j of line i of userScript is not char j of line i of realScript then
            select char (j + ct) of line i of field "practice"
            exit repeat
          end if
        end repeat
        exit to MetaCard
      end if
      
      -- 3.  Misspelled word, maybe?
      -- locate and hilite the misspelled or incorrect char
      -- how many spaces at the beginning of the bad line?
      put 1 into ct
      repeat
        if char ct of line i of field "practice" = " " then
          add 1 to ct
        else
          exit repeat
        end if
      end repeat
      subtract 1 from ct -- now ct = the number of spaces before the bad line
      repeat with j = 1 to the number of chars of line i of userScript
        if char j of line i of userScript is not char j of line i of realScript then
          answer "There's a wrong word or spelling mistake in your script."
          select char (j + ct) of line i of field "practice"
          exit repeat
        end if
      end repeat
      exit to MetaCard
    end if
    
    
  end repeat
  
  --so now everything should run perfectly...
  set the script of button "hidden" to userScript
  click at the loc of button "hidden"
end checkIt

------------------------------------------- When a student completes a lesson  ----------------------------------
on updateLevel
  global studentInfo
  if (the last word of the short name of this card) + 1 > word 2 of item 2 of studentInfo then
    put (the last word of the short name of this card) + 1 into word 2 of item 2 of studentInfo
  end if
  put studentInfo into line (item 4 of studentInfo) of field "hidden roster" of card "Main Menu"
  put field "hidden roster" of card "Main Menu" into field "roster" of card "Main Menu"
  repeat with i = 1 to the number of lines of field "roster" of card "Main Menu"
    delete item 5 of line i of field "roster" of card "Main Menu"
    delete item 4 of line i of field "roster" of card "Main Menu"
    delete item 3 of line i of field "roster" of card "Main Menu"
  end repeat
end updateLevel
------------------------------------------- Security (red shirt) functions ----------------------------------
on arrowKey
  if the selectedField is not empty then
    pass arrowKey
  else
    -- do nothing
  end if
end arrowKey



on doOut
  repeat with i = 1 to the number of lines of field "example"
    repeat
      if the last char of line i of field "example" = " " then
        answer "Extra space found in line" && i
        delete the last char of line i of field "example"
      else
        exit repeat
      end if
    end repeat
  end repeat
  answer "Script finished."
end doOut
  w                 white       	darkgray    X         mtp.mc     
 U 
Helvetica   W 
Helvetica  
 W 
Helvetica   U 
Helvetica   W 
Helvetica  U 
Helvetica   U 
Helvetica  U 
Helvetica   U 
Helvetica  U 
Helvetica   U 
Helvetica   W 
Helvetica   U 
Helvetica   U 
Helvetica   U 
helvetica    
Title Screen   	P on openCard
  
end openCard
           X          0     Welcome   	P *on openCard
  pass openCard
end openCard
           X         
Main Menu   	P *on openCard
  pass openCard
end openCard
           X                  (    I  J   Teacher Screen   	PRon openCard
  put field "hidden roster" of card "Main Menu" into field "hidden roster"
--place info
put field "hidden roster" into storeMe
repeat with i = 1 to the number of lines of storeMe
  delete item 5 of line i of storeMe
  delete item 4 of line i of storeMe
end repeat
put storeMe into field "roster"
  pass openCard
end openCard
           X                                        C Programmer's Sketchpad   	P +on openCard
  pass openCard
end openCard

           X    D  F  G  J  K  M  O  P      	 Lesson 1,1   	P on openCard
  hide button "previous"
  pass openCard
end openCard

on closeCard
  show button "previous"
pass closeCard
end closeCard
           X    e       Lesson 1,2   	P *on openCard
  pass openCard
end openCard
           X      *      _  u  |   Lesson 1,3   	P *on openCard
  pass openCard
end openCard
           X    d   Lesson 1,4   	P *on openCard
  pass openCard
end openCard
           X    |  
 Lesson 1,5   	P *on openCard
  pass openCard
end openCard
           X      |     Lesson 1,6   	P +on openCard
  pass openCard
end openCard

           X    3  4  5  d   Lesson 1,7   	P on openCard
  set the loc of image "fake button" to 70,186
  pass openCard
end openCard

on closeCard
  pass closeCard
end closeCard
           X                  +     Lesson 1,8   	P *on openCard
  pass openCard
end openCard
           X        ,   Lesson 1 final   	P on openCard
  global studentInfo
  put "Notebook for" && (item 1 of studentInfo) into field "notebook"
  pass openCard
end openCard
           X       End of the Road 1   	P *on openCard
  pass openCard
end openCard
           X    X   Lesson 1 Extension   	P +on openCard
  pass openCard
end openCard

           X    !  V Lesson 2,1   	P *on openCard
  pass openCard
end openCard
           X    e  %  \ Lesson 2,2   	P +on openCard
  pass openCard
end openCard

           X    d  k Lesson 2,3   	P +on openCard
  pass openCard
end openCard

           X    d  l Lesson 2,4   	P *on openCard
  pass openCard
end openCard
           X    d  	 Lesson 2,5   	@          X      &  w Lesson 2 final   	P on openCard
  global studentInfo
  put "Notebook for" && (item 1 of studentInfo) into field "notebook"
  pass openCard
end openCard
           X      d   End of the Road 2   	P *on openCard
  pass openCard
end openCard
           X    X   Lesson 2 Extension   	P +on openCard
  pass openCard
end openCard

           X    !     Lesson 3,1   	P *on openCard
  pass openCard
end openCard
           X    e  -   Lesson 3,2   	P *on openCard
  pass openCard
end openCard
           X    |   Lesson 3,3   	P *on openCard
  pass openCard
end openCard
           X    d   Lesson 3,4   	P +on openCard
  pass openCard
end openCard

           X    d   Lesson 3,5   	P +on openCard
  pass openCard
end openCard

           X    d   Lesson 3 final   	P on openCard
  global studentInfo
  put "Notebook for" && (item 1 of studentInfo) into field "notebook"
  pass openCard
end openCard
           X       End of the Road 3   	P *on openCard
  pass openCard
end openCard
           X    X   Lesson 3 Extension   	P +on openCard
  pass openCard
end openCard

           X    !     Lesson 4,1   	P *on openCard
  pass openCard
end openCard
           X    e  .   Lesson 4,2   	P *on openCard
  pass openCard
end openCard
           X    |   Lesson 4,3   	P *on openCard
  pass openCard
end openCard
           X    d   Lesson 4,4   	P *on openCard
  pass openCard
end openCard
           X    |   Lesson 4,5   	P +on openCard
  pass openCard
end openCard

           X    d   Lesson 4,6   	P *on openCard
  pass openCard
end openCard
           X    d   Lesson 4,7   	P *on openCard
  pass openCard
end openCard
           X    |  6 Lesson 4,8   	@          X    d   Lesson 4 final   	P on openCard
  global studentInfo
  put "Notebook for" && (item 1 of studentInfo) into field "notebook"
  pass openCard
end openCard
           X       End of the Road 4   	P *on openCard
  pass openCard
end openCard
           X    X   Lesson 4 Extension   	P +on openCard
  pass openCard
end openCard

           X    !     Lesson 5,1   	P *on openCard
  pass openCard
end openCard
           X    e  )   Lesson 5,2   	P *on openCard
  pass openCard
end openCard
           X    |   Lesson 5,3   	P *on openCard
  pass openCard
end openCard
           X    d   Lesson 5 final   	P *on openCard
  pass openCard
end openCard
           X    |   End of the Road 5   	P *on openCard
  pass openCard
end openCard
           X    X   Lesson 5 Extension   	P +on openCard
  pass openCard
end openCard

           X    !     Lesson 6,1   	P *on openCard
  pass openCard
end openCard
           X    e  /   Lesson 6,2   	P *on openCard
  pass openCard
end openCard
           X    |   Lesson 6,3   	P +on openCard
  pass openCard
end openCard

           X    d   Lesson 6,4   	P *on openCard
  pass openCard
end openCard
           X    |     Lesson 6,5   	P *on openCard
  pass openCard
end openCard
           X    |   Lesson 6,6   	P +on openCard
  pass openCard
end openCard

           X    d   Lesson 6 final   	P on openCard
  global studentInfo
  put "Notebook for" && (item 1 of studentInfo) into field "notebook"
  pass openCard
end openCard
           X       End of the Road 6   	P *on openCard
  pass openCard
end openCard
           X    X   Lesson 6 Extension   	P *on openCard
  pass openCard
end openCard
           X    !     Lesson 7,1   	P *on openCard
  pass openCard
end openCard
           X    e  ,   Lesson 7,2   	P *on openCard
  pass openCard
end openCard
           X    |   Lesson 7,3   	P *on openCard
  pass openCard
end openCard
           X    d   Lesson 7,4   	P *on openCard
  pass openCard
end openCard
           X    |  	 Lesson 7 final   	P on openCard
  global studentInfo
  put "Notebook for" && (item 1 of studentInfo) into field "notebook"
  pass openCard
end openCard
           X      
 End of the Road 7   	P *on openCard
  pass openCard
end openCard
           X    X   Lesson 7 Extension   	P +on openCard
  pass openCard
end openCard

           X    !     Lesson 8,1   	P *on openCard
  pass openCard
end openCard
           X    e  -   Lesson 8,2   	P *on openCard
  pass openCard
end openCard
           X    |   Lesson 8,3   	P *on openCard
  pass openCard
end openCard
           X    d   Lesson 8,4   	P +on openCard
  pass openCard
end openCard

           X    d   Lesson 8,5   	P *on openCard
  pass openCard
end openCard
           X    |   Lesson 8 final   	P on openCard
  global studentInfo
  put "Notebook for" && (item 1 of studentInfo) into field "notebook"
  pass openCard
end openCard
           X        End of the Road 8   	P *on openCard
  pass openCard
end openCard
           X    X  & Lesson 8 Extension   	P *on openCard
  pass openCard
end openCard
           X    !  %  ) Lesson 9,1   	P *on openCard
  pass openCard
end openCard
           X    e  .  * Lesson 9,2   	P *on openCard
  pass openCard
end openCard
           X    |  + Lesson 9,3   	P +on openCard
  pass openCard
end openCard

           X    d  , Lesson 9,4   	P *on openCard
  pass openCard
end openCard
           X    |  - Lesson 9,5   	P +on openCard
  pass openCard
end openCard

           X    d  . Lesson 9,6   	P +on openCard
  pass openCard
end openCard

           X    d  / Lesson 9 final   	P on openCard
  global studentInfo
  put "Notebook for" && (item 1 of studentInfo) into field "notebook"
  pass openCard
end openCard
           X      3 End of the Road 9   	P *on openCard
  pass openCard
end openCard
           X    X  9 Lesson 9 Extension   	P *on openCard
  pass openCard
end openCard
           X    !  8  < Lesson 10,1   	P *on openCard
  pass openCard
end openCard
           X    e  /  = Lesson 10,2   	P *on openCard
  pass openCard
end openCard
           X    |  > Lesson 10,3   	P +on openCard
  pass openCard
end openCard

           X    d  L Lesson 10,4   	P on openCard
  put field "hidden" into field "practice"
  pass openCard
end openCard

on closeCard
  put field "hidden" into field "practice"
  pass closeCard
end closeCard
           X    M  N  O  P  Q  T  U  V  W  e      ? Lesson 10 final   	P *on openCard
  pass openCard
end openCard
           X    |  C End of the Road 10   	P *on openCard
  pass openCard
end openCard
           X    X  I Lesson 10 Extension   	P +on openCard
  pass openCard
end openCard

           X    !  H  d Lesson 11,1   	P *on openCard
  pass openCard
end openCard
           X    e  1  2  f Lesson 11,2   	P *on openCard
  pass openCard
end openCard
           X    |  g  i Lesson 11,3   	P *on openCard
  pass openCard
end openCard
           X    |  j  l Lesson 11,4   	P uon openCard
  pass openCard
end openCard

on closeCard
  put "" into field "storage"
  pass closeCard
end closeCard
           X    m  ~ Lesson 11,5   	P uon openCard
  pass openCard
end openCard

on closeCard
  put "" into field "storage"
  pass closeCard
end closeCard
           X    m   Lesson 11 final   	P on openCard
  global studentInfo
  put "Notebook for" && (item 1 of studentInfo) into field "notebook"
  pass openCard
end openCard
           X       End of the Road 11   	P *on openCard
  pass openCard
end openCard
           X    X   Lesson 11 Extension   	P +on openCard
  pass openCard
end openCard

           X    !       Lesson 12,1   	P *on openCard
  pass openCard
end openCard
           X    e  3  4   Lesson 12,2   	P *on openCard
  pass openCard
end openCard
           X    |   Lesson 12,3   	P uon openCard
  pass openCard
end openCard

on closeCard
  put "" into field "storage"
  pass closeCard
end closeCard
           X    m   Lesson 12,4   	P *on openCard
  pass openCard
end openCard
           X    |   Lesson 12,5   	P uon openCard
  pass openCard
end openCard

on closeCard
  put "" into field "storage"
  pass closeCard
end closeCard
           X    m   Lesson 12,6   	P *on openCard
  pass openCard
end openCard
           X    |   Lesson 12 final   	P on openCard
  global studentInfo
  put "Notebook for" && (item 1 of studentInfo) into field "notebook"
  pass openCard
end openCard
           X       End of the Road 12   	P *on openCard
  pass openCard
end openCard
           X    X   Lesson 12 Extension   	P von openCard
  pass openCard
end openCard

on closeCard
  put "" into field "storage"

  pass closeCard
end closeCard
           X      m   Lesson 13,1   	P *on openCard
  pass openCard
end openCard
           X    e  6   Lesson 13,2   	P *on openCard
  pass openCard
end openCard
           X    |   Lesson 13,3   	P on openCard
  put 20  into field "food"
  put 20  into field "gold"
  put 20  into field "energy"
  put 20  into field "water"
  pass openCard
end openCard
           X       Lesson 13,4   	P on openCard
  put 20 into field "food"
  put 20 into field "gold"
  put 20 into field "energy"
  put 20 into field "water"
  pass openCard
end openCard
           X       Lesson 13,5   	P *on openCard
  pass openCard
end openCard
           X    |   lesson 13,6   	P *on openCard
  pass openCard
end openCard
           X    d   Lesson 13,7   	P *on openCard
  pass openCard
end openCard
           X    |   Lesson 13 final   	P on openCard
  global studentInfo
  put "Notebook for" && (item 1 of studentInfo) into field "notebook"
  pass openCard
end openCard
           X       End of the Road 13   	P *on openCard
  pass openCard
end openCard
           X    X  [ Lesson 13 extension   	P *on openCard
  pass openCard
end openCard
           X    !   Lesson 14,1   	P *on openCard
  pass openCard
end openCard
           X    e  7   Lesson 14,2   	P *on openCard
  pass openCard
end openCard
           X    |   Lesosn 14,3   	P *on openCard
  pass openCard
end openCard
           X    d   Lesson 14,4   	P *on openCard
  pass openCard
end openCard
           X    |   Lesson 14 final   	P on openCard
  global studentInfo
  put "Notebook for" && (item 1 of studentInfo) into field "notebook"
  pass openCard
end openCard
           X      Z End of the Road 14   	P *on openCard
  pass openCard
end openCard
           X    X   Lesson 14 extension   	P *on openCard
  pass openCard
end openCard
           X    !   Lesson 15,1   	P *on openCard
  pass openCard
end openCard
           X    e  0   Lesson 15,2   	P *on openCard
  pass openCard
end openCard
           X    |   Lesson 15,3   	P Ton openCard
  global flag15
  put "false" into flag15
  pass openCard
end openCard
           X    d   Lesson 15 final   	P *on openCard
  pass openCard
end openCard
           X    |  j End of the Road 15   	P *on openCard
  pass openCard
end openCard
           X    X  k Lesson 15 Extension   	P *on openCard
  pass openCard
end openCard
           X    !  l Lesson 16,1   	P *on openCard
  pass openCard
end openCard
           X    e     !  m Lesson 16,2   	P *on openCard
  pass openCard
end openCard
           X    |  n Lesson 16,3   	P *on openCard
  pass openCard
end openCard
           X    d  o Lesson 16,4   	P on openCard
repeat with i = 1 to 4
put line i of field "example" into line i of field "practice"
end repeat
  pass openCard
end openCard
           X    d  p Lesson 16,5   	P *on openCard
  pass openCard
end openCard
           X    |  q Lesson 16 Final   	P on openCard
  global studentInfo
  put "Notebook for" && (item 1 of studentInfo) into field "notebook"
  pass openCard
end openCard
           X      r End of the Road 16   	P *on openCard
  pass openCard
end openCard
           X    X   Lesson 16 Extension   	P *on openCard
  pass openCard
end openCard
           X    !   Lesson 17,1   	P *on openCard
  pass openCard
end openCard
           X    e  #  1   Lesson 17,2   	P *on openCard
  pass openCard
end openCard
           X    |   Lesson 17,3   	P *on openCard
  pass openCard
end openCard
           X        2   Lesson 17 final   	P on openCard
  global studentInfo
  put "Notebook for" && (item 1 of studentInfo) into field "notebook"
  pass openCard
end openCard
           X       End of the Road 17   	P *on openCard
  pass openCard
end openCard
           X    X   Lesson 17 Extension   	P *on openCard
  pass openCard
end openCard
           X    !     Lesson 18,1   	P *on openCard
  pass openCard
end openCard
           X    e  $   Lesson 18,2   	P *on openCard
  pass openCard
end openCard
           X    |   Lesson 18,3   	P yon openCard
  pass openCard
end openCard

on closeCard
put "" into field "cube's response"
pass closeCard
end closeCard
           X            *   Lesson 18,4   	P *on openCard
  pass openCard
end openCard
           X    |   Lesson 18 final   	P on openCard
  global studentInfo
  put "Notebook for" && (item 1 of studentInfo) into field "notebook"
  pass openCard
end openCard
           X       End of the Road 18   	P *on openCard
  pass openCard
end openCard
           X    X   Lesson 18 Extension   	P *on openCard
  pass openCard
end openCard
           X    !   Lesson 19,1   	P *on openCard
  pass openCard
end openCard
           X    e  %  &   Lesson 19 final   	P Xon openCard
  put field "storage" into field "practice"
 
  pass openCard
end openCard
           X                         End of the Road 19   	P *on openCard
  pass openCard
end openCard
           X    X   Lesson 19 Extension   	P *on openCard
  pass openCard
end openCard
           X    !   Lesson 20,1   	P *on openCard
  pass openCard
end openCard
           X    e  '  (   Lesson 20,2   	P *on openCard
  pass openCard
end openCard
           X    |  7 Lesson 20,3   	P on openCard
answer "Click on the robot."
end openCard

on closeCard
  hide image "mouth"
  hide button "dynamite"
  put "" into field "display"
end closeCard
           X    ?  @  A  B  C  D   Lesson 20,4   	P *on openCard
  pass openCard
end openCard
           X            |   end of program   	P on openCard
  global studentInfo
  put "You did it," && item 1 of studentInfo & "!" into line 1 of field "finished"
  pass openCard
end openCard
           X        
     	h          $H          WFind your name and click "Begin".  If you are new to the program, click "Add Student". 
     	h          @l          /                              List of Students 
   roster @)x   Ion mouseDoubleUp
  click at the loc of button "Begin"
end mouseDoubleUp
        
 Yl4                  `    @ e Z 2    Add Student Ewpon mouseUp
  --name
  ask "Enter your first and then last name:"
  if it = "" then exit to MetaCard
  put it into nam
  if offset(comma,nam) <> 0 then
    answer "You may not use a comma in your name.  Sorry!"
    exit to MetaCard
  end if
  if word 2 of nam = "" then
    answer "You need to enter a first AND last name, please!"
    exit to MetaCard
  end if
  if offset(nam,field "roster") <> 0 then
    answer "That name has already been entered."
    exit to MetaCard
  end if
  
  --password
  ask password clear "Enter a password.  Make sure it's easy for you to remember!"
  if it = "" then exit to MetaCard
  put it into passw
  if offset(comma,passw) <> 0 then
    answer "You may not use a comma in your password.  Sorry!"
    exit to MetaCard
  end if
  ask password clear "Verify your new password by entering it again:"
  if it <> passw then
    answer "That is not the same password."
    exit to MetaCard
  end if
  
  --place the info
  lock screen
  put return & nam & "," & " Lesson 1" & "," & passw & ",," & "6" after field "hidden roster"
  if line 1 of field "hidden roster" = "" then delete line 1 of field "hidden roster"
  sort lines of field "hidden roster" by word 2 of item 1 of each
  put field "hidden roster" into field "roster"
  repeat with i = 1 to the number of lines of field "roster" of card "Main Menu"
    delete item 5 of line i of field "roster" of card "Main Menu"
    delete item 4 of line i of field "roster" of card "Main Menu"
delete item 3 of line i of field "roster" of card "Main Menu"
    put " " before char 1 of item 2 of line i of field "roster" of card "Main Menu"
  end repeat
  
end mouseUp
         $ Adds a student to the list          	        Begin Ewhon mouseUp
  global studentInfo
  global studentName
  if the selectedText of field "roster" = "" then
    answer "You need to click on your name first."
    exit to MetaCard
  end if
  
  --retrieve password + level
  put word 2 of the selectedLine of field "roster" into thisLine
  put line thisLine of field "hidden roster" into studentInfo
  put thisLine into item 4 of studentInfo
  
  --check password
  ask password clear "Please enter your password:"
  if it = "" then exit to MetaCard
  if it <> item 3 of studentInfo then
    answer "That is not correct."
    exit to MetaCard
  end if
  put (item 2 of studentInfo) & ",1" into thisCard
  put item 1 of studentInfo into studentName
  
  delete char 1 of thisCard
  --add to log
  put return & the short date && "-" && item 1 of studentInfo &&  "logged on to" && item 1 of thisCard && "at" && the short time & "." after field "log" of card "Teacher Screen"
  --empty the fields
  repeat with i = 6 to the number of cards of this stack
    if there is a field "practice" of card i then put "" into field "practice" of card i
  end repeat
  go card thisCard
end mouseUp
       X  $ Begins the program          	     
     	h           P P        [The point of the cartoon was that you have to tell computers EXACTLY what you want them to do.  They need very specific instructions.  We tell computers what to do using a programming language.  Computers need EXACT instructions which follow rules.  The rules of a language are called the syntax.  Improper syntax will cause your program to fail! 
       j
     j 
     n 
    ! 
    ' 3       Demonstrate Ep on mouseUp
  global studentInfo
  ask "How are you feeling about programming so far," && (word 1 of item 1 of studentInfo) & "?"
  answer "You will learn to program faster than you know!"
end mouseUp
          0         	        Teacher Screen Ew on mouseUp
   ask password clear "Enter Password:"
   if it = "" then exit to MetaCard
   if it is "psgsafpc" then
     go card "Teacher Screen"
   else
      answer "That is not it."
   end if
end mouseUp
         $ Accesses the Teacher Screen          	        Quit Ew ]on mouseUp
  answer "Are you sure?" with "Yes" or "No"
if it is "Yes" then quit
end mouseUp
       l H           	       ! 
extension            `
  "   	`        P          Lesson 19 - Extension    Lesson 18 - Extension    Lesson 17 - Extension    Lesson 16 - Extension   k Lesson 15 - Extension    Lesson 14 - Extension   [ Lesson 13 - Extension    Lesson 11 Extension   I Lesson 10 Extension   9 Lesson 9 Extension   & Lesson 8 Extension    Lesson 7 Extension     Lesson 6 Extension    Lesson 5 Extension    Lesson 4 Extension    Lesson Three Extension    Lesson Two Extension    Lesson 1 Extension   b 
Main Menu E   .on mouseUp
  go card "Main Menu"
end mouseUp
       p X  Go to the Main Menu screen          	       x 	previous Sw +on mouseUp
  go previous card
end mouseUp
      p 8  Go to the previous screen             @             	        next Cw 'on mouseUp
  go next card
end mouseUp
      p 8  Go to the next screen             A             	     
  %   	h           P 0         OK, since you've made it this far, check out the following script... you might find it interesting...  oh yeah, and type it into the Practice Field.    So what else can you do with the random command?  Well, for one thing, you can create mazes that are different every time the user enters them.  Here's a small sample.  Type the following script into the Practice Field: 
       !
     ! 
     '    {Basic animation can be achieved by changing the position of an object.  Type the following script into the practice field:    Glad you chose to try the extension.  Here's an interesting use of the random command.  Type the following script into the Practice Field.  It is long and tricky, but very, very cool.  Notice the way the script is commented... 
       
      
      A  k PLesson 15 had a fairly long script, so I'll take it easy on you now.  Check out    Glad you decided to try this!  Here is a convoluted, twisted repeat loop that only a true programmer could love.  Type the following script into the Practice Field, and mind your syntax!   [ (Ah, you chose to extend.  Good for you!  The following script has something a little different... in line 4, you'll see the * sign.  The * sign basically means "times", and you can achieve it by holding down the shift key and pressing the number 8.      Here's a challenge - Type the following script into the practice field.  You don't need to worry about understanding all of the syntax... some of it you'll learn in later lessons!   I Here's a challenge - Type the following script into the practice field.  You don't need to worry about understanding all of the syntax... some of it you'll learn in later lessons!   9 Here's a challenge - Type the following script into the practice field.  You don't need to worry about understanding all of the syntax... some of it you'll learn in later lessons!   & Here's a challenge - Type the following script into the practice field.  You don't need to worry about understanding all of the syntax... some of it you'll learn in later lessons!                      F                                                                         Here's a challenge - Type the following script into the practice field.  You don't need to worry about understanding all of the syntax... some of it you'll learn in later lessons!    Here's a challenge - Type the following script into the practice field.  You don't need to worry about understanding all of the syntax... some of it you'll learn in later lessons!                      F                                                                         Here's a challenge - Type the following script into the practice field.  You don't need to worry about understanding all of the syntax... some of it you'll learn in later lessons!                      F                                                                         Here's a challenge - Type the following script into the practice field.  You don't need to worry about understanding all of the syntax... some of it you'll learn in later lessons!                      F                                                                         Here's a challenge - Type the following script into the practice field.  You don't need to worry about understanding all of the syntax.  Be sure to scroll down to the end of the script!    Here's a challenge - Type the following script into the practice field.  You don't need to worry about understanding all of the syntax... some of it you'll learn in later lessons!    Here's a challenge - Type the following script into the practice field.  You don't need to worry about lines 3 and 4... you'll learn them later.  But look how we've added the word with in line 2... 
       
      
      
    
          
          
          
          
          
          
          
          
         F                                                                      
       E
  8 example  	h          Blue     XL x         on mouseUp  ,   ask "How are you feeling?  Good or Bad?"  "   put random(2) into theResponse     if theResponse = 1 then        answer "Who cares?"     else        answer "Hmm.  I see."  
   end if  $   ask "What is your biggest fear?"  "   put random(2) into theResponse     if theResponse = 1 then  '      answer "Ha ha!  You're a loser."     else  :      answer "Well don't worry, everything will be fine!"  
   end if  end mouseUp    on mouseUp  J   answer "You're standing in front of a house with a door and a window."  ,   answer "Open..." with "Door" or "Window"     put it into playerChoice     put random(2) into theEvent  !   if playerChoice = "Door" then        if theEvent = 1 then  7         answer "You are attacked and killed.  Sorry."        else  '         answer "You enter the house."  
      end if     else  %      answer "The window is locked."  
   end if  end mouseUp      on mouseUp     answer "The plane flew by."     put "-18,212" into planeLoc     repeat for 30 times  0      set the loc of button "plane" to planeLoc  #      add 20 to item 1 of planeLoc        wait 50 milliseconds     end repeat  .   set the loc of button "plane" to "-18,212"  end mouseUp    on mouseUp     put 5 into playerPoints     put 5 into trollPoints  !   answer "A Troll Attacks you!"     --begin fight  
   repeat  F      answer "Swing Sword, or Raise Shield?" with "Sword" or "Shield"        put it into playerMove  #      put random(2) into trollMove        --the Troll swings        if trollMove = 1 then  &         answer "The Troll swings..."  '         if playerMove = "Shield" then  J            answer "...but you block it and deliver a blow to the Troll!"  (            subtract 1 from trollPoints           else  &            answer "...and hits you!"  )            subtract 1 from playerPoints           end if        else        --the Troll pauses...  &         answer "The Troll pauses..."  &         if playerMove = "Sword" then  +            answer "...and you clock him!"  (            subtract 1 from trollPoints           else  '            answer "...and so do you."           end if  
      end if        --update the status  c      answer "You have" && playerPoints && "points, and the Troll has" && trollPoints && "points."        if trollPoints = 0 then  -         answer "You have killed the Troll."           exit repeat  
      end if        if playerPoints = 0 then  %         answer "You have perished."           exit repeat  
      end if     end repeat  end mouseUp   k on mouseUp  :   answer "This is the world famous Cheerleader Program."  "   ask "What is your first name?"     put it into theName  I   repeat with i = 1 to the number of chars of the first word of theName        answer char i of theName     end repeat  '   answer "...spells" && theName & "!"  end mouseUp        on mouseUp  "   ask "Type a word... any word:"  !   put word 1 of it into theWord     answer "I can spell that!"  <   repeat with i = 1 to the number of characters of theWord        answer char i of theWord     end repeat  $   answer "Spells" && theWord & "!"  end mouseUp         [ on mouseUp  '   answer "I'm going to count by 5's."     repeat with i = 1 to 4        answer i * 5     end repeat  /   answer "...I don't know all of my 5's yet."  end mouseUp    on mouseUp  =   answer "Want to see a secret message?" with "Yes" or "No"  ,   if it is "No" then answer "Sure you do!"     show field "secret"     wait 3 seconds     hide field "secret"  *   answer "That was your secret message."  end mouseUp   I on mouseUp  Z   answer "You're standing in front of a house.  The door is open, and so is the window."  L   answer "Go through window, or go through door?"  with "Window" or "Door"     if it is "Door" then  `      answer "You're greeted by an old man.  He stares at you."  with "Say Hello" or "Run Away"         if it is "Say Hello" then  <         answer "The old man hands you a key, then leaves."           put "yes" into ownKey        else  =         answer "The front door closes before you reach it."  
      end if     else  C      answer "You try to enter through the window, but you can't."  
   end if  F   answer "You look around and see a door." with "Run" or "Open Door"     if ownKey = "Yes" then          answer "The door opens."     else  =      answer "The door is locked, and you don't have a key."  
   end if  end mouseUp   9 on mouseUp  1   answer "You are standing in a haunted house."  J   answer "Do you wish to go upstairs or downstairs?" with "Up" or "Down"     if it is "Up" then  9      answer "You meet a ghost." with "Say Hi" or "Run!"  +      answer "Bad choice.  You disappear."     else  $      answer "Don't go down there."  )      answer "Too late.  You disappear."  
   end if  end mouseUp   & on mouseUp  .   answer "You are approaching an old house."  <   answer "As you walk up to the door, you hear a sound..."  @   answer "Run away, or enter the house?" with "Run" or "Enter"     if it = "Run" then  ?      answer "You run, but the whole house falls down on you."     else  8      answer "You enter, and discover it's just a cat."  
   end if  end mouseUp    on mouseUp  -   answer "Choose a door..." with "1" or "2"     if it is 1 then  "      answer "You open door 1..."     else  "      answer "You open door 2..."  
   end if  /   answer "...and a tiger eats you!  THE END."  end mouseUp    on mouseUp  .   answer "How are you?" with "Bad" or "Good"  A   answer "Would you like a cheese sandwich?" with "Yes" or "No"  :   answer "Do you know who Elvis was?" with "Yes" or "No"  Q   answer "Do you get the point of the answer/with command?" with "Yup" or "Yes"  I   answer "You can make people do silly things with the answer command."  F   answer "I am goofy and I dress funny."  with "Click here if true."  A   answer "See?  You didn't have a choice!"  with "Gee, thanks."  end mouseUp    on mouseUp     global studentInfo  R   answer item 1 of studentInfo && "just finished" && item 2 of studentInfo & "!"  Q   put the number of characters of word 1 of item 1 of studentInfo into thisMany  U   answer (word 1 of item 1 of studentInfo) && "has" && thisMany && "letters in it."     if thisMany > 5 then        answer "That's a lot!"     else         answer "That's not many."  
   end if  end mouseUp    on mouseUp     global studentInfo  O   answer "Want to see something irritating," && (item 1 of studentInfo) & "?"  &   answer "I'm going to count to 10."     repeat with i = 1 to 10        answer i     end repeat  end mouseUp    on mouseUp     global studentName  3   ask "OK, for the last time, what is your name?"  &   if it = item 1 of studentInfo then        play "good"     else        play "lie"  
   end if  end mouseUp    on mouseUp 
 @       Blue    
    global studentName 
 @       Blue        ask "What is your name?" 
 @       Blue        put it into nam 
 @       Blue     -   answer "Are you sure?" with "Yes" or "No" 
 @       Blue    , K   answer "Really? I thought your name was" && item 1 of studentName & "." 
 @       Blue    J end mouseUp 
 @       Blue       on mouseUp 
 @       Blue    
 F   ask "What color was George Washington's white horse?" with "white" 
 @       Blue    E    if it is "white" then 
 @       Blue           answer "Very good!" 
 @       Blue        else 
 @       Blue     ,      answer "I gave you the answer!  Duh!" 
 @       Blue    + 
   end if 
 @       Blue    	 end mouseUp 
 @       Blue          	`    @ C Y  v 
  <   (          H            ]                                                                              Practice Field 
  & 	practice  )h          L x                        k        [        I    9    &                          
 @       Blue         
 @       Blue           `    @ C   v   # OK Ewon mouseUp
  checkIt
  answer "Nice job!  You can now go to  the Programmer's Sketchpad, go the Main Menu, run the Script Again, or do the next lesson:" with "Sketchpad" or "Main Menu" or "Run Again" or "Next Lesson"
  if it is "Run Again" then exit to MetaCard
  if it is "Sketchpad" then
    go card "Programmer's Sketchpad"
  end if
  if it is "Main Menu" then
    go card "Main Menu"
  end if
  if it is "Next Lesson" then
    go next card
  end if
end mouseUp
      l T   Runs the script          	        hidden  @
gon mouseUp
ask "How are you feeling?  Good or Bad?"
put random(2) into theResponse
if theResponse = 1 then
answer "Who cares?"
else
answer "Hmm.  I see."
end if
ask "What is your biggest fear?"
put random(2) into theResponse
if theResponse = 1 then
answer "Ha ha!  You're a loser."
else
answer "Well don't worry, everything will be fine!"
end if
end mouseUp
                    	   	   	   	   	  k 	   	  [ 	   	  I 	  9 	  & 	   	   	   	   	   	   	   	     
  ( hidden roster  !h   
       , $ d            )    `    @ ?   b   * OK Ew 'on mouseUp
  go next card
end mouseUp
       l T   Go to the next screen          	       3 New Button E`                   	       4 New Button E`         T          	       5 New Button E`         |          	     
  D   	`        P         C GProgrammer's Sketchpad - Use this screen to try out scripting ideas.   
  F            $         C C                                                    Practice Field 
  G 	practice  )`        @(        C    I    `    @  A    H    a    @  W  
  J   	`       $          C Sample Scripts 
  K 
help list  )x   
 on keyDown
 answer "You can't modify this field.  You can only copy from it."
end keyDown

on backspaceKey
 answer "You can't modify this field.  You can only copy from it."
end backspaceKey
        A (        C You can copy scripts from   "this field.  Don't copy the bold  
       
      
        words, though!    add 
        on mouseUp     ask "First Number:"     put it into firstVar     ask "Second Number:"     put it into secondVar     answer firstVar + SecondVar  end mouseUp    answer 
        on mouseUp  /     answer "Are you cool?" with "Yes" or "No"  end mouseUp    ask 
        on mouseUp       ask "What is your name?"  end mouseUp    ask password clear 
        on  mouseUp  0     ask password clear "Please enter password"       put it into password  +     answer "Your password is" && password  end mouseUp    	multiply 
        on mouseUp     ask "First Number:"      put it into firstVar     ask "Second Number:"     put it into secondVar     answer firstVar * secondVar  end mouseUp    play 
        on mouseUp       play "Lie"  end mouseUp    put 
        on mouseUp  %     put "hello" into card field "a"  end mouseUp    random 
        on mouseUp  *   answer "A random number 1 through 20:"     answer Random(20)  end mouseUp    	subtract 
        on mouseUp     ask "Enter Dividend:"     put it into var1     ask "Enter Divisor:"     put it into var2     answer var1 / var2  end mouseUp    wait 
        on mouseUp       wait 3 seconds        answer "I waited for you."  end mouseUp    If/Then statements 
        on mouseUp     ask "Enter your name"     if it <> "" then  $      answer "That is a nice name."  
   end if  end mouseUp    on mouseUp  /     answer "Are you cool?" with "Yes" or "No"       if it is "Yes" then  !          answer "You are cool."       end if       if it = "No" then  %          answer "You are not cool."       end if  end mouseUp    Repeat 
        on mouseUp     repeat for 5 times  "      answer "Read this 5 times."     end repeat  end mouseUp    on mouseUp     answer "I can count to 10!"     repeat with i = 1 to 10        answer i     end repeat  end mouseUp     T    	`    @ C B    U    	a    @ X     M Run Script Ew on mouseUp
if field "Practice" = "" then
answer "There's nothing to run."
exit to MetaCard
end if
  set the script of button "hidden" to field "Practice"
  click at the loc of button "hidden"
end mouseUp
        p p          	       O 
Main Menu E   .on mouseUp
  go card "Main Menu"
end mouseUp
       p X          	       P hidden  A*                    	       d practice screens   i          \
  f 
lesson title  	h          P         o Lesson 16 - Practice   n Lesson 16 - Practice    Lesson 15 - Practice    Lesson 14 - Practice    Lesson 13 - Practice   > Lesson 10 - Practice    . Lesson 9 - Practice   - Lesson 9 - Practice    + Lesson 9 - Practice     Lesson 8 - Practice     Lesson 8 - Practice    Lesson 7 - Practice     Lesson 6 - Practice     Lesson 6 - Practice     Lesson 5 - Practice   6 Lesson 4 - Practice    Lesson 4 - Practice     Lesson 4 - Practice     Lesson 4 - Practice    Lesson 3 - Practice      Lesson 3 - Practice      Lesson 3 - Practice    l Lesson 2 - Practice    k Lesson 2 - Practice    \ Lesson 2 - Practice    Lesson 1 - Practice    Lesson 1 - Practice 
  h info  	h           P :        oGood work.  Let's do something a little more fun. Let's do an RPG simulator.  RPG stands for "Role Playing Game".  In this script, you'll be the hero or heroine and you meet a Troll.  Type the following script into the Practice Field (I've entered the first four lines for you!)...   n OK, so we're learning the random command today.  The syntax is easy: the command "random(20)" makes the computer choose any number (at random) between 1 and 20.  Type the following script into the Practice Field: 
       R
     R 
     X |   This is one of the longer scripts.  Again, just take your time with it... don't rush.  Type the following script into the Practice Field, and whatever you do, be CAREFUL and mind your syntax!      This game combines most of what we've learned.  The script is a little long.  Take your time and don't rush.  Type the following script into the Practice Field.  Be careful to use proper syntax!   ENow let's add something else... the word "with".  So far we've been using a variable named "ct" to store numbers so we can count with them.  In case you didn't guess, "ct" is short for "count".  Anyway, we're going to add the word "with" and create a more powerful script.  Type the following script into the Practice Field:   > GType the following script into the Practice Field.  Watch your syntax!   . lStill with me?  Good.  Here's one more practice script.  Type the following script into the Practice Field:   - HEnter the following script into the Practice Field.  Watch your syntax!   + ]Type the following script.  It's a long one, so be patient.  Notice the word else in line 5. 
       M
     M 
     Q    oGood work.  Let's give our script a bigger list of things.  Type the following script into the Practice Field:    Type the following script into the Practice Field.  Notice the end if part of the structure - this tells the script when the if/then structure is finished. 
       ?
     ? 
     E 8
     } 
      
   The following script demonstrates how a basic if/then structure works.  Type it into the Practice Field.  As usual, watch your syntax! 
       .
     . 
     ? G   pYou can also use answer with but specify only one response.  Type the following script into the Practice Field: 
       
      
      S   SType the following script into the Practice Field.  Remember to watch your syntax!    Type the following script into the Practice Field.  Don't forget to scroll all the way to the end (end mouseUp)!  Notice that lines 6 and 9 contain something unfamiliar... the "if/then" structure.  Don't worry... we'll get to them very soon! 
       
      
      9  6/What happens when you call a local variable but there's nothing in it?  MetaCard will return the name of the variable!  This is called a "literal", because the program will literally give you the name of the variable.  Confused?  Type the following script into the Practice Field and all will be clear:    OK, now let's see what was remembered.  You entered info on your favorite food and drink.  Type the following script into the Practice Field:   Let's practice some more.  We're going to create a local variable on this screen, as well as a global variable.  Then on the next screen we'll see that the local variable has been forgotten, but the global variable has been remembered!  Type the script into the Practice Field. 
       3
     3 
     A 
     _ 
     n .
      
      
      
      ?   This program uses a global variable to remember which student is using it!  Type the script below into the Practice Field to see how this works: 
       
      
     # m  9This script will respond to a user by name.  In order to attach the text string ("Glad to have you aboard,") to the variable "nam", we use two "&" signs.  Using one "&" sign would join them together also, but using two joins them together with a space between.  Type the following script into the Practice Field:    Very good!  But who wants to type long things like "temporaryVariable" as a name for your invisible box in RAM?  We can name our variable anything we want to.  Type the following script: 
       
      
      1   Let's get going.  Today you're going to learn what a variable is.  A variable is like a temporary storage box located in your computer's RAM.  Type the following script into the practice field.  Note that "temporaryVariable" is all one word: 
       5
     5 
     = 
     E 
     M   l As you can see, the answer command is powerful and simple.  Here's one more, combining the ask command and the answer command.  Type this script into the Practice Field: 
       
      
      A
     [ 
     ^ 
     o 
     u 4  k Great!  See how easy MetaTalk is?  The answer command brings up a dialog box which displays text.  Here's some more practice working with the answer command.  Type it into the Practice Field: 
       B
     B 

     L B
      
      +  \We have to TELL computers what to do.  They will tend to sit around and do nothing all day unless we program them.  In Lesson 1 you learned the ask command.  In this lesson you'll learn the answer command.  Type the following script into the practice field: 
       
      
      +
      
      =             Practice Field    There are rules to writing scripts, just like rules to writing sentences and paragraphs.  Remember, these rules are called syntax.  So now let's script something cool.  Type the following script into the practice field, then click "OK". 
       {
     { 
      k               \                                                                             Practice Field    Writing a "handler".   
       
       Type the following script into the field labeled "Practice Field".  Be sure you enter each letter and space EXACTLY as it is typed!  Click the "OK" button when you've finished. 
       l
 @       Red  l 
     s =  
          
          
          
          
          
          
  ^ Example  	h          Blue     `P t        o on mouseUp      ask "Enter your first name:"  !   put word 1 of it into theName  g   answer theName && "enters a room.  There's a Troll standing in front of you." with "Fight" or "Run"     put random(2) into theEvent     if theEvent = 1 then  >      answer "The Troll attacks and defeats" && theName & "."     else  9      answer "The Troll runs away from" && theName & "."  
   end if  end mouseUp   n on mouseUp     global highScore  1   if highScore = "" then put 100 into highScore  !   put random(20) into theNumber  F   answer "I'm going to ask you to choose a number between 1 and 20."     repeat with i = 1 to 100  *      ask "Enter guess number" && i & ":"  -      if it > theNumber then answer "Lower."  .      if it < theNumber then answer "Higher."        if it = theNumber then           put i into finalScore           exit repeat  
      end if     end repeat  2   answer "It took you" && finalScore && "tries."  #   if finalScore <  highScore then  (      answer "You beat the high score!"        put i into highScore  
   end if  end mouseUp    on mouseUp     global highScore  1   if highScore = "" then put 100 into highScore     put 9 into theNumber  F   answer "I'm going to ask you to choose a number between 1 and 20."     repeat with i = 1 to 100  +      ask "Enter guess number" &&  i & ":"  -      if it > theNumber then answer "Lower."  .      if it < theNumber then answer "Higher."        if it = theNumber then           put i into finalScore           exit repeat  
      end if     end repeat  2   answer "It took you" && finalScore && "tries."  #   if finalScore <  highScore then  (      answer "You beat the high score!"        put i into highScore  
   end if  end mouseUp    on mouseUp  %   answer "This is a guessing game!"  D   answer "You're going to have to guess the word I'm thinking of."  -   answer "Here's a hint.  It has 5 wheels."  
   repeat        ask "What is it?"        if it = "car" then           answer "You win!"           exit repeat        else  $         answer "Nope.  Try again."  
      end if     end repeat  end mouseUp    on mouseUp     repeat with i = 1 to 10        answer i     end repeat  end mouseUp   > on mouseUp  [   answer "You're standing in front of a maze.  There are two openings, labelled 1 and 2."  9   answer "Go through opening 1, or 2?"  with "1" or "2"     if it is "1" then  `      answer "You're greeted by an old man.  He stares at you."  with "Say Hello" or "Run Away"         if it is "Say Hello" then  <         answer "The old man hands you a key, then leaves."        else  =         answer "The front door closes before you reach it."  
      end if     else  B      answer "You try to enter through opening 2, but you can't."  
   end if  end mouseUp     . on mouseUp  m   answer "Your teacher asks you for your homework.  You lost it.  Do you..." with "Lie" or "Tell the Truth"     if it is "Lie" then  (      answer "Your teacher flunks you."     else  3      answer "Your teacher lets you off the hook!"  
   end if  end mouseUp   - on mouseUp  /   answer "Are you hungry?" with "Yes" or "No"     if it is "Yes" then  #      answer "Pretend you aren't."     else         answer "Pretend you are."  
   end if  end mouseUp   + on mouseUp  6   answer "Choose door 1, or door 2?" with "1" or "2"     if it is "1" then  #      answer "You found the exit!"     else  -      answer "You fall into a pit.  Bummer."  
   end if  end mouseUp    on mouseUp  5   answer "Enter door 1, or door 2?" with "1" or "2"     if it is "1" then  /      answer "You are attacked by a gorrilla."  5      answer "You survive, but you fall into a pit."  /      answer "You live, but a tiger eats you."  
   end if  end mouseUp    on mouseUp     ask "Enter any number:"     if it is not a number then  %      answer "That is not a number!"  
   end if     if it is a number then        answer "Thank you."  
   end if  end mouseUp    on mouseUp     global studentName     ask "What is your name?"  4   if it is studentName then answer "You're right."  Q   if it is not studentName then answer "No it isn't. It's" && studentName & "."  end mouseUp      on mouseUp  1   answer "I am a genius." with "No you aren't."  $   answer "Yes I am!"  with "Nope."  /   answer "Oh... I'm not." with "Yes you are."  end mouseUp    on mouseUp  S   answer "You've clicked on a box.  It's ticking." with "Open it!" or "Run Away!"     answer "You chose" && it  end mouseUp    on mouseUp  -   answer "Welcome to the Wacky Calculator!"     ask "What is your name?"  *   answer "Good to meet you," && it & "."     ask "Give me a number:"     put it into num  /   if it is not a number then exit to MetaCard  !   ask "Give me another number:"     put it into num2  /   if it is not a number then exit to MetaCard     answer num + num2     answer "Aren't I smart?"  end mouseUp   6 on mouseUp  R   answer "I'm going to show you a local variable before putting anything in it!"     answer myWord  %   ask "Now type a word (any word):"     put it into myWord     answer myWord     answer "Get it?"  end mouseUp    on mouseUp     global faveFood  .   answer "Your favorite food is" && faveFood  0   answer "Your favorite drink is" && faveDrink  end mouseUp    on mouseUp     global faveFood  %   ask "What is your favorite food?"     put it into faveFood  &   ask "What is your favorite drink?"     put it into faveDrink  end mouseUp    on mouseUp     global studentName      answer item 1 of studentName  
 end mouseUp    on mouseUp  %   ask "Player One, type your name:"     put it into nam  2   answer "Glad to have you aboard," && nam & "."  end mouseUp    on mouseUp  $   put "I love MetaTalk." into temp     answer temp  end mouseUp    on mouseUp  &   put "Hello" into temporaryVariable     answer temporaryVariable  end mouseUp   l on mouseUp     ask "What is your name?"  !   answer "Pleased to meet you!"  end mouseUp   k on mouseUp  2   answer "Hello.  Here's the date and the time."     answer the date     answer the time  end mouseUp   \ on mouseUp  3   answer "I'm going to tell you what time it is!"     answer the time  end mouseUp    on mouseUp 
 @       Blue    
    ask "What is your name?" 
 @       Blue         ask "When is your birthday?" 
 @       Blue     &   ask "What is your favorite color?" 
 @       Blue    % end mouseUp 
 @       Blue       on mouseUp 
 @       Blue    
    ask "Does this work?" 
 @       Blue     end mouseUp 
 @       Blue      {    	`    @ C a  r 
  a 	practice  )`        P {        o    n                >    .    -    +                            6                            l    k    \            j    `    @ C   y   c OK E   on mouseUp
  checkIt
  answer "Good Job!  Do you want to run it again, or continue?" with "Run again" or "Continue"
  if it is "Continue" then go next card
end mouseUp
       l T   Run the script          	       b hidden  @
_on mouseUp
ask "Enter your first name:"
put word 1 of it into theName
answer theName && "enters a room.  There's a Troll standing in front of you." with "Fight" or "Run"
put random(2) into theEvent
if theEvent = 1 then
answer "The Troll attacks and defeats" && theName & "."
else
answer "The Troll runs away from" && theName & "."
end if
end mouseUp
                    	  o 	  n 	   	   	   	  > 	  . 	  - 	  + 	   	   	   	   	   	   	  6 	   	   	   	   	   	   	  l 	  k 	  \ 	   	   
  ;            H            ^                                                                               Practice Field   ` 
Main Menu E   .on mouseUp
  go card "Main Menu"
end mouseUp
      p X  Go to the Main Menu screen          	       v 	previous Sw +on mouseUp
  go previous card
end mouseUp
      p 8  Go to the previous screen             @             	       } next Cw 'on mouseUp
  go next card
end mouseUp
      p 8  Go to the next screen             A             	     
  F 
shareware             Black    g  $           RThis is unregistered shareware.  Use it for 30 days, then pay for it or trash it!   | 
info screens   i           X
  }   	`        P          Lesson 20 - Information    Lesson 20 - Information    Lesson 18 - Information    Lesson 18 - Information    Lesson 17 - Information   p Lesson 16 - Information   m Lesson 16 - Information    Lesson 15 - Information    Lesson 15 - Information    Lesson 14 - Information    Lesson 14 - Information    Lesson 13 - Information    Lesson 13 - Information    Lesson 13 - Information    Lesson 12 - Information    Lesson 12 - Information    Lesson 12 - Information   i Lesson 11 - Information    f Lesson 11 - Information   ? Lesson 10 - Summary   = Lesson 10 - Information    , Lesson 9 - Information    * Lesson 9 - Information     Lesson 8 - Information     Lesson 8 - Information    Lesson 7 - Information     Lesson 7 - Information     Lesson 6 - Information     Lesson 6 - Information     Lesson 6 - Information     Lesson 5 - Information     Lesson 5 - Information     Lesson 4 - Information      Lesson 4 - Information      Lesson 4 - Information     Lesson 3 - Information   
 Lesson 1 - Information    Lesson 1 - Information 
  ~   	`         PH        NNow that you know MetaTalk, you can go on to learn MetaCard and create screens like the one you just saw.  The graphics for the previous screen were done using Ray Dream 3D, a 3D rendering program for the Mac and PC.  When you learn MetaCard, you'll learn how to create artwork in other programs and easily import them into your own!   Here's the script for the robot you just saw.  You can spend as much or as little time viewing this script as you'd like... this uses some of the things you've learned in MetaTalk Programmer and adds a thing or two, but it shows you what you can do with MetaTalk!    on mouseUp 
 @       Blue    
   global speakThis 
 @       Blue     B  put "Greetings, human.  Nice of you to drop by." into speakThis 
 @       Blue    A   doTalk -- This is a subroutine!  This sends the script to the "doTalk" function at the end of the script and then back again. 
 @       Blue    	
 @        Black    	 v B  put "Solve my puzzle and I'll give you an item!" into speakThis 
 @       Blue    A 	  doTalk 
 @       Blue     *  put "What has 5 wheels?" into speakThis 
 @       Blue    ) 	  doTalk 
 @       Blue       wait 1 second 
 @       Blue     &  ask "What has 5 wheels?" with "car" 
 @       Blue    %   if it is "car" then 
 @       Blue     $    put "Great job!" into speakThis 
 @       Blue    #     doTalk 
 @       Blue    
 :    put "I give you the gift of dynamite!" into speakThis 
 @       Blue    9     doTalk 
 @       Blue    
 R    show button "dynamite"  -- the button contains an icon of a stick of dynamite 
 @       Blue    
 @        Black   6 0    answer "That's the end of this brief demo." 
 @       Blue    /     go next card 
 @       Blue       else 
 @       Blue         answer "Try again." 
 @       Blue         exit to MetaCard 
 @       Blue     	  end if 
 @       Blue     end mouseUp 
 @       Blue      
 @       Blue      Con doTalk  -- when the script above issues the command "doTalk"... 
 @       Blue    B   global speakThis 
 @       Blue       put "" into field "display" 
 @       Blue     8  repeat with i = 1 to the number of words of speakThis 
 @       Blue    7 i    show image "mouth" -- there's a picture of an open mouth that we hide and show to simulate speech... 
 @       Blue    h C    put " " & word i of speakThis after word i of  field "display" 
 @       Blue    B     wait 10 ticks 
 @       Blue         hide image "mouth" 
 @       Blue         wait 10 ticks 
 @       Blue     
  end repeat 
 @       Blue       wait 2 seconds 
 @       Blue     ,end doTalk  -- return to the regular script 
 @       Blue    
 @        Black      This is the final lesson.  After viewing this lesson, you're on your own.  Go get a copy of MetaCard and start creating great software!  The only limit is your imagination.    The next screen is an example of how you'd use MetaTalk to make a scene from a game.  You will meet a robot named Lester who will give you an item for your inventory, but only if you can solve his riddle.  Don't worry... we've made it easy for you!        Here's how it works:   
         
         on mouseUp 
 @       Blue    
     answer "The Cube knows all." 
 @       Blue        ask "Ask your question:" 
 @       Blue         put random(4) into theAnswer 
 @       Blue      
         VNote that it really doesn't matter what the user types... we don't store it anywhere! 
       U `In the next few sections, the response is decided based on whatever random number was chosen... 
       _  
            if theAnswer = 1 then 
       
 @       Blue    1      put "Dream on!" into field "cube's answer" 
 @       Blue    0 
   end if 
 @       Blue    	  
 @       Blue         if theAnswer = 2 then 
 @       Blue     0      put "As if!" into field "cube's response" 
 @       Blue    / 
   end if 
 @       Blue    	  
 @       Blue         if theAnswer = 3 then 
 @       Blue     5      put "Absolutely!" into field "cube's response" 
 @       Blue    4 
   end if    
 @       Blue      
 @       Blue         if theAnswer = 4 then 
 @       Blue     4      put "Certainly!" into field "cube's response" 
 @       Blue    3 
   end if 
 @       Blue    	 end mouseUp 
 @       Blue       Alright, get ready... this lesson has the coolest project in the whole program.  For in this lesson, you will construct... The Cube!      What is The Cube?  The Cube is an all-powerful, all-knowing cyberbox which can predict the future!  Alright, it isn't really.  Actually, it's the modern equivalent of the Magic 8 Ball.  It will answer yes or no questions, based on random choice.    But it's pretty cool.    In this lesson, you're going to hide Billy from Agatha.  Agatha is looking for Billy, but as usual Billy hasn't done his homework.  So Billy is going to do a disappearing act.  And what will be the syntax for hiding the image of Billy?  You guessed it...    hide image "Billy" 
 @       Blue       Isn't MetaTalk easy?   p Here's the play by play...   
 @       Blue      on mouseUp 
 @       Blue    
    ask "Enter you first name:" 
 @       Blue     !   put word 1 of it into theName 
 @       Blue       
 @       Blue      Why do we put word 1 of it into theName?  Why not just put "it" into theName?  Because the user might not have followed your directions... they might have typed their whole name.  We only want their first. 
 @        Black      
 @       Blue      g   answer theName && "enters a room.  There's a Troll standing in front of you." with "Fight" or "Run" 
 @       Blue    f  
 @       Blue      Notice that we don't put the result of which button they click into anything.  It doesn't matter what they click!  But they don't need to know that. 
 @        Black      
 @       Blue         put random(2) into theEvent 
 @       Blue      
 @        Black      RThis puts either the number 1 or the number 2 into the variable named "theEvent". 
 @        Black    Q  
 @       Blue         if theEvent = 1 then  
 @       Blue     >      answer "The Troll attacks and defeats" && theName & "." 
 @       Blue    =    else 
 @       Blue     9      answer "The Troll runs away from" && theName & "." 
 @       Blue    8 
   end if 
 @       Blue    	  
 @       Blue      hThis if/then/else structure decides the fate of the player, based on whether the computer chose 1 or 2. 
 @        Black    g  
 @        Black      end mouseUp 
 @       Blue      m In the last game, you programmed the computer to ask the user to guess a number.  Of course, since you knew what the number was, it was no challenge to you.  At least I hope not.    But after the user has played your game, they know the answer!  What fun is it to play a game when you already know the answer?  No fun.      But what if the computer picked a different number every time you played?  What if it chose one at random?  It would be cool if you could say, "choose any number between 1 and 20".  Then even you (the almighty programmer) wouldn't know the answer.    You can.  Today's lesson is how to use the random command.  If you plan on creating your own games or programs, this command is essential! 
       +
     + 
     1 Y   -You KNOW we're going to look at that script.    4on mouseUp -- when the user lets up on the mouse... 
 @       Blue    

     
 )   k   global highScore  -- call up the global variable "highScore" from RAM.  If one doesn't exist, make one! 
       
 @       Blue   
      W      if highScore = "" then put 100 into highScore -- if there's nothing in the global variable "highScore" then put 100 into it. 
       
 @       Blue   /
     1 N   G   put 9 into theNumber -- put 9 into a local variable named theNumber 
       
 @       Blue   
      .   F   answer "I'm going to ask you to choose a number between 1 and 20." 
       
 @       Blue   B   1   repeat with i = 1 to 100 -- begin repeat loop 
       
 @       Blue   
       \      ask "Enter guess number" && i & ":" -- use the variable i as a part of the ask dialog 
       
 @       Blue   #
     ) 2         if it > theNumber then answer "Lower." -- compare the user's guess with the real number (theNumber) and tell them if they are too high. 
       
 @       Blue   '
     , a         if it < theNumber then answer "Higher." -- compare the user's guess with the real number (theNumber) and tell them if they are too low. 
       
 @       Blue   *
     - `   I      if it = theNumber then -- if they guessed the right number then... 
       
 @       Blue   
      , _         put i into finalScore -- put whatever value "i " has into a variable named finalScore 
       
 @       Blue   
      @ 3         exit repeat -- get out of the repeat loop 
       
 @       Blue   
       -      end if -- end if the if/then statement 
       
 @       Blue   
          (   end repeat -- end of the repeat loop 
       
 @       Blue   

         r   answer "It took you" && finalScore && "tries." -- use finalScore to tell the user how many tries it took them. 
       
 @       Blue   /
     1 @   R   if finalScore <  highScore then -- if their score beats the high score then... 
       
 @       Blue   !
     " /   ?      answer "You beat the high score!" -- tell them they won! 
       
 @       Blue   #
     '    Q      put i into highScore -- put their score into the global variable highScore 
       
 @       Blue   
      5   *   end if -- end of the if/then structure 
       
 @       Blue   
     	     end mouseUp -- end of script. 
 @       Blue    
               ;OK... big project here.  We're doing something cool today.    We're making a guessing game, where the player has to guess a number, and the computer will tell them "higher" or "lower"... and the computer will tell the user how many guesses it took them...   AND the computer will keep a high score!  Well, at least until you quit out of the program.    Good work!  Obviously the game wasn't very challenging for you, because (being the programmer) you knew the answer - car.  It has 5 wheels... 4 tires and a steering wheel.  Get it?  Ha ha ha... anyway, let's look at the repeat loop in the script...    on mouseUp 
       
 %   answer "This is a guessing game!" 
       $ D   answer "You're going to have to guess the word I'm thinking of." 
       C -   answer "Here's a hint.  It has 5 wheels." 
       ,  
         Y   repeat -- begin loop.  Since we're not saying how many times, it will repeat FOREVER! 
       
 @       Blue   
     	 O 4      ask "What is it?" -- you know what this does. 
       
 @       Blue   
       4      if it = "car" then -- begin if/then structure 
       
 @       Blue   
       9         answer "You win!" -- you know, dialog box, etc. 
       	
 @       Blue  	 
       Q         exit repeat -- this gets you out of the infinite (meaning forever) loop 
       	
 @       Blue  	 
      < :      else  -- in other words, if it does NOT equal "car" 
       
 @       Blue   3 L         answer "Nope.  Try again."  -- dialog box with "Nope.  Try again." 
       	
 @       Blue  	 B .      end if  -- end of the if/then structure 
       
 @       Blue   ' .   end repeat  -- end of the repeat structure 
       
 @       Blue   *  
         end mouseUp 
          Now, obviously you don't want to put your users into an infinite loop like this one, do you?  Do you?  Shame on you if you do.      We're making a game today called "End of the Road".  We'll be using a lot of things we've already learned and combining them.          Let's look at the script:    on mouseUp  z   repeat with i = 1 to 10 -- (creates a variable named "i" and automatically uses it to count from 1 to 10.  Cool, huh?) 
       
 @       Blue   
      _   X      answer i -- brings up the answer dialog box with whatever value "i" currently has 
       
 @       Blue   
      I   9   end repeat -- end of list of jobs for the repeat loop 
       
 @       Blue   

     
 + end mouseUp    2Let's analyze the repeat loop of the last script: 
 @        Black    1  
 @       Blue      on mouseUp  
 @       Blue      
 @       Blue      0   repeat for 20 times -- do this loop 20 times 
 @       Blue    / ^      subtract 1 from field "energy" -- take 1 away from whatever number is in field "energy" 
 @       Blue    ] g      if field "energy" = 5 then -- if the number 5 is in field "energy" then do these instructions... 
 @       Blue    !
 @        Black  ! E H         subtract 5 from field "food"  -- take 1 away from field "food" 
 @       Blue    '
 @        Black  '   <         add 5 to field "energy" -- add 5 to field "energy" 
 @       Blue    !
 @        Black  !  C      end if  -- end of list of instructions for if/then structure 
 @       Blue    

 @        Black  
 5 >   end repeat  -- end of list of instructions for repeat loop 
 @       Blue    
 @        Black   .  
 @       Blue      end mouseUp 
 @       Blue      
 @       Blue      When you put two minus signs ( -- ) after a line of script, you are said to be commenting it... which means, you're making a comment about what the line does.   
 @        Black       VIn Lesson 12, you learned how to make a repeat structure which executed two commands: 
       (
     ( 
     8    add 1 to ct 
 @       Blue     put ct into field "storage" 
 @       Blue       Since a repeat loop is a structure (just like if/then), it has a beginning (repeat) and and ending (end repeat).  You can put as many lines of instructions in between as you want to.    CIn today's lesson, we put information into four different fields.     =Good work!  Let's look at one of the lines from that script: 
 @        Black    <  
 @       Blue      '   put the long seconds into startTime 
 @       Blue    &  
 @       Blue      The "long seconds" is an interesting function... it gives you the exact time down to 1/100 of a second!  Very cool for timing races. 
 @        Black      
 @        Black      So what would happen if you took out the word "long" and asked for just the "seconds"?  It would tell you the time down to the nearest minute. 
 @        Black      
 @        Black      >MetaTalk can add and subtract time much easier than we can.   
 @        Black    =   $Let's have a look at that script...    ;on mouseUp -- when the user lets up on the mouse button... 
 @       Blue    
 @        Black   /  
 @       Blue      D   put 0 into ct -- put the number "zero" into a variable named ct. 
 @       Blue    
 @        Black   2 S(Note that since we didn't state that it was global, it must be a local variable). 
 @        Black    R  
 @       Blue      B   repeat for 100 times -- begin a repeat loop.  Do it 100 times. 
 @       Blue    A C      add 1 to ct -- add 1 to the number stored in the variable ct 
 @       Blue    B ^      put ct into field "storage" -- put whatever number is stored in ct into field "storage" 
 @       Blue    "
 @        Black  " ; 0   end repeat -- end of the repeat instructions 
 @       Blue    

 @       Blue    
 "  
 @       Blue      !end mouseUp -- end of the script 
 @       Blue    
 @        Black        Today's lesson ought to be fun... you're going to challenge the person sitting next to you to a race.  And if you aren't sitting next to anyone, you're going to race all by yourself.    YBefore you get up and stretch, don't.  It's your computer that's going to race, not you.    Today you're going to learn a couple of things.  We're going to learn about repeat structures, and we're going to learn another function called the seconds. 
       L
     L 
     ] ?  i A field is an object that you can place anywhere on the screen.  Some people call it a text field, meaning you can put text into it (text being, of course, words).  Here is an example of a field:                      @You can name a field anything you want, just like a variable.       f You'll done well to make it this far.  Today we discuss two objects which you will need to create ANY program in MetaTalk... buttons and fields.    A button is an object that can be placed on the screen anywhere you like.  It looks like a button, but you can also make it invisible.  Here's what a button looks like:              You can attach a script (yes, like the ones you've been writing) to a button.  When you click on the button, you activate the script.   ? You are now halfway through the program.  At this point you should be able to use ask and answer commands easily, as well as construct if/then structures.   
       '
     ' +
     R 
     U 
     Z 
     ` '
      
        ,You're hopefully beginning to see that programming a computer using MetaTalk is fairly straightforward.  The pieces you've seen so far may seem small, but to create ANY kind of computer program (word processor, arcade-style game, role playing game, etc.) you will need these basic building blocks.      Everything in life that is large and worthwhile is made from smaller pieces.  Great works of literature use small words like "the", and "for".  Small pieces put together to make something great.    XImagine how boring William Shakespear would have been if he hadn't had the word "thou".   =If you have not been going to the Scripter's Sketchpad at the end of each lesson, you should start going there.  This software can teach you the basics of programming, but if you actually want to be good at it, you're going to have to spend some time playing around on the sketchpad.    
Why program?  01.  To earn a great living doing something fun.  52.  To be able to make the computer do work for you.  23.  To be able to create great programs or games.  \4.  Because we live in the information age.  Those who can program will have the advantage.   , Look at the structure:    on mouseUp  6   answer "Choose door 1, or door 2?" with "1" or "2"     if it is "1" then 
       
 @       Blue    #      answer "You found the exit!" 
 @       Blue    "    else 
 @       Blue     -      answer "You fall into a pit.  Bummer." 
 @       Blue    , 
   end if 
 @       Blue    	 end mouseUp    If the variable "it" is equal to 1, then it does the exit line.  The word "else" in line 5 means "or else, if the first statement wasn't true, then do something else".    -This is a good way to write shorter scripts.    Let's try another one...   * Today's lesson will finish our discussion of the if/then structure. In Lesson 8, we learned that the if/then structure is a foundation which can determine several paths for a script to follow.  Today we make it even more complicated. 
       1
     1 
     B #
     e 
     v s   Look at this script:    on mouseUp  +   answer "Choose a door:" with "1" or "2"     if it = 1 then        answer "Endless pit."  
   end if       if it = 2 then        answer "Exit.  You win!"  
   end if  end mouseUp    zSee how each if/then structure contains one line?  Actually, we can make this script smaller by adding the word "else"...    8Let's look at just the if/then structure of the script:    on mouseUp  5   answer "Enter door 1, or door 2?" with "1" or "2"       if it is "1" then 
       
 @       Blue    /      answer "You are attacked by a gorrilla." 
 @       Blue    . 5      answer "You survive, but you fall into a pit." 
 @       Blue    4 /      answer "You live, but a tiger eats you." 
 @       Blue    . 
   end if 
 @       Blue    	   end mouseUp    Notice the script will do 3 lines (all 3 are answer commands) if "it" is the number 1.  You can make the list of commands in an if/then structure as long or as short as you wish.    :Today we will look more closely at the if/then structure. 
       '
     ' 
     8    Why is "if/then" called a structure?  Because you can build on it, that's why.  In Lesson 7 we looked at "if/then" statements that were 1 line long.  Today we add to the structure to build something more complex.    Let's look at the script...    ;on mouseUp -- when the user lets up on the mouse button... 
 @       Blue    

     
 0   L   global studentName -- get the global variable named studentName from RAM 
       
 @       Blue   
      6   Z   ask "What is your name?" -- bring up the "ask" dialog box.  Put the response into "it" 
       
 @       Blue   
      >      if it = studentName then answer "You're right." -- if the name in "it" is the same as the name in studentName, then bring up the answer dialog box with "You're right". 
       
 @       Blue   /
     2 x      if it <> studentName then answer "No it isn't. It's" && studentName & "."-- if the name in "it" is NOT the same as the name in studentName, then bring up the answer dialog box with "No it isn't. It's" ... and then attach the variable studentName 
       
 @       Blue   J
     L     end mouseUp 
 @       Blue       Today we look at our first structure... the if/then structure.  We use the if/then structure in real life every day.  For example, consider the following: 
       
      	
     $ 
     , 
     = 
     K 
     \ >   .If you study hard then you can go to college.    ,If you rob a bank then you will go to jail.    EIf you eat a whole gallon of ice cream then you will have diarrehea.        Let's look at the script...    ;on mouseUp -- when the user lets up on the mouse button... 
 @       Blue    

     
 0   T   answer "You've clicked on a box.  It's ticking." with "Open it!" or "Run Away!"  
       
 @       Blue   P (This brings up an answer dialog box, and presents the user with two choices.  The user clicks on one of the two buttons, and the name of the choice is placed into the variable "it".)    =   answer "You chose" && it -- brings up a dialog answer box 
       
 @       Blue   
      !   end mouseUp 
 @       Blue      
 @       Blue      =While very simple, the "answer with" command is very useful. 
 @        Black    <  
Did you notice that the second choice ("Run Away!") had a different looking button?  You could simply press the Return key to choose it.  This is called the default response.  When you use the answer command and you list choices using with, the last choice is default. 
       
      
      $
      
        +In this lesson, you'll learn to use the answer command to give users a choice of input.  If you were programming a game, you'd want to know how to use this command.  For example, pretend someone clicks on a box in your game, and you want to give them a choice... open the box, or drop it and run.   
       (
     ( 
     .    The next screen shows you how.    Great work!  I'll bet you're wondering about lines 6 and 9.  Here's the script breakdown.  You don't HAVE to look at what each line does, but a serious student of programming would want to know!  Click OK when you've finished. 
       
      Z
     e 
     i y  
         ;on mouseUp -- when the user lets up on the mouse button... 
 @       Blue    

     
 0   
        N   answer "Welcome to the Wacky Calculator!" -- bring up an answer dialog box 
 @       Blue    ,
     , !    
        d   ask "What is your name?" -- bring up the ask dialog box, put the response into the variable "it" 
 @       Blue    
      H    
        T   answer "Good to meet you," && it & "." -- use answer and the variable named "it" 
 @       Blue    )
     ) *    
        b   ask "Give me a number:" -- bring up an ask dialog box, put the response into the variable "it" 
 @       Blue    
      G   
        R   put it into num -- put the variable "it" into a different variable named "num" 
 @       Blue    
      ?   
        o   if it is not a number then exit to MetaCard -- if the variable "it" is not a number then the script is over 
 @       Blue    .
     . @     
       
 @       Blue    h   ask "Give me another number:" -- bring up an ask dialog box, put the response into the variable "it" 
 @       Blue     
       G  
         T   put it into num2 -- put the variable "it" into a different variable named "num2" 
       
 @       Blue   
      @  
         o   if it is not a number then exit to MetaCard -- if the variable "it" is not a number then the script is over 
       
 @       Blue   *
     . @   
        `   answer num + num2 -- bring up an answer dialog box, with variable "num" plus variable "num2" 
 @       Blue    
      K  
         =   answer "Aren't I smart?" -- bring up an answer dialog box 
       
 @       Blue   
      !  
 @       Blue      end mouseUp -- end of script 
 @       Blue    
         It's time for a review.  We've covered 2 commands (ask and answer), 2 functions (date and time), and 2 kinds of variables (local and global).  Today we combine them into our first Mini-Program... "Wacky Calculator"! 
       3
     3 
     6 
     ; 
     A 
     Q 
     U 
     Z 
     ^ 
     { 
      
      
      L   zOn the next screen you'll see a script to type for the Wacky Calculator.  You'll need to type it exactly as you see it.      EYou see?  The global variable was remembered, and the local was not. 
       
      
      '   Let's analyze the script:    5on mouseUp -- when you let up on the mouse button... 
 @       Blue    

     
 * T   global faveFood -- tell the computer to get the global variable named "faveFood" 
       
 @       Blue   
      @ I   ask "What is your favorite food?" -- bring up the "ask" dialog box... 
       
 @       Blue   !
     $ $ `   put it into faveFood -- put whatever the user types (it) into the global variable "faveFood" 
       
 @       Blue   
      H J   ask "What is your favorite drink?" -- bring up the "ask" dialog box... 
       
 @       Blue   #
     % $ `   put it into faveDrink -- put whatever the user types into a local variable named "faveDrink" 
       
 @       Blue   
      F end mouseUp 
 @       Blue       When the script is finished, the local variable (faveDrink) is dumped out of RAM, but the global variable (faveFood) is remembered! 
       !
     ! 
     / +
     Z 
     i          &Let's look at the script you typed... 
       %  
         4on mouseUp -- when the mouse button is let up on... 
 @       Blue    

     
 )  
         Z   global studentName -- tell the computer to get the global variable named "studentName" 
       
 @       Blue   
      D  
         T   answer item 1 of studentName -- bring up a box with whatever is in "studentName" 
       
 @       Blue   
      4  
         end mouseUp -- end the script 
 @       Blue    
        
        ?By using the word "global" (in line 2) to describe the variable named "studentName", we are declaring it to be global.  If the program already has a global variable in RAM named "studentName", we can get whatever is stored there.  When you logged on, your name was loaded into the global variable named "studentName"!  
      
     
    (   
         Notice that the variable is named something that makes sense... "studentName" basically tells me what's in it.  DON'T name your variables something general like "stuff"... when you have problems it will make things harder.   
       
      
      h
      	
      W  
        You know when you clean your room (once a year) and you shove stuff into boxes?  Well you can find stuff quicker if you label your boxes with words that make sense, like "Comic Books" or "Old Barbies That Will Be Worth Money Someday".  Same with variables.  Use common sense. 
       
      	
         Know anyone like Billy?    In Lesson 3, we learned about variables.  The kind of variable discussed in Lesson 3 is a local variable, because it is local to a script... meaning the second the script is over, the variable is erased from RAM.   
       
      	
     ' 
     6 
     > 
     Z 
     h n   That stinks if you want to make a game which remembers things (like the player's name!).  But MetaCard has another kind of variable... the kind that doesn't get erased when the script is through... the global variable! 
       {
     { 
      G
      
         fGlobal variables are stored in RAM as long as the program is running.  They are there until you quit. 
       
      U   %Human beings have 2 kinds of memory:  EShort Term Memory - Stuff you remember temporarily and forget later. 
       
      3 7Long Term Memory - Stuff you remember for a long time. 
       
      &   Computers have memory also:  GRAM - Random Access Memory - Stuff the computer remembers temporarily. 
       
      C eStorage Memory - Stuff the computer remembers after you turn it off - usually saved on a hard drive. 
       
      V   KIn this lesson you'll learn how to put something into your computer's RAM.   
 )What about the second line?  Look again:    on mouseUp 
 @       Blue    
    ask "Does this work?" 
 @       Blue    
 @       Blue    on mouseUp 
 @       Blue    
  The second line issues a command to the computer.  The ask command brings up a dialog box where users can type a response.  The ask command can be a very powerful tool.  Click the "Demonstrate" button below to see another example of the ask command.  Click "OK" when you're finished. 
       
      
       
     7 
     : F
      
      j
      
      +   Great!  You've just written your first computer program.  OK, so it's not such a cool program, and all you did was type 3 lines.  Let's look at the 3 lines again: 
       
      |
          on mouseUp 
 @       Blue    
    ask "Does this work?" 
 @       Blue     end mouseUp 
 @       Blue       The first line and the third line tell the computer when to start following directions and when to stop.  "on mouseUp" is called a handler, because it handles the process of telling the computer what to do! 
       4
     4 "
     V -
      
      D   Click OK to continue...        	`    @ C ! F   , OK Ew 'on mouseUp
  go next card
end mouseUp
       l T   Go to the next screen          	       a 
Main Menu E   .on mouseUp
  go card "Main Menu"
end mouseUp
      p X  Go to the Main Menu screen          	       w 	previous Sw +on mouseUp
  go previous card
end mouseUp
      p 8  Go to the previous screen             @             	       ~ next Cw 'on mouseUp
  go next card
end mouseUp
      p 8  Go to the next screen             A             	        	notebook   i           X
  s   	h           P t         So there's a cool use for the random command - having the computer decide a course of action based on a random number.  No one knows what number the computer will choose - you set the upper limit. 
       
      
     $    /No new terms have been added to your notebook.    Very good.  You should feel pretty comfortable with the basic scripting and syntax at this point.  In this lesson we added two new commands:    'hide - hides a field, button, or image 
       
      " 'show - shows a field, button, or image 
       
      "  q So there you have it... the random command is very useful in making your games play differently each time.  We'll add the definition to your notebook:    srandom(theNumber) - makes the computer choose a number between 1 and whatever number you place in the parenthesis.    You've learned quite a bit about repeat loops in the past few lessons.  Lesson 15 is a big Mini-Program, and the repeat structure will be used heavily.    +exit repeat - leaves a current repeat loop 
       
         This lesson discussed how to put an if/then structure within a repeat loop.  In the next lesson we'll discuss how to set up more powerful repeat loops.    lrepeat with (structure) - a repeat loop that automatically uses a variable (usually a letter) as a counter. 
       
      T   ^Today you learned to write a basic repeat loop.  We add the repeat structure to our notebook:    rrepeat (structure) - a structure which enables the program to repeat one section for a specified number of times. 
       
      _   aAs you can see, fields are pretty neat.  We can add the definition of a "field" to our notebook.     Mfield - a container which can be seen on screen, and which can contain text. 
       
      G  / In today's lesson you learned to add else to your if/then structure.  The next lesson marks the halfway point of this program!  You'll be working on a big project for Lesson 10, so plan on spending plenty of time on it! 
       %
     % 
     ) 	
     2 
     C    if/then/else (structure) - an if/then statement where you test to see if a statement is true... if it isn't, you do something else.  
       
      l   gSo now you're an if/then expert.  Not quite.  There's one more piece.  But that's for the next lesson.    KToday's lesson adds nothing new to your notebook.  Tomorrow's lesson will.   	 XToday you learned the simplest form of the if/then structure.  It consists of one line: 
       ,
     , 
     <    0if it = studentName then answer "You're right!"    lif/then (structure) - a structure which allows a program to go do different things  based on user response. 
       
      X   In this lesson, you learned how to use the answer with command, which will lead us very nicely into our next lesson, the if/then structure.  The answer with command has been added to your notebook. 
       +
     + 
     6 C
     y 
      
      
      )   aanswer with (command) - brings up an answer dialog box with a choice of more than one responses. 
       
      
      	
      K   You know this screen, don't you?  It means you're done with the basic lesson.  But you can always do the Extension and then play with the Programmer's Sketchpad!  Today we learned:    Hlocal variable - a variable that is forgotten when a script is finished 
       
      9 Qglobal variable - a variable that is remembered until the program is quit out of 
       
      A :it - a variable containing the response from a dialog box 
       
      7   The only problem with variables like we used are that they're forgotten as soon as the script is over.  Kind of like an actor in a bad movie.  Anyway, Lesson 3 introduced some new things:    A& - The sign used to attach text phrases and variables together. 
       
      ? 1variable - a temporary container located in RAM. 
       
      (    w {Good job!  You're making progress quickly.  We're adding some new things to your notebook, which you can view at any time. 
       	
     	 q   5answer (command) - brings up a dialog box with text. 
       
      $ Jtime (function) - gives you the current time, according to your computer. 
       
      : Jdate (function) - gives you the current date, accorting to your computer. 
       
      :  Good job!  Now you're a computer programmer!  Well, not quite.  But you see how easy it is to learn MetaTalk.  We learned what a handler was, what a command was, what the ask command does, and what syntax is.  These terms have been added to your "notebook", as you can see below.  In future lessons, each term that you learn will be added to your notebook.  When you don't remember what a word means, you can use your notebook to look it up! 
       	
     	 %
     . 
     = D
      
      

      
      
      
      
      
      +
 @       Blue   
      
  t 	notebook  	`        Blue     P          Notebook for     Notebook for    q Notebook for     Notebook for     Notebook for     Notebook for     Notebook for    / Notebook for     Notebook for    	 Notebook for     Notebook for     Notebook for     Notebook for    w Notebook for     Notebook for  
  u Notebook display  	h          P          A& - The sign used to attach text phrases and variables together. 
       
      ?  
         5answer (command) - brings up a dialog box with text. 
       
      $   aanswer with (command) - brings up an answer dialog box with a choice of more than one responses. 
       
      
      	
      K  
         Oask (command) - Brings up a dialog box that allows users to input information. 
       

     
 A   Bcommand - an order that is given to a computer by the programmer. 
       
      :   Jdate (function) - gives you the current date, accorting to your computer. 
       
      :   +exit repeat - leaves a current repeat loop 
       
         Mfield - a container which can be seen on screen, and which can contain text. 
       
      G   Qglobal variable - a variable that is remembered until the program is quit out of 
       
      A   mhandler - a set of beginning and ending lines that tell MetaCard what to do when an action occurs.  Example: 
       
      e Jon mouseUp (when the user has clicked and then releases the mouse button)  end mouseUp    1hide (command) - hides a field, button, or image 
       
      !   lif/then (structure) - a structure which allows a program to go do different things  based on user response. 
       
      X   if/then/else (structure) - an if/then statement where you test to see if a statement is true... if it isn't, you do something else.  
       
      l   :it - a variable containing the response from a dialog box 
       
      7   Hlocal variable - a variable that is forgotten when a script is finished 
       
      9   rrepeat (structure) - a structure which enables the program to repeat one section for a specified number of times. 
       
      _   qrandom(theNumber) - a command that chooses  a number between 1 and whatever number you place in the parenthesis. 
       
      _   lrepeat with (structure) - a repeat loop that automatically uses a variable (usually a letter) as a counter. 
       
      T   2show (command) - shows a field, button, or image. 
       
      #   =syntax - The set of rules that a script must follow to work. 
       
      6   Jtime (function) - gives you the current time, according to your computer. 
       
      :   1variable - a temporary container located in RAM. 
       
      (   A& - The sign used to attach text phrases and variables together. 
       
      ?  
         5answer (command) - brings up a dialog box with text. 
       
      $   aanswer with (command) - brings up an answer dialog box with a choice of more than one responses. 
       
      
      	
      K  
         Oask (command) - Brings up a dialog box that allows users to input information. 
       

     
 A   Bcommand - an order that is given to a computer by the programmer. 
       
      :   Jdate (function) - gives you the current date, accorting to your computer. 
       
      :   +exit repeat - leaves a current repeat loop 
       
         Mfield - a container which can be seen on screen, and which can contain text. 
       
      G   Qglobal variable - a variable that is remembered until the program is quit out of 
       
      A   mhandler - a set of beginning and ending lines that tell MetaCard what to do when an action occurs.  Example: 
       
      e Jon mouseUp (when the user has clicked and then releases the mouse button)  end mouseUp    1hide (command) - hides a field, button, or image 
       
      !   lif/then (structure) - a structure which allows a program to go do different things  based on user response. 
       
      X   if/then/else (structure) - an if/then statement where you test to see if a statement is true... if it isn't, you do something else.  
       
      l   :it - a variable containing the response from a dialog box 
       
      7   Hlocal variable - a variable that is forgotten when a script is finished 
       
      9   rrepeat (structure) - a structure which enables the program to repeat one section for a specified number of times. 
       
      _   qrandom(theNumber) - a command that chooses  a number between 1 and whatever number you place in the parenthesis. 
       
      _   lrepeat with (structure) - a repeat loop that automatically uses a variable (usually a letter) as a counter. 
       
      T   2show (command) - shows a field, button, or image. 
       
      #   =syntax - The set of rules that a script must follow to work. 
       
      6   Jtime (function) - gives you the current time, according to your computer. 
       
      :   1variable - a temporary container located in RAM. 
       
      (  q A& - The sign used to attach text phrases and variables together. 
       
      ?  
         5answer (command) - brings up a dialog box with text. 
       
      $   aanswer with (command) - brings up an answer dialog box with a choice of more than one responses. 
       
      
      	
      K  
         Oask (command) - Brings up a dialog box that allows users to input information. 
       

     
 A   Bcommand - an order that is given to a computer by the programmer. 
       
      :   Jdate (function) - gives you the current date, accorting to your computer. 
       
      :   +exit repeat - leaves a current repeat loop 
       
         Mfield - a container which can be seen on screen, and which can contain text. 
       
      G   Qglobal variable - a variable that is remembered until the program is quit out of 
       
      A   mhandler - a set of beginning and ending lines that tell MetaCard what to do when an action occurs.  Example: 
       
      e Jon mouseUp (when the user has clicked and then releases the mouse button)  end mouseUp    lif/then (structure) - a structure which allows a program to go do different things  based on user response. 
       
      X   if/then/else (structure) - an if/then statement where you test to see if a statement is true... if it isn't, you do something else.  
       
      l   :it - a variable containing the response from a dialog box 
       
      7   Hlocal variable - a variable that is forgotten when a script is finished 
       
      9   rrepeat (structure) - a structure which enables the program to repeat one section for a specified number of times. 
       
      _   qrandom(theNumber) - a command that chooses  a number between 1 and whatever number you place in the parenthesis. 
       
      _   lrepeat with (structure) - a repeat loop that automatically uses a variable (usually a letter) as a counter. 
       
      T   =syntax - The set of rules that a script must follow to work. 
       
      6   Jtime (function) - gives you the current time, according to your computer. 
       
      :   1variable - a temporary container located in RAM. 
       
      (   A& - The sign used to attach text phrases and variables together. 
       
      ?  
         5answer (command) - brings up a dialog box with text. 
       
      $   aanswer with (command) - brings up an answer dialog box with a choice of more than one responses. 
       
      
      	
      K  
         Oask (command) - Brings up a dialog box that allows users to input information. 
       

     
 A   Bcommand - an order that is given to a computer by the programmer. 
       
      :   Jdate (function) - gives you the current date, accorting to your computer. 
       
      :   +exit repeat - leaves a current repeat loop 
       
         Mfield - a container which can be seen on screen, and which can contain text. 
       
      G   Qglobal variable - a variable that is remembered until the program is quit out of 
       
      A   mhandler - a set of beginning and ending lines that tell MetaCard what to do when an action occurs.  Example: 
       
      e Jon mouseUp (when the user has clicked and then releases the mouse button)  end mouseUp    lif/then (structure) - a structure which allows a program to go do different things  based on user response. 
       
      X   if/then/else (structure) - an if/then statement where you test to see if a statement is true... if it isn't, you do something else.  
       
      l   :it - a variable containing the response from a dialog box 
       
      7   Hlocal variable - a variable that is forgotten when a script is finished 
       
      9   rrepeat (structure) - a structure which enables the program to repeat one section for a specified number of times. 
       
      _   lrepeat with (structure) - a repeat loop that automatically uses a variable (usually a letter) as a counter. 
       
      T   =syntax - The set of rules that a script must follow to work. 
       
      6   Jtime (function) - gives you the current time, according to your computer. 
       
      :   1variable - a temporary container located in RAM. 
       
      (   A& - The sign used to attach text phrases and variables together. 
       
      ?  
         5answer (command) - brings up a dialog box with text. 
       
      $   aanswer with (command) - brings up an answer dialog box with a choice of more than one responses. 
       
      
      	
      K  
         Oask (command) - Brings up a dialog box that allows users to input information. 
       

     
 A   Bcommand - an order that is given to a computer by the programmer. 
       
      :   Jdate (function) - gives you the current date, accorting to your computer. 
       
      :   Mfield - a container which can be seen on screen, and which can contain text. 
       
      G   Qglobal variable - a variable that is remembered until the program is quit out of 
       
      A   mhandler - a set of beginning and ending lines that tell MetaCard what to do when an action occurs.  Example: 
       
      e Jon mouseUp (when the user has clicked and then releases the mouse button)  end mouseUp    lif/then (structure) - a structure which allows a program to go do different things  based on user response. 
       
      X   if/then/else (structure) - an if/then statement where you test to see if a statement is true... if it isn't, you do something else.  
       
      l   :it - a variable containing the response from a dialog box 
       
      7   Hlocal variable - a variable that is forgotten when a script is finished 
       
      9   rrepeat (structure) - a structure which enables the program to repeat one section for a specified number of times. 
       
      _   lrepeat with (structure) - a repeat loop that automatically uses a variable (usually a letter) as a counter. 
       
      T   =syntax - The set of rules that a script must follow to work. 
       
      6   Jtime (function) - gives you the current time, according to your computer. 
       
      :   1variable - a temporary container located in RAM. 
       
      (   A& - The sign used to attach text phrases and variables together. 
       
      ?  
         5answer (command) - brings up a dialog box with text. 
       
      $   aanswer with (command) - brings up an answer dialog box with a choice of more than one responses. 
       
      
      	
      K  
         Oask (command) - Brings up a dialog box that allows users to input information. 
       

     
 A   Bcommand - an order that is given to a computer by the programmer. 
       
      :   Jdate (function) - gives you the current date, accorting to your computer. 
       
      :   Mfield - a container which can be seen on screen, and which can contain text. 
       
      G   Qglobal variable - a variable that is remembered until the program is quit out of 
       
      A   mhandler - a set of beginning and ending lines that tell MetaCard what to do when an action occurs.  Example: 
       
      e Jon mouseUp (when the user has clicked and then releases the mouse button)  end mouseUp    lif/then (structure) - a structure which allows a program to go do different things  based on user response. 
       
      X   if/then/else (structure) - an if/then statement where you test to see if a statement is true... if it isn't, you do something else.  
       
      l   :it - a variable containing the response from a dialog box 
       
      7   Hlocal variable - a variable that is forgotten when a script is finished 
       
      9   rrepeat (structure) - a structure which enables the program to repeat one section for a specified number of times. 
       
      _   =syntax - The set of rules that a script must follow to work. 
       
      6   Jtime (function) - gives you the current time, according to your computer. 
       
      :   1variable - a temporary container located in RAM. 
       
      (   A& - The sign used to attach text phrases and variables together. 
       
      ?  
         5answer (command) - brings up a dialog box with text. 
       
      $   aanswer with (command) - brings up an answer dialog box with a choice of more than one responses. 
       
      
      	
      K  
         Oask (command) - Brings up a dialog box that allows users to input information. 
       

     
 A   Bcommand - an order that is given to a computer by the programmer. 
       
      :   Jdate (function) - gives you the current date, accorting to your computer. 
       
      :   Mfield - a container which can be seen on screen, and which can contain text. 
       
      G   Qglobal variable - a variable that is remembered until the program is quit out of 
       
      A   mhandler - a set of beginning and ending lines that tell MetaCard what to do when an action occurs.  Example: 
       
      e Jon mouseUp (when the user has clicked and then releases the mouse button)  end mouseUp    lif/then (structure) - a structure which allows a program to go do different things  based on user response. 
       
      X   if/then/else (structure) - an if/then statement where you test to see if a statement is true... if it isn't, you do something else.  
       
      l   :it - a variable containing the response from a dialog box 
       
      7   Hlocal variable - a variable that is forgotten when a script is finished 
       
      9   =syntax - The set of rules that a script must follow to work. 
       
      6   Jtime (function) - gives you the current time, according to your computer. 
       
      :   1variable - a temporary container located in RAM. 
       
      (  / A& - The sign used to attach text phrases and variables together. 
       
      ?  
         5answer (command) - brings up a dialog box with text. 
       
      $   aanswer with (command) - brings up an answer dialog box with a choice of more than one responses. 
       
      
      	
      K  
         Oask (command) - Brings up a dialog box that allows users to input information. 
       

     
 A   Bcommand - an order that is given to a computer by the programmer. 
       
      :   Jdate (function) - gives you the current date, accorting to your computer. 
       
      :   Qglobal variable - a variable that is remembered until the program is quit out of 
       
      A   mhandler - a set of beginning and ending lines that tell MetaCard what to do when an action occurs.  Example: 
       
      e Jon mouseUp (when the user has clicked and then releases the mouse button)  end mouseUp    lif/then (structure) - a structure which allows a program to go do different things  based on user response. 
       
      X   if/then/else (structure) - an if/then statement where you test to see if a statement is true... if it isn't, you do something else.  
       
      l   :it - a variable containing the response from a dialog box 
       
      7   Hlocal variable - a variable that is forgotten when a script is finished 
       
      9   =syntax - The set of rules that a script must follow to work. 
       
      6   Jtime (function) - gives you the current time, according to your computer. 
       
      :   1variable - a temporary container located in RAM. 
       
      (   A& - The sign used to attach text phrases and variables together. 
       
      ?  
         5answer (command) - brings up a dialog box with text. 
       
      $   aanswer with (command) - brings up an answer dialog box with a choice of more than one responses. 
       
      
      	
      K  
         Oask (command) - Brings up a dialog box that allows users to input information. 
       

     
 A   Bcommand - an order that is given to a computer by the programmer. 
       
      :   Jdate (function) - gives you the current date, accorting to your computer. 
       
      :   Qglobal variable - a variable that is remembered until the program is quit out of 
       
      A   mhandler - a set of beginning and ending lines that tell MetaCard what to do when an action occurs.  Example: 
       
      e Jon mouseUp (when the user has clicked and then releases the mouse button)  end mouseUp    lif/then (structure) - a structure which allows a program to go do different things  based on user response. 
       
      X   :it - a variable containing the response from a dialog box 
       
      7   Hlocal variable - a variable that is forgotten when a script is finished 
       
      9   =syntax - The set of rules that a script must follow to work. 
       
      6   Jtime (function) - gives you the current time, according to your computer. 
       
      :   1variable - a temporary container located in RAM. 
       
      (  	 A& - The sign used to attach text phrases and variables together. 
       
      ?  
         5answer (command) - brings up a dialog box with text. 
       
      $   aanswer with (command) - brings up an answer dialog box with a choice of more than one responses. 
       
      
      	
      K  
         Oask (command) - Brings up a dialog box that allows users to input information. 
       

     
 A   Bcommand - an order that is given to a computer by the programmer. 
       
      :   Jdate (function) - gives you the current date, accorting to your computer. 
       
      :   Qglobal variable - a variable that is remembered until the program is quit out of 
       
      A   mhandler - a set of beginning and ending lines that tell MetaCard what to do when an action occurs.  Example: 
       
      e Jon mouseUp (when the user has clicked and then releases the mouse button)  end mouseUp    lif/then (structure) - a structure which allows a program to go do different things  based on user response. 
       
      X   :it - a variable containing the response from a dialog box 
       
      7   Hlocal variable - a variable that is forgotten when a script is finished 
       
      9   =syntax - The set of rules that a script must follow to work. 
       
      6   Jtime (function) - gives you the current time, according to your computer. 
       
      :   1variable - a temporary container located in RAM. 
       
      (   A& - The sign used to attach text phrases and variables together. 
       
      ?  
         5answer (command) - brings up a dialog box with text. 
       
      $   aanswer with (command) - brings up an answer dialog box with a choice of more than one responses. 
       
      
      	
      K  
         Oask (command) - Brings up a dialog box that allows users to input information. 
       

     
 A   Bcommand - an order that is given to a computer by the programmer. 
       
      :   Jdate (function) - gives you the current date, accorting to your computer. 
       
      :   Qglobal variable - a variable that is remembered until the program is quit out of 
       
      A   mhandler - a set of beginning and ending lines that tell MetaCard what to do when an action occurs.  Example: 
       
      e Jon mouseUp (when the user has clicked and then releases the mouse button)  end mouseUp    :it - a variable containing the response from a dialog box 
       
      7   Hlocal variable - a variable that is forgotten when a script is finished 
       
      9   =syntax - The set of rules that a script must follow to work. 
       
      6   Jtime (function) - gives you the current time, according to your computer. 
       
      :   1variable - a temporary container located in RAM. 
       
      (   A& - The sign used to attach text phrases and variables together. 
       
      ?  
         5answer (command) - brings up a dialog box with text. 
       
      $  
         Oask (command) - Brings up a dialog box that allows users to input information. 
       

     
 A   Bcommand - an order that is given to a computer by the programmer. 
       
      :   Jdate (function) - gives you the current date, accorting to your computer. 
       
      :   Qglobal variable - a variable that is remembered until the program is quit out of 
       
      A   mhandler - a set of beginning and ending lines that tell MetaCard what to do when an action occurs.  Example: 
       
      e Jon mouseUp (when the user has clicked and then releases the mouse button)  end mouseUp    :it - a variable containing the response from a dialog box 
       
      7   Hlocal variable - a variable that is forgotten when a script is finished 
       
      9   =syntax - The set of rules that a script must follow to work. 
       
      6   Jtime (function) - gives you the current time, according to your computer. 
       
      :   1variable - a temporary container located in RAM. 
       
      (   A& - The sign used to attach text phrases and variables together. 
       
      ?  
         5answer (command) - brings up a dialog box with text. 
       
      $  
         Oask (command) - Brings up a dialog box that allows users to input information. 
       

     
 A   Bcommand - an order that is given to a computer by the programmer. 
       
      :   Jdate (function) - gives you the current date, accorting to your computer. 
       
      :   mhandler - a set of beginning and ending lines that tell MetaCard what to do when an action occurs.  Example: 
       
      e Jon mouseUp (when the user has clicked and then releases the mouse button)  end mouseUp    =syntax - The set of rules that a script must follow to work. 
       
      6   Jtime (function) - gives you the current time, according to your computer. 
       
      :   1variable - a temporary container located in RAM. 
       
      (  w 5answer (command) - brings up a dialog box with text. 
       
      $  
         Oask (command) - Brings up a dialog box that allows users to input information. 
       

     
 A   Bcommand - an order that is given to a computer by the programmer. 
       
      :   Jdate (function) - gives you the current date, accorting to your computer. 
       
      :   mhandler - a set of beginning and ending lines that tell MetaCard what to do when an action occurs.  Example: 
       
      e Jon mouseUp (when the user has clicked and then releases the mouse button)  end mouseUp    =syntax - The set of rules that a script must follow to work. 
       
      6   Jtime (function) - gives you the current time, according to your computer. 
       
      :   Oask (command) - Brings up a dialog box that allows users to input information. 
       

     
 A   Bcommand - an order that is given to a computer by the programmer. 
       
      :   mhandler - a set of beginning and ending lines that tell MetaCard what to do when an action occurs.  Example: 
       
      e Jon mouseUp (when the user has clicked and then releases the mouse button)  end mouseUp    =syntax - The set of rules that a script must follow to work. 
       
      6      	`    @ C      v OK Ew 'on mouseUp
  go next card
end mouseUp
       l T   Go to the next screen          	     
     	`        P          Lesson 18 - Notebook    Lesson 17 - Notebook   q Lesson 16 - Notebook    Lesson 14 - Summary    Lesson 13 - Summary    Lesson 12 - Summary    Lesson 11 - Summary   / Lesson 9 - Summary     Lesson 8 - Summary    	 Lesson 7 - Summary     Lesson 6 - Summary     Lesson 4 - Summary      Lesson 3 - Summary     w Lesson 2 - Summary     Lesson 1 - Summary   z 	previous Sw +on mouseUp
  go previous card
end mouseUp
      p 8  Go to the previous screen             @             	        next Cw 'on mouseUp
  go next card
end mouseUp
      p 8  Go to the next screen             A             	        
Main Menu E   .on mouseUp
  go card "Main Menu"
end mouseUp
      p X  Go to the Main Menu          	       ) Print EwVon mouseUp
  answer "Print notebook?" with "Yes" or "No"
  if it is "No" then exit to MetaCard
  put field "notebook" into line 1 of pageOne
  repeat with i = 1 to 20
    put return & line i of field "notebook display" after pageOne
  end repeat
  
  if the number of lines of field "notebook display" > 20 then
    put 1 into flag
    put "PAGE 2" into line 1 of pageTwo
    put field "notebook" & return & " " into line 3 of pageTwo
    repeat with i = 21 to the number of lines of field "notebook display"
      put return & line i of field "notebook display" after pageTwo
    end repeat
  end if
  --
  put "" into field "notebook display" of card 1 of stack "Print Notebook"
  put "" into field "notebook display" of card 2 of stack "Print Notebook"
  put pageOne into field "notebook display" of card 1 of stack "Print Notebook"
  put pageTwo into field "notebook display" of card 2 of stack "Print Notebook"
  go stack "Print Notebook"
  go card 1
  if flag = 1 then
    print this stack
  else
    print card 1
  end if
  answer "Print job sent to printer"
  close stack "Print Notebook"
end mouseUp
      (l X   Print notebook          	        empty   i       `  5 gray bg.jpg  	@          X  JFIF  H H              	
       	
   } !1AQa"q2#BR$3br	
%&'()*456789:CDEFGHIJSTUVWXYZcdefghijstuvwxyz  w !1AQaq"2B	#3Rbr
$4%&'()*56789:CDEFGHIJSTUVWXYZcdefghijstuvwxyz X!    ? bKclͽlT+,me7vm<e4(-ɴ@Q<B!,U +@o)go<S4FҤyرO(|4cvsiW"Iܻ\ۮ 2(:@k:P ͞jQ^iGY7jC~_2S1p4SVAoXQ,mn>[cd|"'\c
HsjW	,
DдђȾR
<rv34csuv/G2W-s,6O	GTm $;x>F\MȑYo/#|k*&\3ArHD	ދ$*9IP~B{M=;Im*A$8ܡcM0x
JMi76E{}r-˽ͺ2	".		$z_}t?{<'%?zMW
@<5j$-庖>	v@W2.pʰv1[:pФMOm, W*h1H>jG<WbH4s Kr:BnyF 	"KclͽlT+,me7vm<e4(-ɴ@Q<B!,U +@o)go<S4FҤyرO(|4cvsiW"Iܻ\ۮ 2(:@k:P ͞jQ^iGY7jC~_2S1p4SVAoXQ,mn>[cd|"'\c
HsjW	,
DдђȾR
<rv34csuv/G2W-s,6O	GTm $;x>F\MȑYo/#|k*&\3ArHD	ދ$*9IP~B{M=;Im*A$8ܡcM0x
JMi76E{}r-˽ͺ2	".		$z_}t?{<'%?zMW
@<5j$-庖>	v@W2.pʰv1[:pФMOm, W*h1H>jG<WbH4s Kr:BnyF 	"KclͽlT+,me7vm<e4(-ɴ@Q<B!,U +@o)go<S4FҤyرO(|4cvsiW"Iܻ\ۮ 2(:@k:P ͞jQ^iGY7jC~_2S1p4SVAoXQ,mn>[cd|"'\c
HsjW	,
DдђȾR
<rv34csuv/G2W-s,6O	GTm $;x>F\MȑYo/#|k*&\3ArHD	ދ$*9IP~B{M=;Im*A$8ܡcM0x
JMi76E{}r-˽ͺ2	".		$z_}t?{<'%?zMW
@<5j$-庖>	v@W2.pʰv1[:pФMOm, W*h1H>jG<WbH4s Kr:BnyF 	"KclͽlT+,me7vm<e4(-ɴ@Q<B!,U +@o)go<S4FҤyرO(|4cvsiW"Iܻ\ۮ 2(:@k:P ͞jQ^iGY7jC~_2S1p4SVAoXQ,mn>[cd|"'\c
HsjW	,
DдђȾR
<rv34csuv/G2W-s,6O	GTm $;x>F\MȑYo/#|k*&\3ArHD	ދ$*9IP~B{M=;Im*A$8ܡcM0x
JMi76E{}r-˽ͺ2	".		$z_}t?{<'%?zMW
@<5j$-庖>	v@W2.pʰv1[:pФMOm, W*h1H>jG<WbH4s Kr:BnyF 	"KclͽlT+,me7vm<e4(-ɴ@Q<B!,U +@o)go<S4FҤyرO(|4cvsiW"Iܻ\ۮ 2(:@k:P ͞jQ^iGY7jC~_2S1p4SVAoXQ,mn>[cd|"'\c
HsjW	,
DдђȾR
<rv34csuv/G2W-s,6O	GTm $;x>F\MȑYo/#|k*&\3ArHD	ދ$*9IP~B{M=;Im*A$8ܡcM0x
JG| k] gEp5i>%#9v{8( X9T.#٥7Tda@H6nS| 6TM&Oҭ`$xZ[XTdܱF҆@s!RoLD:˙IFP5Ŀ?G$Aȩ\yPgj[.`F,A2;-O>pF*<rvR/쉢j,F&!}(3ܐFV(|H1;s&8pV9`	 1\
ZOh.	m]
02pU*zj6i~ M6%mm
,
 IX5I9Ve17,k(Tnl_!fQ:lü>f2RQ)e 
xs441/8QIl*e|T>Yڲ{˘e/LqϜ3<3"\T"hnofdڲ!ɃH_f4$.}5ѷ'%*(C@N剎231;XHWVB[r3gc211J;
_ uMI[yl4fme0*e@$l*
RGyYeLpmFMm(d
0>w2*ۛ*xW&YN#.p*ϙ`Y@-^=/,KNyD+<_5ǕvŲk"KS#m$j"Cȡ'i "Ț+Y6mmr`Rٹ";_`tm/n%kIbʊ4P9bc'Nc դЖ܌ Lm`~ERf SiVa9 M ٻYL1ʪP	4-?JTeinYaSQrƹJ̅Jʿ I2e˜;ʪ/sc.e%"Pq@׏ln3K#CSt"WqC坫+ǱlHR@y<3;ȫ(EHH&fM,q\>TnH@rB W#]{KۉZxRX :TX,	3X$`p5i>%#9v{8( X9T.#٥7Tda@H6nS| 6TM&Oҭ`$xZ[XTdܱF҆@s!RoLD:˙IFP5Ŀ?G$Aȩ\yPgj[.`F,A2;-O>pF*<rvR/쉢j,F&!}(3ܐFV(|H1;s&8pV9`	 1\
ZOh.	m]
02pU*zj6i~ M6%mm
,
 IX5I9Ve17,k(Tnl_!fQ:lü>f2RQ)e 
xs441/8QIl*e|T>Yڲ{˘e/LqϜ3<3"\T"hnofdڲ!ɃH_f4$.}5ѷ'%*(C@N剎231;XHWVB[r3gc211J;
_ uMI[yl4fme0*e@$l*
RGyYeLpmFMm(d
0>w2*ۛ*xW&YN#.p*ϙ`Y@-^=/,KNyD+<_5ǕvŲk"KS#m$j"Cȡ'i "Ț+Y6mmr`Rٹ";_`tm/n%kIbʊ4P9bc'Nc դЖ܌ Lm`~ERf SiVa9 M ٻYL1ʪP	4-?JTeinYaSQrƹJ̅Jʿ I2e˜;ʪ/sc.e%"Pq@׏ln3K#CSt"WqC坫+ǱlHR@y<3;ȫ(EHH&fM,q\>TnH@rB W#]{KۉZxRX :TX,	3X$`p5i>%#9v{8( X9T.#٥7Tda@H6nS| 6TM&Oҭ`$xZ[XTdܱF҆@s!RoLD:˙IFP5Ŀ?G$Aȩ\yPgj[.`F,A2;-O>pF*<rvR/쉢j,F&!}(3ܐFV(|H1;s&8pV9`	 1\
ZOh.	m]
02pU*zj6i~ M6%mm
,
 IX5I9Ve17,k(Tnk?o  t XYG*Cĳ#+ݾgp$<ɰFokrQ.nPULƿ1Pqض0>U# n	Q"kHSo`>pP+6n#$ia_]1ݧuiH ,˰C)\w.ޓpN/~i$6eabr
dGϧG,r1GK.7cF|1Hn ox&VӭY$h-e|*A_@K.+P{KqgKy7XMw6U7F #o Ab1e(#v
38&1L1Dht3$Z|QAU2AbT R&MGTݭ"M2[}BDQ3Je]}vB|vQ [#.=rvJ szM::uɤ O,@ٕb>%ʾd5a>Ð_,o"RA#TQ lMZNdiةe~겆,}AK,v-ş-bUa5TvtCN m(Ŕr>lK<;p7C̛Pm0%͡ ̑iF/T,kcR0JP5R+vE6SP	m	mFb2@Y*ݖv۹	}GPpfo2ۇy(7b&<CfVؖ**Mz|tr OC~[Ĳ_/pI<gQF m6ek]:5I"ڦWb,ķ~qUseQq8dj6(Qʐ,JB7o#;C2l!CܔK6@2ES,Tv-H+ۭBduH)9OC %$J͵c1dvZuWn'wiAR b23W'n7>_B	
X~,#bXCY6<9Q oˆ|
%$R5E/	thI& j_-pFW(`PˊĲoYRM%V]͕GgM;om XYG*Cĳ#+ݾgp$<ɰFokrQ.nPULƿ1Pqض0>U# n	Q"kHSo`>pP+6n#$ia_]1ݧuiH ,˰C)\w.ޓpN/~i$6eabr
dGϧG,r1GK.7cF|1Hn ox&VӭY$h-e|*A_@K.+P{KqgKy7XMw6U7F #o Ab1e(#v
38&1L1Dht3$Z|QAU2AbT R&MGTݭ"M2[}BDQ3Je]}vB|vQ [#.=rvJ szM::uɤ O,@ٕb>%ʾd5a>Ð_,o"RA#TQ lMZNdiةe~겆,}AK,v-ş-bUa5TvtCN m(Ŕr>lK<;p7C̛Pm0%͡ ̑iF/T,kcR0JP5R+vE6SP	m	mFb2@Y*ݖv۹	}GPpfo2ۇy(7b&<CfVؖ**Mz|tr OC~[Ĳ_/pI<gQF m6ek]:5I"ڦWb,ķ~qUseQq8dj6(Qʐ,JB7o#;C2l!CܔK6@2ES,Tv-H+ۭBduH)9OC %$J͵c1dvZuWn'wiAR b23W'n7>_B	
X~,#bXCY6<9Q oˆ|
%$R5E/	thI& j_-pFW(`PˊĲoYRM%V]͕GgM;om XYG*Cĳ#+ݾgp$<ɰFokrQ.nPULƿ1Pqض0>U# n	Q"kHSo`>pP+6n#$ia_]1ݧuiH ,˰C)\w.ޓpN/~i$6eabr
dGϧG,r1GK.7cF|1Hn ox&VӭY$h-e|*A_@K.+P{KqgKy7XMw6U7F #o Ab1e(#v
38&1L1Dht3$Z|QAU2AbT R&MGTݭ"M2[}BDQ3J 	@ z Sokn/M,^<'bDQጂ^Q/丕v2J)9#
wyh1$(9`ی@5R-f:erfRnF,YrkE|0
qP3o/YԮ(dE"O@"]K"UMCP C{zp =čnJ誓&|1s%7VW^FyKFbD1[9/+*b hB=MٲHPۀ-?98y[]\<T nN$sE {[q|ig^-.;U&
wdXv~%ĬcVNqQoTS@	#Ad*Ak15++4t5`9b˕[XԪ+TFˍҁ}y~֚ΥwVC$p)Zz qOXmbjM?͵5Ӂn$hv*W7ET3s/^Qb4Z3|!n71yYVFcGgtBlV͒Bvp`m	}BMIb!|vrwf#B.` ۋK<r!iu	ت60TmCc ī5WK9.%cp#bzZ LIX6!P
TYY\$\ƥQ_6\nu+ⷊ#Hj}vĈSkT *imkq#GR*ɟ/@@dlczս%Rјcwqʲ3ŀ ;;opel;$Eo(ON'knheW2O#)+Ĩ0&Iw; _(Y3yKNUdjV%]_q+dSsFbHPr
jZu
J$49 gXV5*`tf^_ߵ]P,EEdSs6$DXڠSOmfMx@{[8݊U&L%$ccK׽nX)( c>s^VUņ,5Őf{{-dݷ%".[yB~rq8_PtC-⹒yHA_.%Dݜř2H琋 6DZ]Bv*$MP**
UKXc$"㘢0ިwG
TU cjVW&i%)k<rŗ*TW 65J8HdR, +%ڟk"%T> 
k47kǧHTn2g-P#2^uouziIGf(Cnb򲬌,1`&,+3=l$	.rǚo̓JB
q*&,	G<]&x/BUY"l`ڇpAUWhj(r\J;%iGE; ?mBCR3I)M7NH#Y,UJDl(חiWqo2G"eY.\퍥*! TY^=8F7bstUI>_j9u{/#JJ<1G"-sdf1a A4vwMqd!Y&el$(wmIwPN<-.xdF*RWˉQ7g'qf`L9"v 
Q4g/yxPcF;2
JCUyDcV1+H8(7)đn2 H ɚIJirA0eʭjU*#e@;kMgR+x8Y-= 8vlm,HU6@
4q+LKTH9̗{[^yRQ->7yl|#1X	k!
q6[+f!CnK0D\q澡ov[s$1R\J9;3d!s mm򉥞9{ǐUVH*61UbU%IZE81DaQN- &$,qAPԬLJSMӒy.UmcRQ.7JmZk:q[ȤYiVK>;cibDJ} 4 6hot׏Nة\RdϗZ 2F61d{FҒ)hQ1c8eYXbM\YVg{[6I
p]"巔''5}7K2+'TMY$yokn/M,^<'bDQጂ^Q/丕v2J)9#
wyh1$(9`ی@5R-f:erfRnF,YrkE|0
qP3o/YԮ(dE"O@"]K"UMCP C{zp =čnJ誓&|1s%7VW^FyKFbD1[9/+*b hB=MٲHPۀ-?98y[]\<T nN$sE {[q|ig^-.;U&
wdXv~%ĬcVNqQoTS@	#Ad*Ak15++4t5`9b˕[XԪ+TFˍҁ= ʕ 'P,![Q"3ilO+Wd\IWbGb F@
j-DBTy&%%c $X,>ϥ|2y Iy
;{TnX96TăYtwYL"IUUc|lX
^4Ƹm!ϔJP8Y]jv,n˱"E@Y ||&#ʳʊ s- t5/r!L̞iR#,A[.VGJGnWdb)8< CnQDfٖV)ȸJ"2A{q{-2){rN[ʉAڄ"LKJ I,X}Jd v
2ܰsl]8$y\D
1 Q$8i1q*C˟)2$	f1;Hpղ(YVݗc(D8 LGf- :Zj_C-'Ι!<ҤG!Y]-n6!BSqmyg
mFͥ,1<R]p`
$!\򕋞E-d[dSy+ͨ2	QDl Y`>\%(eS͹`;XSһpIf!5f92&V<Ub Icp7W-x۷c$T1>RdI+9Bbveeu4Qز.(P !dp 1D*[*(tEԿȆ[O2C2yHB15lHZY*mIB28_3"0{ 
ڍGQKfXbyX2".HB/+<>[췊4ȦWPe9o*%jȉ0i.+ 'a}+湓ϸKQ+ʧrvv$CkreqL2x*eD@ n Zo 65Hci.|0V0$r!/VThe[v]P* B c1UTPh:ddJ1fbdjv:T>pdp2g#DaN("u#6̰HevE]4p_V.x!|!oiMې6rTJ%G`.]V0 "OeWs'pWO6僘ceOJH1%Lu$ eXUV?Ɉʈ%@-\OnAlkP\Ia$`H1C^֨GbʶB$T  b<1l9
CR g"n>t"9b,>ղ!kudt}&
e|F o8PD6j5DFm-ab싀 i!
࿔\B(lC$("!^mA弨J"$]d` DP2O>	/!G`s*m1ʟޕؐcK17ɕI0@ʱબ/
KZkƞݼ"< IXc [++Qŕmv9BH#$yVbQ@s.D2"|*Drř>X}eBShM!0,A;'pmj:[2!v B)XQ؆H/o/eQE7/nBڃ)yQ(;PDIIvX >e_5̞}^B^U<ۖc?+ b3]o#+`cUX_& *"8q r׍=y1"ECHys&A#,'izVWZE*۲rPG 4IŲK@4]
KeD$3'T!3|#V˴ՑҦ(C#8>`Y#
w8-O,@!ۭue'C+.+Rs^^xLo ^܅ySPv*<v풱}@,gҾk<$̪y,k*zWbA	,:fG&W$*ǂL@6TD	,pj{vcc\D6L	%cG(YNlF;Ue
", >>hYeE 9Ζh9pHfO4Cf aFi[#M7PG+p|1F`p[|YB![Q"3ilO+Wd\IWbGb F@
j-DBTy&%%c $X,>ϥ|2y Iy
;{TnX96TăYtwYL"IUUc|lX
^4Ƹm!ϔJP8Y]jv,n˱"E@Y ||&#ʳʊ s- t5/r!L̞iR#,A[.VGJGnWdb)8< CnQDfٖV)ȸJ"2A{q{-2){rN[ʉAڄ"LKJ I,X}Jd v
2ܰsl]N >  E I$Z!梒;40 .3b c]KsN[iXWI2+&*_O[ſ{9wO60
CɍUy $!iuTKtL9"7f7&HHI45ݭԮ4{8n-2ry$GifP-~$ 'Z;B0,  a6*#bJ\@,^KxoUlY6 G,r
3DSKgk]IRIYIal9 
V6ȍI Hg2CuE$vha۹,@]ɖg, ,k;5#BӖd0 #|d8WU`M Tr+/)mF`#J1"4@H,C=ݼ뎩%鼘rDop0+nL$ik[\iwN~$qZ!Md^H̡[(>I,AOiiwR`YŰ ôlTG
X~X˪Keֲmu-[dY 
fJ6فiS`s	L@
<m<j:ψdH,/sX,X 0YEu-wj1:Fm,>c`249^ F$ p }<-o 1<V^S,ڌ(Fc&5T,Di4X,{+yRKM.-y0aVܙ I!$ӨvRH͸C8ʽClQ<|XPMhd`hب$2)p21  y-UyUӭdl[p,I@6<9M-mu%I%d1%Ҧ昀4yX;"5$y"u
5١X_n琱w&Y `[ bt
NX}(dhr HA]U4RxZ-c˺xYP*LjXi YWvO:\[a412@BHP	oq;Ǜqh6q{";K2lx$=JɁgѱQH+ebReb Ab[.}-gZɵضXm9f(lyr"[;](JJbKfM'w1 (hwDjHE>!j)#C!bL9`  f;]Է1A%Qx䐃!ºh[ǳtYyLj3 T8PA`7\uI-4MÒ#{iXcrd$#N]
JKw#6l'*Dve
GIb
B{KM5--x0b<V(ĥ ䷎]V[-VNkm
$r'! P0E4vQԕ$ĖJNb PcllԐ	Q|C$7_RGfa}Bܙfr,@v+ocQ4+m9aK7!CuVKkxg.ffB4p#1b#O1d3]<nZiqnɇ$FҰI	 F@&ƗtwGmŢ4NU$,ekGu([&[ `;FDy QKo[ʭk&[bہ`HNB aȊiltk*I+!,-604  Hny 2w<2XtWRyhVr1F#CoB
	
o]e2ͨiPF2cUBFcH	gx<q$7Haɒ@:Mwkx5+.Ď<ۋD>iIY6e3%5	-4֎PL8 =vAX+/9u[l[=:Mŷ+l4CcÑFRTVCX[0-*la;iCG#R@'-GY~QI@eyre  1讥
F'HЭ,bF+$X@/=eQҡdƪ<Ɛewo4yIiźo&3J$	$$u jW]ӽ߉y|g9W#(m?xgKjZiԡlql {0䂱FV%._ /%ro*zu]mnV#i9Ǚ")ҍ$$`ZTw|+g{dFO$Z!梒;40 .3b c]KsN[iXWI2+&*_O[ſ{9wO60
CɍUy $!iuTKtL9"7f7&HHI45ݭԮ4{8n-2ry$GifP-~$ 'Z;B0,  a6*#bJ\@,^KxoUlY6 G,r
3DSKgk]IRIYIal9 
V6ȍI Hg2CuE$vha۹,@]ɖg, ,k;5#BӖd0 #|d8WU`M Tr+/)mF`#J1"4@H,0~ѩ1 ɋ*:=k
@xd"'#Z!68E9>|N[;5KW8Uю- ->Oկ,EdP)42F/k{
3Ũ*@[-n̛}3 .@42Xۢ'WT匭k2]գemϖdҐHF;Gm/ иխ!.\
XFL0??4v*sU-DoD\9;̧ܩC m[Xl!>w	-,`Zu٬b_HJ¬qn70FHmygF|͉g+ *wOِ24A|s\`Q-FIUu-vrm#tvd,Q r iǥ&q=Ԓ7ҧ,el+^00~H>Xc-Kln|$vg攀'bF268i}Ĩžn{arnr5ai۵TU07il$x""܀e<FL ;jd-7uY3HmG͸fNcO%ӭcD"UetcqE'z2D66@o#ϓ:5klK=YaT4{
|
&̀j2JkP,3m&_ab M;L=-v3nᾕ9c+aZq1WCEhmr[cs$?4)<;1ěK%@4.-kt3usM&ݪ
{K`e 0nu3)Gb7*`(.~PV$m<,DOG/lB>m2p,r}-nvkR!p+[);ђ 1 [y|ѫ_3bY#
0S(i6d̍(-_6_>gQU]K]g[l7g \-idkEOsu$
[
׳0e2-GOk,% 9Iؑv$_q*qo[ XC\D`~i6UhUL
[,spw  ;O2;SAus ڷ$igVB"}L9~[enXc'huXĿjsY]n`Iތ΍ZtVAU
1)CI .diAl湷<ZZ=`FɼX8@mmN%K],L{%xoNXVa.amZ:|[\fI,)O>ČdmCq&P
}Zbj$Ij;B`n5^dH/L6DEÛLy؍ʘ
0 vտ [O<ngp-p̜"i>KE[%TD*s NdllG'tjؖ{¨hyJMs#Jd5ͽdWRnYg-7GfM  knv,zZbgI+}*rVµpcj22Igov~iHRyv$c#j6Jh\[g.,#Q&MUASp9"Aza".fS̎nTP]\6IxYwUS;_h|ۆd0XIZ-:l1/ڤB%\VWF8Rw$@ccd <?VfĳFCG`PlP[ 9m|($us9l;2o(  [[tӴcn8I^S2g`˃et?$[V,1%7>YK;{J@rσ#PITBVC=Xp79a0 4mڪЪWY
p@@wS2dv#r oaHD$rD#3''Oigf~"*
1Ÿ"" 6%謂0=c>Rf@\҂souFx%UԵۨ{eٓx/FpۦKtX7RJJ{8\+"ڴta-̒YݟR|ڇhM:ˁInPvTj2Ȑ^m7r#0W?(` k
@xd"'#Z!68E9>|N[;5KW8Uю- ->Oկ,EdP)42F/k{
3Ũ*@[-n̛}3 .@42Xۢ'WT匭k2]գemϖdҐHF;Gm/ иխ!.\
XFL0??4v*sU-DoD\9;̧ܩC m[Xl!>w	-,`Zu٬b_HJ¬qn70FHmygF|͉g+ *wOِ24Auo  QCYL˛ϖn(\[_j̒4ICE8!.Ӏ+1ڻ@4#i	Os9"̣sG[h=vwfM6v"ќ?<`?9ur(.TJBeȩ4k@,hfUU\/#b{K\<? J* Iomus.yt>OLdܫk ,N."7Sk`eNъ.vxAPq@CYL˛ϖn(\[_j̒4ICE8!.Ӏ+1ڻ@4#i	Os9"̣sG[h=vwfM6v"ќ?<`?9ur(.TJBeȩ4k@,hfUU\/#b{K\<? J* Iomus.yt>OLdܫk ,N."7Sk`eNъ.vxAPq@CYL˛ϖn(\[_j̒4ICE8!.Ӏ+1ڻ@4#i	Os9"̣sG[h=vwfM6v"ќ?<`?9ur(.TJBeȩ4k@,hfUU\/#b{K\<? J* Iomus.yt>OLdܫk ,N."7Sk`eNъ.vxAPq@CYL˛ϖn(\[_j̒4ICE8!.Ӏ+1ڻ@4#i	Os9"̣sG[h=vwfM6v"ќ?<`?9ur(.TJBeȩ4k@,hfUU\/#b{K\<? J* Iomus.yt>OLdܫk ,N."7Sk`eNъ.vxAPq@CYL˛ϖn(\[_j̒4ICE8!.Ӏ+1ڻ@4#i	Os9"̣sG[h=vwfM6v"ќ?<`?9ur(.TJBeȩ4k@,hfUU\/#b{K\<? J* Iomus.yt>OLdܫk ,N."7Sk`eNъ.vxAPq@CYL˛ϖn(\[_j̒4ICE8!.Ӏ+1ڻ@4#i	Os9"̣sG[h=vwfM6v"ќ?<`?9ur(.TJBeȩ4k@,hfUU\/#b{K\<? J* Iomus.yt>OLdܫk ,N."7Sk`eNъ.vxAPq@CYL˛ϖn(\[_j̒4ICE8!.Ӏ+1ڻ@4#i	Os9"̣sG[h=vwfM6v"ќ?<`?9ur(.TJBeȩ4k@,hfUU\/#b{K\<? J* Iomus.yt>OLdܫk ,N."7Sk`eNъ.vxAPq@CYL˛ϖn(\[_j̒4ICE8!.Ӏ+1ڻ@4#i	Os9"̣sG[h=vwfM6v"ќ?<`?9ur(.TJBeȩ4k@,hfUU\/#b{K\<? J* Iomus.yt>OLdܫk ,N."7Sk`eNъ.vxAPq@CYL˛ϖn(\[_j̒4ICE8!.Ӏ+1ڻ@4#i	Os9"̣sG[h=vwfM6v"ќ?<`?9ur(.TJBeȩ4k@,hfUU\/#b{K\<? J* Iomus.yt>OLdܫk ,N."7Sk`eNъ.vxAPq@CYL˛ϖn(\[_j̒4ICE8!.Ӏ+1ڻ@4#i	Os9"̣sGG? ? s	{O6zzѳ̊s7ܫd=*̟g[HyOo.ܒmh8Yc
|;Y[`\4iqr[ `6aY]qͩ$p*B$ ,g` kZXI4/%k5\2ASJ O/6<:rf+	X0>V	r	[-KIoE`!Px@|C)ت\1'bcyg
)$:Va>]ifQH,2lz)$T}mS͞4l"mm
w*Jws'V4c˷$-Z$10Ve.( EV47
,qG\xE 
Vs<w>esjqF
EЄ	$n'"7$ ֖Mum$l72qGҬÈ;i
.mCΜBc!F*c\aV| [k5tT&v*WIؾXprIOjGmĥ$i٥dR$1̛ފI! [wg
<ȩnnw>lx]ʻxfCү{h앴' h։3LK0 o'úuv

Kv7/@, vnF,ϥGڜQGk!B	z(	 B]F[I5̜C$p%?t0bjC˛P(bacC` U8$d]6	2v/7pܢCiZq)I&viuls&9-Hl e@'<CF2*[ۆϛ rw2};%m#I1>rH"!LfR2 4[eoCyp{P9l۰:g83,wsvQ6k,Z@F|*3y@ia$мQFss'{\	O*8>C&,@ڐ<d&9bXPX$b5&l>`	-%YMBmbpĝ a7(ZmtvJRI]FE CɰnKm褒 P	{O6zzѳ̊s7ܫd=*̟g[HyOo.ܒmh8Yc
|;Y[`\4iqr[ `6aY]qͩ$p*B$ ,g` kZXI4/%k5\2ASJ O/6<:rf+	X0>V	r	[-KIoE`!Px@|C)ت\1'bcyg
)$:Va>]ifQH,2lz)$T}mS͞4l"mm
w*Jws'V4c˷$-Z$10Ve.( EV47
,qG\xE 
Vs<w>esjqF
EЄ	$n'"7$ ֖Mum$l72qGҬÈ;i
.mCΜBc!F*c\aV| [k5tT&v*WIؾXprIOjGmĥ$i٥dR$1̛ފI! [wg
<ȩnnw>lx]ʻxfCү{h앴' h։3LK0 o'úuv

Kv7/@, vnF,ϥGڜQGk!B	z(	 B]F[I5̜C$p%?t0bjC˛P(bacC` U8$d]6	2v/7pܢCiZq)I&viuls&9-Hl e@'<CF2*[ۆϛ rw2};%m#I1>rH"!LfR2 4[eoCyp{P9l۰:g83,wsvQ6k,Z@F|*3y@ia$мQFss'{\	O*8>C&,@ڐ<d&9bXPX$b5&l>`	-%YMBmbpĝ a7(ZmtvJRI]FE CɰnKm褒 P	{O6zzѳ̊s7ܫd=*̟g[HyOo.ܒmh8Yc
|;Y[`\4iqr[ `6aY]qͩ$p*B$ ,g` kZXI4/%k5\2ASJ O/6<:rf+	X0>V	r	[-KIoE`!Px@|C)ت\1'bcyg
)$:Va>]ifQH,2lz)$T}mS͞4l"mm
w*Jws'V4c˷$-Z$10Ve.( EV47
,qG\xE 
VsЇߙ Mgp<.dG(_caqGiè"J>4~kaNnJe;S@ͽRMpu64v\E`"XS$*#$$dZVϾHUZC&$o!WqpnbPԵgEcX ̟88pF@3fq7ͦ궋Mdx;5,KƿH,OmK
-m
Fd(r$UOOjU)$pZ)c2%FW~;c
O<w3'9B; NAյίzQ8٣]l
v
pGbS(I
 Xmkɶ9۲(rm!Q 'w`k&
Jo&}6Ej5#y
_p=-7ędqÀ
62Q6m7ȗUXlW#Ŀ1$1e
_5D1g }VKh/mRXTkm m6 g@-̀C9"}}kT:Mt#L1-2)j},,6˹<X| QZunnu{ҏ~`Sn<3E*NTbsou=ԓ\nM6ݗF+l
I?3;_0hVUy73﹵-cVɮ	Ur[5-E/YoehX$3'#Q0bYMiDpbY%%K(m$!8[A}>j§[hnY8JndDjSZuk	d0o,fQ߹N S$fya>]0P2i Ө/PEsumssޔ}N#he[p$ᘔ)Rv3;{rmi츊4E\[`HTFH*I9ɃBҭ/ɹ}ͮlMpHB~"< j)zs{(GƱ&A>qp5gr̈́oM%m+5/w.jYCnv!Y UT>Z@uč"Ps *#PHfZS] HS!(eKye2w my'3
fO)r6+H7w VA|:+k^qG*6 ĦQJ4Ou$[lsMeQ*2B2AROLi~MmteXդ?rkFw;(
KQK{DZ<n52.ld;l'|o.h\,!خG~cIpcRt,kb_Oڤ ۮ$l@1[Q.rET4֨u]mG1F0c,2[(ewS9 m8YXms2yL#/̱ZA\[\S?5V`7	xf%2TŎ{&:ܛcm."0W,V)
~gvv`ЭtKngsk[*ƭ!\7߸1@(jZ^"pIfOG8
qpc `ܳa8|u[Ea
op<KKPۥc_ݤHCp'd}F%Oq#`q
9s*٧ֵCoH8-a1aY@̣+r 1mIh|a~e
 էP_W(Gʶ
;H#1)RM f,w6SI5mqibLT;skZ_s>]"V5iܚ]/EyCRRQbL2|8k(	6K,Wk}6+_\Բ/"BA>%6,*|63D@TF˜U>>W[x@hCQe]@5>lNgC̞S,l>Vn(:uW7V7:G?fvUl)7
AL'`*h1cI&nˈLU
dDd݃4+]*ʱH~*9~w-P
7x,kd\\(1Fw,N&"]VbXC[\,|ƥ6~XiŜ	Y-QIaS孴\H,b% 25\䊩iP5E2b`XdP3(ܧrgp<.dG(_caqGiè"J>4~kaNnJe;S@ͽRMpu64v\E`"XS$*#$$dZVϾHUZC&$o!WqpnbPԵgEcX ̟88pF@3fq7ͦ궋Mdx;5,KƿH,OmK
-m
Fd(r$UOOjU)$pZ)c2%FW~;c
O<w3'9B; NAյίzQ8٣]l
v
pGbS(I
 Xmkɶ9۲(rm!Q 'w`g2 XX	|,gcڠ"J+G-A
Fa5isb@rIo	Gu{nm=Fxk#VrYc_.21,n}Nxɹ6뻷|򢨂%<HvdJ ׎[7hFbm9]^V6(P3*q0]y[aEş$Hy kĚ[ux2&ٴ\B8?4v$RK [bؽķy?Kw dRA0\6XX	|,gcڠ"J+G-A
Fa5isb@rIo	Gu{nm=Fxk#VrYc_.21,n}Nxɹ6뻷|򢨂%<HvdJ ׎[7hFbm9]^V6(P3*q0]y[aEş$Hy kĚ[ux2&ٴ\B8?4v$RK [bؽķy?Kw dRA0\6XX	|,gcڠ"J+G-A
Fa5isb@rIo	Gu{nm=Fxk#VrYc_.21,n}Nxɹ6뻷|򢨂%<HvdJ ׎[7hFbm9]^V6(P3*q0]y[aEş$Hy kĚ[ux2&ٴ\B8?4v$RK [bؽķy?Kw dRA0\6XX	|,gcڠ"J+G-A
Fa5isb@rIo	Gu{nm=Fxk#VrYc_.21,n}Nxɹ6뻷|򢨂%<HvdJ ׎[7hFbm9]^V6(P3*q0]y[aEş$Hy kĚ[ux2&ٴ\B8?4v$RK [bؽķy?Kw dRA0\6XX	|,gcڠ"J+G-A
Fa5isb@rIo	Gu{nm=Fxk#VrYc_.21,n}Nxɹ6뻷|򢨂%<HvdJ ׎[7hFbm9]^V6(P3*q0]y[aEş$Hy kĚ[ux2&ٴ\B8?4v$RK [bؽķy?Kw dRA0\6XX	|,gcڠ"J+G-A
Fa5isb@rIo	Gu{nm=Fxk#VrYc_.21,n}Nxɹ6뻷|򢨂%<HvdJ ׎[7hFbm9]^V6(P3*q0]y[aEş$Hy kĚ[ux2&ٴ\B8?4v$RK [bؽķy?Kw dRA0\6XX	|,gcڠ"J+G-A
Fa5isb@rIo	Gu{nm=Fxk#VrYc_.21,n}Nxɹ6뻷|򢨂%<HvdJ ׎[7hFbm9]^V6(P3*q0]y[aEş$Hy kĚ[ux2&ٴ\B8?4v$RK [bؽķy?Kw dRA0\6XX	|,gcڠ"J+G-A
Fa5isb@rIo	Gu{nm=Fxk#VrYc_.21,n}Nxɹ6뻷|򢨂%<HvdJ ׎[7hFbm9]^V6(P3*q0]y[aEş$Hy kĚ[ux2&ٴ\B8?4v$RK [bؽķy?Kw dRA0\6XX	|,gcڠ"J+G-A
Fa5isb@rIo	Gu{nm=Fxk#VrYc_.21,n}Nxɹ6뻷|򢨂%<HvdJ ׎[7hFbm9]^V6(P3*q0]y[aEş$Hy kĚ[ux2&ٴ\B8?4v$RK [bؽķy?Kw dRA0\6XX	|,gcڠ"J+G-A
Fa5isb@rIo	Gu{nm=Fxk#VrYc_.2$O^ e UYC*6?2t| `^U\YsZ	It!^6r3eYA*#hR-FS3\GgrvE^isUZ{S.{-
	'|[hScG9f ;\99LuӖefn
ʎZݾ./
_,ZC+eED*gTm$K=gf 7NABxHt3,ͺ	HRv8 8VPYC*6?2t| `^U\YsZ	It!^6r3eYA*#hR-FS3\GgrvE^isUZ{S.{-
	'|[hScG9f ;\99LuӖefn
ʎZݾ./
_,ZC+eED*gTm$K=gf 7NABxHt3,ͺ	HRv8 8VPYC*6?2t| `^U\YsZ	It!^6r3eYA*#hR-FS3\GgrvE^isUZ{S.{-
	'|[hScG9f ;\99LuӖefn
ʎZݾ./
_,ZC+eED*gTm$K=gf 7NABxHt3,ͺ	HRv8 8VPYC*6?2t| `^U\YsZ	It!^6r3eYA*#hR-FS3\GgrvE^isUZ{S.{-
	'|[hScG9f ;\99LuӖefn
ʎZݾ./
_,ZC+eED*gTm$K=gf 7NABxHt3,ͺ	HRv8 8VPYC*6?2t| `^U\YsZ	It!^6r3eYA*#hR-FS3\GgrvE^isUZ{S.{-
	'|[hScG9f ;\99LuӖefn
ʎZݾ./
_,ZC+eED*gTm$K=gf 7NABxHt3,ͺ	HRv8 8VPYC*6?2t| `^U\YsZ	It!^6r3eYA*#hR-FS3\GgrvE^isUZ{S.{-
	'|[hScG9f ;\99LuӖefn
ʎZݾ./
_,ZC+eED*gTm$K=gf 7NABxHt3,ͺ	HRv8 8VPYC*6?2t| `^U\YsZ	It!^6r3eYA*#hR-FS3\GgrvE^isUZ{S.{-
	'|[hScG9f ;\99LuӖefn
ʎZݾ./
_,ZC+eED*gTm$K=gf 7NABxHt3,ͺ	HRv8 8VPYC*6?2t| `^U\YsZ	It!^6r3eYA*#hR-FS3\GgrvE^isUZ{S.{-
	'|[hScG9f ;\99LuӖefn
ʎZݾ./
_,ZC+eED*gTm$K=gf 7NABxHt3,ͺ	HRv8 8VPYC*6?2t| `^U\YsZ	It!^6r3eYA*#hR-FS3\GgrvE^isUZ{S.{-
	'|[hScG9f ;\99LuӖefn
ʎZݾ./
_,ZC+eED*gTm$K=gf 7NABxHt3,ͺ	HRv8 8VPYC*6?2t| `^U\YsZ	It!^6r3eYA*#hR-FS3\GgrvE^isU[ w h'Q"o1ˑ:	7mjv[VnE2.1BT16s@l`o˧J_h̾g,en@&$ĊrqmӬcŶ7v ifbcVB#;Ywo+"ySCw>Hg
f〰2J@X-r.o$FE{M̭'ߡ927K`UJBcO}JRrl^qhG# W@*PKۄ7h,FlE@PYAdW
4dP;r61U!"3&⍵ݍNkt{}-H[3q7J f0h
tRy匰y
ĘWT.0;WuvvF\_,LjDg~B+.x  [4Phn"	5TlpIH T[ȯi'8?>Q&pIr
PR]iO]JNC-h}hC1T	{prFh#;B<m1rb;k(,F.Fڦ8S#t#/$FdQ[Mno9Xeitc4	R  ].*Y}/20a *ʅ֊NB#YEeݼ yjQM
A#* ) 
`XPt=72~$N	.YU*
KA>	+II}yŢ-^663 f;A/nHݣܲ$vhV?g>R3>@N@,Gme^(ёB7T
dnWs̛6v5;iG+M"npqƘ!*XC0\7eӥK/E__27 bE^T9P6^i1HDaq11!\o<
B)t$`׳QqX`% S,
n7Cg"VoМD%0*@!Ith1>w	)9/8E ZF}uS%ZY{YD
F|"b	{ۅ2(FjLӪ|qFnƧm5\=aS-8%K3hw4vLterX<bLHʇ*fZ+:;{\[i#w`./f&5d"3!v KB-a]E47sp6n8$ *e`AB-HldW\~c(q8$fT).4X'Ԯ%'!r>{KHϴuKK9#vr4h۝X6HϘDTU9 Ou{pFEc#mS)u_ϗ#2n([-K24e]1c|bc m.piN,}~X0܀LIyPBEyXowkm!nƬFw"W	pEL5} ^FadL,(Z\I
ZOݿBsen', %ѠƟk$>ؼGiiT3N	ig$nYf;s+)' #nhȡwmc27N9BDfMkep#[LKf8Lo,@`
.2ҥ"/`	1"*\a}h4qm"0݀YՐV].iuϺD0k¨ٸ,0 \K!ё^qs+INp~}MR4`RZ"-#cc>
c-,=,ѢGnvcx#>cP1TvPY=#y\LpF~G>_HɸmlcS.Drt)wi; c}]:TD^e9c,`r1&$UC3ocݮ-FK3ߐ˻y^ %!0.HF
{8U7R 2 ksy$6z2+n.ei?v	ϱI\TF}WpbDZ9ollgPwU:^%Ge4HЬ~`|g|"**X'Q"o1ˑ:	7mjv[VnE2.1BT16s@l`o˧J_h̾g,en@&$ĊrqmӬcŶ7v ifbcVB#;Ywo+"ySCw>Hg
f〰2J@X-r.o$FE{M̭'ߡ927K`UJBcO}JRrl^qhG# W@*PKۄ7h,FlE@PYAdW
4dP;r61U!"3&⍵ݍNkt{}-H[3q7J f0h
tRy匰y
ĘWT.0;i?W- \U Q-GY~QI@eyre  1讥
F'HЭ,bF+$X@/=eQҡdƪ<Ɛewo4yIiźo&3J$	$$u jW]ӽ߉y|g9W#(m?xgKjZiԡlql {0䂱FV%._ /%ro*zu]mnV#i9Ǚ")ҍ$$`ZTw|+g{dFO$Z!梒;40 .3b c]KsN[iXWI2+&*_O[ſ{9wO60
CɍUy $!iuTKtL9"7f7&HHI45ݭԮ4{8n-2ry$GifP-~$ 'Z;B0,  a6*#bJ\@,^KxoUlY6 G,r
3DSKgk]IRIYIal9 
V6ȍI Hg2CuE$vha۹,@]ɖg, ,k;5#BӖd0 #|d8WU`M Tr+/)mF`#J1"4@H,C=ݼ뎩%鼘rDop0+nL$ik[\iwN~$qZ!Md^H̡[(>I,AOiiwR`YŰ ôlTG
X~X˪Keֲmu-[dY 
fJ6فiS`s	L@
<m<j:ψdH,/sX,X 0YEu-wj1:Fm,>c`249^ F$ p }<-o 1<V^S,ڌ(Fc&5T,Di4X,{+yRKM.-y0aVܙ I!$ӨvRH͸C8ʽClQ<|XPMhd`hب$2)p21  y-UyUӭdl[p,I@6<9M-mu%I%d1%Ҧ昀4yX;"5$y"u
5١X_n琱w&Y `[ bt
NX}(dhr HA]U4RxZ-c˺xYP*LjXi YWvO:\[a412@BHP	oq;Ǜqh6q{";K2lx$=JɁgѱQH+ebReb Ab[.}-gZɵضXm9f(lyr"[;](JJbKfM'w1 (hwDjHE>!j)#C!bL9`  f;]Է1A%Qx䐃!ºh[ǳtYyLj3 T8PA`7\uI-4MÒ#{iXcrd$#N]
JKw#6l'*Dve
GIb
B{KM5--x0b<V(ĥ ䷎]V[-VNkm
$r'! P0E4vQԕ$ĖJNb PcllԐ	Q|C$7_RGfa}Bܙfr,@v+ocQ4+m9aK7!CuVKkxg.ffB4p#1b#O1d3]<nZiqnɇ$FҰI	 F@&ƗtwGmŢ4NU$,ekGu([&[ `;FDy QKo[ʭk&[bہ`HNB aȊiltk*I+!,-604  Hny 2w<2XtWRyhVr1F#CoB
	
o]e2ͨiPF2cUBFcH	gx<q$7Haɒ@:Mwkx5+.Ď<ۋD>iIY6e3%5	-4֎PL8 =vAX+/9u[l[=:Mŷ+l4CcÑFRTVCX[0-*la;iCG#R@'-GY~QI@eyre  1讥
F'HЭ,bF+$X@/=eQҡdƪ<Ɛewo4yIiźo&3J$	$$u jW]ӽ߉y|g9W#(m?xgKjZiԡlql {0䂱FV%._ /%ro*zu]mnV#i9Ǚ")ҍ$$`ZTw|+g{dFO$Z!梒;40 .3b c]KsN[iXWI2+&*_O[ſ{9wO60
CɍUy $?hԿ Ň @տ [O<ngp-p̜"i>KE[%TD*s NdllG'tjؖ{¨hyJMs#Jd5ͽdWRnYg-7GfM  knv,zZbgI+}*rVµpcj22Igov~iHRyv$c#j6Jh\[g.,#Q&MUASp9"Aza".fS̎nTP]\6IxYwUS;_h|ۆd0XIZ-:l1/ڤB%\VWF8Rw$@ccd <?VfĳFCG`PlP[ 9m|($us9l;2o(  [[tӴcn8I^S2g`˃et?$[V,1%7>YK;{J@rσ#PITBVC=Xp79a0 4mڪЪWY
p@@wS2dv#r oaHD$rD#3''Oigf~"*
1Ÿ"" 6%謂0=c>Rf@\҂souFx%UԵۨ{eٓx/FpۦKtX7RJJ{8\+"ڴta-̒YݟR|ڇhM:ˁInPvTj2Ȑ^m7r#0W?(` k
@xd"'#Z!68E9>|N[;5KW8Uю- ->Oկ,EdP)42F/k{
3Ũ*@[-n̛}3 .@42Xۢ'WT匭k2]գemϖdҐHF;Gm/ иխ!.\
XFL0??4v*sU-DoD\9;̧ܩC m[Xl!>w	-,`Zu٬b_HJ¬qn70FHmygF|͉g+ *wOِ24A|s\`Q-FIUu-vrm#tvd,Q r iǥ&q=Ԓ7ҧ,el+^00~H>Xc-Kln|$vg攀'bF268i}Ĩžn{arnr5ai۵TU07il$x""܀e<FL ;jd-7uY3HmG͸fNcO%ӭcD"UetcqE'z2D66@o#ϓ:5klK=YaT4{
|
&̀j2JkP,3m&_ab M;L=-v3nᾕ9c+aZq1WCEhmr[cs$?4)<;1ěK%@4.-kt3usM&ݪ
{K`e 0nu3)Gb7*`(.~PV$m<,DOG/lB>m2p,r}-nvkR!p+[);ђ 1 [y|ѫ_3bY#
0S(i6d̍(-_6_>gQU]K]g[l7g \-idkEOsu$
[
׳0e2-GOk,% 9Iؑv$_q*qo[ XC\D`~i6UhUL
[,spw  ;O2;SAus ڷ$igVB"}L9~[enXc'huXĿjsY]n`Iތ΍ZtVAU
1)CI .diAl湷<ZZ=`FɼX8@mmN%K],L{%xoNXVa.amZ:|[\fI,)O>ČdmCq&P
}Zbj$Ij;B`n5^dH/L6DEÛLy؍ʘ
0 vտ [O<ngp-p̜"i>KE[%TD*s NdllG'tjؖ{¨hyJMs#Jd5ͽdWRnYg-7GfM  knv,zZbgI+}*rVµpcj22Igov~iHRyv$c#j6Jh\[g.,#Q&MUASp9"Aza".fS̎nTP]\6IxYwUS;_h|ۆd0XIZ-:l1/ڤB%\VWF8Rw$@ccd <?VfĳFCG`PlP[ y7ƀ(,oei7`T.@D
	RVڵAIZ$`wwiF]Ġ }VEq
4ק{WnfQ#Ua-];;³&{;fVhU]0it]Gw%iVudT5 C43 CZʱ=̋|%Eg`W
c%o`QK'&`2nU  Mr
|FK52σuhG ]vG;  ʨ8!,oei7`T.@D
	RVڵAIZ$`wwiF]Ġ }VEq
4ק{WnfQ#Ua-];;³&{;fVhU]0it]Gw%iVudT5 C43 CZʱ=̋|%Eg`W
c%o`QK'&`2nU  Mr
|FK52σuhG ]vG;  ʨ8!,oei7`T.@D
	RVڵAIZ$`wwiF]Ġ }VEq
4ק{WnfQ#Ua-];;³&{;fVhU]0it]Gw%iVudT5 C43 CZʱ=̋|%Eg`W
c%o`QK'&`2nU  Mr
|FK52σuhG ]vG;  ʨ8!,oei7`T.@D
	RVڵAIZ$`wwiF]Ġ }VEq
4ק{WnfQ#Ua-];;³&{;fVhU]0it]Gw%iVudT5 C43 CZʱ=̋|%Eg`W
c%o`QK'&`2nU  Mr
|FK52σuhG ]vG;  ʨ8!,oei7`T.@D
	RVڵAIZ$`wwiF]Ġ }VEq
4ק{WnfQ#Ua-];;³&{;fVhU]0it]Gw%iVudT5 C43 CZʱ=̋|%Eg`W
c%o`QK'&`2nU  Mr
|FK52σuhG ]vG;  ʨ8!,oei7`T.@D
	RVڵAIZ$`wwiF]Ġ }VEq
4ק{WnfQ#Ua-];;³&{;fVhU]0it]Gw%iVudT5 C43 CZʱ=̋|%Eg`W
c%o`QK'&`2nU  Mr
|FK52σuhG ]vG;  ʨ8!,oei7`T.@D
	RVڵAIZ$`wwiF]Ġ }VEq
4ק{WnfQ#Ua-];;³&{;fVhU]0it]Gw%iVudT5 C43 CZʱ=̋|%Eg`W
c%o`QK'&`2nU  Mr
|FK52σuhG ]vG;  ʨ8!,oei7`T.@D
	RVڵAIZ$`wwiF]Ġ }VEq
4ק{WnfQ#Ua-];;³&{;fVhU]0it]Gw%iVudT5 C43 CZʱ=̋|%Eg`W
c%o`QK'&`2nU  Mr
|FK52σuhG ]vG;  ʨ8!,oei7`T.@D
	RVڵAIZ$`wwiF]Ġ }VEq
4ק{WnfQ#Ua-];;³&{;fVhU]0it]Gw%iVudT5 C43 CZʱ=̋|%Eg`W
c%o`QK'&`2nU  Mr
|FK52σuhG ]vG;  ʨ8!,oei7`T.@D
	RVڵAIZ$`wwiF]Ġ }VEq
4ק{WnfQ#U sO j9۽ާ==hEKpp۹dU2~OGdi<'7nI[D6Ib`]P@y>Ӭho.X㴏q|g-vB0ye}.8e8|]HO3@EFo0H 5,$5Hٮnd k)Y'wR\ڇ9@3̄,C
+Tƹ­%k"M >!Up|3+MRծۉJI4ӳKȤHcc6
mC`*>wOB6yR66|v̇_+iO1
ےA
g+2laOt+xˆ8#n._<"Yd ݁Ќ+9YcK98Yd_"hB7PQ 
kK	&亍f6k8H#J~Va	4ybԇ6NPs!1#1A0eq Ii-Ⱥl*oe;\+$_,o8E$Jl'ԵkRM42)Mpr[oE$ ʀOyІdT

6A.]3!Wd=vJFb|yvECkD&
̥e h:;᥎;Hr ;`t#
pgX죎mN(Y#Wȵ!c=TfZIy.YN!Uq||M1}X!ͨyӔ1\Lr0HLkL*o|ZK}mf.
NW
; 8nQI!Ҵ	-ZM;4Ad69`I$6 2nzl!g-mn͐oWozU>m ]$m&q)vA -wNic=(@m³;(S5HU-v HA#q>XE  ִh^Kki#fd=f@!L_w mHysjt W2,`(|1S
[0[YB6SU¸bN0RHt6}KV;n%)$N."Y!d7%RI
۽ާ==hEKpp۹dU2~OGdi<'7nI[D6Ib`]P@y>Ӭho.X㴏q|g-vB0ye}.8e8|]HO3@EFo0H 5,$5Hٮnd k)Y'wR\ڇ9@3̄,C
+Tƹ­%k"M >!Up|3+MRծۉJI4ӳKȤHcc6
mC`*>wOB6yR66|v̇_+iO1
ےA
g+2laOt+xˆ8#n._<"Yd ݁Ќ+9YcK98Yd_"hB7PQ 
kK	&亍f6k8H#J~Va	4ybԇ6NPs!1#1A0eq Ii-Ⱥl*oe;\+$_,o8E$Jl'ԵkRM42)Mpr[oE$ ʀOyІdT

6A.]3!Wd=vJFb|yvECkD&
̥e h:;᥎;Hr ;`t#
pgX죎mN(Y#Wȵ!c=TfZIy.YN!Uq||M1}X!ͨyӔ1\Lr0HLkL*o|ZK}mf.
NW
; 8nQI!Ҵ	-ZM;4Ad69`I$6 2nzl!g-mn͐oWozU>m ]$m&q)vA -wNic=(@m³;(S5HU-v HA#q>XE  ִh^Kki#fd=f@!L_w mHysjt W2,`(|1S
[0[YB6SU¸bN0RHt6}KV;n%)$N."Y!d7%RI
۽ާ==hEKpp۹dU2~OGdi<'7nI[D6Ib`]P@y>Ӭho.X㴏q|g-vB0ye}.8e8|]HO3@EFo0H 5,$5Hٮnd k)Y'wR\ڇ9@3̄,C
+Tƹ­%k"M >!Up|3+MRծۉJI4ӳKȤHcc6
mC`*>wOB6yR66|v̇_+iO1
ےA
g+2laOt+xˆ8#n._<"Yd ݁Ќ+9gC?n&m8YXms2yL#/̱ZA\[\S?5V`7	xf%2TŎ{&:ܛcm."0W,V)
~gvv`ЭtKngsk[*ƭ!\7߸1@(jZ^"pIfOG8
qpc `ܳa8|u[Ea
op<KKPۥc_ݤHCp'd}F%Oq#`q
9s*٧ֵCoH8-a1aY@̣+r 1mIh|a~e
 էP_W(Gʶ
;H#1)RM f,w6SI5mqibLT;skZ_s>]"V5iܚ]/EyCRRQbL2|8k(	6K,Wk}6+_\Բ/"BA>%6,*|63D@TF˜U>>W[x@hCQe]@5>lNgC̞S,l>Vn(:uW7V7:G?fvUl)7
AL'`*h1cI&nˈLU
dDd݃4+]*ʱH~*9~w-P
7x,kd\\(1Fw,N&"]VbXC[\,|ƥ6~XiŜ	Y-QIaS孴\H,b% 25\䊩iP5E2b`XdP3(ܧrgp<.dG(_caqGiè"J>4~kaNnJe;S@ͽRMpu64v\E`"XS$*#$$dZVϾHUZC&$o!WqpnbPԵgEcX ̟88pF@3fq7ͦ궋Mdx;5,KƿH,OmK
-m
Fd(r$UOOjU)$pZ)c2%FW~;c
O<w3'9B; NAյίzQ8٣]l
v
pGbS(I
 Xmkɶ9۲(rm!Q 'w`k&
Jo&}6Ej5#y
_p=-7ędqÀ
62Q6m7ȗUXlW#Ŀ1$1e
_5D1g }VKh/mRXTkm m6 g@-̀C9"}}kT:Mt#L1-2)j},,6˹<X| QZunnu{ҏ~`Sn<3E*NTbsou=ԓ\nM6ݗF+l
I?3;_0hVUy73﹵-cVɮ	Ur[5-E/YoehX$3'#Q0bYMiDpbY%%K(m$!8[A}>j§[hnY8JndDjSZuk	d0o,fQ߹N S$fya>]0P2i Ө/PEsumssޔ}N#he[p$ᘔ)Rv3;{rmi츊4E\[`HTFH*I9ɃBҭ/ɹ}ͮlMpHB~"< j)zs{(GƱ&A>qp5gr̈́oM%m+5/w.jYCnv!Y UT>Z@uč"Ps *#PHfZS] HS!(eKye2w my'3
fO)r6+H7w VA|:+k^qG*6 ĦQJ4Ou$[lsMeQ*2B2AROLi~MmteXդ?rkFw;(
KQK{DZ<n52.ld;l'|o.h\,!خG~cIpcRt,kb_Oڤ ۮ$l@1[Q.rET4֨u]mG1F0c,2[(ewS9 m8YXms2yL#/̱ZA\[\S?5V`7	xf%2TŎ{&:ܛcm."0W,V)
~gvv`ЭtKngsk[*ƭ!\7߸1@(jZ^"pIfOG8
qpc `ܳa8|u[Ea
op<KKPۥc_ݤHCp'd}F%Oq#`q
9s*٧ֵCoH8-a1aY@̣+r 1mIh|a~e
 էP_W(Gʶ
;H#1)RM f,w6SI5mqibLT;sw׿3G qwmm,P,V3P1mPGc%ޣ٠܅wߣ0as4r I̹$ [#k6Ԟ#^rM5uیO9,/
G7Q><du۾vQTA~̌	$;2`% ko-wЋH#1CʅMМ.+mo(g|帘.<H|bϒ
$k[ݵM-zZfl.JKGiC}ΩRD%^Gt-1l^[<%; 2) Eg.@qwmm,P,V3P1mPGc%ޣ٠܅wߣ0as4r I̹$ [#k6Ԟ#^rM5uیO9,/
G7Q><du۾vQTA~̌	$;2`% ko-wЋH#1CʅMМ.+mo(g|帘.<H|bϒ
$k[ݵM-zZfl.JKGiC}ΩRD%^Gt-1l^[<%; 2) Eg.@qwmm,P,V3P1mPGc%ޣ٠܅wߣ0as4r I̹$ [#k6Ԟ#^rM5uیO9,/
G7Q><du۾vQTA~̌	$;2`% ko-wЋH#1CʅMМ.+mo(g|帘.<H|bϒ
$k[ݵM-zZfl.JKGiC}ΩRD%^Gt-1l^[<%; 2) Eg.@qwmm,P,V3P1mPGc%ޣ٠܅wߣ0as4r I̹$ [#k6Ԟ#^rM5uیO9,/
G7Q><du۾vQTA~̌	$;2`% ko-wЋH#1CʅMМ.+mo(g|帘.<H|bϒ
$k[ݵM-zZfl.JKGiC}ΩRD%^Gt-1l^[<%; 2) Eg.@qwmm,P,V3P1mPGc%ޣ٠܅wߣ0as4r I̹$ [#k6Ԟ#^rM5uیO9,/
G7Q><du۾vQTA~̌	$;2`% ko-wЋH#1CʅMМ.+mo(g|帘.<H|bϒ
$k[ݵM-zZfl.JKGiC}ΩRD%^Gt-1l^[<%; 2) Eg.@qwmm,P,V3P1mPGc%ޣ٠܅wߣ0as4r I̹$ [#k6Ԟ#^rM5uیO9,/
G7Q><du۾vQTA~̌	$;2`% ko-wЋH#1CʅMМ.+mo(g|帘.<H|bϒ
$k[ݵM-zZfl.JKGiC}ΩRD%^Gt-1l^[<%; 2) Eg.@qwmm,P,V3P1mPGc%ޣ٠܅wߣ0as4r I̹$ [#k6Ԟ#^rM5uیO9,/
G7Q><du۾vQTA~̌	$;2`% ko-wЋH#1CʅMМ.+mo(g|帘.<H|bϒ
$k[ݵM-zZfl.JKGiC}ΩRD%^Gt-1l^[<%; 2) Eg.@qwmm,P,V3P1mPGc%ޣ٠܅wߣ0as4r I̹$ [#k6Ԟ#^rM5uیO9,/
G7Q><du۾vQTA~̌	$;2`% ko-wЋH#1CʅMМ.+mo(g|帘.<H|bϒ
$k[ݵM-zZfl.JKGiC}ΩRD%^Gt-1l^[<%; 2) Eg.@qwmm,P,V3P1mPGc%ޣ٠܅wߣ0as4r I̹$ [#k6Ԟ#^rM5uیO9,/
G7Q><du۾vQTA~̌	$;2`% ko-wЋH#1CʅMМ.+mo(g|帘.<H|bϒ
$k[ݵM-zZfl.JKGiC}ΩRD%^Gt-1l^[<%; 2) Eg.@qwmm,P,V3P1mPGc%ޣ٠܅wߣ0as4r I̹$ [#k6Ԟ#^rM5uیO9,/
nx'2*Gbc,i:> 	@W0R/*ke.,uyQ:[yۯC92,h ukq?]FCl#H39;"^d/4Ϲ*=tcitݾ-)r~C QۜxCmOf&Bs2GbnI/-!2"p3wJO}I k%ԳIvG
' Rü$:	GfVh$[X;T Y+lfT [Gbc,i:> 	@W0R/*ke.,uyQ:[yۯC92,h ukq?]FCl#H39;"^d/4Ϲ*=tcitݾ-)r~C QۜxCmOf&Bs2GbnI/-!2"p3wJO}I k%ԳIvG
' Rü$:	GfVh$[X;T Y+lfT [Gbc,i:> 	@W0R/*ke.,uyQ:[yۯC92,h ukq?]FCl#H39;"^d/4Ϲ*=tcitݾ-)r~C QۜxCmOf&Bs2GbnI/-!2"p3wJO}I k%ԳIvG
' Rü$:	GfVh$[X;T Y+lfT [Gbc,i:> 	@W0R/*ke.,uyQ:[yۯC92,h ukq?]FCl#H39;"^d/4Ϲ*=tcitݾ-)r~C QۜxCmOf&Bs2GbnI/-!2"p3wJO}I k%ԳIvG
' Rü$:	GfVh$[X;T Y+lfT [Gbc,i:> 	@W0R/*ke.,uyQ:[yۯC92,h ukq?]FCl#H39;"^d/4Ϲ*=tcitݾ-)r~C QۜxCmOf&Bs2GbnI/-!2"p3wJO}I k%ԳIvG
' Rü$:	GfVh$[X;T Y+lfT [Gbc,i:> 	@W0R/*ke.,uyQ:[yۯC92,h ukq?]FCl#H39;"^d/4Ϲ*=tcitݾ-)r~C QۜxCmOf&Bs2GbnI/-!2"p3wJO}I k%ԳIvG
' Rü$:	GfVh$[X;T Y+lfT [Gbc,i:> 	@W0R/*ke.,uyQ:[yۯC92,h ukq?]FCl#H39;"^d/4Ϲ*=tcitݾ-)r~C QۜxCmOf&Bs2GbnI/-!2"p3wJO}I k%ԳIvG
' Rü$:	GfVh$[X;T Y+lfT [Gbc,i:> 	@W0R/*ke.,uyQ:[yۯC92,h ukq?]FCl#H39;"^d/4Ϲ*=tcitݾ-)r~C QۜxCmOf&Bs2GbnI/-!2"p3wJO}I k%ԳIvG
' Rü$:	GfVh$[X;T Y+lfT [Gbc,i:> 	@W0R/*ke.,uyQ:[yۯC92,h ukq?]FCl#H39;"^d/4Ϲ*=tcitݾ-)r~C QۜxCmOf&Bs2GbnI/-!2"p3wJO}I k%ԳIvG
' Rü$:	GfVh$[X;T Y+lfT [Gbc,i:> 	@W0R/*ke.,uyQ:[yۯC92,h ukq?]FCl#H39;"^d/4Ϲ*;yAs4me^(ёB7T
dnWs̛6v5;iG+M"npqƘ!*XC0\7eӥK/E__27 bE^T9P6^i1HDaq11!\o<
B)t$`׳QqX`% S,
n7Cg"VoМD%0*@!Ith1>w	)9/8E ZF}uS%ZY{YD
F|"b	{ۅ2(FjLӪ|qFnƧm5\=aS-8%K3hw4vLterX<bLHʇ*fZ+:;{\[i#w`./f&5d"3!v KB-a]E47sp6n8$ *e`AB-HldW\~c(q8$fT).4X'Ԯ%'!r>{KHϴuKK9#vr4h۝X6HϘDTU9 Ou{pFEc#mS)u_ϗ#2n([-K24e]1c|bc m.piN,}~X0܀LIyPBEyXowkm!nƬFw"W	pEL5} ^FadL,(Z\I
ZOݿBsen', %ѠƟk$>ؼGiiT3N	ig$nYf;s+)' #nhȡwmc27N9BDfMkep#[LKf8Lo,@`
.2ҥ"/`	1"*\a}h4qm"0݀YՐV].iuϺD0k¨ٸ,0 \K!ё^qs+INp~}MR4`RZ"-#cc>
c-,=,ѢGnvcx#>cP1TvPY=#y\LpF~G>_HɸmlcS.Drt)wi; c}]:TD^e9c,`r1&$UC3ocݮ-FK3ߐ˻y^ %!0.HF
{8U7R 2 ksy$6z2+n.ei?v	ϱI\TF}WpbDZ9ollgPwU:^%Ge4HЬ~`|g|"**X'Q"o1ˑ:	7mjv[VnE2.1BT16s@l`o˧J_h̾g,en@&$ĊrqmӬcŶ7v ifbcVB#;Ywo+"ySCw>Hg
f〰2J@X-r.o$FE{M̭'ߡ927K`UJBcO}JRrl^qhG# W@*PKۄ7h,FlE@PYAdW
4dP;r61U!"3&⍵ݍNkt{}-H[3q7J f0h
tRy匰y
ĘWT.0;WuvvF\_,LjDg~B+.x  [4Phn"	5TlpIH T[ȯi'8?>Q&pIr
PR]iO]JNC-h}hC1T	{prFh#;B<m1rb;k(,F.Fڦ8S#t#/$FdQ[Mno9Xeitc4	R  ].*Y}/20a *ʅ֊NB#YEeݼ yjQM
A#* ) 
`XPt=72~$N	.YU*
KA>	+II}yŢ-^663 f;A/nHݣܲ$vhV?g>R3>@N@,Gme^(ёB7T
dnWs̛6v5;iG+M"npqƘ!*XC0\7eӥK/E__27 bE^T9P6^i1HDaq11!\o<
B)t$`׳QqX`% S,
n7Cg"VoМD%0*@!Ith1>w	)9/8E ZF}uS%ZY{YD
F|"b	{ۅ2(FjLӪ|qFnƧm5\=aS-8%K3hw4vLterX<bLHʇ*f?ش+ .O*(Hny 2w<2XtWRyhVr1F#CoB
	
o]e2ͨiPF2cUBFcH	gx<q$7Haɒ@:Mwkx5+.Ď<ۋD>iIY6e3%5	-4֎PL8 =vAX+/9u[l[=:Mŷ+l4CcÑFRTVCX[0-*la;iCG#R@'-GY~QI@eyre  1讥
F'HЭ,bF+$X@/=eQҡdƪ<Ɛewo4yIiźo&3J$	$$u jW]ӽ߉y|g9W#(m?xgKjZiԡlql {0䂱FV%._ /%ro*zu]mnV#i9Ǚ")ҍ$$`ZTw|+g{dFO$Z!梒;40 .3b c]KsN[iXWI2+&*_O[ſ{9wO60
CɍUy $!iuTKtL9"7f7&HHI45ݭԮ4{8n-2ry$GifP-~$ 'Z;B0,  a6*#bJ\@,^KxoUlY6 G,r
3DSKgk]IRIYIal9 
V6ȍI Hg2CuE$vha۹,@]ɖg, ,k;5#BӖd0 #|d8WU`M Tr+/)mF`#J1"4@H,C=ݼ뎩%鼘rDop0+nL$ik[\iwN~$qZ!Md^H̡[(>I,AOiiwR`YŰ ôlTG
X~X˪Keֲmu-[dY 
fJ6فiS`s	L@
<m<j:ψdH,/sX,X 0YEu-wj1:Fm,>c`249^ F$ p }<-o 1<V^S,ڌ(Fc&5T,Di4X,{+yRKM.-y0aVܙ I!$ӨvRH͸C8ʽClQ<|XPMhd`hب$2)p21  y-UyUӭdl[p,I@6<9M-mu%I%d1%Ҧ昀4yX;"5$y"u
5١X_n琱w&Y `[ bt
NX}(dhr HA]U4RxZ-c˺xYP*LjXi YWvO:\[a412@BHP	oq;Ǜqh6q{";K2lx$=JɁgѱQH+ebReb Ab[.}-gZɵضXm9f(lyr"[;](JJbKfM'w1 (hwDjHE>!j)#C!bL9`  f;]Է1A%Qx䐃!ºh[ǳtYyLj3 T8PA`7\uI-4MÒ#{iXcrd$#N]
JKw#6l'*Dve
GIb
B{KM5--x0b<V(ĥ ䷎]V[-VNkm
$r'! P0E4vQԕ$ĖJNb PcllԐ	Q|C$7_RGfa}Bܙfr,@v+ocQ4+m9aK7!CuVKkxg.ffB4p#1b#O1d3]<nZiqnɇ$FҰI	 F@&ƗtwGmŢ4NU$,ekGu([&[ `;FDy QKo[ʭk&[bہ`HNB aȊiltk*I+!,-604  Hny 2w<2XtWRyhVr1F#CoB
	
o]e2ͨiPF2cUBFcH	gx<q$7Haɒ@:Mwkx5+.Ď<ۋD>iIY6e3%5	-4֎PL8 =vAX+/9u[l[=:Mŷ+l4CcÑFRTVCX[0-*la;iCG#R@'-GY~QI@eyre  1讥
F'HЭ,bF+$X@/=eQҡdƪ<Ɛj_Lb jd-7uY3HmG͸fNcO%ӭcD"UetcqE'z2D66@o#ϓ:5klK=YaT4{
|
&̀j2JkP,3m&_ab M;L=-v3nᾕ9c+aZq1WCEhmr[cs$?4)<;1ěK%@4.-kt3usM&ݪ
{K`e 0nu3)Gb7*`(.~PV$m<,DOG/lB>m2p,r}-nvkR!p+[);ђ 1 [y|ѫ_3bY#
0S(i6d̍(-_6_>gQU]K]g[l7g \-idkEOsu$
[
׳0e2-GOk,% 9Iؑv$_q*qo[ XC\D`~i6UhUL
[,spw  ;O2;SAus ڷ$igVB"}L9~[enXc'huXĿjsY]n`Iތ΍ZtVAU
1)CI .diAl湷<ZZ=`FɼX8@mmN%K],L{%xoNXVa.amZ:|[\fI,)O>ČdmCq&P
}Zbj$Ij;B`n5^dH/L6DEÛLy؍ʘ
0 vտ [O<ngp-p̜"i>KE[%TD*s NdllG'tjؖ{¨hyJMs#Jd5ͽdWRnYg-7GfM  knv,zZbgI+}*rVµpcj22Igov~iHRyv$c#j6Jh\[g.,#Q&MUASp9"Aza".fS̎nTP]\6IxYwUS;_h|ۆd0XIZ-:l1/ڤB%\VWF8Rw$@ccd <?VfĳFCG`PlP[ 9m|($us9l;2o(  [[tӴcn8I^S2g`˃et?$[V,1%7>YK;{J@rσ#PITBVC=Xp79a0 4mڪЪWY
p@@wS2dv#r oaHD$rD#3''Oigf~"*
1Ÿ"" 6%謂0=c>Rf@\҂souFx%UԵۨ{eٓx/FpۦKtX7RJJ{8\+"ڴta-̒YݟR|ڇhM:ˁInPvTj2Ȑ^m7r#0W?(` k
@xd"'#Z!68E9>|N[;5KW8Uю- ->Oկ,EdP)42F/k{
3Ũ*@[-n̛}3 .@42Xۢ'WT匭k2]գemϖdҐHF;Gm/ иխ!.\
XFL0??4v*sU-DoD\9;̧ܩC m[Xl!>w	-,`Zu٬b_HJ¬qn70FHmygF|͉g+ *wOِ24A|s\`Q-FIUu-vrm#tvd,Q r iǥ&q=Ԓ7ҧ,el+^00~H>Xc-Kln|$vg攀'bF268i}Ĩžn{arnr5ai۵TU07il$x""܀e<FL ;jd-7uY3HmG͸fNcO%ӭcD"UetcqE'z2D66@o#ϓ:5klK=YaT4{
|
&̀j2JkP,3m&_ab M;L=-v3nᾕ9c+aZq1WCEhmr[cs$?4)<;1ěK%@4.-kt3usM&ݪ
{K`e 0nu3)Gb7*`(.~PV$m<,DOG/lB>m2p,r}-nvkR!p+[);ђ 1 [y|ѫ_3bY#
0S(i6d̍(-tomi?@Pk2s崛0 * "+VZ$-mPDF;4 w
vP M>}wq dk=D+ȷEEi3(*.kYs͝H4g*i.4ńn]\ ˺v.Ы:h2*y!UUW!eXE>qt"E3+17v[]\˨]%ϓE07*  K&ӹKHTŚgӴbˁB #eTPk2s崛0 * "+VZ$-mPDF;4 w
vP M>}wq dk=D+ȷEEi3(*.kYs͝H4g*i.4ńn]\ ˺v.Ы:h2*y!UUW!eXE>qt"E3+17v[]\˨]%ϓE07*  K&ӹKHTŚgӴbˁB #eTPk2s崛0 * "+VZ$-mPDF;4 w
vP M>}wq dk=D+ȷEEi3(*.kYs͝H4g*i.4ńn]\ ˺v.Ы:h2*y!UUW!eXE>qt"E3+17v[]\˨]%ϓE07*  K&ӹKHTŚgӴbˁB #eTPk2s崛0 * "+VZ$-mPDF;4 w
vP M>}wq dk=D+ȷEEi3(*.kYs͝H4g*i.4ńn]\ ˺v.Ы:h2*y!UUW!eXE>qt"E3+17v[]\˨]%ϓE07*  K&ӹKHTŚgӴbˁB #eTPk2s崛0 * "+VZ$-mPDF;4 w
vP M>}wq dk=D+ȷEEi3(*.kYs͝H4g*i.4ńn]\ ˺v.Ы:h2*y!UUW!eXE>qt"E3+17v[]\˨]%ϓE07*  K&ӹKHTŚgӴbˁB #eTPk2s崛0 * "+VZ$-mPDF;4 w
vP M>}wq dk=D+ȷEEi3(*.kYs͝H4g*i.4ńn]\ ˺v.Ы:h2*y!UUW!eXE>qt"E3+17v[]\˨]%ϓE07*  K&ӹKHTŚgӴbˁB #eTPk2s崛0 * "+VZ$-mPDF;4 w
vP M>}wq dk=D+ȷEEi3(*.kYs͝H4g*i.4ńn]\ ˺v.Ы:h2*y!UUW!eXE>qt"E3+17v[]\˨]%ϓE07*  K&ӹKHTŚgӴbˁB #eTPk2s崛0 * "+VZ$-mPDF;4 w
vP M>}wq dk=D+ȷEEi3(*.kYs͝H4g*i.4ńn]\ ˺v.Ы:h2*y!UUW!eXE>qt"E3+17v[]\˨]%ϓE07*  K&ӹKHTŚgӴbˁB #eTPk2s崛0 * "+VZ$-mPDF;4 w
vP M>}wq dk=D+ȷEEi3(*.kYs͝H4g*i.4ńn]\ ˺v.Ы:h2*y!UUW!eXE>qt"E3+17v[]\˨]%ϓE07*  K&ӹKHTŚgӴbˁB #eTPk2s崛0 * "+VZ$-mPDF;4 w
vP M>}wq dk=D+ȷEEi3(* Oƿ9 5@}mS͞4l"mm
w*Jws'V4c˷$-Z$10Ve.( EV47
,qG\xE 
Vs<w>esjqF
EЄ	$n'"7$ ֖Mum$l72qGҬÈ;i
.mCΜBc!F*c\aV| [k5tT&v*WIؾXprIOjGmĥ$i٥dR$1̛ފI! [wg
<ȩnnw>lx]ʻxfCү{h앴' h։3LK0 o'úuv

Kv7/@, vnF,ϥGڜQGk!B	z(	 B]F[I5̜C$p%?t0bjC˛P(bacC` U8$d]6	2v/7pܢCiZq)I&viuls&9-Hl e@'<CF2*[ۆϛ rw2};%m#I1>rH"!LfR2 4[eoCyp{P9l۰:g83,wsvQ6k,Z@F|*3y@ia$мQFss'{\	O*8>C&,@ڐ<d&9bXPX$b5&l>`	-%YMBmbpĝ a7(ZmtvJRI]FE CɰnKm褒 P	{O6zzѳ̊s7ܫd=*̟g[HyOo.ܒmh8Yc
|;Y[`\4iqr[ `6aY]qͩ$p*B$ ,g` kZXI4/%k5\2ASJ O/6<:rf+	X0>V	r	[-KIoE`!Px@|C)ت\1'bcyg
)$:Va>]ifQH,2lz)$T}mS͞4l"mm
w*Jws'V4c˷$-Z$10Ve.( EV47
,qG\xE 
Vs<w>esjqF
EЄ	$n'"7$ ֖Mum$l72qGҬÈ;i
.mCΜBc!F*c\aV| [k5tT&v*WIؾXprIOjGmĥ$i٥dR$1̛ފI! [wg
<ȩnnw>lx]ʻxfCү{h앴' h։3LK0 o'úuv

Kv7/@, vnF,ϥGڜQGk!B	z(	 B]F[I5̜C$p%?t0bjC˛P(bacC` U8$d]6	2v/7pܢCiZq)I&viuls&9-Hl e@'<CF2*[ۆϛ rw2};%m#I1>rH"!LfR2 4[eoCyp{P9l۰:g83,wsvQ6k,Z@F|*3y@ia$мQFss'{\	O*8>C&,@ڐ<d&9bXPX$b5&l>`	-%YMBmbpĝ a7(ZmtvJRI]FE CɰnKm褒 P	{O6zzѳ̊s7ܫd=*̟g[HyOo.ܒmh8Yc
|;Y[`\4iqr[ `6aY]qͩ$p*B$ ,g` kZXI4/%k5\2ASJ O/6<:rf+	X0>V	r	[-KIoE`!Px@|C)ت\1'bcyg
)$:Va>]ifQH,2lz)$T}mS͞4l"mm
w*Jws'V4c˷$-Z$10Ve.( EV47
,qG\xE 
Vs<w>esjqF
EЄ	$n'"7$ ֖Mum$l72qGҬÈ;i
.mCΜBc!F*c\aV| [k5tT&v*WIؾXprIOjGmĥ$i٥dR$1̛ފI! [wg
<ȩnnw>lx]ʻxfCү{h앴' h։3LK0 o'úuv

Kv7/@, vnF}_!o7@},,6˹<X| QZunnu{ҏ~`Sn<3E*NTbsou=ԓ\nM6ݗF+l
I?3;_0hVUy73﹵-cVɮ	Ur[5-E/YoehX$3'#Q0bYMiDpbY%%K(m$!8[A}>j§[hnY8JndDjSZuk	d0o,fQ߹N S$fya>]0P2i Ө/PEsumssޔ}N#he[p$ᘔ)Rv3;{rmi츊4E\[`HTFH*I9ɃBҭ/ɹ}ͮlMpHB~"< j)zs{(GƱ&A>qp5gr̈́oM%m+5/w.jYCnv!Y UT>Z@uč"Ps *#PHfZS] HS!(eKye2w my'3
fO)r6+H7w VA|:+k^qG*6 ĦQJ4Ou$[lsMeQ*2B2AROLi~MmteXդ?rkFw;(
KQK{DZ<n52.ld;l'|o.h\,!خG~cIpcRt,kb_Oڤ ۮ$l@1[Q.rET4֨u]mG1F0c,2[(ewS9 m8YXms2yL#/̱ZA\[\S?5V`7	xf%2TŎ{&:ܛcm."0W,V)
~gvv`ЭtKngsk[*ƭ!\7߸1@(jZ^"pIfOG8
qpc `ܳa8|u[Ea
op<KKPۥc_ݤHCp'd}F%Oq#`q
9s*٧ֵCoH8-a1aY@̣+r 1mIh|a~e
 էP_W(Gʶ
;H#1)RM f,w6SI5mqibLT;skZ_s>]"V5iܚ]/EyCRRQbL2|8k(	6K,Wk}6+_\Բ/"BA>%6,*|63D@TF˜U>>W[x@hCQe]@5>lNgC̞S,l>Vn(:uW7V7:G?fvUl)7
AL'`*h1cI&nˈLU
dDd݃4+]*ʱH~*9~w-P
7x,kd\\(1Fw,N&"]VbXC[\,|ƥ6~XiŜ	Y-QIaS孴\H,b% 25\䊩iP5E2b`XdP3(ܧrgp<.dG(_caqGiè"J>4~kaNnJe;S@ͽRMpu64v\E`"XS$*#$$dZVϾHUZC&$o!WqpnbPԵgEcX ̟88pF@3fq7ͦ궋Mdx;5,KƿH,OmK
-m
Fd(r$UOOjU)$pZ)c2%FW~;c
O<w3'9B; NAյίzQ8٣]l
v
pGbS(I
 Xmkɶ9۲(rm!Q 'w`k&
Jo&}6Ej5#y
_p=-7ędqÀ
62Q6m7ȗUXlW#Ŀ1$1e
_5D1g }VKh/mRXTkm m6 g@-̀C9"}}kT:Mt#L1-2)j},,6˹<X| QZunnu{ҏ~`Sn<3E*NTbsou=ԓ\nM6ݗF+l
I?3;_0hVUy73﹵-cVɮ	Ur[5-E/YoehX$3'#Q0bYMiDpbY%%K(m$!8[A}>j§[hnY8JndDjSZuk	d0o,fQ߹N S$fya>]0P2i Ө/PEsumssޔ}N#he[p$ᘔ)Rv3;{rmi츊4E\[`HTFH*I9  (+ti~_(61QlnBјy0j9\9X$\[yhi^۵jOp^9EĺUvX˂́i#S2na
; O?fF05㷖hEZ$BhNFeaW͊3ʾrLvVQdiy?|1g5@&^=-	m%%P#4!݉>gT"/#/q-tx"3 
(+ti~_(61QlnBјy0j9\9X$\[yhi^۵jOp^9EĺUvX˂́i#S2na
; O?fF05㷖hEZ$BhNFeaW͊3ʾrLvVQdiy?|1g5@&^=-	m%%P#4!݉>gT"/#/q-tx"3 
(+ti~_(61QlnBјy0j9\9X$\[yhi^۵jOp^9EĺUvX˂́i#S2na
; O?fF05㷖hEZ$BhNFeaW͊3ʾrLvVQdiy?|1g5@&^=-	m%%P#4!݉>gT"/#/q-tx"3 
(+ti~_(61QlnBјy0j9\9X$\[yhi^۵jOp^9EĺUvX˂́i#S2na
; O?fF05㷖hEZ$BhNFeaW͊3ʾrLvVQdiy?|1g5@&^=-	m%%P#4!݉>gT"/#/q-tx"3 
(+ti~_(61QlnBјy0j9\9X$\[yhi^۵jOp^9EĺUvX˂́i#S2na
; O?fF05㷖hEZ$BhNFeaW͊3ʾrLvVQdiy?|1g5@&^=-	m%%P#4!݉>gT"/#/q-tx"3 
(+ti~_(61QlnBјy0j9\9X$\[yhi^۵jOp^9EĺUvX˂́i#S2na
; O?fF05㷖hEZ$BhNFeaW͊3ʾrLvVQdiy?|1g5@&^=-	m%%P#4!݉>gT"/#/q-tx"3 
(+ti~_(61QlnBјy0j9\9X$\[yhi^۵jOp^9EĺUvX˂́i#S2na
; O?fF05㷖hEZ$BhNFeaW͊3ʾrLvVQdiy?|1g5@&^=-	m%%P#4!݉>gT"/#/q-tx"3 
(+ti~_(61QlnBјy0j9\9X$\[yhi^۵jOp^9EĺUvX˂́i#S2na
; O?fF05㷖hEZ$BhNFeaW͊3ʾrLvVQdiy?|1g5@&^=-	m%%P#4!݉>gT"/#/q-tx"3 
(+ti~_(61QlnBјy0j9\9X$\[yhi^۵jOp^9EĺUvX˂́i#S2na
; O?fF05㷖hEZ$BhNFeaW͊3ʾrLvVQdiy?|1g5@&^=-	m%%P#4!݉>gT"/#/q-tx"3 
(+ti~_(61QlnBјy0j9\9X$\[yhi^۵jOp^9EĺUvX˂́?<E C׿@m11Pʍ̝ +m|)mv:ւo<t-m׍dPJ4 TQ5.i!g򜝑}2FgVKjBI9?!Y(mc!涎G'!9tY[FVo@Qj
񀻥'$[b5jY٤#
䓐Pa#nF{F4-yT* ,3p*gT-11Pʍ̝ +m|)mv:ւo<t-m׍dPJ4 TQ5.i!g򜝑}2FgVKjBI9?!Y(mc!涎G'!9tY[FVo@Qj
񀻥'$[b5jY٤#
䓐Pa#nF{F4-yT* ,3p*gT-11Pʍ̝ +m|)mv:ւo<t-m׍dPJ4 TQ5.i!g򜝑}2FgVKjBI9?!Y(mc!涎G'!9tY[FVo@Qj
񀻥'$[b5jY٤#
䓐Pa#nF{F4-yT* ,3p*gT-11Pʍ̝ +m|)mv:ւo<t-m׍dPJ4 TQ5.i!g򜝑}2FgVKjBI9?!Y(mc!涎G'!9tY[FVo@Qj
񀻥'$[b5jY٤#
䓐Pa#nF{F4-yT* ,3p*gT-11Pʍ̝ +m|)mv:ւo<t-m׍dPJ4 TQ5.i!g򜝑}2FgVKjBI9?!Y(mc!涎G'!9tY[FVo@Qj
񀻥'$[b5jY٤#
䓐Pa#nF{F4-yT* ,3p*gT-11Pʍ̝ +m|)mv:ւo<t-m׍dPJ4 TQ5.i!g򜝑}2FgVKjBI9?!Y(mc!涎G'!9tY[FVo@Qj
񀻥'$[b5jY٤#
䓐Pa#nF{F4-yT* ,3p*gT-11Pʍ̝ +m|)mv:ւo<t-m׍dPJ4 TQ5.i!g򜝑}2FgVKjBI9?!Y(mc!涎G'!9tY[FVo@Qj
񀻥'$[b5jY٤#
䓐Pa#nF{F4-yT* ,3p*gT-11Pʍ̝ +m|)mv:ւo<t-m׍dPJ4 TQ5.i!g򜝑}2FgVKjBI9?!Y(mc!涎G'!9tY[FVo@Qj
񀻥'$[b5jY٤#
䓐Pa#nF{F4-yT* ,3p*gT-11Pʍ̝ +m|)mv:ւo<t-m׍dPJ4 TQ5.i!g򜝑}2FgVKjBI9?!Y(mc!涎G'!9tY[FVo@Qj
񀻥'$[b5jY٤#
䓐Pa#nF{F4-yT* ,3p*gT-11Pʍ̝ +m|)mv:ւo<t-m׍dPJ4 TQ5.i!g򜝑}2FgV? <?  㶲nhȡwmc27N9BDfMkep#[LKf8Lo,@`
.2ҥ"/`	1"*\a}h4qm"0݀YՐV].iuϺD0k¨ٸ,0 \K!ё^qs+INp~}MR4`RZ"-#cc>
c-,=,ѢGnvcx#>cP1TvPY=#y\LpF~G>_HɸmlcS.Drt)wi; c}]:TD^e9c,`r1&$UC3ocݮ-FK3ߐ˻y^ %!0.HF
{8U7R 2 ksy$6z2+n.ei?v	ϱI\TF}WpbDZ9ollgPwU:^%Ge4HЬ~`|g|"**X'Q"o1ˑ:	7mjv[VnE2.1BT16s@l`o˧J_h̾g,en@&$ĊrqmӬcŶ7v ifbcVB#;Ywo+"ySCw>Hg
f〰2J@X-r.o$FE{M̭'ߡ927K`UJBcO}JRrl^qhG# W@*PKۄ7h,FlE@PYAdW
4dP;r61U!"3&⍵ݍNkt{}-H[3q7J f0h
tRy匰y
ĘWT.0;WuvvF\_,LjDg~B+.x  [4Phn"	5TlpIH T[ȯi'8?>Q&pIr
PR]iO]JNC-h}hC1T	{prFh#;B<m1rb;k(,F.Fڦ8S#t#/$FdQ[Mno9Xeitc4	R  ].*Y}/20a *ʅ֊NB#YEeݼ yjQM
A#* ) 
`XPt=72~$N	.YU*
KA>	+II}yŢ-^663 f;A/nHݣܲ$vhV?g>R3>@N@,Gme^(ёB7T
dnWs̛6v5;iG+M"npqƘ!*XC0\7eӥK/E__27 bE^T9P6^i1HDaq11!\o<
B)t$`׳QqX`% S,
n7Cg"VoМD%0*@!Ith1>w	)9/8E ZF}uS%ZY{YD
F|"b	{ۅ2(FjLӪ|qFnƧm5\=aS-8%K3hw4vLterX<bLHʇ*fZ+:;{\[i#w`./f&5d"3!v KB-a]E47sp6n8$ *e`AB-HldW\~c(q8$fT).4X'Ԯ%'!r>{KHϴuKK9#vr4h۝X6HϘDTU9 Ou{pFEc#mS)u_ϗ#2n([-K24e]1c|bc m.piN,}~X0܀LIyPBEyXowkm!nƬFw"W	pEL5} ^FadL,(Z\I
ZOݿBsen', %ѠƟk$>ؼGiiT3N	ig$nYf;s+)' #nhȡwmc27N9BDfMkep#[LKf8Lo,@`
.2ҥ"/`	1"*\a}h4qm"0݀YՐV].iuϺD0k¨ٸ,0 \K!ё^qs+INp~}MR4`RZ"-#cc>
c-,=,ѢGnvcx#>cP1TvPY=#y\LpF~G>_HɸmlcS.Drt)wi; c}]:TD^e9c,`r1&$UC3oZO' @dQ|C$7_RGfa}Bܙfr,@v+ocQ4+m9aK7!CuVKkxg.ffB4p#1b#O1d3]<nZiqnɇ$FҰI	 F@&ƗtwGmŢ4NU$,ekGu([&[ `;FDy QKo[ʭk&[bہ`HNB aȊiltk*I+!,-604  Hny 2w<2XtWRyhVr1F#CoB
	
o]e2ͨiPF2cUBFcH	gx<q$7Haɒ@:Mwkx5+.Ď<ۋD>iIY6e3%5	-4֎PL8 =vAX+/9u[l[=:Mŷ+l4CcÑFRTVCX[0-*la;iCG#R@'-GY~QI@eyre  1讥
F'HЭ,bF+$X@/=eQҡdƪ<Ɛewo4yIiźo&3J$	$$u jW]ӽ߉y|g9W#(m?xgKjZiԡlql {0䂱FV%._ /%ro*zu]mnV#i9Ǚ")ҍ$$`ZTw|+g{dFO$Z!梒;40 .3b c]KsN[iXWI2+&*_O[ſ{9wO60
CɍUy $!iuTKtL9"7f7&HHI45ݭԮ4{8n-2ry$GifP-~$ 'Z;B0,  a6*#bJ\@,^KxoUlY6 G,r
3DSKgk]IRIYIal9 
V6ȍI Hg2CuE$vha۹,@]ɖg, ,k;5#BӖd0 #|d8WU`M Tr+/)mF`#J1"4@H,C=ݼ뎩%鼘rDop0+nL$ik[\iwN~$qZ!Md^H̡[(>I,AOiiwR`YŰ ôlTG
X~X˪Keֲmu-[dY 
fJ6فiS`s	L@
<m<j:ψdH,/sX,X 0YEu-wj1:Fm,>c`249^ F$ p }<-o 1<V^S,ڌ(Fc&5T,Di4X,{+yRKM.-y0aVܙ I!$ӨvRH͸C8ʽClQ<|XPMhd`hب$2)p21  y-UyUӭdl[p,I@6<9M-mu%I%d1%Ҧ昀4yX;"5$y"u
5١X_n琱w&Y `[ bt
NX}(dhr HA]U4RxZ-c˺xYP*LjXi YWvO:\[a412@BHP	oq;Ǜqh6q{";K2lx$=JɁgѱQH+ebReb Ab[.}-gZɵضXm9f(lyr"[;](JJbKfM'w1 (hwDjHE>!j)#C!bL9`  f;]Է1A%Qx䐃!ºh[ǳtYyLj3 T8PA`7\uI-4MÒ#{iXcrd$#N]
JKw#6l'*Dve
GIb
B{KM5--x0b<V(ĥ ䷎]V[-VNkm
$r'! P0E4vQԕ$ĖJNb PcllԐ	Q|C$7_RGfa}Bܙfr,@v+ocQ4+m9aK7!CuVKkxg.ffB4p#1b#O1d3]<nZiqnɇ$FҰI	 F@&ƗtwGmŢ4NU$,ekGu([&[ `;FDy QKo[ʭk&[bہ`HNB aȊiltk*I+!,-604  Hny 2w<2XtWRyhVr1F#CoB
	
o]e2ͨiPF2cUBFcH	5/&?1a PGoaHD$rD#3''Oigf~"*
1Ÿ"" 6%謂0=c>Rf@\҂souFx%UԵۨ{eٓx/FpۦKtX7RJJ{8\+"ڴta-̒YݟR|ڇhM:ˁInPvTj2Ȑ^m7r#0W?(` k
@xd"'#Z!68E9>|N[;5KW8Uю- ->Oկ,EdP)42F/k{
3Ũ*@[-n̛}3 .@42Xۢ'WT匭k2]գemϖdҐHF;Gm/ иխ!.\
XFL0??4v*sU-DoD\9;̧ܩC m[Xl!>w	-,`Zu٬b_HJ¬qn70FHmygF|͉g+ *wOِ24A|s\`Q-FIUu-vrm#tvd,Q r iǥ&q=Ԓ7ҧ,el+^00~H>Xc-Kln|$vg攀'bF268i}Ĩžn{arnr5ai۵TU07il$x""܀e<FL ;jd-7uY3HmG͸fNcO%ӭcD"UetcqE'z2D66@o#ϓ:5klK=YaT4{
|
&̀j2JkP,3m&_ab M;L=-v3nᾕ9c+aZq1WCEhmr[cs$?4)<;1ěK%@4.-kt3usM&ݪ
{K`e 0nu3)Gb7*`(.~PV$m<,DOG/lB>m2p,r}-nvkR!p+[);ђ 1 [y|ѫ_3bY#
0S(i6d̍(-_6_>gQU]K]g[l7g \-idkEOsu$
[
׳0e2-GOk,% 9Iؑv$_q*qo[ XC\D`~i6UhUL
[,spw  ;O2;SAus ڷ$igVB"}L9~[enXc'huXĿjsY]n`Iތ΍ZtVAU
1)CI .diAl湷<ZZ=`FɼX8@mmN%K],L{%xoNXVa.amZ:|[\fI,)O>ČdmCq&P
}Zbj$Ij;B`n5^dH/L6DEÛLy؍ʘ
0 vտ [O<ngp-p̜"i>KE[%TD*s NdllG'tjؖ{¨hyJMs#Jd5ͽdWRnYg-7GfM  knv,zZbgI+}*rVµpcj22Igov~iHRyv$c#j6Jh\[g.,#Q&MUASp9"Aza".fS̎nTP]\6IxYwUS;_h|ۆd0XIZ-:l1/ڤB%\VWF8Rw$@ccd <?VfĳFCG`PlP[ 9m|($us9l;2o(  [[tӴcn8I^S2g`˃et?$[V,1%7>YK;{J@rσ#PITBVC=Xp79a0 4mڪЪWY
p@@wS2dv#r oaHD$rD#3''Oigf~"*
1Ÿ"" 6%謂0=c>Rf@\҂souFx%UԵۨ{eٓx/FpۦKtX7RJJ{8\+"ڴta-̒YݟR|ڇhM:ˁInPvTj2Ȑ^m7r#0W?(` k
@xd"'#Z!68E9>|N[;5KW8Uю- ->Oկ,EdP)42F:^n C ~
(c5ss|Ms e}TkPyF(hg#p Qf;Wq( &U {\B2A5y"[nbABKmGɹ٤U3q4qb7.E e;jQZhUl{<wE*քwOs"8Ikcg"sED;i-eo."ɘmc  %i܃q_%ѤFtRoi1Q]2(c5ss|Ms e}TkPyF(hg#p Qf;Wq( &U {\B2A5y"[nbABKmGɹ٤U3q4qb7.E e;jQZhUl{<wE*քwOs"8Ikcg"sED;i-eo."ɘmc  %i܃q_%ѤFtRoi1Q]2(c5ss|Ms e}TkPyF(hg#p Qf;Wq( &U {\B2A5y"[nbABKmGɹ٤U3q4qb7.E e;jQZhUl{<wE*քwOs"8Ikcg"sED;i-eo."ɘmc  %i܃q_%ѤFtRoi1Q]2(c5ss|Ms e}TkPyF(hg#p Qf;Wq( &U {\B2A5y"[nbABKmGɹ٤U3q4qb7.E e;jQZhUl{<wE*քwOs"8Ikcg"sED;i-eo."ɘmc  %i܃q_%ѤFtRoi1Q]2(c5ss|Ms e}TkPyF(hg#p Qf;Wq( &U {\B2A5y"[nbABKmGɹ٤U3q4qb7.E e;jQZhUl{<wE*քwOs"8Ikcg"sED;i-eo."ɘmc  %i܃q_%ѤFtRoi1Q]2(c5ss|Ms e}TkPyF(hg#p Qf;Wq( &U {\B2A5y"[nbABKmGɹ٤U3q4qb7.E e;jQZhUl{<wE*քwOs"8Ikcg"sED;i-eo."ɘmc  %i܃q_%ѤFtRoi1Q]2(c5ss|Ms e}TkPyF(hg#p Qf;Wq( &U {\B2A5y"[nbABKmGɹ٤U3q4qb7.E e;jQZhUl{<wE*քwOs"8Ikcg"sED;i-eo."ɘmc  %i܃q_%ѤFtRoi1Q]2(c5ss|Ms e}TkPyF(hg#p Qf;Wq( &U {\B2A5y"[nbABKmGɹ٤U3q4qb7.E e;jQZhUl{<wE*քwOs"8Ikcg"sED;i-eo."ɘmc  %i܃q_%ѤFtRoi1Q]2(c5ss|Ms e}TkPyF(hg#p Qf;Wq( &U {\B2A5y"[nbABKmGɹ٤U3q4qb7.E e;jQZhUl{<wE*քwOs"8Ikcg"sED;i-eo."ɘmc  %i܃q_%ѤFtRoi1Q]2(c5ss|Ms e}TkPyF(hg#p Qf;Wq( &U {\B2A5y"[nbAB '_S  ~>wOB6yR66|v̇_+iO1
ےA
g+2laOt+xˆ8#n._<"Yd ݁Ќ+9YcK98Yd_"hB7PQ 
kK	&亍f6k8H#J~Va	4ybԇ6NPs!1#1A0eq Ii-Ⱥl*oe;\+$_,o8E$Jl'ԵkRM42)Mpr[oE$ ʀOyІdT

6A.]3!Wd=vJFb|yvECkD&
̥e h:;᥎;Hr ;`t#
pgX죎mN(Y#Wȵ!c=TfZIy.YN!Uq||M1}X!ͨyӔ1\Lr0HLkL*o|ZK}mf.
NW
; 8nQI!Ҵ	-ZM;4Ad69`I$6 2nzl!g-mn͐oWozU>m ]$m&q)vA -wNic=(@m³;(S5HU-v HA#q>XE  ִh^Kki#fd=f@!L_w mHysjt W2,`(|1S
[0[YB6SU¸bN0RHt6}KV;n%)$N."Y!d7%RI
۽ާ==hEKpp۹dU2~OGdi<'7nI[D6Ib`]P@y>Ӭho.X㴏q|g-vB0ye}.8e8|]HO3@EFo0H 5,$5Hٮnd k)Y'wR\ڇ9@3̄,C
+Tƹ­%k"M >!Up|3+MRծۉJI4ӳKȤHcc6
mC`*>wOB6yR66|v̇_+iO1
ےA
g+2laOt+xˆ8#n._<"Yd ݁Ќ+9YcK98Yd_"hB7PQ 
kK	&亍f6k8H#J~Va	4ybԇ6NPs!1#1A0eq Ii-Ⱥl*oe;\+$_,o8E$Jl'ԵkRM42)Mpr[oE$ ʀOyІdT

6A.]3!Wd=vJFb|yvECkD&
̥e h:;᥎;Hr ;`t#
pgX죎mN(Y#Wȵ!c=TfZIy.YN!Uq||M1}X!ͨyӔ1\Lr0HLkL*o|ZK}mf.
NW
; 8nQI!Ҵ	-ZM;4Ad69`I$6 2nzl!g-mn͐oWozU>m ]$m&q)vA -wNic=(@m³;(S5HU-v HA#q>XE  ִh^Kki#fd=f@!L_w mHysjt W2,`(|1S
[0[YB6SU¸bN0RHt6}KV;n%)$N."Y!d7%RI
۽ާ==hEKpp۹dU2~OGdi<'7nI[D6Ib`]P@y>Ӭho.X㴏q|g-vB0ye}.8e8|]HO3@EFo0H 5,$5Hٮnd k)Y'wR\ڇ9@3̄,C
+Tƹ­%k"M >!Up|3+MRծۉJI4ӳKȤHcc6
mC`*>wOB6yR66|v̇_+iO1
ےA
g+2laOt+xˆ8#n._<"Yd ݁Ќ+9YcK98Yd_"hB7PQ 
kK	&亍f6k8H#J~Va	4ybԇ6NPs!1#1A0eq Ii-Ⱥl*oe;\+$_,o8E$Jl'ԵkRM42)Mpr[oE$ ʀOyІdT

6A.]3!Wd=vJFb|yvECkD&
̥e h:;᥎;Hr ;`t#
s7 	lNgC̞S,l>Vn(:uW7V7:G?fvUl)7
AL'`*h1cI&nˈLU
dDd݃4+]*ʱH~*9~w-P
7x,kd\\(1Fw,N&"]VbXC[\,|ƥ6~XiŜ	Y-QIaS孴\H,b% 25\䊩iP5E2b`XdP3(ܧrgp<.dG(_caqGiè"J>4~kaNnJe;S@ͽRMpu64v\E`"XS$*#$$dZVϾHUZC&$o!WqpnbPԵgEcX ̟88pF@3fq7ͦ궋Mdx;5,KƿH,OmK
-m
Fd(r$UOOjU)$pZ)c2%FW~;c
O<w3'9B; NAյίzQ8٣]l
v
pGbS(I
 Xmkɶ9۲(rm!Q 'w`k&
Jo&}6Ej5#y
_p=-7ędqÀ
62Q6m7ȗUXlW#Ŀ1$1e
_5D1g }VKh/mRXTkm m6 g@-̀C9"}}kT:Mt#L1-2)j},,6˹<X| QZunnu{ҏ~`Sn<3E*NTbsou=ԓ\nM6ݗF+l
I?3;_0hVUy73﹵-cVɮ	Ur[5-E/YoehX$3'#Q0bYMiDpbY%%K(m$!8[A}>j§[hnY8JndDjSZuk	d0o,fQ߹N S$fya>]0P2i Ө/PEsumssޔ}N#he[p$ᘔ)Rv3;{rmi츊4E\[`HTFH*I9ɃBҭ/ɹ}ͮlMpHB~"< j)zs{(GƱ&A>qp5gr̈́oM%m+5/w.jYCnv!Y UT>Z@uč"Ps *#PHfZS] HS!(eKye2w my'3
fO)r6+H7w VA|:+k^qG*6 ĦQJ4Ou$[lsMeQ*2B2AROLi~MmteXդ?rkFw;(
KQK{DZ<n52.ld;l'|o.h\,!خG~cIpcRt,kb_Oڤ ۮ$l@1[Q.rET4֨u]mG1F0c,2[(ewS9 m8YXms2yL#/̱ZA\[\S?5V`7	xf%2TŎ{&:ܛcm."0W,V)
~gvv`ЭtKngsk[*ƭ!\7߸1@(jZ^"pIfOG8
qpc `ܳa8|u[Ea
op<KKPۥc_ݤHCp'd}F%Oq#`q
9s*٧ֵCoH8-a1aY@̣+r 1mIh|a~e
 էP_W(Gʶ
;H#1)RM f,w6SI5mqibLT;skZ_s>]"V5iܚ]/EyCRRQbL2|8k(	6K,Wk}6+_\Բ/"BA>%6,*|63D@TF˜U>>W[x@hCQe]@5>lNgC̞S,l>Vn(:uW7V7:G?fvUl)7
AL'`*h1cI&nˈLU
dDd݃4+]*ʱH~*9~w-P
7x,kd\\(1Fw,N&"]VbXC[\,|ƥ6~XiŜ	Y-QIaS孴\H,b% 25\䊩iP5E2b`XdP3(ܧrgp<.dG(_caqGiè"J>4~kaNnJe;S@ͽRMpu64v\E`"XS$*#$$u Q t \][ya4?/yTQEwh7!]<Af.qHcs.I- <4V4m͵'ׯMb]Dv*K;,{f@f4 esO70wvTUD#I̘	@fu}"PbSm'#2˫[ e_9n&+l(4>䂉 mxKnY6(GFğt3T	uD[c:G	v@H<|Fː][ya4?/yTQEwh7!]<Af.qHcs.I- <4V4m͵'ׯMb]Dv*K;,{f@f4 esO70wvTUD#I̘	@fu}"PbSm'#2˫[ e_9n&+l(4>䂉 mxKnY6(GFğt3T	uD[c:G	v@H<|Fː][ya4?/yTQEwh7!]<Af.qHcs.I- <4V4m͵'ׯMb]Dv*K;,{f@f4 esO70wvTUD#I̘	@fu}"PbSm'#2˫[ e_9n&+l(4>䂉 mxKnY6(GFğt3T	uD[c:G	v@H<|Fː][ya4?/yTQEwh7!]<Af.qHcs.I- <4V4m͵'ׯMb]Dv*K;,{f@f4 esO70wvTUD#I̘	@fu}"PbSm'#2˫[ e_9n&+l(4>䂉 mxKnY6(GFğt3T	uD[c:G	v@H<|Fː][ya4?/yTQEwh7!]<Af.qHcs.I- <4V4m͵'ׯMb]Dv*K;,{f@f4 esO70wvTUD#I̘	@fu}"PbSm'#2˫[ e_9n&+l(4>䂉 mxKnY6(GFğt3T	uD[c:G	v@H<|Fː][ya4?/yTQEwh7!]<Af.qHcs.I- <4V4m͵'ׯMb]Dv*K;,{f@f4 esO70wvTUD#I̘	@fu}"PbSm'#2˫[ e_9n&+l(4>䂉 mxKnY6(GFğt3T	uD[c:G	v@H<|Fː][ya4?/yTQEwh7!]<Af.qHcs.I- <4V4m͵'ׯMb]Dv*K;,{f@f4 esO70wvTUD#I̘	@fu}"PbSm'#2˫[ e_9n&+l(4>䂉 mxKnY6(GFğt3T	uD[c:G	v@H<|Fː][ya4?/yTQEwh7!]<Af.qHcs.I- <4V4m͵'ׯMb]Dv*K;,{f@f4 esO70wvTUD#I̘	@fu}"PbSm'#2˫[ e_9n&+l(4>䂉 mxKnY6(GFğt3T	uD[c:G	v@H<|Fː][ya4?/yTQEwh7!]<Af.qHcs.I- <4V4m͵'ׯMb]Dv*K;,{f@f4 esO70wvTUD#I̘	@fu}"PbSm'#2˫[ e_9n&+l(4>䂉 mxKnY6(GFğt3T	uD[c:G	v@H<|Fː][ya4?/yTQEwh7!]<Af.qHcs.I- <4V4m͵'ׯMb]Dv*K;,{f@d۞"  	L
c(eFGNP󶃾LʶYK;nkA7Ti:Nd6Fr}K(%Dm *EjzOkQ3NNȾW#3pJOjt%oeu]!a$om
|~󜟐,gks1[G#ىr̬-ayQث[EKHeyL(L{x]ғj@-ĉg,]pI(T	FeٷA#=գ}	<Ngw g
~3* c(eFGNP󶃾LʶYK;nkA7Ti:Nd6Fr}K(%Dm *EjzOkQ3NNȾW#3pJOjt%oeu]!a$om
|~󜟐,gks1[G#ىr̬-ayQث[EKHeyL(L{x]ғj@-ĉg,]pI(T	FeٷA#=գ}	<Ngw g
~3* c(eFGNP󶃾LʶYK;nkA7Ti:Nd6Fr}K(%Dm *EjzOkQ3NNȾW#3pJOjt%oeu]!a$om
|~󜟐,gks1[G#ىr̬-ayQث[EKHeyL(L{x]ғj@-ĉg,]pI(T	FeٷA#=գ}	<Ngw g
~3* c(eFGNP󶃾LʶYK;nkA7Ti:Nd6Fr}K(%Dm *EjzOkQ3NNȾW#3pJOjt%oeu]!a$om
|~󜟐,gks1[G#ىr̬-ayQث[EKHeyL(L{x]ғj@-ĉg,]pI(T	FeٷA#=գ}	<Ngw g
~3* c(eFGNP󶃾LʶYK;nkA7Ti:Nd6Fr}K(%Dm *EjzOkQ3NNȾW#3pJOjt%oeu]!a$om
|~󜟐,gks1[G#ىr̬-ayQث[EKHeyL(L{x]ғj@-ĉg,]pI(T	FeٷA#=գ}	<Ngw g
~3* c(eFGNP󶃾LʶYK;nkA7Ti:Nd6Fr}K(%Dm *EjzOkQ3NNȾW#3pJOjt%oeu]!a$om
|~󜟐,gks1[G#ىr̬-ayQث[EKHeyL(L{x]ғj@-ĉg,]pI(T	FeٷA#=գ}	<Ngw g
~3* c(eFGNP󶃾LʶYK;nkA7Ti:Nd6Fr}K(%Dm *EjzOkQ3NNȾW#3pJOjt%oeu]!a$om
|~󜟐,gks1[G#ىr̬-ayQث[EKHeyL(L{x]ғj@-ĉg,]pI(T	FeٷA#=գ}	<Ngw g
~3* c(eFGNP󶃾LʶYK;nkA7Ti:Nd6Fr}K(%Dm *EjzOkQ3NNȾW#3pJOjt%oeu]!a$om
|~󜟐,gks1[G#ىr̬-ayQث[EKHeyL(L{x]ғj@-ĉg,]pI(T	FeٷA#=գ}	<Ngw g
~3* c(eFGNP󶃾LʶYK;nkA7Ti:Nd6Fr}K(%Dm *EjzOkQ3NNȾW#3pJOjt%oeu]!a$om
|~󜟐,gks1[G#ىr̬-ayQث[EKHeyL(L{x]ғj@-ĉg,]pI(T	FeٷA#=գ}	<Ngw g
~3* c(eFGNP󶃾LʶYK;nkA7Ti:Nd6Fr}K(%Dm *EjzOkQ3NNȾW#3pJvA wP\  qqYAdW
4dP;r61U!"3&⍵ݍNkt{}-H[3q7J f0h
tRy匰y
ĘWT.0;WuvvF\_,LjDg~B+.x  [4Phn"	5TlpIH T[ȯi'8?>Q&pIr
PR]iO]JNC-h}hC1T	{prFh#;B<m1rb;k(,F.Fڦ8S#t#/$FdQ[Mno9Xeitc4	R  ].*Y}/20a *ʅ֊NB#YEeݼ yjQM
A#* ) 
`XPt=72~$N	.YU*
KA>	+II}yŢ-^663 f;A/nHݣܲ$vhV?g>R3>@N@,Gme^(ёB7T
dnWs̛6v5;iG+M"npqƘ!*XC0\7eӥK/E__27 bE^T9P6^i1HDaq11!\o<
B)t$`׳QqX`% S,
n7Cg"VoМD%0*@!Ith1>w	)9/8E ZF}uS%ZY{YD
F|"b	{ۅ2(FjLӪ|qFnƧm5\=aS-8%K3hw4vLterX<bLHʇ*fZ+:;{\[i#w`./f&5d"3!v KB-a]E47sp6n8$ *e`AB-HldW\~c(q8$fT).4X'Ԯ%'!r>{KHϴuKK9#vr4h۝X6HϘDTU9 Ou{pFEc#mS)u_ϗ#2n([-K24e]1c|bc m.piN,}~X0܀LIyPBEyXowkm!nƬFw"W	pEL5} ^FadL,(Z\I
ZOݿBsen', %ѠƟk$>ؼGiiT3N	ig$nYf;s+)' #nhȡwmc27N9BDfMkep#[LKf8Lo,@`
.2ҥ"/`	1"*\a}h4qm"0݀YՐV].iuϺD0k¨ٸ,0 \K!ё^qs+INp~}MR4`RZ"-#cc>
c-,=,ѢGnvcx#>cP1TvPY=#y\LpF~G>_HɸmlcS.Drt)wi; c}]:TD^e9c,`r1&$UC3ocݮ-FK3ߐ˻y^ %!0.HF
{8U7R 2 ksy$6z2+n.ei?v	ϱI\TF}WpbDZ9ollgPwU:^%Ge4HЬ~`|g|"**X'Q"o1ˑ:	7mjv[VnE2.1BT16s@l`o˧J_h̾g,en@&$ĊrqmӬcŶ7v ifbcVB#;Ywo+"ySCw>Hg
f〰2J@X-r.o$FE{M̭'ߡ927K`UJBcO}JRrl^qhG# W@*PKۄ7h,FlE@PYAdW
4dP;r61U!"3&⍵ݍNkt{}-H[3q7J f0h
tRy匰y
ĘWT.0;WuvvF\_,LjDg~B+.x  [4Phn"	5TlpIH T[ȯi'8?>Q&pIr
PR]iO]JNC-h}hC1T	{prFh#;B<m1rb;k(,F.Fڦ8S#t#/$FdQ[Mno9Xeitc4	R  ].*Y}/20a *ʅ-' 
2E>!j)#C!bL9`  f;]Է1A%Qx䐃!ºh[ǳtYyLj3 T8PA`7\uI-4MÒ#{iXcrd$#N]
JKw#6l'*Dve
GIb
B{KM5--x0b<V(ĥ ䷎]V[-VNkm
$r'! P0E4vQԕ$ĖJNb PcllԐ	Q|C$7_RGfa}Bܙfr,@v+ocQ4+m9aK7!CuVKkxg.ffB4p#1b#O1d3]<nZiqnɇ$FҰI	 F@&ƗtwGmŢ4NU$,ekGu([&[ `;FDy QKo[ʭk&[bہ`HNB aȊiltk*I+!,-604  Hny 2w<2XtWRyhVr1F#CoB
	
o]e2ͨiPF2cUBFcH	gx<q$7Haɒ@:Mwkx5+.Ď<ۋD>iIY6e3%5	-4֎PL8 =vAX+/9u[l[=:Mŷ+l4CcÑFRTVCX[0-*la;iCG#R@'-GY~QI@eyre  1讥
F'HЭ,bF+$X@/=eQҡdƪ<Ɛewo4yIiźo&3J$	$$u jW]ӽ߉y|g9W#(m?xgKjZiԡlql {0䂱FV%._ /%ro*zu]mnV#i9Ǚ")ҍ$$`ZTw|+g{dFO$Z!梒;40 .3b c]KsN[iXWI2+&*_O[ſ{9wO60
CɍUy $!iuTKtL9"7f7&HHI45ݭԮ4{8n-2ry$GifP-~$ 'Z;B0,  a6*#bJ\@,^KxoUlY6 G,r
3DSKgk]IRIYIal9 
V6ȍI Hg2CuE$vha۹,@]ɖg, ,k;5#BӖd0 #|d8WU`M Tr+/)mF`#J1"4@H,C=ݼ뎩%鼘rDop0+nL$ik[\iwN~$qZ!Md^H̡[(>I,AOiiwR`YŰ ôlTG
X~X˪Keֲmu-[dY 
fJ6فiS`s	L@
<m<j:ψdH,/sX,X 0YEu-wj1:Fm,>c`249^ F$ p }<-o 1<V^S,ڌ(Fc&5T,Di4X,{+yRKM.-y0aVܙ I!$ӨvRH͸C8ʽClQ<|XPMhd`hب$2)p21  y-UyUӭdl[p,I@6<9M-mu%I%d1%Ҧ昀4yX;"5$y"u
5١X_n琱w&Y `[ bt
NX}(dhr HA]U4RxZ-c˺xYP*LjXi YWvO:\[a412@BHP	oq;Ǜqh6q{";K2lx$=JɁgѱQH+ebReb Ab[.}-gZɵضXm9f(lyr"[;](JJbKfM'w1 (hwDjHE>!j)#C!bL9`  f;]Է1A%Qx䐃!ºh[ǳtYyLj3 T8PA`7\uI-4MÒ#{iXcrd$#N]
JKw#6l'*Dve
GIb
B{KM5--x0b<V(ĥ ䷎]V[-VNkm
$r'! P0E4vQԕ$ĖJNb PcllԐ	Q|C$7_RGfa}Bܙfr,@v+ocQ4+m9aK7!CuVKkxg.ffB4p#1b#O1 ڷ$igVB"}L9~[enXc'huXĿjsY]n`Iތ΍ZtVAU
1)CI .diAl湷<ZZ=`FɼX8@mmN%K],L{%xoNXVa.amZ:|[\fI,)O>ČdmCq&P
}Zbj$Ij;B`n5^dH/L6DEÛLy؍ʘ
0 vտ [O<ngp-p̜"i>KE[%TD*s NdllG'tjؖ{¨hyJMs#Jd5ͽdWRnYg-7GfM  knv,zZbgI+}*rVµpcj22Igov~iHRyv$c#j6Jh\[g.,#Q&MUASp9"Aza".fS̎nTP]\6IxYwUS;_h|ۆd0XIZ-:l1/ڤB%\VWF8Rw$@ccd <?VfĳFCG`PlP[ 9m|($us9l;2o(  [[tӴcn8I^S2g`˃et?$[V,1%7>YK;{J@rσ#PITBVC=Xp79a0 4mڪЪWY
p@@wS2dv#r oaHD$rD#3''Oigf~"*
1Ÿ"" 6%謂0=c>Rf@\҂souFx%UԵۨ{eٓx/FpۦKtX7RJJ{8\+"ڴta-̒YݟR|ڇhM:ˁInPvTj2Ȑ^m7r#0W?(` k
@xd"'#Z!68E9>|N[;5KW8Uю- ->Oկ,EdP)42F/k{
3Ũ*@[-n̛}3 .@42Xۢ'WT匭k2]գemϖdҐHF;Gm/ иխ!.\
XFL0??4v*sU-DoD\9;̧ܩC m[Xl!>w	-,`Zu٬b_HJ¬qn70FHmygF|͉g+ *wOِ24A|s\`Q-FIUu-vrm#tvd,Q r iǥ&q=Ԓ7ҧ,el+^00~H>Xc-Kln|$vg攀'bF268i}Ĩžn{arnr5ai۵TU07il$x""܀e<FL ;jd-7uY3HmG͸fNcO%ӭcD"UetcqE'z2D66@o#ϓ:5klK=YaT4{
|
&̀j2JkP,3m&_ab M;L=-v3nᾕ9c+aZq1WCEhmr[cs$?4)<;1ěK%@4.-kt3usM&ݪ
{K`e 0nu3)Gb7*`(.~PV$m<,DOG/lB>m2p,r}-nvkR!p+[);ђ 1 [y|ѫ_3bY#
0S(i6d̍(-_6_>gQU]K]g[l7g \-idkEOsu$
[
׳0e2-GOk,% 9Iؑv$_q*qo[ XC\D`~i6UhUL
[,spw  ;O2;SAus ڷ$igVB"}L9~[enXc'huXĿjsY]n`Iތ΍ZtVAU
1)CI .diAl湷<ZZ=`FɼX8@mmN%K],L{%xoNXVa.amZ:|[\fI,)O>ČdmCq&P
}Zbj$Ij;B`n5^dH/L6DEÛLy؍ʘ
0 vտ [O<ngp-p̜"i>KE[%TD*s NdllG'tjؖ{¨hyJMs#Jd/7[ F ZO1t̹\m&์ 2*JյV<#K[D4Q38 (³ O]=h!F w<
-QZL71D}ʡl%gxVdsgl*ʸC˸
1aW"2KD4*ζZ=sFz"ƀ`UUbB;V'aO]$ȱ@r
񁹌d
W27IsdMʶ ɴA#|:)qfYnP`_wU 1t̹\m&์ 2*JյV<#K[D4Q38 (³ O]=h!F w<
-QZL71D}ʡl%gxVdsgl*ʸC˸
1aW"2KD4*ζZ=sFz"ƀ`UUbB;V'aO]$ȱ@r
񁹌d
W27IsdMʶ ɴA#|:)qfYnP`_wU 1t̹\m&์ 2*JյV<#K[D4Q38 (³ O]=h!F w<
-QZL71D}ʡl%gxVdsgl*ʸC˸
1aW"2KD4*ζZ=sFz"ƀ`UUbB;V'aO]$ȱ@r
񁹌d
W27IsdMʶ ɴA#|:)qfYnP`_wU 1t̹\m&์ 2*JյV<#K[D4Q38 (³ O]=h!F w<
-QZL71D}ʡl%gxVdsgl*ʸC˸
1aW"2KD4*ζZ=sFz"ƀ`UUbB;V'aO]$ȱ@r
񁹌d
W27IsdMʶ ɴA#|:)qfYnP`_wU 1t̹\m&์ 2*JյV<#K[D4Q38 (³ O]=h!F w<
-QZL71D}ʡl%gxVdsgl*ʸC˸
1aW"2KD4*ζZ=sFz"ƀ`UUbB;V'aO]$ȱ@r
񁹌d
W27IsdMʶ ɴA#|:)qfYnP`_wU 1t̹\m&์ 2*JյV<#K[D4Q38 (³ O]=h!F w<
-QZL71D}ʡl%gxVdsgl*ʸC˸
1aW"2KD4*ζZ=sFz"ƀ`UUbB;V'aO]$ȱ@r
񁹌d
W27IsdMʶ ɴA#|:)qfYnP`_wU 1t̹\m&์ 2*JյV<#K[D4Q38 (³ O]=h!F w<
-QZL71D}ʡl%gxVdsgl*ʸC˸
1aW"2KD4*ζZ=sFz"ƀ`UUbB;V'aO]$ȱ@r
񁹌d
W27IsdMʶ ɴA#|:)qfYnP`_wU 1t̹\m&์ 2*JյV<#K[D4Q38 (³ O]=h!F w<
-QZL71D}ʡl%gxVdsgl*ʸC˸
1aW"2KD4*ζZ=sFz"ƀ`UUbB;V'aO]$ȱ@r
񁹌d
W27IsdMʶ ɴA#|:)qfYnP`_wU 1t̹\m&์ 2*JյV<#K[D4Q38 (³ O]=h!F w<
-QZL71D}ʡl%gxVdsgl*ʸC˸
1aW"2KD4*ζZ=sFz"ƀ`UUbB;V'aO]$ȱ@r
񁹌d
W27IsdMʶ ɴA#|:)qfYnP`_wU 1t̹\m&์ 2*JյV<#K[D4Q38 (³ O]=h!F w<
-QZL71D}ʡt~)  P? [wg
<ȩnnw>lx]ʻxfCү{h앴' h։3LK0 o'úuv

Kv7/@, vnF,ϥGڜQGk!B	z(	 B]F[I5̜C$p%?t0bjC˛P(bacC` U8$d]6	2v/7pܢCiZq)I&viuls&9-Hl e@'<CF2*[ۆϛ rw2};%m#I1>rH"!LfR2 4[eoCyp{P9l۰:g83,wsvQ6k,Z@F|*3y@ia$мQFss'{\	O*8>C&,@ڐ<d&9bXPX$b5&l>`	-%YMBmbpĝ a7(ZmtvJRI]FE CɰnKm褒 P	{O6zzѳ̊s7ܫd=*̟g[HyOo.ܒmh8Yc
|;Y[`\4iqr[ `6aY]qͩ$p*B$ ,g` kZXI4/%k5\2ASJ O/6<:rf+	X0>V	r	[-KIoE`!Px@|C)ت\1'bcyg
)$:Va>]ifQH,2lz)$T}mS͞4l"mm
w*Jws'V4c˷$-Z$10Ve.( EV47
,qG\xE 
Vs<w>esjqF
EЄ	$n'"7$ ֖Mum$l72qGҬÈ;i
.mCΜBc!F*c\aV| [k5tT&v*WIؾXprIOjGmĥ$i٥dR$1̛ފI! [wg
<ȩnnw>lx]ʻxfCү{h앴' h։3LK0 o'úuv

Kv7/@, vnF,ϥGڜQGk!B	z(	 B]F[I5̜C$p%?t0bjC˛P(bacC` U8$d]6	2v/7pܢCiZq)I&viuls&9-Hl e@'<CF2*[ۆϛ rw2};%m#I1>rH"!LfR2 4[eoCyp{P9l۰:g83,wsvQ6k,Z@F|*3y@ia$мQFss'{\	O*8>C&,@ڐ<d&9bXPX$b5&l>`	-%YMBmbpĝ a7(ZmtvJRI]FE CɰnKm褒 P	{O6zzѳ̊s7ܫd=*̟g[HyOo.ܒmh8Yc
|;Y[`\4iqr[ `6aY]qͩ$p*B$ ,g` kZXI4/%k5\2ASJ O/6<:rf+	X0>V	r	[-KIoE`!Px@|C)ت\1'bcyg
)$:Va>]ifQH,2lz)$T}mS͞4l"mm
w*Jws'V4c˷$-Z$10Ve.( EV47
,qG\xE 
Vs<w>esjqF
EЄ	$n'"7$ ֖Mum$l72qGҬÈ;i
.mCΜBc!F*c\aV| [k5tT&v*WIؾXprIOjGmĥ$i٥dR$1̛ފI! [wg
<ȩnnw>lx]ʻxfCү{h앴' h։3LK0 o'úuv

Kv7/@, vnF,ϥGڜQGk!B	z(	 B]F[I5̜C$p%?t0bjC˛P(bacC` U8$d]6	2v/7pܢCiZq)I&viuls&9-Hl e@'<CF2*[ۆϛ rw2};%m#I1>rH"!LfR2 4[eoCyp{P9l۰:g9lWz my'3
fO)r6+H7w VA|:+k^qG*6 ĦQJ4Ou$[lsMeQ*2B2AROLi~MmteXդ?rkFw;(
KQK{DZ<n52.ld;l'|o.h\,!خG~cIpcRt,kb_Oڤ ۮ$l@1[Q.rET4֨u]mG1F0c,2[(ewS9 m8YXms2yL#/̱ZA\[\S?5V`7	xf%2TŎ{&:ܛcm."0W,V)
~gvv`ЭtKngsk[*ƭ!\7߸1@(jZ^"pIfOG8
qpc `ܳa8|u[Ea
op<KKPۥc_ݤHCp'd}F%Oq#`q
9s*٧ֵCoH8-a1aY@̣+r 1mIh|a~e
 էP_W(Gʶ
;H#1)RM f,w6SI5mqibLT;skZ_s>]"V5iܚ]/EyCRRQbL2|8k(	6K,Wk}6+_\Բ/"BA>%6,*|63D@TF˜U>>W[x@hCQe]@5>lNgC̞S,l>Vn(:uW7V7:G?fvUl)7
AL'`*h1cI&nˈLU
dDd݃4+]*ʱH~*9~w-P
7x,kd\\(1Fw,N&"]VbXC[\,|ƥ6~XiŜ	Y-QIaS孴\H,b% 25\䊩iP5E2b`XdP3(ܧrgp<.dG(_caqGiè"J>4~kaNnJe;S@ͽRMpu64v\E`"XS$*#$$dZVϾHUZC&$o!WqpnbPԵgEcX ̟88pF@3fq7ͦ궋Mdx;5,KƿH,OmK
-m
Fd(r$UOOjU)$pZ)c2%FW~;c
O<w3'9B; NAյίzQ8٣]l
v
pGbS(I
 Xmkɶ9۲(rm!Q 'w`k&
Jo&}6Ej5#y
_p=-7ędqÀ
62Q6m7ȗUXlW#Ŀ1$1e
_5D1g }VKh/mRXTkm m6 g@-̀C9"}}kT:Mt#L1-2)j},,6˹<X| QZunnu{ҏ~`Sn<3E*NTbsou=ԓ\nM6ݗF+l
I?3;_0hVUy73﹵-cVɮ	Ur[5-E/YoehX$3'#Q0bYMiDpbY%%K(m$!8[A}>j§[hnY8JndDjSZuk	d0o,fQ߹N S$fya>]0P2i Ө/PEsumssޔ}N#he[p$ᘔ)Rv3;{rmi츊4E\[`HTFH*I9ɃBҭ/ɹ}ͮlMpHB~"< j)zs{(GƱ&A>qp5gr̈́oM%m+5/w.jYCnv!Y UT>Z@uč"Ps *#PHfZS] HS!(eKye2w my'3
fO)r6+H7w VA|:+k^qG*6 ĦQJ4Ou$[lsMeQ*2B2AROLi~MmteXդ?rkFw;(
KQK{DZ<n52.ld;l'|o.h\,!خG~cIpcRt,kb_Oڤ ۮ$l@1[Q.rET4֨u]mG1F0c,2[(ewS9 m8YXms2yL#/̱ZA\[\S?5V`7	xf%2TŎ{&:ܛcm."0W,V)
~gvn|A (  ..0}zy<ͪ(dr4fL Z~F8V$	1$ `+pdwWfړk׎Qi.;qi%= a{9猛Cnw**"Sّ$fL
x:>`Vf(yPyXembE 2݇Y@^iYADw {IWKC,mEIq##HwbO*H-Kq#gx E$>Hn.0}zy<ͪ(dr4fL Z~F8V$	1$ `+pdwWfړk׎Qi.;qi%= a{9猛Cnw**"Sّ$fL
x:>`Vf(yPyXembE 2݇Y@^iYADw {IWKC,mEIq##HwbO*H-Kq#gx E$>Hn.0}zy<ͪ(dr4fL Z~F8V$	1$ `+pdwWfړk׎Qi.;qi%= a{9猛Cnw**"Sّ$fL
x:>`Vf(yPyXembE 2݇Y@^iYADw {IWKC,mEIq##HwbO*H-Kq#gx E$>Hn.0}zy<ͪ(dr4fL Z~F8V$	1$ `+pdwWfړk׎Qi.;qi%= a{9猛Cnw**"Sّ$fL
x:>`Vf(yPyXembE 2݇Y@^iYADw {IWKC,mEIq##HwbO*H-Kq#gx E$>Hn.0}zy<ͪ(dr4fL Z~F8V$	1$ `+pdwWfړk׎Qi.;qi%= a{9猛Cnw**"Sّ$fL
x:>`Vf(yPyXembE 2݇Y@^iYADw {IWKC,mEIq##HwbO*H-Kq#gx E$>Hn.0}zy<ͪ(dr4fL Z~F8V$	1$ `+pdwWfړk׎Qi.;qi%= a{9猛Cnw**"Sّ$fL
x:>`Vf(yPyXembE 2݇Y@^iYADw {IWKC,mEIq##HwbO*H-Kq#gx E$>Hn.0}zy<ͪ(dr4fL Z~F8V$	1$ `+pdwWfړk׎Qi.;qi%= a{9猛Cnw**"Sّ$fL
x:>`Vf(yPyXembE 2݇Y@^iYADw {IWKC,mEIq##HwbO*H-Kq#gx E$>Hn.0}zy<ͪ(dr4fL Z~F8V$	1$ `+pdwWfړk׎Qi.;qi%= a{9猛Cnw**"Sّ$fL
x:>`Vf(yPyXembE 2݇Y@^iYADw {IWKC,mEIq##HwbO*H-Kq#gx E$>Hn.0}zy<ͪ(dr4fL Z~F8V$	1$ `+pdwWfړk׎Qi.;qi%= a{9猛Cnw**"Sّ$fL
x:>`Vf(yPyXembE 2݇Y@^iYADw {IWKC,mEIq##HwbO*H-Kq#gx E$>Hn.0}zy<ͪ(dr4fL Z~F8V$	1$ `+pdwWfړk׎Qi.;qi%= aOq  &P[hౌLe2am#'Ga(
A&
@[m},ŝ5*4'Ko2uhyG#9Y>6 "n=
n'5˨{mqAi|'d_x+̅摙8%U:nm7ں{E>v?tyOz`
3syNw]9fVa0ѼU"Ť2PZ@|`.II ؍bDږvi.By$*AwA#2۠ѾkU'` 3ʀ3m?
 KhౌLe2am#'Ga(
A&
@[m},ŝ5*4'Ko2uhyG#9Y>6 "n=
n'5˨{mqAi|'d_x+̅摙8%U:nm7ں{E>v?tyOz`
3syNw]9fVa0ѼU"Ť2PZ@|`.II ؍bDږvi.By$*AwA#2۠ѾkU'` 3ʀ3m?
 KhౌLe2am#'Ga(
A&
@[m},ŝ5*4'Ko2uhyG#9Y>6 "n=
n'5˨{mqAi|'d_x+̅摙8%U:nm7ں{E>v?tyOz`
3syNw]9fVa0ѼU"Ť2PZ@|`.II ؍bDږvi.By$*AwA#2۠ѾkU'` 3ʀ3m?
 KhౌLe2am#'Ga(
A&
@[m},ŝ5*4'Ko2uhyG#9Y>6 "n=
n'5˨{mqAi|'d_x+̅摙8%U:nm7ں{E>v?tyOz`
3syNw]9fVa0ѼU"Ť2PZ@|`.II ؍bDږvi.By$*AwA#2۠ѾkU'` 3ʀ3m?
 KhౌLe2am#'Ga(
A&
@[m},ŝ5*4'Ko2uhyG#9Y>6 "n=
n'5˨{mqAi|'d_x+̅摙8%U:nm7ں{E>v?tyOz`
3syNw]9fVa0ѼU"Ť2PZ@|`.II ؍bDږvi.By$*AwA#2۠ѾkU'` 3ʀ3m?
 KhౌLe2am#'Ga(
A&
@[m},ŝ5*4'Ko2uhyG#9Y>6 "n=
n'5˨{mqAi|'d_x+̅摙8%U:nm7ں{E>v?tyOz`
3syNw]9fVa0ѼU"Ť2PZ@|`.II ؍bDږvi.By$*AwA#2۠ѾkU'` 3ʀ3m?
 KhౌLe2am#'Ga(
A&
@[m},ŝ5*4'Ko2uhyG#9Y>6 "n=
n'5˨{mqAi|'d_x+̅摙8%U:nm7ں{E>v?tyOz`
3syNw]9fVa0ѼU"Ť2PZ@|`.II ؍bDږvi.By$*AwA#2۠ѾkU'` 3ʀ3m?
 KhౌLe2am#'Ga(
A&
@[m},ŝ5*4'Ko2uhyG#9Y>6 "n=
n'5˨{mqAi|'d_x+̅摙8%U:nm7ں{E>v?tyOz`
3syNw]9fVa0ѼU"Ť2PZ@|`.II ؍bDږvi.By$*AwA#2۠ѾkU'` 3ʀ3m?
 KhౌLe2am#'Ga(
A&
@[m},ŝ5*4'Ko2uhyG#9Y>6 "n=
n'5˨{mqAi|'d_x+̅摙8%U:nm7ں{E>v?tyOz`
3syNw]9fVa0ѼU"Ť2PZ@|`.II ؍bDږvi.By$*AwA#2۠ѾkU'` 3ʀ3m?
 KhౌLe2am#'Ga(
A&
@[m},ŝ5*4'Ko2uhyG#9Y>6 "n=
n'5˨{mqAi|'d_x+̅摙8%UOG~  ;(.ƀ8{ۅ2(FjLӪ|qFnƧm5\=aS-8%K3hw4vLterX<bLHʇ*fZ+:;{\[i#w`./f&5d"3!v KB-a]E47sp6n8$ *e`AB-HldW\~c(q8$fT).4X'Ԯ%'!r>{KHϴuKK9#vr4h۝X6HϘDTU9 Ou{pFEc#mS)u_ϗ#2n([-K24e]1c|bc m.piN,}~X0܀LIyPBEyXowkm!nƬFw"W	pEL5} ^FadL,(Z\I
ZOݿBsen', %ѠƟk$>ؼGiiT3N	ig$nYf;s+)' #nhȡwmc27N9BDfMkep#[LKf8Lo,@`
.2ҥ"/`	1"*\a}h4qm"0݀YՐV].iuϺD0k¨ٸ,0 \K!ё^qs+INp~}MR4`RZ"-#cc>
c-,=,ѢGnvcx#>cP1TvPY=#y\LpF~G>_HɸmlcS.Drt)wi; c}]:TD^e9c,`r1&$UC3ocݮ-FK3ߐ˻y^ %!0.HF
{8U7R 2 ksy$6z2+n.ei?v	ϱI\TF}WpbDZ9ollgPwU:^%Ge4HЬ~`|g|"**X'Q"o1ˑ:	7mjv[VnE2.1BT16s@l`o˧J_h̾g,en@&$ĊrqmӬcŶ7v ifbcVB#;Ywo+"ySCw>Hg
f〰2J@X-r.o$FE{M̭'ߡ927K`UJBcO}JRrl^qhG# W@*PKۄ7h,FlE@PYAdW
4dP;r61U!"3&⍵ݍNkt{}-H[3q7J f0h
tRy匰y
ĘWT.0;WuvvF\_,LjDg~B+.x  [4Phn"	5TlpIH T[ȯi'8?>Q&pIr
PR]iO]JNC-h}hC1T	{prFh#;B<m1rb;k(,F.Fڦ8S#t#/$FdQ[Mno9Xeitc4	R  ].*Y}/20a *ʅ֊NB#YEeݼ yjQM
A#* ) 
`XPt=72~$N	.YU*
KA>	+II}yŢ-^663 f;A/nHݣܲ$vhV?g>R3>@N@,Gme^(ёB7T
dnWs̛6v5;iG+M"npqƘ!*XC0\7eӥK/E__27 bE^T9P6^i1HDaq11!\o<
B)t$`׳QqX`% S,
n7Cg"VoМD%0*@!Ith1>w	)9/8E ZF}uS%ZY{YD
F|"b	{ۅ2(FjLӪ|qFnƧm5\=aS-8%K3hw4vLterX<bLHʇ*fZ+:;{\[i#w`./f&5d"3!v KB-a]E47sp6n8$ *e`AB-HldW\~c(q8$fT).4X'Ԯ%'!r>{KHϴuKK9#vr4h۝X6HϘDTU9 Ou{pFEc#mS)u_ϗ#2n([-K24e]1c|bc m.piN,}~X0܀LIyPB Er  P"u
5١X_n琱w&Y `[ bt
NX}(dhr HA]U4RxZ-c˺xYP*LjXi YWvO:\[a412@BHP	oq;Ǜqh6q{";K2lx$=JɁgѱQH+ebReb Ab[.}-gZɵضXm9f(lyr"[;](JJbKfM'w1 (hwDjHE>!j)#C!bL9`  f;]Է1A%Qx䐃!ºh[ǳtYyLj3 T8PA`7\uI-4MÒ#{iXcrd$#N]
JKw#6l'*Dve
GIb
B{KM5--x0b<V(ĥ ䷎]V[-VNkm
$r'! P0E4vQԕ$ĖJNb PcllԐ	Q|C$7_RGfa}Bܙfr,@v+ocQ4+m9aK7!CuVKkxg.ffB4p#1b#O1d3]<nZiqnɇ$FҰI	 F@&ƗtwGmŢ4NU$,ekGu([&[ `;FDy QKo[ʭk&[bہ`HNB aȊiltk*I+!,-604  Hny 2w<2XtWRyhVr1F#CoB
	
o]e2ͨiPF2cUBFcH	gx<q$7Haɒ@:Mwkx5+.Ď<ۋD>iIY6e3%5	-4֎PL8 =vAX+/9u[l[=:Mŷ+l4CcÑFRTVCX[0-*la;iCG#R@'-GY~QI@eyre  1讥
F'HЭ,bF+$X@/=eQҡdƪ<Ɛewo4yIiźo&3J$	$$u jW]ӽ߉y|g9W#(m?xgKjZiԡlql {0䂱FV%._ /%ro*zu]mnV#i9Ǚ")ҍ$$`ZTw|+g{dFO$Z!梒;40 .3b c]KsN[iXWI2+&*_O[ſ{9wO60
CɍUy $!iuTKtL9"7f7&HHI45ݭԮ4{8n-2ry$GifP-~$ 'Z;B0,  a6*#bJ\@,^KxoUlY6 G,r
3DSKgk]IRIYIal9 
V6ȍI Hg2CuE$vha۹,@]ɖg, ,k;5#BӖd0 #|d8WU`M Tr+/)mF`#J1"4@H,C=ݼ뎩%鼘rDop0+nL$ik[\iwN~$qZ!Md^H̡[(>I,AOiiwR`YŰ ôlTG
X~X˪Keֲmu-[dY 
fJ6فiS`s	L@
<m<j:ψdH,/sX,X 0YEu-wj1:Fm,>c`249^ F$ p }<-o 1<V^S,ڌ(Fc&5T,Di4X,{+yRKM.-y0aVܙ I!$ӨvRH͸C8ʽClQ<|XPMhd`hب$2)p21  y-UyUӭdl[p,I@6<9M-mu%I%d1%Ҧ昀4yX;"5$y"u
5١X_n琱w&Y `[ bt
NX}(dhr HA]U4RxZ-c˺xYP*LjXi YWvO:\[a412@BHP	oq;Ǜqh6q{";K2lx$=JɁgѱQH+ebReb Ab[.}-gZɵضXm9f(lyr"[;](JJbKfM'w1 (hwDjHE>!j)#C!bL9`  f;]Է1A%Qx䐃!ºh[ǳtYyLj3 T8PAaKLXT[Xl!>w	-,`Zu٬b_HJ¬qn70FHmygF|͉g+ *wOِ24A|s\`Q-FIUu-vrm#tvd,Q r iǥ&q=Ԓ7ҧ,el+^00~H>Xc-Kln|$vg攀'bF268i}Ĩžn{arnr5ai۵TU07il$x""܀e<FL ;jd-7uY3HmG͸fNcO%ӭcD"UetcqE'z2D66@o#ϓ:5klK=YaT4{
|
&̀j2JkP,3m&_ab M;L=-v3nᾕ9c+aZq1WCEhmr[cs$?4)<;1ěK%@4.-kt3usM&ݪ
{K`e 0nu3)Gb7*`(.~PV$m<,DOG/lB>m2p,r}-nvkR!p+[);ђ 1 [y|ѫ_3bY#
0S(i6d̍(-_6_>gQU]K]g[l7g \-idkEOsu$
[
׳0e2-GOk,% 9Iؑv$_q*qo[ XC\D`~i6UhUL
[,spw  ;O2;SAus ڷ$igVB"}L9~[enXc'huXĿjsY]n`Iތ΍ZtVAU
1)CI .diAl湷<ZZ=`FɼX8@mmN%K],L{%xoNXVa.amZ:|[\fI,)O>ČdmCq&P
}Zbj$Ij;B`n5^dH/L6DEÛLy؍ʘ
0 vտ [O<ngp-p̜"i>KE[%TD*s NdllG'tjؖ{¨hyJMs#Jd5ͽdWRnYg-7GfM  knv,zZbgI+}*rVµpcj22Igov~iHRyv$c#j6Jh\[g.,#Q&MUASp9"Aza".fS̎nTP]\6IxYwUS;_h|ۆd0XIZ-:l1/ڤB%\VWF8Rw$@ccd <?VfĳFCG`PlP[ 9m|($us9l;2o(  [[tӴcn8I^S2g`˃et?$[V,1%7>YK;{J@rσ#PITBVC=Xp79a0 4mڪЪWY
p@@wS2dv#r oaHD$rD#3''Oigf~"*
1Ÿ"" 6%謂0=c>Rf@\҂souFx%UԵۨ{eٓx/FpۦKtX7RJJ{8\+"ڴta-̒YݟR|ڇhM:ˁInPvTj2Ȑ^m7r#0W?(` k
@xd"'#Z!68E9>|N[;5KW8Uю- ->Oկ,EdP)42F/k{
3Ũ*@[-n̛}3 .@42Xۢ'WT匭k2]գemϖdҐHF;Gm/ иխ!.\
XFL0??4v*sU-DoD\9;̧ܩC m[Xl!>w	-,`Zu٬b_HJ¬qn70FHmygF|͉g+ *wOِ24A|s\`Q-FIUu-vrm#tvd,Q r iǥ&q=Ԓ7ҧ,el+^00~H>Xc-Kln|$vg攀'bF268i}Ĩžn{arnr5ai۵TU07il$x""܀e<FL ;jd-7uY3HmG͸fNcO%ӭcD"UetcqE'z2D66@o#ϓ:5klK=YaT4{
|
&̀ ߭'hw :f\.|p\ E@B@p%jTdJ(vw~f nYJ 	o?WLMz|ǻ@ȅy設&e>ePEc+2nwif\M!C˫@wNڥw~"Vg[-EO9]=c@C0
1}Ȱ.ZXH9vx2QQ K{kuˤ~Ȳf&[X 	dw Wtij[,7ZvTyp(_ds/ bw :f\.|p\ E@B@p%jTdJ(vw~f nYJ 	o?WLMz|ǻ@ȅy設&e>ePEc+2nwif\M!C˫@wNڥw~"Vg[-EO9]=c@C0
1}Ȱ.ZXH9vx2QQ K{kuˤ~Ȳf&[X 	dw Wtij[,7ZvTyp(_ds/ bw :f\.|p\ E@B@p%jTdJ(vw~f nYJ 	o?WLMz|ǻ@ȅy設&e>ePEc+2nwif\M!C˫@wNڥw~"Vg[-EO9]=c@C0
1}Ȱ.ZXH9vx2QQ K{kuˤ~Ȳf&[X 	dw Wtij[,7ZvTyp(_ds/ bw :f\.|p\ E@B@p%jTdJ(vw~f nYJ 	o?WLMz|ǻ@ȅy設&e>ePEc+2nwif\M!C˫@wNڥw~"Vg[-EO9]=c@C0
1}Ȱ.ZXH9vx2QQ K{kuˤ~Ȳf&[X 	dw Wtij[,7ZvTyp(_ds/ bw :f\.|p\ E@B@p%jTdJ(vw~f nYJ 	o?WLMz|ǻ@ȅy設&e>ePEc+2nwif\M!C˫@wNڥw~"Vg[-EO9]=c@C0
1}Ȱ.ZXH9vx2QQ K{kuˤ~Ȳf&[X 	dw Wtij[,7ZvTyp(_ds/ bw :f\.|p\ E@B@p%jTdJ(vw~f nYJ 	o?WLMz|ǻ@ȅy設&e>ePEc+2nwif\M!C˫@wNڥw~"Vg[-EO9]=c@C0
1}Ȱ.ZXH9vx2QQ K{kuˤ~Ȳf&[X 	dw Wtij[,7ZvTyp(_ds/ bw :f\.|p\ E@B@p%jTdJ(vw~f nYJ 	o?WLMz|ǻ@ȅy設&e>ePEc+2nwif\M!C˫@wNڥw~"Vg[-EO9]=c@C0
1}Ȱ.ZXH9vx2QQ K{kuˤ~Ȳf&[X 	dw Wtij[,7ZvTyp(_ds/ bw :f\.|p\ E@B@p%jTdJ(vw~f nYJ 	o?WLMz|ǻ@ȅy設&e>ePEc+2nwif\M!C˫@wNڥw~"Vg[-EO9]=c@C0
1}Ȱ.ZXH9vx2QQ K{kuˤ~Ȳf&[X 	dw Wtij[,7ZvTyp(_ds/ bw :f\.|p\ E@B@p%jTdJ(vw~f nYJ 	o?WLMz|ǻ@ȅy設&e>ePEc+2nwif\M!C˫@wNڥw~"Vg[-EO9]=c@C0
1}Ȱ.ZXH9vx2QQ K{kuˤ~Ȳf&[X 	dw Wtij[,7ZvTyp(_ds/ bw :f\.|p\ E@B@p%jTdJ(vw~f nYJ 	o?WLMz|ǻ@ȅy設&e>eP??  ƨOyІdT

6A.]3!Wd=vJFb|yvECkD&
̥e h:;᥎;Hr ;`t#
pgX죎mN(Y#Wȵ!c=TfZIy.YN!Uq||M1}X!ͨyӔ1\Lr0HLkL*o|ZK}mf.
NW
; 8nQI!Ҵ	-ZM;4Ad69`I$6 2nzl!g-mn͐oWozU>m ]$m&q)vA -wNic=(@m³;(S5HU-v HA#q>XE  ִh^Kki#fd=f@!L_w mHysjt W2,`(|1S
[0[YB6SU¸bN0RHt6}KV;n%)$N."Y!d7%RI
۽ާ==hEKpp۹dU2~OGdi<'7nI[D6Ib`]P@y>Ӭho.X㴏q|g-vB0ye}.8e8|]HO3@EFo0H 5,$5Hٮnd k)Y'wR\ڇ9@3̄,C
+Tƹ­%k"M >!Up|3+MRծۉJI4ӳKȤHcc6
mC`*>wOB6yR66|v̇_+iO1
ےA
g+2laOt+xˆ8#n._<"Yd ݁Ќ+9YcK98Yd_"hB7PQ 
kK	&亍f6k8H#J~Va	4ybԇ6NPs!1#1A0eq Ii-Ⱥl*oe;\+$_,o8E$Jl'ԵkRM42)Mpr[oE$ ʀOyІdT

6A.]3!Wd=vJFb|yvECkD&
̥e h:;᥎;Hr ;`t#
pgX죎mN(Y#Wȵ!c=TfZIy.YN!Uq||M1}X!ͨyӔ1\Lr0HLkL*o|ZK}mf.
NW
; 8nQI!Ҵ	-ZM;4Ad69`I$6 2nzl!g-mn͐oWozU>m ]$m&q)vA -wNic=(@m³;(S5HU-v HA#q>XE  ִh^Kki#fd=f@!L_w mHysjt W2,`(|1S
[0[YB6SU¸bN0RHt6}KV;n%)$N."Y!d7%RI
۽ާ==hEKpp۹dU2~OGdi<'7nI[D6Ib`]P@y>Ӭho.X㴏q|g-vB0ye}.8e8|]HO3@EFo0H 5,$5Hٮnd k)Y'wR\ڇ9@3̄,C
+Tƹ­%k"M >!Up|3+MRծۉJI4ӳKȤHcc6
mC`*>wOB6yR66|v̇_+iO1
ےA
g+2laOt+xˆ8#n._<"Yd ݁Ќ+9YcK98Yd_"hB7PQ 
kK	&亍f6k8H#J~Va	4ybԇ6NPs!1#1A0eq Ii-Ⱥl*oe;\+$_,o8E$Jl'ԵkRM42)Mpr[oE$ ʀOyІdT

6A.]3!Wd=vJFb|yvECkD&
̥e h:;᥎;Hr ;`t#
pgX죎mN(Y#Wȵ!c=TfZIy.YN!Uq||M1}X!ͨyӔ1\Lr0HLkL*o|ZK}mf.
NW
; 8nQI!Ҵ	-ZM;4Ad69`I$6 2nzl!g-mn͐oWozU>m ]$m&q)vA -wNic=(@m³x=C o<w3'9B; NAյίzQ8٣]l
v
pGbS(I
 Xmkɶ9۲(rm!Q 'w`k&
Jo&}6Ej5#y
_p=-7ędqÀ
62Q6m7ȗUXlW#Ŀ1$1e
_5D1g }VKh/mRXTkm m6 g@-̀C9"}}kT:Mt#L1-2)j},,6˹<X| QZunnu{ҏ~`Sn<3E*NTbsou=ԓ\nM6ݗF+l
I?3;_0hVUy73﹵-cVɮ	Ur[5-E/YoehX$3'#Q0bYMiDpbY%%K(m$!8[A}>j§[hnY8JndDjSZuk	d0o,fQ߹N S$fya>]0P2i Ө/PEsumssޔ}N#he[p$ᘔ)Rv3;{rmi츊4E\[`HTFH*I9ɃBҭ/ɹ}ͮlMpHB~"< j)zs{(GƱ&A>qp5gr̈́oM%m+5/w.jYCnv!Y UT>Z@uč"Ps *#PHfZS] HS!(eKye2w my'3
fO)r6+H7w VA|:+k^qG*6 ĦQJ4Ou$[lsMeQ*2B2AROLi~MmteXդ?rkFw;(
KQK{DZ<n52.ld;l'|o.h\,!خG~cIpcRt,kb_Oڤ ۮ$l@1[Q.rET4֨u]mG1F0c,2[(ewS9 m8YXms2yL#/̱ZA\[\S?5V`7	xf%2TŎ{&:ܛcm."0W,V)
~gvv`ЭtKngsk[*ƭ!\7߸1@(jZ^"pIfOG8
qpc `ܳa8|u[Ea
op<KKPۥc_ݤHCp'd}F%Oq#`q
9s*٧ֵCoH8-a1aY@̣+r 1mIh|a~e
 էP_W(Gʶ
;H#1)RM f,w6SI5mqibLT;skZ_s>]"V5iܚ]/EyCRRQbL2|8k(	6K,Wk}6+_\Բ/"BA>%6,*|63D@TF˜U>>W[x@hCQe]@5>lNgC̞S,l>Vn(:uW7V7:G?fvUl)7
AL'`*h1cI&nˈLU
dDd݃4+]*ʱH~*9~w-P
7x,kd\\(1Fw,N&"]VbXC[\,|ƥ6~XiŜ	Y-QIaS孴\H,b% 25\䊩iP5E2b`XdP3(ܧrgp<.dG(_caqGiè"J>4~kaNnJe;S@ͽRMpu64v\E`"XS$*#$$dZVϾHUZC&$o!WqpnbPԵgEcX ̟88pF@3fq7ͦ궋Mdx;5,KƿH,OmK
-m
Fd(r$UOOjU)$pZ)c2%FW~;c
O<w3'9B; NAյίzQ8٣]l
v
pGbS(I
 Xmkɶ9۲(rm!Q 'w`k&
Jo&}6Ej5#y
_p=-7ędqÀ
62Q6m7ȗUXlW#Ŀ1$1e
_5D1g }VKh/mRXTkm m6 g@-̀C9"}}kT:Mt#L1-2)j},,6˹<X| QZunnu{ҏ~`Sn<3E*NTbsou=ԓ\nM6ݗF+l
I?37|{>  ]       
     	`        P          Lesson 1 - Information    hidden  @
                  	   	        hidden  @
                  	   	        hidden  @
                  	   	           K@         6 "   
        
         Black    8  $         T MetaTalk Programmer is 1998 by MetaCard Corp.  All Rights Reserved.  Version b1.0 
    6	  
                     Click anywhere to continue...    hidden  @
                  	   	        default  @	P don mouseUp
  answer "This is just a picture... it's not a real dialog box!" with "Oh."
end mouseUp
         gS   && R      R              
 R 	         1     P         
     P      "   R     Q         H   H                 Ү        ff 33      ̙ 	ff 
33     
  ff 33    ff ff ff ffff ff33 ff   33 33 33 33ff 3333 33             !  ff "  33 #     $ % & 'ff (33 )   * + ,̙ -ff .33 /   0̙ 1̙ 2̙ 3̙ff 4̙33 5̙   6ff 7ff 8ff 9ffff :ff33 ;ff   <33 =33 >33 ?33ff @3333 A33   B   C   D   E  ff F  33 G     H I J Kff L33 M   N O P̙ Qff R33 S   T U V Wff X33 Y   Zff [ff \ff ]ffff ^ff33 _ff   `33 a33 b33 c33ff d3333 e33   f   g   h   i  ff j  33 k     lff mff nff offff pff33 qff   rff sff tff̙ uffff vff33 wff   xff yff zff {ffff |ff33 }ff   ~ffff ffff ffff ffffff ffff33 ffff   ff33 ff33 ff33 ff33ff ff3333 ff33   ff   ff   ff   ff  ff ff  33 ff     33 33 33 33ff 3333 33   33 33 33̙ 33ff 3333 33   33 33 33 33ff 3333 33   33ff 33ff 33ff 33ffff 33ff33 33ff   3333 3333 3333 3333ff 333333 3333   33   33   33   33  ff 33  33 33                ff   33              ̙   ff   33                 ff   33        ff   ff   ff   ffff   ff     ff33   33   33   33   33ff   3333   33                      ff     33           ٻ     ڪ     ۈ     ww     UU     DD     ""                                     ww     UU     DD     ""                                     ww     UU     DD     ""           wwwwww UUUUUU DDDDDD """"""             P     P $   
    +   +++V   +++V   + + +V   +++V  % + +++++ +V  % ++++++++V  \ + +++++++++++++++++++++ +V  a ++++++++++
+++++++++++++++++++++V  d + ++++++++++++++++++++++++++++++++++ +V  e ++
++++++++++++++++ +++++++++++++++++V  ^ + +++++++ +++++ ++++++++++++++++ +V  b ++++++++ ++++++++++++++++++++++V  Y + ++
++++++ + +++++++++++++ +V   ++++V   +++V   +++V   +++V   +++V  
+VVV                 V     V     V    V    V    V    V    V    V    V    V    V    V    V     V      V      V       V        V  X                   V  M               V                	 V          		          	 V                         V                     V                        V                           V      		           	  V                 V       V       V     V     V    V     V       V       V       V    V    V    V    V    V    V    V    V    V    V    V    V    V    V      V    V     V  $  V  (    V  ,     V  .     V  -    V  -    V  -    V  -    V  -    V  H       V  M            V            V            V                    V                V                 V                    V                 V                V  5      V  5      V  6     V  1     V  2    V  1    V  1    V  2    V  2    V  -     V  '  V    V     V      V    V    V    V    V    V    V    V    V    V    V    V    V    V     V     V     V  VVV                                                                                                                               
      
                  
     
     
     
     
     
     
     
     
     
     
                             !           .             H        
       
          Z                                  R                              S                               X     	                             [    
                           E                          #              hidden  @
                  	   	        hidden  @
                  	   	       % hidden  @
                  	  & 	       8 hidden  @
                  	  9 	       H hidden  @
                  	  I 	     
  M   	`        P         L Lesson 10 - Practice  
  N   	h           P $        L OK, now for something cool... Change any of the phrases in quotes that you want, then click "Run".  If you mess up, click the "Reset" button.  When you've finished, click "OK". 
  O 	practice  )`        HP        L on mouseUp  Z   answer "You're standing in front of a house.  The door is open, and so is the window."  L   answer "Go through window, or go through door?"  with "Window" or "Door"     if it is "Door" then  `      answer "You're greeted by an old man.  He stares at you."  with "Say Hello" or "Run Away"         if it is "Say Hello" then  <         answer "The old man hands you a key, then leaves."        else  =         answer "The front door closes before you reach it."  
      end if     else  C      answer "You try to enter through the window, but you can't."  
   end if  end mouseUp   P Run E   xon mouseUp
  set the script of button "hidden" to  field "practice"
   click at the loc of button "hidden"
end mouseUp
       l T   Run the script          	       Q New Button E`         L          	       T hidden  @*=on mouseUp
   answer "You're standing in front of a house.  The door is open, and so is the window."
   answer "Go through window, or go through door?"  with "Widndow" or "Door"
   if it is "Door" then
      answer "You're greeted by an old man.  He stares at you."  with "Say Hello" or "Run Away"
      if it is "Say Hello" then
         answer "The old man hands you a key, then leaves."
      else
         answer "The front door closes before you reach it."
      end if
   else
      answer "You try to enter through the window, but you can't."
   end if
end mouseUp
                    	  L 	       U Reset E   con mouseUp
   put "" into field "practice"
  put field "hidden" into field "practice"
end mouseUp
       Hl T   'Reset the script to its original state          	     
  V hidden  !`        HP        L on mouseUp 
 @       Blue    
 Z   answer "You're standing in front of a house.  The door is open, and so is the window." 
 @       Blue    Y L   answer "Go through window, or go through door?"  with "Window" or "Door" 
 @       Blue    K    if it is "Door" then 
 @       Blue     `      answer "You're greeted by an old man.  He stares at you."  with "Say Hello" or "Run Away" 
 @       Blue    _        if it is "Say Hello" then 
 @       Blue     <         answer "The old man hands you a key, then leaves." 
 @       Blue    ;       else 
 @       Blue    
 =         answer "The front door closes before you reach it." 
 @       Blue    < 
      end if 
 @       Blue        else 
 @       Blue     C      answer "You try to enter through the window, but you can't." 
 @       Blue    B 
   end if 
 @       Blue    	 end mouseUp 
 @       Blue      W OK E   on mouseUp
  if field "hidden" = field "practice" then
answer "No, you're supposed to change the script first."
else
go next card
end if
end mouseUp
       l T   Click here to continue          	       X end of the road   i           X
     )`        P @           You've reached the end of the basic lesson.  But if you're up to it, you can go ahead and complete the Lesson Extension by clicking on "Lesson Extension".  You can also click on "Exit" to go back to the Main Menu.    Lesson Extension Ew 5on mouseUp
  updateLevel
  go next card
end mouseUp
        t  , /Go to the Lesson Extension (Advanced students)          	        
Main Menu Ew =on mouseUp
   updateLevel
  go card "Main Menu"
end mouseUp
          , Go to the Main Menu screen          	       { 	previous Sw +on mouseUp
  go previous card
end mouseUp
      p 8  Go to the previous screen             @             	        next Cw 'on mouseUp
  go next card
end mouseUp
      p 8  Go to the next screen             A             	       e picture backdrop   i           X
     	`        P          *Lesson 20 - Introduction (other handlers) 
       
       
      
      (    'Lesson 19 - Introduction (on your own) 
       
       
      
      %    3Lesson 18 - Introduction (Mini-program "The CUBE") 
       
       
      
      1    2Lesson 17 - Introduction (hide and show commands) 
       
       
      
       
     " 
      ( 	  l *Lesson 16 - Introduction (random command) 
       
       
      
      !    8Lesson 15 - Introduction (Mini-program "Guessing Game") 
       
       
      
      6    ,Lesson 14 - Introduction (repeat structure) 
       
      
      ! 	
     *    ,Lesson 13 - Introduction (repeat structure) 
       
       
      
      ! 
   ,Lesson 12 - Introduction (repeat structure) 
       
      
      ! 	
     *   d -Lesson 11 - Information (buttons and fields) 
       
      
       
     % 
     +   < 6Lesson 10 - Introduction (Mini-Program "THE MAZE...") 
       
      
     4   ) 1Lesson 9 - Introduction (if/then/else structure) 
       
      

      & 	
     /    ,Lesson 8 - Introduction (if/then structure) 
       
      
      ! 	
     *    ,Lesson 7 - Introduction (if/then structure) 
       
      
      ! 	
     *    .Lesson 6 - Introduction (answer with command) 
       
      
     $ 	   :Lesson 5 - Introduction (Mimi-Program "Wacky Calculator") 
       
      
     8    ,Lesson 4 - Introduction  (global variables) 
       
      
       
     ! 	
     *    %Lesson 3 - Introduction  (variables) 
       
      	
     #   V )Lesson 2 - Introduction (answer command) 
       
      
      	  	 'Lesson 1 - Introduction  (ask command) 
       
      
      	      
  
   	h          P              0Look at the following cartoon, then click "OK":    OK Ew 'on mouseUp
  go next card
end mouseUp
       l T   Go to the next screen          	       ^ 
Main Menu E   .on mouseUp
  go card "Main Menu"
end mouseUp
      p X  Go to the Main Menu screen          	       s next Cw 'on mouseUp
  go next card
end mouseUp
      p 8  Go to the next screen             A             	       t 	previous Sw +on mouseUp
  go previous card
end mouseUp
      p 8  Go to the previous screen             @             	       g This is a button. E`          (         	     
  j   	`       H X         i This is a field! 
 @       Blue      k    `    @  Y     m advanced practice screens   i         \
  o   	`        P          Lesson 12 - Extension    Lesson 12 - Practice    Lesson 12 - Practice   ~ Lesson 11 - Practice    l Lesson 11 - Practice    p OK Ew on mouseUp
  checkIt
  answer "Great work!  Do you want to run it again, or continue?" with "Run again" or "Continue"
  if it is "Run Again" then exit to MetaCard
  go next card
end mouseUp
       l T   Run the script          	     
  r   	h           P          OK, you decided to extend.  Good for you!  Look at the script for today's extension... it counts forwards AND backwards into the field "storage".  Type the following script into the Practice Field.  Watch that syntax!  on mouseUp 
 @       Blue    
    put 0 into ct 
 @       Blue        put 101 into ct2 
 @       Blue        repeat for 100 times 
 @       Blue           add 1 to ct 
 @       Blue           subtract 1 from ct2 
 @       Blue     ,      put ct into line 1 of field "storage" 
 @       Blue    + -      put ct2 into line 2 of field "storage" 
 @       Blue    ,    end repeat 
 @       Blue    
 end mouseUp 
 @       Blue      Good work!  But how long did it take your computer?  Hard to say.  Could we program the computer to TELL us how long it took?  Absolutely!  Just like we got the time and the date, we can also get the seconds.  Type the following script into the Practice Field.  Watch that syntax!  on mouseUp 
 @       Blue    
    put 0 into ct 
 @       Blue     '   put the long seconds into startTime 
 @       Blue    &    repeat for 100 times 
 @       Blue           add 1 to ct 
 @       Blue     "      put ct into field "storage" 
 @       Blue    !    end repeat 
 @       Blue    
 2   put the long seconds - startTime into thisMany 
 @       Blue    1 -  answer "It took" && thisMany && "seconds." 
 @       Blue    , end mouseUp 
 @       Blue       XType the following script into the Practice Field.  Mind your syntax, while your at it.  on mouseUp 
 @       Blue    
 >   answer "This will count to 100 in the field named storage" 
 @       Blue    =    put 0 into ct 
 @       Blue        repeat for 100 times 
 @       Blue           add 1 to ct 
 @       Blue     "      put ct into field "storage" 
 @       Blue    !    end repeat 
 @       Blue    
 end mouseUp 
 @       Blue      ~"OK, so you get the idea.  The ability to control the information placed in fields is important.  Here's an example that shows how you can use a field as a place to keep the names of items your character has taken in a role playing game... type the following script into the Practice Field.  on mouseUp 
 @       Blue    
 5   answer "You come across a sword." with "Take it!" 
 @       Blue    4    answer "One sword taken." 
 @       Blue     .   put "sword" into line 1 of field "storage" 
 @       Blue    - end mouseUp 
 @       Blue      l Now we're going to do some work with fields.  Notice the layout of this screen is different from other practice screens... that's because we're going to use the scrolling field labeled "storage" in our script.    3Type the following script into the Practice Field.  on mouseUp 
 @       Blue    
 7   put "This is line 1" into line 1 of field "storage" 
 @       Blue    6 7   put "This is line 3" into line 3 of field "storage" 
 @       Blue    6 end mouseUp 
 @       Blue      x    	`    @ C !   
  s 	practice  )h                     
 @       Blue         
 @       Blue         
 @       Blue       ~  
 @       Blue       l  
 @       Blue       v    `    @     
  t storage  	h                               ~    l    y    `    @ C      u hidden  @
 on mouseUp
put 0 into ct
put the long seconds into startTime
repeat for 100 times
add 1 to ct
put ct into field "storage"
end repeat
put the long seconds - startTime into thisMany
answer "It took" && thisMany && "seconds."
end mouseUp
                    	   	   	   	  ~ 	  l 	     
  z   (                     >                                               Practice Field 
  {   (                               Field "storage" 
  | example  !`       8 0          on mouseUp     put 0 into ct     put 101 into ct2     repeat for 100 times        add 1 to ct        subtract 1 from ct2  ,      put ct into line 1 of field "storage"  -      put ct2 into line 2 of field "storage"     end repeat  end mouseUp    on mouseUp 
 @       Blue    
    put 0 into ct 
 @       Blue     '   put the long seconds into startTime 
 @       Blue    &    repeat for 100 times 
 @       Blue           add 1 to ct 
 @       Blue     "      put ct into field "storage" 
 @       Blue    !    end repeat 
 @       Blue    
 2   put the long seconds - startTime into thisMany 
 @       Blue    1 -  answer "It took" && thisMany && "seconds." 
 @       Blue    , end mouseUp 
 @       Blue       on mouseUp 
 @       Blue    
 >   answer "This will count to 100 in the field named storage" 
 @       Blue    =    put 0 into ct 
 @       Blue        repeat for 100 times 
 @       Blue           add 1 to ct 
 @       Blue     "      put ct into field "storage" 
 @       Blue    !    end repeat 
 @       Blue    
 end mouseUp 
 @       Blue      ~ on mouseUp 
 @       Blue    
 5   answer "You come across a sword." with "Take it!" 
 @       Blue    4    answer "One sword taken." 
 @       Blue     .   put "sword" into line 1 of field "storage" 
 @       Blue    - end mouseUp 
 @       Blue      l on mouseUp 
 @       Blue    
 7   put "This is line 1" into line 1 of field "storage" 
 @       Blue    6 7   put "This is line 3" into line 3 of field "storage" 
 @       Blue    6 end mouseUp 
 @       Blue      }    	`    @  1     f 
Main Menu E   .on mouseUp
  go card "Main Menu"
end mouseUp
      p X  Go to the Main Menu screen          	        next Cw 'on mouseUp
  go next card
end mouseUp
      p 8  Go to the next screen             A             	        	previous Sw +on mouseUp
  go previous card
end mouseUp
      p 8  Go to the previous screen             @             	        hidden  @
                  	   	        hidden  @
 on mouseUp
put 0 into ct
put 101 into ct2
repeat for 100 times
add 1 to ct
subtract 1 from ct2
put ct into line 1 of field "storage"
put ct2 into line 2 of field "storage"
end repeat
end mouseUp
                  	   	        Save Ew on mouseUp
  ask file "Enter a name for your script:"
if it = "" then exit to MetaCard
  put it into thisFile
  open file thisFile
  write field "practice" to file thisFile
  close file thisFile
  answer "File saved."
end mouseUp
      p p  Saves your script as a file          	        Load Ew on mouseUp
  answer file "Choose a script to load:"
if it = "" then exit to HyperCard
  put it into thisFile
open file thisFile
read from file thisFile until eof
put it into field "practice"
close file thisFile
answer "Script loaded."
end mouseUp
      p p  Loads a saved script          	     
     	            Black    P ,         *                           Teacher Screen 
     	h          $P          JThis screen contains a log of all access of this program for this year.   
                @ l          Year Settings:     	u on mouseDown
  put the selectedText of me into thisField
  put field "log" into field thisField
end mouseDown



on mouseUp
  put the selectedText of me into thisField
  put field thisField into field "log"
end mouseUp
        t @   1998 - 1999    11998 - 1999
1999 - 2000
2000 - 2001
2001 - 2002
        	   	     
               \8          +                                Access Log 
       
      
             @ \          $Student List, Levels, and Passwords 
       #   Go Back Ew .on mouseUp
  go card "Main Menu"
end mouseUp
      p L   Takes you back to the Main Menu          	        Change Info Ewon mouseUp
  if the selectedText of field "roster" = "" then
    answer "You need to choose a student first."
    exit to MetaCard
  end if
  answer "Change info for" && item 1 of the selectedText of field "roster" & "?" with "Yes" or "No"
  if it is "No" then exit to MetaCard
  --name
  ask "Enter Name:" with item 1 of the selectedText of field "roster"
  if offset(comma,it) <> 0 then
    answer "You may not use a comma in a name."
    exit to MetaCard
  end if
  put it into nam
  --lesson
  ask "Enter Lesson:" with word 2 of item 2 of the selectedText of field "roster"
  if (it is not a number) or (it < 1) or (it>20) or offset(".",it) <> 0 then
    answer "You need to enter a number 1 - 20 for the Lesson."
    exit to MetaCard
  end if
  put the first word of it into lesson
  --password
  ask "Enter password:" with item 3 of the selectedText of field "roster"
  if offset(comma,it) <> 0 then
    answer "You may not use a comma in a name."
    exit to MetaCard
  end if
  put it into passw
  --place info
  put nam & "," & " Lesson" && lesson & "," & passw & ",,"  into line (word 2 of the selectedLine of field "roster") of field "roster"
  put field "roster" into field "hidden roster" of card "Main Menu"
  put field "hidden roster" of card "Main Menu" into field "roster" of card "Main Menu"
  repeat with i = 1 to the number of lines of field "roster" of card "Main Menu"
    delete item 3 of line i of field "roster" of card "Main Menu"
  end repeat
  answer "Record changed."
end mouseUp
      p `  /Allows you to change name, level, and password          	        Delete Ewon mouseUp
  if the selectedText of field "roster" = "" then
    answer "You need to choose a student first."
    exit to MetaCard
  end if
  answer "Delete record for" && item 1 of the selectedText of field "roster" & "?" with "Yes" or "No"
  if it is "No" then exit to MetaCard
  delete line (word 2 of the selectedLine of field "roster") of field "roster"
  put field "roster" into field "hidden roster" of card "Main Menu"
  put field "hidden roster" of card "Main Menu" into field "roster" of card "Main Menu"
  repeat with i = 1 to the number of lines of field "roster" of card "Main Menu"
    delete item 3 of line i of field "roster" of card "Main Menu"
  end repeat
  answer "Record deleted."
end mouseUp
      Dp \  Deletes the selected student          	     
   hidden roster  )h        @ p                   `    @ C q   
                Blue    P ,         )                               Main Menu 
       
 @        Black   
   Save As Ewlon mouseUp
  answer "Save log, or save student list?" with "Log" or "Student List" or "Cancel"
  --log
  if it is "Log" then
    ask file "Save log as:"
    if it = "" then exit to MetaCard
    put it into thisFile
    open file thisFile
    write field "log" to file thisFile
    close file thisFile
    answer "Log Saved."
  end if
  --student list
  if it is "Student List" then
    ask file "Save student list as:"
    if it = "" then exit to MetaCard
    put it into thisFile
    open file thisFile
    write field "roster" to file thisFile
    close file thisFile
    answer "List Saved."
  end if
  
end mouseUp
       p \  "Saves log report or roster report          	        advanced practice 4 field   i         d
     	`        T          Lesson 13 - Practice    Lesson 13 - Practice 
     	`         \ x         Very good!  Now let's make it more interesting.  Let's add another element - the if/then structure.  Pay attention now, because this one's more difficult.  Type the following script into the Practice Field:  on mouseUp 
 @       Blue    
    repeat for 20 times 
 @       Blue     %      subtract 1 from field "energy" 
 @       Blue    $ !      if field "energy" = 5 then 
 @       Blue      &         subtract 5 from field "food" 
 @       Blue    % !         add 5 to field "energy" 
 @       Blue      
      end if 
 @       Blue        end repeat 
 @       Blue    
 end mouseUp 
 @       Blue      
OK.  Here's the scenario.  Your characters have been transported to the Desert of Death, where they meet their untimely demise.  In this script, we're going to subtract a point from each of the 4 fields on the right.  Type the following script into the Practice Field:  on mouseUp 
 @       Blue    
    repeat for 20 times 
 @       Blue     #      subtract 1 from field "food" 
 @       Blue    " #      subtract 1 from field "gold" 
 @       Blue    " %      subtract 1 from field "energy" 
 @       Blue    $ $      subtract 1 from field "water" 
 @       Blue    #    end repeat 
 @       Blue    
 .   answer "Your characters have passed away." 
 @       Blue    - end mouseUp 
 @       Blue          	`    @ O !  v 
   	practice  )`        \           
 @       Blue         
 @       Blue           `    @ O       OK Ew on mouseUp
  checkIt
  answer "Good work!  Do you want to run it again, or continue?" with "Run Again" or "Continue"
if it is "Continue" then go next card
end mouseUp
       l T   Run the script          	     
     )`      h   t            
field "food" 
     )`         t            
field "gold" 
     )`      h  t            field "energy" 
     )`        t            field "water" 
   food  	`      h < t \         20    20 
   gold  	`       < t \         20    20 
   energy  	`      h  t P         20    20       
   water  	`        t P         20    20       
   example  `                 on mouseUp 
 @       Blue    
    repeat for 20 times 
 @       Blue     %      subtract 1 from field "energy" 
 @       Blue    $ !      if field "energy" = 5 then 
 @       Blue      &         subtract 5 from field "food" 
 @       Blue    % !         add 5 to field "energy" 
 @       Blue      
      end if 
 @       Blue        end repeat 
 @       Blue    
 end mouseUp 
 @       Blue       on mouseUp 
 @       Blue    
    repeat for 20 times 
 @       Blue     #      subtract 1 from field "food" 
 @       Blue    " #      subtract 1 from field "gold" 
 @       Blue    " %      subtract 1 from field "energy" 
 @       Blue    $ $      subtract 1 from field "water" 
 @       Blue    #    end repeat 
 @       Blue    
 .   answer "Your characters have passed away." 
 @       Blue    - end mouseUp 
 @       Blue       hidden A on mouseUp
repeat for 20 times
subtract 1 from field "energy"
if field "energy" = 5 then
subtract 5 from field "food"
add 5 to field "energy"
end if
end repeat
end mouseUp
                  	     
  Y   (         T            4                                     Practice Field   i 
Main Menu E   .on mouseUp
  go card "Main Menu"
end mouseUp
      p X  Go to the Main Menu screen          	        	previous Sw +on mouseUp
  go previous card
end mouseUp
      p 8  Go to the previous screen             @             	        next Cw 'on mouseUp
  go next card
end mouseUp
      p 8  Go to the next screen             A             	     
   1998 - 1999  !`        p8          1998 - 1999       `    @ + q   
   1999 - 2000  !`        p8          1999 - 2000 Log       `    @ + q   
   2001 - 2002  !`        p8          2001 - 2002 Log       `    @ + q   
   2000 - 2001  !`       @  4 $         2000 - 2001 Log 
   log  	h   
        p8          1998 - 1999       `    @ + q   
     	`        H          Welcome to MetaTalk Programmer. 
 @       Blue      This course will teach you how to program a computer using MetaTalk, which is the programming language for the application MetaCard.  After you've completed this course, you'll be able to learn MetaCard and create games or applications of your own.  You have to learn grammar before you can write a story, and you have to learn MetaTalk before you can write a program or game using MetaCard!   
You can't become a computer programmer overnight.  But you CAN learn the basics of computer programming using MetaTalk Programmer, and then create your own games.  This program teach you the building blocks of programming.  What you build after that is up to you...    1Click on the "OK" button below to get started...    OK Ew 'on mouseUp
  go next card
end mouseUp
       4 | ( Takes you to the next screen          	        Demonstrate Ep }on mouseUp
  ask "What is your name?"
if it = "" then exit to MetaCard
answer "Pleased to meet you," & it & "!"
end mouseUp
           (         	        application   i          `
     	`        P          Lesson 18 - Practice    Lesson 17 - Practice   	 Lesson 2 - Practice    Lesson 1 - Practice 
     	h           L @         OHere we go.  Note the use of the random command as the basis for this script.  
       !
     ! 
     ' ' 3Type the following script into the practice field:    OOK, so let's hide Billy.  type the following script into the Practice field.     	 Good work.  Now it's time to apply what we've learned.  We've placed an invisible button over the picture of "Agatha".  Type the following script into the practice field (which will be placed into Agatha's invisible button), then click on "Agatha":   1Good work!  We've taken the liberty of making the button transparent (invisible) for you... now let's enter a script for our button.  Type the following script into the Practice Field, and we'll automatically place it into the invisible button covering Billy.  Click on Billy when you've finished typing. 
   example  	h          Blue     d          on mouseUp      answer "The Cube knows all."     ask "Ask your question:"      put random(4) into theAnswer     if theAnswer = 1 then  3      put "Dream on!" into field "cube's response"  
   end if     if theAnswer = 2 then  0      put "As if!" into field "cube's response"  
   end if     if theAnswer = 3 then  5      put "Absolutely!" into field "cube's response"  
   end if     if theAnswer = 4 then  4      put "Certainly!" into field "cube's response"  
   end if  end mouseUp    on mouseUp  /   answer "Oh no!  Billy forgot his homework!"     answer "Quick, hide Billy!"     hide image "Billy"     answer "Good job!"     show image "Billy"     answer "Too bad."  end mouseUp   	 on mouseUp  #   ask "Did you do your homework?"  -   answer "That's not a good enough answer!"  end mouseUp    on mouseUp     ask "What do you want?"  end mouseUp       	`    @  e   
   	practice  )h           l                	        
    `    @    j    hidden  @
on mouseUp
answer "The Cube knows all."
ask "Ask your question:"
put random(4) into theAnswer
if theAnswer = 1 then
put "Dream on!" into field "cube's response"
end if
if theAnswer = 2 then
put "As if!" into field "cube's response"
end if
if theAnswer = 3 then
put "Absolutely!" into field "cube's response"
end if
if theAnswer = 4 then
put "Certainly!" into field "cube's response"
end if
end mouseUp
                  	   	   	  	 	     c 
Main Menu E   .on mouseUp
  go card "Main Menu"
end mouseUp
      p X  Go to the Main Menu screen          	       y 	previous Sw +on mouseUp
  go previous card
end mouseUp
      p 8  Go to the previous screen             @             	        next Cw 'on mouseUp
  go next card
end mouseUp
      p 8  Go to the next screen             A             	     
     (          |                 	         fake button   	T 0on mouseStillDown
  grab me
end mouseStillDown
                 ssssss      | t !Drag this button on top of Billy   W 0??0 0??0??0??0??0??0׍0׍0׍0׍0׍0׍0׍0׍0׍0׍0׍0׍0׍0׍0׍0׍0׍0׍0׍0׍0׍0׍0׍0׍0׍0׍0׍0׍0׍0׍0׍0׍0׍0׍0׍0׍0׍0׍0׍0׍0׍0׍0ׂ߂0ׂ߂0?ނwoDy0?ݷwn80?wno0?no0?[ono0?[݂)ono0?n0?}wy0׍0׍0׍0׍0׍0׍0׍0׍0׍0׍0׍0׍0׍0׍0׍0׍0׍0׍0׍0׍0׍0׍0׍0׍0׍0׍0׍0׍0׍0׍0׍0׍0׍0׍0׍0׍0׍0׍0׍0׍0׍0׍0׍0׍0??0??0??0??0??0 0 0 0  	 ?? ? ?? ? ?? ? ?? ? ?? ? ?? ? ?? ? ?  @  @  @  @  @  @  @  @  @  @  @  @  @  @  @  @  @  @  @  @  @  @  @  @  @  @  @  @  @  @  @  @  @  @  @  @  @  @  @  @  @  @    >  @    !  @? !  ?? "H!	 8?? $(> ?? 'P! ?? P  ?? " ) ?? bB !		 ?? ! > ?  @  @  @  @  @  @  @  @  @  @  @  @  @  @  @  @  @  @  @  @  @  @  @  @  @  @  @  @  @  @  @  @  @  @  @  @  @  @  @  @  @  @  @  @? ? ?? ? ?? ? ?? ? ?? ? ?? ? ?? ? ??   s ??                                                                                             s                                                                                           ??   s                                                                                           ??       
               x                         Billy    OK Ew
on mouseUp
 put the loc of image "fake button" into temp
  if (item 1 of temp < 500) or (item 2 of temp <  150) then
    answer "You need to drag the New Button so that it covers the picture of Billy."
    exit to MetaCard
  else
    go next card
  end if
end mouseUp
       l T   Click here when finished          	     
     (          x                         Billy 
     	`         P T         OK.  Now we're going to place an invisible button over a picture, so that when you click on the picture, you're clicking on an invisible button.    rClick and drag the button named "New Button" so that it covers the picture of Billy.  Then click the "OK" button. 
       q   man + comp.JPG  	@       T D  . JFIF  H H              	
       	
   } !1AQa"q2#BR$3br	
%&'()*456789:CDEFGHIJSTUVWXYZcdefghijstuvwxyz  w !1AQaq"2B	#3Rbr
$4%&'()*56789:CDEFGHIJSTUVWXYZcdefghijstuvwxyz !    ?  M'?_O	GZGj
|-w}_\:|77Y,I+31$_s é ?g<! 4 é ?g<! 4é ?g<! 4 é ?g<! 4é ?g<! 4 é ?g<! 4é ?g<! 4 é ?g<! 4é ?g<! 4 é ?g<! 4é ?g<! 4 é ?g<! 4é ?g<! 4 é ?g<! 4é ?g<! 4 é ?g<! 4é ?g<! 4 é ?g<! 4é ?g<! 4 é ?g<! 4é ?g<! 4 é ?g<! 4é ?g<! 4 é ?g<! 4é ?g<! 4 é ?g<! 4é ?g<! 4 é ?g<! 4é ?g<! 4 é ?g<! 4é ?g<! 4 é ?g<! 4é ?g<! 4 é ?g<! 4é ?g<! 4 é ?g<! 4é ?g<! 4 é ?g<! 4é ?g<! 4 é ?g<! 4é ?g<! 4 é ?g<! 4é ?g<! 4 é ?g<! 4é ?g<! 4 é ?g<! 4é ?g<! 4 é ?g<! 4é ?g<! 4 é ?g<! 4é ?g<! 4 é ?g<! 4é ?g<! 4P $ L ??k ( ( ( ( ( ( ( ( ( ( ( ( (   (_&Wim |%Z[-m3WO_?|1NML,UznNgnn?OL>9~֟u; \/̖úLdi\R7
PGJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = s' o{M'ς[PV{i
0hΝm-T}M<]Hu	ob~WCHo hxOP9i--.;[g+[y95 ( ( ( i_K_7?/}KcK}Ku~,|C
mwmo/	,/,c_j W"?|]yu~<=u 	_[K j6rq4=qـGJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?=}o|<nL%o	?x[Ƕ]C
i>Lw}%ԇ^P$o<Zď9#-n-n-#{Kx)#^?  q$	 dmzC_~ˡ|<x_k{T/"\gGM[
MCķ%/AqϿ>~˿߳ ?|)zj0ZIWyfy&ieY$Gvm/wo# .T??>g?io~/Wy۾J j ~?fgǉOm7^SFWiLhzwVM$Wwg{2Les/ڷ[* k<_xH׿>}_7~fDs_Oh^u=m%abrsi<[+2(t>?>0⇁r|m@i>29]7Rm[XM]GNi 5'~4xGv/X~:[ZEgQws
cI?||)w~+?s #E.4cGվ+xZIdhGHU  Z~xwGgo|rh~.u[{M1w0^18@ǎO m{?/&x{_{ï+Ëhj l7^uaE:ZX܀t_.ge/%'୞Ѽ_}?hi:l)[>mݒjFfk;	̨%@	X E>
??|3ك@мG㻭Fo^o:چmkYy'ӭr[
M-ӿ|	W۾  #A>{kˋ?I K}_SkWxdF ڷ[ּ{~Lxgt[xHT~43EV9Pxmnf[H-pcb9M|{XFk}狼#ɵؑmiySJw7f)obfs# t??jox{O1k^u+xHҮ4{u9⻞7KK& d`?joEO1O%o<;s"-S0q.<m>!HT˅I 'G
[-xS"NjM֏6χאַԭ./#Ym&!D+ +}k7t><>Z9MJTi[k$hv/5]AaQ: ( (w-?
x>96'E5mcXկ!lmi.nn&ebI%vUEFf h'g:]U?>$ha4>1nHoG4Tmln虜P~ҿS _Iߣ~ϿW_F>&]odK}/G\h6ZIhMvmu}uoO4>c`kOCl 
|GCV|# &VVK{\vqM
$,+3!;@:ߴ _gٯǾ:ƿ_ hٚ  6qLm"I,>f`Tz> 	#nm y 	yk͒VJɼ+O>|7< Eb~_Ǌ gv񎡢<_i GmP<Ey$QZi_XZMi;KEв[NџlOL~ c]|bAigS𶿣͡M-2io71<76<2L4s |J?g w1.hZҼ)k!E.ir&ZrLcCeo쵪|K3m|?
_Mt,o4fs[Im1Mq	@>͢
( ?<|O~ ֹxgO>:~˸-,`ԥIv{EKֲFbU/uC h I) _@~9g $k>%ݵ _K]  @ )  
O/W۟۟ n?پoONߞ*_K w¯a 
'o^AAe٭/_QQm&-?Eړ	k 4~^ 'C}WW\>%j1ӭ(^Gt\+f  Uj I\.C  $KO?Ɵپr|5loXiK5; d +|{ xsτ5?#ijRxRC][4q^Z f>i>ڢ5I@= Uj I\.C  $KO?Ɵپr|5loXiK5ߚ ?o7~6K='ğk/Xqk4V?|eG(])fy/Y(Jt _7ҿht?x[ޡ6k>(k}k]&oEΕYŧXMiZuy-Vabk7	gx&_?`׍6~Ѿ/Yo
2E6j!Yu9>̍<g?O Ǎ /4_x𘧊lon|; ?{Yk1"I6C/C
a eW
_V_Wjw#Ɨ4y3\n@Km򟖿೿H F|W2]C׍uysX|C6}6ť̚-RX^Ӄ^j
4le |!Uڻ{P_xHl[&CǇ]Vizgص=FQ4r~ z ^a*hi~X^)jiz) y~ӪYBdo&M- r?ߵ'/ߊ _'_ t ZՇu]_I w3zOmKYt;QGاD3<W??9CςV<A6{:\\^aMQVw
ƸՔ+uro#o_K	|?~(x@ KmWm Yլolmʽ?ol"P?iH K l 8$c Ugĺ  ( (  ) ি@~! 9Pݵ R cۣo:?3~Ѵk n%ԵXZ~<,tna7I$|_ ~>9[6;O|>ψ>𭏃xZ F5me8u+OEFLԗĳ6G$>eW	Q|Z[|7!|Q * hmW:O!=߄YmkK7f3$z?LVJYe ?H (oJ|9'DG5OKKա>wck^zAe}4TQ   ]/ɧ6V<;'YŅ[>+w
W^]m,kl*Z4`)/K~?>4si߇u_JKM#
O:t;B0fjqWiVuGMY`>/d~'I^5=_WCiQjd[i5+d;9.
[j(R]F?Pl~MS'χ;/x
+|^-F캺]GHn..^G '7->:|*  k?iO>-£ Zӧ֟ A32$1Cgt{wz<OdxR/k_ǀonVζW\Zyþ%ѽLP+_GK
5xWپ5<?OV 	7 o%^=ckkͶڕgyϝb, X~ ߴoV.kZ;-Jt*[Mpk
?_i?k}	 Ej'/[Ti/ơK ,Լkuwg/I6x$·1VUu}R++Ugt_<5 K |
,?O7m}qOfOsT Q@	~ qI//ωum 
?I/E?+G4?l 8$c Ugĺ ৿\?wE/ 	g?|!>6x5c^5dVlW{mvϨXE*yfLBx
)F|^  @gWQ+OaDDC.b"1ז<*ߖ'9x:<'!vww-_mԒ;zY\<vkQGgqq",op~. |c O?^l?lˏتZOZVM2j6lj-c y&}
+ OC?!D~~  "kOA>(|9]L먋6k2Y:}wvLjտ]O_ o?oÿ؟@7# .jC~Gմ×E/!O,<p:E> O	J| yxߎ_C K6sk?_hڴoȶ ,i"Ե?~
ǋ
x_|[}hڌ?; 	>q>e6[X[j1X:H->{ p;/زN?f/&#q\-uV'঱52u*jlyE@чG o~m/U  G?k'y[>][8 '쁧?V~'|U/7o|:=\AwMqi#;M-(rt?J.</_kZ M wx+/͵ϰ}{oy
olq |ux'.+⿍WN}nZzZEkf
Bk>ͧ^3( [W%/+P4rE9|ax¾OgbN{)V`Xnݍsy xO/
*<L߇*ͯ_i<5yOH}΁G<0jݤ-n0R~\?] P?b_{?	xNƣ|8u+GLMM:QWHoo[|3 jCF?1KKᙴjx^;颋LXΉaeO"G@B¿M߅2_?_Z+}iNϩv7cD-5Thx
)F|^  @gWQ+OaDDC.b"1ז<*5 '  @v@ Q@ W_VE??G5* 
 j (WO,Ï'}oNF\~$վ	x5֮Os[7igM&{ّӨ=R?S
	P⯉?~04v77:Lam"Qe|nZ+xSNoBb}gZtmfAeKF 2xl0 " |>xKysuk^
uͧ=)k_xMtKw ~!<ixJ ~_/Hxƚ=ֳè6l ?ab ~Zo"3?C?_]><M/侲X	u+7R[O[E{SI~ s  to~(v\v/	}z}F[{G͸Y#HE@| i Jm
cF5\t.Ycru{hZ-uK:MV^]O3翄_oٳo=
+~˿#xCO|mf|U}eCvZi[Ŧ]G=
o(P?߷O?ۿW>4|2%|4|gGTth׷M]/'ѯ%k+h0w? [gg5	?~eD$a^:oA":<VmkZx̰Bؾ9kn%>/xSZ|o k]@٦<9mm2ɜ[[wh_[yfB~ZoOI
ƿ  /H: K.V
>PĿd-Ｈe5Y! 7~5'}qg`4__ͭ޷woZviܴ ? P_wK ]}@E KQO   Q6?N;	% eX Y.>W	W?@>iM쟳Σ,Ɵxk#mmu8Xіcm2OӥH@?R~|z iOx-`i3 o aYO3Z<Cgt .?ߊ߳Ꮗ*{gƚucouwK/
h7e>teY-< -~_?C⇍njuNK`6.yCkoHSVi.i.eʩԿ_? WwC[C7i%Q_Akvgr; ; `~ >=xk|w$!G }ն_^\uA?)U ?
~|mᆁx#M 'Kյͧ\˄.W7[4@g p n74m7m/+mB)T<`g/4I5{^JmkkIĳyn%|/AoOyU<GO5߇Nogj=?ږd?nis@?n߱Ǐ_.u K J϶EizeV3^s`Eko/7z>'oÿ}^ |Sֿ&G<igk^}?F<B@?=  Oo?g_ړQOrsOԼSSu^	#KK:)-u&JI'((R_' 
CTmCS Vmt]V HtKSԮfWA4~L^X|< J ;鿴ٓOt~վx-g[xm<+]jږ$l..K맰ńt(<0| Mx~+ f#_ ).?/KTwKx:}	ps̺[ p㟲ob4~_OOi!|NK/WQK ӌw^"Hm.gg?,  bYhVy|@(ڮ
S":ޙhWyuq%jEZ\ ?MoGW6 ktvXomV[uGZZmX8_?_h S^ƿ__z  Vo_־E4P&ګ/?N;	% eX Y.>
( 
( ୿)jTm~xn rm}?7M;?%ǂ7V7~]Z]d$uU5܈LP5P /߱߂axSώ YcYɥivEo?5 Sc
x[ju<ymMú
Xuif@[]@ǥ e|+׏{{ռQsx"M<>:tvHGY鶚za(RC,߲_|>&k|lt>^oRi0BfkuX&g?'gxOҿeᎱ/c<&4]Ow.IѴ,!Iaq.sIȖ+K~ e(_ϋ?>4 ^:g=JE?q.c/#mB2 /~
 o? Yx <M<QMF5&ӛVoGgmsvԌO<P	|1 w/%%'TԼ_~ϧ.k6f֦7kwemQ'Zաams:V@ a[!O7V;[sƳh}{-f;4xH- %XRid
BlD? ~_i_ Ov7shSX>(o5M"S}Y{kJQ,&i&:1|{ dhKOx߳<'u6 M-ctɬdkl3HUV.Č+Mo?cۏ⇄#,t-5G9nnL\AK\  3~~ߵ/?KoO|_Oڗ(dx)[;}:Xf9]9^+mJKlmb~"xki  1x?Xmo
okdо;^ ZqyhG-85MS̚ISϏDGXɴ1^G(/?N;	% eX Y.?G	% ( ey G '  @vl'? ko?^)c/(ӵ=^ @cq<v4h=Yv-nQ%ԕ  {}   
S?!# /Xg 'bg%o_W??V]_/j_O¬jw>V 
 Ѽe帆|:O-҄7LP_ 
ڏ)O  s?Clboٟyi~_ Go)7୿Կi?f i:o!>,a~^?>(Nvֳg$ >|C%?ˮ~5 |!9okn,&l/ϐ}~ )k/uy"_>=@/_oڇ umE-7Y_
LԭoR{
I*,msxw ~)(>?rO_ς_|k 
7<UO_<IMg ki/I׬,&O>HG!P>xk5  / 
; 	gU??  >  ?ؾ Y aڨԟ
 ' 'l(|=/^,&r
^E5;zK-6ocpg-Ďa&p{b
x3'?	t3j*(4hXRS[9b,Ddh ?? c	u???h	3i C~
OH̚o#fiQҴ56AI<1ݬxCyh) O3G!?b?d?{?C5e)Rk#OXY١@/5':K -  c)FWk O #.߰ d Ǘ+XyM|3/__KhۻmOw[o7=[Ş$~Ҽ'^|)ZU/	[7@e> w|"~% ' ੟hߊ}[Ɵm
Gٷ|[{9mEuMG[a٭ыK+)H" ?O_7gu |!o/,<ˋV&mikwkmqܚV@>
K  I~?V|Kh ( +/+o
k d }E PE PE PE PE |%g $k>%ݴ 4P $ L ??h __U( 
(;7~?i
i~C	Vk7\9aK4cxġCEM PE PE PE  '  @v@ Q@ W_VE??G5*  ( ( ( ( K  I~?V|Kh h I) _@~9g $k>%ݴPE PE PE PE PE  '  @v@ Q@ W_VE??G5*  ( ( ( ( K  I~?V|Kh h I) _@~9g $k>%ݴPE PE PE PE PE  '  @v@ Q@ W_VE??G5*  ( ( ( ( K  I~?V|Kh h I) _@~9  Oھ??>)o7ig_x70'5jv兘H  ( ( ( ( ( 
.|/w@վ6xk\ik;v%͕IX4=9Rh ( +Oۓ࿊iأ
i6^	ifUnmxcDdFH`) /Gi_m?POh6uhU;IcI9dTE+I ( ( ( (im&o+z  |l巗C1{xw;^ MhdX2I0}@E KQO   Q6 Zo g#o 4NO
z׋[j>.LOkzZgemeg}a6k7? h5!ji7ZǂK6m%ńƓ,s#DX0Yb0H@ Q@ Q@ Q@ Q@>' x[^m;<',-fmcAweu&d5
iXƷbPٳߌU"@5.+6w7M閶vf,[:T` ( (w+'_񾟤<s<CG4?
[MNI<CxQYg0ic
چ
 PE PE PE P^+J  dh>>x@57Z-꺧Jaizd7ϸqM)AR:x}=~z|#zfal|I|]Z_vjFceb   (_&Wim ؟2|W>֚zi6Ǎ|k1,m$+,"40v$#~	7Km~|!?]h
֛I|Td(f#2,VԜ"@  ~C	#Vk7\^W
\o%
,(8v KFw3  ?KFw3 ?KFw3  ?KFw3 ?KFw3  ?KFw3 ?KFw3  ?KFw3 ?KFw3  ?KFw3 ?KFw3  ?KFw3 ?KFw3  ?KFw3 ?KFw3   ( ( ( y|-/?e? ,SL]Y 1gf<>
M'Ϝ%ܷv=p ~N| c# 	ρ yDZ>?9; Z??hKG'>@1 Ih ah <?- - ǟG% |~ sw 0 ~N| tߵړPеoI4k]jF MoLZHEq\[Cr/p/,m>W/woh?> a~?j<Gk[[yw60iucsWsE$k_ǟG% |~ sw 0~N| c# 	ρױ| g+> څ [>MOx: |TKJ^%+%,I,; }E 
?I/E?+G4
(/_KI`뿸?4뿿jR?V>ZfD4 fO*qmv__S'/_.xK~"_%x?eK-CİxBW::*=Zm PE PE PE PE PE PE PE |?gx>xV	h4_\Y<1#<bPKC"`?%'!Oc?_Fk.~s |9{/
[^qSŭZH{wFsB2ʌF%  >~wWOLԾGӮ	tEcY7PTApV%_ǀ>! a}koG|}>y~/ۿȗnv6=
o'Gf?PO k>6-tJ;dHy8cW5,T3%^ f33?:x>	<+k>	FaREj&QԬm.YR!4 lنfSǟuW;CYѯK,:u}FF[kՒɖKY$}BOww3?w>) x^VGZY&{;/bKaE-̈T Q@ Q@E KQO   Q6 
/O׊&6ΡbWi !hvsMMJAdV^ӡ|3$$o]Q%cxG~<1xOּii7716G<2$r24)7; W}C[>ⷂt6kɼC_Z@Ӛ3uh6[@RyX]%O~|P/ ?4/>@ӼSK:^mݜMG4>d3F\2 QE PE PE r >+|-!-{Ɵ>~OQZ^>}>dE
oqIQY?G ຿ h%?ιSj{/esp
+/ԭ&ӌQ4|MpWS9q
"*RIv2^iOo_$_I]t_?imWJ>|<Q WN.^EYM*Kucw8	e '4'_ϊ$Mt%|a]̶A>gPm):.幻bCpk&oG8(_FN:#gX^5cVIs5v}MiYGto/<4]bj:ev-bI쯢])cl{SN5iIJ2IOTZ4e8YQV 
( O <_	|-zu-{åjzԐnaņJcd4|էBUvmT(o_ _N/% ox6#(뗗
晩1L,u&26E!|. >h~ _it F<o:}o+q[F}"%j-R=oW gHx[_8`d5O
_\no!7~ti5cOyl{6yP M|s'P)ǿ ]xZ:"~/]]v\}>#/SqJIMe+%#UG>'  WP<qi=sƞ=ahAixqC
o(gyO iYi'~%i~wo|1úVo7wiky,/XuRQwc;jM#Nǯj L_87m_mO
Z bamqwomi
M+ĺ<6DVZZ I^%燼a>.,_
jS麞ZsiNJ96dxJR$Wξ
f[k%i4~E~ӿB&o-cvVVC+pY, FҦ@BX)S-ڿnkJN?oؓ|}"n).˻3m#ˋmGQ,jv,D?-/f/ ¦$sHtL?>  ;f  Ӿ^;R|!
Z5i?4~"uowCU-f5[V%8
 0i+ڃw?-oxwѴ)M*[m*Zצ#KjZ}+}JS6kk}ٴ Q@ Q@ 4P $ L ??k ( |Vj𞍿 M}JբZnoG5gOKu-KV#Mpm|% šh?ؗU/~k-Uj>=Z\k~V]>  ( (:SL߁_<yxO|.	}N4$I$$7T
$sZEJSZQSmdնމ%ce)(]~k(~YHl!?\vwqxۮh\GuO_iz,oğ xGÿ,hx5Ot6IctuU =q_.L6<j
e~D~Ù-<)UzZEk ߲ ~|_ jZ~ KӾ%EQ}m_;x-E-rm4" G ~~>|ihtյ E  4eYo#Ѧu>t}^ SMWWӧ\/p?gwqgW:kʽ;be^PMTҌJMU)Ǜ2phhV)^-:J	M.v&M+$GS,WVjHuπ4mYc3E H紇Ķ򕿳U59K+i
ݟ  . ࠟ?~7^Ui'ylͻgwgrF7K	K,{ңFkNRp}UJ-(rq|:O
sjZ]%mJ)mPE E3	U>_=쥷n$4mJ͹Zͬ>!kSIn-tY8TKihҟƏO _?|{־~οMN?)V/H5嶮fF @E{o\_FW^/
 7?'?_|_ >߻7M{6yi|^[yo =,m6)shѵou*0n/soS' _q?\Ҵxඕ[^JO5Y?_̈ D#& -}?վ)jfyk/fvcޟk5nt-a`>%Le:3RM5%'t-b?vyG;	;2~|XE¿?ᇆ5_}k!״uڇu7R;6;px.-"eU?7 h?hotP}mcYA}oC$*I"axrV*Zjꞏ[w|Ԕ%# > o  ]~#xQ>jZi0G2]~5[y=GJ~a&AWo
M,߶߀?cmo}]aiZ}y\jKm=W7C
;MYV}>7*jd A|u){B,c:50 J_4Ծⶹ[
ߡ5-ywN{qn; 
( 
( ?  q$	 dm}@ W_/⟎>//O
_MO25}<bTE59t,B1_C]m_ڋZύ>jٽK..g}S(6ڮk	hnm_|)
/{:o֓=I,a-k,Mg%h⳵/[:>-
xc>6x'ZmXo!լncYm!fxeHFeuue$jz ( (7 ؟ Z<~/o
pY	u
p\'K&	.f	n.BKEi8uVuov췳<=J5s';? ?b gڗWῆz6߂?u 7mG&ibuKʊYeRHgFϜ-ƬRHsj8JRe$XLG֨t䗢n) [4M]3K |]ߋ^
4;?]:|!gnnY-cHO2-{'q"x|zsX Xcğ CxÚD:/xY\Kqu7P^.^Gy{}1᷆yCV̱3lm9)4*.*mM5W$Ӆ&ԜdF?'_p|=i68Z9ڔT:mݴd^_7T{k˟ϦxP
"5ӭ^jqR9!K{`[>5? m|Dƿw_ov 'K6JO:m^//I
nj2.Y-5φViۧw̚X&I[N?/u0:rR&jJiYԚiw FWߟPE opٻ+/9n CO
X}X Ǚ}nyY9 
o]? K<Q R<E+uHj>;,|Wo
mXК4IUİ;M_oG~D
uZx'4ohbl!D*K"a`p7_ɫե/S B/K?ڻO(ց[fS+'<xVJ<-αauZ־|:K"/9%2  bf3/tៃ/
^5Ŗ%Xϟ8"_|HͳcX+s?晔K]  SGw/'6>|Gό|Msy;Y<9^'֧;Sgo%
1C' 	?~~*
8{)aMzbYm&d8h\F#OꘜfKJisrUwme{Z7å.şvN2  ?./_>X~t覻5i=EK~hRekLЈO3\=>lm ɛGWa_?O࿿m^iMoZ\@hy5u7wv-ؠiyhU%i=3	 9kx_|k+߆?cx3\oW\ҦO;J0}K;ȯ-?k?]~_Oşok:;VcӥC]IFd1U`?- aG`Ui7w|~:upY[~J(-<(>g
^mTk ( (   (_&Wim PE |Sx]fCŚ ͽ{xc[ֶEo[jRZf	⇁~3xA]$r=ŭŭż[]Z]$w60iucsWsE$jo<AΟ'CH,mt٢>:[jR\æ_]y<:DQ[[w?|=ew@ Q@ Wj ߆?bCrxRO۶kEӚ!|:bX+*i@Q33W>8摕_-zC#B|&O=w 4kOĽ.|AxZyWw{RNJĲ"$[@|M  Y<c /||9~9Ֆ\܍c\k;VƗHWO+̶q	ü:ߌYaj)4ӭ
twK$Hcnt*k_S\=咻Zݿ3_,G <xJMFm #m?K/6CSKi%>nus|	J, ij/]? ?||]x@4ɼG_F+cCbmo{{+=Z+;N1&%ܼҮ۪n,Bp]J	3j28lڬ/`()6QTӍyF2'LM
c]_.uXkѴ=MJXcQ[xwp0/n!kҒKa144qxoe^j?9A.kݜd&0Xm	J:ja+mk{QJMW2PE Bك E5,S lI
 QO t~xL+x'%){්0wI,Ơ?7 |꿶 eO
᎗s>DmķދI#6<Yּ9]ܼ\jȞU
d`_D	%u?J?,C?L x_>/x7ƾ4GH2]n}aj>t
áKK#1 B?:>b<E)M-Zuƣ$i@spۈS{~ڇ	}G~5 h
k/xQF-oT+ww=6ZKvgP h>.Z??pZgԼaʋ7^\u+ő3&0i;>k\SqN҃y-=-~͢/E%g?W8/!~Mu%&/:zdhɊv]R7=7f}I~O.. ݟ
=|h7^޷Esw$F+M@Eׯ2 \Mk~9gĞ)⛿xNHoizZ^fmynخKu\-
of?,:o#b {'kh寑y{| ( (?G	% ( ey _vE P_	|w~)'ǯ
' D,}|s]bK<ͬ᷆-f?:am]kosymklP _s|R-^?ts>#|_'it;Bl.~uyv nl3\G$qyǩџGd|S ^GPw/m<zV02M1ӬuY`+cPE P_  F|dj(&WmNo2qx_
[UmWRvK&c-ω-Idi˨ hglV//O ӌߑΜR1rQ)$SmFMYajR^2~Gu+Zqm_FwI7~?>\?
˩LtH/tXX}ot馤	Gwo
_ڿo#?fC/_,<
rῊ<!{)Yc:Vo,-{.k|kz`S:;?oЩdvrxxUni+UhT9rQܣ8=TnKQi7t Ki^XVHҦމ$TXWL5Ǽ+-/'?;.eOGm^ 8XcRHT}B	̪øJSvJ5jkG.TJQWbgsJk(nfN<ۓmO'W vB^W?G>֡++۹'tk;@,o.7?ixZg|?UC_"k:xZyz^j&}a|wvJx.7?aQGMJpWm8m
0$͡%^4497ݳΊ ( +4]C/u pjڿ??xN;o|==!@g;ԚY`]lmPgqR˱*_'+> e to-
 ?O/
`ᕖi=?q^zN7d1G
O9DFaP߻m;Z=tc:Pʟ
   >^a)xK~çnyc~2ͥh	4C,EdG҇G?`?h -_t#:~|}h׍+LѯbxZ.(1C[(jj
_g'[t/Kmeԯ'Ծ$id4RH ~ןS__50i^+:YOT{VH%7@8KRrvp֟7cz;*?__xixiCaZ[]6k6}}r,6SJFءY\#0?b//~ȟ~ =??\<}Pҭ.nfD-4D]U  <kLMk|K~<q sU'!~?j k=_ ~3kXf:HTvdPis]\55{Nmn3A' & j??4<s C
 ej C@'N5MG͆K\M\  
u_
 PE PE 
?I/E?+G4
( 
(~; hEo>+, V:'$^ cxHV>As;> ky]oϏ4h9? =u+ٽ6oaYLR}8i7MفNT{9kzw
? `mOP5OӴ[['hncx_VpibEVs;?WL_G?/ G_
fxjχxmm#Q$l0̅BTPE ߴO~?O:i|]i2e=Ė4rƓ,sF)da k9б|mwp~)Z
GF{KKu7,zVvP7ikurO׿e!O^h|iխ|Ca+ңg$Er!Y7gIk**^Ia6$jBeunH_6ѻ>sx{0:Jbt$ӿ<m+uE$#W|`漶_<5^YVL{vF* W
Ex2 ࿀w [R]J/NxntAmc#=ŝF;Ux{e8)-rJRnEFwrV{98N:r%92\rrUUD~fmG-;?m|1Vw%'O-p]d[663@H0_[n5?Volt(,mxc7FHRŊ}/a41߶]w+k=eQoyuQx}awҝi|o}=e4W Q@? RoN u P_ s YP_w 7A|?|7Ěf7gm˵B e+?yxw^ !-WZiQ\VsƲqo<E)#et+
}oe<R0L$9-{ y hL GEu|?i,{
FN; E_csu^}^k:ڵ{Y.&K~ߵO싪/ڻǿ|s,A=k}x_ĶMmI-iDSE[C*I7V
Yl_s4Z?/XGx]O7Anu^Jo/.[R+<;[NGx O-vg,F/s6֩짮 ?"iJmjjV_Ew'Gu \) m5-KM7tn,.;=2ݞ2@'2wG,2F20¿ Ŀ#<q sUF-8O|wS>*~k6-ndo)e!%PA,a
1 /fo߳* Ҭ]l_mI}\4mđJ!aPF   @lWêh 
( 
( h I) _@~9ݴ Q@ Q@ e Vmz ׯlu\y&KVmzT)mmT5(&SO/umP$uKYY9ծ}<[^s36{O˵MYlnG Z#.^E<!E*Py5=O6$'Df·OmeY77Пszï'	V+񶑧Ⱥs?^/֭
#X:>cNڐc0x̱F9  & ~+U>4R`m'I߯4F,sĔTO??i
j99xC	$nxM,m)K	e&XF`FaԐI>?_O (_#?췠x_׼+\ ^_/b2* 9 1
/:c¿ /t}w6^kmFI֝m&3G`M)>w(οc)Bߗ{)dZ.GpxE[kI.[˭mOݍH@,t{{混RM$@ `` ;W?c /<S:x;?joCw^f.>[Ymm.$%Y ҄
s""%_LwN:'\VQOתOtг+NmtQ[U͟Ps -6'𽇇td=G<ttw%ԯ~e2m	% ( ey _2S57,UdiF
9YmϕXq0SQR&O5v_f|(Q@ W qo[6_kyq?&pmǝZA?7̑5w^L|\8Gw	/z?%)/ x]_l<Qth%|qwE(ֳ][-RI(fU 3 J81 '|Ov|KΖI51k=WdPiJ},r`"G+
Je[[KrM-FbjiI  "~<xn l>3 +W#Wy#YV9s`e}B >F?c//?߄5o }C_l؈2oPme`a*Wwzڔ_)u뭻3Vv?[io٧/7|F. 1hL5Gڒ\nIw??k exTCxjZZX
kYӼkygnetBFѩJ8.ite{kc
 ;~5QW' 1_zu 4]OĖZ>y{K[_RKҢO#-3ܴQ)28	*$nS9xA> ]~о'ğx`.n4{/\ZŞo
ޞY&KdO}Bk;mq Qo/tI8Ѯ| xv
xRռ
biڼp\kuV-fܣ5 ~E|1dȿSf_~W_$-w>Yhդ3iYFhh 
( 
( h I) _@~9ݴ Q@ Q@ Q@ Q@ W k~? _;߂oD8EivxK?Ei:Ƣ~3In%Bh ?	  "1<mlԍτ<SRKNU³-MkvK+qt%o:'j-<?m8|;'5H.Zguh"M5܉-O_ϸR6،[%v%n])]tI;'sn%R;{Fջ6ՒJǓ~RO [_^6r=@בIj^Ɉ5R2KRy{I>2-BgNtߴ\ giz}vpy/$ypymI>el$V;v&ZIF6{ߛ> ͰzUhN(9F^Nkk(|n~~sDr|w&kxĺncs}$r̖_o3G+o^|D h}+}:i`4O2k!+7{+ڭs}YE P_B ~v)j>	P:uzuԭZ8nfe2- ߵ 1 R~ܿ d>.|ij7-ҼExKD%hz5m#M9,.lAk
Q C  KK3ho|C?"Լ'h5=7`] KhͪGyGo"p.^'+XjU}TuM)	ii, h /
xOԵ_ikG!4[m:i:Zj'Y ]/ kyǞ	ѴmoZ5ZIOGlu9.-o,kydPEq~/FJ[vM?ka8Oڏ)2o C~$ GC{`Xfk-ϯ*}87Cxv{-Kৌ|AOǈJ[Ƌ}pִɒ|yR8_γ
9WGIE{ѾWjo%88UIC|f
>~]bJolt)#I75y#RC:X3 Cυ~!9 #{)+ȞI^%ׯ4c"#	RQ%PVUU@v 13Wg_쟫5 <_~w«c_k6j[_M.vD>QT!o9ϑo -4 ߶G|2|H?t=q_ƞ/tSowÐ[%K-FQmjCo2ڌO#/>0 =σ __w
A/ߋz|P@EHݶufkBh@?5ߟ g!0#s
O>Du/
-{XԴhzhCij)%q'u@ Q@ Q@E KQO   Q6 ( ( ( ( \$'O
i0[s&>
~1Y9e
%Pxc4[[/_[G;U WxO7IeC٧MEo>
zuqk28' _?5д?೺7Wn/5_~ѾΝymqc%IIig+?,W??V?[o¯,c]мUco	|f4{kKԭ OYjMj5+;Yb?kŷ>3kg|=|LVk_
	c[(o.m먯mk*"=k_G[	}|S?n5h6$mAquuťjМM{rcF* |( ?	m|BGCmO[nv767XIYn\%MF\?Mۛ ~_GOŢxGÚ쯦ZiڕӟPy$vOU F `QD|F>3~CMJ<l>+Y"imVP\ [ &MAl M5O mt bUXV Q),Kq\$E6V Ѓ_~_RCo kOڷաue.C{cstlڥ&t*'v*JQw>	MO1¿~!/O7}'LǊ-NBno5u"Ly-Mw
) )?j?>&յLiEntl"O6a:Ewe,8oԨWkY+ݝ-5K;\q  |A|3 |ce
uσzol]մ;CdCwoO S/st gc_+EYtEM$5WӖxOc^6Z{'evⵒv]֫Hg}|  o|E,_~пHO_^%챷|uM!8n
.tij]x c+Gw1;ρnjKMMOS4WnZJ:׿eEɅ_B8+9RN"|˭帾W??n3=xş]ĩ1sxc7>MĶk$_iX'KGr#Z(؟*u9U |?/Z]xwڌwLo${Jy.8t{8Z|vKhcIGh:ZVM.mtVit}mXx_I). iZL<gu^Cm=ݍ\];x@ 	?<#J^njV]phqOoqdXVG2 Eo©Zߠ]|yIh_Z?+	|?	EҼeO1\_(<)tZj65-VM,Q(l d!gog=#z؏mgT:E+K<VwR:neyo]o 6Z?7i?/C.se{=uڷ"#ocY4s &~Կs ? n(׾ V/}_ YOء6o4<kT ( (   (_&Wim PE PE PE P?-WEi>>ٗ^-=឵vº_j2vu#Zf}F7aIu)v=^.? \ \k4Obլi}5mo~ewqCɏͫ]	.ۙllۏٛ Y'~~~:nckP=}I$w:]ψ./fҦId2lwr~E SE  !mk?Zm//Z^ xy&ѭ7tN3䔂? yۿo¯{`̈́1xDk|'tk$3Z(Q#%0Dx=5|>t 	cG,>K{	eŬ|[*̤\H/d ϧ0?O?'^[~՟])e[+K{w
haaYF1Ar:0dE`S 'У]Oc7	KYh[`ҭ-'6MY$}Il>Fg ^'eP{޶Ϊ=kB] M]ϊQu=6InDV +.N?h'Om'|^5z@  <ß=V4MKQ+kح-^{5m`[YK{^? 5hM7  #Ou]x^x|?cI<-<V64v_)'J5s/w=[vz9ImvnP{?  cPw^  lOc-~o([6%KGĿ*nt˗1Z7W}be5_7  {x'3DTú6#N<H4mOKS֠.n..tLG/='lq*"h^%aRpJ7e+%<J ҿ?O>_ԟI_zusg͔^.k[Cm65:Tml!{C!II-~d%w|_eaƉ|/y}5f<][vޣt~md,SP-q$tkJkfHՏR*6i=>L^Ж8R_x'_Ž q}H׼g5ҼmS][,ah7;;uo x UoW
OXuc㥆HxU#NOck2X`KSqbӳEԥMyq?pP64 {_d$o8w; o/ڏƶZizS4OKxMvqgs<1Z}S_{]~Je>zV֚uqq<c(Vw*$ M}O
t69J^G mgy۱~ ub^3~z-txZuQ:N#p#
<f5/C{>|GA .
~ֿ|?h!%ԐCw2]}8on,Ӣyn`6̏ի->8Oo gD~>Y$χ -FA[73S[R\ј9n/#_Vk/Ld {?<go=K|?Ym^Djpl L𷇿d?8(ռ6;7[mbҥЮ( 	O&!>o"Le#)Z ( (   (_&Wim PE PE PE  n?o# e}r CoioJ$u]GFЮSM[;{dym7V>'4^oi>igiAommo
VE
qF
 @ Q@[ P	 Ey/ _/	?|{M[i3^Wl![i࿎գSi] oI~ڷ
>
~ >*~Gͷ4Mz.?ԡƚ6&8ۻXRi_f/i ? |Ys音υOϡ{ľ"է[6I}Ikڈ%a2 eO]~xK:ֶ?`nɼ..!\e+&ٟ(N%G̟[oڳI  i<?a藺EKk:vK.YIYVH|b=8n}o4#ŚƟ|DנZލ6mn/|Y>.*=ͥGi|O~, /|A_W\sN,'OuT0k#}j-B%+{LTWiռa։V윥]8I'Sl^G&~~0ca'oXEq'Pτ[0񎟢j24=cZմIuah|k7O	 5x_>|5ֿjo>*jw]kQhvz7ww};hO]MuKJ0tUjZ8蔴cu~i7GT@_"O%'9v
#?W
Kᵯ/3M>B>ݪI\soiq3@67\/ F?/?i'&igO~<W/M6A[=Vĺ;L-5tH^AxʮQV*n+'em +O
7Ad?c3hYl5;tB 8t[Cy0W]ca
𝇁⿉;y>)KΚN[ՄӭdmE=-HNJxZ5uS^ZoKU3i${O:U s3~.X
i%7/2$z֑4ڄp\^\1)Z{
9m>)w>9?W~I?e_xA9<h_3P
BK8&	)_/74IٍRG+X/ kچFs_~ї'G]kn<$;yӴT0s,̗Gַ??~jZO{h5xJ	. :NuV{f"Ugt%3[,*^`?c+ܫ6Rvi]V3x~t/W^|s鶒wGsAcu(v#Kh'	O|gZ5=w5i4M}xk[}ww;YvqgOz "|Y)>çhw9IΟܽ*{ZH#Pmɒ(? 37o
#c?WUjW3k7V6ᡏI]V9IY=EL_OWAh_)F4߈*AvuIK]bh^y D2Gf?s( 
( 
( h I) _@~9ݴ Q@ Q@ Q@+׿$O ~UƋRJK \D#uJ!fҬnm 7Jb?V_?e_
Ou.{lswwy,WX\M+0["$@ ~|6/}4'G&47O>,Q&TA`_h<ω/&fUi![S2bowo$7VMo<R\_>(~ go
~˾
4uOB4ص-Z5@idȞ,S,`pWo  xźdg|Ju/[
RHlT_jM;uM^HO&FԾ~ΟV&?k6״-{A
>!k~%uNho'5	5&cuiv6\sm_Z
{ m?KB	y_¿%g~\kV3I}[Y\X\4&.#m֡v%Af mW^?OQ?asc[<1 	Z"Z5vQGe[-y6KLeYOo[пk7<uj>PtԡѯRKWxylŵ@KF"0 ?mKd|k   h6V.mxCWI^xxD5)๲F	S~/|-M'
ZUu/	B<]4YM֤ibp=m)+Y;sJU])'}$;?LK?ٿI9 m č*[we=)_xPbn6pKuαi[|/-|s ا6>x@4]^Om4	֒x^k]*h/,a[+?!ScexgO^Ym8;-n⺧Z]]okgƯ Wok;OM֣my7u>wsy.D
;PIi/I   M_ڃ=@|ů=Cºg;DPG֤bk4--
1;3{ZpJ)2mJiIYrv]+>Wχ+W/%I/vk4x3
_Sb.uK_K{}?Kִ)VV(H W~
ÿ
|#h:eu x\ft#%ak6no[!#[Wi4X:7߽+/eWdI6vÖ֧Cx
V obbqnxrh4$sϬj ei4  ao 3 TWO
2C]^ڌEykb^y]*umit}aXKM,vrjO_ψ b?d^Oڟ<]Gɠw!jƱmoEso,7k>R+uK]>%|3O('%v5]wWp]Nd|C&5uMB[.9^]m}Z^^pkoT9==TcedW`w?'?|o  /3
RzΣ-Z)nlt
:w0BG\w[ NtV B/٦o?</A>kN|?}NO Pkl[\jM[ݛiQ5  o?_^><wMVt9,4聺d&UѡHgmJ6
~=;7þѬ/No"#2i $,Đ ( (   (_&Wim PE PE P_˗oCĦ/;>|QIL~
q<fͽ垡q:Z^\Ʊ[+/ٳ~|{x[,M4-.6X,33ykIYfI%ݽf
( *_[AP߄>hz $yWMRMN{&wL(_Q xg H>,͚ Zkڧ|_R"LҼOTu(!kKMJ>#<o 	X,>;ˋ{aeŬ.훗* Y|X'4 MGW>&o`Mz:V?yo{1̥%%'  K3ƃ˸_3Vm4M?#Lo94i (h ?쓪 #Agui[J<˯MwyiؖE<*%i
4 wį?<o~n:m
X]GI$7)įo<
Co_	?WSе=UJ<5NgH,u&<-c<$$2dD¼jif?-O(7nO |=uiag<A<+Zd{=N/cXm.`?D}_W~?n .t4Z|dH4xo6{l(JxcԴKf- M	q
_<6@L:oQh׺W?g%狯$F_B7[I[PK+	\:Zo*gWǫ||5<?h|/C~2y}ɡ0P鷘^[KzuCXo >6>8 ~</_w~ywqk2k]i]ZK) G~_-(T7exFqVjZ^V #wdJ7G¿	35iu~^\iͣCimrlu-F[}Gz;=?Q/2<9*~|:	l	Q_ hiSkiwcv^t;]NQAtV/:+^tB4W3qmw{T~抍鷺&fz]gI q|=~ @AoC x3\]N?PqZjq_j0Z60-Rx!Rۯ
5Sߌ]oZziYPU!ZLX..&'Ӗ~xԕmu]ֺoG+~	~WFoK]w~&C}k{}W zvhtOIyesqkȦ )qk  {_n+UmyZYXxD|з^hF՜_MTNuRiFqnjۥg7n< ~߰ l|(tzo7eᏈ*>U/jM-͗l(u	nKK{8w#;  ?~ ѿh_kM a?>WY{YZuhgiʩX:(Ԥۋۭ{iCI4K
 >&d|x  cd]оx#"m2,w˧<XP+4͏ `ÿ x<]Ҹӡ}S[溞RԼ}o"9Ql">
( 
( 
( h I) _@~9ݴ Q@ Q@ Q@\Gw#	?n_ZDOû\[j~ csy7ZZj"vԢ#RK ~?c	<3UBguTN"FzrjEgG$6@LQ@TڳP?O>__G_|z
./i6w:mj	!,Rcxef`+ o	_Vc"xR?
XϤ#pzݝ{w.]I,ɨLc/-M!dWVl=&#TIPH'$sgf8(7˟X_Wټ+WxgA y f42YXW ds۫ #K,.  ~WPOoz|'7(|V^5ա,aϵELG  <M ~L7O`ҳk"N[ʹwS$xQK ",W!= ox,R59wfGVG$E"IMKF_?e_: ZF~_< 5H<3ot˘am;XL]7Y7a%wE{OgOڇත~9-|A[9}eyI+IP$y7Xf'_K[^jVP~~5O?^C~md4UI%=>eRo
??j3__JOCe  ?j-sF+/$_NfMY!յ.Rq5֊\K*=Oۃt< uY =oٗ?4ҟ

wJE
q2O\^O]XAj2:VqkYSѧ
ۍ_?d~|'~mנW+3 e#>]m..u;w`q-ǆ{C|#jo:D>$j~$WMICiU:V\bimz*S
OsTwqVnwQn-+ku'w&
aGovyoᏏ_i/ 5W|3O&wg*nQՏWP[MXx T NG;&/K_5mC]&.Ǿ#u{-[]ļl7e{oes{ei+?0Xu1*6%b+}4i[M
 GGO O]/;KÚ$~!Ҭn7R,o(oV<H
Sv  Nm# oj_)DC_xVixee_j6 bAhg]Z2-cF|Ɣp4W$c~y䓺n׳z;P|S7 V~ѿ_ G/hacCյ(5|:{x nw&9`H4}^[w M% `S߆:j->8^#7;Ȯ&ͯLm%+$wB<5P/ݾS%Ej 
( 
( 
( h I) _@~9ݴ Q@ Q@ WWK ߌ?f	X|_Fᦕxl#6gq}xQ֙4KwiWx0 `_ C|}K~_'[mk/ϦZvOG6\c%܅-w/.k	 s jZxN/x
-%ޟ}ɶ+}Ճsg'd_u3o #k|1>ӗ˖E]6SF%{g
x>8kXk
l-]#W",#Ym!fxeDՕA_w־
|= *t_fbBm`}k2\AE3^ڰ3  f bz^lTwWޡ#UǇ5H!閷wHlngvͦkg`/ w|C7=1mL,K,Nmhk}vkfۿaO8	s^
7/1k_l΅M+^ǧE;4ۧ D~Z90M[E펫m`2(轛r9̖ (lco7?
lq%-?jZĩ
V,ҙH[uC
 Iߴ 	?/,k?t}̋ 3c߳n(/7H2~GNu; oZ}(fݴy,2k߷wa`
<?;^{Y^G3m
GV4ein;E
 Iߴ 	?/,k?t}̋ 3c߳nD'W cߌZևJQ׿5uws\G^uX<.mFëaU   q//)m
OY, _}~3xg_`2}V?٣ ?gO}g[πf/6^hWin-e-divWX$F8_>f{ܳ_~WJ
{A<
wQ|SᏏ|	w>Z>3iݝ|G;zzn]3V`Fm
]QF.}-?&1m =Q k>k|X楮ͨh?&ՓE+aNiK$)Jm\^ܮ˪w] |l? _<|(/`ZK%evi^TV1ivcsJ M_%x		=CCIp_<7_A3\\/."Ϲ$
O2,^?/{>s>H]ӓ~{Q-K
WߏO Ŷ<sma*6KW6GsyyF~x|Q/~|s/E]f[;}1u
s\L?_PЎE}mo9''v]  P>	 i߉~EesO
XxWi_kGHwkdԵ,.hKI	 
( 
( 
( ?  q$	 dm}@ Q@ Q@ [/)F >!~vU-<# CՅEz%x#2mimIIl'[Ke Z v_tψ:X$oR]ּI}$_jodp`X[݀>}  ?lO(O?|>3KG >hm|kgPN-7Wno)	=MjMO%4?3_/x,G=:.v[k;0[s\Xs9a{x܀5_`j=N?Vw>(rOo[wkX῏Uk	 д55K;O	e ox;	5	Pa7beXNYC,Cs4D/%J_DnOЋ|D@1O=> o|\_ u <7ǞԼ~W독p2[οuټ
GL]oE,7Iksc+$ v+Tnɝ\"ܚ/9>]tmG㧃>
xowZz~!5wG_Q^%Yu5ާG=kyek+f AطP<c:#P|oǟ-<95ޟ
ZY\CsmIe,W!mV0RQfT#5fŐZE]iu*<Wr\Mc	Ո*8<WQQ?e;@Z_߷Q?2Ib6PhWwB1"xefՖ+p]r Ue_3~ɺN
A/<WmS}A[/q!gK{(khXƯΟ)7[+υ:]G$hY{qqv"D&9n- >_ Gl;|X:xv+°IskoqzM}{BOYG%ԬMksqP.𧅼yO>Z}Ɠh7v:m
ŵͼ$NE7c߯)'~ u0%87w&h40pUx.mo-T-~_9'$/4o <.C?ZnsZOaY%iZ g^nh.5G|kk d bf#Ǻ_~(kq&a-Z?~$9[auy$Mk+k븣{-.P%MXژ.yc&i%Ko6~LRK_\ۃӴ{k VP&kk8]wPxuҤxcdy;~<owAV᷇P-__n{帛RՍv{YZoio4(SQ
*ъ9mݟO|EH<o *5
VĖYqc%4MukGkY-'A<Z3~Osx
<h.i\i>s]Ov^K>q7(F
D}YE PE PE PE P @#  S 2< sMh 
( 
( |=ſ|5O#y5mU> S77,-gi̗+4F%D+K6:a5O,X}ۜg< _?>~#?; 	+`ڮ1=ZKexi8bWX]1xOh:o 4 sC7]
J;4Eqw'fH3Wk?:/m>-!uV/.9&ſ|sO5d+s"\JWKK述w[¶/ xJ%?x~
JM=X[%ǛRKY?AY;'/?~
.z ٙK$Kq+<K$$:US,ne+՟u)16~w_!ugO|<a{폈mU/NlȦ'h%繅'/|J1>|2gCw?_3/7]Qw|ee/pKk? C>(H͍ÄX8iYqOQr4Nۉhb#u(J+VQkt?z,( o?#l |ڏti~3NEH6ݕ[oex^S+jgwT*,K1t죲wZ2_ {4ֺɶycZK ) \~|2_~|KOÍR+
CHԼ3V>D3Y}X]<PF(
 ૞C4Wך^/mdKkYal,r5b9Qd mWOڗ_j:'&źW-In<9L#i,f}J䅥KI <7P\\D d	?i©e _ 	"l4ٟl I|#_ R
 ğ7➪CjO[׷^mO
-$֗wp$  "Wo%o?Z
)^x[]Ҽ=
_i7
7Wmn'mO?ZVKB_>[\/奤woln.T_:B k5J(.v{+۵c o >$gx
S_ׄ ׺vyҵ\\i:n#]Wςybs.Wf?gs>eOX$n헳s6zۤO5J4ւ= ( ( ( (   (_&Wim PE PE |x~ßClN/S.-!<3Fڦr e̐+t9&x淞hdb 8?d
^> zgᾫ|sG'{٭α%WPL+0
[? oD>Hi&}\<7O/_\,-+ľLp\y?wG UXj7<UZ&
-.QԦK{{8dM:[k]   v~$~ ui^Լ[YxIռ;i/=OLԾ}BY-G$R173
q l X?m $?||
kּWϦ^uCi^ӧ[FR{Q}hsJ= . Tg&su ohW/Q:V6fcu\ψdx.7wi_ŏ ~|%a.|/GrךKtY|"Quq"i#y>)T5X[9sw*?%w>#WNW/nݗ|C.A4|g $
/^mx-/OM
4j+4h${Ef/&Ǐ* s7<Y~/z7<,pzl޼&]Ae8܂0EzM^&de{=,zYcrmQ$)Tuދ]:^Wvk8ıSןqǨ5^N?<
( ~
~?|Jum}#6H	4~|F	b,lJ݋g 4OERQђ%v gyao.s< (ۧ   |z?_o:.mQMSbDհl	͵,m noo<BMZGWHd(f#iJ+jN@ ( 
( 
( 
( 
( ?  q$	 dm}@ Q@ Q@"4r(d`C)_o"Wj nj:Oi4466Pr#(bPh?b?f
jC>	$ծxkMno(^K{h6bƤ ?s
 JٿTxȇ_im_ko\idI|^c^7٭H?(~Ͽ>~˿߳ ?|)zj0ZIWyfy&ieY$Gv Hφ_/Feb?ZV3 4MGry.,<7kcݬnLQ?= wxS
 >gq>'|1h:6Ԟ;MSKxֹior,d減VSO碊]u>ӣ(Ɯ 7'v+n?o?:7SS|^c
{\Ӓ=#~([xNt)Io0mn$ŸiCy_ Z>+]+>=0UsĶMʹϥjoqrj~TEhG	fݵ,\ַ'm'.ҺWR&',TlUm]wVn?3TtPIɒ<n1H9:VG!zW\i ޟ_ 6GS;0+$rD0D69/$gFDp@ ?::m19x]Ad 3P Q@ Q@ Q@ Q@ Q@ Q@ Q@E KQO   Q6 ( ( ( K
(R _7[   <m.%v[ͧ=	P	t˧Emܨ6 W(g|O oٓ	]NS{[x~?whW}j1cK͔F6w~^aETp,(s_OM{p8aVcUJzF*W|wnO׃ kU>zY[:Y|Ju;M7L%ڵŷ:}&ui-ōֵŧj!ՠ fP,-ৈ :?<5kRG.tX,+Ya%ڡ-⼴Yͳ@u(dfU)FUFZjڻO+$PZIFzƜ=>JWm_N|Q@ Q@ Q@ Q@ Q@ Q@ Q@ Q@ 4P_O8-CO/ l쿆~4xwM {[/O:Iia<]ݶff$A }?  G  ) }?  G  ) }?  G  ) }?  G  ) }?  G  ) }?  G  ) }?  G  ) }?  G  ) }? >[  >+sDᏏmikxv?_[X$%wDeyAF.¿8
CZ ߴz_cizw4ypM4>嘒?C 1SQ ?t?= 5 C 1SQ ?t?= 5 C 1SQ ?t?= 5 C 1SQ ?t?= 5 C 1SQ ?t?= 5 C 1SQ ?t?= 5 C 1SQ ?t?= 5 C 1SQ ?t?= 5 C 1SQ ?t?= 5 C 1SQ ?t?= 5 C 1SQ ?t?= 5 C 1SQ ?t?= 5 C 1SQ ?t?= 5 C 1SQ ?t?= 5 C 1SQ ?t?= 5 C 1SQ ?t?= 5 C 1SQ ?t?= 5 ~	@         syntax cartoon.JPG  	@        4    JFIF  H H              	
       	
   } !1AQa"q2#BR$3br	
%&'()*456789:CDEFGHIJSTUVWXYZcdefghijstuvwxyz  w !1AQaq"2B	#3Rbr
$4%&'()*56789:CDEFGHIJSTUVWXYZcdefghijstuvwxyz  4!    ? dO?_ >.|\wktm'X_QvYYoeekoPAx$K  |~ Į = yO%!-{ƟS>~OQceҴ;Ϛ;x|G>dE
oqIQY? i /  D~!i@&B KtG 6i /  D~!i@&B KtG 6i /  D~!i@&B KtG 6i /  D~!i@&B KtG 6i /  D~!i@&B KtG 6i /  D~!i@&B KtG 6i /  D~!i@&B KtG 6i /  D~!i@&B KtG 6i /  D~!i@&B KtG 6i /  D~!i@GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = |n^o'

  OMZGSCIaK_KB-QM? /m(  _ Iy ΈB ҏM? /m(  _ Iy ΈB ҏM? /m(  _ Iy ΈB ҏM? /m(  _ Iy ΈB ҏM? /m(  _ Iy ΈB ҏM? /m(  _ Iy ΈB ҏM? /m(  _ Iy ΈB ҏM? /m(  _ Iy ΈB ҏM? /m(  _ Iy ΈB ҽ/%W#C߳>񵦟&u+_[X$P̖/DeRCMP@> m~ R>?W|q 枏v E#%wi  m~ R>?W|q 枏v E#%wi  m~ R>?W|q 枏v E#%wi  m~ R>?W|q 枏v E#%wi  m~ R>?W|q 枏v E#%wi  m~ R>?W|q 枏v E#%wi  m~ R>?W|q 枏v E#%wi  m~ R>?W|q 枏v E#%wi  aO+:6\~j|EV>O=-I8h/&Oď/jxʏsg/|V a;~%Ư'Vm淡*ngtl]f4.kbiZǚ1i+?g?=~4 ? Y5 0
Xj7HGM?KktD?VPE PE PE PE PE ~x	om f;CP^"=q5ՑX&?Cӿi?
|G7~
<5W^/u7ʺ'cO]Z]Z^XjZ~D.u9y^[h@>
( 
(  _঺o h]#g N?
+ׄ<[Rt> 5Lu[ZMyeqey}$7h gw5~|!jZ?5v77G/s%QF4pAJTXcRpE PE PE PE P^m~	HSO77>M_
i卵q
\o%
,(8v]&VW  <?LĞ
 +]Kw${k_"7P]jZfsY[^X
:5 PE PE PE P_L7_;}@	2>$~ ST3_/\K~?l|#g}*;m6y<%w{OF~s[ _N֝}5aۺ^xF
74u.ofK_~ H~1⿎߷Ρ?_?e|4^5t}:JVE^k̵dexa /~߳~?!-f/~ѿEx/~mJ;YKլ˺Z7 ~ӿ/= D~ƚ?|!4inu{MuN
`kAZ7o*'6k&<I#C"oK:ƏCMfHo<'$ypa[S\^{&a
iR{ 8~3~B[jzև]'FtR_X\n.m`/ٮ.dU9K

?~^.5
x _4-/Su]nuN3[*ɤo=泧k3:n(=
auxwoz<msw>h~ټ9c_kߛ{tFO&9,$Df3:G S??|ßֿu=C
ωV+?s=SV{ۄM),i A a  ̟$~ ¾ /NԢ_LylE P^}鿳n"H~[~ΟS69O7pͤk6VHF-N·T4NHne-~ L| '_d<s^jS:,ؖ6wW@#K_y"ϋ?8K4oxb :)~{4ϋ.4/<I`u[[)oYhq5xxO
 y<u_G}gR?* k 	⏉Ǆf
nYc/e58b
Y@?nٟ27?Z?h߀_~:kV:xV|=A}oם4iV(/G[Ot m ~~=
|% G A᫭CU IcI?e)+@4PE PsⅧ:O0R4{]G>f-l,"C$qi,7ƓX}E PE P_Q~(# 3f|5<ccs2f{_SA&oqlz^_ٔכ~-  S7o.
G K>i? />+b?|. <@ž?h	 fy{=m[SPdubS}TxCsS~#gRχgº]2-ghVo[%V@ZIm=|K_%*i;_GCMS|jv%波~S1kIomP$zZ' g
Q ?> K>: e } M χ ?e'I hw~_ mkW/o>/d<gYi:WCH]/PuyS
I-2ER[ܟOφ߶/) o/OR~isiZb_E3E-s6t<ײİx ~Ӻw_Nď_?jku4k>-/|?;-jyH
wZe$lm,_OG?b  w g"I$ me0Z$:
jO?bCC">87G珡^ ٱ.n<m-R_4 [Iړ%cx_V1|4<3L dFص/^,Nj7cjpȒO+FKq7K#JRۇ/~*X- Ş% u
jm[[_jTbi~ãiZ/)qqo5?mE a߀o
xkIw$q
U֙}
n
DHР  G|#Z1x𖗧|Cطo[ˤپzB6MorewH 8_J !; Iiif_ d fh~o?-Pb?~)pw2 iյ~z~$Mh[_tOW7]SC\ZjG췈Ag
?߰o/U PM4E팿 pV
EطG)5bE?_~?6%m7
Wj^
W^iZޏxD/VH K&9V?  <x	5[Oxgğ ψzG(Yx_UW[5cH"kI;+I|qJU| ?l q'4ć紳٬|Ai} ˋ估/- v@ Q@ Q@ Q@	2>$~ SUm |%  p eOQ  S 2< sM|9[o{>&h}͝ΩZF'i
yȞj)tܠ     ' 𶿳 &#}?/+ڼ 7	 =k?u?ށg 	}kOd|7}h:v=\W3|6R
ǳu#w?ͿÝ<_nUeuַVhV8`< /fg__$)_mhz߱[:|\ǲOʻfR7 r?j]>4}hjjq-.jz|VZݬv&ɋ?`N  _W^?)?&zG4;>h}oy`O"/_~C#?]M~$&m~?'ĺ`֢]E4\ZG1r}ك_i? <:|Yڞmo==٬$t[dfR"cj@>|^ `~  i??}ƗcűwC[:?:v{{bW]^J]D>fg__$)_mhz߱[:|\ǲOʻfR _'_M|
'm~//M7b<!COũZ^cOK˫[/cRhdhA?'/QR5O t{3"麆oamVXf.zב\-4<d9 L_'7|x x=_N7t}G\7=GNӯ`olR{VSkؾmx?M7RS+}GŚmZ,4}{o%dQE P_	~ qI//ωtm Q@ Q@	~ qI//ωu7WoS9ω:.qkƭy
cmMqssq3,pChI+*31 @Zߏ
?5?WW6o)[0?a@hlx-'>&|_m'|4o*]y?=	x?{ٷ~(m O~3\hM޻]vV&;ae\Z\&٭-䏡?7>_aOPPѵ?w$mH[_2RCflml/D08$j.& }G>xSP7:xc|<qDV;_]PJc,ޓ@	jL_VOw_h1/\[x6ڥIfvCz{x¶qhM*< R~Ͽ>~˿߳ ?|)zj0ZIWyfy&ieY$Gv 	iO\< d}>_ iI<%{♬^JRe֧}FEHb0\D!'CS buiK?/xi8Rh|M?.u/&5Gԅ$f%0}J k?h>xg@7ź-ŶZ56a=jd]/-ե2rs#/2O٫k/#<5]OQ>ˍB'P{7O'%mfª o'W	7OKd->Vur:u
GGծm!onIJo1 O⦟-':~ՏU=c(b4Q(	7SJ )k_xo#4M}iZپmgm#^xff>9 [}x@|?l|G?x<:5c;K/g!ԹTƝ%r{A{ |+wk+~~MωCs]Di_꺤׭^3jWj1:pD/ G$:o gkkykʎ*Jɼtۿ>|/ E W_w  }E PE PE PE |%  p eOWݴ'MG<eGKQO   Q6?5߅?'j;oß~? !7*/h6mqsOuۏF^bw+>Y
5 gK~Ξ0c*i>0վ$1|]lunl^u^:5ϔb }I {|U a Sg|;HxK=C,п	,k[5.]'n ۓ~ p6^NVh2>u
[mhlqھe%
g@<oSW_6 <K :^  jf.~K==VEBe]~ 1>3|L|-/d<3|AZȦ>:xM=mh[T <_T/>$|~ f °Ǉa<?\5kKI쵟^
Šylj7ym3ʆ? <Wf s;_{E[V]|KmsxqVLVIVeґA d__,ohc w<m
K|ux4&X4S{MD*]y)W9% _pQu죮N^WU%6
^VV56͜W5M ~xG_]~ٓ~:Oo[][V,`ںbAs5$D[ײZ>~
= q KR`'g^wxkT KO[,K];ڔ;Zv '?Ƕo;g_u{U^xzwĻK;-wDѭ`;woմZK7 J ?g
CďV|>=kƳsmii=k5!-mF/-yP 
%   
IG/ ?? 7L /|;#G~~74/>g%yjV}o&y66 :( 
K  I~?V|Kh ( K  I~?V|K
O	 73k^6־I}&kZA!ZIGHT@;_ ӿb!/z 2x Iks}
KLVzoަjXp&I|u7#o A `>(|LO ~&g\Fc=3 iK̂Mc,,n/< H$_߀<K xO~jvwq2O4i#XU6Wd>R>~o	|~g|!M\h>,m7ĭ}WRY
Kr4XPmhE ߊooW ٯgRúv;x_ᆡVǟ6xj%tR%J_Lt%5~Z/N
џ?hۯRoDz/Z:wѫ!ϭL׺L/HŤ@iчy[p GE90k,5_Of`[4k /w.h_^5
?:i<=*=Siwc:dt}kI[8n`?د#IG$j k9~/Ou}sY}Ωw/:Z&I#kK4.Xѡ` ~J*+Wi^ ~&|6|smCZDҵַ:]nmdo-q-7i M; tuٮ@t6P֭eKM"kv
J[\RPK   x?50T?  ַ$ {nE5 w ?~_o 
k~?o_폅9~??d?~/~\¿>-'4~@|z熵H/[<xJ:( 
( c8+g# Ug:  ( ( ( K	 &#oZ2h/&Oď/jxʏ$	 dm ;  
=xk_|kҼ/#>!G,&o[YXYO=
 ǀ?i?R~xCVKmm!uXZZ*L^ G7y$BBB t?3  On o⷏^FZTzޕ^V{X$S12.ŎˑBu_-w=>xο~ca|K};bWtN\j:}Ʃfmu8`Yf ~;G`ooICxCv"t C{>?%3IxKk-?W]I/7	&^)n)7ezo Ppgf!}ou;		t&Ӧηt4ƓH t?JۇC|	V  	S_ ٿΡ ٭|3wo>7~?i
i~C	Vk7\9aK4cxġCEzM Q@ Q@ Q@|%g $k>%ݴPE PE |%g $k>%ؿ(x~(kj>)k/O&$o.d.(nY tok:o%W}<S6\xu?YZjiYlܭ77sd|s '>&?6~4xC<ŖC7_YkًLϒ8RѠHM&% |[  zGǿz3π4<;=\ZAi73.ln{y'-fi _ҟ)ᯱmk_ٚ/^[|3ɾ?|ͅV`_)/xS#h<cŐ|7׭Oy
(t_XAn[^Z0є&Oc cOCڷZ-[Iٷj"ӢºdzXZLng@ :
ӿb
|uoVm|C>shzlZGdtw-E	&qτ[?&gƯ ?hߴN7
>PW?^8|=
dbAiuj6+\6x? E j߆0h y <_6!uM?|߷Ȱ63럶e3  yg$zxQψ|?qhfK}ON[}R+;[ gGE`; W;
K_'>Ԭ<scWkǂ'm,>}z- l/e}/IIUҽŏ.'=~??jwI?TW!z|C}%u-_K/'i2X[EqmzW) O+Ýß=_?w>:ooAŪi~LoqV(Io `~$~__[1xS~ [
gڤ=$m{meYŤ<
7"d?ӿJ- /~[jeO<y~o&vj (?ୟ_U( 
( 
( 
(/&Oď/jxʾ?n?|v թ*?_&Wiz% h_WOߴ_j_
[Z@Fm5:(tصek">n${ -m>6xG޿_z~>Ӵ=T KMoė7yں6u/a+K?JO 8<kFx[~_c|	7,|I	KjMs5ͧ䙃Bhd@qs?|I ?ᬵ 
]7kH%߀ ҟN%͖e/2[?7z | 
O/# h}
 8>m_mx<7ԟ y Gm/Z_ڿ  k+Ϥ dڼ;Egs z'xw>~~@@na۵+E}oWoؿ\{'$Y@ Q@ Q@ Q@|%g $k>%ݴPE PE |%g $k>%ԟO~?O:i|]i2e=Ė4rƓ,sF)da W7 9W^, g9]j	<76$MN]^ı\Kqm-[8Lv}_7So4| >fv?tGNL[_XIi2I4kVb\o4 }$+ᘿjٓ  
C   5mC?mo *M}_ك fٯ|k/#?غ/~%ѵBh-mkq'%]^2 K y^W?/2܋m#K&9)&gS$ib |- qr<!᎛_.!+KD70.>[wUpW|/ Kп
 ຟ hOV '|^xi[?!gEүtm;VԡKs$k};7zIo# R ; Yky֑xZM?sO/,6nτ@V 
~|; -4CW[h OL n?l?hȈGټy '5/&|־}/5/ `&yzToNZP/4FIf-Gj~}ZW L|-f#yriO   P;@ |$  dYo	!oɧn{y?hټw.uK|O 	?9\~϶>X}.kshB#MȲHdMПc#3O~|t<?h:ÏBhWSÓKA"5
;lngG֯>~/GOM'>Ѽ#jMæAf븡㸽Whw
+zM PE a ' l g@v@ Q@ Q@ Q@	2>$~ SUm |%  p eOQ  +lobz -~[?qxBt G[-.5)mdK;ph ( ( ( ( +/ x࡟Oht
[gfƛk'o+M\_X]DHѥAY! CO'K^(l/N>2i7$, j5E h:φuh<s{Ր\w4ЭGK5)/-nq|WoxS97k:֟ohƓy
ݎcsosmq4s,nG*3+) @@w(o?
?j  L=} \׼I7a" ( ( ( ( ( +_~tx~/4˭־	|-`t7^{eʖ} ?>/x@׼'9]۞b5m+ɶX/''Xe7W'<w o G 3 ?g& ~8 1G<w o G 3 ?g& ~8 1G<w o G 3 ?g& ~8 1G<w o G 3 ?g& ~8 1^; ;&Mc/_ Y&qy?|Ame%G6gstʀ( K	 &#oZ2h/&Oď/jxʏs/V n;?o%>V扡UgԴA;	fRkY1jǔjh+ g?=~j4 +?U45iN?l=lism}pH ( ( ( ( ( C<-/M? hsj^SöC
Ʊh沂dEk,zc[1}(~ZwOZ~* ~ x[vI[[K;
3OyEgq*Ks0[_
~&i e3vZٮ.>KdiawmUf Stk<i(߈Y|\]ͬY|ԡҴO

i_aOSSuob ? .|/C~o3G4;k$sx~,b2kI5KbE{iVKƝq~ÿGa}w'\8tm1<Cxs{G,
֎bK?<3(~߳ft x]|8oIl-5S=&'zg-cJ +᥯&VH%  <?S~5޵ +m7Kk_"7S麞sY[YYXG
?'#MC?/x6Mֱ卵q3Iqa,Hh،:4 Q@ Q@ Q@ Q@ W|n~~sDr|w&kxĺncs}$r̖_o3G+ k
ky	xO=_O$'|AwxCſ![RƝZ4M-זW7v6Cm[ĺf>O|M; ic^/7wNX&K$fB  H 6x'ƍ\֗]HǇ(q\ mj:}t˧Kv[cK ߚ^ ?c![wfx
m(Z%vT o KK)w8 .(  R?q\P . - "] [ K Ǆ?q@D  q > /|7ۋ+kZ^%ʍB4gq$J 5<3o+㯆FVi7#F%3O9bGXn+O*_ >\^Wƿ_'<UcsqghV"φ9sl#j:Nweyc!{{x̱;CF_E P_L7_;}@	2>$~ SUm r >--{ƟzO|QY^M>}I\2oCHAé ?g<! 4 é ?g<! 4é ?g<! 4 é ?g<! 4é ?g<! 4 é ?g<! 4é ?g<! 4 é ?g<! 4é ?g<! 4 é ?g<! 4é ?g<! 4 é ?g<! 4é ?g<! 4-|)o~5Ο\7+IƓg
uj>/[(X_Þ%q[-8x&/=?g ࢟fO|
>?Nk
i*P}emlR@u94+WPăkM7T KFw3 ?KFw3  ?KFw3 ?KFw3  S7O
w/ៃ
G>"Ծqs]O$Mm«1  :xޓ~
'|1xWZac鏨LZ^Y'I_:Ao,Z|
 m 7'O |Jִ/Ot+K5)mnnRF{
{K;2I> m ;?`#~
 rPVFknzJqi&i]DLO ֵ)/>?m7Zgv5	eĶZ`i0ǆQA-Kw7/XgB,k	(</YU'[>;kic##7Eu  a|x #~0Z|rI?(4f^Tҝ켙5m.XMXqg_ >t_ ?xOM&Xt-r9%-DeyAF.:	o H s@:	o H sG:	o H s@:	o H sG:	o H s@:	o H sG:	o H s@:	o H sG:	o H s@:	o H sG:	o H s@:	o H s_ O'~_|/ zǋ|/Ú^gk.,RD{xI' د	^?|xJo]Ú<sj?t<Po|>xг }  [ 3      [ 3      [ 3    ױ| c/ٻzgoᏀ|mwɤk
\$S=HA#DXhcb2@uM?<@73YǿX[vƞ<i{wYXk[GdS k ?e/)/D|J
ƾ"mhMZ?).4\m6[,X}G	\ 1NQi'u(.v?	BxI.#=
F*56:J)7&߻v~Co7xO:d[
W+cӥ56gk^Hg#W/Cm Y 򢾻+!VXLM~jrq\EҺoIZi[%I9hG{,eVZ,\ՄIBoIF9F2q:3!X QGCm Y O  C 	 
  D~1Ǟ,|xV G.峊u4獍Mvј'I$P ~?V~,/.ͧ^Q.W.j|vm{$WVo!ׇlye
Z],_.T⒧9+KJPOE(GY?x lিn
 |	 թ >
(/&Oď/jxʾ?n?|v թ*
( 
( 
( 
(Zw |aΠ?i>L5kt߉>剡yfHּ+i0(_v4C  Oھ??>)o7ig_x70'5jv兘H  (
N|o?? 73[ ~W>] K=ƟvzͦMcGԼC=̑NDO_!_
 cAÿ^3Ǌxw }CXwu4T6P*I`yr,|sO	g
2On/DYSy\g6-;I  2~eoX1ῌuZ~MKuZ}S]>VHbh[ۙ":4 ?>"x >j/nփ>yYYXޟ:8ZEaI2"*n8f:9w\Z}U[m CFcv}/ZV,~ηVrk~5s+49%#I̱*?TF{o_k:}֓7OhpYZͧX^%GWof7iy0;Ux: ( ( ( (O߂4/O~15xMMŷ[Iiyl'~)~W jOڀAcVw]~sq#HmoE|E$"[[k9$#Q {
Q|/ށ@Ҿ6xzkjZkx;Ŗ4?%ùYn5A8h +/s&? ?=g\=w`l?um'Ky7m{f ?j /| ҟB_EO s'z~ יt?ܫTrUٷ	a
I#մbv8Nɧ[[[<[iyH&fO   5/z??
?6w<k&yvt6b~]\ fB\}>apYcC9GSw;uRi|<&gg?x;:lqNPd}F<:a'|EMU) \ue& jc L🀿d+-o\|;KDTͿH.ȦiG1y?xqI;)IU%)(}Uqኹ2\%ncOMүZjF4ijJ+~ )f%<)ď؋V|q[,:W&omqh~lmwnUY<
rtOg);'uf\TTWx{Ǚ!*y9{9QjСBQTeNQU?nUYUyBY uǿS_7 _ e6m Q@	2>$~ SUm |%  p eOWݴ Q@ Q@ Q@ Q@+T^Mg_
kWVׄ\橧[Z^_@w^:yщ#2>,Md:e/UҟN|1clt[̲֟mh\OyėVf |  f dD߼ KX §ψ  vght/u7{Tͺ3mѵ96oE Q@mDh?|t|s~	
gŮ2\VS\GlIo3Gjƥu n~~??  c3ᾟ
+'|#x6CxQ=ΘEtiO-m>)x.~dT VmE]C	{-W>'soZ 5U?+׆MxFi3ۈ=iWjGO ٿ@_`[MA>|Jok֯hڅia}]F[#R_&u4sb6%Y(vgNFFe"lk|߳էV.obVZ595nHocV&_WN~|R|.&	
rg𞲃4khucH9&Htd_ʳzYYE{=浶a:n<C_?g>|7_-|:<aJxP>W?Lxŗ6wq,iEis}}y=ʹPYXHeVU
뙟O /_;~ >נx@NԼIT|.fH}Ɍ@> ( ( ( (7|Oh?+?'_ol~#VuhbNqs6{t	WSԴ۩c# 
k?hi];mtP^xZy,kqj0Z\EiF؀}>h_Əs6:#UIVS㸰.mwiq0@ W_wK ] y__SK (d ԏV<8 /. [ʏn?'{S>jɫh_h4=U/_Ih~R8o9lo6c:ƿF1gO{] ]KRaV>D:|Ct iICۋ~l=GHɫ^IEy_&2/
q^`eC>kSS+קK'*ԡ.eMƣ[ʥ)Պ>J \k; 5w[ύ=h?mj^"sʶ /&TD2A{<W9ɰyXe%$WWWMl5g|ǆ%<GϲiR´ԧ78FP
Ӝ%ps?OxV>\5W־%y;H|%=;iq]v_ʰT"~
ݶ}mYkJό3>|ËERR$y!iӄ!')9O `!^, : c)/jx2< (?n?|v թ*> d ɸ|H  V ( ( ( (W>~Ѿ|/΁ot[mOQҵOkl{OJ4ɭ_p[Ke"9dF gw?ixSOǿ:k~K9aX%5Eڷ<~	sw ~^'>LnmA6zއ6
滣qC|0/m|SWjZlzV-N@?l,O [mqk^!W?,D,kvG{ԥxѲ_o_x_!L~=|j?twú_2/NOk7m~DI|<Q'Aѩ[jo3Zu/ty) ~ߴ_σ? 
kZ?\53Mݐ[G+i?`2#jHfH6 |~kO+
n|ђv۫]ގMM\+|WC	|T޷k?w3u^jE^q]^Z]F[D۷#_S^9Ji>EǊ_Yo6~wXYXxKB[
Vd'>Q__	G񟋾/蚟|mIxOF>'E[X֨eDOtOҬ-[ZI$	 s ( ( ( ( +/Ə߲t ߈3F7g;Ӵ+X<I}B=Nkh욤76z폧:>=zO" G<3}=[3UԵτVR-Eia>Z&o7<Qhv7Kܽݎe ;Jt3֟si4Ro
^][&wCNXZ-7L:=5ݴ_cb >͢
K  I~?V|KO/]׈<=}Hk|1Mg푕ޥeø؎B_EO s'z~ יt?ܫT}D~e_>?D߀㻃O['bDp[$2!(ݖ8'e %~~аCŞ2խgN=W ݝ찘݊J7O-@/%yԮ'4.L?-y0yTfSޔ1jUyܥJ|U(?'\W 0տt~,<'7}_Oן34ϳ[6y|:bp:I4\`J]v?q>9
Z/RVl,S¾"QyI(Tܣ/~߳G퉠_ŋO-vZii{eua$DZE
 #hfUfhd~a419ӞU{;=M4$3W
vJmN.QS(J2(ɦi/?x lিn
 |	 թ_?ݳ( > d ɸ|H  V K	 &#oZ2h 
( 
( 
( 
( 6?||)x&PMZG񯆴r8.cXeyi;χ? O_ x?O5 :  	>=y`ߥSVG뗸Iw/_o
/y8/QkPߊ
ݮ%Xl/(a{lmvm
}^N3JŴw{5ϻ) <	<W>}ǆ<oSɚ94Hor(&x/GFM31CkO𿇴ߴ\ g}vy$pym31$k[STsw\M޿+QwH ecԖ:W>|Oǣ*<Pj~Z޽ϢYIhVOudl.8o
x)-ei-jZf]\4y3#M$#0'^!ʤew);Z'4s~ owŏRkP]G+	Y_Xn,ݬ<=V]BC&u(9_HbPE PE PE PE PE   |~:O~Z{i5/G7UF]i"]F	HEHhT a߀?GEii^z>Yi:yae%1E$FD$eGF
K [C?h_wq 	f|:Ӿ̍ռi\o=vG̑[ԟ # ' V?k?gOHjÏ 2 M/5W .0_)S᷃;/]k/.߉-;(\2[AG$rA,<ئX~6 o ugujoc֊U`* US*+H>x/bNrK
ٷd'%gʴ6?=}&r7 q	FuU8Ɯ*Ԕ+RFIT$d9ο */^ z¿7
-J3?}?%)?3b&ػ'>rl߇8*Ս:xOJpiiבZ^[+#},5qLޮ.mj4pԝxt).Tܟ=X|Ҵ_  H: x? ngo[:,Z魥Z;<m	$9$F;a#H1"cy]O/>~[+ZkvJ; 6|Rc8XuUBΩӧ~X9ӔJ)E 7 d+şg_{ 5 po eOOWaٟv@'MG<e_v_L7_;}@ Q@ Q@ Q@ Q@ Q@y[¿OoccOkX}Xaռ9|XUıʶzvW6kkKyoM&M]0?5 w?x7nXZ 
5	nłMFDFad/o{kcsu2E0iⳏr*̰Råzca_Ww	U/|6' ?ߴgu?_
u:]7\5ZPjWv_f,4eԚDs'VGҧ	{$%/  R}>+<)~kOմ}cIVf97I#ՔAÌ( ( ( ( ( ( +/)/jx2?س_@мWaZGS?׍$m|E
>yoV.[{/ݩ)5&WG;  XK&?;?*5wmkn$3֑z0ؼV
nɫ^qvk<|r%YeeMSRZ
i8Ԍ)%$    GG ̅?\:ߏ_D~Woy C6	|- 7- / *`.Woǯ"?j?d( 	 z # B5l   KooP r~=Q !^	 4|?yq
Y>'[H,1׭d	I^MtL"P%b?c[     /k~_?<IO_Ծ&i4.c3DNH.w.oܮ=Ճ^h 7/ I 5 po eOOW}m Q@	2>$~ SUm |%  p eOWݴ Q@ Q@ Q@ Q@ Q@ Q@(~Bzk⿇zFiZ>T"YMA6f[.p2)]7w44~? bs߶dki eO<y~o.v gĭukl%3WI|`"45iiqjur|P7v^YX]fq^h2J??n+TҟǏ?&/	Z?ۭx&]M '{
@yLn(Qxn	;QQy)YٸFo]3׍8JRvSmj}M 2?~
>xI-b_
gAi<΁64w}{o؋K5D<]~3ɫO=<tqWxTWWtiwNaEtE PE PE PE PE PE goh?5~ĝ#(<$7ܺ52oxx |1,u+h Na$_$63%ЬQxF^nnS6+[ P  ර{@>ki6UK+kO52J#Kw;kT48VxWCx׍m5։t$m)҇d1DR K  ?տ" @?_9߱9MSIlih4Pm>¯.efQ#LɹJWٟ?7}ίx<kv{it[kvVGyg6o4B;k3%+2s
K`  { DR|ڷ;SK] kdfEriOuk=;Q{'IN{'o7_oP-3@=S=WK|Ȼy!˚a}v) K	 &#oZ2h/&Oď/jxʾ ( ( ( ( ( -P/?~4P;@|S-K?^m%MI4\0\Q* ?n	+|(t#\FƋY\/躂&wvacn>j#<X
,l8\:ݮH?P?jK d Q|_|M񭧄ᴅt]{W0\lѮ[κYI4|
7{Sx¾O!h|3xKJ?u֞+h/5qYڥ0*OtY?59y[QEۢڸeV~}ǹ&wu(+h3{jK^" 1ӿi_ٻVZCRAe	{{AyM+M1ɰsE<-H hi~ xCFkEW:ܤ2KL΋"(`]ĺm\4wNn˴d_2X[(Mvi.M ZzMgE PE PE PE PE PE y/0o[,iӍ\Oe([\Ouqoo
i/x'2o.+nYa.mLZ,q<6vkKs}<M}{<~V4|7O ~|]32f Q6֞*Gf_61a$Ws==+Ɵ
(|$]_u[oX5<nnm&EA]N%g =>
[5: E /Y{W$# Yk
Ği/|)a i_|He-`El,mD|<>SG Vxo=o	G/?OReGdnQ! mϕpM/όYKm+& s5[hmTdZi676q$
yelྛ~?g_6~4u¸&R[o%s%]Gqk46Vw+ _'?gත_'Q'X
k9&+n-gIo4FrTO:iw/jKBz6 +9n^;kZCIooK1i'¿-G}wCzImwgyit^=ՍQ\Z[o<QQE |%  p eOWݴ'MG<e_vE PE PE PE PE PE )R > ?|U{~O<I|Eѯ-?his
5yp>RT6YtYhx׋f m<GMgs_|c֭<ǲ:uo</	幺K8lkns'aJkRbniuPӌpx:y*3hAut]c.މ??c்w^(-GOα|k/"Ԅ	~ZSN;ha{eWZ"7uon?2<k-K$Wk1ٶ!b
얊%V?CcO~۟}?E
x43ŞGt6%~f( Ɠ$Ilv&//}ǆչs^ަ-|>g=iQ@ Q@ Q@ Q@ Q@ Q@Wك_홪 3fS|/OQ?o>h.cskwy{[*̧ 
j_s Qoj67=cikeMik:sK;<FԖSq;	{k iŶ
~j7}kT+v[DyO I6Tx '	ogOּ|n.h7v:νqmso2s,N+ @ч>?c⇇?d:
[ 	'eW>&/x&7Yjw峋}[Y"|?䟴G??ID7 ; ?䟴G??#W = xS^G[ eς_M7֢46nSZZ]ZMawq;A;xo/[ᾗ㯈g=M_ ^|+w#[x/ai5ܫp4Kw C | f|Aįz|)^ivE4q-ln&(ԣG,Ek
n)~? ?̞/YY֫]B?t{TlF͠;%m9c`ꊊ K	 &#oZ2h/&Oď/jxʾ ( ( ( ( ( ?Ŀ ƴeП~"xx˯|(jvLex]I^q=֡Ie(̱/WƵ~H.dnl9^[$OD_94C37~<?exKIL6+[=6(-,phUP  !&'vJSշaE!|-x 
 ?G =߳~.ڳukR?H,tRB ed#<9G9^OG}3X%Nih 4誊h( ( ( ( ( (l 8$c Ugĺ f'+OR_#?J>)G|#zO/ȗ~ yjcϘ%W_SƧg6iۯ\Z#G4'K̏A_% WxXgMd'?
é+ڥλj0f1=y18h?ۗ	k :<W_ٿ u&4NU<.慚#-D$j?I/J+H  +  j  >'xZ|!yPگ630;?X R_*"GA%|tW' Uڛ_>9xSCtu+&mQ9fZd
qjIi4%:O_G?Fj?O_V/!J>')k5ipH3E V%$F &u߉f_%7B |KGi_I6v8Enyyqs:[|Gů1;J?B|!"4ۻ
yGw(	쯏oD5?_t]'{AHvKŇ[/f,Y66~	s- z~?c߂ O~6Vw: 5˪MiommUM&P0'MG<e_v_L7_;}@ Q@ Q@ Q@ Q@ Q@s >Z>+
Ý
=]MO[H[b;[k$&VI!f;#EVCeǴkzb0l]?cJKiCo Л o Л ?|к
 "x'+  Mx'+  MOR p  ?]G C A Bn &Z|7wc36^ a񵖟wiv}icw%v\#ill%`50&$+,/UaikgE5}WCZNWl(Mm(ӌZI5uEvQ@ Q@ Q@ Q@ Q@ Wiؿf?SWyh d k~߆CxdU]DiK[K UakXZRZ,?.?l sh_'i o!?^<mk?
~0[xoX'Vњ?bnbuB+9 m?b_$  ?/OM]}&_HKH񗇴-t~;qV ~5Zx}g/'O =2[!Y '{? I?H?-4.
O; T m___m~<🂾'PVZcX_]Ii"XOgmGC; }G
g??o?Z^	֟隽YMm
15=_NivnEBĒ L_KK\ۓ៊~1]j|i[>fm4{kh^;+[ye8#O  |# N   $ # ӿ S'#D)}OZwIh6y\\|FeBŁ ?% v ~z7#ᮙG_iaG4_At;{
^iޛ;[u$n.sKo%P?KI<~ 	'@69xC/]15]ĺnFJaLZiڞמ 7S^N鷳ؼ+_ ~G~<1xOּii7716G<2$r25= |%  p eOWݴ'MG<e_vE PE PE PE PE PE PE PE PE PE PE PE PE r { 
Oߊ$ k@|A 
s_b-7'گg ޾dFڃ|%?i~&K |@״}:姂ox5K}]=ͦK-   5 
?BY |~ Ě  , ?M|_ 悏Pp&/ A@(K?8o_ %7I P 
$ h( 	g G
 k  4WW?޵7H/g<{k>' v[%se&>.qW?6>! ?iOz~Ŀ<S{ūZb>?Z/`k+Smͥ֗0KoUr'zT;<@ᯀxsZ|_mkĊ=gm]ǣ[7ɦacs?Nn6\=֠O 
$ h+~xĿ|]W;?
_|N?Mo=UaPLO*	NMV8n.`߆OR|PBqa9cop#V=L"֭|}j{y֫}@	2>$~ SUm |%  p eOWݴ Q@ Q@ Q@ Q@ Q@ Q@ Q@ Q@ Q@ Q@ Q@ Q@ Q@:~)O^*~m[k/ j>"M{_x{Nٮm4ۍ@f ʺJ įw_iO5   	΅{#>O~g~oy{wnϟ% 5?4 *?+K Jj1i T W c  /)  !P 	__SS 1OBc@%	MO?
?
J Қ~ }I(?| |Ng&o|=-Lͥ47-spDb)Rዶ~[ /)  !P 	__SS 1OB *)GߊkgIS_c wCC>lvba{k_"I-_.)5±J Қ~% 5?4 * [ǉe#>7|#׾#i>
Ot(~éD֗%WXfm.eahf+xIE/&Oď/jxʾ?n?|v թ*
( 
( 
( 
( 
K u   "ψ < ?@v@|ec
,~> |76$WZ2jZu߈җEhS,#!fΟW=~+<:|T} MBTEiM}ai54.bۉBm;F~?ý7M-+Gz冗sZxKX5O>"`h_ 
K b GY j7(8e?y'M<cwtxS0	'OtRX`ukي[,ұT7vU?Pc_ ~xGP|M6~еk	-Үo*-Nɦ~֪f@+?~  i]|u 
ĳQF hX C<C%|{U PE PE PE PE PE i}~'g<;HMW9$#濎9㰈,s-٨߲Ǐo/g.7/_?-4/$ڼ+o?c" V~Ŀǀ4+xHT5e4-$L0M5A-C#H 1l~^3s;x?c~0L|}]x+Lkei1nA)p>~ԿRo߳g߉h~?_
|04[#VWl+jZrOvA5 LRi7_k:ƺ^) _SKúG;[,rZlRUFU_w	?9 |mN-i}[H[\xA4R$NE {ڷ[U[~(~ ƿ14s_eO.n䷋ʍch,^exQ__cwMDׇocA[k2hdN&KB&Ԡ!GU$ |u- _`ڛ_
|y<?׏<xEoa]4'F摡ӯx>$"G>%~
|/ Ꮕ}<
<GMmcs]\wwvy4$R@>-
xc>6x'ZmXo!լncYm!fxeHFeuue$jz (?n?|v թ*> d ɸ|H  V ( ( ( ( ++ % EŦ  #$S   *ǯ}?% F)Ot?۳=7OK?xV?~'k.^x纾G T֭XDO D LM  #5
Ŀ?ς|
^4;VI{=^{KXQn!ki, (~|)>~37@H>q/fmBᵷIokiev?$B kS(|NFJ׆sg3@gn.9ȵ91dH[ 
??<"c=[FK7z.My3i^Ei~75§Կs<Sr)^[㶛]jKK׺T֗vVR#Xnoy-&զXI >9 htɨxgWO@} 
 HĽ;wo-tKOEve2?.^;2QՏW=54. ugM{a:mv|-m3%6ሗN0bD  |f_%'~~kSi)jGH[Kt(e/䯊P
k	m ξ #>6Ӿ>?K/~h&"ZjXjZw/Z7|ړp__~NW>m{wonmxm&7Zv5o?D!X~?nςlOgPk||q:}k
7U|wkswis6M\,%7z.ڻO^D@>ZS~_~2+kZw2/i:g.&0A<}&C!Gn FۇD  Eeo/~:|CiXz_M_K4kM@Qk$?lկ=]txno7;~z|$WS{}ֿi7o`J=V[UT򡲵K}CTL!`}O4   g|
  ?;  oa !PQ@ Q@ Q@ Q@ Q@~W o `O K?e_xB/Zj<j-וּKIncY`-쐱!+oj_%ٿZ/mo4 W:ڎamOG]"(v[®[ jOT7O~Qk+?V4+;m:SmWrXr\\GOM)_~"|l|_[M<8I|dmN.'C5r}x!k)X!=c7L w2ᎹkQ
}kb]'N$XgZaCf>H? '?)U?s_7㯍5+m?W5K-sខizVli}i%~ЬC
|ggot c|I;wֺEcgv^rҙVkkgUb@NL`ڻfh%?>	ͶЯ7F5E'M?u3$.&X.Mē# { I |/ |E~¸mKӮ?jEw-受,ml s _)Fx??<!yv_ox!?+Yg-߅Wkt2F ex%^Co_ z"K\<1^iE.yw
aEнIoݼP7inkݟOio~|./t}CV񾥧__xdao\âGi<AM].ngtBc:ǻb?!x&_[}KQSHLELHzO#*i.E |%  p eOWݴ_K_Q ٻC߳&w?hޭ:͏];>m41jo"Ze|0 b R?  Jx  f %<_ XT3??/ u@,_*GIO /#$ P 
 Fg S   H 3 ) wT  љ Ĕ ;?b R?  Jx  f %<_ XT3??/ u@,_*GIO /#$ P 
 Fg S   H 3 ) wT  љ Ĕ ;?b R?  Jx  f %<_ XT3??/ u@,_*GIO /#$ P 
 Fg S   H 3 ) wT  љ Ĕ ;?b R?  Jx  f %<_ XT3??/ u@,_*GIO /#$ P 
 Fg S   H 3 ) wT  љ Ĕ ;?b R?  Jx  f %<_ XT3??/ u@,_*GIO /#$ P 
 Fg S   H 3 ) wT  љ Ĕ ;?b R?  Jx  f %<_ XT3??/ u@,_*GIO /#$ P 
 Fg S   H 3 ) wT  љ Ĕ ;?b R?  Jx  f %<_ XT3??/ u@,_*GIO /#$ P 
 Fg S   H 3 ) wT  љ Ĕ ;?b R?  Jx  f %<_ XT3??/ u@,_*GIO /#$ P 
 Fg S   H 3 ) wT  љ Ĕ ;?b R?  Jx  f %<_ XT3??/ u@,_*GIO /#$ P)|ƛ]f >;Ԭ/^j^ 	?5Ckݕ^D:P<ioH~        % 5 grand.JPG  	@        H!   JFIF  H H              	
       	
   } !1AQa"q2#BR$3br	
%&'()*456789:CDEFGHIJSTUVWXYZcdefghijstuvwxyz  w !1AQaq"2B	#3Rbr
$4%&'()*56789:CDEFGHIJSTUVWXYZcdefghijstuvwxyz !!    ? dO?_ >.|\wktm'X_QvYYoeekoPAx$K  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ? g?	_?CYMOUxOGǟ*}/׏55}7,.RC{d*@?\h?n?|v թ*
( 
( 
( 
( 
( 
( 
( 
( 
( 
( 
( 
( 
( 
( 
( 
( 
K  I~?V|Kh?n?|v թ*
( 
( 
( 
( 
( 
( 
( 
( 
( 
( 
( 
( 
( 
( 
( 
( 
K  I~?V|Kh?n?|v թ* w-?
x>96'E5mcXկ!lmi.nn&ebI%vUEFf ky쏨 xW & ⯅~$8> Ƌ}R_]Kl#@I; 7  ?䟳?I; 7  ?䟳?I; 7  ?䟳?I; 7  ?䟳?I; 7  ?䟳?I; 7  ?䟳?I; 7  ?䟳?I; 7  ?䟳?I; 7  ?䟳?I; 7  ?䟳?I; 7  ?䟳?I; 7  /?_@xPu t5mWށ]
$/^"ִ\ZrY²yi4e( 
( 
(xsi/t]>V5ZK&6fX(WeTTfb &  - &? C    - &? C   - &? C    - &? C   - &? C    - &? C   - &? C    - &? C   - &? C    - &? C   - &? C    - &? C   - &? C    - &? C   - &? C    - &? C   - &? C    - &? C   - &? C    - &? C   - &? C    - &? C   - &? C    - &? C   - &? C ( l 8$c Ugĺ  K	 &#oZ2?h/>D
?Pt
=ahV%ciVjzܖ6aծnOUQֿ|o-sGM

Y=!.AhBŲ
X܍:? ( ( ( ( ( (wO?4 hyM֏54wբX]"zFnm;)`g/Ѿ |u>_'/ -ߍ5d|O}.=vAi-ot%Ƈ}@ Q@ W|;ٻ6_𴺆_hxm<Cdm,-7_zmZ%`}	N e {Zv #6gsZyM
/2AlJ)on/n[}@ Q@ Q@ Q@ Q@ Q@ Q@>' yx[ᦛm ;<Y ,.!k}c1OiM{)k&dti#(5PtO߃u
|U|@+7Wv֭iVFgW/?N;	% eX Y.>> d ɸ|H  V~ 7| 㮯  M4NlxKۙ>y;63sh Q?n?1~ D(x]>2Ou/[ gj~{wg?rC741,nu| HO|XTׄ o>𵶗[xOԼ#þŵ;[WkkO aۣ>=_9@|YW@xlմtմKJ8";H!2E  ?i G㯶~t?3N?R|{a[(l<VKG?̚HB~|wuA ϾO:߃|/!P{x?VqIQm^5I/M坼2\ɦ4 ??   /??_)w 𿂼KռEh~#ѿeiZy{5GiOCS~[_+_SR#|B׼C_F?>#j7,v>еˏMiZR]6EYF@@?Z_~: <-|>- '@ӭ?tsNoU++HClZ\//JkT!g`OM5ͧm/֗{oIf]TYj6ڋ]7cBLL* K?z}^|0 FW_1f/#u_c.4
Vk_Y/)O_|ROŏ?O/~8񧎦NKP^5WMA6h[{(^=VM9V`;
E'Ïx{:xY~//<aCE5
m>]^mkkc%4ë́-aq{ @ QotaO_+?
h^Zgw&mqǦKaR:\@ߴ O3`|9C,k~ fiw"~' 5iח3uvOt߱޳E?e]W:Z8?tO%^F)nԬ@__P_ x /]៏j%&~}JKRJSh-&/j𧅯?jn3m74?X񯋦௙3ac$+0PԟU_\ be#O~'|Ox>~4}gZO%.Rj}96ޱ{i[\hO E Y m |b!ټ8ڷ}PU4;;Z+WDtˉ5g._D[$|KY{LӗK񆇦jOxc5붚NZ	Ki..?6:o>7j|U~hO_!g6Tw:G4dh{9t+1YiR } ~ hҺ fB⦳6&|+}miY\c6n#mk+wbS[kڵoeuj}Mjwr[Z$2d[{x!#4ڊ=)oؿ
,#D9v׋;gI<;qvMz/-vE PE W GW~?,; 70 :K<z՘T򣳳 oٻ~DO. ύ]&(eҬ&(fXK	a"ȿ^SJ=a|k/4oM O+:gfĞ)K{tm6Tn]ntTh ~ Ii_M?_/߇	W)y;/[5XYNXKaٯuHm$MRA) > L>*~Ǿ'gӿ;[/W}RM&jĒǨ$&	VA4hnP<=  n SO~-o)|JBUxr
ZдV=SSY)scᙝn4Y-.w_ߍR~ hs W~:~i櫦tW{]ܵĮЙez >/L>Ǿ% g~ӿG;/WMR=ށ%rɨ<"y	CE",bmo? /R~ Ꮚ WফúVj e/z}s=z5ųɧťŧC)dke&? ?koO?/|=7!|6]gANm^fִi0K-dk7|O(W9gx EfOE}_ouҴ!÷\ϭBF[_Gǿ h|<kjZŎcǩQӤhdW_1h?rK {⯄mO|h)񶙡hp|CZk^ tO3X]\As?iմ/ʐ{'O=+  ê4]- /  ?o ğ_d C߻ k. ~ d0>>	g/~ڏ鍫[M_Z!ԴXwLۤ!avWnDֳ%W7~?/'?t|7c@y}귭%ƞ̱Ys{1@-|# oo
}ǾH 
V!=W% IXuK\ZOb+'/8O}W~??g >_uO 	EoyuhvkgI՛6wV2K{8@?Qړnu > No_	N~5o_AhVơ`b%ֲQٶ0_IƯ K  gğϊ|A~.<[k{++VKtX(a+ԟF)ǿ Io'irxbR~O˕xac+ _{   ÿ?o 
O+$vD> hkasPПoO_n':~: Ƌߎ 犼	o"js:-?ԛȺo6iB| ~l
K]m |=ik~  zw˻WV-ΠĿֿ ֟o^?wg#Zqa/^III팚]VwtWI+KjKR hw'o~9xo>|@Լk]K
)kVIǬ]-Ɨ+k^.Is`KS5PsⅧ:O0R4{]G>f-l,"C$qi,7ƓX}_	~ qI//ωtm'MG<eGğJa d'	h ?_׊ j&}B_麆i!Km6;3=	-
w	[ <m?>4}jĚU~"wķvG5Xu5=AdKh&X	ˀ ̿w{:Sb4jڳD𦧥oKnm'2=*MzOrsmrK*ߍ~(|xឩf͞>D[]<;dᔀΙ R_MSm Ꭹ[^,)|++VFjzdu;9HITe<}k +
}a}X6spn|8u(K)ed[6 |?c/Gzgo Ꮟmiɫ]h
_[X$P̖2ȐJT(iRr 7 ߲.ko~O;o?O_|dlA@>ֿh!a@{o<KjLyE*We&P-'$ho_^ ~ ?W}WؼcO 
 jG9{^Vϱnǔ@<_	oۗ&jwo|/+Úq7iiu$yp,ϱԉT_joo
_Lxğ5HxH5w)gy>w.d_65cl3 @>| @~| $🆼MsCP;;4;LןGf:?Q_E
I:M
Vkxg-ۭ֧iwu՝ݟ xvIf,4|xBX.-ݴ+sn"("}wn'㗄<A4]cƾ%t;#dXy8'DXd`0@=|VGߊǀ<7Ŀc w t?\rvbgK>9-o2X5)ψRoo8;-" o įE <zTp}ot϶>/i<"
^=x$_k}/ki66v=o^rlb]3OTk+6WRoo
+ 
/ U? j}f ˟?F?o;)ش_7k~4wfEW4ѓT> 2iKba6T~۝c  [I |}]Cl.e]2k|XEte -ԟW'YCt|3 xK^?/w7rѴɣXu^I<(p+
(/+o
k d}@ Q@ W_L7_; }
x[Ǟ?s?ZNi:ƏYwcX[\̭rD$W)~l  /G ,  7B P -  ^ g3?CF?GAGؿ/W } | ׇ?h> mo i յ pjR m}Yk)ysoY)j -3'o]Ώ |1
?T|u[xBƖ:mRWKa&
IsH
 cym{5/ؓWxwVoWQx]Mk^kmD{I[BڻJ<	6jQ
e h^:>{eǦxgMҦ4im_[[ĺΣCj"(?sS-<C?|A ||SǊ<Qug.kS,aoiakcCI$ -R1;⇆f i-5oŶ"vmkoq /u`ˠ[4Pi
`<
gCi6	o,tp3-):Ɗ- |'&?h'CW:m4^54xF1и1H}I__?C$,)v_wYܽsdMH[vqHӬB2z't߂:='ᦡ>/ Io{*i.3MJIu9ڧOsxoPoSM<7 ցe-kW"r喇ymy}O][XD2
д?K[/G?f i ~ +^  }wˀkyn7.7g}
x[~ǁ
?EN:>icF[[«$qĊ  P=υ?|#߈ <)@&xxNѬOg7q"{hYw&$W^ ~  hWؼA jG ~{^n \nϚ9 )x@c'E}=G|ZX>*a-X8VtTUY  WsO?
|341%"Ӵk;mS𵽇H^h`bI	6:u/ğ.m3Pү|Q^ixtVӭ-4Na"k[<O,Ħϩ?ᔿe6   kD#Gg Mh })~
+x ٟ_E
Fk lK϶%ןsw7,k#ex;R g 
[ik _϶&<	U 	* k %/<%/ ;͟l/~jjˏ͵tRykяc#?|)xv &PV7C8{-"7RP =& __UK  I~?V|Kh?n?|v թ*>$ V?c ??#K@ &OW	NΟxOӤ]ZiRL,u{xn|EX%;Lcf E)m |1֭oK u/^*xZ0k1m,-0E<y[Gf@>* *5xǷV|G?@maO
@ǅIln{Xy&6tٮ,E|fKy> J b|׋<k{@ ֯}u+{m[iuR[bZH~~ğowI. ¿< >
\ d @W/ &;=~Cy"OUĶby  ڷ- @W_6>2w'NgﴻOV6vuK[aӖ$}7 ^> L>^% 'gӿG˫WW}RM&z%qI$&	324fSm ^?~|W<	
l<
$_~;ռks]Kiwooai{Yx6.% Cލ [ k|W?|Yk+ږum%?ӑѵ;2jͧ	iP$ߵ'/߀|G d vS S M_c,OmgwDuP{f3ɤowku7|98
*7w	%*f_	 <G I]P >ן;c|J Oд{9lඏFKkY/"bTjؓ
>[WCGK? $3ռGgw6v>U$RjxB2^#i\F_:#eq"=Þ$+ :4[yP\J<={>ok~2*~~?'~V ߍO
f:mvZwwkL"f0<|  c{ {}/!gxCO_i&Լ?5忉4{;R)kc[n/eJ߶f{M/x?mZk.&k*׍<?;1iR1$Ү#bvWHR /~ԟ୿?k/O~~W3/'9:M PMC ~ / S$Oh   QT'-袷fΚjSl?_/ثǿR-?~ 5>?x㯄}:=RHk/Qӥm57_lIL'-|5o_qڋ?
_k?xCRu_:ׇnZ|qqKmbٵ~m$ :rYmh?_
>
i_~xUozgxxQ{Ya6n{6KD > ߵ&$+ݯ  <nEbi>u{.-Jyzӛ\/Mē75-2axZ"? (୿)jUm PE P_	2>$~ STmo) gj>g+}?GtxY~)[|m]zTQWS=]&]ȶp$ڀ? ا	_) y~3_zN;_l~$Nſno
髧\xY)53G+u77	o*Ox
 hskg[&wZ\wyk-,m'  i @?c?i dh|!<Yj_ \DeZO-֥wikYjIﳥ)翷 G|
 7/$ _	Aկ`ԭ<JZmskuZ п_M?(q]G9/:ǂ~!x-K _IԼ;O-v+-I>t19	  -f"a]/Ҿ'|4xsZ$JMz:/ZSxy#ԉ`~_LۣOB~?\iOxw<!wM'DQ1ޛB[4#:ߒM'Ŀ??j&)
w?aO Gi>&V M*h;ج[-b]o6 ~H/ڟe \A_GOE9|kg|)j>HtojN/a$Q=:I$3OZO J`CU ? k?	>+\ѯM⽮>{ދ->$mYȖ.[b( s  @x*:+mg3մo|7:tߊڏZ
nOhg_=֞Vasyo\*}Ǘ_OKM +מ)]'/wxn\롬+s]XZؗ+k=BHQ@ Q@ Q@ W_wK ] }_	~ qI//ωtm'MG<eGğJa d'	hn/_?f
⯋?m
?Ug}yƭzmKegeKҵ[i C m#E 
9Po=&Ҿ!WVV5Z[.EiIh$b)bS  f[,y^k_<5xT"+kخHh,zkjͦZl/V<G6|	 ؞Լ{G ^3\5ǲKY;mN+-? ,i&?oQ5t :$m>!|~4ҥT4KKnQ-om5\'ԟ'
-?iuk};#i~߂<&<QG ,-,중UD# ;d~6񗁿dC>	U0C7[6Gm41{%O:<0g 

a/wĿןC׏,|kT\_k%zjBlOC,G<010(ϟL,O(7ú~ 'xb%x/7u}y|FZޫpM
mA{gdIKn-:M~ڿj<_4s6x-ZM!Om::STҵ9!K O -/V*;'K'<akWOj\iv:|0wDڲj7L.<7Qw rnOZO>xׁ4MRXw4:PukI[m2H%㯎^zᖉ_xO+wu/Oe{?_I͢.
h5}%}C 4jZ?bB / -4mF^ BPWY-ltFcs
kS=_

?@ UNiMzm~-m7Rir]ٛKif-<I?t۫/}K :~_I/u ƿ
3fiڇؾ]O F!MW&n\2 ;
#K|OρË~ѿg>,~!.ozViu\l5Rg/?ho(w+_I/*)O?_>5?	wZ>|3xDٯm{IIM̥' kط )~׏0O-O_φ'WLZM|o'4w>1/_
t|x hku   
 g)[W ۿ?}ɏ<mm༟Q?)nx^	Կv--zH/f.Y s4B5	QRR N_ߴCW'jp|
,º:>jNalTUumjzy?J? Ow _۟kψ < :#Gg}1}D W P_VE??G5*
( 
( ?n?|v թ*  ( ( ( ( ( ( +/?N;	% eX Y.>l 8$c Ugĺ  K	 &#oZ2Oc0  R?+0||;_Kڞj4ل:i[wV4Erȍ r/سTyOng?]>.jvVvlhRGMy-5I-ϖIX._ퟁ^O'^?~-k_&/i~m>Gu>Ӫi_b}Y6~W,fFo[@ f}?@-KD+3 j{.Lt;H΁ L fxw
v'USO?RBmjLvyywg1Z
a(O nM7; DѵsYеM>VLլԴk[e}e;^XIGi$|n4<|3~X.4;ݒivVX-f͂8C&/#׈iO|
oƽW	M| x.O١[egX"X W>7?+z(!K=GW:ޙhWi=jm%7Ȭ|^ `~  i??}ƗcűwC[:?:v{{bW]^J]D 9$|%4K mg[loOӯ.䲺QK)`{h[Ɇ"[c'_j_wᆡ.=ZOl|=k-l_]6V51BcTb!Pϵ$UoڃT45kn5nO^_xHMw2i΅$ڮp_%
,%J+ p n7N߳o]J3M<1mM6kn1_@Ms*\$ j b@	h]gghpji1#YéKx2#spT lπ;iO ISĿb?c-teͭwy{[*̤%+_ ~̚}&xÿUhzηx~KsMӮBI/Ƴ寮IĥS	_OO؛Y:-so˪x\RWSu׽:ơzS+%00Ʊ#~*z?iO  o i0`oYǧL^}ILSy{wGc&/GP¦ 7?U ooW'~}+ W	y7&/ߍ׿~Im}aKI58n
ߙ3aa$Rk+f{BaB&/;|V<YH!4? ܋k
m'_k+']dx_
;G-~
~,5"gmkiEo&z (୿)jUm PE P_	2>$~ STm Q@ Q@ Q@ Q@ Q@ Q@ W_wK ] }_	~ qI//ωtm'MG<eG ǿ>_mE>wwxbu\5-JWk-/z?݀}E PE PE PE PE PE PE |%  /~k3
9~d?fr_4[t5jP h5OQ	$/h 
( 
K[ 'I֟ƫjφV=t?<Rxy^xV5ⱷcY;`h ( ( ( ( ( (_(g}3MP6{"];C%t 
M⇿n^%ƾ.{y >l 8$c Ugĺ  K	 &#oZ2]Ox'7|3^	ִ'Xk8nukkycwHY]] FF~be|,  ցhO[ Z}fT^aa6gX-_LRoB 9?~ />+G_'n ͎aRxkGzc ?:zc ?:zc ?:zc ?:zc ?:zc ?:zc ?:zc ?:zc ?:zc ?:zc ?:zc ?:zc ?:zc ?:zc ?:zc ?:zc ?:zc ?:zc ?:_	oۗ&jwo|/+Úq7iiu$yp,ϱԉTe|S
O4'Kþ(+TӼcϴh|fdރrJ2	 zc ?:oP 7__ѯ|w<5cqe_IȗChb&ֵH],f?coU~O>"Z,Z7[Y|;ռyoSL[o&oem? ( (tf?|sԾ|LOiOڅǗ,:{%w4BGYhYd_~
S |<Oߏ	^']L:Z[LW[SoCoCw[]=g	o I1 @=g	o I1 G=g	o I1 @=g	o I1 G=g	o I1 @=g	o I1 G=g	o I1 @=g	o I1 G=g	o I1 @=g	o I1 G=g	o I1 @=g	o I1 G=g	o I1 @=g	o I1 G=g	o I1 @=g	o I1 G=g	o I1 @=g	o I1 G=g	o I1 @=g	o I1 ^Gik >>񵦟&u+}mcB2[\"Bm)PI˨ EΟmn^o'c]Z5\$v1HO)RȠ   - &? C   - &? C ??Im `߁Zrڅj>xhP ikC7r,-"S$K'j>˾|I^3vsj7F1uU!on;E0Cmm
 {U|%g $k>%ݴP_L7_;}@ Q@ Q@ Q@ W/߅_xo]~^l r/}.O*-;N :( 
K  I~?V|Kk/N;
 eH Y΀>
( 
( 
( 
( 
( 
( 
( 
( $ V?c ??#K@v_
+wYh +/?N;	% eX Y.>> d ɸ|H  V ( ( ( +
}[	|xy|mI.4, UhtcnV]ywu0L8j(;?ao
?9h%1]/CҵK߈}2at,X+kq|t8 Sj?~4hP 8gAc|
=kKh^;Ƴ\yp j_[%E P_	~տT?Kh_f Sm>/'^x6gViKH{!  ~ Y 
= `~J~ O! bi?j /~>
( 
( 
(OG93_
<[CSPѾxv
xZcl
1Fn5Km4!4/{yk+ hD(u@6 H n  H 3 ) wT  љ Ĕ ;?b R?  Jx  f %<_ XT3??/ u@,_*GIO /#$ P 
)hx+%_?Z 5?!-7^ ?*qs+	_tOny$466 H n  ?  t
??׏>4x#o^//
?S զV4Rh"\#.A,֣m Q@ W^	 c J sOG/C h| c 
G_H<]  |'gMb>}vo|y@h +/?N;	% eX Y.>> d ɸ|H  V ( ( ( +E  i m > ikggtwZi}iw}&mxGiDVBgOhట?Q dKƃN6w
MeVYk۶Dk\m@ Q@|%'R Z  W__-_`_:> }d_h'A1}E PE PE P^	 c J sOG/C h| cࣟ| QZm~Y[Wcv)yl	K{Za=Y6B.ZW-ȨeKr"M\'D8 ё~ O !~?d 5tH_m ]  FG >WGD8 ё~ O !~?d 5tH_m ] w_ا:՗  ~hlíx:tj
֯FFA,ۅէY?|U  { u {~4 ǻ1j}h~#G|/6
k`gG y&4_𷈾|	<A>V?h߁uygh'/shkKS,eXw<DՀ?C ( O<'ϏE] 'h_45o$uŜyS<}o⇁~|)↻j_fi.'mIGݶU~{ }/ؿv;ށ~&[3zk~,}CT˴"?;˶TbE  ( __U(/&Oď/jxʾ ( ( j?຿O$?wN <]76&6Ӥ/
5REHZ_K%o|K|z߈{Seؾ+Cl?VY Gt"7`?b+'_SM~x/POsxUU34:[FnZFb%!I  4g#g%_
4x/N4? 5>xŌjg1}-*KBh| ಿu_;G~4>)j e
?PxI?Z|HQAe69  R?&? 7	  5=?g K~,|?yj?	oQm[CQVײGas{73w$4% m9>'|񵮠4Mc;6|eeuq>f	%]L֓@m W^	 c J sOG/C h| c (_|k	 z5"[[]x[o\$jXZZؘ7W[R4}	~|)e[~oih,^I4%wv۹@:( 
( 
( >m )X ԏ/_sfg߆WxzohZï 
5id%Ym+IKn
hyK#Kq K~x #MΛ3<%Ե[{e/bܮ
?h6߷7 = *+2ͳ,u
Ԕ*+)NY K8+s2|Is*XwM\PZ_6߷7 = *( mno+?	 {TWgCl  Ϝ Y	 `6߷7 = *( mno+?	 {TQ < )  Y	 `6߷7 = *( mno+?	 {TQ < )  Y	 axO
 QWG
FdIuxI	ec<:RBȌTe_/  O S O7xm͛wpFk`*8!km%k-/x._{NIVB4ײ:pԒi4 t|G~_Hx^xϾ.g|zYIv*8
 W X Omk t٠ox%7QJNM'ǟѧݴPE PΟ+~?/umO/SI>"NдKefuK
>9Q]?b/ُ߱6~}>m'<760@Tk8Ekq}6dk]ٝ>[?V g&g5/y_>%wSۿ!iwvi'dmZ;VO0/ ( __U(/&Oď/jxʾ ( +
 K:o$<EzxG`|{	;,[N|xZH.T\B[x{!P<oK }kχ?cًp<3u h?z.uH%ioaBm=Ԯ|q,  a'gzOmuهľ)/U|myq,I
<Nk&c y>~<oD\|	Ҽ_[ZVo	~.ӡbuk[]15Ow=׼[O'ι>pkwy;sap#	 CM/7#O&v}cP.ڋۛ?ZIH(^`?D bw.!O>*׌v_o 	1*
GUM'LŐyO,s9^Rz++i=/wugtծ2y'U5bww벳vkOC???ߴ iًƟ^?ҷZYܫͥKk/UWOYOY#qA C_?CSwzzzn,dhI dh&Xe9#tPI
K  )}# wG#🂵6% "ya-i S.o؟P$~?ℇWzwseﭦ5 \[ylIIygm PE PE PE |%W*)/Ѽfw>6_x|H^OUo/)%ic >)O*ׄt[+)t~~QC⽱GP:ȾT.̮1 ɆY @調WI?V>	7
C㧊 _~:x63Zo.yO{IY-.-^}і5WuT)Sm~Ǚ&e-pe[*tau
kΚ֝:pK)8s w @|-uxSd3|4ռڷ7|y͡$)nE<PFK7|[ 
i~_wkw̺ƏxE<_!	k6Cq}%㵊.Y"ϞklW.W'eEFRMYEKMz_n>,\1x
PK3UIӔ*:hWzӤ4D~߶  ~VNOK[OG?FFIE4Xs=IfA#A4߱dF3Vʜvn6jItR|<1poG[:sIZu)s~NdZG?O _/ ?;}8g {?_ '5  ǿx+o
k d~ 'ݴPE Pů?OO;OYlo埀|9<+,MѧN B2E$ʿ(x~(kj>)k/O&$o.d.(nYC~ Ok_Ǐ_ٺރK koEVx:2$"
( 
K  I~?V|Kh?n?|v թ*
( 
(;r{)2_6~?O?gմJ1F+[;IY#mnặu1~_?A*/vxPnk
WAhZY[i\5ybt ? E/&/ק]Ů=}!,ekv<`	V+HX$("X/ҏ
~=;7þѬ/No"#2i $,Đ >#x X۟ᆡ>
c
z[^ W}R|1;VK>[ξv>e:KOP+5>=<I#,6r|LL.ngbY,IlREUh:v.r_/[=ݺYnLpsh'y՟O?(5x4'Nc^Fwڭ·m$kG\R9.[<ұ[g?_MǞ4_| ֋*G#ۥ֟i
6V	 ],^7Y5tt4)cXkڋ2[[XW
z0xi]&Ԕ{]5^[OHο/׳_?cGE-~{WJP["qf,tE_$wyHx.A yoG~{6G6n<1wM1+M+R1],'畲~ln"x7mZ_[=w_
 wǿ
t\>2 oj5{}WNh0%U-5aXdyR[i'7ҟ>-[_
~&i e3vZٮ.>KdiawmUf  u/'sBwG⟉ i޹$ߋ'jj<sP' X@<wW[]i>VѧiWUlZkb×K5!{5u PE PE PE |%[?i> Q?| _ ɆY @調WI?V>	>'?e?xǿ&L|+ekuk	.Sn.GRh2Zo? dmt~j=mqu;kw]urmF"Ӣ{VIfiWN#q\O/S©RKԛ?"',c&ݓmZo)q:,f}*8OO	Y~:ӥRj0i:q9	zu~7eH5
Yӵ+<XI3(o̾x
 7 | | 
 ub;~!xIMsZ-۹+na8.^)"GOmLӈ5ð9S;)jQW+5+ꝜOO8$a?c,5HcPjʬ(ڬ1)N5)Z3j~Οov i_$
^e:6ZZ6אCwC3_
.
S߳O>7x_ï<{GOzS)II*ys%EЬFh洤8ޖ*)%
P/3ӑ4VK=\O$Ȳǖc<U|)Ζ#FuY҃*)u*NS:u&{#tاO1 v^ ?7 8  9$^= S [ S_ ? ԫy>
( i?o|Mձ{ko<#[OfQL-JK[۹U2Ƴ\oko=@y_?~Q4CFuoƙ,j^*M}qͦXHҖ|FZ;ف#⿆Uc>6w|$ohƓyX[|jdYm!hO	$ʍsi*aсր?T( ( __U(/&Oď/jxʾ (  9 Ŀڻ_
3Y~?/5&^ln?<[$ͭc]zeܒڤrWußl_1x/+V˖IOj,ksj*8TH!x!0( z
{Z~d|V6zlm6×lVyEKwYeS#?؟ W-O'%k5{bmj:ls.ª !xI}o<!5Qj__Au|\_A۾߇[-/E/ ͧH{adqM%.(ы4-+d:dx5ʤ}mӏc'.^5/Xj|B?jO,Ok nxπc{]"nÚ[fXj$#}kK',ebwh~i?
 g/ZUY[ZkxXg[^#I/e.n]P	+x,KݜG˨YΝ)VڧӋ;F+)J]N<
*F:gR4$'9-ZoY= ?dSb |MޕO|% uj368Eעv}Km$0j8D?r???d_ۏO|]KRXK"𕾋uZAY}K)/&š/&,VSۄSt- ~{Px|Jִ^oWy_Q~(# 3f|5<ccs2f{_SA&oqlz^_ٔכb4x{믅~~>(-|G{MKZld;jZoHҵ[F3
 /࿅g ?P/O[ifXgռI|_Qķw%EkozM PE PE PE |%[?i> Q?| _ ɆY @調WI?V>	O/tߍvI vvg}b^^[yw3yvINdW^?e/>_ߌ? mc]Y<ѵko0ԼYa)GmlȷVDX#aHU{phM/{F36\8% WΚ,>#-TutR*-д* ~|m?hO(Q| qR|;}yiH	VKtTfaG|`<oG9*]Dڗu%77imd*,	 [˾6g[,U0j
(.SPT᜿r8	iR92֣};^j5 fVTӖ"\'$/\<   B~6ZW?
kROckyo%##SnEcܿdP}NxU7Nu:x;E=]"n;+( XE/
ap5nJ)CH59ԫ
Sn5(AƤ0s   uIo Ӱ> 'ӆo Pq'  s_H{   ) ি@~! 9W}E P._O>&_}ƭk6:Mm5̱Q$ʨ M~k ǿno-믂~` |/m
W6$ْY$mma@)n9@<sw1 U<WΡ?$z_f/KJ{qiJfnR<-?
xcΟ'EGlᴱlmXmUb8EUEEU  (z( 
( l 8$c Ugĺ  K	 &#oZ2h 
( 
= A/[T-h594SRFimǨI_kvH;+X.q\L" k*,ux[Gyhu_4[ozh-#V{ͥZ( ? o  #n5_?zMJ춏s1Wfi
GL縍,Q?~? Ѣ#v-W4cPPkt7iĸ{9`H/$Ϋ#⣍\W4Vumrc>YɾV{ު^{nwE
?ho/<k'ԇ퓤\.exxYGhg+G{- zW;Z5φz&|D5+³xI-o`IK1K6wjAe9V3i䓲o~z%}WK4虞e0zI\kkNV߭6nkG/g쩭h|i_~/k77Z.WOi4b(oB ۟4?x
<"?t[Ŀِj_3A$v c+$g5RO)BWI5ʯW*Z:)λtn]zO' ~ҟRO(ሾ#GC4-';ؤb[O۴1٩٬-[+ ! ?j.׏t7EkSeu4[G9ү.>&9a(`9Z҂'{T8niG/KVvnV88]c.V[{E}A_	m-EΡ}:~x]faNռc}6.7px{CIVӵ/jyoj?wƁ]Z/VwXZx	yE曠\FM{^-K`PE PE PE P_w u ۷'=@ loş+
+g>, 1
+?!>um)|1^_xnxFcIm'I#ȻnWVywƿ	/ _z~OId|&]|gi3<#ttkȧ+rVwVxY2<fAk<5hpVpTj9B\֓y[=r>`+ ?s ~W ?;ߢN AĞ   ?r?
 (   _m WΟ/qsQj?5ozCτYY#[OVzѬ6ImI;~";ď
i2G8T:?
u
b[iEZaiqw~e5hm7 ˞: sxO>h/m}]jZM C+6]=M*K*
b`h ( +/?N;	% eX Y.>> d ɸ|H  V ( _3Mҟnº|w߱ k di:~7_I~폍ֿ mF|-.3]|Q
r-S ?7ڛcCpž_5 _y JuxPiZk[ykk<& P ^> f|co[z ?-'1ZZk7G y,i-&m:]_n' 
۟	x+ׄJHN,{#hR쑢$Q??J1i[[EwpVXVOCe ZU j 5ߴh?kj'bƚ]Yj<6&+iWO%n8%
 ?<7X[~(E{gokQY\ygp *%."
r)GcgI5g&荒[h\ϨrBN\5{O>a ~]
5|G_ 36Lc]SmYĆxG^<3! 0Tǟk[!-ދؾH%oIbw8^{=7*5M*e̤Ӕ%/8iVgpj:ҮZvj(5(Ŧϭ_q M3~_+ ?AN뷳|/}gg
Ťm0`p['sA? b __	  |'e~~>|_|FڜZ=ˮrqrڏ~,^3[yV15}/
.mҧ*sA'uoG}-gTRR4M[m|䯌lz|)߃!u{Q#Fo=}Z,6mtt:Ο<YVԴ>:~o4 ]묳jZǭD
+@]B9&Uk[[I_:j PE PE PE P_w #q7 i ĚGu~}$O)˛=NA6SL7S LEU¿N?gOL=qgğڣ_tv뻽/~FMՕfOU}W%S##Goj._UQuLơuқCߥgF!|^l4'im*фѦbU(8i)r?<?k״Ox_[|M]èiڍ̖VPMꮒ)XP]5g1V,E)Я8M82I&OFѧ[+h%,8U֋m<EM4WɏOS1Z\֓Vgs,>Mõ=_O^8y]˚jQ3wn
G?O _o&1 N{ 'ӆo Pq'  s_H{   ) ি@~! 9W}cQ<O
ZXi%wFΖ=M3(6ΦIcMο ?m_kI| 2|^#>
xKѬ~iNk}dMS3嫙P寍
  g\U'ƶpŧJD&i3߲J̖|D#,) T./>jM \xFvM}gZtx_ sn4_
-!-oz>~wo|/YZ^%EG>dK3AI]Y=E PE PE  '  @v@	2>$~ SUm PE ~_5 ~:|2&ֿᏅ>|/mOxTԵkYXOF٤/.cg" g?K%Ѿ)d?Qp\>|2{WshAQD	? | 8 9|
CPo>6MJXdoJwѩ8Cޫq*T+FP \  ?|g O&؟?}Kڿٻ[C>My>^WU?hľ%mSxN+Ӛ8o^Ke/*i+x	WR7Bt^\U~p*U8TkvZOѷM;?:|
>	 ho/u?5$s[}^%H'H-)X"o.?gw4~s=ýKW~
|%sݞcgj66,mg%C/8G	~GwI=/	E7][YZ>3-c>We+)l(vWqW&sSֶZ+/~1϶O%o.XuXf,.Ro۟'e4~ȿ
5Gx>!^~yoK{ZHbY1*Dφy3b)a>O,5g{:I^+]Ykm5
T>V)(WP|^v~h˞8=HUZ?þ|?}}wen!HV-2$ɱE vG  on^"/-|=xCv<z|Vcqԯѭ9.k-w
kt$EQ}4k+՛JcgkY)u|VRV cQ{=6hl/Ž6ÿ_MΟkk|Cc}њi./um-!iW,"0x¿%/?>1x >,^?↙M*MoiFK{mE=No/lnl-㲳Lm ( ( ( (g?o?( /o U?e_7 µy	?:R  ɦ Y> 5> e?~, X?ϠWU_\+ $??g IVG4Zhu+IGNdhxd%љ6YX&F3ѧG䴫UՅzpeӋN馵M=SZ#G_k߲~o^y~l:)Ƒ/c]iUobwf>/	~xg<LvzvLv{yn^Dw[#,I6.8m'n
(:rd~Bxř2gVP7hэiB6&㉓U%*US5/?
G?O _o&1 N 'ӆo Pq'  s_H{   ) ি@~! 9W}E PE PE PE  '  @v@	2>$~ SUm PE ~??__ݿ[}_7G/^7e|a$dN>l5F.a"yD~-7~ goj߂~CFNuK6:U6\1#$QbQA
=&
(xS<
ׂu>I4}ZZ6ehX'VWWe`A" િGm?/'~~ aM/û-Эo!Vo0h<km+)#XNʍUx4tk]:R5iJ-45g <? $  ||]>6}$e5mYIq,gOӮ
qY kE|R_ ^ocM/ҖASGLyFW<\O)9f2uG7$:kI]=ޒNv60\5(M'XnY+jo'o?Qxc u!x_Y8|5H,3OPMYl?V#eP[@BAD"!k3vzQVuw+-o&iG.y*VnW{wVߴ-
I3SBA Z'|Qu5CxK0!klE~<
;|
|wI]h
֛IP̖Em)RaI(a008jxL4m+%ޯ<Mwy ]Et Q@ Q@ Q@ Q@	|6 ~@~
 Gf/Sr|%∴k6-cY_xFi.ݶ6eq$=[x#P¿/E?
-+=֏s:%;6pR mLʪ3՟rg vo`p\W-8+%Mz7 8!rm˞4a^0[-#L _  TVɟK2=?׎' K <  ˼w 45g D'#ݷ (  ?d {  oS JρL ; CL _  TVɟK2= 7 ) %g& '' :|b<%OPY=⯅ţDeR]ӭ-2$+(wV7ej'-e 	 
'[OF =?_l?wݷqˎ2sR)٩-TS'>𣂳/pE19ObrHJʕxNQ{4p ~~
B `ùo?2MɎ᫽:MH
g$Ζ
az- _+o
k d|m Q@ Q@ Q@ W_wK ] }E |%  p eOWݴ Q@  f>??<{-  g&& /'ow?V ?g<m Q@y'M??O/x7zi6Ǎ|Kv77G,mF4pO 1ba'%D~?Q?7¯ٻm]/z>x[_%o#7nruc5E"iwP\fX]_#r~5~Ⱥ΋. u~/t?>;xMC׶ͫilk$2"{I
$$)PK:o/l8roIu.ui#k?S &7 i8N
B-K^GѬwsi(V(十GEe*?8E+  a?hW?Ya
"x4ۧh4). -{6yvIu:\?f6S!J\4R[_Kkk ]XUg:(ݞ_}oM߱_/$-)  4<ៃ|-w+h~:$bmk_Ry:ܡm屟Ϻ}vk/~=~;?g z~O]OC4c
%Y,M$[LK$n4PE PE PE PE P^	 ?c E OG_C}g|ݟl-ӿ J~ _N|ki~_%?{3ۿȋvv. >| S-  xC h S-  xC h  S-  xC h S-  xC h  S-  xC h S-  xC h  S-  xC h S-  xC h  S-  xC h S-  xC h?1U 3ٿv k7ڿW'<v{g*_T Fό ?ا:.4$e=γIsmEe v@ Q@ Q@ Q@|%g $k>%ݴP_L7_;}@ Q@+@ iR_| 
?? QFg<M?|~:`hֹZk   ??O?~y~W   U?g?$uM_Xx67i}R5R̯[(<ȞQttHI't?3_ n/Jj?gWTӭxkk/KӬm$÷rI:+#֣ #Ox73	t}'G8m,th{kkxUcD8UQQU@ 
S <_?mKƟg,h
-A<vKih?!Ԯ
Ilo--n.
 3$ZI_{5~_<9NA4xY.M,qq.y-;mGڕZEs
]B]2$qurEfs
:$z=lD)>E?a{G_4Z sL;.-c,`WLTKM˸o_ ' ]o mCM>?~+xA C|ayZɶcDHB7cYmX!޳u  ׭Q6|WEzI7<ukogY01H X'?/F_3;?kt1;?༊=FtY~I̛k.UFP( 
( 
( 
( Cŏ~x?)"77&	%Y$[k+x帹x"YQS;{ Vw }/^au\y&KVƫއ/'[[yc$7_#/߅<1῅_o6oi^0%/cXwE6 IZyqMq̓%w_obۿKe>zsmiZ@,Kuc(Vw*$ M~n iR;P 	u_Oi}çx{K}%kWiGc+m3Il.<_[K~gԿl3gؿ>0Ew<DuWx##WK|//<5
¾0Ŀd:vwo7IS͉7$r.QՎ/7%%;_%O {@>1'E]~4??l'b^je$̮PL*2u>u Ym x7Q$gjK-4;Ώ[RYgCo* W^Zm'
^OŚ>x#Ip^O'M[γuoKe5 = X 4p 
{} h Bⷊ9xNW~0~5!fL<O*ZIRʱI";E@׋|{74x 59<#[.o,.3j{
owm.-Ἰ>K_( 
( 
( 
( l 8$c Ugĺ  K	 &#oZ2h  w-?
x>96'E5mcXկ!lmi.nn&ebI%vUEFf h-
xc>6x'ZmXo!լncYm!fxeHFeuue$hzG<t~??b?k6x#V|S\j*I,yQBZ ?*A'E{C5"ׄ|3IS+.gk>U]ʬ#_.90M;GoG!֚
Bu/3icճ6SyA7mV *  U?g?$uM_Xx67i}R5R̯[(<ȞQttHI' t K * hS  hkWȿS
iqMI&3?o`K=>B`I{xk JM9ǟ
u?Ɲ <\Gmqw;(yPxmn+h減aNm Y  <[/7_O 'Qj m _nDxⴎ:{(nhIk<]Ox'7|3^	ִ'Xk8nukkycwHY]]  8		Gi|4?gYNN44.u}fH{+H1\ , _!>0~՟X?Fx\<n<O m/(VHt[R<m|	i$Hv(Ҕf._zm${o$P >~_ WhzÏ-5k߇o#˩Xe{cw,;f!Doqweh|V jK!_/Z4 +|_Q7|'Xikz.-Z2Wi..ۋImmvr̘ E ُ l?:GƟ{N㏆w~Rih?n$<Mޤ7V-pC $cg )5ࢺ?k+>|}ᛙ?Zwqsd5vu8Cb7 ӿ`?.Z 4G=ڬ
SZZihmvG%tq<{tԟ?ᯀ@__}Pɧ꺄|SSWKe{umӼRo71YI3Km=SmQ@ Q@ Q@ W t2:Isa;f<]YlZ"K֮0:LxQ@?[K 
g,M_⎲7Oi3ZkK#KȮfiQ\]Cmq|ᢿg/^
 £L ,W-sχ4OYĚ뺜veڢmAbXɎ<3;~; [ fmݿۼɷdϝ$돁]O *<aK5˝m.|˾.n>uZ<t> |  4I xCvϫ+}*76i  l/ҨfE*$7HR5i[fmx |i .>![ឫ, h1:3]D1_
\O(O_ E> i ?^muΣ$ypymI>98~ /+ ~#jOhZޭHumdc9-4v֚}L@?d_ fF=Cy#K[[yxl/mnaX-n-ขX9翅<uǺH,<{	m'[%Ķw[$v&Ya+}B}WM(b( 
( 
( 
K  I~?V|Kh?n?|v թ*
(xS<
ׂu>I4}ZZ6ehX'VWWe`A"[↱ x E m_o~^+Tȸ5gusyté^5[Oz
Y$ŕE |Ig[^A|' g|ƥ 9>
ﴻ?q^@VPo 9%|:?i_5[)5gPLw~&V:wᲸ_"n΂k?Eu7>9ѢO O +-5
]' Xۭieiu5]=n+Ki$mV/_⻿_<UG]?H_O|kዝRK>stlEmkW,Flv9ϋ/ A@Z훨x nio|Ah$WfQ,V^͵ʹ1&hk  LS/s ?h_'
aO|Al?"xQ wLnK?Iy$nf--sWB>~s  ǚ?|?x#Ǻ\h͎*jZ46ڝռr=\ou~%Go~XH{OKisj7v`.lHxn]C<ܠ_>  65ՋCH u^-"k-ć/ ͵en !iJEKoUg*RTZyezN.*ڶ  7W/?i C/ [x7M'5g=/CĞ2{Jv,w)of`{?o)J6k~k?QoZ]ΗO[|64I`E'M>O
+Z?ڗ 
~߰ƝCi9t[ưw_9uk;Roms<-chx6{iC 	Axj?غqueio յf.ch]L	Z>|ໟg |Ɓxg|wcIL4_>(څVʭj ߲A'챧bGy6->	m594Y$͑I$7h
+>xP>hwמ*+-5nl	Vi--"y,7k{kmLE PE PE |% m S MC sR
W^0 u^>:xSwωQxqunYlu6;sxb+jK8e\Ƕ l' ٷğϥ~\6Z_Kay){j'-C"d)   ?Ŀ@<S

 G .x'  ] O(7O9% ?Po?OsK t<xc5ݾ/MzEwM3JyF-)$/Qd'?o  f/ڳ ቾ?km>8 k dj7:ھ~6o۽| 0 Ϗ?] H   0 Ϗ?] H  G

[4W	
F>	P~[
3NdKsL\Amu&j.oib)pc/_|ig?T?_h7xfHfZ_j}60.v9S+ej_oۋ   %']6 tnz7w
	q$Qm-4dH  `x>< i<<sj׍>յcVVt.nn&fyI%vfvvf$k ( ( ( __U(/&Oď/jxʾ + 9 lj~&ڥ7PX`Ѯ!ey%FPпिtK~Ecin;i}[h7Xӯu;3p4{5VI;Q||Q_,~ҿh¶ޟ ּo/$zũ\wEX_CPMbK[-ݼ#8VnX*/6igWvteP*t[{[&Mlo[|
A?dCſ +gY񾓥i? fՠh7i+宋oZ\ ODRT,? ?kڇO'v}kJW)ݭ,KO藖ion]1[nWGG֫R6K7+Jii=ol\tib%5#=MA;v-(?cOً/cJ?3T:֬}wS^\3\^5R(H@b$O_?N_*q[|^ u?!u 3ǅ<_5nmPיȹ)d>o,K+m
q~ks
Í# ?V_i+VmC*x4.r&
ܗWPIiE;P5?: o3J k4 _SIw[ChV[B	<T%5xR虜5 IM; ڧ gto3[%߅KI `;ҥ+kg8{$OC
e&x#	gnnt:·OxwJ_ZwnwIu	>tY!mZ4);S#V]!6 Ҷ$"9\7Ѩ@'z/=K cwAb:u9
FHRR-B݂Z,ϨŸF>ia-xHB=Hu:mi?Mprܝro#h hjO<!eb/~ڿ
|s|3cmĺf )ԥޡw"eXH6cq@k/~$x@tZO8-sK}+@zi R[][yx1x+O[9_k_?
{.`ח׳Oq
 7w6Ѵ(ӫ,1+ʀE h.~=CE~xL-V v}glpm$UhRhʙ%]JO+gMYKu|T~ jV^9ƋV֡k{-!yZO5 +@"wO/|Qx
MPgrC֭t.h:uϐbG&xm$J
( 
( 
(/+o
k d}@O 
a~-oUT^?=swϣ=ڴK$;fbĒIo6a 	''[ [Z^byr]OUoO3l[EZ3[[Nf9? s w?h>i.ӳ}iKGg=Y\. I%`Ҁ
(<_2NTij7,ڵ0xǖN.5K[kYvL  V?ি_! GPTP]n:G
]|2oZƞLZC[8m&'".W|1<
?KO5-&:e0"4@T 8_?d  go^kE/3?;<ZY{%VOh[4;qş,a7|^} 	V3Tlt85/훟;IWK1-eN!P $ L ??k ( ( ( __U(/&Oď/jxʾ ( $|̿>m/ 4>!ởCjaIGqv&X#:$Z|^M؋7߈z nhm߈MKmVOpGLcGy)NǆܽofԅXFSkR\Дzz)]+ø
cRPUkgiF]7k|}w ')|5 a?~>ӎOZObOJv,5[UHbUhř/ ?cό:t~zºωt
^hiHt%kۏ6vme7odXvd8ӎgVV:Ujޚ^jΰxJoJ=z(ԦwKKT{[kL S.
;Dh ?>/G+f o-ODֿc/'mC iqO߇Wv1ڍ.
۳Dm;ɴ?x|X1>4k}gP EdwM'7$wP^"aif"NƏ8~
Hڻo
]^Xڔ!NԮn/m(ah4j:WSə ~g  3x?/?
|IkEYZź4WzG7JٮX :.{xN$R2j8WʴyTmJHT{Fl:㢔5t5|;x5[-}'D4cq^Ȑ[A,$qv`	  ra_~ ?
~,|<Q|WW({$&L!,44xm+%1UT]4RQ:z^/m5h߿>  ~/x^@'5	iz%R%/9y_t; H wO  ?:H|5VՍ/4.gy.2.dMӘ]<<sC?Tyٯ/φ @jfӯ]<C7\4>R[\|3ij  cg'w Ŀ CIռmn~{*慚^Xݥl;  A߶qs1~ֿou~x/OP]&/f;;KhAUinmi(QWXbW? ߲??Go.We?>/ 3y~]P-
W,α E PE PE P_VE??G5*> S-  xC h S-  xC h  S-  xC k - 	os?>5 *[kW/7:sqgdYZlJf9 )JZn?kMB|}ᛘ5<0[wqsd&
ܗvu8fͱbc8 -kz5g7 
DOC ) U  w U3[+S_/ #Ԩ z (n )o?e_:ՁӼ+Y,\.YPO74Z3?gÿ
xWQ{,!V+a4Ql$&.
]i4Oҏa<
o*:.o>:Mk
>X(#$UTTUP c# 	ρ|fhᏋu(૟?rǇ>	yr4~G$pk	U:
PuH>-V/WKIi2:}ƀ Zx@%ć79   z> I) _@~9ݴ Q@ Q@ Q@|%g $k>%ݴP_L7_;}@f /:|
% k W_Ӥy72èY\Fٚsk{i-%ou%?'ga?wP &YkWx׳O
pz>k0e<w;&xb)K@?=g k%x+=.hxPhcG
wڅ֝
ܭ,ufO"(z O_ i)/#x]xT):Yn#
<REt3Cm5EJNq\ZV{%Uʰ)b}"կ'fZiۗS~ݭ~ ˍF]C㯆 |Wk+[ubO#"H%xfdsI<  ko ?֥~_ <:_5I{xNK=Z5+ٵi9aD%

Fe8KTdڒ䪡h˙d'y7[ꪰax*ixIi{j ~ߴ ?4M;!h H:ׄߋơ˹{Cn4mBJ nE/Oǿ  u ~ξ _'6Pҡ>#x>6b^Դuqs֍s)g|= xs o<I f bwg1k:VckܫY(3)o-ߏᓿo?"⇂u <Wi_a&{{k}_i<MZB%ͥ ?ඟP  'Be U-:{uC"qs6^iK
[ۧ%ggYxذ[~	~FksTirrF
mΜaғM*ܾ,&$2>kvZE"o^ 5<Ǌ!O^0>z\b~ˠzoQVTխ}kgŪZZv??Ɲ	{O?owO៌<+NмM.Eƥ^iK|Otk{{7RTZm75Jԯ._o_M__xDg-Z/<ǩ#Zyrg)g#=?_ o?lOƗ_l4VÛ
J&_mĖ\izi pi?!s r	5Y
w546&oRkEgԄQ}FG-qVlibhWHQeg{>3Zzc	Unuy;cQ /L}rX Z]Z$V#6{ibh]2M-[cQ@ Q@ Q@~3ZoOnO H%)|Y[þ}KN>K6U𮫩_h-ZCt&Ӭlb@[(P?n-S៌t
G"ŷ[Iiym9!D"tuݹYX?'?ӟBO* "E : ?ӟBO* "E :?ӟBO* "E : ٧; V?_ixéԼ=-Vnַ&؟.ams,
kxd%w B C@57J m Ά*{|D_/_|[_b|5	iz'K\J_ɷr$w`]; 'y?:k^6ֵ[X5o'_nkk
,I+31$_x	9 9g?G|bּ_qbVGwckW7\Ksɴݤ{fuv1<OxSKEN:>ƶ:Mk
?8!4HUT  %w B C@57J m Άjoۋ 
 
 {o[Y4[.?
|!h|淞?|6֯6qڵwqcs=wͪ~Ͽ>^~ Qoۡxvz"˪k^\kSo>}B{!nr2 } A} d . =@B|	n
bO ns	[j( K-<躗/IPy51{gm_ƀ
( 
( 
( l 8$c Ugĺ  K	 &#oZ2h n_؏N)_UnMh:װk~%_xRPhKi|Z^Y!Z[vMp ~|xc _o;Qao-7_Yv@e7zSimi2]NbN|7 {
iJ ]rCY_,k[),Z#_YcuO|%;_ 
ߊ|SCocH9|@m(<H7Bf-J( I J_Q,w/dZEZz||Eg6R«%F6IV?<:i`qh-I'Jhn]q:Yv+
JqmKdvI7m~V_~?_R۟y_>.-/Zyqǧ/QN..aicG'dx* &S	_ll>"|Qoڦy ] OPMuhƏsc[[>c^Q"|-:5*i%|Ty-fVĸԫJ?zFeCQ??+~~8 i~-% -߆<)hgh(EڄPl6fTE𧅼Ox_}M6:Mk
*QGH zO^+[o¯O?|׀<Cxw:P뛍B엌^}sCNf`H S X&|c qEeL4k#]wY
畧ũ_/Mcv5=2zlfm<(Oԟ	~mi)xCz} Elm6֚噇TN5q<yU: c >aן<' -ZKn/b7rIq=ik jgϏzg}I ~кo3E^!u+gALwx5&;WLouqb_hmg6~[K 
T5
֡m344i`be~Y#=2)SCo\Gq?:  |MO_~"xĺ	UmW]iZ9mL|CmM}{m{y2ZE&NiϷRzsWRM_m_.Gm3烾.7,><nӯ`6Ibtuݕe Goگ{$ 7Ze,T¯~M{iH3DjCcOOwcoZN&1ѥ4❕V][.xabjj}վ &~ ?'Y4];_iGoI&&菓sٯ&n'5M?<
( 
( 
(?⇎~uWƽ{3a-?xRχo#I#k+m[W7[9[{'~ߺ'߀?7()=c~)<5sa+NѬgݵȮkbᤓRMdDin"   X?0[c  ao { 
?ᅿ?`OA (   X?0[c  ao { 
?ᅿ?`OA (   X?0[c  <W?A~ο>; !
_ Q_?> Y'y;<.Mll`LbCviC_? uW\x:2|F kC:&}?
mIP| 3ʋC.+ʟW~ p ?d ?]S   S	u 	?j'Q?&_cO_LoRfMM6j49"Z_mO| bSD1s0j߱fonm|Mm u
?_dʆIBkϳ}l?0Z	 = k'  1FgIᗀ-KЮ|;	6|?lgA
6Ƚ%#@{HmhG~^+O~?Mj i	M7zAyHŮ;MUiRS隬%Ɵ=ٴPE PE P_	~ qI//ωtm'MG<e_vE P_:xc'If/iuB2ܶݴ+spJe(P巶@>	 u+~_<CkBSEu9mMZ<)nV!m5È`>^`_Fأ	@ezO! =OS47lXT{V)~? )oxSφtk:֟q>g
ݎcsCqmso2s,n+ @_ ~' T26sQ<c45j^
uђXضr+ּ
cwh=[J7| wlmq-
b2 z  r~o&|_@CTG<<|Lxť&u
գsmF1<_E 8e; ?i/c ~c>_ \!.5KY_ڶpחDZ}6g5ue]nZK~t?OCfh系֘}>[Cc5[0_ ? F/ටx7@֛&}.C·[MY	찺U!x8-9 [ gf =?g +ֵcEӼ㻯,I3N]BY%gg<دVI!tO7dhi kLnL B>?Oh
f4OSAv^
OOGgr%CMy~U|KZcW¯m/%Y;
SNmUkOR=uW?"F~Kouuxsk=څΝGϰNIoy$8oT( ( (+  ~˟?y|5o!WnZ>𝼭7se}awi#F+OyfT?m^)+ uχuSLo={:^kO:YxwX $PJksn n   ?G R?~    04  Ѻ   `h  H u    
?
 F   #  @( *G?/ Q T7_?_ 
  n   ?G R?~    04  Ѻ   `k訿cG ~,? h | [Śe7|;ayQ>:=朶ZWIgV@wWwO túࣿ Ώ~
WO*ΌGzfG5] hiwcu
v-mmyd&y{y'?~5xW S<!sLx _+:wletFMCM4A8[* | 
?
 F   #  @z /.,#Wt+.o+~4>7jRﭠ]歈 J?k:ֿOz'}-}5k
6+{I|_͖&M3+Y,]Ѽ9s{2d }	⇁~7)e~:_fhnR9!7waX: ( ( +/?N;	% eX Y.>> d ɸ|H  V ( ( ( ( (7OQ|g B|'.7<eҖ
SM} 8轑Ou;8	m = Ax[?|ZGi[O]&(辰K+K[=.`//$H"8TmRdH]IPe)﫶b۲tWD Q@ Q@K of_v c%ul|M5449=OC-|Cw͋Yy%~-yM*  J3_~ @(/:S  <?Aҟ ߆P 
 gĿ.3 *P_t>% wyT  ?/  ʣ) @ω]g U O|K ?  J3_~ @(/:S  <?Aҟ ߆P 
 gĿ.3 *P_t>% wyT  ?/  ʣ) @ω]g U O|K ?  J3_~ @(/:S  <?Aҟ ߆P 
 gĿ.3 *_[ïx_%NAb<u3?KW,!s4Vw0+ۤk+w
|2<?x[IS÷o&Y]}mF-Ml[PE PE P_	~ qI//ωtm@ `~3|/r!//W4SN'x>9!)z
*8ʰ'ozc ?:zc ?:zc ?:zc ?:zc ?:zc ?:zc ?:zc ?:zc ?:zc ?:zc ?:zc ?:zc ?:zc ?:zc ?:zc ?:zc ?:zc ?:zc ?:zc ?:zc ?:zc ?:zc ?:zc ?:zc ?:zc ?:zc ?:zc ?:zc ?:zc ?:zc ?:zc ?:zc ?:zc ?:zc ?:zc ?:zc ?:zc ?:zc ?:zc ?:zc ?:zc ?:zc ?:zc ?:zc ?:zc ?:zc ?:zc ?:zc ?:zc ?:zc ?:zc ?:zc ?:zc ?:zc ?:zc ?:zc ?:zc ?:zc ?:zc ?:zc ?:zc ?:zc ?:zc ?:zc ?:zc ?:Zl~_s 7_1>7kz֏hZ>#B2[\"BOfRCMP@?d ( ( ( ( ( ( ( ( ( ( ( ( ( ( ( ( (         & agatha.JPG  	P on mouseUp
  checkIt
  answer "Good Job!  Do you want to run it again, or continue?" with "Run again" or "Continue"
  if it is "Continue" then go next card
end mouseUp
         Y {  !
 JFIF  H H              	
       	
   } !1AQa"q2#BR$3br	
%&'()*456789:CDEFGHIJSTUVWXYZcdefghijstuvwxyz  w !1AQaq"2B	#3Rbr
$4%&'()*56789:CDEFGHIJSTUVWXYZcdefghijstuvwxyz  { Y!    ?  s^/>!;M==s\ԝ6pTET@O4pCm
I4K1G$"0į/ZGv㽹ყ|Zn(:l3IcNmfEi8ٻ	MC ~җMΡ&$5"xWqC+l*GX#0o
G  }e ]l1~M{wmeׄnNXmO>-dyZGo.ʗ^E3O^_yOx&Z}M7v:k5͵,I̮
 OE PɿPo>0~\ΫӬtomA|O꺕Xv P"DxฑV?O
Ke.W(?qgJxoJO\Қ_a&]T
GY" w>?G»߶wZƑh&<Kit׳6!{k_tasy̪ln ?l.3ޟ?٫ᯈlM,t|@o[u)ŧY:yosi)}"±-% W1Q]o5Ϸ&'>%Wz7sEY%EK?;|,  ;;x 䯉|WowM4KNګWOVl{s>g\ |! +cO?
=~,_%P爼YOcI2^ˑM2Y̐b~~|=~|)~iftk}|6w/n~QIus)e<Bs@E L~ K
 ߋ'xBuSUmPQӵ\,7:ڦދ?K䰸w>'OMT$i]wOkq9;# g/<W 
|=Z# ?F8gTk!Լ=RKV;q,cb b;ǿ~~?
<  kZ:]ὖ뺝]}#gko0K6;f4i~~e?ٓ [/<=_#_N>./y_h*=7lLL7z xľ}^ԴY4EՍh6s;UaXvzMjVWY6o@~!  >O
޷ۨn%O(Xw$듕tc +u  c!Go|@W՟w
{J<g 
ϋ ^Ҭ4(En ={oy.9ѡAI;_ZSvml|= ~ SC?ट w_,/z5o[BwQaq&"	d́_E%~' b_Slk oe8c@߆>+1i{{;dkmOS>~z{^x]ASMniZ5tos	}xW	1e~.a i)w㎴K࿎v-[-S,⾵>|iur
kW^;N.]|MB-2?m5Qf; kin|D>TdN9yDCq +O IiG _=Eτ=3]o74[F,ks(%i E#6@a?m`K=m wo/ɸ ?cG˸A `9uiҾ  ~,=ᾁ;n%(t5숵R_XFJ hy$|
c~Y9}ܷ[=ߡ)#sZ?W 6Hg 
~>xRviZ6l e}]0^i^oDKo߰7
#W	S>0ƫ?~|H

:+v4M-V#8 eǞ_Nl>S9>g(/HUn{5cE6ө>
m?oO(a}P~H{nd/m/^)5d?4(SQ
*ъ9mݟ?Yo[ i <~;?g2mam'-R[ӯd6}y->u[˘n)kxnk>g.xw]}?^Vf=CEִ?y6~[wT6)#i  A~۾#.m ,|C|rGIybKdtfh-	aDگ߆W~^<ExFY/}w|e~	 |M
_	R'V.ҾxKhm+ͼMxUY-fBiھ[=om6]ϗ>|4>|nHGߧ&FG.sSjvVmİJ4絖hݭ
%y9a[1VIYY% ˡp
 _'E k ٚ 4¾{[VE˭[.۴-eU?ܦ& <|iG&?c㯈/c|X}Ue&'IjUa;
2G)x>YM4z3+ ??ό`o
>-	7ik/#G]9~ߑk4&Bi?W%W	-@xCĿ?	(Y'{߈Vz$z=ϦEu
;KKeq<=|h[CT G(SeswAZ{}\$)ne Z"YE/&2~WY\sLB{5 F ~¿L
H2흄h 	;|'o/vré
K;k>F[	.[%տ%hr?yk俴	XUv)bi:ū2 5YF:H ?<gxnZ-ƓƚΠK6<҇KMQuA"ھc8}B\z>f^]OQ oc|#}k~?n MwWς0E>fi:aion:tma$IHY[ߊ:ptNK9EXZo~"?~0a~4mqE>]OV-}橧}8Eդ'l\,[ _>4|񵗈~xo^s%Y\,K,rE"$ ?*nO ~߳'Q?g 
|7xiҮZwkiwi,l
G&FmYXO/x_~ώ<[
gzՅU7v:k5͵,I̮
|GG&_yAW?&j?M&,4^9#EҴݲFy{,Z1s>Vծ^٤g7 h M g|{
RjpNFk[E5RhiyF"KmOGS  ?h?.χ>~_sğY\j\[zQ^N-
糒nR;I.&q'-}G}~^W$}]jSw[E{AE {xO Zu?&eNZN3ae>9τ-Ri5]ZLr˯]p5m$z=?R};y H_t"^E&iVז׶^UY-_1xn
 o
E5'P{7O'%mfª6:QaymumOW  _  e   ࡟??Úe෌׷Iav1ɅVo'7쥨~߲ǄV^<oZ}+kK+օ;K~\3xYbK)ZҼ{gQ_LbP._O>&_}ƭk6:Mm5̱Q$ʨ M ?O)cgōC^	cJ ֕~#xmwR-${otOifVPy}Nϟ?+o
ƮsTWpW߷_;=?f _׌bRmOڜmv*#Hi!iҍ*5yIbm%v~m)bڇ_$Rվ6x.?ᶩu 3xcXK&(/m5m<lSyZKRA_aC
B)F*~78[mAE ~O ^k?o w2~37S~
ZӠ񧊓^t =M8om;ݖy- T~ ?)¯>+)ៃ:W~$ǈ5Nv$jZ͍pbXi58@><u<N.^I.ceʛnHjֲtc_G
 4Ŀvڷk&<S}Ojƿ0{*to@OZE2KHI
 _+~3_5KAIq%dĆ屹H!K1|n,%Uw=VQzi}f+ q  ~?GoS g߂w̶PPkAz 4oMm
Eg=Jo2XƮ9ד֚myo`w?+P
-P/?~4P;@|S-K?^m%MI4\0\Q* ZWZa V G#_
}S-nѿn[d1>IkObeٟ_/g|N/
#xH.eyX-pL(A,ȏңG1W7F{El,.07	F	([\vwwGw\|A~CC?=JӼEhm)G<2p0ĲY  ~۟_?m7~?oCh&״wiMgbHP]Ef8UTi&Ӻ1<- w#/ٳ
C@uK|
U|F l_QͶca-,d͊RMr}; h  +k O-ό )OY~-gOy|ldtn"ӌ\ek&WvVTmR|MW WL#W '7=^_3 xOӵ2ö7~1TuuUi'.:,F&NPC2brNrWjֺφ;
-&
3KXl8#X qFUB ܛ?)NNRwoVS
9&?f RfxaxYּ=M/c|tm5;
e̍)%iw!,~ϿqGk  Ň4px ^ӥomVao4lLuϔ.%3JqJ<r+}gk_tg8j<F0ƨ<J6<ֺ-S
)ooP'tڗ	v"UvwvR%-_˿#d%
 ~*;jg
>/ɶկ4}=#S:UQqwui"O,jIJ.韧FQT;E1 W h.O&ZK_EEpKt^?xKTi+!
eC&Mx\OXn}` ?ŧ?~琢>6>4x><Wt_
1?\%=zm'ΚZ4W7vw?]/
 hOD5#nuX^fj:=+ݳͬ]'%SВjW|(ַ[?q=O)Mzrx5=~8|'GAҿ?P/&@kÿdQSooD罴"Im5l-CPӦҞ0O*;w Fl?cch8:X;&5٦`NM>3?
,<[6yv=6~tkVK7Q2ڶ=
= 'U]<A}=||Gו,S_bV>4W'aE P/wmcP|m>vꖗ}NltI&[Q8!Y}	 (4~ȟ #+~_Fe:"}\x/˵!WF9ʝ|o^{۾:dKM>vٻK{k:Q_z~h
xz@iXڵVz=)q}}s5˪ 53Jr<9gv'l>*
&gi%%~wS bƤS%}f #_'i/ h #_'i/ k#* *_.q ad/  ȇ!
 ;K } G!
 ;K } GFU @T\??O P CН  Н  #* *_.Y' ! GN _o מxcp{?<zO]sO]'Ym2^T[Ԣn!}?tچj׌cnIi7evnNGkHJ+?        ) inmyday.JPG  	@       N u   U JFIF  H H              	
       	
   } !1AQa"q2#BR$3br	
%&'()*456789:CDEFGHIJSTUVWXYZcdefghijstuvwxyz  w !1AQaq"2B	#3Rbr
$4%&'()*56789:CDEFGHIJSTUVWXYZcdefghijstuvwxyz  !    ?  M'?_O	GZGj
|-w}_\:|77Y,I+31$_s é ?g<! 4 é ?g<! 4é ?g<! 4 é ?g<! 4é ?g<! 4 é ?g<! 4é ?g<! 4 é ?g<! 4é ?g<! 4 é ?g<! 4é ?g<! 4 é ?g<! 4é ?g<! 4 é ?g<! 4é ?g<! 4 é ?g<! 4é ?g<! 4 é ?g<! 4é ?g<! 4 é ?g<! 4é ?g<! 4 é ?g<! 4é ?g<! 4 é ?g<! 4é ?g<! 4 é ?g<! 4é ?g<! 4 é ?g<! 4é ?g<! 4 é ?g<! 4é ?g<! 4 é ?g<! 4é ?g<! 4 é ?g<! 4é ?g<! 4 é ?g<! 4é ?g<! 4 é ?g<! 4é ?g<! 4 é ?g<! 4é ?g<! 4 é ?g<! 4é ?g<! 4 é ?g<! 4é ?g<! 4 é ?g<! 4é ?g<! 4 é ?g<! 4é ?g<! 4 é ?g<! 4é ?g<! 4 é ?g<! 4é ?g<! 4 é ?g<! 5o xn 77MV7C^4/s%QF4PAbƤ  I) _@~9ݴ Q@ Q@ Q@ Q@ Q@ Q@ Q@ Q@ Q@ Q@ Q@ Q@ Q@ Wz ?  _&Wim PE PE PE PE PE PE PE PE PE PE PE PE PE ^{c  G  A$	 dm}@ Q@ Q@ Q@||?:/OMPxsMԬt-=JZdqI
jW+kɧ隇m?n?7s » 
O]jǍ m+{=3þoLY~,c# 	ρ yDZ>?9; Z??hKG'>@1 Ih ah <?- - ǟG% |~ sw 0 ~N| c# 	ρ yDZ>?9; Z??hKG'>@1 Ih ah <?- - ǟG% |~ sw 0 ~N| c# 	ρ 

{/A|_# Ht/뚕ğhW+{
.$2KTT#/ه'|9>*gPO7 zD:gtEW]eX]auwcv-+(@>
( 
( 
( 
( 
 /_=R?  #] KQO   Q6 ( ( (6~4x[n:~>9?mbIolt)#I75ycRC:X~)?>5?4ڎ|Iq-G߆?xV4MN=&Fht"I	JӖa,; ේÝlmO+C|>5} oS:M̫-{R-t;' ^կ?!^B yx'!,y{ma'wK3|= 1f 0<OkPφ'E>5_xZzu\\dmJy0cB mG=_]A49}r?
X6jO:Eޛ5҉UWt5-H; ~
 o?4Yx ?/mM<QMY͎aVoGgsmLOD1?߷)W/|<}37
$ K_{}^TW|P鷳MeoWB{x<X$Qm-GT|  {b/mqxJc4K0g[Mծv)k|'O#
K
w~?r]N OH4;7[Smޙud59MD^8 گu>75?x 1爼kMzN𝎙x֓%ЛHqxn~i+7i/ l?	 >o^/^g,nmէd%Ա\Z>场}7VL?  _~/|m4}O%el6S'h|-|Ɵ|3 j^"ҭlKo+xtgwm][P(់ ]' hSG֡߅_|LW/^*ڎxd:u/h,|\Rb ??oQ)}A4Am6i%ҮtF OͼHgg j?;~ѷB2⿏En<C[7-4ib:eNPF[$K  ^>@	LlOokǇ</k: n>sMkmi=񩹔'e [oy<e+	Yo"oAhZφlsڳ};;o.`x %Y_Q/(K?িg/ \?~I>@Ԣ5Z[x2ic<0lm #j>"<AKPuk>CդEX'yf1HY,sZwO
xK
'\Coŗx3k/{e
Nit4_\4QI<Vr ~Q@ Q@ Q@ Q@ Q@ )X ?w	% ( ey _vE PE PE P_S_7 _ ez- cߍ> ~1Ҿ՝~gCKwos
%}cgkψ߳gu/  l~>'o~PͿtx&>{M>GÆ[Yo0hƣ;Ld;g߄o#C7x_V/k嶓W~. mRNj[I{k庑
 O$WK?(;ÿu
|Cǣ_hfq$Lcncm.,nldٿ<A¥ύ2'^L2`㯋?Eom/ľ?56]XBiq/D)4YO3^Ffidu5/- hx_ K{ß<;ugu?cMeO68[d _  _  
_ڬ   ~}?mO}_'wG- z~	c߂ O~;E՝Ω?yMiommUM#Ts Cwş6/Ϡk 
:OE楐BUTwZd|J  e? . x/PŚF?@eյ4(_'O]McbIO=29?=M17SxCF~6Ѻ|EH5~:u'MzL/zѦgf?fυ^Ӥ៎t[ _aݬMŴ-__o''	V>x_*CĚޥ'k1i&j:u:uݠ̎XeZf|#u 5S_ԼMx? uK錭1e
yp[m1
@$Y$ ? ~_i_ Ov7shSX>(o5M"S}Y{kJQ,&i& }c/Wφz v|9hB>	+Wҭ5O*9t/>էc,,@R={[[x/oV6:\zý6K-M9SèLבYc0n}k~ ?nkPW4oh.!U5%I&xO|)-5ZO5hc֦5GK-iL-vmE> I) _@~9ݴ Q@joWo|
LxK?G|H/gg->tc/*6%\?ok)K1t>%E-uƝms
z:P nKYu4L()/Sn >?4_+Q C}C"&z@)s
'C. f3K>sZ7vh^Kڙo7YvFc?b"^~@?:,',t><'~ǺXdUI  ( +J  dC ԏtI/E?+G4
( 9<COߍ?5쿆~5R5vIwy?lM72?n
x Zz#q`XjZv3Uɧkږ-ׄGMM+M߽źV??g 	W3_w_|o k7ڿ}/ݳϗn7s) Q `D7~: '>jz=Z>wK"2?&_\[^k)o/. dW}><i凅uZ΃iڞ[_Z]̪l)% Q@	M> ~ S Q?n?1 :Gwo_ o|G'~n VH>vV	fKI]kv_}e娏Cmw[	Ŀ֛[hϪ\x>[{Olj:
ވ
$TЮn&R؛ƿkou{Ŀ|3C嗌zKxxmFծ-5CK7PW2٬VCJ"Kj ?od#o+	hwuO	nici ٽ>(X䵎H ~g  >}O7 hj
 hR_^nƝey=U+/i C7S x~hl}xGֱkwtFmkH'Y=?G#OD WW>.>
.>}5["YmaTno= | x/	 $x ߈~>M~UxHsGmdU
N٠TiZ[v o[: ?h_)	j>ц_:ׄ4M>Rs$~"Mg]INd  R![oK+
? xsPj7
ռB C.ƙk٢K6-JHmNkKef ( l? ۝
kWZ񇏾{G P|!yym蚆ffomt
Vݵct6
n J?m ^3㧍 g-ORmMR"ծ<3hmդF}2m5g\iH+~%x~uK׋4?iWRIմ6wO˧I
ŌMli
, oW5-   j@>M o~^bJ5čSGv/uvMjV-K}2MY$ J x|/= /k_>&i ;CCiq{K9އ3$N4}>_
 'Ow
?Ǐ~_
 ZO_C 	'1 "n7jwZ4m;FO+/I_*O5x>xnkM[^
[F˦ˢà|ɮne7H.{?/ۓGOh: 1|,O
;Lñ^Y
}.$Y|zi gsټY
5ӴDk-"O~AjoG-ۯ.g.I
 K	% ( ey _vE ~Gv	[\|k_xIF_iz֩ut]A:${4]^${̵Ej_'?g 1i{^~Ծ
phYTGi3$Zo)%7{?2~x  ٺ럆:%[
+Ӵ5/$o!ח_^w}j-
į(ψd ?<
;_r|, #ClkwBKo
I=?~ǥ@4hՀ?o%;K??oo5g zig7sj?dN>+ͻsF	o= ߿VQ
 >~8 x3P~2~'$Pn{cBlOk7M=E˘n:k	_+Hݓju趭t[O
񬶞՝YfiY(ڗ
 B~Oukm?Qҵφ|~潎4YMafXQ6WQII <s_,g~  
MR|?|Gj>!->_˿{?`]&e+Q  _R'U^&-@hZŮ֖MI˖h#-Ieff\J }E P_  V?g  :~+ I) _@~9ݴ W߶IvRi+/Oou4˿'K7ZSHIqjZ\NI	J ̇Ï+|Pֿൟu?k3' xB't]RMJЦԯ9//'ܦd1}G}OxG PM\1fcNR8/.|xoRT ,e Z pGఞ1)W0  f6-%cIZ1^$ttMV[+>gKY?: ($7ŏ^ WH٪|=wH L>-6
}b(~uKu,E
<Os=
3@M?<^~GşOSៃ?|/kgsOYp][Bf|Ɉ) uc2> ~NhP{ZFWZ\̭ex(fpFb|yt> ࢞. p^2~Mb,Ay׼:څ^k}B[ԙoguglse;ch$~տ; 	W3_1_f :F;jϞ_g6%۝[-u|i<
K!ncUƝ<WsI4V)tD̌t:/_<];x㗄/hOM[\-tټCغ2\)̈́DEަZfh ?- ?fs?c}^_~(_ <U>6h">g]#hR,&{{wMPJUEuڥ fNdP RO %CS	m]2Boijy6,#M[[[-p_p 6~ܿhǚ~kO4ۻ\Z>vZw-͙&pAV>?<E߳9xB4յM:-%ޘhYolK$J]An o	Uo j  x~7>χ5
C_$2/w^~4,Rj2Gg	hOgOڇත~9-|A[9}eyI+IP$y7Xf<s?R'<Wx
GZ񶵨[:>V}s"ommo
I<q";:Hz[-=Y<i3-n|cExCC.%[GM$7V5Jp)  >% eۏSO3Ð^|<.$ HOM
e}YR+/7)})xXPO~:|N
m7R4sͥ2\=Qd76pd@ f@KQO   Q6 Y
[~ۿ&~x~/Mo+ Lƅs,ۭcIfnwC_7ퟦ?O& |W__5m:W{^ h.}HRVU-ve ߋ_^7Z
 ?D~7|1&j0Cs'G/Xq_χ.au{"Ϗ(̟
?WO٫#'Ǿ#9$s|-5/'GY5@ӴydeI sLࡿk+_
fSCYx^ 4;45V[:R u؄.?-|o$
C2t?G⮟'6"gaߌekؼ?c{?Gg\\6>e~k /	 r t=Yk\5K}xXYn_
~.ӿ.k u?fυ>
nu
z~K'F]4X
gjuYbӯn/ >o8t 
 W	i5KeƝ
5͎2OsFqm$I`~,~ Maojg½> MoK׿eI54-jOGѼZ+K8o?/6x/㇄ |Yh~<U̗ڟ
<ahV+{k/l.Ya5XO&&o( 
 /_=R?  #] KQO   Q6 *# ~zi{e2~ _vXO'㷵id Jֲ'"Ѥr_0~_߄?c__w7{_ў
HmX;A~bt\F  fO~ƿٓ_iѼ#%'[PQvW\J! Q@G'wEcb_c_Y6:guxO/"%/m7,$vZ{Af&>d <|wٷ
 kx'_ xRJӵO
nCu)qRm,v;JYO>hxi[iϳQT 
 m A<eֿMk[/<;vNs^fllφm#['h|R  3 fO
/g ұ嶗~ip]\̻|ϙڤ*zM?<^{ )B  {[3? fxK?_ҵIm-f]ʩ̌RY@?~3 __<k;⭗VhxúN_ZETk9ȍj<F1#0/v k|A	 -Oh~Og~̶Nu{մz
E'{L$"8ƭyv$y+ 6?jO:WdҞ +Ec_ͦgiͷ3&[+}	  /~ԟP/~+~?|kV9u}'>5-eGKbKIShP?J^ X>
iZ ~ڧ<S:|Msjsx[YM6MGZ7GWVPS ?mQ_*[ ko L4+)+#Ry?RidB <5 '>Cw;g㧌<KOy\PEzZpկd[{)c
[ؾ,1=?27!w -]Z R_
j^;2+ԽQIF]>pE F&?ǿ' şړ?<_
OI	q5<vvʐvKVFvx~iR|7 =  ?>,B~_6mIC|Jt-%K9OMkFx`@s_'R|Ə ??þ+' Igx_lm|m^Hn-e_҇ / g6>xD&/5=.-:..쬦 H+ɒg<@!F C 	g3)?o۟b7/3~' HԟEړ }KK|UR^m4+ka^Y5>٭$^<@"I W~ſ~1 K 	5wV~ my?ٞ}ժyпe#/ L ${@~&~ϟ>1W擥k!!	n;y6^%}1Ҽ۬a  K	% ( ey _v_:~ܞ?أsC@|Uxm'V]./Oť
L.ɖ!s"m ?%7_M | oƿO=xXӥӼODX{\3\.l6VUUm:[+Oԟ/[Z|AK_í}<MWnOvOelg}\@f8^ Mڣ~;~ݞ9QmxXMVxoƾ[+<G%9|YgIKx,mຸӓ?๟ O7a g~\4C\ԢgIOIԚ		,]X*j9 ?~ɟ5MC桯2C7iZ[Z\i=/<Wk("}r	Sh#oRK	3 |u<e /ՠj>io]GhmgmZjvzMůobׁ|;Z^ /n _U #;	B|?IPEgmsEvO.ӦWdԍF |e3~׿?cM /_\O;5.ĺ̶VuݫYmӡm@{I)6_@ӿ|[__.-/%ղ`n43,hL=Z?>) ~?i|hæic$Fh5[{I
Mg-%\- -?u?gᯉ??.D9u$/4oh" 
 /_=R?  #] KQO   Q6 j?+W
?:X|=W[ZAj 5	ViؽY	KH >   p&GOZx{&VO[cjZPq=Iy7V  79I~ͿJ?/;Ned~Ӄ~x{SV-JH,^jM꟣ M":ό|ox[_<OC
[ם|GgV[\Yٿ$uB$oq50[B*JTae]n$S|; d -@)i>.a@~#x__MmcŨ|E^uiln['6M<o~8|r uu?φZ ÿn|Mo	iٵ "mRfѴs,zKCvMawo'f[Ύ>W]
S]w=^Ml?[࿊hk?ZcM>=wK2X^6.!/\QdZ/$ฎUh州7x_пgߍ>;?Pu=nfV3CjI*z}we٭. &I
( 
( 
( 
( 
O㯆 g4i񆮯m_/lˮj[-^ݛy B|$__
~|_e3vx[úon.>;K8<뗒ia<]ݶff$
(/MC^Wz7-'Mm-eӮmQmjkscjl"aϖJϏx  _^H_Ic,ilw7o*(y%9 ߟ f ) ><~Ͼ?g>#⏌PVvPk
n-"Ж7NV_<:g
kYx^=V+N햫7C\X-N
*)y?`)կ[?%?_ wYiׁ4[[X[ԓɶѬf:ZCb,bпoGo+c ko	|_ 	|/jK=o\մ=95w$L 4뛖8]*e_|D~C	0<_ ?boڏ5=;_<* T4_˨K]g?eo LRpk8[xXc3iq\}HGW! ~'B,O_YxV{{>%_h2^G7/t!QܭC=|O 6gPks?mk>,K4>!lmM>;-;U丏Lҵk)2jOtxws>~&	j֟A*o:麽kˆkhƍז"-0< 
 /_=R?  #] KQO   Q6 ~|C :-xg/<?
:;݋f-KԴTe?B i &O H{@  _  # 
L 7 ǯ?a򿱿w ~cKqxF|WUݗ5}F1lxyhytOMxCǿC?;e X_R 	pOm/(i|C?yOm%Oo=d& 
< ! U}zA<\Gh:Ek8{{ Df~'jauQF7vvٝm8ʺXB> 
'd⿅ׅ/["^O
 g[j<I.c(?O'_}C|\
xᇌ,]%g%Ι>Z^ae/Gs`Axy4p)b>+Jr'ihzekgUh-jwO dxB<_sot/4:)ikRTۦ-mGP?w]_^	'k'e}Gע9t
OS,V[9zc ?:zc ?:zc ?:zc ?:zc ?:zc ?:zc ?:zc ?:zc ?:zc ?:zc ?:zc ?:zc ?:zc ?:zc ?:zc ?:zc ?:y_au :%	gq%{
S:՝;oK#X~O5_¿i
yw*[MGSWYfEl-llmB]H( 9CO'K^(l/N>2i7$,#l~_~ߵ xOV\H{-.e!Yg6PF t4  ihGo?i?xV,~6|F5-fúeMX5:NY,l"5Ù~3K c |A  hۙ~Is^
l֞U>4fK%FM8C  iok? ୟJ Xxׇ|;	kV /o򵦧e$k1
],o[i[3_E? e\ s7 ] 
/Oi?Ɵw׊e-YZ\56V^^\MR/E g ޳ G4<⫽<-_ ]1qߴ d%Z'ώ6 ӟÿh ?")}3Ǽ]MU:N䱼iO҂;'?𧅼Ox_}M6:Mk
*QGH  ~) H?_~+j?R_؇ĺ  #NO ٺ?쫛F>3K/+ȴ1#Ο(g4KMZ֚Η<AI2oMmgu1%E ^{c  G  A$	 dm}@|M 4?Sm|oi㟄gV5[Fúo0]$$]e	@߳wohO4]K u6;_Ie,5	`.I`-n.f{)<i,ߞ¿qk}xS^ SwލB5׬l3pʁP]_B }ƟSk[>m=ީZ^xSh,/tFKfaH)W@<S	Rvm.)M&H% C?~SANxYH<Cn$l+Tbo{_pN5#BvSV_&G[m< |lW3Oᯌ4
C!~qmjZ][sEC,D* xP eo?L ?fO %V֮^,m6iEj\uʴlsC{T}R;?։ߴǿO
i!2*yhRIX9$?5R fX_OV/Z/jkn#X<3+wYmMv6Qլ4ҏ࿅f_mCPO h	iaJK8y8d5,X(!@@ Q@ Q@ Q@ Q@ W?ۏ_ Oo^4 {h|I+\|@5=m,ahoYY S\Gi2'"'\=T?~9  nڇmw~<OKkt;ìui/-4^2[bd,M͛$fI W p|aax߳>ٵ
+V$|g-_	_ios%mFҢT`GAWlӿ 
)[Wm<E
/Nѵ-GXֵKot_eg h]5bI>|c~ wցGCt
W쳲/¼ݭxo6ֻE6z%]KO0	 ॿOCQLZе][Gӯ?-ƛr/,G[,Zsl")jgG_M/?_ a;_b~hvZ­r9ojWpyvIK; Ũ44@?k-)k?^9Ο->I5[).泶/,0K}$Q3nY 39o?  |xũud> =^;KN4x퍤1k2k;YL{-e3}	
 ?agOZ }_,4Big;
cj,VIyV$R2FK ;L̿Y٫6j _"#KtȖz޳2X=N-Qt, ҽ Wz ?  _&Wim Pӟa)~?|3_7_Iq%ŧ,m>!H|hF9 [ e	sV$Zh7MxoN7{W8CX[rۛuuUq~) j_+o-?zUv[ ^܉.!Gi
l5	@gtS*F;?oEv?gw
 ^_|`5߃3v:CkAW	k
A%6HRc"   3@ SgW'< ;ڿc Ѽy\}fK'ٽ-tޏ{{[TsԪӴOz쿨+? =Fjmѭ>۬\6Vyī2 K~߶.e_U/ۑ?]k?ǉ"t?hz:ZXwKm"OE{vHjOgae$EJuʬizl"NtG?B4  ;Śgts΃귷]&98[BK>3eK7	?<3 񅧂|Q\ݯ2}n
kHc_]~wG_G1 	V_}<G-r}.ieagehX۬Wm_U PE PE PE PE PE ~x ad}G cٿx^^MS,:ƋhC>ag#F<eİ%O	 w} :>O(g?_=_Mǅt>±j/;#.
zSGu̷ߴ_cQIM? $~8 <iKj$?3^{+9{l}14^@t*  ^oㆁ+x_S5-SIiAMa{a)|r@7 )>)\~͟ ߵ+d_X\^|D?hTW?ٮ-,B]wL?i_!{fw+'W6y/NӼ3;i,!t-,M[uR^}		F~?k #67Nx{= ßz5׋ cëjP\ڤch$'k n wuڇm[z}ޭ5+f[{Ѯ!PQnDdB8ٵW%?P_(6o y\˟ xsׇ!9x7W.t^+NKRm9E'w]%~ .h!~zi?.t;h|7VR,*Moi<[\4[+&HoIt  _/cV5xڧӧ_4/>4hM5.{
L[*@~Q Z#	3|LPO/1iZM6x$GH#ui$O.kg<r^,H0'oSOwS៌t
;>ԾqmܤsCC4o:* u Wz ?  _&Wim P^mA|9P?~4 VfHK++Y )R9ṅ	hH d~W=rׄ|=xEVPYH-4R5PppE?VOC'O8>7Ko_x3pk~o-f^.fD"B;hm;Ljٮ?go(_ke\YܪCgSQtR]yd"I5'5-j3՝
ҋiWG? >7hmo?h6~9ޝ7tk[{kMM7v)9H9Cÿt_u
~?|z-{.uk9.oumyn%
х18JЭ	efݚ]$Տ xhm~Ox ã|VũxD?|7,\\]s^UmR ~Mb RWWj͠Q@ Q@ Q@ Q@ Q@ Q@y_'P?𷍼o
[ZǇ<5-\L.uKXKۻ<Fs3g21 = Li_	W |Vȵ
j=fY*-an$Xc[e?߲E; ~xb-j^ψ>%xY5{/uZNIjRIK~ux /?	m+ ^yeO*mI<߁~l5/u8]Ⱥzl._RMwQ b;OſgA~xYe:+j/|?j[xDHl~Ͽ>~˿߳ ?|)zj0ZIWyfy&ieY$Gv	^~&| <uyc樠#yC<\$cc<Bg:s^/>!;M==s\ԝ6pTET@O4pCm
I4K1G$"0ᗆ>*  t۟~~^;-B Sg~5Y|D._ZWVV؋i-d8dG??l[~͟?eO>@8/!on2NG\\O1P K? < ,|wwx_?ᇊ<{ii/mgMBɴͲjZDM+#m
 t~/xI_	/_F1i~jusuCWʹΧtAYC< ^{c  G  A$	 dm}@ Q@$ 4No+^j|9mᗇZWz>eankꚍ׌o/=M9u{Y!~_Q ƭ_NKoLuo
+[<GhhbZGim`tC\E$0h'\֖YI6KދW9#ggo^cb1x#᭧ ٺ
A]ͨ^<6-q7Y]k
ޥI֜ԕm$/  W`"/o[go
9s{og]x[[.&.>+0YL&[dW
O- e5 _^%w/jZεKOէHl/IL[aA$F?D+X0%]U Q@ Q@ Q@ Q@ Q@ Q@W >xS>3 ~?3jڴ:it9%$J̰Z[\]M)b	er~|) M㯇?Y|?fD'6B fkY
w;D ?5o
#O `o|1cMx>Q/Fsi:7#5m}7CW_D(gm
E)+@ᶬiak_$?ZLZlQ~>Q T?n?/D_uH΁;
ީ.
!gArca,wwpf.mJE2 Zf/O? ucӮu˗o7ʓfO_?Oo|u<x S_񮝣K5_|2$w3^53x*ivRI=텬ImY.пk G{  T/~x>KKlkO
tgH4.[|s
?|/  : ٿFx3Wo|G]⋻n9lfDSZ\m9/ ?/K?$m2/Ri#:{eŝL2$h8܏|>w/&]O  )n-k:,0w	\]v;pW࿊_V"6&wϏgԧ棠xgrKjXjәO}&܍\*R= )~֟go	m?eF|?ϭiJY
~;˙Zo,x*4s[l?lJ  dC ԏtI/E?+G4
( ? ~ͿQ*_dSS%Ծ?^hzqaO\äi]#׬tFyeP7vY-𗊼/
g-jV*V5hX$TfWWVRA#W4j5r?]k~NkQ_,n|^ cW~0j[ͨZ~,_QCz=;BtȓQ%!L Iexic _~~0~:u
zƜy!;ɧ֝aH0MkOd^I]7S%|Z[D诲9 ( ( ( ( ( ( o'࿅iCPOk>	.aUKg9cI9ݣgE0ʟϏ%co)Grd|U~~f65<+hܵɜۤ~XA,0JZ¿_?)
_CEj?|;rUm?m:ERTGzy#7eKm.ux_mG^<	5-{^dMKS X"a;	S~V/
}sPD.-ѮQnHOd Z/ٳ*
wß9i]:L/</
hwq'1<ItVVInh =_No ſ?|^coEƣꚏɈ"Oo65IO$LKoۏ⇎CP
w?[og#S7He[iך-[{+{-<%{CGſ᠛Vm[M>a4Y~~ܿgo'z~kO4ۻ\]X=vZw&r@ 
 n?%O(٠xgh_Kx3Pj]^E47iӵJhL~JkM|s9;_cƿo\>/ɬ[JͨG\Ku% {&  H>=촟YΉ~0M^^xQKUiQ9`IU@* /_=R?  #] KQO   Q6 + ||ӯ|{nM:ǋYD	-ז'mR-JX쥆HQ*}ճ:iХ:hE6蒻$2N+_?gύ߷g?
[gBѼ;i'n!kwvKecqdԮ6?;>"o@״Uj_6oeoO{jڴCuoc
#i<-j9Tԃ*i}W,NOktwGK,/"5w2uv[WgO C!S$xcm=_@W57 h_HMV;%&	&!WR'~%[>tk=S>2RWG? ֏6`ُOSJNfT]Ab#QEaufIo:7ZWM
t2:(?Y+nnEz$ Q@ Q@ Q@ Q@ Q@ Q@ Wk_9  ;>
~ ^"7<'ikҞ-hԭe._Qd~w7_5w<zýcúxPrIk{hm ~6 T~#>)?o|oxV?zcwᕺJ'T{qXnYّMC 9usSNAB_z -A 旮Ia	Z(d1۪ {xS3 <a?Vanuhmu+8n[IUfP7E4J]x 	ck [ GC ۻC/xKO/ټ}3_vݑ; q> d ɸ|H  V +)~OյcVI8!4y$U	C
-ߵGľ6>&~^?|Su_Rзo_tMEY~M+B;xm [R F^{c  G  A$	 dm}@WoS9ω:.qkƭy
cmMqssq3,pChI+*31 _ɗ?տǏ+G]{ėzKe{;Tmbm9ﯦi-]`H
]k1Qi9wvGRph8^ݥdW~k7Zk)SKԭbԬ獢	CG4RF̏VV*Ac mo_?~^6qjqUۨZ:mj:hۆI氒^Ɠ,+61&ӄT'Q)K-ʺZk/&'Tr7*IsYmk?P& C >xkKkxO>]RSLX&iIbYcx緞?"`t5(?~2Z>>QxƇ{
>3^mW{[IkH-طfds,=ݴz=4~N|ߴ U9tz<uLv7~|Ӡi7m(l̷1<3\su݃yZUhlD&W@ ( ( ( ( ( (  r j?i?_]~Rε59_4 -3P-.&{iVq#<?~A?,g|{gz> k ?n?A@|
k=-o6זZrGϣ_nXgg>"Eq=~ ?i Q*P$׏ G5~,5x~"|Sc+Y _ÖZJ7ٞ&ɉ
x|h }>~z/x{|[TҬ-UeKӬ.eK;KKfI?_~|)e[~oih,^I4%wv۹@? V_ SOпg<_666x{7Q[j77 56ήd>lp흞P? oßgOg[ ) @ß~3 
sF"Qn!\
$X ѵ|k~?akkPWuli!V6uy%yP	  V
~|f?	>wZ,n?g 5oU=:gT'd=])'!Oc?_ࠟ_ &o 5o@߀ |9xH<p[5'q4	/|4FA" R_	>__i/O:o.cO2Wwm$ +  R? $ L ??k (,/AS f\OIf5v
_N<Seh̎(.]K`e>OGmÚ':uZ,"|rI&:㚵=9[}<GW`+i{诂?3?	?`~̾( (4/ 	x@
CxcOHte[#+9\M 
7xi?k
=3x&5nbTy4]K?nms~ׂƪz_'TkoDɳ.l56z_Qzn2I7odP|q t sjx[Wٖmc-3X֭xG,4Kc}}TTV%ް/%vIMy[Ǟǎ|
m?ZN>CwcXƳ[\BʌH ׬m=({hi0
( 
( 
( 
( 
( 
( <]x'ώ|M	t[X5km,thkcGI]QQ   <#&اJ x?o폀 .1jOrP]T/'D DZ cѿk?x:?~/4MO;Z}7U55;K{COyd{Gh/|c?0>Ŧi{3RJn+=kuBD!i[x" [`V +A??h|-wo+^
jrAåwZuMv5;J:> . Rk7 c|3M~ּiڤ5/Fٵ	tkt6:3\Kv`f +E?߳ e?_U??aφf2mZ	Nִ[
R{W5[ؗR]6PX%MՀ?s!>/~~<g@ϏeɮMF;}GNI5Bo`֟;ւ{y/-.Yr! >?_]EC~?|e :מ~Z~ xH3GGMWRiZ4kj4%U<-?
xcΟ'EGlᴱlmXmUb8EUEEU  *z +J  dC ԏtI/E?+G4
( 4gU ' :>R
[Ǩt;X5nOq(,</9aoiaIX?n5S_{mqǈXS9Am
knM߰Q_|W?+/~7~xK
CNm+{+*o;{9+-$RpxU<]$?cjX	9wI;4 |C	 ׍j?ZqyfgԾ_^\Cq:]n^YI
酠"5cȿ" >&i_ŻkZÏ~	Յ0Gk;v]Rh	`/be+7Vy?.HWJ1K[I|7n۫qڟ u>gO;8nn-q%uPQ_ Q@ Q@ Q@ Q@ Q@ Q@|% m S MC sR	uy ~y<CxQnڦU7ٴ~,ʖ j:Q?؋ ͿgOI 4M::!$f\X͘eTxudP/Wc	KCᯍ?| oڔV 4qցRK?IekT:nG@^& L|7<xo\4i#].ش:t-|4}^hH-k(#B[ʓO%G@ d?Pg[ū_x/q닖a52X8Ag D h/?e ?hoS5ICgeDUD
$K+6ФO4CrI"# b9	't/~iC
B#|EO,{b"y(ukۙt)+d% ^O /_;~ >נx@NԼIT|.fH}Ɍ@>o k43<_T;U"h!.Hf)zD0 k RO?	!{@ed
xO5Ҭ-7{]Kw&6
 ^{c  G j '~߳~|n >NuoiZMĖ6IlFJE$#A [  ?#A [  ?#A [  ?k:[eG>!7}m+	𭭗8?
hpG&kD
ExYk&[+'g_?Nc 
ye_N5dܯdW^w?0ϸ+7ͳlFaJ%dӲ?+'g_?Nc WN" /+ Q_K   y3 G  +	 DWO Ɵ'|1 ?|~  C  " v ?y\G9	Owϋ |?|^"G->ɕ'ε^)vKR;^4agRNM4>M*)ƭ,M(-4&4;t|d_/^6?\l4[\^fxk+m[8Ȟ+dVf/F   	oC_S>.{+k}){WJ%;.n[{kfm_k?4%KxC ?4%KxC @  @~?-hh  @~?-hh   @~?-hh  @~?-hh   @~?-hh  @~?-hh   @~?-hh  @~?-hh   @~?-hh  @~?-hh   @~?-hh  @~?-hh   @~?-hh  @~?-hh   @~?-hh  @~?-hh   @~?-hh  @~?-hh   @~?-hh  @~?-hh   @~?-hh  @~?-hh   @~?-hkۓ p~?G;xO|@cZ-rȐH1Tc {  ߰	(~VuoB
kv^ghnuKՒ :E
*ğ= !k	_un|9CxwTc}wv0[uo%MF;z/ܘ4+`  - ~ [  - ~ [ gտ?eڟƿ?	Dt<=\$z~y$h[WF{+I/R_'ti"~ h?K ? 44 h?K ? 44h?K ? 44e < >
 D+|i?x'_񾯣~
 wj7:=杤-iãA4n]ﴖKx'Z ei<aJվ񵮞Z?
|=L.e,|_}}Foom"ZH\	R(LFG=& ž??A F_~XOh
m~tmĳO/|5  
WC1&'x2=cڅinEǋ|QKu4FQ2* /S%?ů?v'7ߧV-ÿXjx^͎o6_hZv9y  @~?-hh   @~?-hk  ?૿ 'v_tZMVH3	RCU$Y?        , solitaire.JPG  	@       H A  [ JFIF  H H              	
       	
   } !1AQa"q2#BR$3br	
%&'()*456789:CDEFGHIJSTUVWXYZcdefghijstuvwxyz  w !1AQaq"2B	#3Rbr
$4%&'()*56789:CDEFGHIJSTUVWXYZcdefghijstuvwxyz !    ? dO?_ >.|\wktm'X_QvYYoeekoPAx$K  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = |]~"OZ|n=jߴŽrU}'Qӵm~+۫y"	pG |%  p eOWݴbz:w c `\]ӵ\o'P_^hvZ4WVڕm-[-Zп_O['췠|L^%rߪ2SG2J1N-īq3  [ 3      [ 3      [ 3      [ 3      [ 3      [ 3      [ 3      [ 3      [ 3      [ 3      [ 3      [ 3      [ 3      [ 3      [ 3      [ 3      [ 3      [ 3      [ 3      [ 3      [ 3      [ 3      [ 3      [ 3      [ 3      [ 3      [ 3      [ 3      [ 3      [ 3     ,6_oڢxCI.<!$W/f E{GE%,rYn|
)x'ⷄdۻVK-_ᶯ-4?rqijsM{k66W:}EՕCE}E PE PE PE PE P_S_7 _ e}@	2>$~ SU@W>[ÏjO_^/Ҿ5c~]xQүѕ4OM𭇉u[hҭbⴜ d-G+ {E%վ1jW>Ԭem[kKkOMkvQZJ-Rj <f>7|E֡ß#5Fo|?nK[]Tֵ9a<_𐶱chũ@> < 	ct 
]ß
t+j:hz3S'"xtZ+ k_[هtwJ|C x_T16+ogƋPOiak,(|Aoi	`5	O ~{~? g ~:|#~?
 lx3Aiڤ)iz^kꚝ_i'iiܾT"?἗_?m۷ϲ\xx<.uM6[Ӻ.K^O ?-/@ rg> j ٳߵ9	c;
X)5Ɩ7v0A4y-u7TuXIխ'R_۷L|=_ck?h3H [~؟W쟣}ǅk"OGտ,S
?}KxG$ >Q?*g]+:?S
? 	߄?a}FƗchRxPzڄMcg>CoWdf(
#>
y]O)<gM"VC-5xl5yjVӡKq#H ~i K?f7_ b_ٚv/xFѵg}K O¿w_~Q
j.|3q5)_u8lᲒhnDҀ|u,|okϊiU~Қ 5 ~ %hvuK=LJKho|AmeRmZ~9-?,?IC7gwN>_\t^QVUHt{&!mHE$Т΍(_\+߲oG6~&x
/+᡾ 'ƛI"+%7f$پԗ_jW' m z;5g|3ÿi:^5NjOZ[OG$gp)6  jخ\c?h5oCѮx{;vLcS)b扄 - W)|@Ѽ &؏υW>җKƫEjֳkv_e.mZ
Be2 ~ _۷L|=_G;
E%?i7?|!d5xL uYws-CkY_vTI>~'{ߵǇ f> [\-5(f־#&lɧ]Tg҅5Q.oC |b` Y~9,?<Khk>	T[kk(>z:o}˸i.i?//ۇxzڇ>|$_IMގN[.Ne`+Ia{f-RA$^4 Hs$A] dk- M.|> OɩkG#Jbn3dyAOH՟d;?{/__
xC_[R𖓭xėAwyi~B"r##p% H j۪;@!h$F+n[[MF!K)#qaq- f?5 kOп n9Sj>Se~<G7'62\kz8M9n4t}:Y5H%uI~3  JfRC>;
7x><}į=/xQ֕6WO:EE6,d` 4?j(ƻ?EgOZcwjiz%uGn KXKkx31l  o:6xV-}F>!(.mi
:u}Tĺϥ.^E 'oSOwS៌t
;>ԾqmܤsCC4o:* u Q@ Q@ Q@ Q@ Q@	M> ~ Sm |%  p eOQg $k>% job WSߴ b s#A7 hO<[^|[sO)Wٳ^)E5|%oq~ T$X}2
S[tocv{YQ??oⷂ>P<῍~%#ci˗s:\y1oyѮYHV~Ŀǀ4+xHT5e4-$L0M5A-C#H [ ?7k_xxŞ"o9c&[hN#C_L}H&Dr^X 9 i/~  jߋ F_|9/֗dv֐k:aȗs57hؿlf~|M>]54[+JD=:9;Ryfv1{'V V=DvПὮn/vBF֮SM= y~FpU|] <;OG';^լ?jۏCt }x(Kg-LEu2Anu?_Uo'ooL5_uO_766k3h:1}mOOKi-JMhc > B d߶o_? i fT?RⴸwMe+&ɟ1U?`/Co/HMa|3m-lH?+.o>+KWtRl!;XP>o gS<I /ؿU 
?cmŷT}ǳVwKx,ў{w<) 񇆼7xItu?CO=聾#TXS_[>m5l5smŦM+X\%wH=o*_` g&Goj \CiO e_Dze%o.{v{R+6Na*|?iZk/~|Q+x³xf/au
rT.2e{{Iʴ?|e ~ȟ|
w}cCU>7vxDy26ӽOs5ڊM$Iu[ok>4L<!KEfJ>h8a&(S{J2 g ~_ ؃>)>	VoĆ(|iciz.b8o#Xgh(YE~jQO8/~xNŦ1O~ EokmBJ/i5-Lna91L''#MC?/x6Mֱ卵q3Iqa,Hh،:o*ek?e]➟x{5okƷ[XM\%aѥQgKq
Ȑr٠V[Z43<x_YtGȚKyGl:2>? g_~	A;U?.~мE=yMƥok͕@g \e
  G ~"Xh/ -ewn| ߲޵[~ |[ υ |%u}#K_xM4M3@K6z̭j`Vt"A`/~ CfIu?	xwY  c,<XK'P8P?'>qC//៌~ ^Q2 g]tfXg]#b }K[~?|sm?ENjƱ^CicF\\L<J쪊@r~^e|+:,|9c
ԣ,nX `HC?ڷ[>+<1/[+G:E4=>uKONY/loQ[c!~  @ `_~o]ž?C=N7I)<E'\8  K	% ( ey _v._O>&_}ƭk6:Mm5̱Q$ʨ M|3 
'c/|_#׼'/sgyj84],#;G ? hD(uG6 H n  ?  G"_ K~ w 7TaQ l?#/ 
?Q 
D%?G;  ? hD(uG6 H n  ?  G"_ K~ w 7TaQ :޿'_>|n|Uյ}DuZEK
+N5x[[D
3J/DФq[@	M> ~ Sm |%  p eOQg $k>%Y?&?ǿ 㟃~/' RǞoi[K;xa"KvFH~hw~[joyM gh'16iO.Z~c}I,u/+̊䰙(i3%%T_-/{ ~>(| 4?	U 4 ZWfm4[&7aXəOR|U ~	
x"_u}?\?\iyYivڟm"˖6h
9 CO<៉nn/_S7MybJZl:]Fi#O= ٧7o
BxĚM&o'Xkzi#H;ℂ|P{T{`C/G(goj} |1Wt{ZYty.^!Y'F)(b
%h$/O"{ j<uWWEK,Oem&a3E~='3o||.ږ[+d֖
;I0Z%͜p3yBO)S&>$K?_|!? |%ZkM;X4ut۽7MtdGg/  gƟhA}{˝.
T!%{S+@f??/'?k~4@>&x;+^\s hk-ݽͶؕ\
0CR G?   	/OD \ ->(߈, 9I~s? Rho?O&[hZ)Z*Q\ O߇~, >9I?c R3kWڗA&
[VY̈́,O+o)w;M7n 뺖cEcӵ i.@s> c~ I~߈WuZMq
u6im+ng}{:~;0 ~ m߀<{ _?!o}t{[G!h.k`V > {i?{~L5#,}GŞ# gj:u֝qq4 bQk|QgOЏro/ZR_aH???>ӷs?fٿ{io~?"_OG' ZL/	w<Qw
h)G}^'8a&Zi:naoYx[  i n<
g^	!G5fԣ$LHF+dy5tIVE/pҏ%G_K7{|iq3/|uԴ^_i~ߚan&<l2N6%T /~ԑx⦡x L Kp/Hux4hbh-USNmkx,8HaoYX@?=5pß.> 
^ë %⥯ĹM
 f)-.|ϳ4} R$I/ +~៊𵯆N|;cz֛yͼ\1[[+
OSNg Uoؿ/P-
g	(Y5ͥϨ[ͦyK"]$#0mk{|(! /|)<=ڟ,s5'8/buyΪDSYSj ?Oa?;[Q_bԹy'ڿ韟 -+
 /}s?	|[VS;VGlc
<#qj񶻡YxGhoo%?kH@c ~Ԛ	Ə k_o<E>hz-MV{B1R4{b# &)|aڃπ5G?=ީxM_WڬcHlnİ2^M[rɐZ(/$	 dm}@
?6 4zf? PEoþ߈vYVEgiX)q [LT~_GuhO|C[i^{{m-5=e3cCwy N	|m ? ao
S_gǯ^u-TƧi{w3k0]{,i H&u s. ͞Ajmgk:cּ}l%։L"	: 7:~ǟWཏOwVj^'ӼE?Y0Ru:Bdu;9I hX&i?5???$@Uy/K\oj0
^ՍC|VGߊǀ<7Ŀc w t?\rvbgK>9-o2X5)|nϾ?}-;/ qׂ/0K}5[ayͦ U/e/2~> ~;JSޅx{MmA_Q5G2ʹŻYZ}_yOx&Z}M7v:k5͵,I̮
 |s)wǞ+ǁ
 #xZ-G~+xZVaiet8YUA$
={1Gi i-5W^mkqiZI8/u`k;R[GTn~~sDr|w&kxĺncs}$r̖_o3G+紿ڷ[ּ{~Lxgt[xHT~43EV9Pxmnf[H-pcb <sR'Wx
GE񶋨\i:Ə|V}m#Cqmso5J:##+ A&@Ə _Vy]6V(,6c.aUc,q2i9'OBw<-
x9Οx'Z4cGլựլnchn-mVxe9"ueuvV+_྇~_~>ӳ@>EsxT5xK@G5ƍq鷺uuy1H4-4[( =
k &Zh/&Oď/jxʏ?N;	% eX Y.<s
 *~ԿOo/웧N PMڷE𝏆ayyws1/xRE<,q,|{ c 	cĺu xs׊	>Vv>MaeΫhl[s x  N T?w]voŷ^u	޽Y_<YgqpV[t># y<uoٲ . bK{.wxLOYOFya{Kq$= r?_7So
4~??g|]/~<NF]_ C{ww:\VQJC5ܨ_> 
 O/߱W |
 &躄Va\&pEjڶmRҴnE PE PE PE PE PE PE P_I/E?+G4?_6~#/t 	'Ox;Wc
rkY$IbKya5x\O'࿅iCPOk>	.aUKg9cI9ݣgE0ʟCR o @?j$|\ڥ?ោ
͵ޕi$Zd/M
2_=Ο)nbo !G㵾yjZl1|nK}J9spXM{<[go7b'1oz7EjֻXº>å_ɦjw2[#I
E{+V  7b "?]~-N[wOWZtw]l$wo?"I &=Ѽ&~w:^k"eM9CܫG71	&efd ?ിEړ
[ ^'WW\%i^1uӮQlXRDw2!c&eW~0{|{uk~OjzZx[D?A͇rck=GMWȆkd jM;//xk]_PwҾ 	-Μ57γ
yfq
7Og/  gƟhA}{˝.
T!%{S+@f [7o- ?1G  /7 cyb G<7ퟻ|
# ??	#NOUg$߉am|<|G_kӛÓ-jBg-*\Cpcɟoş~L>?i>v}U /1qm'RKY$[kkbR&6  mߌMύڗ
 d7[z H<3qDMt,t++'r%
Z$Ri.$`fǤwek5ufς92v%2	Vǡ~Οo {x'Jj Q7(&gxM	C;][ek c:EȚE /*J_7o_c/\-տt{y,!7Wth$d )/jx2?n?|v թ*?l 8$c Ugĺ 7/ǯ~/  z~muD 7t{>9'/QпlO|h
CGֆچZ躭z]ewhh _L]!chxO.q-Ko,}V]}3Bկ%F[K{&-/	>WV4xTξ!uIZ \/q fԮ.Xbuh   	ӼMjLe/mT[<Vg#ݛG(wR뿶'~ _
kGT]CSV֭muVHᴽ7S m"-aTO4t=߳oÿ' [c⿎uo iO7$[7jX_yW᷇~AwMK_4;(f]RO:i'?TO:O.0&DP ( ( ( ( ( ( K	% ( ey GM?<@ fڇtCͪ__Z0mk:$>l	~Y/7_@yOؿ>?b ukpʹW˲McQњ[
$z5:\Y~h χe[kl<_+/#خ#O]}5h-, %}o"{QT_;_/flu T^?v4֩]?ᆑ75MgGul䲂Fӯl' j 
P?eMx᧎-t
ZcaaƭiZ/n.!I;xcgT 8 g ?jO f~!xA]\i>4ڽiyao$Π  q 0?יͯ^mύwz<%iնqvey5;_Vx!]KE"_> l.x[ <56 5v_x'RTռKebgt%&
(QcFfh` k,Ư'?'N{||A
d!:	Ñͬ^+uNȎ5	7 xaWX?fύ5c_/<K]i/|/~=PF	t˻;>r$7f["	m,!.t\yhy춷ͧI}hTW0_E P_	[ S_ ? Ԩ   ɸ|7 ' V+ K	 &#oZ2  I~?V|Kh ( ( ( ( ( ( ( (_&WiM> ~ S'C_'@|<SwZ{i懩#o!,dhHh&)9#G_&/_û_[|^n.|MR$SO:U&krāRWaգ$@ i_ك_g- l^E+T湦'SL K_.Y.cDoU p nN?oZk'Kkx0xR<Qm='<Mk;ZGw}:]A
3+kn }Ibgඏ{wic&u}KUӠ+FeEE\FWL_E~7~Ξoox-S:Z4Լu9U.&8Fm~EZkߋmu+x
.\4شoSBh{Y
^]!-;̂@x_	?/5xsWپ
|?/$!Z_j_}Kֹs^{gZ"= ?lGMmOE[u
NoISaҵ[+mAGZަwh#?Ϳo gĞ?9~?>/lySY|-' _t-ŗcųY\Ai>9'Ovo$W	~|)e[~oih,^I4%wv۹@:( 
K
 (   @M?<_v_L7_;PoSwzռZa#W/SOѬ<[w;+#ۀ}E PE PE PE PE PE PE PE P^+X|q l>5s$ {Kk|#BG3NKM6(Yn/`(e6 ?d_5 S 
'ؾ[i j7/߳W&w7?_)~#P: 6kЧ7z|OxWSk
Xx{ If6y( 
( 
( 
( 
K
 o'M'hOA<uuo"^;(oI%-i!p
k &Zh/&Oď/jxʾw<-
x9Οx'Z4cGլựլnchn-mVxe9"ueuvV(ǽG	d!X_n-&MoF Bq^çii(nc:6m@ Q@ Q@ Q@ Q@ Q@ Q@ Q@T~&hg?^"Fgizw4vwo0M)%Df |x:~ߟ
|n<Hqچ?vH>2xtwTѯ{3FݵM&i{ugeb4k	o?K > Ծߍ;~?Ht;m&íjh	58|AEk6m-ZKKIHmT( 
( 
( 
(  w-?
x>96'E5mcXկ!lmi.nn&ebI%vUEFf k_ྐྵ~޿~1K@>"Emx_TTŠ^I
վoWVkug	W5[=
k &Zh/&Oď/jxʾ cO7 : =y<kC<5ƓOLtM+Go
   |~ Į =GJ?  |~ Į =GJ?  |~ Į =GJ?  |~ Į =GJ?  |~ Į =GJ?  |~ Į =GJ?  |~ Į =GJ?  |~ Į =GJ?  |~ Į =GJ?  |~ Į =x>hwt7o_⯂?moGOxJ׾Co]V;iVԣY`Xح܊Ł  ~W]:-߈>?|!7aSO־ZXu7umE#gt_Jw@ög)+8 OG;kw   4 ög)+8 OG;kw   4 ög)+8 OG;kw   4 ög)+8 OG;kw   4?
 aG7t:7ߍzO?:vC$Yx7{.Ai> <)x:~kOuVVZ97xՕXH4~O$IC>,'~a+Di"BK<q<RGmhT-/,;?? 	~wS?h;OO
|5&>k_9Xe)'¿^6-o-3<x^>D[]x"HfX_cDp@ /c# 	ρ yDZ>?9; Z ??hKG'>G1 Ih ah  <?- -ǟG% |~ sw 0~N| c# 	ρ yDZ>?9; Z ??hKG'>G1 Ih ahrc?x ]'P֬5~ mRNխ$WtڥMN#H`)gY͠িn
 |	 թ> d ɸ|H  V ( ( ( ( ( +/ڷ)o	u,|⿅G/׶>[45of
: fI*qsv_gP߷}G 	֏<ߛZןh (?j_GJ<(0?ixIOu=>ַ:tqx]oF>g3O
,l. U~ _¿	~L4j&P ^_[M
{g~Uo3ppRPW^mZ.B6璺h7kJǹdU]R{{ߕwIZ;.xS~9 l|nӼm.o&:FSq
(Gp"Cb{mv]^?߲x0g
º򷗿O𞹫k7d\#}(_*hO֫
0ri+ӫvM$m"¹!)ӲRm$}Џ?mo?'C{:煮VCi2<7b4XHæ/_k	ƤTӋWMj{4N-Jx@h  o x_o] - \ikxT[Zx Vm7JKdh^(K`Z_|c|db?OO?BW +|-
x#Q[Ai-f_5IvWXG>,P;y7?h ?7u   Ğ)<C⃥ jj5G_ԧivVIS)G E PE PE PE |% 5 po eOOWݴ'MG<e_vE PE PE PE PE P_?Ww	]?Sվ6jsiV>+堚Biߵ72~W_P 7$qxy U֣\H^MRdO6`h +
 ?bxc_|IҴwuԵBٴ?FH#qwy5յn
aRWӻ{%u6QWKE|Y-Ư'ǿ"BxǱ,ߋ5Knt?ľ.ӭ@ -nҴ8]e_3!~'1Ak8J:Z)՜TVEF:ng97^SR
F_6ܥ'$+T׊~!|9[PBQ
}zl4wV3swoq]qi<W6	{p7[Ot "|{/QMH^ ؚ fkIbԬ]OW.$^sV~]kE1J%P*y[_꛿Hz_Tq o㿌kd}/&{߰i?kkT<çZ^}$
? OL[\:y}ͅ_Xj-j jOmZɵ=WF&ۏ>W|7ogOO8i.n/.K۫['IF( 
( 
( 
( >  ɸ|7 ' V+ K	 &#oZ2h 
( 
( 
( 
( 
oߴOٻh^nmuMnoY;bhAba1 +  a= ڿ**x" ) Ƣ)rNͧg{5}n~x 4Wo|;Gm>Ǩi
nm`K|*4K7)fi|=sCyrm`WӵĴFOw4M a |	/dk:ھE+gǿfb/s߶6՞M>'<I6PWKkȒ5kqc6ckYQՑ~ + m>tC\	kX[̶];BB&{Yj-ܯŝx[d?K1X!⚿SOIj7':ܲzHn` P>"~3jCĺυIj随<;6q+WQ-{sIԞ-aXmω|6hoe-{Ow&[:$Oӵ(y~n`~*a8O,X{)ZTI9;IQ.Em#7exk*mpoWzE~\}@WL8eѿ:]ƕjAoŉYG]U?x@g}!)5WSM_՝>4j~kN_SӷcCrZ^xɳB ( ( ( (িn
 |	 թ> d ɸ|H  V ( ( ( ( +??gߊO1i%島5Ҽ57Gow^o)
̰V*Vboa۲)?
{ j|- |: GGƋ/r\n(M.."?fm; J?j[oW<eO|u'o'Kv>ֵ
Vk=GYdk4
%.!nIRHI¦Ww{oIJR?Vko%{7 itZ>
hS?7zO;Hak
k#H{'x6HS>Uq0_}8ZV| xs_fgc'LIDb,o/uB<G;L/9τei,jz|lelC'-m[o_>+xv58
( 
3?ʿO-k]fO)tIowaIwujMKc>t9t(\/`V.5R#KW+_$iE-O{ph;Žٿ+-z,~ 0Uo#_ 'g/^۝??
y䥞ҼKk"{z}Iw^ DX5ďٻȿ?3|Aj
GΩ`^ZfdmzFK-$,,>3	ۡWݲѭ"jo㎍)7QJ(֡;TxJ*Mi
|KS_!)toILHHH9a{qCTİxYE5n?s%xdGyiw.hnu5_&I'O_O02S;i{ӖRokZ,ބryh*qV=tl;ZѼK#kx{P9mA$SC,d2XH5;࠿u)MW
JcEuJmPVghz@1a&"0{xj(v^Gz<.l%2ܾGER Q@ Q@ Q@ Q@	M> ~ Sm |%  p eOWݴ Q@ Q@ Q@ Q@'Yxz?</
lSB˻]}ݯޡ;yS(i?oߏچ	7/i
OE#:#~W.[nL<)QZ.9?Wg U B;ɏگ4xYs72'z=#Z][Euqmkcbjs[ez-WmN1VH+C 	{ R// 
|; 
5N~ǧi?⏃_g,PH_4'bɴ> 
Ԧޒ_̫/u3?xS<
ׂu>I4}ZZ6ehX'VWWe`A"5 f?J=i쟲h/K,ǁueC0tc]VO{u;:(G6oPPuGzew':}wvz~%su}Jd-
xc>6x'ZmXo!լncYm!fxeHFeuue$hz( ʟ_Wj ?axZO~+Z
nYeXu>.ey9&A	ьYLM<%'V7bjT柲GK]xoC|W/vz?|yuhm=cFhn\\i^iI3Y
xs-:5fiYVvѬP[;xQ#Ec[pB j֝iK[%/z}}*F]w켴I+$~ kxsğa<_nk u岋T]G֑ygjvw&[,O
~ς㷺oՠqmJk.ΡfwbK%ก6Hi[-Ӟ*aNqS唡'Q-]|fb8.t˦mw7_Ͼ"+xot#:K.h'Ե{:̲1ՓRD94Q@CA}kr|tfmWYe]^"U|5O-H"lC[
(U0c<lTW:ҥ;_N}V};2?rEE8xK?q
( 
( 
( 
( >  ɸ|7 ' V+ K	 &#oZ2h 
( 
( 
( _S7O
w/ៃ
G>"Ծqs]O$Mm«1 |_ ~E5_6վ [_[񮫝W7:&kjRUHLQ~CjғlJ WÏJ d_j_í}_C 	s R/#~uZ%.n-n-n-㹰[ib	b(_NCßO+ǿ 
մ>};Fb۴ݗZMQ{[hcog'/ JY 
@{Z'HRNՒ[Cc^iw>tXKvE?37cs~r/5?xKUn	Rgm+v:njJ	
\+h j΋O u+[حKa_ƞX[~;hmmhseVT9<v^ܯ8]ywۯMCx5(4?]7K hkV/ 	|>~
wzO|?΃⑩R M(o6K""$Qxs஗ >_4]x3cKW~x_YTPBsVU+Bwmv=ci:t=%;Z;]۵)  |j? ><|Ǐ<0A_jP<?vQNv7WȆ CI{>Uо57~#hAu%ݕM&}/Wu+u;P?D>uำ%ݶ([_>R.9%5Wu>  $|3 >㴿[o3O5> 
& :6$eGmibkr'1|5g_o[f~Gzڞ_^Ϩj:ܼuy}uuy1U1%ìQEH%	Z-4'Q{mh..SȰ8YSu%->䕺w
( 
( 
( 
(/)/jx2?n?|v թ*
( 
( 
( 
 o/ ?okA|TO	G
zduoK$D6\:}:id<+О"bz/1IW'xQ@~~T~ןSk^|.Ӯ1+þ%ķ_heiKy+{hڗ oCc?*:@ C~ w''( Sڟ~m;'ڊ]y [Z++߱7~xS|sqk)OZ4mƗ4f8fKm.kW4??Ē@?55 \ ¾l>?/M?
|6/+kؓHӼ<ƌw-տ4
4aZ6/ൿMoj^!?SOEB{㽴 |C᩵;Qy#[XH2px\JA$P? ?OeFg?㏉OH$Ѵnt
Vi{,?[I}mg
đXF+)`ߗ>"  p/߁u-'J5K7" kE/}
x}Co^j62MύeЩtۭ?֋~ڛ_+~?_:gC~7
'Z.>/t5NfciIu|-V	 9hO?|oJ5eoTмGjGR YtBդ-,';Q"$VCSkJKtyZWQmm?/sa䋼ZsZڻ;蕗Wwe?߄?k/?gO!!h=L75k\xƞUftmȨ.WGKvWש<'iµF*^֟=E{ Q@ Q@ Q@ Q@	M> ~ Sm |%  p eOWݴ Q@ Q@ Q@y_'@|C-w{jz湩;liexi(bI$D`OAj~xú<]3k\[kTzagBњ4K&_0wv%\[k}|ȴ	d߂>Ϟ<#okZ_xV8uke<Hj=:?ǯ>tSW{E|Q@~~ƿqVO/zO߆/ >
|-
c
OX}s'Qs/|B:hӼ dgI<-/η~_E PE ~B~?UwOڒ+ =k~+ƕv7{K;;Mb#Ih4bO |z `~sOx>|_xj<W^+_>Kk֛jG"^Ly֥B69_N(|ҴR[gf]*Wm.ng}.ADwX xĿKֵ{2tkko:ZϤKkĽ+o/ @\-Ė_/v vm 6 {|e *OTSZZYh}.ӝ?iN:vWKMwu?׿" q2Cƚ>%xڞG{)<#iڝƟbV-Z'T/
ӟA/m|a->e6?=;YR;]	u&Kuncgi-Liq)2=*uI7̸8`<E
I/gfڼo;=xC|kKnϏ-:kSH΁bT$h߱7	?~ӿ\uįWBvn4EۭYc$A~2Y\lwoSKJ0Lԫbk9CfJϭ}v?<<soiׂu>V&Z5hX$TfWWVRA( ( ( (িn
 |	 թ> d ɸ|H  V ( ( (,f_~:x j~՟<}ᇅuo@WtuEզm@<gJeػsIF_i/IS֊
( 
 ଟ^U
+j_í}kaON?n(Ō? >OO7Y?`& | 9/lɻ0bS*PE ?c?O.
խռYIxuy$kpI<ʍ+"e%e?M-π~u-氿h/
;@ڼ%̐FwѬo'G<4X|1caqMڶpn_j5ާݰ
wy; J@ *GqƟVe0қNriz-_kkF^O/{D<C⏅o7uoG,|iKXn﵍.X.=}-md^Gk:Ŕ	s@3' 	h> +$K[MoMPdDKKo%-UW*q9e$_:Z˶pV*?2r4O8?SE<KaO#wR#oӭkSl ԤXK
XL~ɿ|3⸸ӼU^:ѿCa귺՜s:[Ed;~srލ zu%ǘwO2u;o$}^C4_Ieu[{4ymgIQ.-{{! <SE$NQt`Hqm5f!wǝO&~>( { 7-V?zlq
upȸxot1h݉euՏ%IEtgX^OYE7m
( 
( 
( >  ɸ|7 ' V+ K	 &#oZ2h 
( 
( 
" - "P> ->RuW wI|4 {o9/mb#mRZoO^v>뢿1;B (?c_8+'' UoJڗ oC# f 	_F}S|S~$k}al/Mg1A8w^D/^N)_ mk>
( 
m~9׿hׇtmͤ zo>&Լimorap`uz^gO嘙^_~>߶w?v^ 4g^9c2Y^j:gXJh͔6`$܍
}?Y|sЬ~!Zj7:ÝvK$yZk(g!LMA#DgYwW`(+dԵY=mnu.qJm]k^KkVGCeB>0~~~{o xF<^N5=^m荮[4k߷ Y[ş	< ~Tg<IKk.YK-:mquA"y$iԍL^qu_ڔ#8ٵKm?z3slZRjMY7鴷n׋WJIgso BP |߿ ;/3xG_|N6_x}Ǖ_ZKzMmy߅ ݷq[\h^5..=gï/<ayp-VioʶwNR&Y$iwFU?ٵz>'1i)]tn6ҍt]~8xk/?*x?zW~{[x_|k;[kk;KlHg/P0b/3xvMY]m/z$[ݵ[Jꖶ*;Yܨx a`H5BkHk}߉x-K$v-}bꖧOj?৿f/|,һ,Mօs&V^3K] LE)aǫ+WoɹeTErQ@ Q@ Q@M?<_v_L7_;}@ Q@ Q@ WS ߈>k_>{Mf?=nQs!qA'k$q[別TZՆgtWxQ@ Wk ' d  i[Ro z'/?f_|1%xi}-O!Ҽ+i ٵ/K.v%ʟV$__
~|_e3vx[úon.>;K8<뗒ia<]ݶff$:Iak)[ I)߼Q_T`PE Yw @m?kڞEi·f7xbm(nfU׌W!_31%ׂّWd 8&W(Wߥo߳E~зZE6|swui_:Oȩ%[̾l|xO=Bn;ei=~#tMv^Ki-ѯVhKn[[^vԇ/5oӦc0Xh*v唛V[_ Z=sx	)x_OGR]>*ym4^7ZܚkqxVOkAOngu_ 3]{5|/7V{OGK|FlAntaMkĶ;m7qَ2*YvgbR~_eH;7Sj-^iV{W4jUڿ|ͫ׺h _K&~w>$'uvǋf|en5QeԦ%v&$w-WM-nF2+AYշuy>/
|C>ݧZj6Ō]\]$x-'C%D}靮x>84mw1۳x%VwF<5<4Pn[K|U6;wꖮ/<Kx ^&3A<S:ߕif,,nbI%rHʍW_Y)$aM1>( ( ( K
k &Zh/&Oď/jxʾ ( ( (oR bx_Iտo4ψ
<7a5A=?ŗOaҬwY\]\I[*dkT}`$Ϳ :.яC4o'>o?l~kϏRXA+=Zzjc%mOF B?kz[x߳GV-u}Xą
2)o#eKyuX[^^Zw2 I_ ap8|)ӜMP䵺ߚVIW?GL>7 s; {\7̖[úTdiTR7
P7ǿJ WHSE+|Ie?a ď ¯_VrP|]i_VJSKqw⸣[Odi--G'"~_Oǿ/R> Gđx_>)<={k7uJ;_
W鮤`Ԯw{^_K2櫨u%xB)ukc	O<bҾ5|1Q'vۯxcAQ3Z
2Ů/uu_N^zܳ/[Xh˙ݶkK-e9sEz Q@mDh?|t|s~	
gŮ2\VS\GlIo3Gjƥu >or? gO|>#x3x3H-
^YmH''
Fb+0sI7|*hܒ;%wq_?f _	-aG6=%NzTs3!/ȶkYeky?@ߵQ ug}e
۰~&<+-Ah?FI=kuw<|Q9^m&vѭoe} Cz jc<"\/G^|(-,N<%_Es$sEj"E/_^? nO~)'OxgH4KO.۟
|>RNTL\J㺖$3y6χٝ<"7I7蕏LK*jU0{ϗIJњoKjxsV!O-;Kn1iIZXt]K!YgoUt SD$խ+^^WUg<5x Y}7&$OASڽYa/xȪWY)gͯ1>( ( ( K
k &Zh/&Oď/jxʾ ( ( ( +k+W  k>4Wqм?/u?&GxN׵?Cg>~"3MҴ]! a%LRK_}l=IZWxWxgZ7WO_OWtdƯwam	Z1Bi	m:ȡ]g߀||E<+ aXXmCoi/Sbqxm-n:ՙ"eQ0aɉC=\ߣ׽^gO4;?/  nRMs(<M*}gẔ<>57(m-m,-t<Hh~<𖑯*|!ODu?	aaK5mJT'Imn!eد|K-Ւֲ҄GQ^E ~`:_gŞ{|8]5 %A١K[j1uo'! fu
>	|U_GU{M6
xLӣ0i^*'-/4UkHf|c?,֏离uǠR"[yzy_}~8?i/+?IB=W_Ư6ཌVqu|O#P7*N-`C\?j O= eׁfOMn5
2 Ƴx;ږf5+v7B(c[C"i9HvY5gm5{OL8t2LO2[[liۻgi7-Jirc,>]b
sMZjKwiA-B`5+ʬcr?+8|axVmw0?NKx5Y x帖'ܿ6˘8xQW[m]˪N{&,\Ue$mKI^i5Of!cz$lU,ּA
jUsc8M.	J46ݏ럇 f~Оxt\^u>+Uo2I
oBMH&]?8C/ʱq	{ed{-yRA8r*QI+^M%-V~W|A:Kŧcx`CxF[O-
X]M
͔ѦmHhok__	XG$/]G%A&[1/$nfӡ%HVK jYKuRmJSޯ[׻Wn?HljiҔa
iN;-svh{ϭ|$ֵx_zFYY,.VmBo@/\[z?4u OݶOiuOW]ZFK(#e3đe"A~$~^F y̺%mYY%yh8??
h)W]W]\d3O\^;GΝu+zFy%y%ͿC^>.\ߖ<=GtMv__Q\ǶPE PE PE |% 5 po eOOWݴ'MG<e_vE PE PE P|n~~sDr|w&kxĺncs}$r̖_o3G+GWR|Wxo7<]*Pt?
w'.ko(x~bxg8dElkhaiǻ컽4KWi9;$|I~ I]SLax>1~C?m6:m5Mw&O$ q ?5wm@MoھyZXExOEKe+E;y~D1,\fx<jI&գoZZ>W:iBP 

 G w
+Z*?;KVǆ
23HuޣMoom IU*+z(Gsugg~=޻
 A.x'@|xcFY>ypk~o1ѧ:\<da#K}:]WxMbOF26l[Imkq}<SKoVQ
<X	*zS=JXCF /:OxO~</#g^EIK及x`AvVG30R>D׫'#|ޏi>){&j-oOھ;oHQ{3ɒ5?%j6=.zd}ttSg7?f 
~x)?|)F>~{
[X }¶SZ	Mيk&xRIJI]g$ '~g/_ cd Ykovֻ7u|Q[o%Z)//&v(hc?z(~ _'ºh>;+_f|?A? ]iky0js%iYFՍJjΣTݵSӲK>N㦶ۿ[-^[lw?aϋn h 8O]Zg|Ux?òבY}]tv׺YAtd˧C4WWw<7;.{/h;U<{%ׇ&B-o4$6n:I%&>J
apsU{{>jA/xKWc]tFp.!oX}	z)~hx./IEͅi^9ncl|gT˔AgPZu:zvaAP[KƍeZT{.>,H"^=̿h_;S	yjWt4Wv씝7#.Q((ma8SKDh'cg=^4y׼MOxoUku YNx#,m_>t*K51
>iSzh6⭾2"2,iʴ䖺4-vqVo[}m-N 9«g >OA<CLscw{UbdHxcT^ǿ,oC>6Ҳ,[ږ\jsA}e7oO
kKig]JX̶Ennfhԍm0*ٵEϲVo_$&vg
~^
j_Ϯ%j"崳x,&kcgoj#$p纺kRrݟRFRK+ Q@ Q@ Q@M?<_v_L7_;}@ Q@ Q@ Q@犼/y-[%ƚvgj<wpn̊䰾)YBW*\-:MfOAEy Q@|x ?Ň
=ոz6lu=_(Q_M75
$4{#jK">?mo-|b>j|*MYYM7wv ʳ[][\Ʋ$@4SDq__?&g~E}|@#M>~
Y]i~V%̺5fAkolfuҾdyd+?h?[FRռcjQ4>ZEwZtS4	%5|)_|.Y5{[K[OsT0MF;6I+5vWJ[?

 g(-O.Ѽe>Gyjׇ^і[෵p tImAE\~!],_v-"?!}&߶EI{rȷBe1~𡼨}eum+;9{Yn>3&:r3mҜ\]t5)KDQ_O-kG K8O>ϏUATVJwcL*=J.KqI$X-_ 
 g[?#į|d_sx7ÿ	|?M5|%1q,ލd`Zx/qbY.9E-m;iy<O2˗]lvym&>_MX w6Z_G? sP> !o[|}fMNh"o
wo-`ωSL

hRWWttGKN\loB5猗/ ( ( ( (িn
 |	 թ> d ɸ|H  V ( ( (	8x"?? 
x"v}msIy<gϜ?>9 (?  759pU*tz40EN%*|T_)O_~Ϟ/qO
zo<-s}uq5]RB+DmHZ%C|ifp5f#Ѥ.Q( (7૑_'xX 7ƿlڍsg
ŬpHݤUdY,vV""䒕vh_χ#??Ag?:
{}SEӵKj]hv+ZO-meO5K_ f
%|xFźN|=1_-홎QI%沞d	
:Vjoe_,e^hJJ1uMyFI<ڦL?$	 OgN?C6~ϟ=y1ZĞԴ]+Nҿ-)5=)'Bkc_mO~? ]+>&/	ic>$4IGεj:`ZG=ͼZMܙfp(Z\9FS&RQQ|OK8W'y~[?t?a~ l࠾'x a]9c:
t.xSI44#i2^_[&<h&H ? c [~"j~)i<1Ok7mw^jM2oM(Wr8AO2rӜRM4m'Y\jVW25ߡ{<? doZi/<x╽ǀt}>(ͮFcHl;gd̞]}!'<qm#O7l"?ᯄ4
^Γ
E-Ǘ$vpjIg2XjĿ'^+|<^=i-vVin|'tFkJ	f]uz/[ mqAYm`[
4^&i+4[\z,>}NWZOOG$CᶟKQ-GVէ_ާjwRfxWSҴ{]JvX[}+I#ibqJtr~s拵b^S2S
I%gyIl`oZ/|3OZwHl4>omam
 HDUEEUT  '?c7u >#~z<W{K9|#4n;v[XIlH$11<liS^M|UJxTj{5)YSt+9o+)jӣO8*uVru6n{.Ǩ~?O$7y/w<9gcuh/-- 5dsu$MP>& VxW!xkRPӵ?kK[Ydx&7FWYe`A ׽qW	Rp\)4+vRON_.+K_x?+?b?_KHi>o>VfI$[߳[~%77׃Q]g!<W~
bb70ͪh!I'IURY5)'&~3:t'w(YфiUoMBg/v~4&iWt%+Yٟ_o&7#s?	o&7#s?	|O?4 Gi"u
x[~ǁ
?EN:>icF[[«$qĊ  T`xAE PE PE P_S_7 _ e}@	2>$~ SUm PE PE PO  !_ ] f?φ R?l  !_UwJ0/VWi!E P_ A;㟄vii[izuce6=cS[hG+4ά[$ޚj<+πߵWah_t|-kKSV-~D[}mhMP_.Vh_L)M'ǀ5_ᔿ~ѮxJQ.av
jw
i9X#eCV(aRmM-Uod'dڒ,f]y/ BǏEן|Rb?~f~,ᮩ ix{  -WL<ϴS&;^$qPGlj%8c&Mb(>_Gɿ>iPizgL<%x#~
|0UYѼ\-i~ۢjB}5yn5/4 Q 6 ٿ	k}?ھ_h?v:MN%XʴjuT]hrTV2i-#R^dhOJMNqm}zE|]iO5|hxxmoX4?kTY^ew7&
k6uk F1Or^Bܺ+sEtR4n4 8xcBE߷?%O	,$杩_Ci,Ho&.Zh|Kn=k֝mSUޣ/񭹕溹nSR(BM:+.E?Spvd%kф{$|+Q}sJۻ-ucgg+G~x㷆
7.{W?d׉VX_	nZfdIOhbGnF|Gy1~A_񶛧K
yմ7'H>jwsa=ɋL.,&kգ3OʊhÒh-$g'(ԋQV*nm^YYrn]>~0J޹R__xo'wX.F)iOçJ[u٣\u?^^_~~	koW Ku	""Ԗ;޶(7'Srxu()bkqi%6*PMƢQU\TڲJNں룊z.ys+6u/x7
q#Lw2P@g>佼e>2_>BILxgO_?z g:unSdqn>BZ)'~6?ڸG/jKT.k-%V\R~ )^<g)6m[KJV}EN Q@ Q@ Q@M?<_v_L7_;}@ Q@ Q@p  WGWc {8Ox| 3䏋~)]dcIxčGAu/B]3M..>C&wK4y?d
:l _ ^J,ZZ.0id).J˖1NO}z +6|"Ǐ
&58gQ# _xrXv<0)$)N5xSkqi{oK~,{_ǿJ 	 E/%OikpϿ? D^gwO) *~6 K^[Xk+7.O~'_j65|E}E)h|E6PfU2"IdVʷuJE)hiQJ4ԗiP_N w |<K_WM/ڴ8Ӽ	x[o[SnkY2nO(r>js8t2ӌ<$M_T~O}ӴWAE PE |7|/>kx<'}gZG?h6cqy}_j[iڈ.&5/~~[ '}^mNj>&Oi۽	m<?%Y}h&>i`jaTnrI$njr&֟iiEIi 5 hc_'ƍ7>>)Wuytsκ1|1z\EtV7ƶDC~'sV¯~8x^"	4⇆㹛?tSN-^lOuXek(1\\Ѷњ
4$RV[JIB5l|`'T*ww?_ǂ</?/Kw:λui[Aeeo4&Tyx/.~[r98gk{ 	_15>r#II,pOhW>s*<\ڄT~%ik'()$noRTIiEm+KM;'??U᷍fx>cxd-$|rIma]+'t}wτ"x"狼?b}Yt:ˑ^|<$Nb"jh,]ZgE;M+&c񓷲ھ޲/vo 
sƗťgإݫxJѭ6Ʋ8UaA^dEJ ||iǆ6|ռ)k</j^K=7Sԥ}G/<Mv-ԒF+P$GQ`jѭ*q&;nnz|Qs\6[Mf;|D9bVm^M?MWPE PE PE |% 5 po eOOWݴ'MG<e_vE PE PE d\?-r  i?(: ( ( ( ( <c<C^zoxfE˥Z4f͆A$AD` _d/74uy/NNxjMcjo>+#[H݇q8odit%mY\>$ $|P}kRjp>i y!tF|Mۍf+k_K_R/tF6O\mco	{;RGO׀>$jzRΩ\Mwo>*izbZ"V([xD~~-ͧFQқHE(4-8ܦ)Aƞ$$+[ @Q@Ed<PE PE PE |% 5 po eOOWݴ'MG<e_vE PE PE d\?-r  i?(: ( ( ( ( ( ( Z+$ࢀ
( 
( 
(/)/jx2?n?|v թ*
( 
( 
( 45'w3Ҫ 3a =  <>ɳƶiV5*rFPQb9=:iRR#6o? K י "O }ze 3a =  7M
8{+ T P}ze 3a =  7M
8{+ T P}ze 3a =  7M
8{+ T P}ze 3a =  7M
8{+ T P}ze 3a =  7M
8{+ T P}ze 3a =  7M
8{+ T P}ze 3a =  7M
8{+ T P}ze 3a =  7M
8{+ T P}ze 3a =  7M
8{+ T P}ze 3a =  7M
8{+ T P}ze 3a =  7M
8{+ T P}ze 3a =  7M
8{+ T P}ze 3a =  7M
8{+ T P}ze j,
( 
( 
( >  ɸ|7 ' V+ K	 &#oZ2h 
( 
( 
( 
( 
( 
( 
( 
( 
( 
( 
( 
( 
( >  ɸ|7 ' V+ %( ݡKmo|w;}oV.IoΟ㶚dRu-2f %<_ XT3??/ uG,_*GIO /#$ Q 
 Fg S    H 3 ) wT љ Ĕ ; ?b R?  Jx f %<_ XT3??/ uG,_*GIO /#$ Q 
 Fg S    H 3 ) wT љ Ĕ ; ?b R?  Jx f %<_ XT3??/ uG,_*GIO /#$ Q 
 Fg S    H 3 ) wT љ Ĕ ; ?b R?  Jx f %<_ XT3??/ uG,_*GIO /#$ Q 
 Fg S    H 3 ) wT љ Ĕ ; ?b R?  Jx f %<_ XT3??/ uG,_*GIO /#$ Q 
 Fg S    H 3 ) wT љ Ĕ ; ?b R?  Jx f %<_ XT3??/ uG,_*GIO /#$ Q 
 Fg S    H 3 ) wT љ Ĕ ; ?b R?  Jx f %<_ XT3??/ uG,_*GIO /#$ Q 
 Fg S    H 3 ) wT љ Ĕ ; ύ
 :O9[6xX)/|3ėix;I{x-4R         - new car.JPG  	@       ) 95    JFIF  H H              	
       	
   } !1AQa"q2#BR$3br	
%&'()*456789:CDEFGHIJSTUVWXYZcdefghijstuvwxyz  w !1AQaq"2B	#3Rbr
$4%&'()*56789:CDEFGHIJSTUVWXYZcdefghijstuvwxyz 5!    ? dO?_ >.|\wktm'X_QvYYoeekoPAx$K  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?= g);OxZO7X>_^,ln~xU=G_0JbiQPC  p eOWݴ WΟlً^g
=>1_ii_t8. /$}MεBe+;)΀; $ ~ Q OE?P $ ~ Q OE?P $ ~ Q OE?P $ ~ Q OE?P $ ~ Q OE?P $ ~ Q OE?P $ ~ Q OE?P $ ~ Q OE?P $ ~ Q OE?P $ ~ Q OE?P +|C^}xsDyگ4(St]I$Kh>W[o h?>|L<_T|E}fU"i-.HfX_cDp@ ( ( ( ( ( ( ( ( ( +/N;
 eH Y΀&Oď/jxʾ)9._ i¿>#K◂'Ot4Zx?/-jwZmi+q_Y|uO~ V_ e>kj5sG6ZZ߉|O6S[YO\LxƝs~?O&M?ZO<!q6s}X5mK8n`XQM2Ƥ[#?>>
 l '/?hA|m
CBtïxz_ӧ|?lڎZC6eo5ƛj
b
Hٯ~U Xh?<Mc~mym'Qfyfee9  |4 v7¯'USOxƺlz7|%[j\i׷z2-Jn-r ;*/ÿړ@GFK CVwl!Gln.tȮ/)VxL{ e ;#íź{eք=ʹqru5R=n\ }5~  k?k?>g@KZսΙZ56cz6]/ݼ2r(C~|k[' )gHt=::nukmcMЯѢՁu8$P# G/<)ዿ[K9[ZƟ'll>4jn5{kɴY.IvkmH|E)+W
#i>o|@-xq[F-:UՍ%heg=ŖOk}r?*݌ ه
5~?<gp.6i:ޓyMWLQ}OL&DFb߶"_|.6j񵧄-~ _[:gn3[7wZ>uoi!lD>t&3<[9c
S]%z ,<^L'uOOyH5çeW]Mm4̑[bTg??f\HӠi >C<hwiw	Og- y%vW{#dycV ?f_g-g'?l^xKZ5+T湦`5]/S K_.Xec7oX `o?h~٨]Nio|=m)umoW:tz.
+Qsq{3W! ,q?aATOu
?-Y-<3j^a8OIf+n_|o >Ժw/}h(O䱰յ{Jm/M4۹l˻n#0C' ~?Qأ?߳?6tO!u;mWDdzՓzdv2"4 h 7~?C_Cm&x¶oKY:҇tbtXX/6n+@=<ucཏ|aP-/P׏k:_Y6Sf7`F/tGNH;}@ Q@ Q@ Q@ Q@ Q@ Q@ Q@ Q@ W' x_G~-оɠx}_M. xD};<<n~12>$~ SUm ~G~?lu cx|wYhxΝkr$Rk?:Nh6u,X<)  k?ǿ< c k'"?a iWOڼ϶+?k|`w4M a |	/dk:ھE+gǿf  ?᳾ Ǐ gS|f 7kg>`  % h_]O'+P/|yռA-_3Wf6\P5tQi
I A ?JO Gk9 
[~Լ	7!|{GEim5$Li"gB4r| |'No_৅u 2𦩠뚶ڏ<2v6\K4қ{5RA?S'ew|F  fWv}^5hD5=vjq^Џ&= _ iI  fl5'/ a=`G] &~|v~
ꚇc( e/oN:>)񎵯E[T+].\4; e?%?F/O/aXk]Ro>OS}l%F?
(S@OH ĺ~x_ĺ御=>xWYƓqzm$Z]%R޾H~ K~ɟ/[ _/44B$4I.6:_:\ﶒKu
 < e_M~  Wow  jyVw}bm| =,7G <s'{?|[.&czuK2m3Ofm?MJ` l	 t
O^g:+xXiPYX}-Lk;HV9 %w @ a|^-}~ GCF h_V`',~{O4F   |U v ,4˿>7>G?0㧀ُC b (_ 
[>x__,7 dӿfѽռ^l\]]mo;_ԟK	s/
?~ZAx_t+K{"[A񭡂|3&K5/8p6F? /e]O_4N
P	</xzZox%VFv]3NX47$?t Q@	ij @ŷ6 ^]SJu9b\aMKK
chV ( ( ( ( ( ( ( ( ( K	 &#oZ2hC	ÿ_N~+ԵMQfR?'CgO#T./r(&?1ѿ|c1 t|Gtګ~G/KoPmdMuYi  Ak uf	33o"zG #ڳY- #T֟oK&̒ic9W͓o-?/ |?x
|eVcEӴߏ1XkiSk86^2Yrͦ^æHd_2y@> a?l_r~ҟ<G ANú.kwN5=
.+?IQE,1+_A +|R ~ 3_'#_?	xwY?4;?쟱_iw-dU[bm7|Ŀ?nW٣G2|3|xI޷qD5i-/)|,,h4Y-I57?翃z	 0i?W=6"n+2\U"k	 dx4@kjZo,t`Mliwsil7F{{ yeE|0 ~ߴÏ(nWg7EoHtX-K՛ZT6*ڞ}-kZ`{?mxW
{'ExQ#eMӫBCwaǩsK<ZepI7b?᭥S~5$oH<+-WFDKkĒ[
O 6h|WN]s~)F_cw|u
Q.qY	teaV_?7S'@|P<[oC7xZC)o>Lvqdh(C ( џQ[s=?Vw}>Tqᱮ[D
j<*I"7m-uS[ϟ'+o?7 j_Fe' OS{$νӳOTy^}=[_*=>~ʿbek?kXaw_hxwJ|EOgvmd6N~ x w?ï K<'k /^5姙,?wjwQ^A"yz}۶P~_R :WS#Osǯx㧈u-Fln<g\hj#)nSWYn,Ā<|3SOb/oQM{^? M.x>}$	%e՝Շ%\Z=$S }I & oo(_ogcm>H?#ORna]Yji(sXlt Q@	|I ~@~2G ( ( ( ( ( ( ( ( (?n?|v թ*> L 0?>޿>b -Ɖh]闑@ZF> R B /3!G#  #_ @e/o._Of k?vy 	F>7|#b{0+Ox7d:/t_C}':h}re
N(#gEEU  {?~o 
ខIuF ͟l~̉۩wK'>|)[U 
 Kx_5^lf{dO^KY<h=<;ߴOBuYkM:Պ-ިUlE$Z@ m??`? 
~_t~1%ӾrKG|qai{iGb鵉4'?~o 
ខIuF ͟l~̉۩wK'3'o]Ώ |1
?T|u[xBƖ:mRWKa&
IsH
 c zR#|
:M>}'^Ro k#iPiVZ"
(Qh^ ~  hWؼA jG ~{^n \nϚ:<g^vj߳:}u/
i^ke剭fhbm@¿?~xA_[ខz_zVyIq7ih4nWsbHeًfٟ?~ 7_wپ_h?n˷&)~~'CĿ?5zۯ_x;HT48e59.|3
s-M"BA ~>x⇎~
m}@j2<97Mmas\ZĒ_I6뙛9~_ 	W3_ۿf Fo;jς/y_h7lۍWxc~u+	_-7:]O%ml
nԎ{K[  
C i(i ǟw Ǘ'- t>x3 g&om|=-Lͥ47-spDb)Rዶye/o ¥ ;H  _z * ?S<
o/t]>I}&K&5X(#$UTTUP o * }_^#yݹ/ 5߲y~y[?m PE PE PE PE PE PE PE PE PE |%  p eOWݴx#M<7 xs a_W
GLK
'FQ,+mm.fl-_@ Q@ Q@ Q@ Q@ Q@y?g
i0OtA4]i/IKZE!}N`[iQOwrRd|- |
|8cO~п/4 sN\itF(hlm]]$lk"
Qm PE PE PE PE PE PE PE PE PE |%  p eOWݴ)oxSφtk:֟q>g
ݎcsCqmso2s,n+ _ x'b ڛ_{[wß3yjHǷ4(mDph&vMijXj  u H   xº | k <Z ?]R?>  5 -y _ W_T<π?~/ G+*GgF Š#3#_  

 G  h  u H   xOU/	x]owƾ OGs
;;;|_mkiR6[gqu:@GQ 5#xJ$мSmsfLσuiJ~$Lo<sC,vVw6wv3{+*GgF Š#3#_  

 G  h  u H   xº | k <Z ?]R?>  5 -y _ W_T<π?~/ G+*GgF Š_V Wm 6Z= gn\Yt˝Wƺ!fk7PIDm5aAW-?t |AP;7ī=GT|dGǟf]bio㷅2( 
( 
( 
( 
( 
( 
( 
( 
( 
J_|E
xڅ|nil_綴Gbеъ0fR7 'MG<e_vE PE PE ~ԟ>0|y+x6>*k~26Ǻ<7YGX]͆ok-ŵi(4b~}ƿI4G r..~5q]CohZlR^-yrwkcz}t Q@ Q@ Q@ Q@ Q@ W|n~~sDr|w&kxĺncs}$r̖_o3G+ oI; 7  ?䟳?I; 7  ?䟳?I; 7  ?䟳?I; 7  ?䟳?I; 7  ?䟳?I; 7  ?䟳?I; 7  ?䟳?I; 7  ?䟳?I; 7  ?䟳?I; 7  ?䟳?I; 7  ?Ot#~|?o5=[Ue
n{෷$icؿ
+|--owo/^M%Eݣ\sHHE a ' l g@'MG<e_vE PE PE PWj   h u 
g o ~ oؿ ϟͯؿ#2 
C '1 b;Fo?@E PE A[~?|sm?ENjƱ^CicF\\L<J쪊@qTc j_)n$xMsv7yPB+jp347F54m+Y\[ ǟ>|iu?nKdG0Xak+h!iKot ka>5+xZM:-?|I^;c'ؗFӛ[B4ih`Ӯ-ͼ9m'hld G _W KÙ|9x*tuF)Ѭ7/K=ƣy5!4s'@ Q@ Q@)Y;_~_5<?fE~ϋf}GH^h'tmV	T ўkM[Y^/D<l&|)ZMcY$S0GO~ h|1<MΟk8ﮬ<BD#ѵ;8[5O ,"4p  ࣿo*PKJ *տOݿX@>{ Xs %V ~0FV7iIzaaD[mԮ
Gࡿ<{x[Iռ/k_wZ+
7Yx%Ɠj$N)Y=W9?/5j+εk~/o
'fɪ N
PZCIai3I)0?Pm;	I~j7u
#L圷֐M}kJ=*YK$A=
=g _ WC_|EGE~_BX"xrM״t'2KMjCk4ܤ2:v?U٧FO@?ٳ_T-,dnh6PMm7Om$^[\E0ؿW?/t
/_Լ%[階xs\f0_ioKZ/,21^ 7~$k?o_B):\fiZŖe
ŲͦMv'{yo .?Mo?>4Img@|o!³#O~
vf.VV_N  W^?>x%G4'B2}<+B ~ԟ/\~ž=Q ].y:g?,>ݏ!!L>W6oao8go% 
|&-~&~?,:V>
)
ŇV1?64rXlB]>ЪI ?b.k>1OÏ>)]t j-g`ݴz:zMqp!^_S#oυ  |c/ioF<7semo \+{fYk~~p ?  o? Li]= ?c]G~3mkOZ[ytNISѡu+ym?I&ih;LR < >"~Ժwߏ}ak)O㱿մ[{kJ]/R5+IotK363  yg$zxQψ|?qhfK}ON[}R+;[ gGE`h7~?C_Cm&x¶oKY:҇tbtXX/6n+}<ucཏ|aP-/P׏k:_Y6Sf7`F/tGNH; }_	~qV/Gφt 2>$~ SUm PE PE PE ~
wᎷW//>=|Uw3TF:voZBӧUu#}q@!7ր~2w6vsV~/׋>"x=|+xw3K{kFvl&Z^ӠVt-cqN&~Gh/YBVM>MkLR𶿤XIHUioi}1ȶ{hif	}j }E u||Lյt^khmmbh{x5好	\ D i7Y[FӖxD7GcrL7޹`H5k}IKK#-<z ޛUxX&Ҽ1\/KIʽ׷iR Nҧyaѳc_ݴ~{]v]gùex
u)+_UKwO]7=V~,XW&#°}.=A|%ϫ<7#.ofk=7֤Mqban# ǟRGy
~LL[_<]2]6UI5ocnmdmo#3.*JpU*]1IyuvWZK춝Ϥ|=
	Qg95fM{Fήi)?GwH<Kb|c-5C[n!]Emy%_mnh-+?j">Amm!
ɼvvZCm|#5IkNŽ\|b1Xcg)^ZRI٥י=xg	GeaJԣ4-5RݍާTWݟ Q@_?_W s \  gğO񮳪YJ%zݤiBoCgߊ G x 

d _+
W}~V-Wy$| b fOٯW^ ??:OWټ~6o۽9 o?( KW  _Mb}OEtyLoWvw{6 )  4W!؟1 o ji}ݾ_i :a < w+bj_4~~: K W 	5wVgo~m6 !͈_P# n?n4
'_~0I۶ V@%66ycĶ#2} *- ~?^0Ρ'}pm7iW7ֺ[VηKM̀R?!ࢾ:3?xr]`?
/4Z"y,=5畠YFQ'W ?<)Pb V'{v sDGt凈kK\<	*sПM_{/  s% 4ټkOh_iѭ+{-?_sWCQ|& ?-f/>~ƺƾVKԵk[_\^!OD1\zwɨ[( |P9վ1|1Y)|	i|/cg^4ߴ=sf C_~پ"|= ~0~Ѿ9к=Iaan;K)knE,^K*_ y Gm/Z_ڿ  k+Ϥ dڼ;Egs~{?Ce_s_e/2_- 	'j _aO>}g  9 2>)-<AdxC? ?">wp'ݵK,i 7Hcs/=  
|- o~ߵ lg爼/,=K\@Ė[N~ n,Vkj = X    
+O  ? nd/4 x= Kg<~ڇϊ?W$^	|G5߅c%Qqijr4WOy{g#%r$? w
e 
K x \WO{ 	G|?q%4m#fc>ů'	] < o|e_?B _ WG jyW^O }c =wy*E  
{J?n[ycoo4.S%_^4,da/O6l>c8+g# Ug: ??n?|v թ*
( 
( 
( 
( >C<Zjϧɢ^){i2Ii^-<1;[Y4t9%,mV=?|!b*<xUXx@;/~ƚ
ZE}B.",#:#FKhݼhQ"<<j*]k>5+ |/f1I/)Pivi`x~EUDDUNG/-{O-MG:jeƥcGzSQ{6WVZ}Y[iw1ĩ5mң'v)s;~gV_1~ RmpME^ryn`h 
мW/
;Wv~|WZG jSZ=xMPPKSc006jKZ]]GM7Ze)$O<Hb o0UGҔb},7}2*Ͱ+1j)76i&ۿ*Z%Ş'
'ǚV|k}NTZşk6>iznIYR(9{4.}U|, :%ĻwO-XȖA#lo|>Y1-u H.b"SQ*{ї"J3N)E--zwwY3.x78:7'*sN7ܞQʹcʏ6T
( 
(/N;
 eH Yο>h?jOV~!)?W5oE(7fk@ϨY\^]Dzn~uuMcj ta
	% d&~_sxݯ?<Kekd֞%Qͦ^0xu,l{e[ ؿ	şS?//|b3%Ω
OM@.kY- 2˨^Jf τY('㏆~i'O
xc63%ڞ^k7*vڄi֪]N" N'UO'6_xW]BmHX61,;429$u2۬>?? o 3(&­ᎽΈ$0hWu,aX /
\֗?-d' <
|uz<M ^;mB+m+6ڄwQ]˧\	VP# >^?oL͟>!>x  /ڗ<]eݏx'G&gcW1Դ/LlfErǟp/| 5ֶ ioXǂt=&L ~êjZmQçڶ!=սeQ U=˟a ٛvᎅoĽ~ǿR
J^}q;9-ẒHmPܲĦ첬?໿ =x7~:
|:~wRZڍŗhzb>\GcL i?PާC>
~='H<!9_GVQY~ĺ$2%Oۣl+~E PE PE ğJa d'	hK0  ~?V|3	 &#oZ2h 
( 
( 
( 
( 
 W~)߲e߇rIc'uJ-gF&,7gWY2ʰAd$H>FZ|Ri
++i{{=ӽ3mi;'{O+}DO_ n>T\}8j>'o \'߄5?[i7wWe5~o\'77=ԧ{iojU~#r,~"/ߧFIRgz4בu, 7?aߌ t~͞vgޭͫjgQd]*$MEzOqo˧?>,O*O%xkX}f/.GoFIzH"n9&7:JqOQ.D\/yN-#dWϼxIҏ-P#RiSToy6d x {O~-ag?y;x^Լ
>4K:χ<9y77iuDj_g`D+o<]Oek~+˝6K5ǢzOmlOl#Fj3شy9<~nT8+ĸNV׺ozgBOX<4.,*r[^)W[O]nW[TWE PE |%[?i>_/jf K D ;H < /}<? h  e/oE¿7O~o;m"-/3OqZ$>&nHY.&pbz~	ߍ.|?7xZl>!֬Qm-D]«ef)%e h'>
'~Of.6ߴl\Q-Cr7
4F-.d#?|)xv &PV7C8{-"7RP 9߲ⷍ9|/῍~%g$^0<i˔nm\y1q/#yƲ6YAOK[߬!3C-J5[GC=R2yn沎ɉn"I	0 t_'~4x X~:N?
iZET!ws
H MK[U[  ƿ/h4s_e^^}P.n㸗͑cY,wo'o<}MA5k]ƾuk)cI9J0YPp=R*VG/?<I_c w C\>rb.`{_"I."_.YE1$о|)[U 
 Kx_5^lf{dO^KY<hǞ;R g 
[ik _϶&=_</-@=/k=+KӼȴH̚if}7I+1' ( ( )X?d ԏ- }_	~qV/Gφt 2>$~ SUm PE PE PE PE P_U__
 i5F7ĽN_4c&~>mnQf/{kUy'%Ҩ%/4z>t~*^!~_,=Oe ' Ƿ-E|! gYxwwIe:i&EIʥG
zQmZ{#?~XJQqiwO/ڟ0 oS &~/~ |9>ռ14.d_ܴqi֗o.d
s¯7xz <Vv|~ЫZ¶2Dmp!1&FaMv
K)Qe)]JJmKD)#/_q1x~M%NIoJr^/h&_4x~p<3hWV^3OoGmK=2YEC{mD+}C~fOٿK"|z5ZxGLuj>еوKxY'0uqYcK'RPWc%;ܭd\7rݯO2xo&ϡB)ԏ%S]6|0,(sGTE~3 Q@Pڋ}Z\~R4{];,-l,wqj@ Q@ Q@ Q@ Q@ Q@ W^  %>	?,.u,L7oc2O]'Iywiq ԢinfFK0  ~?V|3	 &#oZ2h 
( 
( 
( 
( 
~ Y]?`/5:'ǈ5}I~4Ѭlln5=OMӡg*$--Йg[QW*oK?3FAnWz$H3/= =~ ? q^ ~*??%^6<SxGmz/5?A}L<Ru	-u- PWV)|mo_įjnOMwGC~o/4i${tm˜2/KFgwNɩJ,ce"x8'ROǚIWS)Yyοi_ψ|5w6XAu%׈K %ap8v]v/|Q 'f1_!ַ=KUkH}#@Y.pX2(4pN	{$V=~%6ݵZ=urlϙ?ЊoUEk{{6+`
( >t f;Ái-C_|Mas|x;#uͫjeեi<BQ&⹇C<-M?~ gpxV]M
Əi`&E~u,bķ2 ~Q@ Q@ Q@ Q@ Q@ T._O>&_}ƭk6:Mm5̱Q$ʨ M ~|k_ϊ~;^ĝ'S\yq4
bַ,Ǔ%?d:Fp[j:$o?eog_|wZfqk#5ˍKU5;O6AqF5 K0  ~?V|3	 &#oZ2h 
( 
( 
( 
( 

MCſ/C}]Kݥ%ݭzϊ9k/tZ\U`&inMuiƵ)іM;yЭ,=zx-`ԕw?<|O%Ro|GZk=v7p_.hHG"6Ue)/?`ⵟ
3|o?/<jH.WS=Q_;R'PҎ1A4֞__xe;5x7I4F{;MJ-u`ig88uO;NqiW'Ѧ(1}oB>X7ÏZ>4]ǥAxxG1*xwRF%)Kwk嵕̆3_u{ş>*x +\i55חkv%S]XCu$i|ҞF5)JsCݜz?vi,|țZ5J'irJ)KZzJ/t	S*EIrH7_M
SW/;^.^^^drmoo-̳R]y҃%~%ts |`x6xHHmcEOu8@>~;"ˉ"G}G:pQiI7IFW߽y7)NM/'SrZ曳&6$R!1n
( 
(/u7 ?u7 ?u7 ?u7 ?u7 ?u7 ?u7 ?u7 ?u7 ?u7 ?u7 ?u7 ?>{?a%:f 8 
W4}s\6-lY[iuuO*N׷mes~  +g7/r?JuCyoh.&i%0&ZI
͕7:]6jWR é ?g<! 4é ?g<! 4 é ?g<! 4é ?g<! 4 é ?g<! 4é ?g<! 4 é ?g<! 5xG	 1=>6u}[G4>oYm!Y )Q$TeddVR>͢
K0  ~?V|3	 &#oZ2h 
( 
( 
( 
( 
G
7gCA!zceoi57:aMKpnIef,'#09R"|KjԊt>ɳo }Q?q)km	I V𘹸iZm&4X1I]p%"$e ' ǷqA>(.ԓ'$ݫ]W-jOܓiZ<Yhֈ?Oo^🉴:̂~&c47V:[Ism$S3mռء.@& O
;Osx||7~ڄaųyqB*-ROojbI`ӣAT)F^PT=hݸcԱ5vB5*+;
iA;-)&Ե/ S?XS^6xZh{M6ciLLdd) O>ſ]Έ#_q>"OWn%᳖Y-b7 xYN+'FeR4c.[^J.rIB5{[Ju1NPIo5߶TE}Q@ Q@ Q@ Q@ Q@E_?-
x ᶡ//B\hmrmc@);]bk;k[ +/iֺƺ|7<^jt?\Zz}ecssZ{ecE-[3YK~e Q@ Q@ W_w  L7_;}@ Q@ Q@ Q@ Q@WoS9ω:.qkƭy
cmMqssq3,pChI+*31 _'R?/Rk֗qM%bÐj5W)/wpo\@ik,38xFB-94ӌS\7\^?gtyG?$w˯Izmow>/]?ݽ#P^	Xs<	;4v avm-}n hĞеM+SѵytsD֣n|CvI%oY-&M(*I_	:5UåꫵWh4wd7ij>
qO8|&nI(h-"|e ' Ƿ/= =p_ % % <>-iߴW]žV۫o\G*;^$BoPi4{:yw֒O Ims?ōwOe]K"B SwqhY,MYZK>T`htk'%/O	U5^^ݵFOFҒ9wƸusRog$WOI8+I'{7c.8
( .B~:L<7˛ҴϷLM޿SMYUԧKyϦ=FRdZt)εi)II]މ%oDrQz$Z|->,q\ú?xsEyd]6rlYeIt'ԭ|68nY ?bio# Vv7cgف]cTռم>mJ5S;> J?	Tqu\r4]Oe)	FWugա:JZM{Z.v _mmN?m̺;}}'L~DfΓ/wA\?
ߏ>|t'L 90dqZ8x\?Qs{GVX}ʮ*,>)Ez*qkۧ.k;_?~'ES⿎~-zk6>?	3M<7Py^%nn>  W~Ԟ:~f?ٷ[>-xJCϡ7id6F{Vյk{n/bt2O,=]STynU9)ф=bЕW^eU$8fKҏ%9תJi(;3
S 		S@<3ֶ\^	|M
6pdڎe,VwpBaC#A c h>4Ώ%|	<&4[m.VP4뛵MgQկ]h1_6s`k'9ѳ,a+MEyz|<:eYfܮwZcOe'|N"'JuBmaRu']tW ֵ*9 hΏ-WmhZ?͔1-FFtxXn4۫KoHЫ	''tދVgЕ<0?wr9SVj)8٤Q]'P_?ǃtV~>#}ֽi{iko| 4}IJZX>O>MTΡ j<e/'L{ҡTZ,tKi5l >͠ ( ( +/N;
 eH Y΀&Oď/jxʾ ( ( ( ( L WdMGRCm"ki<iwa&ҵҢw^}Zam ?k  k;w`/q+eJvOH/U-e/}\5:k>ݗo#O>.rk%\ʁ5kLN$eq*G,yt{|wxE45O ڦM|ݥƱcׇKO2YKVKնGa3X'2ucgOU(\=ŧtS1>Z&֎٫ꮏE 8%o?-h^7sok>>mzb7v^7:ĉ.$qY#Y~ߴߎ|'>kk.^xGR	a
6&uqfŴWi0%$-TNTU^FғQNv%4-Goq'&6cS-FY	
)RJ5	ߖ<ӋUax[~kkMlt~$kc_LY '|]~4<|WxIWOMHKŔzѧ+"mZ<s#q~I5=iÙKT5;RN|} B<O/?O~14wR5ŷ[Gwg?rѿ,hWE ' 
EW߈/<uh[͇A+j~񎆚3uO×jelneo?m5
E9y,w҅L)δ*B5#8Es8rN3r4I]O[F	VRJ-6oM֫?>?a_Yş~|yx3PӵKiCX4f5+(3-Pw!C~|+s]s~7}4IŮxa>j7|s]H4Mqa]3ɼ88<*acLEHF0Cٺ1qU*Z2:uy~Su*kY]֌8n6D|Mxķ7[uu[#Ğ8H]}kHN$kQ*}YO?jߌ^~kJ|9ψ9uc[}5ⷷ_.1c2	,U\^TFNQJUrQюu 9*Vzs8\]5N_#J2|x5m9 ſ|ozɣj?oC4:X?2C5Pq'whh_.|'mi|}-H.75j,CT{mU+ux弖'&8 h}vֻ')^Jn5N\i8)$ݗpGar-XzSTF9ቊl4c**(S*rM_7iOڗ\??'?|A1j-ԶEc8a,B;;h8H_|0H9hZ=icif,#|v嘜ujթ>k(UkI6ge.>(c'}['*9N~9ғ&ꪒmhXۿ?kx0Gu9|q2ç[ֵ}sD-H70de[viXa)(EEZ[8vcugmnqGձwONRpNQ~d+f+>X(o?_o    ' 	/,L ?3 {F 	?< ĶK 
( 
( 
( c8+g# Ug: ??n?|v թ*
( 
( 
( 
( 
(>~1C~7ŹmH 	|/Zuk.P# d2%j$(;8{ ?k  k;w￡srjKoޯ>oI5w>_*{;mO_m\iw<?.k;ݺhty#8RIx>+o otT֮tY<Vu
.cҭU,$sI:-LV_:ؗJ	(ԋU_9lҲx_J)Eڌ^pQ6TW {[z?iWᧇ kKxGw>5<=1_-n~k:./u/)$v[igVƯ{Ð 7|SlkKY<1^6>ZmkQ"]s\.Hfg<rʜ^R:OT.e8uEZ:_O\Wu`?1(SMG	UNR9})/iZ}j_VSI [崗[	lYZ,Q$"8ۛk J|xsx9~![	Jp},TOMJ2MI6ڒi~3V7'˧OwOv BKz|\)gm?Ű[2K-W3xwQ0YK]%h?R1uD[YKV\V\熦k}uKAExI{p~ O[~ZO߁z{Iqa}~7ծ䷷\j^"׍KzZĶoҭ&9CbO|Ʒǋo?x^:NI{ O_ZhP\ѧ׼E-ѵKNE&X~ jbaJXU8KZυNNu#|*8tpJnKUwPnWc{9&ӜSII5eN AfZ,u5mwXKZVl濖[_'?*C?_^Nzmg%ݭjd4ؔMv#Ėp=΋_p	2*u]T*Ԋud)T%AE(KQJ.OZVVWQ(:UeҲINm4JkɟWwoYxb6xg
XcUWy.WB{Im{CNv|  M x]./7xm#ş-mI]A&쥮a,B/| yؼ%=v۵3I}ux?܆xK+<OJڞ9N-Ft5:VrjIQ " vO |AM?||WDux֫OCNbb4{+ȧ&Q!y؇\<u㟋a6mq)6K{yͼ@QiIgD"kk{D%SoyK3:?ntSNf;8N19%G	ƞyΰУΝ|Cڪ]9RITW_Wc;?GӬ#MJmmmX5eHE@(  cO_ n<e N _~/:9T&mvݷ}[ ?}S GbM_X»xqͥ_˧H}+Mk
eg8Vkn6QYe|ᖐuSR\ۻYk~g_Këy֑Pqktɟ4W4x[aLf_[GiZi1B6FyEoךs\om\@M=;?Ǭ% 0ڧ5Fՠy6u].$AE#GqD )~ 
/ E#  D [_sj ( ( (?ୟ_U  d ɸ|H  V ( ( ( ( +(E~Ɵg/ú47ltۼ/-gP4V9.ٽA0K<JUSڊnډ&+^Ҿ=íRm@K9n#i#i<-Ľ g>og9_<wY[}1*#GD.՟!4'7
 e
v]J}3\FՠXx.V{01[^#LA"|3״}n3_ ޴J/sNү,Ć~c#ޢT*ou$oT
qoU ~{ֿͮ[AL&Hאy]XK<\Tʡ"Dkğ^>֗)46ķC;(Y!IdMq>cRq8rqOH'BVuTӴVW>{\Q<^ܪUҔ$!NTSQrrnN1>J|q>2^iz͝y\iQpȐĒ\-FqMj߇ۏkՙiݧ:HVVI,fwe+h~n~aJRmnsJO\6vI
1劉*sjϕ'ow_Y~)?hOޒ5_猓2h].U5m[أ{5]L۾|'oSOwS៌t
;>ԾqmܤsCC4o:* ~W_,.iGhևn_z;/eKK8nKʤ>ݏg(=C㮻/!X<_%~$m>Rۛ(.V)bH帊(8>uf: |'jMO-+[MQ5k5mRZK-pbѬWhl#SR֚MYAE8){6ڄg(g<EY.ԌaM]Ɯ`zj'jRk¥jT K+ׅ>?^ŚZe-'qf7Dsqffcz
]EZ(E~X~O_fg?G\Rm#ko*oҭ){KTC3M7X\4+S-XYT_y' q6ic<rrQa**/7RN*ANQj{ f?%K % n>h[x_?i=Px6֟ftX/-o&	.45WvO[ſ?o&[ ;tx{ "QWd>qmH kʒ] ^l#$oVwwնwLqoIYyƘ7+Ԝ`8>!F
t+V? Qm"%׼cE=fӥ[Mmk3o{x4M '-GmZ0X_xRԅ͙..uH5vʊiYⅿ8#l^_QBZ+]T^һ-"O襚;U?{97mڗ?)ҍ:Q;)TNsOe ' Ƿ/= =ӿ _ ?{oΆ3_?Ox][j־-׵gKᶐ!tS[Y'k^͆FSӯYR|8e
_5?>3K
µ~yB1Wݒݵ(YZQ_g/S~3x^o#B休ŭŭż^Yڼw60wk}m,W\A,SE|/z^ڄk:iԵbQԦK{{[H庸ƀE PE PE PE a ' l g@'MG<e_vE PE PE PE P_ppQ s?ͧ< 	f:! Ɨ|Gɟo|H^;s+/˽n_Vs s wŻߴeK.m=tmFkQ 	߷g>
%S
MR w9/}Nf{ g>og9_<wY[}*kMoG<}mYL=;.%ذ߶)#x#GR1g7Z
%.OuKxh3Mm=jװ\i'贶7+y
[,1xïMmuƵkjtk[+),5YZ]FTͱ)ae|7+]M;rKM_KJ߻u-?z g>og9_<wY[} ]̚7/o̹&<4CQ84P&b~+	R[s >uuun*p\8{ >L}7OW{[(&--%I.$6ѵ\O,[YA<SI/?Q#5BGC^g-GM9W #~q7$j`ir*nܼRZ~˭ﺷS#ʪZn ݏ??G76??cWyXF➛kwuŖOҴoi!`Dsȗe>.fs8a*%VGNMJ$Ok8
jYkG/0/Z#)Ɲ49p^pOYF2
 _>4 A~.A:jkt)|EWwOx~g:W&8$aT1%?_~~ҿ->"9SzƏښ-4x;œ_^٦moAOIGbOVKÎZycdW֝~k++}um<s,/|(\Xm>WBRT*~r [xsgO/2txl:ɤ<|+;0guk+mRu:]C<5WQ\jw_w~߃ _ڮMVҼS3ti~\}ƇOnmo·<VJڴֻ>p,>qgNpRc_3$+J p|[ 2O/Niگjr/l),4)aJ*QtBJׄ#~՟`}C]xqx>5ō:i귗_:Tz,
jj2M_୿~xσ>xN9|-=}&x.$s,o\\0%S6ʄmE[tմ~ɲl4sL773n8u;U)1qQ( K qfϢ|jҵ--huK;ky6-rU[YhV7^<8"Rԩv~Gmyny D87겥-4k*PkZ܎mAUm?Udo]w_|5w|[GHⷺ&(	c1{q6Qͮ6>e ' ǷW֩tݭ_Or 7:WTNge5-7ߗ.ŷ߳/7({Hl~w=PXs%aLͤ&R ko	--)&y$Y^Yno.$y'Iewo#,_<uH%:M,A\ yq,ۆ{'fycʯ}weE}pQ@ Q@ Q@ Q@ W_w  L7_;}@ Q@ Q@ Q@ Q@|; IGT?iw7 eb/tk;Oh7ve4eaS,mI%	b&MhU:Z+t祥h7g\oYMSOc,F;bsJcKm%Fk	X|K+g[ωP]cg>Uis]Z[ӟB]Z|ohuKs.n7}+99 ;w ҳ7^3s-߾9 g  g>og9_<wY[}xo'<+:޳`pXŵw29g!dN]~%]((:Z^ϢKٻ9r Άw ҳ7^3s-߾񖉢>-^otHh)S|w[rHr ٖj`ZTx4׳%; -  bo~~ࠟN%Kռ8c.u5J([gPmH̾{v	ZwQJ1\{F6MkXj䊵zK;¿./_: ߳?raiiMzth-u><Meu5Xiw$56)";Kijg[e{Ǩ
Biͫ' .{x[I|O>g
yM%9hN8h˚tK9yѿ_᷂e/?X?/~ [?𬴨MSqq	I5K{=:P6? Aд[ x}ncSRCcђ;XcknnnsZ:9V sjm%#-%gtW/	RTq>7TjF״[n
kZOF_z   {p2  gۏǽ; M??*yx/Rg
hiK&Gld}?YԮE7Ǩwmmp'%َSy}soW9ÿ>OgL xSM6Zj"Lo0[+slwx[p\DPWZbX8̣{II_Dܮqôrl\(fY%jzq/N"I43-8ӌQFRƿj_+/J/6RNAymi:kxR{/[KqlrTl0vW~ M|}ş>6aocC#T:tW!SF=YuŽMǟgXX8ԏJpչ3%tcd 
b8fw̫Aӭ%̩Ql63%EµoՆ_z   {q?#  W<A?İ:VڧH"4l$-w~ћ}>ݤxmHRRNI|_wZI+˙f2|4N.N׶z)$m$v?_We!>%^m]=%[X$M:=:dqqwtMzzXjK݄TWUf*;__)NVsI;/VV8Q@ Q@ Q@ Q@ W_w  L7_;}@ Q@ Q@ Q@ Q@ ``O?dS[?q}7%v40U~k+Uf T{M ?h>3;LݶOxCK1ʰF\\&7f+2RIZQj-u_A\n_Vs s wŻ g>og9_<wY[} W ?O 3/ s<  >Em׀uM;Tuxl3t[+
\K%08VQq<OHjZ]4?/th++M{]X(mHA\	|K<ҩqU9oJɥu w6MJѲ&m*j4oN }hk J|xsx9~ ?k  k;wo ӟ ކ< M <5?-! ŏhZā
Ʊ+gq#>M\tF/U54e1Xy
RkOv?L¶>mv_Wq>#Ͼ>T^%?	ӵXXy|hK9[OSJt+GN-=j|3)\8T8
	/8&} /;4_̞g/_HU^.lvƻ PŕY~ ? q\UyccWbݮ߳o-SRW9S?7˂ΜQ*odrIJ*t_z   {p2  gۏӿ _M>xHoEZŗ4?kk{vIz22*@+)~ ߆>^C!Ҽ5\^x5}"Ե#R^[)>ݨ.<΢	y<[z8JaqIi%I;Ks.h)&έ,7׵MRJsSu=WSHKiMZG-ƾ
u?2k)
5rO
_#ʸ{PtPZM"$wVs/= =iS]˞VbNWWkio>~~ ⿊+I-]15
ONӿKxl%`KOq<G5[4}Lٟ<W
9jmcŷo/	Kcmls=wSi*.&VbjZ#Qk8?CLUj4J9?M6,gpxldEg{M=-
xc>6x'ZmXo!լncYm!fxeHFeuue$jz$D( ( ( ( (?ୟ_U  d ɸ|H  V ( ( ( ( (o߁P(߂4|3<qfsUy -<EɧW;dN6}kzZ ӒCn3%|$y?򻛍k J|xsx9~ ?k  k;wl9 |'_p>9k><Hco4[t&v2o,ƬkL*pqkN|￟h9ndnmd◲^4ٺNvQ-vQ98oGu g>og9_<wY[|\n_Vs s wŻݿW ?O y?  3@ rpwnݟ<
w6~ֿZsZ߾ѷEm0W众͏>:+ `o+'w{P>}ƳeKSGl[iא[KD]]kF䷸-77/l70aįGV5`.&O
`eŽ֗&$p_YYJHVMJN/j7MmZ77f4pYj*:89*[|)ɺpZm'-y~ 6?m_ x{x~߷wQ>t歫>VJ<Yjڞ1#[EkoJƌ_cf]p3K$o]v]Oۿn9*m$oIJ'ߊ
k9JB/suYdpF6~1]Ĳk}1K;Vd<w<M]SūAipxc:n"OkZm5\|&\ES\t:X,]D]+KUPפ"vu!k5f8TQqM*ܭW59Qu-Wz hmG-Cu7ŝíRԯ˷oyew3]^K#<3|I{
a7xF+?|cw/]w[9Z Z^RfImkAVⰘHaiǖnSR{]Hfa`2L<('5OߒZ++ߕ}W}w|w%h6w2C4zmt]
$xŔ3\GjmΫ\i6ڜ	u[8biqyLbid*ydruo]ԌF1VQI$z*wJ[V~iRJ|L'yIvOHtI#=o_ ]w⇈JZԯ|i+^]^WAèȼaoI+՟	ߴDtKt/iOԭ4W5u-$i8g9:-O5kծorzm}ַ>KJ'a`g異wi&?l(>( ( ( ( +/N;
 eH Y΀&Oď/jxʾ ( ( ( ( +q6>7	6 \c}wb_u˧7ۧ WGfx_]/ v_Ϲ ?k  k;wk J|xsx9~O ӟ އ C?>(x |VnWٵYtܢ]bwgl唺\diiYρ1 /uwŻ]\ic(TJwiZS+K5OH4;=T4[[nn9oQ^a8\+Q!Uv#d~w ҳ7^3s-߾(ɵWkGl읟'fF\  mg;nQ;?]_-:`oUrh 6zK^K^Px~<OO|jאX66Ѵ7721F$*35_
c~|o~]
M5oUD-yi*;}!OEb<oԻ}oO}& 繷6^΢Pci-{J{;/v^V_Goh[_?	>v<4:;X,	:n$+Z%p8JN?Y> ~"l~/ F|}O4ܙ},)Mw~ N\AceM!tz+k{2<0,&*'	sIWtRUe$ޜ%e}TZ'<f_*+Am({82QJRR<?j+|MúZsxwiѶ 7Mt.# o'~ ?n 
xOSa/Ǉ<
cg/ӯ1WzοoZ77P/}3'dYe<tWrvRQbjjNU'⢟*+ p0*JuڋVbӃ$҃mLI7z_U׊uɧo+XaŬ:Yc-k-jxf2ɢ-_[G{M/Oh$ \~Ҡ,ב놽Eo5mh=6R=[vgR{1:$۔ЅIݤp>n/>(</*iz
Pby^H$g0,v2;'ڦn{c῁|5\k/ o]WgԯgIont
Nd5x'tQ(-55g$䮻XJQ0enko'wQj.xm3y.h  /i Iߍ/᧌/Z
zS/4ͻDPw$RE"\sWGK:aZOz-5_UεћWOFt*I_qMgc[`cZwm,
"FNtǴgkV!e_ZuZpAө*r6ࢬ
( 
( 
( 
K0  ~?V|3	 &#oZ2h 
( 
( 
( 
( 
 <M B}~>.
v?wWm{ؗ<<>u]r2u*Kݗ3n7}+99 ;w ҳ7^3s-߾  ) rw % g/Y+O6?I3d-Zg䲥K\n~3g>g9<e O9wx)ciZ}kWs +ӲwIZܷ|ƼZC]o?h
>$΁8.<igm;UVnn'.D\٭֜.ƦQ,>㵒 ,ErѱEs^G岇Lu(4TSIS+s5+'~[am)ZpqQr$ގ:[ͨ'D[? b~?~.my 0_a5|;yl?yyWgWXܼ&nv ¶_OArЧ_Gy U?a r|/~/#3]E{xnm6M2mD`-?GK
K~?AGb
jɡ5}ZռiӬ$q=ĶkE~k̫I8:׍9=ړrl/v^zCØ(8)+Ɵ/Um֭m3y.h  /i m3y.h  /i ^R_
vߛ1^ggRm?n~ ;G'~&M|
gៅ*n-4{8DZҬIktB?{fh&+v|Y(SɪTҊiI-zY#=x?xέ',WummSVx><A%ƣ^ڥܐAKu:߱7_]j?#٪x\o|-}C//籠ˬ[àﭴ]?!a0XߙɸssFQ<76?9iĹ}z(ի5(J\v\<%nXjRuyϋ+tYchu+bU+`ͽdi#nu
	!x_EUouz±%Ovoets%̗a :) Jp˭?{Iִmwg{;E9$S7v:I+tlY[yf?7 j] M^> q[yf?7 j] M^> ~Ok O?ov[yf?7 j] M^> q[yf?7 j] M^> s  :o?bO.{`{IB-H\xKRPqg*\y +agO껿Siy?pQ@ Q@ Q@ Q@|%[?i>  p eOWݴ Q@ Q@ Q@ Q@ Q@W& !>я;;y6NKC:ott{:J_k˥?7sgwnsqYϛ /~ O9w~s  9?  0 ?k  k;wk?i϶Nt\Vc%3i 7*\3tZkw~VW
wޟ7sgwnF_=cL4賴ږ=MGҼi3[ξ{#"sQ(aʬY6'd޲F*ɷ&4䢡~ \?y:7}RwKbv/^jwڑihVJu'$oehG(E+$G6W~&֡_	|$ӯ#fGF|WصmOrj"XLs
vߛ1^ggRm?'T#~U^}[smSrNɦ֭jZQc]o)?(OnVg<?ڗ~m i  Vg<?ڗ~m i  k O?o}7c3~߻?7񖬞=վ:qៈv 7> !c:@7>hWTFܯBRh8 ?7vxuPKsg}9'n[
 ׿|K
߈O3A>Lޫ!,XjTcӉo;oy/3߳wG6xOMRT+9cgG+I^*kINi>WVSGGsI]E{h ky-J2\qtoQ,hOk}^}:E
uwwu:b*I#l噉0$M*Wu(өuoWdokkZ7UEgUNk%ɻד<o륧ÿ	]W/s2^~ȩ'.I9Roeu:]uN7[ Z3l"Eţ.ba\oKT`6F Iu=&ѦRu_jPi/jD.n\ьSVJi*K_4,SGRU7c3~߻?77c3~߻?7 & U?o+:~<}RhM#h%iqgxS&)#є'uuCWyL<
xEoWo7S4 <pQ@ Q@ Q@ Q@|%[?i>  p eOWݴ Q@ Q@ Q@ Q@ Q@6?py~ 	>:Wݥ冴xz5Ӧ23M.S]bgй]-Ab09%FvIF2VrZh*Ktktԣ)Eሣ
Ԛv177 ކXTHId$ܯ5]\LpZO?#qˍxFn.>wxQnb>]AuJFIp	ztNdi=uc8}%Z}V_|ۧqr\My+2|Qmj<H	=Mcm0i.D"Sj5?/O6^j2J/oˢgƑmĤ0H`ZԱkHJ=]]:*poVKtF
7h춋Wh;_G[Ռ?,~O!8@ mwm<#G G!WMy=?D40+V=AlE
K|g`19VYͩj~wZC]u把W~biSիI?u-[mo`Wſ Kᇏ* /kþkc͆+oOXͣ}	ko%ڣY^1bjҡVbmMޛIb1RJ'ewdn66SO/6c j 𮡩x67:. )>iT 71=s
a!NK+DqM[Aiw\]s[_I48D+qyMI:Ύ4c9B4i/vRk7dU;G,U2zF.LD(9JJ
M.kϙG
'.|^Ӭfѵm7}Kt~D2.Pa<K={$2jEGuJvߛ1^ggRm?mRQ\75uviVI+Ya+TR烳DZlOz
vߛ1^ggRm?wt8~#I֒bIhQbw^Utp!O>7ws<ON_U
9NSoth5WMf8L6?
]ԧQ8'MwO;mo;oy/3߳wG6xOMo;oy/3߳wG6xOM & uaIXmK[ycm%#Q2+FVi4PީY
CS?gQ)%,maGYnDqwtlK2
S5
j*[FN:MrSI8ݪU=1[yf?7 j] M^> q[yf?7 j] M^> ~_k O?ou[[yf?7 j] M^> |{^|=%BF2,vI$l3	^> wIF3z/{ N0Zi W  `K?o:XGᶋ]m>e֕=ޥj+hM̗+X'ss{.&q,UY?^'
Nӷ~1W
B >WAPE PE PE P_	~qV/Gφt 2>$~ SUm PE PE PE PE |% o u z|h?$xជwpxkˍ'aqz#論+{xVC& R? /x?w/N<ok^%i% L|3ɇʷ" ? h 7 /  ? 
C}c=S'Ǖ G]l?h__¯|/fuk)X|sx_KYp/nI	y1~ޟthokJywv
}t[Xn|!w-,|LʬOOp]
{W?x/ǖ|y,״,wE'YM2Eq&V|dPӨwF55ENRKIY%ԛj},rz-d΍yn.oRhnn9#.YdGW,n7}+99 ;留(*ptMB䶜/ sk J|xsx9~d w<+
7\>!_𗍾9kzǆ|NMѼ?v$^^j dS|2,"<MÖNkBwS]<'ouU#7
[ 3 ,x  ۟ni f}3GL|/g+Ğ:о|<#ᯀRڕ čjM3:Ư\Xj"u+]k-5~}ϩ^Lk~-˜m
N WW
 s4~vXJ8|!iFwY/o&>|-O/u-s~:D5^
FmKcMm?̱[7Os0w03~whn

W5Xo-uIo4^QI
Rke%yg[i䳌7q ܓ	kU9(M-97
87;rRnrzMQrt-t\6 WtIc}V:to1kg=^#ty224wrmG2Aw<,gkRt/LuN}"1B^I$Eٶr\L&`iAhIsRݽ׫z^
TW{I_]%5埇<06xQM۶b-mgټ屎Cr=|cSh}
\Ezeu[axבLo.ViLH nth }zƣj1t"{mt׽V_=;ydrNwR|m3y.h  /i '2ztZl7	-4w5bV FW(˘$yԃ}[G}_KduϝA5yt=6j7>Ѽåi+\Oͨjn("{Ǆ2̮Ivd7\m3y.h  /i S*%RU5y/K*QN4_mPVg<?ڗ~m i  Vg<?ڗ~m i  =< ɿvVg<?ڗ~m i  Q
Ǎ[υl.5˘L鶨3 24_G4w+aܩl /ڲbizoj~3_/puS⭦O+[[YZoU#ķ:Y	RGoѸb0Mߕ-oKۉƞoQ(d.
+
( 
( 
( 
( c8+g# Ug: ??n?|v թ*
( 
( 
( 
( 
( 
( L'MOǞ"%WE4{O}x%ơiZK#κ7ܤL8?AXa1?-oټK|`weWI͍煾a>ոʝLe(٩Y?ummihʥ
5/U{ǟoi1IS
Vo߉tdiAۤ$VYXBkiU/ fOPwK0/?~
|Goד`]CJ|Wuqwȿ7wZch{?sTheܝPQ4MdQR^z~?~QOڻp<P<xİx*<e6TkoaiֲhzieV{{s|֧*xǓ/A-΍hK{~muX*
B?*YC(3i΂FQnn.Zn6 5zy<C5Odr=%Fti'
;ggÿ'Eo'VXYqie?e~6i~΍jN>7Rk.O+'d5e8I4R+FaNx-iݒS3Wnuuek-RW]eE|BW
R"J+JI\ϛwM%| 嶏8xg]ڧ<]2x9vzk\Gors%Ն9X['vo|7kZǏVSwh0usQo&6|D7P6[f0S|s_NVڽJtGqDMG܄a;{^vӕ=}>g#Пç 2eڍĖWOm{ejK5+WDLr;Y=v~>GGb=kTI`tF{kn^fKF{I
6"'=G+[Qqi^D{0΍gR*ueyTO1\j'V =.=6o?:&Z;#5Χq{tAbf"kU<.k#y{I3&$ZB2K}1Z72y\4˚ةJ& \iEӷNGѧf'rZ<%BZT\ }״nIKĴ?%f96(zVzoM_Gkzm,=?6ĐZ5۶	Hu	{>o	@X?z6:<;YR5bgd>6ڥŝ̗z4
,5%R"
չ[SJ%u'8	p&3R/Zz96Tg(&&Y,o-[kˍ3P+;[:	ݝi州dyI"%yui7c3~߻?7jJYZQm5ͳZ5~iƭ7x&tOc|eKn
yb0#"ZiI(ds>M˰G=Ȗ%.NWM
wE7hԥ}Kai{G Y? mЌ]E/yڤ_Kݽ+Ӯ1yNEY>t]5^o~%h_׊mn#AbIwu\5ԵIs%C΋$Qr>KP+8F;ݩ{gz	kFG}~KQ_X|Q@ Q@ Q@ Q@|%[?i>  p eOWݴ Q@ Q@ Q@ Q@ Q@ Q@ W/S߂׾(|ixCភ ix͞|ݼpM4Pe ࣟ
5?eO;˨>(|WZTMw@
[I44jZRҥѴa-jC~|AOę<GǊtxH-cT5iz%4ыԭukk/3:Qa0irΫTʤ.g94ԹnԹec8OAIEXNrQ|i]^o|R<U _|TIgsh/IO&koVe.nu7G{[?b_?ઓx/xA 	:WG-xSY.	I|ً_q-_ygФ֍%&ଓM[/xOuT0󧋭ϪcRNRiIKM%ˣo ~4|Oo㯆5/giv7ҵoT>,mJ\ɻϼ帖nVN &7 [E{.7~^1fcy_:.!
tba<7E3{̃*ɧNܫݛI%FZ$C<Aӟ3')7)Iiɷvovߗ u_+_X|Kφxguox_ka7{O3Ⱥ7#WĿfV-g06|.-&kS4'HZvdɶ3j?aݕ5988_ĩzriVԤ&^xZx\^HBjJr)Zt(jJn}9Y~ ? q#ƾe?|IƥxwIu߳7m!_.I6GVc
YƜ)Ri/w˃jՅsRVSmI] V<u$  fdQ牭avL㿋PUeEԭe>R~g, ] 	o>*~ |^3n3Ú.<nJ
ޫjDڤNi"ET[s'.*j5EI{%ME+6%M.W3~q<5<:E6OE^$?><e]yy
?7f:c>-OU[_/2Pv5%Ğ(~>Ҽ	O[19@:uI%oA,Kv˪ጏ6+6Jsqݪ{HKڨI{E`8`vJ}myGt/Zv]5sj#S$%ķ,RX]q"|EzUo;oy/3߳wG6xOMژU:$UIlI%I:qNE͵vVyٳL_	ͿCw;ќ97wjU_q桉wߧ  0ࢀ
( 
( 
( 
K0  ~?V|3	 &#oZ2h 
( 
( 
( 
( 
( 
(/~Ծ)&񵖡qk5m"h~x
{I<Q5_I}=COm7Ș_엣=~:>0 K{h~,״.]C$W>#e7.#y^{R[j:VHVs? g>n|gGeޏFZN_e-DA_&dyu1cVK'[ Ə_7?l
E7z	Ktȿoֱ}鋥\ZIyksgy7*8V#%)TiEYRl&+2,1cG-II=P.gud+{ZYL|W_ >|m[w ]nt[OJ{]	Na<]͜R_[j-i
ڵ7&Vߎ N + 
)39vd}O o/n "-ظ⹕[k_^.U&]Yۥݽ.Y; þ |X  pk:E;;xItk+|Hfo_Yr7w"?xZK|SƏGF?j/t+yp\[#Gdx1lr哊^IOk}k7	Y
~%$|mCeIº7/ ko#LZ:JWhx^+{U:eM3^i|D|^?g??isH]fSռus:׈k;UHZ/"cYI:N
iJ*񌛏&<xܾ{O,<eR$\=8MA;+=^K?z5 <Mڶ\klqy{yvnuFXmcM"i`GQcO_h^%_+H֬|5j>'
Oe6}=Yӯ 9Hլjٌq؈%Jo
`Gk%em+x
Ù$#XڄQrW'76.ox KSG
 P}to?]yqo0ʆ,2Fg	0U:+
V_i 9Z4R+redq<DVKԒSy#qy._nUiZJ/^I6.>0vP7ĺ)AK+7>KKé07FJh7څ9 : V]O~ƧlhIG隓i
֝d㋘;X,NugZu_,뮰{M3m|CM|*>8C7Mb _x3۩m.tM̒j)wsh-{Y5Ot_?<M: :ӘᲳ|H]V4f.	 OtG;3\"џ*rMemVuGreDyJw{$W}47ٳL_	ͿCw;ќ97wjU_O桉wߧ  0ࢀ
( 
( 
( 
K0  ~?V|3	 &#oZ2h 
( 
( 
( 
( 
( >t\|+?uQTx*jV-PV%_b:%o<k᜾5~ k|s;?<Ol&УMi__

 sxG<1oxgO|N6pX66Ѭ61Fq" = |a~l> lu]N\ѭ4[GI&)p&e}e$7RiCy꺍Ѽr;T?" 7#>a[G5]_Y٥\wֲ	Y]K4flV8Q+YNW֜5kx>[;Xbe**CGm*BP+KUi:/ ¹uF-t φ-SĺƝz妨euе&o
O\Zj	5J⯅Wi ]Ԧ* -+werǺhd)F9I+/+?>x)|D5/ukk)Ao;4ɧCkvx"ݵWrEa>ZVMIgz3	fLv:=rRRRm.M'|{|[>L |5j>&NvVN_Ou[2K1{FQ>Ү
w>1+ѿt ֭oU嵴6u)MI}}>K#սe8(b_+JJQvrqlg1bxg00rrҜPFZ5:Pe-W<
xSkxVJtORwF85q52&_eSxI۞Rw%vk%g<>jJ+-l +;7~?i
i~C	Vk7\9aK4cxġCE~~|\ " (0iVK@8X#HxVO]MD~bF.%X c
G᧊1|%7h,}ORfXhVnuOk^ ⶒVX#i$FRb{jعTJM쯢k}Oh ( ( ( (?ୟ_U  d ɸ|H  V ( ( ( ( ( +;)XVxH /m֣x[;{[k=\_iV(5j	ykgoxZ6 bwΣW^ }~ h%ީk@  i/.8l-e6Ք Q@ Wv_ӧ|z__6xH SVY:muZI`>yu#ĲՕT~&hg?^"Fgizw4vwo0M)%Df |u 
*gbw
|#~ #xwL?u(gAW ~xA[C_/5敪i|2[]Z4>d3Kq%t9V }YE PE PE PE PE PE PE a ' l g@'MG<e_vE PE PE PE PE PE |.h ~4~׾*ih6WIgm#^ST&ynml`w3$rǎ ?n>x^ꚢjw2P+YH7_ҐlwSv$?S /~!E Sz\N<=zQ<7~%-;yp5<
'=|^Kz?ҦŞ=7KڦɭkDwԵ[7KxgO?OGgo^m5	4c^%ukgYcI9,,ѱu'h <wǿǅ4 |h:M.
˴$եYm"zpJ-(d)2>s_ |KH:4 =={{6o-% dOJeu=O\  ( ( ( ( ( ( (?ୟ_U  d ɸ|H  V ( ( ( ( ( ( (>7~߲W?Əٿ[
=4:~*1I,kЪjD-͵͕[Nxd\8bxg{VPk 4=ST^VMNP%k)[>Ry  
aß?4c}xOWkgQXj7#gĺEGo0  OÿnW?n-֩M'Ϝ=M;_/>i$WN_~O^꿴vɥi>EHm@iG Unu{X'+k[M/K ( ( ( ( ( ( (?ୟ_U  d ɸ|H  V ( ( ( ( ( ( ( ( ( ( ( ( ( ( ( +/N;
 eH Y΀9=9G ^/7zNIj1Kx>ou+g]Sy
+ <?- - ǟG% |~ sw 0 ~N| c# 	ρ yDZ>?9; Z??hKG'>@1 Ih ah <?- - ǟG% |~ sw 0 ~N| c# 	ρ yDZ>?9; Z??hKG'>@1 Ih ah <?- - ǟG% |~ sw 0 ~N| c# 	ρ yDZ>?9; Z??hKG'>@1 Ih ah <?- - ǟG% |~ sw 0 ~N| c# 	ρ yDZ>?9; Z??hKG'>@1 Ih ah <?- - ǟG% |~ sw 0 ~N| c# 	ρ yDZ>?9; Z??hKG'>@1 Ih ah <?- - ǟG% |~ sw 0 ~N| c# 	ρ yDZ>?9; Z??hKG'>@1 Ih ah <?- - ǟG% |~ sw 0 ~N| c# 	ρ yDZ>?9; Z??hKG'>@1 Ih ah <?- - ǟG% |~ sw 0 ~N| c# 	ρ yDZ>?9; Z/wfn]Ư<^6'<j4mA842(cUmC;        . doughnuts.JPG  	@       G K   q JFIF  H H              	
       	
   } !1AQa"q2#BR$3br	
%&'()*456789:CDEFGHIJSTUVWXYZcdefghijstuvwxyz  w !1AQaq"2B	#3Rbr
$4%&'()*56789:CDEFGHIJSTUVWXYZcdefghijstuvwxyz  !    ? dO?_ >.|\wktm'X_QvYYoeekoPAx$K  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = |s  ~~eLwxú5/ƛSOonn|I$3ysCrpH?t'MG<e_vE PE PE PE PE T~&hg?^"Fgizw4vwo0M)%Df |u 
YF|Tek_"şugⷰSu>h.#h͟XT3??/ u@,_*GIO /#$ P 
 Fg S   H 3 ) wT  љ Ĕ ;?b R?  Jx  f %<_ XT3??/ u@,_*GIO /#$ P 
 Fg S   H 3 ) wT  љ Ĕ ;?b R?  Jx  t~'1 e _BKΝNHYYj^f
jcWm'g	;@ Q@ Q@ Q@ Q@	[ S_ ? ԫ K	 &#oZ2h 
( 
( 
( 
( 
rmڻPa6| >-~
u ٿᖣtPy!.<zu	WPԯnjZIhVYMn'_ QO)oÏ'|1'caG'?sxY׮tiCj_sI
M	|#
p ÷`ώ߶*L 
 ko#KGY5ד P.* 7|GK. Yx!OĐjO}sL˵-`i#i~S~f{@ f}?@2x/K7[_3 jKX턯tGƬ+; x'PgSwxsJ<OxŖ>-O^BjD676et<=	 oI^|LO#ɣI{q+;Cöskɣ^v7:uWyOm<&@{	KM5 ~z~4ėQhCw]&PԵU6owZoHd_
KI~ѿn|hOѵ	>[3<C.bNu:jL+;]Co
հ=
x
K	CT!{T|`睪j5mF?&XKyr5'= ?c]G~3mkOZ[ytNISѡu+ym?I&ih;LR *ӣx
GZxO 	?pܲ}N4(O&kQ'/-m =T  ǯ ' { { j {'[_˷|nw@b+o4෎/hxM/j:ƣgGi^nj[ŸLu1?wd~/?V{kr jբmSJntm4SO5OIc T?f
|B<M?<M}}ǋm;#^-}&	-.bԴWIv$Y ?l3]8|~MmOZkxNoISѦtKxmAG]Y>Iwh"#Lo |/@=S4k=WK|ϴI!˚Mv8(#|V|x 	oO]Cx ûL.5ܪXj:24z/o&kZp >>2wW /mj_ZFQCMm7'S:kw9yӟ  H 3 ) wT  љ Ĕ ;?b R?  Jx  f %<_ XT3??/ u@,_*GIO /#$ P 
 Fg S   H 3 ) wT  љ Ĕ ;?b R?  Jx  ՟g¿-.|Y[Yn +t\^-KŌ^}_oC O;7^l]/Q&o"o.he9$N ୿)jUm |%  p eOWݴ W/S߂׾(|ixCភ ix͞|ݼpM4Pe=g	o I1 G=g	o I1 @=g	o I1 G=g	o I1 @=g	o I1 G=g	o I1 @=g	o I1 G=g	o I1 @=g	o I1 G=g	o I1 @=g	o I1 G=g	o I1 @v@K⇎?n?쿉C/wR5v跷vs7)$3ysCrpH?>~L_Ko 1>94
[úuǈ?=iWvpy77y.;o2[ ?#пᇿkZ_@E S e 
`ώ߱o-/C?5 _7;YoM} ^| 6݌_
OF	&^~EcKX:}ށjRLLu[q<fR?Zl '	/& 
C	}/zn66-֙pnmgEƛjf	oD7>3/jFO}[*|=şkz|Z+kv[-w6KG=C 	h߆zK3 
|#}>&MBaF^LtA/D t> $xI#_ AaZj ]OxDŞ&MalUGoʼFKǕ> ^ +_ h?   | '? Uڼ϶ o+lfϕ' a OH)KZ ~,𦣢}[T]nNoyMŹ6p~{ .|E O	kt=C״}kg>*;fX|BH$y |f t7ĺ~ @qsSV Aqjjngy4^y y v~"|k-?G.]E݄07vZ妏5$ [C,20%w= >ſ3 +k*_O/gPտ7^O '{/翁?~{~Ծo??x.[MSCԵmR/jzf.U! iy  k  K  2Wؿ= _+?i ϴl O_	s/3 kk6%Ɨ=o= 5׼_RĞ&5ӓ[K GKIv5[  k>?_F|Ek-y3wU|a`k/*V=| ſZxû[L\iځ1vzgl[&@T' Y|/gM i/Y;xKÚ.C滸?m4ֆ3-}.|&/7ƿJ<#l~^<<so Ꮅk 4}cIwcx5C壟S7I#Fi]Yc @ [o-oQ4] g i gOؾ/wwk_Oh^u=m%abrsi<[+2(t ?ڷ[//G?i j +^1' y}w˜ d_a+g7c}{
o 5O;7þWT|dȴiag؇jDpH ?O>+o!x#POxMԯ%|d[jyQSmec`9?oⷂ>P<῍~%#ci˗s:\y1oyѮYH @Ə~@V<g]6o.̗7zbJnea,*w7
~߿֫U|#	t[Z?u
YucmqB.|Eok{qW<ʯlv@~: Ec/?m~>տgtRC4hWPHn;MOS!}4Fvrࢿ)'|W@hZ.W[kHloynBw;n$졀>ͯ &_٣UG!};@b.aǢHNof7:<c:7L zQO 5  QJ?n?|v թ*???Sb'_Ҿ&h Ǌ|wK:LNYŖsDFO筄:nk^7?f_(goĿ?Fm/YגU:ּ[kor@" 渍@?J?oCoHa|i|3wgluI 5+=."+h[l31=l~^/' _Iuy
kW*֚܋KNOǟgƿڇNO~.Al+%seg[۹V<D4>/_N7<_⿈ i^a<!akyeMB]DCޤK!kl쌠_7k~4wfEW4ѓT> 2iKba6TR W=D#|!;?!xV<YxFRˊi㰺XyaYVe >Ec//&/xC'o4-:폊쭯Dfel؅1>+<)~kOմ}cIVf97I#ՔAI?d N
Mែυ_^4?/]GVTtx-S[:A=يE(^*@ `=׾i~Cf ixw9jwwwQLnIQU RG~<1xOּii7716G<2$r25= ~x	om f;CP^"=q5ՑX&?Cӿi?
|G7~
<5W^/u7ʺ'cO]Z]Z^XjZ~D.u9y^[h@>>  ) ি@~! 9W im_OO&)a||Lw# ٶ>(.o>+Kil7Ҳl1";  _do |! a5i~# ^5u%9`7
̋P?To, q?|o|;#zEwDv:m/h%oSAi}-wS4ʘRv ~ԟ୿ d@<~_W=OS[A:N?PMy{|4? Uwk߳A|+_z7&@=5Acq
 ?-'v/m@pOٗEo
|0c?큦|Nh.,6?;rItoXt)5ZY[xfY4gk;oؿ@p>	xŞ/_ zxo+kZǇ/j!m֖W-EdZm-DϜƲ]N\:F )ao +xkgŐ+׍7cxKTXK#RIe@uoB-HW* ~?e- 7 u + jZm?+Ԧ|Mo\\|.%jo(෈~-x '/o6$x~qAix˴ad5ۥߙkؚ~[yࣿQٛ  <	]?L WG5֍1}K	;vj)| * >|L!3K K7^o4SNW[]<sCC4X+OwCφ:C|nUfN]N~k h;X
ZA\GDY _|G1 Xu?So xc
׉|V湮j:Tuoh76^c=El"Sj||ko >%wU]n=i7RHaԬˇENF tP_	~ qI//ωtm|%)S` Q|{~ Ś7+NgxLF^O]o/)hm9 |R'GýK\CΈ |k˝S᫨9u +?)vV{?7?go!~>/7MkR~Gm}qxJO9~ҖV{K!y.KF7	kR~?>9Dh[ >-/>-U yekPjV~w}qwj=fd7 Mz7o?|_g |u7įjZ~_xEմ gND[FZ[oɨ[6&QmC( ~ԟ ~~Ə ^ !CO O 	7Gk}]K5 Բ}>յ9y oϋ?|s|Oc&Έ߲wֵ֚[6\$
̫,!w|F@> %$5>%k < 5
[ᗆ|oxǚ<U !tJ4	Gw%m6X|K ^?iO
/@ zl>(u{k5?V'[M:ɬ,e$GyM"V2fPo +|{A [k|Y῍=hmfړx[ZKzsۭN=BMol7훩ȿ>\C>x6o^k厽} >a%4|ŵAf+g0o7WşOc 
߉ߴkZ^l~0x\xe#
iR]3iKggxVMo
2Mq	+^h௃ ^:/xO<5뭭AåKK%/s{[X?-// ?~|Pп>@|--77:^m%u4>d3HdN++ @ſ: MC]؏QO/[hꚇ仼ɶH̚iˊ4E݅UP ?n?|v թ*?/*>x@5պO<Yuyghƹjm/lxsH;H%4ie_?MZZD(xK$)ᯀ6~  hk,Vힷe͛ZH_ErQ#*B  L S=-
KG oQuymZ|3.leTF@v,? ޯگƞ5V|A_~ѿ?Zύ<u'\Nҭ"u[EC5dFGFiuqjuH(x6ӼE ?G.7 n>ZN}%hisma\ݼ0	#ԧ*Iy#F7 g/69|\p'nuKx|XNthxZKxo/RX!kUHi<bLw~>9. 컬Z7>*ҵkKd(Lhug9
l߱fMxZ .&kB*/5 ^1Jo3*F S 2~_~^1ռ; t.
j>$bMsC
S> g2Yi-kmmm.tDik? _a_'&|M񆁮 Zjڗ}#Kka/y_h>,Q_\]J  b _OO&i|Lw$WMR"[{il7+1"ooSR|^ |T5  A[g7ڮzýXy"NxEjbfDY[
?Eؿ	5ǿ|Aj< 	.t 5STȖf
JLH
KY(gBzV'm {qk=	J|V6!KwYe״I@>>  ) ি@~! 9W߿(_g=
Kg+YjgVz>Dv0bW6p6_ދ/oٟ
vDZ_5f-OJH:}Mus2@ʲ\LH?g|W?>C>6Fuo#֛_xJo1.y,&m-d`hu-Ƥ |	-> h ("_۟_xH #G})ƷgleL~_"fυ?'Ɵ>@<SR%e_sڴa];W +}; >?i'/|1ei?<{χRzN	omM#X;I6L
i$O<x|!EX|5_i>f!dLTI#FXYc@?~*  CខOF?wF?5= cҏ[<<\n9]?|O
mk5cV֛w}xVFC&}2Y]٠vvfM x'WZ5YKÿ 
|9`hv{ǦY}e'kأj
>K[ ٟ,_O <^s+gρű>3ؾ^
 /
~oO= O'Kþ(Ѭ]/Q&>$o.hb7$HwOx'7d:ׂu|C4}[:ݎ⫘rkf}NXէuvVE }^mG~	7xSP77Mޡ&u+Zncs}$qB2[Eo3GK5' zM W_wK ] }_	~qV/Gφt&?<s&_f/~oWN DMmm4h|?{eJ)ɺwӿటf 7+@Fx _>xJ}Ų]ik>x:8&dWg dBIW5/Ce7hwEcp\ZCzEG	KZ=|`>O1ߠx_j?\x_\\tHYӬ-Ou5ƛ,"Ke3=	bi~?euoѿ
ץ֭4XtV{[G-m5ٯ#i9l]&? o_QNJO|C_uCđlev6VVtѵ\+iM | -ۚ?dCN_G?<!$~0Z5[CmN:)x4KinnPj
=7=a _Rx17ςZ/]x:ڴh-4֤aJayjt׉5u Oۇ{o-o#?xW ! _4 h> ǧ＿/|
( ?T OU@	2>$~ SUm ~&~_/o[ `*M
?Ug}iz-reKҵ[i τ?V?_ßu
|!rk
+uhmo\XkEIq
95"M=Zb@<wx  -><xFڟw?%-MKqii>N{w6s;.Hѡ'|` %	l|rx#M?u&h+"MtK'Q<%i>y^hy%c o)QxƳ-Yt45~Xzm-,:3^]sJrdS! {
aw_ב\K/kT\wXkĚzk,PA4"<۰0~ 
 c>ϠG:X  	}Eǉo%􋙬?at- i\K%ءnKN?c/
kxV.iâ,tN:9km1/NyU3Hb1 ~k>:xK( B ?' ڎ:OCt 'Y	x^=iȎ/Zzsu(|$^Sχwc{hb_W7vXITyW6}g6Y
( l 8$c Ugĺ  K
 (   _= j fG_كß< 	'~?ON }.I5Mfu-IiyJOg( ^)~' 7O?dσzK
o3xuǅtKWC텬Y݌+n?Ӓ6?lo&?p?f_` 0x[Z7=oAi/.kصm+1zDӧ-n5 t? ⯏|) Ao/&ޟ>= 
M]÷񽾛)~ukz[jz/t';Xm"Gџ 4I?w-G¾'E|+#-ŸoK@د7Q	~xռ¾]ZftK70^_ZE6O*ۄw3Y[ ( ( ( __UK0  ~?V|3 f&?/G5>9.5< >G,{| hjCE No1e>y6d.HD_l3)x?S#;[msY<qԊ=J֭ncլ/mcc[nGiU<wǿI_'w?Wͮ̚}߆~*η_hv:Ɵ.]3C\.2.ҙoa羻 |?hړ^1azsƧ:[:Gu/鴿;M_wvIl58bO?^<+_❆ 	7f<QK;]?fv0Afc?~?M7 {R>牯Y-</y^'ѲЬ_+M5OtL
< p n7~3k>?<}R4<u=_EҴӨ-
k.V2AL`w߱I?u6Wş xk~x^".)o3?&֡fKe-㥺^}&T@O;	_oP񯍾 |Nşk_E[Ch1! SnOq-G@ Q@_'?n?|v թ*?#bك_g j X;_KCź-ŶZ57C'SL K]s#}I?'/QR5O t{3"麆oamVXf.zב\-4<d?>?g!72xT>Gc/_o	i
x7:ڏzM4H/7AE%辥 87n~|-?ۻ~ 	Gޗ[kkO

Cζ6v[OqiB/ 	'<K/$!{=z>^{qխmM)3֕ vi V) !<e:OxK4]ZW^%tWu..Yyd}/G纚KYoo^tbJac_oCP><t}ƾ[{xn%KQLZ;Ee0	 z)࿁_bץx 5IC7Y&4׭ll/uP3 o?uSC'ï	'>')|Kgi_ۗ6Wַk-@&1W2rb	V{(%]@ɽ]:lpsEf @ ` ¯~ž"CCNO[(<۩vn??<yx!xZ=G|Kja-ᕤLWHEhUd$@E  '  @v@	[ S_ ? ԫ ( ( ( ( +/?N;	% eX Y.>  '/ 	+ 
kGп nVS &G?wKo|! |Kߊ</n?u/~ͯ40<Vnq_bT x{	 ~| o^cڤd^u+vO"]B{k]|V |*ӟ>?xoM/ c	xOϋ_/<= L]4fG-uđFv!VؿN??,6h/xu^~IKcƓj>䷻F,өY$ވS Lo
j>|Wg{4x)SKz",>4.ᅳI(΋."[ؤkc\/~7	 7_WEyF:wٓS{tf|E6B]?NͲs}SHEvWqGqvl& l_*)˚[}?C᭕׆<E>O_N].nmhYNxH_{;o6 b/b e 4?ji4/\Ѯ<mj]Ck.{k6{VTa5GΊ ( 
 S ?W |%  p eOWݴ?)| ?~P-3_/x_YҵM;ϸEݣ4>d3Kq%t9V OR>* 	>~6|7 F <Ej^/!䚝w꾽ke\LH;M_YT?; {_tSW<_[y>-+CU T7VCR܄ M;qsZ9Q|oqk{Twoax#UI]>h>ԉ}-җ7]	M xm mZ||j;\r,:͏	g;]2Gk[ZIlg4Zi| ?~x¿ӱ:eK MsYuG}xvom2Sy-n->[h5;.ok?,}Q~?
_5|+znt}?5SJdS&)"P؅p?{g_; o?]x XYj6(<bG  } $o+O/ j<W_"~"tkm/λ߳LK>?H/؋I6ſz-?x_K/u(<"ҭXO틻9?*61 5x?
?b 3
aC>ị|Ik=Sok^ڶ7
c.\b@M{ q~ҟ
^c;KoViltFŚnd1Sֵ?A%|j[4AE  '  @v@) D-B>2tߴhꚆ{igr4ѧ+.ʠ'OƟ?w|;}GK-ɹH̆h˖4u݆U`@ ( ( ( ( +/ڷ*	u-,Ѽ⿊z?7c7oxf;iyCos$ v_w  }E y?|Ə> @Iuy6o.*֚neSrw8#I ( ( 
 S ?W |%  p eOWݴ[& `>1|3_<Pkqf<5W_1,ww
t!_?G)n{i<It4XK	;v~ԟ߂zb|1Ծ+ųYxWkoq=חhu(o hɭ=A-AC?O ğ>4zG'|5}bm*;
^jVz픺e}6h䷖(9t ~?j]w;o>5kq-ֵXj[jz|evɛgϟ	Lύ_2~?hBo}Ρjq{MhZuMGJSvlV"	e7Qm,(е*=c_V|_I<IP~C&
m;[MjZ6LГ:9	|5@RE|/^	=nMՠ4jյhUkt]<@H ?\h ( __U( 4 %'e٣UG_b.fF9`Nof:PL" ~@ Q@ Q@ Q@T~&hg?^"Fgizw4vwo0M)%Df u#s_?l ԵI۩@wkrw:KGO6Mŕ+}hK0  ~?V|3h ( ( (? y~_L7_;}@Z= ! m?dط!G /'ouuoM} ^| 6ݍ7G <s'{?|[.&czuK2m3Ofm?MJ #
oj-!t_i+mdV04AXM[dT[1 	 ;/uzuoz﮴?~
4k]%X\\Xz@nKwVcKe ~NO/KE|I{cj
/|ENG^&Ң[ &g%ŕ8k )/|2 8 <Կ Z~h|5c7{O\e>k6̓ ?o/))~/|狯5m4]CU6swo-IfV-y{  G~߶ <k> 	>i4{cY NXyo7kmⷒPpKÚw+oG<W=?4
^Yj&Yo uuuO:mAi g@cGQ@ Q@|%g $k>%ݴP\O?~7^_ខ zhzGqivC741L$qP@_g¿Xu-'Fn [{/\^ޓj>%-;5Y3#3#_  

 G  h u H   x º | k <Z?]R?>  5 - y _ W_T<π?~/ @+*GgF ţ#3#_  

 G  kv <O_OյcV<SicF\\McGI]QQ  ǟoϊx7cx
>MZ-ǿ/_j1I77:u<ga&
6h-_,3wn$#3#_  

 G  h u H   xxG|+'g6C5}S:9Y|-wk"eyh&~Sx5^5_	m a ' l g@v@ Q@ Q@ Q@_'?n?|v թ*> L 0?>޿>b -Ɖh]闑@ZF> ( ( (mS )=_C\ZhvmrĹx졿4K.Xg]®m Q@ Q@ Q@ W_PًR=Gz]\t/Ţ:Q_}
̶j	t-.vsC,_ߋx',=ռ}}
x~o}gU(R/]nѵbN (?ୟ_U( 
( 
( 
(+uO  u_'MG<e_vcQkZׄ>N5<W$16~"4'u{x
@ Q@ Q@ Q@~xƣU?mWZF|k,d_xum5 Xc;gn-=.DZS"ץ?C ( + ;7ӿgg{Oi?3iVRmx/uCR}&iϺy%Gcಜ\0Ѧni-mI$l.ӖNezwE>#8 ]Io=iy"+fx@u(E2K?| V4j~~~&Xšx(ceZMٹ. 3[h㌇$*J5o\/ɴHNrb`74]~5I>?H*xsi/t]>V5ZK&6fX(WeTTfb &Ok d?ĿOk	Ş״B.4ͣ5aʩ4%]%s߳K.~s@_ƿlx?=\l/m^ZzYFдpe Q@ W_
?C?j/>1hWMqۍK\tx&䶲w4q"-ƽ<S\Gbm Q@ Q@ Q@|k|hO -|bO1Gǡ|=ҵh{wڽ:G۟*HpkWe<ķ-$F4`~ܟ-7	lچw j-͎y.^hF(Աb'MG<e_v~_>~?"~ߴ??|Uhz1VH&Txnaxh)#4uo7_ >>h|>#~+BiC2K .nWkŸ ?b R?  Jx f %<_ XT3??/ u_=>jOo7?d?|k?"~b},>ۧxm|#͍|dX?b R?  Jx f %<_ XT3??/ uG,_*GIO /#$ Q 
 Fg S    H 3 ) wT љ Ĕ ; O
mO(?mBQᧅ<%7\PX]lk$WE1jdŲ7u PE PE yO)߳#|)m&]JK
;w<Gii\Kw:cgjdFNV
Vŏ}ǿjwz:zcOi2Gckiaeaj$S;C%̓Iqq/^1掆Y M[_IuNR^WObdYod}t K_ ',ms 擄ּ%Z?ci7~LIF7v#,0JRRNOf~Щ	{> Y_>7xIt[oA$:p.^hZi,Kzfij2} 

~ݷu]~2uGmoNזH^]YEsm# maGB"	*J٫TT)oݡ~˿S^_~$CM?/?͡hnF=m^pbv\X. ( (t f;Ái-C_|Mas|x;#uͫjeեi<BQ&⹄C<-M?~ gpxV]M
Əi`&E~u,bķ2~PE PE PE |g  &|`C_bKt\Z(mImlXBL iߍ kO&ᦡX|,˪Mo5i-;i3r/-np꺫Ǧ t?VE??G5*> d ɸ|H  V ( K
 &gI7Ij0 `} ȩ WRevσZ  2gG, )Z-?~l A_ Y jw-?
x>96'E5mcXկ!lmi.nn&ebI%vUEFf k>~? hJg4x+ľ,ixOpבA| 6Ka{r`E P._O>&_}ƭk6:Mm5̱Q$ʨ M|'Jf:_Zk_uXu^qaY̲$oqG*3gR*Vuf~/̸SQڜ[~J| ?d_9gZGmW}><ѵ[&o1NY-j%-m0j2](qiz
( 
(c?}Լ7m2EMZ<'<8mkYisXuiqrKo,hO@ h  _<|476oyeFL1GML_2e<KT!kQNm*ogU8.ZSοhTiicrmE/yY=Y;3+?'gSu"-б=go;丿t;s62M>~"xkM /<ϲj5w^\\3FdG#)_9^apvUji
ߒn7]zt1J
䪕[NYsEd֜ыv? " 4fnhZ?-Tf
*]Ecr^499fVW-at0k]I;mMzzcWIQ@~k~' |pǚ_W>2]tKsSl-MJ[.KE֫Z{E\ҍ'Z)'k_֧O{lQ=Ƿ
^㯍|&5 H	t24iJ4yZmC t[~'=a~	~בjV|S/KK#SF$Vk	&Xl]?w?7:{|}3pn->w /' H_k7m->fE#;x\kZjJϧjvkdjwqo3Zj@~WaGF:=JTjJO|%  [ 3    a  [ 3    _? O??:x	?uolu#u	.uXKc
ZmiKkhK"O	f_+ڃ	_<_'VWg-7WY&yq(u-jIӛOkdKfM  g| 9AM  g| 9AM  g| 9AM  g| 9AM  g| 9AM  g| 9AM  g| 9A>?f
jC>	$ծxkMno(^K{h6bƤI୿)jUm |%  p eOWݴ Q@ W>e_o
k/?"#O5 \uhϹ;|̖5 hgu
B?<!'Xe+kV{-h&Xv)0R*|sv~)xߏ.h+þ
o6뗺zܽ\V3(Yn =Ə~ 5_,h
+Bt&(^]ֵ}FHo>HQkkIgGxZ |[@TƨO>w}n$w(#Hh#=o|	c:ğ:t%%-...&$K[hXdڊm$G~x滥l+M_ 7mtKz_EiczٯԣѮ!ӯ՞-W_x%<X\jھCmcMqssq3#gI]B3|N/<f!Vh.w}|ϱ #^OS : NmAI7|M
L5[S;;Ɗn+J_VLn |+:|UxoOo' /<\XI}iZΏwmp,Eͅޣq5a3&]BU=7SIAZ_jK4\[pG(5	r4k~ySi'|WoxS97k:֟ohƓy
ݎcsosmq4s,nG*3+) Sڟ8PE yWQ_'/}s=6lo|E/uլws$E0aOß C}X@?`~_	.[ix<sis&uxNEH톛j%)Zk<SRתmtua0tUC-;O[Q? ό<  HntkU߅v:ܾ-ﯴ{mҼCCynM?U+mS¯%'_fغ߉mW4^Zͷ4;Mnh<!rVMe5tP\{e_R>+FygvSגWi)IySKUn+4VVWrVK_ςB.|xĞ׾jqC!
ԒjlF-n% )kG`~04Þu@Լ;ȼ!
Al9-O"/pG5x˂1kx<(_½/zS46j\l6{g4T*{J\Ke*svwեkK{_+	{v|Sҿh_LxKOiUf=OW	6ageoN[:67L1ojf;Q ޮ}j]7oMsFV{f(eٍ|9FGi?5{?4
+<ࢀ>S |P'~3|e_f4&$o.hc.XnYIE(hP/Ko▇[Ai^t{)t>PMm+f:B3RZrZ8)J./%z??eOj~2 Qo5gx_AJVh>7)w(zld\-ô )?O>?X^8<1Z^,i ^44//lOqhKmmnmspJp;u>J|3GNOwU5I; ۯn&ߟV?O$T|)<? hO|I.ΗT^?MMnn;o8]^ b?
sڪў-u%,z:?#vwܾ4ϧjuƘׯƉ=LwRIJ5];w}n7/SWwnn=R 	)~7ڷ4~/h 
tM_iui{;IկgFMR\OoO~~ӫxWR/)?<Kk
+Vtm&u5/~ިe'y/ZF~kUQs?ㅷ5K/z]Ejo4mMk[mgÓj5}w
⟎>q}}[k:5qiڄw:TwBRִЮ0<w6KϚ7_+ڃß|/~/mxW^*|k}J:rjWχauM'WeQmEm+ ( ( K
 (   _v_L7_;}@ Q@ Q@O-{čCzF7Gsiygwj^ݭ\Z[qMr/=G_O z[_jjڮkP}R5GR-m#f2[C zM o_?φ߳aF,~"K}K'ÚqN<a&gf.[.\=GmMޝM{h7{mV{ӱ9|_ /\N:?}ODng[Xݤ#	2xM V,VpJqOs Ïfm__V>#O59.a-OP-m!O*DYO2Iea)k߉J4EKWw|(MӷOMӺ]#md?QM_M_:֩c5
v+\]6.e)' e߀!cٚ_ů|Ql+MVÇHþҵ]aus]_g^K{q׃[y:rm)ɵ-ϒ3izk٣W5҄9JUOR$R旺/W8 O:h>M+=/6ֶUv/\2ilͭqoH'
55mZEnޘGiysYuɽc[KY$@Bc_YiSwW׷}<|^[ͲWGF]*Bھ_ ࠷z_>|Oÿn͟
yIOأYvYIy/e١xݼ^Ա4^-S_޷OGgcl}|3WenqZ[L+ j3:|d/hW:pKhzFRד6v*y70BAZ6G!::qrI%v$G9C ؟޿4Q|o^(sP,,${=&LGcWi[V2*G8X< ۯ
; ?׍#kzǁ'{$>L/a/[oo
'T⊕P/Vj׫'p'
c3,SQ5)2ϑ]*q\ҍ ?ǟٿ$a_^/-ڷ|Gqww5oޡ%Ģ0׷gl]<o^$Ӽk_HI,-;Xu]*NXncYQnlo[I\D&FDgt株ӭ?0OTݭ?3g ~ƞ5<+
Ɵ>V5oj\xU<%m
j&]Q丶֤ѯn|sDax>CЇiZi#ۛ3o/mDb*͋C1qzmmh4-U)
C-)~?'{>	/~& <K:։xYЬmjE6dO3E
`/MRg;_xR\ZxCZˌGl7K0fcsؑXO)5=oUø南ۢ?QNcd8l,#:ªR}4t|??؛z~g=:#UF:^l,lU])`Y O8TjSwiOcV[Zr'eԓM4¿$?ࢿ[/o	ͮ-W5e/Iulnm`a)L+u<S\)w+V*z-M̳eyeVWvz$QSm:}۳ `/	ïxT
gᏃ~ X%}gJ]"{kln'	eC? o_
OQmAo/ó]>u1Rom|I4Ed`ӴtMjsȗ׾%|\3;ɴVi̺NjftOgiJVQiI'(2es __ÿ
</hYZjH$o/ _Nab'Jɺ6|߶ |=ǌAm~o]Cg
w"?_KYݼۮGטU<N%VKu*PpVѥv ~Ku?
` ~?,E߂ /ë.}.LE{5.%]BF9/Zi 	 h  7+ x^W5O	k7v--EDw7~ Ym^)dJG+aQU:=jwg՟:^0 TRqvp)]Y=_bX _|@_y1uMGឣ'ú&ᯈ^nNQh
lK+9̿ѧ?j
3	cs>aվiWCߴi0\Ix>fg.Rq_-	{gFÞ(KuZvӎ$nPE PE P_VE??G5*> d ɸ|H  V ( ( -P/?~4P;@|S-K?^m%MI4\0\Q*~])/ퟬ}_Ծ|44(/kDYnu-~+X.9tOHJsҦ]Igk-k꒿s	xy"jxX*N.sjmZJ-FnN-?u+kƟ Go  xW?n^;x(MuqAq wrkEQo > _ে,^ss_.^5-+Dx$x5Ya77Uu18ʣZͧI߲7~Sø,VYB6NTVNQosN-7;O?|Lዟj^./x
W{Qn.b֦5[Cs؟iw%w~M{7߅>
{xzti{xfkk}J3Ko%\'pFI=%_E^:;}[[{+h~/Km)-ٟgkWG চ63t{dѴ]oēbRO""}CZ7X 2U[$wu|LqQX> xAm?Tįa5 u/kzE^G0GtovQ\fУ*15([h0y\*ZnmoT{ T+h?x|s_Niv?5ZՋ7W)]}mOjD_Uy$sۚw}$ں5f#<<y]F(mQQnQRnW;?,2|׆~5xb,mRXdI${yHn x&X6 bGi_m?POh6uhU;IcI9dTE+:Xz-5 o']} t3|4ju!&vJ-6TI=ݬQ=&;Q){m
"wauYZ\5*
#ItEbfzJ!Q',%/	30pqMB)꯭*sx+?=T,5KIlu;n,dgdC#)BJpvkT֍>B&L6&9FI8-YI4ӳOFg A A¨|;t (VWÛ/]k25kq!O[k+ZZMqXX[?-;ZUUsu9ӿ+2ݭkWyeYaqiQefߕ$8[c۳/	 o?	^?
c-E&
C.&@/:;_! |'?	xK
g-bD!:%^EׯP+++6$[yVGwJm){6ݲqgZ\Th9YʥHZ+QMFJU9=io	H#8*Ɗ0@   
m&wl!JN*1I$[$%m7ǟ	? >xSR ƗxKŚt]}-;FAax*D[[<0UDV2/]<9RU2j_e/Ktp}ok
S
.K~[ݹ6\3 h/ZcO&#kmVH1e{s{\|F(QƟ7x?<MzuOP'o
${&#$8 A6p/ŕh'od7}i}i3\=P86QSB)ݥMt?iE}  |$&=Ok[}ki7iښ!sk3DӳFUku?)7:/:G7}῵kƍSCq {aJZ/]u"I*>3pTY9rSrOUx$gg>*+Nq1:x*s&S*VN*7w7쉣i߳?X#֓GSߋ>%^*/h݆Ea4.⼷-~}?~Ŀ~*xR׭?xz<Sk^"n-4nu-SR+}+Lk&fwHc0ލDtѤ׳M$3
p\rԅލ_K.n??w9Ix;g
׬WX\s'ioEG{6NՋ]Q{FAm{yW{]A-V&'JsXɵfJsvSWWN}$?`]V-cεYޭxXft+xA{
<}e>i9}i+Cu%7fj./hf-ؔgFiF.P5-V a+
( 
( 
(/+o
k d}@	2>$~ SUm PE PE ~m jOk I?(|u oZdEb?Z|g2Z1$(=qr|W}=?~z}t
xvwj*˕;[wo=	-dF*A/-~<>"R[l'<xI<^̺5'{@B
}ys/eتxzц"7&[VwJ~SܵJP7K)Z\.gxF_3l~z\~,ψ4[=\ZOwY0,i݅;~GD,*w+x.jZhZJ3OM+hm7S%I=ߵV^tTբ$r+{+7{j%FTj-5-N뮇|~.9~?	CRG-֭oi_	mO;XuՂ]wpkh3=  ?฿?]~ǟ:ixGS&5lCɭx_3E$דio^k(42p86jbj5[bʑx8OoF:mFRN7.ugO/٥&g%jhQ`w SŞ>Ү/mK{gQ9-!Э
._[+̎%'W62yה1	'*6viZ{mgpMe.\;ЯT=^hrII ՗xs^3oVtm'LW. ѭ--`44(I""}	'Zs/{A;ʩ.eFMꓛkgمww8^޷<e/OSH~l/,^$YdŚGVXmB$e$2B} &M&{Nki;yF.. t$i$F
bx OJb?mCύ<KCWEz=kyOy-ykYmk5\Id_((F.J|;$o|.ZmGE?c.UTn|!mNqqSQ7X׿aGJ?gsM-qn<KzZ~i2GcKK˝N;IkI5. ~ L~r^! ñO.{ťƏ{xrnk[j:Xԣ$լܤWGJt9\Gm}{-ݴg^<8֔cgCnv
T{|*_ o:\fn_Wy&u[ᙀS;M-l5:y~&	ѡbO5NT`<W *߈#ƶ	x[Hƌ6O
؈\[]{ec}^DS
o`¥5S\|<6⹴=|>=^k2|DՂ'(2n3njtFܭoֶ/	excI g?%cs&xE]Fc]2(a2eb3O,,u;wJ20dp@5Ӝ#^9:J>Ӗkݚ{&3N_TR>^W8I٩(愴c(+9FrnOx)&>զ.ž1$h/ {QЅ%u3]ҭl<kj.9To3*wpJ2Fo?vI馶W
_/3{eM$iմ FcG&y,Rg^HD ,
UTԗ}q_a|Н)>֜f};yx.絺%9#C,X ֿs?
ğ?km>'//uh5XPi ҭ֮Y}suwueu`y^Qi8I-ԓi}Zv4dy.;jaj%yYMƣQJ'xC|u FxO#5{uo
, NMVZ]:^إA';c  kw~v|i wuX\
&5~[w||+ݿ7:%*r}hx?WK C>%x
!s\Wབg xw^u#Zle&yٯmcSmc76WYY_g|< }gl> 	^}B(|&o\+Us')&(-$֮m%ݞxONQ˥Y"R
n1g*$Ig	A)N>Ӟ1QsoqݼV9#`"0e# :9㛉<Y+#6*Ѳ2 A+̡pI4vgٝGp?E q(iTW|)oS7t:.o>g
cmommo
pCh*** SPE PE P_VE??G5*> d ɸ|H  V ( ( /G(goj} |1Wt{ZYty.^!Y'F)(b
CGִ+YG[[xY "$3~]ᅩ9/"V4BK?}[Nu
 s.5jӼA0j^8hOP[ˣivo,	`ľ, 
~xW>E֛j ^5Ėؼ;6	JV(":k/'fo6}|?|5X\#\k;˽r/>v;?l~wC% tZĞX/.|GGFAY]As|u}b#n/g'g?oڏh8_\Vg,-/nm?|OigOk3Q.MQj4NWSIY+V}x(9.i骳t>[~ӟ4x7	|h*]Jz[=?Q]NKm.Aoe
iwm;/->꿱oQL׎gfoj^~l}f[Sk{co\k:5.ẖ/҅jw\i=]ʕӽf8U)b̓RjRK{wm,  8uxs_|O
TQZ|Cwu$nV}jO`ȭ	K$b$	"1ghu|4]v)oE}[
:}.[.ݲŴ'4,ܒjRm%e%/勵Z-i<Cl&!I9ʍGrwTQwU9 )>g	·V˨I,p}3 S~I͒D۵vO8Z9lͿ+8yBѧO
N.O+Momo _? aٿ↛gox
/ΛÚk6$j쮵4augHM5D|<~&6=<].ո#r%w{%V*W}n}-{. ML+hŭB#"VIr󕲉Hn>a_֗~gؿwnva ݟ7n寝uUQ>W?K}.#.*ͧ^9)4^
8IM^WvI[Gc/kOgOxT;"Ν}[k^$-=A.=FT͇ʕw:\Eq4v?5_?_F'NF%'F,JIHWQ66036q;Aip
:I1iJcRQ`~3~[BUI]+Z7揻̵wZ=Y~?@s&/Sieg\6%wqjI
{q
-[+^x ֑`cM{oȺLeӟ!.k-x`\[72֩Bj2a`&%(^W`3<)vM6$i~^S8|1w_Zڼ)[bqo:."hwJRS$m3} (4Fki;-Ǭ%F#\LoIn{kLIuq
Yg7xil{x7;Y.uThѨGIZ8iZ
/^Ǣz=/\ygKl~)7^mVxfPԮoFFi{
7 |u^_gk1'_sWwkF _u	t|_j|Lx[úomuMCEιx̚h̕vePH }>Tecs
O+7PpA ׃n8Y\ &~wN5;~Ik]d>nl|2şm.[nٙku-nyehIC'OZwLӼe/~|h]_Q]
Eźshשq_X!kcmiVWR(~wR%ISv改m'\׽g
8u%Tri=⣥ uω;9ٿWS:ͅi 8
a]SO[mųG{BN,|^cm>i$vڜ2~_5WC<ArE%ΥcMªYƊ^_zug~j][ߦKo? ?f/<=ss6-,ft{mSxVQBbpp>ѯ7Rj=Z3 ~
||i_]|Qs
+K3E6Gx6ZNb-u3.e%'|l =xVZu	%fJotI#yYhQ@vBѣ4݄Oભۅ`}7j)	簭sBnXjXjnY|)OK(5u Z+d( ( (୿)jUm |%  p eOWݴ Q@ Q@ WXR?-14>:xǅW_x{H5X|7w	%>k"{bVe-gUUcMJ GgnKV+SJJm&nN.{{]xB91=%|CȨ'G#8;w/߇W
|E>rVo[Ao`,缺XmӒI:Yk6{)B4F)$%V+_MέIJsRnMg~'~???UCwom~ ޑ~$'׊gZI~qJ1\742?*9} ߰퍮~˟/Q࿁:|=|1&~//X%I䱸5NyP\XYMLiQ\ju	rtKP657	*nҳ}MS
 ߶ Ưpn a-_4x
x5Eu5/xg\vqkV᫫x,v7&[i/_+o(  Iu?ş,>}??eCˣZKF+=D4e\,UuFiSUdKᏽEms,7/j.Uw ~!7\xg-\>oh_~&hn(ӴRL{{+-PY"kI8?}wI{㻿:g5
x[Lsx7JIuدd|KZnx֙(G
ϝ N~?R(_; օ/,~
Uڑ7Ȼ֒A:.uwl{c# YυSQT)|)ɯ.i9[{#sWSͱ֜)FNrtB;'3vW)xOg'Q_Ѯ^^þΩA,B@\LP-4k6vݴNއ
*c(Bl{VڦOú'|7K[XXq[Z[F1Grȑ:] _I%Ezxm4_B~ iN?gIuvIrM4FUk>cq)n5wKD4orԼӢ?>|~)_Z<~W>f&KmU4^TI{!5s^W O	o;3ƺj".g]JoB:<zuᨄVE_Ogxcpn0NƧ*^;&5QV>_akkFjTv拏3qh~tzC;-A&Lic#]x;xk^Io"]x.kG>#n4+u?k??h?O@5MLᮅouEwt?Dҭ^:Q"e*Esxv8 ЎN0~TF%~y+JwNl^wBrvnI5Se.Ngkiێ_4O -x
3gt#P^h4[;[Xt-w3-`"I_}5cFmR[+K{y%X&D0>qeJnWm[Wi57fow{9jSIRˢS-U i~ǟd|5꺴Y m]4R؊_Ex^x?ɕV#mm_*FHE8lE/D~u{wļMIN&ܤmMܷmۻ
 O_ើ1|j" oO|:'?u;'g$??;e͞c~w!|v #'s/ǇrMZϽ} '$ uqmg6
]&
^Gksj
nG	zwPVK?!sqh'	-KFO$
.K.ݦMD-&F|5+%7w)^WQ}]cy4|ؿk4,e$rRZZ'%)/[g?Ǘ5e ًJ-M	|fԼUƟl"k?;/%?/ctw$Z	nD{
65
⯈ oo^6AMc_?0h͖|&/4 Yy:V151XyO?+]x'e:1u(ܠMTտ4,~ҿ
1|YfO}oC?I0iеQ;ƙkcrFD<,wЩJE\=9UI&LTӻG~	t*|;/hzR\%iFE؁D["Beu`~s  > xK#Sx^3OݥB%IS
EucI}./
fkޝ~<q
vK[Ƽi'{dkmcGl_ Q@ Q@QO 5  QJ?n?|v թ*
( 
( 
_|e(3
+j^/E t	ǥxOX
mow7	+96Pik,qRqokfT
ڮh^bKloKW}ߍ~h_^}GJ^4oakV;M{2JծoyNiiqSz^o<VHt_+I'RloΡ;]c)sc`c;"-.Zz2>:c)'ӿ?ᯆ  u ZJzڭΝoo]j:m047Wxž%c$ֱ% vয়$ďٗm?oO
;~x3U#<euI'@Eh5K; x9aK<CA4i5V)%jZLq=
-xx#N`~  frx~]XGش]gIúfyxGIkhmg놶 T 7-?g੺L>6x7Dojι+{aP:/㻴EӔm>g1Fj XԖ&1䜖ov3Rt˕UUr2v_̧q~> Ғ`Xkρxs73I}sTM{RΣskC/Y-ssYi9j7F;~?	';])o+/ΉeXoh$:^c ܠ~Io-aMFP_
Yk?d
3FOLڿc_ h}{ =ټfϗ*_~)w۷d0sYlkeߪl|iw}7v'^wo{};Z.+{}oRsz^l4m!򬭬xT2Ka5vm>Tӭä.׳u}p<'+km¿<~#5CfǕjjbk	f6l'WqI?e?6gm/S7;;Tm'hIw=ߏ$(U}9;;\9?UgKX_xwQiTvN~懋:YaghJUԵյכEĿnڏ;?_i?|[} oi<Q>|hO+5?GBM>#HOOu;9^[)㺱E)oq$|^s7cNm%KV^Z,7f=;]6曳M_m,g⮟sO
xnö_OxᶵZE1GvQcTuUVE d[K3_黷y?~ ϛ M7y Ne(ݸm/ugJNq4NݎvW럱wWM <vڕz xU
keg"Nnɼ?2ܻKϭ4$eTKGcdndݏn+ÿ/ه [;%h_͆ Okw4=ǟiWđ k}8R+T,No8R><}LapZb)֧-Pݟڥt	oW5q/<oim?eGm}"7KxY 
?  <7e~_?vs f&< GgDaZHo^gyytW^j}9InI-?-wa# CᶷsZk}
6-[H~s
W 2fSio+.i~>JI>{/_5_zǳadħ` qVb֊1]7mڥZ歄.I uvJ>=evk%.N<'w_Dܴyݨ$xh5I,t-pgOQJPV	]kÞ~_2dV'ygs/|n+iJt ?4Wkצ?S /칢k
 *.[koR?
iSGU2amx%.)RK8}^yRY5ɵ^6Xl>"'h֊**[F8nkC<
( 
( >  ) ি@~! 9Wݴ'MG<e_vE PE PQ2piό	[k_P燯W-]V1NE3`  &u xcFaev&ȢE#ܳI _R Ɵh_5-;xc^Sw6 ƾn%4؋ fo@o  _?hX|ិwKKm1Nhe[=gO<Ajm#j/o[_}U{~~/?<~׿/ƿnIO,RfӮ{Q{c8up\$WCs5J\=XW7	FQm8kT5zI @*?co x<A:o<wu{ isx+BG'}J2<Vts4 Cq[V.RM7N))6
OHQF:*JWw w-?
x>96'E5mcXկ!lmi.nn&ebI%vUEFf kͰ9ߏl>5_΋[_xWS@-еIsETak޺=>nÞwk=[-ҫً୏ÿYj,j%X\ys.u)Xy.Xm;x?U?<] |LƕwH-}GL>]q~[je+}<
Y}#o⇁~|)↻j_fi.'mIGݶU kZ?~h?loOWG~AЬ4h6ǆ;۹|+;yLԼL4m)]ꓴSnM^ѭoS*Zet擲ZY;=-L7 /%տt/ė͍wI<MϡjPj/ٮkKW?c'៊/}.!5+}PM[/7 6<$}ʼ\F8hTysFϕtROEͥt#%vdk #OJV>.h7
w5VIw0+n$ƚOuM 6"4ۿWhK;\|)DN 'g(tQr%h%t㴵ή[l#XeKEfzEsPe[$BӨFR}5ocwi[u#'_HR j>Ϧ>,\)|kM-4XLl6)K_ؼGg?<I+]?úwǿwmcm
mg$Q;3EP>3eR73TydNIY2iݴpʏNZTݴ좮쬚^/x51|6Ewekе;o^=K	l,L\TWf˩8Yg	lex7Ծx~aP+e:o:dǧ?&-Ť `H.`YW]LE+kF<}T+QwzE_54o&Ug?U.2NVzkedk>c?~-x ^Y~xǉEVx÷CtO]
k]6y[9>Wҿgߏ?j  h ⟃+S5w	fGVG$E*I$sA4R,q^G
4WF*1KWӲm[S3ZүV-}=zhW:Qޙ)
i'4߁$6ڵ̾Ե9luY,=%iY2B{5;xS?CiGoNQ%잗M_ya=g_<=ss6@%;xVQBbpp< |S3k>#x7Fw%ZxLG:}3%:pw/ߞٌ9tH	\C];?mω^(RL"5ŕbѯ.
'uRHe[MVfd~>'x쑬z?_-?L_ڷޫO 	auE@VKywqkn7wf/{oE:JZ2cKSN<iWjkk$zht,*_?e-ӭm4xFHT,ikk-fm?-#N
HB"yOٷ=yk~^_˭Q/..kgft 
#.Lgk+v> >B|=ݯx^/䤯M} +v3MKѴ2ZommBmBҭqB$r(;QW
> gx_S0jZw>!|:OO<Kg>h]G!Jiqoq8ۉIM@G?FCQG7Oi~v_}EW4WgQ@ Q@ Q@	[ S_ ? ԫ K	 &#oZ2h 
( <wn'㗄<A4]cƾ%t;#dXy8'DXd`0G%$?u ~n B  <~#~=S㽯|9+ڨa¾,>iku'k!EX[r>iY|H x{ZGß~\I<G~uu q\Mq$~e@|V?fZF_
oƿ:񞰞?:VKjqiֹŅ%mir" h||g9i~M_êK/=ַ>{9Pw@~  ^iK2:8Y )RH&#	cHkOKc o R?5d>4νs^3V~|6Ե}K70 l]\[i>3nmAb;O!FGhtά:jퟜ>-%)aDY<1[,\<ru% }]oK-Bm1[OHt"_D '>?iiόO:\SOt[:fNK'ʕ}]{-*8x<i~K+n~W I{X߇<C⟆( M[XЂbIjܺV-m[E$T~?7ǯهZyL?_mk~4Jt>j~ Li|gٱwzvK:yk
KG1Y*_75t־z?K9vom~v 5>.~->)|(S!|A ^7ςoYt?
kq_rxc[^G[mP/__յz;]A-v9+ˋ6](#nɒA3j~F/C3'57gm4z-3Pis=.}g{ɾwws	 q߃,iK	i6)OL/SKc}Fy$i/	{: ~j":޿:櫨=Ə[n`+籺\q-b˩){<mzPZ^9'$wiJ鶚Wjd(J!NNqVN;_tm]}㯽{R2?h ٟៈoɤ1hxk^1	
{qt$h-+<տg?O
%5 mikY"\jrj~#ּ6,qh]O<$K!ǜ9(ҫܹ'
SЖ_fqNQXʦa8CN}Sʕtݚo/㏇ 
E=kÿEe>l?j uf\aoEo߲M[>AOO|%Z<5I{r|FFucǥ/&}?ى'Y$n. xKÌ.+ү%	uka5)rRxT[MIJ7f/2+B"p"⢡$qoyt3G j W SlZپ#:v㗳5[OKK{iNIVao%Ľ./g4 ]
gΡ]+Ws-$.
9vZI-֙N];h]jС	R*Rn;Ͷ֐vJ1wjRN^rhEPQWI_޾n_^]':|z4N_x>HJWu5{;f]#v_Ei=I+mQfſ_
߳'S⦱t k||O CNtZ.y_zQs{umͮiK6I7,c^UcM5d8ݧJ|M%u<E8%}3J񓳊WMuǽT[g{g  NW韗?hO7w;O|e |w|k13?Ԟ+zmp$;-{kya)kR8QM=-Xp^i >
  W_/W ?j-k tOI{F5QjZ,7:ݫGpfӼVo fOߊ<7
w{k+=3 <s cdf~^qxֱj~(065ΧZ5r,F&cJ勻Z6Rtj<nIO
];$6䭪r#ĿO~>6}eƿ<ekCYмMqm-ֿkZn @H:Qյc:|  j_fxO?ÿ\:g<eGxs^/`OZ]ώȼYSqM%ܗ_ANMĪj3I8Ml3L4*v+V
)*pI0J<2n1V\$Vg>2 j>.4v~_M^;K_2E?2ycM:"YG$
dٓo%u~Ӯyx_𷊾%jZVcF:M厯E=׷FkXKrӯ
Re.^[=5׺3IR*}8L3V;^;˯^ʿC_< =|M j/ a iy>/;?)5qOo_v<?=Z< Q s/ _4 fï	_H-|Q ⏈2}f~V7X<y<%MW+Lⱕ9%tI+k9
X|\QQ_Hp Q@QO 5  QJ?n?|v թ*
( 
(~2xjϜ~?μ/To|_ kۏxާ.t=wn{g
~ߑ|`g'|a _5iVz`UktsɹN"Gd*> |a}{Ŀ&7ƟCK&xGXէ־)ͭ$D.(4Nj5
Err db"=Gj+M^oewf"v7~_Qm3 t;^ׂxĽ7Wѵ[OmVdԴͮWaAugg7}Vj$mi>P>~џOëk+oBxJhMitO}j}
cn$?6+Ò:X+Y7d4fw|wvGKS%(;+^J:\w ƗU4~
|XSgо+|		g׎<#ⷻx=cW3{a8![]R+k[{;Ҕ])IEKKW&+j"IJ. ʬ5 |%Rg7 Śi <m{셯~~58-]n_oK\ҭ4ЮI^ɩR8gݫ_$䮺s ^jm~  HO_>
wPiW˪_YCsq5<W"y`#P~T eψ _,O_7UZWًı5vo5DO0D!*6ZvjRoM>&Pwv߲ׯV~| ??d_^/4~V6w&>/ۣ|3<OsO/m>ڄWx74kq>OTX5F  ? a=:VeT
^=趫z-]#N˫ߦGo_ŏ.[{?>Ĳ,ƭK Үb}Mm}U5yo[h+mt 7-}/ⶁ{rwuR6V:G2鲙)-mo噮qE4c	T}+tJ_ַGXNs(ԴV}kM~/u3xoOviWQBcm.}fH*Ko!js
	 kW߱}{]/z^6Նi hno|9jm, 	F/n-']33>+.ӥEJ׸[u]¢JQuz뮋wϨKFw3 ?KFw3 T?	9yw? .e]?%ҵgCm;MKOfa3\+~x[?(k|>4Oߊe|m txOPM/.|Kw݋;xn-di.RβjYN0ܒNMJϷ5ztS?vW^=?l~	-K `ViKK_wt۫}.`$k}ONV7uݵ}  h9g v?e
x_Oy8K?Tm5tm<:tW6:is%kacp'(٤2ʘ,_/<#Zrru:VjzB3l5'FqJ]+mnHrgj u0x~uW\%̏k!INko
~
x/h~so5Zin%\QC$\I#xwfyS֩NKSJjծe;p{8׌nZXF  ? a= ҿgW>'xl _mL|?O> x;Bu h7<W-@GMtmƌUFS=Q\]y0جʞRNרdVMQI^M]Εx+vIz+x 
g*͚Guυ~2uI7/iW6>5xYhd>.-G59]z~]:C~?DaѨGŏWZc$OR}^ܗ..o5+:qj
1nnJ1[{%eX\&dm붷+7)l# >_??l=Oxm7 l:om֖N[_jv˭ZZ\Ri3Woy<Ql0_ߵ?ڧwO
/~'D^5g|KZ-ŵޥfNiodUcar^Jm=N<έ
U;k䯧otKa|Kg׾5C;YwiZ/fU]]?́$V[1v'i"8o#7⏂׿
~xX->Ծ"ʰE/ړQզРYr[ZnJa+GOu=_n|-qH~4Nkkf?&WHk+
:74
FO邏B#Q8sj !??{qM29Tcdʚ{=m=[>,TJTwV@C7 8C7 8 & }υ>%?  ?{6JuH[~H(<
( >  ) ি@~! 9Wݴ'MG<e_vE PE yS
Y\ׅ !??{qΒ WsuO_
Q1gn
Q1gn>?   >gǯ~om~go{ks$i2$2?>uk?c W@㿁"Ӯl<{kƉ}m,;xCWȲy;,Ճ4rL޶WWG*[{J2i;6-l密$E-+$~dY10 w|7a|,/~о+CJʺԵ/ּ1Oq>k&% ,a-OvZ c{wxX5`uߋ~mSadX^=wJ-n	i?$}f'+eWZN*Qqj6jr6SVI[9\*&7Z4noV߯
 ! ?~. lk:ݤ}XЮ<!YxA%>o|FW-/-t5DҴ#bo >4|<
q`-混n׮AH2Z+t,<(0#8ubY ٻYɗe39TyO}SM/Ş{-~V o+y^~<m?>|gv~q\ ϋ/돊_-+E4Aܾ}bNtysInHFzM\h:WM7iJ88VNZV7F1O޿~j !??{pj !??{q{_y s_c  _axsÞmL%59mh^djg{d#t$K3=< ɿUm}?[S|_o6|[<C6.$؃I,VWkJKM:(Yn.(3)g/:wYTuv}w~/uU-kPIص{aE-̈? ܞ+{Akuמj5kվk?TmovE~|M?<_ ??cW Gw>#h
п\|/5mSP}҈X&dӗ	[:s[	T0r%etjFi]/6#u`)/s?ƞ$ >Zɠ׺#R--"cψn='ؒiIic5:͟nm_Ŀ5w>%twZyo<1AC=:]:H[u&w\7+p"\G2X|:ɲx%UU
Pw)
6ʰRnՕv+?V%giǁ|-evFfa&iU6ZUz6b4UT .3Ƿr)unޭݷ[y_pj !??{qg.|%?f ?;X/N~s\WWVTKowkmr"I&X7CSZ"KJ
I{֎O^Y"8է*RIӱ ܹ_7nz/}*Ox.ᗂ,mcKO[F-ayi4{~n' ~ω)Z.}}}þ[j}3ޭNR{<;|#v#oI{_[_S*8XQwJvIE%_nܟ|m L|0"݀[׋5wa?Of-j<7 E>*|V[CZ?4|3/xYҴ;Ϛ;x||ɦt WdA{y~nxݧ|u R g x{
%?:'5nS_ꗳ>ؠ{^8IP. ~s|n|j߲ƻK&6o
,pChI+*31 _@pk6L~k 9C]޹/㗆~xVxjŷiF Ś\]i?
ZM}g^eib;{IcF  ? a=[Cߵo% ?cۢO'ρ&'5F  ? a=5F  ? a=k O?oz>|  O׾C֫|+w%#ך_Sl|fq ?E  ( K
 (   _v_L7_;}@ Q@N<5g?}sw?^7>o/ q<oS:K߻ڷW I_=ϳ?Y~o5F  ? a=5F  ? a= k O?ozC7 8C7 8 & o/
Q1gn
Q1gnk O?oC7 8C7 8 & o/
Q1gn
Q1gnk O?oC7 8C7 8 & o/
Q1gn
Q1gnk O?o. h~ >#h>^񦻬hoo<S5֣xeeblEu9өi_=g	o I1 _\<e%-S_f_O[UʳM5{+vZ
o 5O;7þWT|dȴiag؇jDpHK
 O d|~}q7 E~|[MqBB~?) ѵߋm.;^8l<S_z݌wJOq+-&T  D? "zǊ<;yh% &ZDloR9;($hD~Ivokxqtk~*𞻦~omW>%$wg6\ok$L[[;|QTc9'^W]mR&i۵F  ? a=5F  ? a=  Mo/
Q1gn
Q1gnk O?oC7 8C7 8 & o/>9
ο>,|Q+]x1h&◎-ivfUHGrdg{Y7^gʚO^cOk[Qm>
g
'4kM\Ov=<J,Io-巚_ySG1j<];5yiJ>W~hYs6onJGx	0xF32^Ũ\xc>)x@%om H5
F$.&0
Aa]>  |#Ķ~1_oHvz5iy[IKoqm<6$$r#+#C)\1\Kc]\kVI*zh,GtV]6}7>o/ q7>o/ qǏM λy_pj !??{pj !??{p{_y pľ#X~?_p;[ y. ҟc3/PE P_VE??G5*> d ɸ|H  V ( (=q>q q:Q1gn?!z\~պ?J}N)~A7>o/ q7>o/ q_y sԷ3Ƿ3Ƿ 7 wy_pj !??{pj !??{p{_y p3Ƿ3Ƿ 7 wy_pj !??{pj !??{p{_y p3Ƿ3Ƿ 7 wy_pj !??{pj !??{p{_y p6X~ ?~/?eo:_iuNo	mo/\KۆԢn[EC&rA8Dψ>)x_ǀ<eA%𭯄/ow%V/!{H/]VK_Np8hJUIs+4}{ǳG5\'Q匷IuO|#|V// wUyqoK<3lOw!$a
SÿN~	څl?RkxO/[?vXOsh7VЋ)Rt4ȸ־;O?xBu*9s;%kr1=<6ס'ZY- 4|OiPoOun|.V{_ik%mt\^]=ܻQ !?'ƭ[?ߌaxY|wUgЮ5˽;NOi7![Ekyws,B#oЛQNRvHRrj1Wl 
aX>u⨋uG\IenN<=˱o<v7C~$ i/k^k_u_M{u-?OћR ֵ"KyöRA{&=>yb2:XʫQqP5ڒF=5e~U´5te=wK}Ǫ7>o/ q7>o/ q^y_pj !??{pj !??{p{_y p3Ƿ3Ƿ 7 wy_pj !??{pj !??{p{_y p3Ƿ3Ƿ 7 wy_pj !??{pj !??{p{_y p3Ƿ3Ƿ 7 wy_q|K> s!Ul~/)>38 Q_`yaE PE |% m S MC sRh/&Oď/jxʾ ( ߌqC7 87˝%o[c 7c  _c  _| 7 w=Ky_pj !??{pj !??{p{_y p3Ƿ3Ƿ 7 wy_pj !??{pj !??{p{_y p3Ƿ3Ƿ 7 wy_pj !??{pj !??{p{_y p3Ƿ3Ƿ 7 wy_pj !??{pj !??{p{_y p3Ƿ[@|* QխWfS÷=O"-5+m0)[N|4)NKFG=
_ůP[_f G>&O;H~p}xaiǁ|-evFfa&iU6ZUz6b4UT /^78f3sbgndVk(;%}[ճ:ZhЦm]Q1gn
Q1gn8}< ɿ5F  ? a=5F  ? a==< ɿ[To|_ kۃTo|_ kۃ  5F  ? a=5F  ? a==< ɿ[To|_ kۃTo|_ kۃ  5F  ? a=5F  ? a==< ɿ[To|_ kۃTo|_ kۃ  5F  ? a=5F  ? a==< ɿ[\\s_ ,_?^Z׸d [^iO䂊
( 
(/+o
k d}@	2>$~ SUm PE Pe8՟8|ˍ߸ ?x^3ǷN\.{~?j_Ok%|>'_e C7 8C7 8< ɿ[To|_ kۃTo|_ kۃ  5F  ? a=5F  ? a==< ɿ[To|_ kۃTo|_ kۃ  5F  ? a=5F  ? a==< ɿ[To|_ kۃTo|_ kۃ  5F  ? a=5F  ? a==< ɿ[To|_ kۃTo|_ kۃ  5F  ? a=5F  ? a==< ɿ[To|_ kۃTo|_ kۃ  5F  ? a=5F  ? a==< ɿ[To|_ kۃTo|_ kۃ  5F  ? a=5F  ? a==< ɿ[To|_ kۃTo|_ kۃ  5F  ? a=5F  ? a==< ɿ[To|_ kۃTo|_ kۃ  5F  ? a=5F  ? a==< ɿ[To|_ kۃTo|_ kۃ  υ>%?  ?{6JuH[~H(<
( >  ) ি@~! 9Wݴ'MG<e_vE PE ezd:x>Ǒe	zy 8Gu~ 7 V;|϶Nqo}6yµ3jG*fUb=px<־  0N?l o˫g?8_Ksw}s푷 W?$ y ɗ "_	Qm|ucg4k W#iu~ 7 V;|϶Nqo}6  $ /?LN?l o˫g?8_Ksw}s푴 W?$ x+ e ȅvgT[|;]X> M9]|'kEՎ3Ӝ}_lC1 ' a_ /D.?oi>F;\*-o .vl ~dm? I?^
 !u~ 7 V;|϶Nqo}6_	Qm|ucg4k W#i I  XW  sw}s푴N?l o˫g?8_Oc O ¿ &_]|'kEՎ3Ӝ}_lvgT[|;]X> M9? C? @ 2 B;\*-o .vl ~dm.?oi>F!_   ɗ "_	Qm|ucg4k W#iu~ 7 V;|϶Nqo}6  $ /?LN?l o˫g?8_Ksw}s푴 W?$ x+ e ȅvgT[|;]X> M9]|'kEՎ3Ӝ}_lC1 ' a_ /D.?oi>F;\*-o .vl ~dm? I?^
 !u~ 7 V;|϶Nqo}6_	Qm|ucg4k W#i I  XW  sw}s푴N?l o˫g?8_Oc O ¿ &_]|'kEՎ3Ӝ}_lvgT[|;]X> M9? C? @ 2 B;\*-o .vl ~dm.?oi>F!_   ɗ "_	Qm|ucg4k W#iu~ 7 V;|϶Nqo}6  $ /?L𿃏u-KP:dٙ目z}~G9Vk{ig)"Uyom/}P
( >  ) ি@~! 9Wݴ񗋿?Nx9mkPյcVSkZFk6yI%vfvvf$k S-  xC h  S-  xC h S-  xC h  S-  xC h S-  xC h  S-  xC h S-  xC h  S-  xC h S-  xC h  S-  xC h S-  xC h  S-  xC h S-  xC h  S-  xC h S-  xC h  S-  xC h S-  xC h  S-  xC h S-  xC h  S-  xC h S-  xC h  S-  xC h S-  xC h  S-  xC h S-  xC h  S-  xC h S-  xC h  S-  xC h S-  xC h  S-  xC h S-  xC h  S-  xC h S-  xC h  S-  xC h S-  xC h  S-  xC h S-  xC h  S-  xC h S-  xC h  S-  xC h S-  xC h  S-  xC h S-  xC h  S-  xC h S-  xC h  S-  xC h S-  xC h  S-  xC h S-  xC h  S-  xC h S-  xC h  S-  xC h S-  xC h  S-  xC h S-  xC h  S-  xC k         / mouse maze.JPG  	@       + j   z JFIF  H H              	
       	
   } !1AQa"q2#BR$3br	
%&'()*456789:CDEFGHIJSTUVWXYZcdefghijstuvwxyz  w !1AQaq"2B	#3Rbr
$4%&'()*56789:CDEFGHIJSTUVWXYZcdefghijstuvwxyz  !    ? dO?_ >.|\wktm'X_QvYYoeekoPAx$K  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = |sث᎓ >i ~?G?~%W~4MZyiO70뚪yh+q; H ] z ?_; H ] z ?_; H ] z ?_; H ] z ?_; H ] z ?_; H ] z ?_; H ] z ?_; H ] z ?_; H ] z ?_; H ] z ?_; H ] z ?_; H ] z ?_; H ] z ?_; H ] z ?_; H ] z ?+O?_OچmkumcXկ&կt>kidwI]$6> d ɸ|H  V ( ѿq/
 e-
B/j|sGiskZxcPɇFtKs y  Z>  9@IXτߵ>' hb 6kkh jдw{яˏ+'?n C	_ {=sWXk ~
t ~0/mmo5͕6*ɨOlNu(mBEy?s?ࠟ`_ؿ>"Y@6&omIy[=/,a G |3 )G/o ޡx7A-&ңZMr/)[CR-MY+ | E j
 -A|X [ƛX 9k:?s't7n'T <E@t ;#/o|%og}.,ChE#dbe_:s Zx
qᧄ-mk
xzx9;K0]~%S2~~_g7o(w~_-iXyE==˿{)p!pwcpڊ ( ( ( ( KOc0  R?m PE y_'@|C-w{jz湩;liexi(bI$Do_CxY||3>xWg"^E>2f{4e{HKm>[\:	s'k|>h 5̷q^y.%y%Y$vré ?g<! 4 é ?g<! 4é ?g<! 4 é ?g<! 4é ?g<! 4 é ?g<! 4é ?g<! 4 é ?g<! 4é ?g<! 4 é ?g<! 4é ?g<! 4 é ?g<! 4é ?g<! 4 é ?g<! 4é ?g<! 4 é ?g<! 4ì wgb xŉ *]_yOVc/f΂iF{}O>7[ 	Uּr3y!/3CwjB+?3\]&ߥ_yOx&Z}M7v:k5͵,I̮
 OE |%  S 2< sMh/&Oď/jxʾ (x?
 Jx,_ڷ/ ^y_?j,nӷ3;%ݳ/#A [  ?%'w~;xC/t_&ƶmZ}X^^Fa1P*XH
 ߰(oWɢmirOk$duDh$3Z)cO絕3# ?lo, x? OS⎵o ;mbRXR]ͰMXUs @e )X ?E 
(?s+g# H~@ Q@ Q@ Q@ Q@ğJa d'	k ( K'_/ۧ	6$QɮΗ+{:ke#9%<^4֭}@~x B mG=_]A49}r?
X6jO:Eޛ5҉UWt5-Hkx @?ࡿgDeg@yL|:5o^Yz3,>sZΑ盻ʹgG_
 Bߵ'_&7l_7><vK{iz޵w~Q%qۨC   q৅>(|# 5 9NokO/TZ޻=<FWƪd1{;W [b~/x#@o5zFi3WugVMZsMf  r,~2~
'_iI/Ì<;'R|AW͜zfC\j_Wk0xġ?Ak < VE/i> u-KO|/:msy,6.r.X!H >[3 /   gw5υ	Ipi>"xJĚd#_Ik*[mu8#_`M'Wֻq57(&Nߴ/6Zx'4ohP}mcA}oC$*K"a||me7xzGӼ6 |7emoKdźzMmi4
A})>f7~x Zjx/ eMgq46e{Zj/mf+_"XLq
 
 g*&YyK/FCھ6{ۮ ٧IoK>ۏ(Ɗ (?x G>~&s?Odh YX~/ĖeoLh_&Wim |%  p eOWݴ Q@ _:_@
zo)eO?dOO??.o
f5o-6 	SⲰEܭt4ze4_57;; ICƚM>/4=D?<;7>x/hMV	X0,^T{_}s/!);=u=\]7pdudpA4RMm2G4E,2( V?O/G @ c\
 dH u~PE PE PE PE PE |%'R Z
( >m )X ԏ}@+ O   3J/ > 7K ߈?WZI ?> u՗u-dV2?1ٍ o`ǿ"|/# ~?SFz[W(o.m[DW{~*zGC <~ž PƁYٽe{A["G+9kqpR ~_Vo/\~Z~63/x;]zVƃZZ,hnH5S8>?KٻƏ|q6 |;i>8^ӎBN7fMѬො]P@ 
_O	l^#$P0x4%>#j/iIhW	/:?/;vi-E }KTE~$P4:kk}u6̯D x o_)6 }/Nq=I^7^Z;魤% m!CV|;/>FźgHG5Ɯ^"Ҧ|-j'}d\iW
Tw3k'_ i~/o+3NO;k9,>ݏ"'	lHn
? |)o/Y<m{uh+7TnhIԛSѮtņM/Rc=u '/|I= uFO;#ƺφ<!qCF/,;s^Y_},~oڝ?A>| ;_ž4A.5*˫[x%xQ@ W_
+wYh_&Wim |%  p eOWݴ Q@ 
??lOSk  .;ִ_xOWӿQ-nt Z h}BxHdGC H ?? ؿ$~ JO|E ] 	z CY_ 1n>] | P ?S|X~];eur46IwlE%]NW@ؿxS<
ׂu>I4}ZZ6ehX'VWWe`A"%L*UퟯJ
_ᧄE{[VMy-q'ZI(+qqossO}8 c	[ VPiO_ G<w _!ujeOn??;Uzݩ@? - YE?~NGwy_clfO ( ( ( ( ($ V?c ??#K_vE P_
+wYh g9 4᷄_'WV/hmy;'RRM3iK)
H ~P;>1nt?ǟ|KۿK/]^ukeBEItǤ\~.?'_Q׾(?uo߳wg_|S+>е
'u5:Cj?O䴽FҪ\F-S寁 _πߋ^?/xbR|mė|O|i7z.{uI
7v
gb.&qsn  :~?
o?Ӿ6#Ş-ӼK?Km!t=FRz~4sI#'%=WZRW//_J/C7~3ܘn>Kky׶Wzկ4r7:YI-"w D?FN z\޷{Tg,r'Me[YO{}*F壃V&? jmc|O[Hu-}{/7őxc4wmx[\t=bK^˛Y|x-ac' 2?d8>|KtM7]FHs_ͫ|A-qd]2HKծ-Aw R1  'Ŀ|M v_V?i5+wzi3KqD
l&+!3Hƍ (-#xh_<Q-no#1_Mu
kcrCZ
[_Ŧ c| qF<Qb:a|~ي;/jWYq⯈Y"Ӽ)l=F9[[E]J<LxO
F?G ~y`~c}y\<c-kǿ%|%Co5
o/翋s6 h2  (m )X ԏ }E |%  S 2< sMh/&Oď/jxʾ ( ( ( ( ( ( ( ($ V?c ??#K_vE PZZ)W>4!5xT5Km2)[)}{x[LRoBuKf
( 
( 
( 
( 
( fo_Ci 'KE?M[XuKko4<;qhO^xNdZ }E |%  S 2< sMh/&Oď/jxʾ ( ( ( ( ( ( ( ($ V?c ??#K_vE PΟ ڇ>1iz|Flo͉hXO&1{:ȑHk~>CvmC_CoIiU";[j7uS2vHbcSilD( 
( 
( 
( 
('q__ drP7i|YЬ,uO|լvb^ kso(ymK,nNؿ~ ~_i:k̰ϫx٦[o5=BK7ww+ (/$	 dm}@	2>$~ SUm A[~?|sm?ENjƱ^CicF\\L<J쪊@| ٟMo{Mּ?8^j>1Zzci3>	_hX[[2Ssi(rC~۟r O  
vDSo"ZQ\;o'ل'!Oc?_"~   3 j?'!Oc?_"~   3 j?'!Oc?_"~   3 j?'!Oc?_"~   3 j?'!Oc?_"~   3 j?'!Oc?_ԟ؏
|A= 	=/_ڗy֗r6o_X7+
( 
( 
( 
( > )X?d ԏ-}@ Q@r >--{ƟzO|QY^M>}I\2oCHA õ?eook?GX>>.C-YN{
.6AooG1G*; H ] z ?_; H ] z ?_; H ] z ?_; H ] z ?_; H ] z ?_; H ] z ?_=~ǿ||H=?I$OڗZYZK۫[-I6 k?	>	71|vf|$浨[ZO|w]F֮Xl4fčZKo"kȭk{7V?s ög)+8 O@;kw   4ód}GǺGu7 
Q'^1n & ʐ$}_&xad"}
x[~ǁ
?EN:>icF[[«$qĊ  T Q@	$ L ??k K	 &#oZ2h
u k?n 񶋧3>#ߌ;I-Eut:mϢKoqs64B
CB/ۿ] e_ <ccMtx͢{&R"HKXb`F S>*|)CǺ ? |L/FҵM;φ;|Kh|fdރrJ2	 WaO 	(  )_?$ y   S J?WaO 	(  )_?$ y   S J?WaO 	(  )_?$ y  ?/"7)@ ~ /ڴ'O/پ{o_?ns~E PE PE PE P_+%h 
( 
( 
( 
( 
[\~;h^5|!q:֋sfitTɨk'm䲇uWig
ᶲ oeۣSc/ h?|ck ?uΞ޶teh?iY8;Bƀ
( 
(/$	 dm}@	2>$~ SUm PΟ/]%~O՟<{ç:f7;k
F8m.X?i	Ex (Sn|sw&㿏w
oQ.^]Cm5maO֗zޕg,bimq4@} 
D%?G; ? hD(u@6 H n ?   G"_ K~ w 7T aQ l?#/ 
?P 
D%?G; ? hD(u@6 H n ?   G"_ K~ w 7T aQ l?#/ 
?P 
D%?G; ? hD(u@6 H n ?   ߅_ t;?F,><)󇴆 X%e
(/?OHݴ Q@ Q@ Q@ Q@ Q@mDh?|t|s~	
gŮ2\VS\GlIo3Gjƥu l|V|GZ;/g7'u-g7(l4=*HCU:6jQ2[&tE PE P_I/E?+G4> d ɸ|H  V ( (h|RI-E{oM>9O4^{-LФ\5Xe-}6EԞ)4/_W컦;gxZ]kCeVkgZkjs	r$9`Vٿ|	J~~: ৉~fj:~yq js˛YKܹVV>@O~x^fz_/k6zVyGowv4BnTA`C[Ǟǎ|
m?ZN>CwcXƳ[\BʌH P/ߍ~(|xឩf͞>D[]<;dᔁտǀ? K # #? 3 P TTPE PE PE _iN e|D#~>'|_?k5_|Ii
3UֵkiaPҵKk8cf P??ि_([¡R𪿷>?c ī^g L~ͳ?h{~/⇃|CGx/P/f5a%SSBu;fcu	Mݢh0(>ٟ* >g߲ye cBնy>Zyi>~bO,wM  _y?C?k Nm'W$71y|+1= ? Gkw nS9ωn:.qkƭyX66Ѵ7721F$*34߳O/S
}zz5-3fԬ]CrzC2^Y)/{lC 4v؇_ht> o x[u:MoeujrX"ܥ7o*Yy ߲3
x?׵k
>CtkSE:Z[= -iDQu2Knu	i_>|CU Pt?KXSiz֕xHc42I# {lC 4v؇_h ?b ? Gk# |~ sw 0   {+O>&_}ƭk/icF\\L<J쪊@ϟ
~7~>(|>?z4x'7×:Nךl-.4Ն.Z.ZGHSbEiPcÞ4[D\ c=I)\R\I&5]r-t}mig햰\F_?b ? GkogU h>._;>w}(g)M/˚HϓD`b"ΞM؎d@<wxǺ)kƁi`O2"=nO_-ݠ:.S|e$=  ПmU|)>(|/ |~ V^"sZ٭/<?Ko8o4_ͷ(á>9 Oſ^jVWR2%ݲ_mv̪%n-+(r( I/E?+G4> d ɸ|H  V ( (To|,?io  #fD4WuPV_?>'|sOֿc-k3-^7v:s.4{.iZxeӝG{fuv)@ Y/w
 -  71xkG=/v~;C}~{I(8bm?b 
lo>~wim 
^,ĺ&}-OK/$Rm8Q@?g/-/X|dGi__⇆<)*G_]A;b\ph|a]?%!F6VIÏ&NwSX|-xZEuzW4V,toA{5k]=^H#S8yEieO9  a-S⏋>:hGV➅i}i&Y^,>/&5YL$IԳpG I?_G.7%>1SOѴ
~}ņe2i[˨o@,|on5;tY@=
 1 N?|i|) è^?WZѼKŞ.m?L[lYmL.ck2/|!UM 3x=ɆT{ku{ǭZN7/~ê]%^jB):~qO 3oh^ 5
~׵Ox"{
oQxEUҭkNZ85a.o~߰OԿ?>% ڇ^.قſ5]S^ݭWT>ӌ&RmzٶK0LGH0˽;e "$u?j揪[ivZ-_:ηRZiV{~O
F?G ~y`~c}y\{U Q@ Q@y_ߴvΡZx'5ZL}mcOcq%ѳ"
YeH<SH?O>k4V6ڮi}qM$$+$#
t %%?P/CO '{[>]#Au|k_7$wmt[Ig|~|W$|-!-o$z_zVyIq7iiz8a&Yb
JrI xP񇁿esɦIi
ay"v>$}iۡ@)̪dE$+z~=SO_mm&
2G,Aděa3l,7h(_ & :?sNV 7@|M k,YܬTzWIKtne[Ǌ
	ؿ & o<)x?K/ڶ I$ƿ>xfx∬w$}w;aB*¬du<3 slENVFC	^xK/C𖇤Y˳^
<I$esxD?<xw'Ѻa^zOg;jhgKKguM3(6ΦIcMΠ o?8koS7|N?,6:Mk
?8!4HUT  RӼV_mC	}3:#M ȸoz=Γi/~L攞[tj>%_. kCck ׁk 	? 3W/3V?ڟ?W	VGI
<9¾ὒ'_abYv{ɣU[^gI=; H ] z  = X 4p/]<Wx&?l
j?|HƿX62O.c|Nԭ.foE;+~?
xIմ2m'?4衞6LɎXr#;x> {~ۖ?5^g1C4VZS5jBO[ɕ>sip! ԇY|V_ c	 t
g~;V~esjڧr}LIKd5_Iul_  o?8hwxS0 P'OkRX`u5PiXG*>	<)Z}O
ݎcsosmq6xeHFeuue$h = X 4pױ|Kzs3~ٟ
t/c<kbxe$%bfYUgHvUsH?`> 
i5O'oV
ST&'$k/ӿwcooէ~:~) v~պuŏϢ>OMkGEW\mO{l.Kg~4x <~վ}?L<Q|:Mtŝ4S #涎X"IfHvB$ƈ)   ㆀ?B?_&Wim |%  p eOWݴ Q@ Q@	2>$~ SUm PE PE PE PE PE P_I/E?+G4??ा 
i /xgd| .okQ þuki>OCxS⇎b pն	]<j#>'McGq4"ſcҡ9&ybh4ic(iUSlW7LooV_45K}?tY즎V( Gd_]WWx?7IO=sƿ'nY"Aixo^v&eV{tmW1Bx	#þ?4}o׵k
>Ck?qkSE:Z[= iDQu2Knu}$|-U 	* $Iu ͟l~y>{?u.ds  
{} h c  @)   ㆏S  G 
 }KG_<o%[jrM_<c|<qDV;|I[daV2:Y1B + 	 OA=x^w<3_|Nv<[yn d/ 5l?_I]?E 4nk[-'XY> = X 4p 
{} h c  @)   ㆾ#|*MC9[VP=ƿ{V8]h!fU{uT19d_~he|e|owũRi!l5+x h$K[v|H,tGSilյ;e/~=w)kυ|wV\_3xIӵxmSF=,f`T%ݤcf_c W%y c|z7y>gڿay	Kd)   ㆀS  G 
|<ao
 ) nԼ_:?iѴk)-Oow݈m{0~G
xc?It}2m[?5Ka5 ]UYf<;1k⦏/=׾"x	nZkԺc</DiakK6^W$ & t_'`.Q~?nvOK~.znkkYmGI,@Q֋
2jJ"W g׼]M7ƿi*jdDߍtwpM?* ,j&PSodq"xMP
$
0I/E?+G4> d ɸ|H  V ( (`1.࿋&m!uq{mN+6e
r;yb"r,֖vE PE PE PE PE P^+X|q l>5s$ {Kk|#BG3NKM6(Yn/`(e6 ?d_5 S 
'ؾ[i j7/߳W&w7j).(?P/BY3o?R^ ͬ3^u+?m+T&-;13[x
=6GKOմu
Z]K
˨bR_vP覂)P 4  ^?O!% :# J ?4  ^?O!% :# J <	?7W|IZx~beS\w&kȐKqjRQ
 
 _ Iy ΈB ҏM? /m(  _ Iy ΈB ҏM? /m(ϼG7w=qCRT %-GΩV :__iVO5#Pz&B KtG 6 i /  D~!i_sG
i g<1
uFm'IYo>/$kNkي2\K,ұgGvf =n_W?UXziCXuBK(i,|7kIf3r4̢4i
E_N  Oh k6^5o(o	,t_Ke:iww(-WY
pyay gؿ[? :&iQ]C-ڽD-qi\oɧMqbW~Oԟ /?_P 	  ͥ /?_P 	  ͥyO |/ ,<_T;Gqiw!˚Mv8( 4  ^?O!% :# J  |)xv'x6MֱOcm}qL\XxXex$h4lFI~*~?/k>4ҟ!KE.|8a&(S{J2 O!% :# J?4  ^?Џ$	 dm}@	2>$~ SUm PE P_v_>MZ}O i6phEw{X=*ԴYf4n,˻BkwTCӴ: |[`?~mi-
JEf_&(k-Ż;}E PE PE PE PE P/S߂׾(|ixCភ ix͞|ݼpM4Pe<u~|V5> #ƿjW{}#PKKuSFK{v4.֣ͥ=5Ѭ% /?+ k	 -<aM:dp+c|>PXn(vܼK
@ƭOE?P $ ~ Q ~:x l (gÏG_y2|a>,{U6֭=saae4bVKR ~ ?g& ~8 1G<w o G 3 ?g& ~8 1G<w o G 3 ot۫-?gߏ~>.^"|K |wլ|97zV i铤a$S2ؿy' D"f(GW jeڷKiXo;
!.n%3""h?>=׾?;Eǅ gϊ%t5MBJ<7ET?dS9χ7h	t[X5ow]cmMqssq78!4y$U	?U;Ǟǎ|
ׂu>V']wcXƳ[\CᦎxeHFeuue$k ~ M?(q b>9zx[//?4Ӯ d:XF/̺&}oawv?wzjB|[cߍ 
~&k:oi_mtBKK<o
4>d3HdN++ @K7%w[5K\[Rᖾ,\ giz~yiAio/GLO1ݶc!??OE?P $ ~ Q }#wB U  c(ςy_',>ݏ!ϳyV͞l{=%ӼOW&t>SIoKa6)f*GmoJR8T3 $ ~ Q  ~:~ߴ.I6 ~?j_Na mC	eB3kvQCiLw ?g& ~8 1@<w o G 3?g& ~8 1@{
oCി_T|E٧.>D[]xrHfX_cDp@o)j|7WZ<7M_x~"c&h:~2i7	CI,MR $ L ??k K	 &#oZ2h 
( 
_ I +sඁ=i׶n.<%慫E Com*_XOoq*In>ög)+8 O_-~  ?d_5mYjx~/|Oc]mj;FŶVpYjݭ}ď0!QCTS>[x3|wL|k|3ZGmt"+?PP&$'ԿGJ?  |~ Į =GJ?  |~ Į =GJ?  |~ Į =GJ?  |~ Į =GJ?  |~ Į =GJ?  |~ Į =GJ?  |~ Į =GJ?  |~ Į =GJ?+?e=~,	 ~5>rh > ύ_Iga/6F9G`
(?R؃<_'V)4?^V׾IiVh"pn22	?c ?   }>" x.}~GQsϪi~\D|%`b"ΞM؎d@Q@	aQ {z-'&@57Z-{U<GjS,t+K<iq^[/Ҕ#ПG"_ K~ w 7T aQ l?#/ 
?P 
D%?G; ? hD(u@6 H nKemB  {[	o{KG oQ߃V\Mi+t62l# ;TPҏOxG/t]>I}'VicF[[ㅎb8EUEEU  + ?   G"_~^?%h.t9M/˚HϓD,DYɻ́H4 >*x^ 
|%qy?gt85MS̚8ȓ[Giλ17R7 K~ w 7T?+ǿ ~b i|~;_^>
/U&x5DXY^ܢ[׎HRy}	 
D%?G;  ? hD(uG6 H n  ?  G"_ K~ w 7TaQ ?-m~ϟ4C |&O#6x7,5̖p%~ aQ $	 dm}@	2>$~ SUm PE P^m	7xSOMޠM_2[Gq,Q"X20F V%_ǀ>! a}koG|}>y~/ۿȗnv6>[ Y^"uO躎^j0i65ޙMZM+P7m֚bע, /؏/߂_
|A?5 )_K;=jǗvϧiemmgw
( 
( 
( 
( 
OCF|f<i ?ZZ~5 'uHk}VWV]Z0KWPKm▷;O"5[/^]cvixn^ŔW7\Fd	-tCR??ि1 {] # 	>e_.>qi'<y-Ͳm>fG ?
# |  ?oG?  (~ XP  _0>)~_V/~o@X?g/Z~j/5ϬZ}I!7M,aSw'.K;C5_?} 9 ΏGaC s    :?  tǿ~2 NIt
;N4[Gq-Ns3ɞ
 ጾ2 o # 	>e]}σ˲O/>[t|̀oGaC s   : ?  u?<|P <!KE⏁zVyGoww>dE
oqIQY ?xρ߷^kOմ}cI
ݎcsosmqI̮
t?  : ?  t?
# |WWyA ~úGۯÿ<_߈<]|ִh|-2=ڊi:	2|BMq$4_> Ӽm.o&?ll/57^Mwk%)!tmEUv"м# ӼExW >z[]k}%*=X^\ݼ0d[{y*#GڇR>oOb/U / Q $7%_} J  k  (~ XP  G?} 9 ΀GaC s   :  I) _@~9ݴ'MG<e_vE PE :~ݟ!j?{7_;
?O]xJƝm..jw72Iqo<Ug(e(ϣ{_^ƴ!*
z+v|iOg&l9Q=@7j.<{,|OҼ#}}o|ao[^О=8_\YLztGZ[V;|O ~߲};ZZ4}φ?ΏM6CjsY^j^ӯg0EI\>W^nl,씕mivR IbuJ]vk8 1 aP\Fß,WWM?Mqioe"+-:cź۵^xeu5.'  k%oPqƟTvZݕ~*Qsuǈ.']:j<ve^.̢`IwY)C4g鯅n?_OV߆!~+Oj^~moʶM;Qt[tY4mKJ&%&[sz!uqsgk_EI]|WE|TִmrщZ>ѼayմPΗψrN[+np^[~ſ0ѵ?OH	xm-<o_ xSâ9Xݭkgq5̖-؟?it{~+KL{h/oF_Y%
7Nm.5Imbԣ)Fhc%NOm7k[.}$U>{9Pw@~  ^iK2:8Y )RH&#	cHkP
( 
( 
(z-P; <1&äk67S4i
afk{C2O&	?u(/?OHݴ Q@ Q@ Q@ WWE (L   S 2< sMh 
( 
( 
(/$	 dm}@Igߌ<Wo֚-/AU֗;'R%/9y_t;GJ?  |~ Į =GJ?  |~ Į =GJ?  |~ Į =GJ?  |~ Į =~l?>! |W2j:W?/~$xŞ [F-4XjeỽgU7Eڭų$xԡ8F7vOf֩?&՟t8ϳWxSq=+|M#u}oke$1'ٮ.-a;&If7hSR >6/x[_gch"K;NlJ?xP	-R 9N+Rz=6z(z{u;񇴋i=]ۿ^zu|9f ki2_3M{xoxmPjv|^,/u]n]}N4HCsR_?f:|OՍ|/k7T=Ң8&L\y[:mU&ڷy7&wd{IGzr>w{k_cس|!NMk㇅l/.iijƟ\B8ntLıipxaԕ7xۦ4饴᭕wA?;Q4vi>,tSwqqj~,Y\HWʍt;!PiZH#>J$ PZ߲w'[O|K⟉_D\xö?kxu
K^ZI-ĉm'n-[;kw   4nO]F.W? cGڗ	Ew➁  xgI"f5]9.|=bo!0|bG_x>^ U?l{ ڋM#ӾRxj+]wW-Λe=ιozcoohҌqy#,&YMNn>׵Yk-+sM3e i_wSm?kht]?Qᯊ7\EYmwz֟%P{?I[X[<{ߌ g )W}o>GAiױi-3K#k-S0Xq[\Gsm/=|VmAW(֧wm$VN;Y7j4ѝ//W ~?~Ao} kϏ0nq.Tl^.'7:=ෳK,7* EnOzXt0YՑJA4RMm2G4E,2/PUhK=Itk
Qqvg ög)+8 OG;kw   4  m~ R>?W|q 枏v E#%wi  m~ R>?W|q 枏v E#%wi |,+/
xM_|n]q\t}wgVy! Go:mCSFjv>W".`?_zssYt*߭4ֈ$@ci߆ iCS~"rk_
[jeEdϖf4a}/ Y #?]pf Č e   ?   3 @:~_nX|7eLNWmwZxcxm-QD53D&_"YW/ Y #?@^<O un:.qkƭLCicF\\MpChI+*31 _Ao%oٳC^|6g_ ݵO?BX"]R{\wW)i4
᳂Sxg8__} Fpf Č e   ?   3  Å 5 $g {+Ͼ*?~7^_
nxឩ ixw]/Q&>Hdއl#2 : <1obn:.o>K&5)cD8UQQU@ 
   3  Å 5 $g {(  k oHP  / Y #?@8__} Fpf Č e   ?   3 +31]>~?g ey}~ԫm}Ksh%U+	,@{*upl?j    3  Å 5 $g {(  k oHPGKQO   Q6?n?|v թ*
( 
+)~OյcVI8!4y$U	?ُ   ||^4S__lCsOk;ۋohwkdĭb9 KI4P{%φVSYCO:c7miŵ9(+}Jͳ\KSm ?	~_>'~* gj_b߆g/Ou+m;^}&#0J5x55
7MIkCë_9j:./4xKH'Ӵin]>m {ז3M#y6"Jj4b|߽dZ.E%gٍXP2N0PA:/;QSoǿڷ&wf~[Mj^ D3g
g
pz5ݭfۊ*tF.mm%oto:*B4/ut>㢹H<^?Cֵ:Xio<:QҴ9䶶u/-mFMq'evpr[O욎yMc}˔ 2)+
iR19;+Y %K?0ig\5<)kmBĞkĚtuj|M	`(/ߵ*ƿ{ۣ٧J4KUf<66ZjVYnbItSrL0r7);e2I;.eR3R>?Ǿ6I hp3?to;˨>)tjG.좶[]:M=΋c+S gپgizw4y0M,ϱ%w9f$
>ޯ[<vuߴ s.>GR\Q<Z:Ο(Qu-:h/˸rͬ4EsHҒiI;	eJ~ N_ӯK&&six8m2x'"[<b7_|K|- DO}c+\?,鮥R_~(Vyuh$Rf
|rŦ/[mFJk# Xۻ/O7P%o5?xrZxnԴx)/ [_jZ:ՌKX@3Fb|w' :a^zOf;jhgKKgЭiDQu2Knuexs'[Zyt>' ~(xE W$PI[x*Hw
G/=ŰK	x^?/ڛ
`xw=K_{\xoPGOFM&+GZIfOi\psTR崝yk{>Xyk7qvW
OkO7?9 j|Y3.O1x+2yg7NxcW?f^}~([	^lYm.|@^t\Y:Crȓ+Kԓ*z{-'/Y $ >;!W`[N|{⻽rmG[ xK+;Ho4-"#^~qyo6u
R.i6{j+$jԖ %  ~T? P]  	? _?mOvoו+Oհ:  ̽Gu! V	 zC 2ԇX'e ?OR`~ ?jٳ__~4kZġ&xM6iym-kW۳wдS,r'͟qy6|i?%?hwJ+%}{yH`[۹wSQT4> ??/Q HՂ^ЏC SS 
a  ??  :?4?m|-o ûᘿJ`A ϴ g Fپó|ߴg_ R`  ??/Q HՂ^:  ̽Gu! V	 zC 2ԇX'e ?O'  Om/d?fIW <>/' ;g϶?\k?sO ݿu o ???] g Io~óg@·
 -?c?sO> x"O:ucI)aXe.8f_ u|)-5ZO5h(G}Mjwr[Z$2d[{x!#4ڊ R` ??/PGKQO   Q6?n?|v թ*
( 
#Ae}SZ xCSmSi3]@
%ͬpk!Kk>'?a? Koګ#/7|3Ե=7N'5
xcAtM.h`[K7y"qz߼?
~j7/߶Oe/6x]߁	o'h>P{Vcx^R/,,^%֕!o=^
쨴۵;Vzٚ҇3i4hw[}cW}Ofu|s-gYϕqG kIMƺ~#Z
牠񗄓Wӣ+&#2qxf;S[<o14VQ~WgmzSzoǏ < />?ھ oKоѿcGyO=̿h^
#Rq*?t}PZjW{9Kwi{4yR*:7\˙Y]78x7ď;#oxYtˋ[D}/n}OFvtۍ>ϡFSc&(/|N)kUon5}|A'CW?4xrwDkyTI.+{${yhH kߴt?W x׺|GjgtX	^}FtHEfS^IV++Y6ERvMi;㏃4|xRt
v]sGY/u
?RY]/S+;;4۟ܽ]} N٤Y|EĿ	<ENͅ׈~jV> ,{=UXjj
mE,&3ga^=xSi;YsFK{=}c9j\CڊӔ(Wg?N[-xߚ ٺO-->e7i
E}lC3E*1 ~FKSo
+?	Xh:+]fKK?\h	ot+5kky.ҴF b)׊)]K~6Q/ǖ:FmBˍ[Òi#H5aW:bnM[t߯$\] 5!X~]
VMb
xK;ᧅ[qk	OKS-ƥ+Kݬ4k<|0o<;6=;Gд{xcHa{uH#8@UEP P+X4cdKM_{˫i$rosZ$($ V?c ??#K_vE PE PE PE PE PE PE P_I/E?+G4> d ɸ|H  V ( (S4f}7WӠӥǙosK!pA h>$~? |}  k_6?5o@xïᏋ+ͯq>gp76	gK7y7j,."kV(&Fz;JIY3_!/!~t_^/ >7T
6w𯊣uFՏMүfm2	-f;ӵm VO XzƇ7{ஃ1ƥ25/xTLj-'$TT\O+vVdӲS~7>0j >x㏆#U'QƵm&-f++Ifъmul4pd1Mq٫_W ,C[?ǂ,ǈoW>60]cM&^]xA7zepiU	^+
\kiR-VEwkW({ٴKG3*b7  Ox_ᶻR&xPմ/FZ_gӉ^LKۍ~J ^ѵ⯀5^3|;.KZ]tzUJJ \y,<Ӧ6g},UwME%{9NqPMݷu?ߵOy' 9k?Gek9#Pt 7g%5{h.x?) Z6rj1&oWngY,V#ι6[/Dylhw	>&9f
G^Vm_{YΎYδcSgexюDG/Q~>'G?w<+sZڦ.-^=}	kqo
z.v1<}.y|kڏ~!kzU_Γ%:mi$ ZXXic֣\Ck
&9f
_Zx$/etweN^{u Q@ Q@ Q@OO	
k 	~ZׂK/o)gyũNDJŒ2  K/ 3 K/ 3K/ 3 K/ 3K/ 3 K/ 3K/ 3 K/ 3K/ 3 K/ 3K/ 3 K/ 3K/ 3 K/ 3K/ 3 K/ 3K/ 3 K/ 3K/ 3 K/ 3K/ 3 K/ 3K/ 3 K/ 3K/ 3 K/ 3K/ 3 K/ 3K/ 3 $ L ??k K	 &#oZ2h 
( 
4۝&mB VModUZk#tO,Yݘs	>__i/O:o.cO2Wwm'?E/o'ůx
WL;:݇čkL <J,SıweK>]_KJKǕZrRwWWZjꚱJM&_NWR?_SoVy4?ObF=lKjmFQqhTιN[1T+Wx+I_1?yH-/|< uvl׆%y&Qf3?~+ =ٯUѯg"x},~xßou 0_yt9*oE9y[ukuEO gߎ>🇼w\?Ѽ{OwG|74voqh`hȶȓdfZt*PR_r7wpQ@ Q@ Q@ğJa d'	k ( ( ( ( ( ( ( K	% ( ey _v珇 `O|# |nu'JIwcxY׵ռyza7ƳȮ ~N| c# 	ρ yDZ>?9; Z ??hKG'>G1 Ih ah  <?- -ǟG% |~ sw 0~N| c# 	ρ yDZ>?9; Z ??hKG'>G1 Ih ah  <?- -ǟG% |~ sw 0~N| c# 	ρ yDZ>?9; Z ??hKG'>G1 Ih ah  <?- -ǟG% |~ sw 0~N| c# 	ρ yDZ>?9; Z ??hKG'>G1 Ih ah  <?- -ǟG% |~ sw 0~N| <R v|Nվ+x/N J'hυKK.tF%|!ΛCҟx츍e?~N| c# 	ρ yDZ>?9; Z ??hKG'>G1 Ih ah  <?- -ǟG% |~ sw 0~N| c# 	ρ yDZ>?9; Z ??hKG'>G1 Ih ah  <?- -ǟG% |~ sw 0~N| c# 	ρ yDZ>?9; Z ??hKG'>G1 Ih ah  <?- -ǟG% |~ sw 0~N| c# 	ρ yDZ>?9; Z ??hKG'>G1 Ih ahO࿅f_mCPO h	iaJK8y8d5,X(!G        0 
title.JPG  	@       Z A    JFIF  H H              	
       	
   } !1AQa"q2#BR$3br	
%&'()*456789:CDEFGHIJSTUVWXYZcdefghijstuvwxyz  w !1AQaq"2B	#3Rbr
$4%&'()*56789:CDEFGHIJSTUVWXYZcdefghijstuvwxyz  !    ?   ( ( ( ( ( ( ( ( ( ( ( ( ( ( ( ( ( ( ( ( ( ( ( ( ( ( ( ( (˟-w {R[hIuM=rkgPyQI.cw
rpNB;mC1ګo/\?U,h:
ŀ%hc%V'Vpց0y/ʺ79^c.om5y(IVۓJb1(aM$Szݭ}oy-]T[58eh#
0RK A#FǷM_z!_  `|Q;~Z_|78OzEƣ&2}㻷RَXO)87 lAM;uV4&^vg
OnytUdݑ >7߲?[5,'#Q-5ĥf?9m\(8Sf
)ԜcͿ,dҾlVaVWSvU
+7
( |[k ³ugQ7 AW_I6
\Exf+F+Te}OOB;Saа3;;pt>k<L fGZs撗ok(z5/[&KUcZU\b+Zet(Ϗl( o b_Xͮzv7qe`ė»/ſQű^T!_P%a_ <Ɏ'<+ۇ+J'V6mdJnVݗWIE
lNIYJqn9%WsHTWySgTԜURA;f&%1 bo/'~ #eݵGM&RC{"+*6pJ	B&M
xScqyVNrM5x/[ٸݫkuLZ,vzעwex~*EźN¾BȪF<'zp:
(o  gv}Wھin'ɶAW0faѲ^2w/q׿->}RYt
_ZNdGDp,Kyfݎܹop'b8.S
${	[~fJJKM<H>ʹ鷧+OOy{ܟW_ #hM&Oi]gI[yc3E)oܪؠ3# 
C~=+[NkO5=Ǚ hG?$2dȸg*xsbe/mYN*7>h^VVi)q[CK[Jۧw[u|4n"S9b0*;ޜ\( ( ( ( ( (:b h^Xn<C$;jb02P~2s}Aҙ9b̌#+S%wY=egN;<\oեm4[kEJ^w okOc/jOXT7:j$Noe
X9mDG-0'hMk[Illa{ZvҾLw
qfiog_H'1ExCN2!oBR%ieEv3H4Vџj~A:ߋe]kSկu)_7Z2\\]LbY&vVupyϏ2|,8qy9G&OM4֢/zq^z-RmZ]5
m]_׷  ܙeĺ2Luق N\/w &~4?7Y$fX`%igfڊv;Fe9Wqf;R&anU+=H/VRT#ۢJ%vl`.ӞӵkO'^j^Uʆ"M6K0ؑ
1ctW5-JO_Vo)Ox_Ő>xck[bebK+2<LYi2j*3%Nk9ދ[˖WSt-J]l+klqn<?go/
g-;o9,$ìUtG2?WΙ],QqLx.4Y=J-],fiUҤ!IDR|aq$rYASFNUUGsJi=uGftpXM%v>omot_Yw oBmkcv%dS&%B]8,S mL|- F;f v8wczp_Q_.l0 x6zLn_*qu9G(ohJVnMWKrF:WfV^m>>HAO?jZޣos*i$0+u8r3 ɿ<3Ğ0W-	"\SHrf9|F"1J*/ߕ(7uK'	NӝV6V[kJ |f'][3ҦpXJJ4[6f U"[v?" ϟtڦQ> Q	6߻
sm,GʻZXUm3,~diG,W
es^+:pSqWVrOs4TqEZ+5W+;ivݞ6 ez$~^v5ǫ:Vt֫|@J<pɯY1|+/.SW݆.
%HqgU~U|Yڼ |ޯteBWugN7qPM]$qZ	b!B>OyF<Z5G/>m
z3kWvHkpU#S6! 샠z|;%2Ӽcmw%-	IvHCn\	dÂ[o9ͰM.::/ƤZ5׼SoYF/
ax֪҄s)4;{95̛}9cO_~;|\VF
JE6 t^1%Al~) Һ
?cThlIH.E[++BQG;+pRqV(h$vi8K3ytiԷ5Vf{-uf?֭~.~Fk*K+]F5hcID%Cn߀ }_½fW/._O9)6-LK{ˮdۆI7GlxÀq-F>oyy\]WJRM=uM잭^d>^Y]=TZѧfM];/k0#
x\|4{X 9)(v]_?oƼ<$S[XTɖ_.ܱTW>fC͖ĳ}MM䖗/D7uyyEi(^=#~Vݷ̴ ² "fKUGA~ahʓ?|d$m/$0'H؈%L)6,FaQ#Y1pko94޺%5aui%kW=-{IJ6OO~W?)&Ͳ+hU#G˙$wd8$u PG)I MoZFl NnE@C#;cfϲ^akeJ;My6ns&9Gcc8r99;+~7ӽh>x:]ǆgתfI!KAi?>@+v`QH ( ( ( (  F $W#x&?(Z3m|Iga;CO&5οu6	
̏a	*v˩[a2C~UaK$' ?~n*z7^Q=^XH{YծSVK' -Q;_iC,0xoUyTǧ[HYѯ6$2G)X\bl__]:}ڭq-I2O_5	ab-X'uo-IJ7OVۻ}Ee<3}`꓿I<{ n?l;oه:ݽ/
=\'x+,~Ya*FMA78ǚL^27ԭ.e#tK#nI!.2Dp/Λm~/]/gRɵgR#Z"vNiktUc
Y gNH5UMvj.T\` nr2ۛ ~^%?<(k𵟟nk7
XB{_ˌ[Yګ呑;01xbޮ)RZ<Ey^jf2<% /dw쥥'{ ! 
50^?eor$Sf4wQ)qv	76|8u_ڻrsCYΟkmFm[J\-pKwV])VbO*{t4^%Z8ܗr"O}OI-~)4^E*.s4ޭ$`/ Ե&_ 
ͼ2y1j`4"2GEˉHax Goؓ<G%tK=MR
jz]9fm$^᭤pxO.e}=fWqUNkލaz6j<%nC^3˫/4]Mj-' z+xo^񦟤j/5&{yfD'͙Z[ydaa7M  'lEŵ9GOg̲"bP !~_ ߋWp3*BT /3焹ycSa'$ppWӫWi^tylvVM »'4];O<:W$yc!ǘN8c~3ҿh?bh<%><mhSZ]XC-ms6l0o8KxJr)zJ*Zm^,JVS9b)${&KYI{ ,E|= pe^=|IxŐѣx~}DżeV+*\>La$ɖ%~?a? ?lٿ_ўX~40{Kiu"YQvb5TxfWFj%Zumt/z3Iv'\6+-,,ٿq8)(qskMTp^00s_5V e|5BCL++SK:[-mu}+xߕu8iھg IKvv1_2fYaxh@V`#lc3~w2A#I]5Bϒ['&Bq=qO2km쓔Ikhwi],8YYc+mQuD/ۯaW
 Ou|&ҵOWbs)Ȓr(7e&f6
MGn7^<mnB4-\/T:xCqg?aNnrtڃriY:ezM;]ue4k}s1i^KN޻ٵv~	 p <OOo'Ǌ<=%i
rFl^{Ym$a
ۍF ?7._gx'uoE(]ZY$!hu2"d _(fk2<1S;)Sܟwo4._ê,+i2^jObMƽþQcv1ٗ>b%@X^QQ4tu$>⡈`>.Q?
t!]sM45e$vRWĴRjPY;tմQuџW^ 1n_6a	!Guk
 @Ƈh-߲.uv*Y/,i#ILd|/Xa ukSmlӽWa]s/ߕQ}  xRYf]Z}V]{papjt66Q̒%e{/WE XOƑߴMiS`$Fx{hws<UKM6vos)6q[N
{0Rc{|:}tk.=F4N4qc {4W姼PE PE PE PE PE ~j (Ueu0+HJ3_u]#_@-ֻmuyu
NfHY|==Zx0JJɻZT]ڎI#ǟ355oNhz;[73ƿ/_ |gV]XyTɊB'Xo#+i@M#U?f-O<[o'7+1Z5-r
Rdv\/يj7 )_Oe_a9\x0J=SVT'G-iΜ =V%/tJ.mWZPY "ma'ψk xUIe 4Wld|V!οUx
3\I
+S"A;Ňv\k|&<>0qkY
Vp䌬kUSN9ѵk.d?o7O٬$!xW_݅_1u
;J _/8|iٮڔ]Od@f!q\m{{޵['}UݹmwcL.˩pWa*ޜJ򋎏KC *h?R]i"Vb;y$Ssh־a WFⅿ갑iį	o>ہ<q@e/ywD)Av>g>	׫L*9Ғ۴7i)ZSo6QkxT)Fs%hhsՒ9ۓRO/?g4O麞p0ej(}j&KJ
O)q
 DV=]MzKKɣL_g9$u1TDU/%&xqYN%U*P,mZQWcpY6cOF䤟IyߗV"Z[?mx@tBcjEdbIųRNj U@ /~St wRwRK]-2QÃ?ݱMZi^U^ f򨧪v* ?m?	Oo蚷<IZs[gHPx8]d3	~_[òO	Jx\mb&0hIXLQ%ʙc']N(*#*}%''J\ME>Gk{z?~s,㖺2IKi5i&~@?e+ ?g]fH6GY<C-5Y-ՔV<HP9`'wL~;n$g #y!6w,KhKZ}/mn4^mƝx{jSUIMN7mvvygEvk()ѧ6d8$--+_	?P*lBp3m ?<f6ebB~JHFP9fGt G} .l^ <{[KJ '#Gt;:
FpGf1f7+C$|97gL:>L/\㜟[Ɣ)Y*4impk+i~PJ7 #O#ŗg?^ o,qpo!HaD#tw3	MO1մk:Zx﹖!Y0<scbN;0 ueUp{H{I9[Mv[Cs<Ik%r L9 |
aῈ<eew6jAaҥ0}cJFͰZis
#[<REUQP C!+D3,L1ٲ<3|aiJ)9%7$wp'jwKP5v\[Q|;xroow
$e>%2)Qm6I#'l??@D6 Pca
1 v?}i[~]TսOɮ#]^YAyH!4"DLˑ-	7?0 <[YḓNe(yi4dYXf?r.Ty{=7vj1n]&*|IRAҕFץKE3nPZ_	H)l/|:Rq#\so
֑q(;V3*9 ./k;kRԬn#Uhx$iSVRFq%`2Թ+DZwi2i)JZ?z$8I{-TkǻQ_Q@ Q@ Q@ Q@ Q@) : H_)%L_Q  kڀNO+ȱ; F64ҦHCu9m,gdODь_e34״+FJִyU+={kPmjۺi$ֶzVm+'	CoPdڵ>"KkegVM#P2[%m-&F2IBgI?6R.
ڻoo
Aoo/
PKHD7̑F2"i톡//r_w\hӻ%8d+^2<<֓aRnݷouQR^+h GÖ6B.~9qαXG"BlU2*< [- ߶)X;diwm>Ivp91eI~wüc̸7-FN:QtMWg^uN4r6-=mV%$  `/١`]UJ
rFJ1+   cePo;Oѝ<%-JZA+ww-s$[67Vb$IbO, 6{*wKX+6m/3<E&/kiI&~?[߳x{ž.B5-u.[."FiIs"fɗ+J߶yYx?/&'LI;yq!Y[* ~3K;8aU*BIT	IITnv*_fi(nk]
j+K٫.mum
s" <wob?iW-ݖ)igkUܮY 1ma	8?U_k?ߵI׭xx}MG!u
x%
7bS>njR4u	7WKwe}750q5tG񅏀.|%D:7z$K$3ްh.c(rvHཧ'
5 "J{3eki24#rB_g7ex:ЌjFNmAIscQNҼOCCYE&dvO))^{9JM~ȺE ?_[jQn|4kˆQVHIhY<r$3!?i/m__)1Y^A;KA)srG+*%7kq49].z·)Jw)B6]kF)%y1\\9gA{sI^ FeG4T=I7vXdVeiIQ&3jFO3vP6]	9#0WWHmAā|0 ,z0ңRBq#dr%ݡx6q?Ψ>h(sFRm>q]"?ч}i?Y#*zv9ϻC
)̏?I*AF](LG77kaEӊRGUgҤ^TuRB+e:RIWo+"/u@!E"ͺo97gL:>L/\㜟g+]PӶ^wʞn]o>nnJI9|3 k	kq[6~=֯DvZݽڈ4F{Y"xyn"	DqE  oُ/ſ?YV>&aP}B[䶹Bg, T,.YUZqNr]w /c'T9hg>d~dܛmwEM*mۻ'o;z}>Z/զGm7g=ƨֈ	Z 4.a T7^~ y1f~+4Gh7!,XKIUY?r]V4e)&*%R1wwZJ694dJqkPpobzKVq䴬r! s)~3p)T
[B'f6519dOo WGoY#	ܴ{[i%B~P?w*6Kox^'.?kKܸF+Sy-wѽTo &) 3&?60J1,2U|d6?f Ce;\tk1n\Cu.Hl$UB@Ï.+^X6N1骶ٚO5'ʷn:GUx=^K?MÿetN\x^RKO]/j~lKoٌQ#-  Q9?b 'H}z Gs?U6$9m<yvD1<1
ZՌ\կJoKrFI]JVRvJ=$֎IZ\ @2^."wP2Ni>dkn>( ( ( ( ( [
y'C@'GK}lkW{[_	r_K!;_ag/U%m+7jsxԡy|ߡ'!tU${8wu^vM-sSs+EZwo]o~[M{Gp3F>(n]]d&يp%g"H\W > h <kXxbyu;
$6%&+[Œ(2\O3%.W!KWM)sr9Grmexӽ+/**k4jkky7m<e
ǟu,Ij*2Byf<g~_mӿO?Y4(i\koN氓Kw("6?>\O--'M]2ҍS'}(^ͧkO؛_-tu~ bmr["wߴg ]<~#s [Zϣ}U7jBd!A,r*^{t|GWVUbni7ݗ2is&4XO 9y^]-^wwն?Iկ.?gڟF4wxN#In.XEGF
[s e~>?hiZa:&C1iؒUPYXys7t|m˩IeX_׻^44JRi5uxO,D1	i~+>r٫h2qo?va$Oؚ?jZ']wzլ6ƭq6 $@
 +3![M=661ϩOs_{L޾qZVc*^%{]ϯa!CNMWmlS {>Q/ټjwK}{C6Y,WIc2<}#eh?o+|?/yzѵӼ"k{s5yLeTb5G1ebOiingG+?vR6e{Ggxʣ'MhN׳|тOS		u??iU5=tl 67$#GȌ>& r$[[k,VKwx[+3$ ߋ2ܲKae^nT(
Q[$|ރreʺ3Y_a(TjM{ڳrQ^+-Y 
8Əߌ]gId@×3FR+멢@y#ǵTw 	;_ǤkZfCD."gGv,	NC.cpd=bV7)U)b.ETQ0_5)F2z8F<kiC*҇[|_mYE{OE)7   o} ^͛ lJ  57 |"]dx|_nmC<en?(q8(!xGN!g{qIAzspO3\50J|\5dtJhމٴgg] >KhO lZ)I ;6BF"
o~"ga&űcb|g$q y%N0So)(ul& 0T{Y$W}oUf74;  >
<A|Mo?t`PўhcP*e0G!qI5UxnrOЯ
m-Cw$Hdla+_<2ʻZRS)+B&hv14f<.xUAIֶ|I5&ڒgu[Ŀ+Mu}S]ZZY"Xa">HRTd'?a*J&+sᣦ/Q]Ja&ױ
J:K1)LcpIԮRъU9BNЋ廩2WÔpX5I[w)]]{i>g+FN? C~p?Z R=X)wCyn#dgk/ ?b!>:?/O$_i3$|U0\s>̥_9׵z}:1`8٧m[ymj;=kr# =~0/]T<q{fk>Yљ%L ?_W97F CkxSS]bJ?
#ӸXcen,(WT&/쌃K	=?ʓyo$wZ몕9ciD-dwOZ;B_?j٧w"o[b[{0
fUYc%r6; +9(K,^	6zQD,ip-\#XJ\y[\RQ׺㦒oG55%f/~="~Ϳ 4)~K h\_
ɦOY>Gk%#G?z	Y73nJTR
|rn1*oH촻zQME);׿EdPQ@ Q@ Q@ Q@ Q@ Q@ Q@ Q@ Q@ Q@ Q@ Q@ Q@ Q@ Q@ Q@ Q@ Q@ Q@ Q@ Q@ Q@ Q@ Q@ Q@ Q@ Q@ Q@ Q@ Q@ Q@ Q@ Q@ Q@ Q@ Q@ Q@ Q@ Q@ Q@ Q@ Q@ Q@ W|}o+CŝV[~ѮAAk5̖VdCI!
	
UF.rPD_F6 |He ?0*	-Pc#/! oi^c2-ÿnYN@B>ipnTWMmZl~#	bhY޿ך>M/VW蚷\'5'WtYvZM2i"W@mYI%`:}S@ԑeIpWC-lMhi4HT\
+
( 
( 
( 
( 
( 
( 
( 
( 
( 
( 
( 
 ۡ$W` 	B&r@rA1~d ~hOfmO$-<fI0TZ\*	؃j,Jcԟi_$|8bM:Դ|QZKJN,Fstb	(V_3ԡRmٶikj{>9vzi@ڮs} XosjVIꋽQ#X1as_ $?c?ٻ^gok
#*BI쯮6y9ƑbYq}Tap|ܲJܪ]HX%9Kk.[i{$' 
!|7 D T & G 7 ?lt㨔]-y
]a,p5/ʬ(,4~XJv[cԄb)$!>~_hxD`A-b_"V1
CcpRFE{UaZl5YPFEFQTS>4ig{ |orOMiFԨ(TK $S/'߆m 31)z]K2yPʷ>l)85߆eapU'O_z0iYwx-9rԭ9%}kZ6l.M^ЀDAr9+:'Pd+_j?ëo/ˏh;_%dr`mn>R:*B2KNΥjTEy?Tz_-|)ne|P܍gko8ۿ)$*pO<!;<7jkWEM̫Xq̈:ʎ:
t5ʭkiu}zנ{QsN_zmk^<ΑhWimwvpNQ3IXݱ&m1ZBz\3*`#3$檞_Aa*JU߼I},NU	ՊEvmOS~!߲?¯>#~Ѽ]_;XȚ"8=9s<
}>U_t_Lms6Q\ $fW\2	V6ahc:'(^twZKR*5Ti$ӳ]MK--纺"I#XFK1<  &b nطW2仏w^,g{}Xc *Yw))ԯ8BRQ JѿK}q<yuMj(kWGe>*5Ï֤z,%Cۉ<Tܣ+R
{]ͽ\\$2FǨ#\[e8`s<4֎\]+kFMb(b*zq{4Gx/T:/)wIDb_jzݕo.Yq85HXeJԭ7dYv|JҔ8ژZ%u7	(4ݓRj7BU]Ջ7WZ_mS/޿6K^9ԕ9a:Q6vD%DRnR6>O;tc<ѵ&wZVmw
ڌx]@6JOuc)K*ѧS(][omv3jJe8iw]],W~/f>4~^𶰐-Ѱ|MI
$[ydesҭ|*fߍ:/ K]w΍$/z#EL;p֪%{$ԚMi^!whik^륮zƎ"I*z{׎MQ̖qHx&9JA,.Nz\ǆqKG#)[ҥj4mj(k3'3Ko+i7r _2S
567=46TDom̸XXeXцɳle&a'6KVK[<N/͵W}mhז7vzf9ђ If<3 <c߷?[6$72+y2m;|m9faT4긫HYwvZ/6UZh+֨ݥ~W~|B4]?4]sBaF{궷`ʸRGQ$5fifjcx  <k;z?<ijm[dyO,+ /SB
of t-h(rurOEc)%i43j4U&vO3ĝLßz^YhߊXEREt(pZ4O4<w {Sǌh i>%ȼӵ?i6VpvK+# +sP#IWo>7Fདྷ</&j[J-+
x\JP+J^[Mo2x'(BxO |~xAdtѴ_77	YK3Ƭ0I ;|'WF#B~ν7	vi+(PE   DF#;Oa6쯃y- dkl=J˙n׿OQ=-q!X2+I(Wd$ɶ, 
)	x 
}?t:Y鶐,
,]NVv;H9b/0e6GtkUmTL7*rvջ.Y/ği~4Z4bJ<I}XɋK3B611;0Cy^GK-]R_h1$Wۄe"[IJ8<glvҢ~r`IG{Ż[Mmlnk9Z,\d"ed Up#<Q1>kF u[ʿT/K¾6 ?	oGýV[_%캥~T+M-%elBKY%q>_/01N9/'#KGxA2(_
RvqTrr]h$ǯ?íkROlBèiZv$>dncKM o.)  	J5V~~5YXDɟ1+8uWW,;K?UӔ_%Tߖ
ͧ|$+[1K
(jչVI$ >%6 0~ѿRo[4j1
~-}>IXOq|3-ԲCg^FD_+I>c _77k?wv^8𧇬g<A `ɤTQe--\Ad؍R{v_`2|
J4gʥ+4ʽ(W]ռ帜V1T|ڴ5ՕqO^e
k'O	xZ9uBK?GM`ZH^G\,6X%+|I:T0W7.q$wͷl<2|Ⴢ;JY&d}3VdދkI+z.)ե<=Gw
/g%tJ 
W'O韲Mu_Od>:XOcX&d )|SiEe_
'hěKwca]3ªK1a<5$.^h]Þji(rJ)Erntqe?g4ʛ4n[.V4Ӗ|~?
#OmOGY]\Kcx:zѭG=w<#ܟon OĘ[+ᾧ,%f>1L#De%)U|&n1 N)O_tfԚ|&l%:sjI4$iB*֏<1K?8w+d6>1,*ʰ9?:%]*Ưgyxw62nLאIg֑Tw'qr<0uSMG)WU/#$RkZVIjUJ(+VZ)A7-ywSG?f|yُu-5Ltk%"ؒQ{! M-~4xo>	^jM6,nLcwյ~U/ݷU,* şcYOe̲ڪtRU):-%+KውnzXRħ	QWROi)iʖ\??U_+o?%>"ڎ%SlxWyݙ/
C2
5牿j^1moeKxd]=+ebeGdt&OxKܫK,0_IU$MFNsPŵϪ}ˆqykί%;Ǔf􂽭)+[N~_ b7[JX=ytFJGV񽳒# WI/ g3.>eq+c_$w2fWɸ@)#IN叨9p6YŸD/:XJJ|7o~My)*vq_,NM5wE/{Vj}T ?_xM4-㧖](XI*4
_^߲k-PMoĳn #VK)O/f3ņ(e/,M,%T~ͩE8I9)YSi7O<TGi9J)]䓗7ì9/ګ d-%࿱S]x5m:'6eVVn]c%O?fσW7+Jӣpv=A,wJ~h2Lc/1CS|Bᕈ_S((.]Scg5utҌ6PSw[\chk;˖Tl^; N~MoOF\Es %EN)"͟|7_C}/m"HVlչ;1a]L˳㌳˓-h4SӴ9~&)%q>"jҥWV' am-CL4u)2G*d,dwW# ğCI62O;/_2H٤Cr41o աDj\5"k[5~I긢M$ٿz	-<$, Y52I_	_c/xv7V6Kg],qqq3<&Y-T~ -̟|]#'/4CiSL$NDt
RSe¦D4ipY5*9=m+JIE[^ee",J\,+IMIOVw?B~~ @|* w|5WM#]Ʈ[Ĩ4c
"ə,Sg,|r2k֯wxsuңI%n^8EdUE)c埳|fAQ< }^Xrr,nTR {1]Px{)G$y>i7'hwL
|g\#M3NuiʎIӮ$0Ufh'_[sg݊Oj2cm`]\	(o1rjZO甝7{r7)7#yMth6mѮ^]әɿ?i
TxZ_o[["i~yFGOg<$BE*DJ$wC/_jOΝUxR-Ƈq߾ӽԕw#yOTYsjXLǤR^MZJjNsY.a1\.VֻZgwIFR|~~_u |Whn۽ǟ5;]+T{9Z;1\#MrE5YOI?j|MƩ%炼c-̨
dC6ö#d5sJNIh n6߻ے6*{vetnZ ).

,joNS$m=
o<6"@7M8R)O/S~ji^#t"_RPXwB(ۅ{a.+U5	]E.G%~Ui7&+RJ8S֍$w]UurmZ;5]K_)	l=Vq .
Ioso,$˫Ʃ  /h/7Fωi-& _1.u1fic\WIU
1_;Q$uO[J^.f݇oM~7z[~_u Q@~f o"_$7ie2 pA-{q4}О wV#߾mȹBT!
 o |Vm7VomaRm:܌!QxՑee18z8ve$r9FOvkvKͧd/:_%  .FH*z~$MbZ[/)eLۿ/ڋ|&hvBдPcҬ-=ymo{fU?(S9mK2a}4ֶzY9]:SW-ֵ{Y;] zTRHJ1<Is>&7FhGXA_;^|Hk>:YAYq$7P\d2`5qIeթ>IU-Iw֎ZG˙eJuWZR&.O	w){:wO
]i	2$M2,ȓBtWpΟKT =qxSÖEL**H7t,-hb18\eIU)If׵ﾖ\3:QTEJQM%dgki}wz?5V|"oT񍎍1da`0澑E]ˏHÞ9oGh
:q	Ęt݄cշӫrmntGI/>ޚie{vm\74}FK41K4j!W|[x #'	࿋oX94?Py.A*Ln
˲ʕ"]x7]|ݮ{J_;¶!r6|k\|Jk;[y. RΛF%HX;N`ie?fOѼ
F(D$\|a%qo˗+zn`ww;[޸i?m](ދGk-լ*i _YiV+u[O[ܴr%:frqBH:D]n>)3|/&
|7Ց=yW
/2_8|A䌠U2OUJo+ODvѽ[Z15k=!gmG[J?j *xT"Đ#ʯH_	+ZFgRfm~5 XDd<s6&E	"\8.`໯h*8eM:r[YY43T͔"tՕoݟ+o=c{~#[g"Ӿ3|𿋴
Vk<OXj$0#Kw6eIP	+4?kwkwQ774	#CWgPy _:yJUXV^~|^rիjzi,U*T ꭥʹ޵ g  v~&[|@_؆L<s$nI-y,I-#G#| ೟oWg/ƅ,{gk[#>cY+t"EM4;_Y/71
TZJsWs(Fҍi-ss81YorF18ZrmZw3ehu%%Ym~1FտiF0Zpnڝ)YKV$̛6+:![z l/7,]1n#0f܀ND4^Ke^)JKT\rJ7NJjU׭_?|LQNm#I4r4ϒI$tgh3)ރ?gfO#ďuidYQ}#??ii[z!C ƨUsX˔p%^Vd)oKɸ;w`rROިݜmˋrږG9(ii H6VTm$wKU W .ءV<YaIo&E,V\FLyR펳goeZ&tݶi]ъQsRZfz-֞RrJqIk%+$ǅ]FD?:jL3}YG<QֿʢC+y1;
&Q!(~V2ec
aDI|_t3tVU5k;ž{Ynmk_cMuI^\_y %,1;ArXc!h-A-´vޑ<pU?tJ+e'gVg.xU({a)-eOv*%'-y]BuvtpqN񖒵$՛	*$ʢaK	U'^B  *tS1 i X*#b\}Rmn+ݙ_kee{uvZG,ӫwoNl_Y4o7rH%eۻu`%8J	ula ,UlcyF*8$ 6v6Y'{Z 7JRt! .+F}z٭ \k) fO٢F_6l
FHs4eCy]vgc ^K2cBv4q0W̑-d;g]׭AK2ݶRQuZv*Uh^95S2WI9>h;s[3 uԾ kχ?įxÑkZOݔ=ܾ\RB#lG/GUxOG)VlmH#
97G)!tLg8b׌!(iIۚmZъW*vV|&hn;;WͤRKǂn?۳a7^7L^YiV-"̱ı4oo ʒϰ5_C ^<kkMD
"kU18ͽ"聹s FFqy\QyST8	$yndt`'=v}VͭIi&?\1ிPwt !pҠm7
GmFcFbfO&'f |nP}{]w1ݻRß;dXh+^.rwMtMZ7
_Y3V{[&D?7 :'|_ඳgP}SU[ዻVC5Z44$sy|}ÞwC<3G:vv8- PX*^T*Tm-mcXh
( 
 ? Q#v M! ǤA8I $#l:"_̿1=*&bp(%~Oݻ
oQ.m1]He`Ar^%r0϶6Wom9i _ҶuJ _'XQsƤXK
| XmF%Vl&4)YlMk9LVi()S!t2+; 7)7Ovwg9Z9+:mkd앜RNr.jeoͻt?zz5w_q o67@'!-,,m*g|_jIHGX<6JQKԡ--gI͢兊Ve׺Zkoĝ*__ [t{O9Y"2(vdEm1RQG
x'Ὲ*YM6WP}XX[3#aR$g$5u	 ظ_Qqz~Vmi_Ru'+^{o.% ^7<WVԯdo%T/$rB>_-#c Ib|ZC?칭O i.^XXZ=WLG]Ƴay+@RhMOn^
~628\-YNw~6JwqRݼ_N6]Vz7;|P }ɢk$2: -«2<),? !i{xY<+akc͖omP̑ "%C<r}
m)Wʰȫ[M4~Y%IGV՛ڤzZm>iGxSGYw5
I~xvmXHgS]f`A
6򠉼ƂU&?gă>Z­H8cgD4+.;c T+IRC#I:o|5+yrJj*wjcm[rJc iιK ޴h݉ӦWVc.хݻ̈?#3#DfTkATaj҈3#ylU/2UkL*OX:|V_+neBflˇn_jKζZYsY]\[_'EG2k'5Xy7Zw}=:-. bhv/Ne}OĹ=WOvv q[jRsAAq !*ܹg*e۱uo?_
:h?gm+N:S@lmѾ1dszO/=[am{n_>y]|T+?&F?8x:O)7}ku%fkq
X cy#{2L[|S kσ =2F,e)LeI"F_-`;WoUG
Ih>WRNʹ{e դ:jOkּԬm(N?" w6޺m#@WKHEm<b-9~ ~$G3rE
aDct1Tҿt-6Q\
&NEk^VOm_r# ;G,doVYr(i2`#%J %%Bg7TKr}x@Gy+R5R 0O!.kI=<Swq[WN/LGf¸yJiu̬`QI7)])sRD9rq* D_[О=kkt.6[(%GU?.Xī
*H~7fʂޭsv/yN+7ٷ>UdJ2 M' fvtBw':hB1I		uiQ:bftC;6dߘLh+.>1q깡;sV\K_+[4[W'M FC?\	V{mv?l̀T1Jc 2[p:3м#Nv	?CKq+W}ޱ^]RwėVӽVMX
v5vr.=A}I._r|ŋ?Bf,quNFkɖWL6 -+=o}[ViY)ox+ߛrץܟ??gUVb(شe♴; =/I|֑J<*
 ~2K gĹl8LceA!Pl.mYUAqX㜢sGv:yYխoFX|6\7}nޯt\d, F FxK'5߇>$:mIk	_;МݦWo°)?'W	}U w,u;'݇3Dcī(q٦4𸚴ʒ,+/2N7kD;24eCT=ޭ'-uuvWO]m  f]7Q!G=ϼ?b	z澏U<~ 5 w_~ ^ƛY8o"(
C
۸H3|FaŮ\V&uiNR=8ѥ$mZv? ]ࠤ4Ne_&ؐ`S@N Xτf?O!|*Yn ?&IɾkG~OvגN8fOMtr뾿
տB ( +|I Z o
G_]H.duH-irp@9qU鹻+\OfLK/);Oڝ9'#ETQd6s' fD:jˡG`>UA6s=E*FU>^}v^WzuXPN7|| ψ|k~
o 	_U7:Ə{;$:ƨbp~~h9$o˹qi;hL?)kY\ s|r:U%0ĎdpmPȠ((v.^u \ٻA4y5
PZ	F>`0
Fxӌq\d0]Tqu7%ZFwI&jҗөS4)6ZɵmҲ>+ }uƭmtٸ7-x&Un-.&YZcEvX"7ym-f1Wz%ֱmjوEОCGX?_n<q <COoa 	۝WÚʩ-ͪ5͡0D
QZ[[2<0 C ૿4 ٿZԼY?9#	Im61EٳnG)IVݞ%c|[K$	v?rG38u"N1|*OUi4^VKvPΦa-VOtj5''g  |xg_|hϢ|3n
"$mi` Ķ>lRwMErnO;߀U[?USϔ.p>{dp3\o4+я,^Im'o+hX9`IO⛻ZMi;7_os icöz߆<Gqwk+{+PI-Ԛj--A,n!/'G^υG/jط(uH<?=MQ f_O| agFtR5UԔ^'粓J.Wgc2_SjoI%捜twi/G ^  {1JxRծm-䕬t.e$0LiYbf[] x~oگ㧊,_w:M̭"4fkGM G[2ea"=yv3דӫU^Hd-/'{2JVo[diZFqI+C' 1|*Qk2ZҼ)^ꗑ'h" /dd<` (?c >x w}VY;ie(eXm>Kua3pu8W<JTHFrn\E9in][(V))'ˤۿ2Kwjiyu
qzt/<n 18r܀\@<mnOjzn麆YEs]%ͼ9J:YI(VMնY.iMrN߭}oh =	T~Fx +-wAgK<Hm5t֍)(9ddheOV-.7n]%VLwvi#=SaVO.\Ɯ1CNst("N^;I-W<'̝<4g&җ"y[rRJr?߃i|! xDOY|/-kMr]^[42id,oT67߷D/>|0kWo=^xQ 	=:]DKܨ
 yhrAv^<܇<,EJ^ϒgR0XKJ\EiyZVle'yEuQ>Nڥeb~.~:ξ945?T-sݗki.Jb7[;<3L|Qev1` ֧[2%(ʩ,h!TF"&>ĪT^5MI5iIk(4^&'95)2崣.-ӓnW_z 	>+b/ű@/&<;^jW0EjlCkdRqO _?n~7?BWOZ/}VDEv#HJ9F˄cBQ*<=Zm>iF(]8Qfx,UN ׍)8)AF{ѻִ_=r𾋫d-YY'j!]qp9̻
 }W!0K /1J+`O+63Le:JNBKs8;N[$Ӓtq..XuFhv7dtw DG~.ON7=6zE=	$HnJS?c OTo)ēȿI4(d[  1&^n<~2IqrZUog9&Owz04e'OOvI|Ir?L
3~ǚ']2Rմۻ[:N7 q⿙8L>5 BO%o|9gS
֢Fs .U%hҲpaq/B4JM=nJR_TߙҭS+J0nKY&ڲi- tm37_a>	K=jZ	wP^~؁(gTr<e1o$O_o+E.	hYC%4FlL1I)%8{68.kYꞪ?ftiTrq;=9W#ߦ>g # ` sh?b?eq-:`Ӵ 58Q%e]2o<//;f;v?Y~i*v	x'Q)E;VoЯaq~"5)S(FRiZ]nԜ
HjSE'M-ޭ C
   c/jڏ_HxLP<#6_*؛Ty:-x[,'k9>%jݻCii|$ M$Ox:3ya+NE*UqJij7vvVNQ'-/&Vnǯk  v2xZ?]JixDox{d{Eb*\O e|=[O#þӼ> K$Koo,!k@DVev~_I唩a9bIAܮ9-[m[
Um_7J]'v ̃  |G ~ܞ;m|a|H5|3힫[l23
q \?mែ4|
<Y5{xoR.KJm!Y'2%/W'QV2kOkodZ{47/g"**Knms4
( 
( 
( 
( 
( ?O+
C Mh'gOis]sJ&ރ{H[u	h[iTo>I0o' ?ࢯ^io_ؚ诩}pL,ݍ ,r0NN77JqQPJN\њR|ܼk3;
E[JV挮ގ<ਟL!DZ?vlB V[ya#k3<4  i~?Cy:ڧu{8vAGmik2@ʋ;*i'boḬ9>GC2ĢQMAJmSҞձ8I=vvV\ͧe0JFB(  q+ ( ( ( ( ( ( ( ( ( ( ( (M
xE9c~{J+yC
J
| E{|᷇D-p#x4f10*QbRRߒryZʥ
5[kHx+:EZ6CF>XEUkjroV.1"d AE PE PE PE PE PE PE PE P         New Button  @
 'on mouseUp
  go next card
end mouseUp
                	     1 
Angry.jpg  	@        o    I JFIF  H H              	
       	
   } !1AQa"q2#BR$3br	
%&'()*456789:CDEFGHIJSTUVWXYZcdefghijstuvwxyz  w !1AQaq"2B	#3Rbr
$4%&'()*56789:CDEFGHIJSTUVWXYZcdefghijstuvwxyz   !    ? dO?_ >.|\wktm'X_QvYYoeekoPAx$K  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = L)e}gF|__/[O<Q-S^?􏈾*4'ԵI罻=I<?m |%  p eOWݴ Q@ Q@ Q@ WsX w _uZO֯|U\1kSEVZ$2E#_Ag>li満~:~ 쥨>h[8ĝ?Q[[t"]OEH-݆MvT~_֣G_!?n
ix?	5~ZkI^е%[MLv"Ak;F8u Q@ Q@	2>$~ SUm |%  p eOWݴ Q@ Q@ Q@ W/ߍ~(|xឩf͞>D[]<;dᔀmt  wV
79D\h/yskri6uVKV=
^;O?೷>)/Oٗh<mcOy<Y:aw^
/y[O&
Zk7Lu<7'o YhW>,t^-VR?ĩu)4lugӴ]>o_vE PE |%  p eOWݴ'MG<e_vE PE PE y'M??O/x7zi6Ǎ|Kv77G,mF4pO 1baϋ@迳oZo*o-W:e5M!k5M+}^;}/[;=^ 0w~/Wjzomanx'N;{;';Ioms}'oSOwS៌t
;>ԾqmܤsCC4o:*  (h_ڟcj>o/P:2O2'G]ە#W	]NN_n~j3z/)6,EXa8o<}nn&/
R}Yh &/׃?aoNڷB OK 6ďieh3H1YYMxNMI@5?s~~+M?!P~$|/.y5eiSVKg[5݅ 6 ( K	 &#oZ2h/&Oď/jxʾ ( (<|1VxntأH-~:
zNN՛"RR mLI[Cka xc_࡟g h: ?zuyK~#4Mtm#?Y,/6m]'3&Z-Y
Ow߳ hL5o7~3c{.Caei f34ڧ]wO=62,GJ?g?HxCAXlmHhYW	gYT>Lr
|_%'~~F >OP(~$\YxcAo g6XZ`-i5{="-i֖X=~?ۿZ;Z&UM>[=uk-.a%fyavfW|Wo=wڂߵ o&-tNGmT2xV->c0-z/) G|?i_
j66#ium#_o4/$v#}2}/vro$rK-ou|( 7??'vQ6~ wwM6	`^ }E PE |%  p eOWݴ'MG<e_vE PE PWÏ~!xg{_|/T|75]\ P j7f4M9,#е-~ߢC}GK~)x]n?Cj]ƥzw66:/Epa.kao^ʶbY.Igj >Z ~ a_ٳǯ|G4+?i@5<ay#- 
jZ57׬eki%R<ď5ºy_N|O>>7.'M$wyOePp ߵƣs%xPվ
;þ%7	̺.ek%VW@"W  ~^ 'kc}rh4ۭ/[(Lo`O,QHfHU ?ho_3/xՍϪI|D\G!6PMגXѣ0pŕRjGO  Wt
{D{#@lRCf|Ae4^e-e[;{Z<SU'<=|wwK	kS^%n{5Z"}1`ɗηO5h 
(/&Oď/jxʾ?n?|v թ*
( 
u=
3OeEi\ڧ<	hwaK&ZjTpv`No(qwe: ĽWՍ?
Z%63y$z.MovI7o0T(@_LO-<1'
>eBhotIԯQk=Ss+}
Xz`0ϧō   @5|o ] '	X߈+/Ӵ6hI5+Bl/-Ѯ-ڳPke %oc4 A>,K_>|l|Gq]~!"hXC[Z^_3qHb
( '+# ?Ux?k?fFEŷhΩ{{m`G+vvf5 _۷L|=@ /⟊^
 i1mr;fIgÉHd]r_&)9uH৿L~" o~kﭾ]RCƥmxJ`<A,fH"MZk;ݴ Q@'MG<e_v_L7_;}@ Q@	GK ?~7?L?Zo[jvP ;>Ŷ_Xno58.n"Jo#?|)xv &PV7C8{-"7RP ? / tO~3j~|cx¿çZi_
+IxZpJ/}i'M$~, C>~ĿSOM5ivm=o3ntuV0 _ON]B}C9t>k2Yݡeb,ys:<UJ o߇k* j:|' >5-jmjCsXGKp.aUC6P	^
%|ϡcLb?m6+T}ͧ FKI-P}Rgk  PO? " ?'>_''ڼ.Mf_ygyVE??G5* t  ?߆ '_ |	 	/f #G$վ?'_Gy[>J(xS<
ׂu>I4}ZZ6ehX'VWWe`A"9 `x>< i<<sj׍>յcVVt.nn&fyI%vfvvf$h( > d ɸ|H  V K	 &#oZ2h 
K
0?࠰\|Ym\qrw1p{{m`w6MiZ{cy ݴPA> K?k/ޡO"<7GW.g^[hsu֖ͽѵ=N҅j6z&wq[D ?N  X >~:࡟x<)}[T\KxSыS:R[
ޞnfM<y bx7 y/-|׿f- ?
*ǈuF-n^7TIcݤS??c7^ ?b_?4
s_e-\7shtu>t=cJ}X`W<~j AROX?c-'<G"<5|1|i/]l]6g6 Q@rĚgfO߱'ǿ5#+]G:-ϝx~It4i
$r%Zܘس
 (   @_ |o E f/O1C<[úomuMCWEu>dFd3*Gu@|%  S 2< sMh K	 &#oZ2h/&Oď/jxʾ +( +kohz6<a}7^(ҵi"l;
NYMJKik?ۀk?/`_YD?h} }Fig5.kX&[K{S?m#K.pPiT#SU ơ}f$as4l<5{_BZ͍F˥jLV
g-߱E _iڟ|WiVO݇teUdm25oiI
F;H  J {
?㿍Gů|-՛3|&Ouk)qK@M&h3f5+Y5o &/ x_M?ax)xXмWwnw$?+%/!.c2yڼw)o@9-Wx6k~ψwlﵧKˡۘko#	% > |+7kxC>,_h?.Pt
FmSaucwq< ? a !\싯|1>[&XG_ؗѴj%Kſn ϧJh 2j C_|_㯊ڇ%xRtZ&,fTThWRKkKP( = f/ I	e
jW+w ?XYm^>5H%ineӧhׂe.m }?QO 5  QJ?<a7
"|)xm?>oy~[w#dEyϕ<P_	$ L ??h( > d ɸ|H  V K	 &#oZ2h 
K	O o'B'^8<uuq^N^;(o˸mc-%ypk;χ~8ӿW?xG7s ᷾Ϗu\oxwTҭ`e4k}{c5ޜ-YA܋wkp)'_ m/ «>VHm1#NT}Zy5a'{ W C3 9>Cf gqo:亗T }iyVp eG&Ѽ{'$N/SW<A:<KM׺H൅=[_  Ie#Nu ??
<Yټ֚e/~y,VB<sq$m/|?%h>Ƶ𯎣3ڟw }K?>,|<Z~|Sj~Ouڼ׺Z
)AwH|S_{G'Zgk_׊<'^[=GD9VIFk-3$@
iA|
~7~-5O]~8>"W%dNqo};o&퐖O<-E )?dOuoƻ	(m_ZRXHa'X$m 'oث?PGPFmgǚ֝x{46GXEx{VQ$S;)x3	+ ,<am?If#M&JXelmeV,wU  Md}:Aw/?~^v:xw^>piY f2LbeP*nsxIEvĚ-XW	Eew,!GǄu_ <% ٗQ]BCդZ挮/a<R5ν'X.4J~|$__
~|_e3vx[úon.>;K8<뗒ia<]ݶff$ (?n?|v թ*> d ɸ|H  V ( S ħ	,/ צNm\x;WckkY$H{y yaFxPwi1~+"L?+=4+=ށ]
$_i(ִ\]$ZByw_z;~>4SzheqC}u&iXOh:w%+&_]h-~x<OogOּiNp7176+G<2:+	mG]%:P/xoO⯇tGhu^.k	Ю./6KH)⟎? lgP4_kmNkMfE/t;KYIMu'th\[$j$^_1t){ ~ & 
?KG.uO5[xRռ;o/M~V>kk[]L]cQO gS' xؿb 	-C_iE+7۷࿅bZO(_ jw]㿆:K
:}<=㴱6XmKE3M5W߳σo? 	\ዯ]H΍g{BY7ڧͽl#Y fJ~|<9z\ſcuiw_뗥.e{.%Y%y&3. %_Ŀ{F񶁣|L  	K}G\ԼiPŒia iVa,Mo)7/ 'iK~CXMoymZIkhXo"-s~umgO?h?*0x<9?iDHXt=Mo!mt6Kg?K (?n?|v թ*> d ɸ|H  V (2>!' RAa|-\÷<wEibڎq里]R(6;S_ xZn>Oƽ#2_SL=KJ7ψ<O%1jM,MfKTfK*~ڿV'Ǻ?N?:m3u)wxaK[OL՚ 
iMiZU ~[~?TڻǴ 
|C> ?<Ico\dѼ_<-,M2[۝̹oɬK{[{s=s|4 ~3z?uoin4bX'Ϥx?
4iYOz
9QH <>%5ڃzg>,7M&d/GHo[)0è.iw3GwPoh_N_ړ<YHxC)?|kI-+WOM
̶hW֗}w߲TQO 5  QJx|-  __ }o<u3Åh=Wlo,w)_}ƭkIK<J쪊@|-j||_ Y5[P/uh~x6t67^}QN4,Zt=u?2[+ ?>>EgPk|#M~-)-gFQܦW_]GS:=XtKͽ͔6yool#  :?k2;j^>I&Mwk%]<{k,4ߵH;Pٻ Zt&Ou=Nß~x:hmc]+R>"ϭnQKmy;a,!
w?؇zm+zKºC	XbtM'LkK=bkiTkI" ?lً/cJTڅ֒څvY_[0[]
ݔ^)DWN' > d ɸ|H  V K	 &#oZ2h 
(j?|w^,_
}?xV|?},vaِm>r#sٗ|_|ǧL:׈|s
FCFӼ=krm7CѴYk!ckQ) 	T3]5׌'!\R[yj&'˽ƫ{O.qtc~<~SߴQ-{~ /~y?xw+-/]4wb𥷍!fK?'?f:<j[&?N{sMMkW> Iҿ-C}={
Ax Ǻ  @5?WO|_&-jk)
^}BׅX߃eZJvz_i/>>Y|84fm{TiDZnr
eI 'Q()7 G_c`i_|#OimO742TY<:!kb:CbxgH:)_o[ᇃ. k
mg^Sе5~("H'>ga%䷰z j|__F/.|f>4{G6xw}ٕmϾ-~3|)ܳ)Qό.Y-Y_C$υ-K3OOwkBIxV3", k/7 
kG2xEִϊzy)WOۧԵkH|7gq-Kk`~_~^ Q; >(@}Dn#x77r~94??x?^ZM厙qm]ɃIůɪ[DceZ1v@v/W O ^^&?,  T>}wx|>?f
jC>	$ծxkMno(^K{h6bƤ  Vm|{ X?_  ؾ_ ڿ>߳}oh > d ɸ|H  V K	 &#oZ2h 
(/9 	gO?5y  ,/ (t~/ 
?G!7?
|C46)}<qт9$%ZجFѾ=[v| GAx'SU<fg'<OSZhǕh:G37؞Vyo_?e
s@c#O:OtBԬ|%bcivV>]~Tq o;&E͟u
{W~+vž𮧤ki|m ~Pd!KQk9"ō;	 co	Kd UsO]Xl|
Xz	IRQfgh .@?&?
O+WA[~7xs xQC{Av2LOs	&D?# wƿ*G4 xOFFi ixzh[V5;uys&%v  mgƞez<%:~ <#Ko^k?쇼-/uutyBk?G}Əڧ  5/i~	_j ſ|}ruq}wjCcqcgq^l^G$WO[|Tc1\,"?A9=GWZjLZy>+]隽9	 `iϏG|_M?Ě¿
qZԴ~//-/1to6{
vkco4צRiZp֯C[B?a~ឩ >;ԼE꺦 	?5kwcc
ב6Bű?R
67-4m;m~ڶ-,uMTX&h'XeMvwI%",,Q}E |%  p eOWݴ'MG<e_vE [_
~&i e3vZٮ.>KdiawmUf  `/:M$|&Ѿ,__?4taJ"䍬m^\o.4}Y@ Q@O3ĺwiojNa]M__x^XSObv<Ek_4٠֥n.d	iG~<1xOּii7716G<2$r24'	 5 !g5sXt#L|76"GDSm |؟2Ƌo'[Pա֥
1_X,+crv[-(tBظ|;; 	~.~# ׌|1]Ym4+0[Ꮍ{s[NԚ
Z[hq(ԟ	?k?,V_C %go	xG[
M.˳>Vk[#M5wsl[4Lm ~~'M
'Cßx7uB
^%4/QYK]jVj 7ǿKw|__~<+J!K\V;Og^+|!C֙Khɢ٥ gRտ_~&I xKǅ4%n2kЈ}Plwxǘ%pJ_ۏ
g#? ,xVOAEMį>f6nb	^K?& K	 &#oZ2h/&Oď/jxʾ +/ڷ   i_ZVc#:_/%\Ԧ/5+]R5"'O ? R f>о#tƠgZukYUZ_cjۛۛv.܆f'O/?  uO~14wR 'o/P&Nh|fcG]eV = e/o>5  ?h_&}#05|1.i=aiu+.,XLdq -g?|
Op}<,uEYHfXU"/ 9gx^6<Y~ աG'ִ}Qm"Rxkː{Wk
ïHYϏ%⋟#k>!I\ծ~O FӦ?>&!7 Oڃ  zO)Q 	;#@5;Hտ?h˷n7jtL[=ҧ D?e_Ŀ+[   <m1|t}伎ݼ|QO{F%N6{ɷPm  q >~1<[?~&B%ڌܦk'T5lVvصk8'PPO֯_(ckr퉭 e
_.4Wu-sViۯuJ-V u ?ݿ R~B:ێ4?qcZ	>ͨBS-e |?f?2~+i_4yW7dsTsoCXym}ɕ!͔ v3?c&7O'_3xZ--;B_m2[pwv@v@	2>$~ SUm |%  p eOWݴ Q@  X߀ P>
<+|Nu?IKtOKm0[B]lL
ѯaߴ4/
[_<Y_>jyTӡFu}*$q781DW_K_Ŀ>|
?'|\^0I{5i5ԑQ=ēP$(?i ~'#:o+u/:faqs;EIwpK2i$#>@nxig_?_4|) 37 P]A5@gM6 zEAwGj~C<|L>yvo|yAe8VɥVFc j׍BI}'
"Vam$K+qĊ	 WIz׌>">#چg]CǞ/bIw-:Mjچ-V%uDK땔: ( (?n?|v թ*> d ɸ|H  V (  +?<| {׊#}_xiSTX#d,4}:.LH +P֭
7[P|φ~!#M5T-MF9PM''ȟeK)pਾ׿qgZ} x_RO<3e}&cO3V_>̳o,7L? _ړFwc o}wTmXMd/cK{+&"kFR8nvh7?<CD|
jX{u
GBY{'ѯ_G:m\ ~W~_~"~=?|)kʈIWmI&ib(DF 	?TOڟ ~?oOw[a_	xgB<	u"{
k^#v}}5m;{ɬӒgmm « i?*@ Ggv.sxLd
i)(ީ,Ϗ~*x 쑬hh3xZ`Kl|[`EѬKZXl>4??>0  MxM_z$r}P𶭢f1o5^<-(`=%?oٳYoٷূ>"?6z\ju+Q/#$rO"XYeo<M|;'. Z/zzxSϋoj*j%5|f-o.$|rs < D oM k gپ /i F/?6z-~^/Ο%׊n|I_ºREäMa6<2{kLgNm@E@'MG<e_v_L7_;}@ Q@1"՞}BIeOzgs
`)]#ymfI3oG cm

?PVľ	䳊v^Dh6aY[Ζ(H?ԓs^/>!;M==s\ԝ6pTET@O4pCm
I4K1G$"7])GW:~uߊ~uH|BN,5.C/.gm4n S I3k l HK~Y\KˈpK2eƞ6x.Sl[?>U?g|7{;
|-wsV7W6|u_PgN<} t=/o> x[eSm`Yl/A~e˖Mi 33]WCSմ?jUߊ&:._943Yo.60F|??&O}#o!U P\O?~7^_ខ zhzGqivC741L$qP@_ؿI F__g76[G~ww|8XⷷhD:>
xcu
{V쮵Z;ﵩQRkDfS,oo!qFQ@'
(/&Oď/jxʾ?n?|v թ*
(  w<-
x9Οx'Z4cGլựլnchn-mVxe9"ueuvV+~~  _saO|-|N,ZMxFS5i)#8oe ?ƿi6QO2X&<7%]?%_?! MV{A3ĚY/ZYXt+(&y$9~WJgE P a? o(i߳ i: ;cJDg6GiͩK$QV)/yPE PE PE |%  p eOWݴ@ `~3|/r!//W4SN'x>9!)z
*8ʰ'ozc ?:zc ?:zc ?:zc ?:zc ?:zc ?:5m ?n~.X>6^6m>9|?G1tn$7D]Kldo+ O=g	o I1 G=g	o I1 @=g	o I1 G=g	o I1 @=g	o I1 G=g	o I1 @=g	o I1 G=g	o I1 @=g	o I1 G=g	o I1 @=g	o I1 G=g	o I1 @=g	o I1 G=g	o I1 @=g	o I1 G=g	o I1 @=g	o I1 G=g	o I1 @s~/~kw[G4nuk0hX$TfWWVRAC 
( 
( 
( 
( 
( 
( 
(      
  2   	`       ($ 0        d POne day, Albert decided to press the mysterious button labeled "Don't Press"... 
  3   	h   
        X 0         True fact:  Today's fastest computers can do as many math problems in one second as you could do in 15 years (100,000,000 problems per second)!     4 supercomp.JPG  	@        @    = JFIF  H H              	
       	
   } !1AQa"q2#BR$3br	
%&'()*456789:CDEFGHIJSTUVWXYZcdefghijstuvwxyz  w !1AQaq"2B	#3Rbr
$4%&'()*56789:CDEFGHIJSTUVWXYZcdefghijstuvwxyz   !    ? dO?_ >.|\wktm'X_QvYYoeekoPAx$K  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = sOm@ #ǋ?u<E&uYmu	ԯ&MA~P_L7_;}@ Q@ Q@ Q@ Q@ Q@ Q@a ' l g_v_L7_;}@ Q@ Q@ Q@ Q@ Q@ Q@a ' l g_v_L7_;}@o~˦|kOjV:|}3"Nh~,";>l.wc~qLӮWys\G;񞖻vaة˖ kmm.vLpTe!(ac܋[d@HQXrx<qC>Fy#x<(c/EHh 㒠֦OhNPc9 ISKG? A[^#gOjWZC%;:ƣd-$[8pXI`{_?n/[ŪEס7Zuĉ mn,x'_O3B⼏ksm*ueYA|kXmq;cRuNCo5>Xdu
={ XWŚ"] h#4rOtIX9 :̀?gR?ƕ\}B	$`- d}EAE P_w }@	2>$~ SUm M*0QK@ A$|=<~`÷Sd`}+c-v/OSѼ7{ǄD)xLTϰkwx\qĞkBi9ԭlwރH _+Q]
^#[yӢ"ZG%WSWP*5^+gڠ/yx 7z<)+vWm
1jZ9|W*@r>ϱT2@$#uyWU ؃t rAۂ(ר _"N7/ds.S =ϸxޡ?oMYt망y$RW_cx4l	)]5_2|= ~uu jj$m)D9F_W߰l:O 32{  @vDKs~,/a,>9<Z
EkX	$%SuTN f>5/j~!.KYiȹ% 'A{/6dդmS$q?'7wk"2@'f
:X9Vk_1>*&.
gxr9q~?u?xcE.ⴾ45<[w#[[h(Jn^(W> aUFG7<uӟ9/ouo%׾YS< R4(5
(/N;
 eH Yξ?n?|v թ*
5L7PpKFNX=Hk⏂>"zl-j:z4t11&fɬ36LIG<O_U$7[*>z0G>/~On:pkfBG)嗌1XO ?^}P.0Gtg'?1O~KxcF; Z1kZi6M]7Mr`dy# 7e]E|߼.TԿm۝t	Aʞ:way27<?CC6x9m8ǟ޻ axz/)#OQV߁t7RnZm*Prvx][3:}SKK
ˌ>\?N?|;Nfߴ7cH=1}x<}?H)/XR;JӨsCzI_cT{a/cItk2ʨ2RH1?'ŝNQx}>4
eR AsLj,UOWGXzc+S|0 xZÝnFĚ(JVjUr̪2ܖQX
j_/<q_^_ 88kQhz%a ' l g_v_L7_;}@+kL:Yc~Z)~Y`VBW
0G':
3:/2fodRI#
~X>]V5&е$\gsﻛ<iwڵ֝.%4FEsK.B6$t=oQܒGtnGL9Oo񭿀 ҟ='巄5}N<Hھg
:KIwϥ2XImEdț:Z4 ^ac/ú'b/x+>w{7X-dC%v_;Q#x'];HْMڅ!u"f!#\pri9_O<ZWĞ5kCcsqk^Lv=OP7Sl<yl  ?~˧,N
歞IN  |zhTb2?sE)u;qlcYњ3B2s$sۣG'Xܐ:g^=G>+%& )|i⵿-#{/C,;۬0o1y.ksRn6}:k KVf#?;RO>?d?uOx[VЬ7f&.7$2?MuK
3$YρAcH,|5XHSו	Xfzm6 mg*OCG[?g3{]yjގǒn	r7gG?gl +|?7=f:shXQ@	~qV/Gφum |%  p eOWݴ Q2G?c @j7į^37/kuyv0.Io6W"W{k;fmxG*xZ+_c9;^-xDeNw,2KOPx<{{I:㜁Dޗg
-S~ZOXciWɆ#G8,:u?d6	$g_jz?>'ũzFO4򩻅d]"gmEjn6ܴ_Ӵ;oCּ/sWH5-
V;8A6n&@$d9/VUtE>.-5g8ܣЙ2䨷m?tGK/Ht3ɛ'ɿ̏Nrٌ yYgSπh>5}W/􋻉C:,NTa#`oB>0c[u=1\8۱'k UV#G&xc3$9S >]/:(
@;/t >~|]/_R+
<0!bC<o(]),GG8?m[YؗR|amzTgwϱ
ԸC!U?t)}#|k~
/<-q*o"w3,5@';0JnCŏ ϝ>I}ϙN^01xw <:|3Cv?m7[W,!|Toai;\OLA{a WsS| {w_*M K0  ~?V|3h/&Oď/jxʾV<FOgҀgx~DRkUBˑ=I!duÚƝ9%Xy7$8lg 8z_oR<=$M-J)bm@A}[GMe<Gc\u/X4]V'YP|Ov0>lg<VK qv~^4~|񗌴h-f|G+[OA7hxK?$3_Z1Xٙ_"pzFn y'?>?ZjmKrwW7S^BʬGofDVTk><P/
|e=N}P|Z!x줺<y~G9T 'mwom]Wlz)PZsm u.O*Q.@\_3kڎcq5ɘ5dfg
w_qvN {^ŨZIi.,s@39'b#bϰ4H3q  v~Xb6:_۝+kUxߌ}k 3GoJ1o!'H?*	Rx  SjMt+׶ G?Qw1' v<q;0w
Bkgl 
[7\~=VEIaE |%[?i>ݴ'MG<e_vP¾%8,.=zP ><gory d`120y$c%8=#'M] pGlF~\tq8 Ts zダCF z_'Au|'/kBr{o43Z91_4%oMP$[i|]<eZ?1*[NV3Q;>0_	x_j֦%sd<붻EhU10/ƿ_~|C3~:~ڼN$] 3%ED%*2FcpMy'.<rvD{'ھ5?D.oi&WkG"9Ġ1`2ޚ ^CӔ:wu =^h=)y'dX
_ItrNx7oHnߪ')':{ǠSC(Z-8~v֔`t=j A2s18ϧ#{dӜ k[k +ϭo{*);EIaE |%[?i>ݴ'MG<e_vUb<#\{(V9#0O<3JܶaA3ОIĵ^_!d
۰q
r@0Gbo [isAէ5I.)Ĉ쌧AOq/Wo_.f~ξ=2mgG%\"9q5֙- 7_,~|{hm+s.fϰ
|( 6~2 G|B[vkID	'ɩZ=,p>^9?iX|Oo_+|'_j'լ&}B	@fM𛘐u\xJr
jZ#|Hx #:K`;S9,x<GG:Ԛd/M6?MXFU֗6z㌐6
~6Fx9>{ҟDB^тpyq$?A"H=x =۲<r;~߀~4sI:0r 9ҿV?f_y sqZ(c8+g# Ug:> d ɸ|H  V *_A J  >F|sg q
!v @ h9n+S׵_or~qH#^^{vJ
Rs3|zNoc'oW fi~z,Nkx6V;/2]c}o%l m[
+s^Guk0C *SQI4yM))O V<9mmΖ|N9>Y=	Ɣ Eo+ݜ$A6ݎ\1?:Q~qkI5?wį CGVy&߷~W8q__zѿeo/OP񖓠jy>#Dw(Uq3I۝b >uk}Mnv-aw|`;{g_4esmp1en4$_/_iG=zA2CpXK܁>ۏ#~ߞr8My1#{zu)<(=@8*} p{ yn@=xh$z==?zY?3W='ب=fEa ' l g_v_L7_;}@Q^/ ez  > 3$cGnq{+k8yo~7]_]v>Ow#'ɣgp8N{㺁׺`F|MSGU]ZJVVSق9#;q w0t=S<cÒxJ\_C>E^xx^׆%w?uTX8$l%E
 8'e{2|>J%jG,[.^!5FGXy$_-Ȭ妇 𧌴_>h-"YCm񷄠L+WIpUcJeS݀m[c6|8-;Z_o[մKRoV$	d\+c=
~Z{G<j>lzN9;SG~@.09O|wך%)__s0O~ .#?ϿZCDIdegߜqA{}xoGr8?/8tٯ?<W='PmZ(c8+g# Ug:> d ɸ|H  V *yOB S >ުsO d>{זd#q`zN}8 Ǘ ־~xoNN1|vA=n#ccۯ>óOZ/?|il~xKV)\4K[>qPl?tOh _2ϪkfVIIOu,s`Ǹb(r4N|q xrq ./sq$+7~MgX<<=o r0x?2'd}\3@upgh
o1E䞣$_柩|.Ze;^ȩusġrG*w> p8$T>߀ ڣL
<7ǰ g{W,?X,S9&LFzc&[nå6uP:30vn$ p}v`p|܌9 ?ZouI [f郌=JF+cSB<\Iz <Нr}N2~cFڍj3xO_^_ 88k8*K
(/N;
 eH Yξ?n?|v թ*
ǀjHɼ~t~|b}?$, Óώ{bko3G_}t		$&:0yxL#{1lg=q0{io EW,߳g @oO~A
Pp0xӞ8';Ҏڕ4ԭ ?anI;_z~|qRAp} VMݭ]ƌ,8Nブ 69#$g>87//gu lǂu:0Y<3#gᬪ$@bO~%`ϐ|wd,<)9]	 Hb=>s~`9꼀8Rz$T4 ;NN?\c+rNcPVQL#  )p1c>K[4@=F1#6gZߩ4Ta ' l g_v_L7_;}@cFb|vzF	?Z  ?Pj g8> lA;$skS&{]9l;Key$g߃ZL6*qOc }H7{%ޚvױcoٻ091a\+e{	8s1Ҧ ZtU2G<cd4ep03} JU <NyߓܷA$zu^wWr  9 O~\}0qW _w0%2'(A$00A\~=∷7빺r2?犕 67ǭAeѥb
#zsnk m;ysq9FA>}} p[08 ? #݅I2 ?!9<]>q} 3q_ YO ?c?z"EIQ@	~qV/Gφum |%  p eOWݴ W?@gAߞJ  =K_h7*<%Yx_
$O3(W`x'-=}p8#؃ekOGv<?N p1EػOuu}4lOEg?7z =*yڭңEkg̋^\c
_'f,%rE#p229AI [lm;sk.ӿ(쉦ڟ}nA?4yb9$Xv= <iW>U+cpL3}Aggv=z'uٺB4σgx9F"WɩwWC:?gӍoH0v?R{\q|Oc8^qG=:O'9RO'@F?/j.M2/U MkH$ڛ5sgOB #۷6g}$<)A*O d |VXzv3a7=:ǎ1GfNA\r=x>~͛Kx7vwf9럶OևJ#h,(c8+g# Ug:> d ɸ|H  V +>KoMP= OJCwŞ/M.i
ki# f+վ~:~<a?2V\{OrWz ^^~>`Ne9{8C\98=8Ǡbw~G O~Lapx<sjcD?d0ݷA`}=(÷\nl #	#rsz5[{~812G$H^>b?t cBc$_˦-45wN x*
] _>#>0W;ntʜ;"ӮyN=yb$gFR}dr1~9 n9lvqږŵ{ _ւeAhbqNGEM1xϧ9? < $W[=
TSRw=j K0  ~?V|3h/&Oď/jxʾ$ ~7 o'ĶzT7v{;]7(f G$a52vgÿuX`]/flC $FGA[{d~M|fw^{qK70_w)=Aև'Ysм{xDv2[8Q&Yd~汾+mGNIlfZ#&A$ӜdiU| Sw$~͟xRy N1ҿ[n_$
3\8HUr>%O?0GNx ' &ʌ7 ߎ3!koؔ,>l{}}8@ 6|6l 9'_@ϯKb?~_C<e^i^oer^6mt$t>C-^m<ct!ͽX 3jfQe6w*~ۚ_lr}8ߥqn
*O?O08FANݕ=p}	ӜOAׁN5~
0[+z&E |%[?i>ݴ'MG<e_v\__ 
~#i]x7WXVn$ɚ;ʺFއn @?,|c [5[[|#i:+y&[;dc̏n7 g\Kʿ?fO߉hɦ-3U$Z(r7Bw)9I/y~I|ms5v"EwfRS<l矘 e=_*|'>1aӦ[9q{e{Luy~]瀵	[-^f2+Pv8ӧ%xR9L]Ta8r=RDy]=ma +&UH4 '<yz=8߰/H-r~䵬[11?gzm9:zj(8PQ>\i"O<= :g|+dhVaIYK,eݎ	8&A-OQj6Q"I%XMF,By>Ň_үbxf&ݏ)r0KtZ#)^Rs?hx{tV&GaO	J7M8!j	 ]?\gӥ]\2w$uG6vz_ C/vv`NuCJ
2|0gppi>)k[Fҵ9|-.4۝>@#a쪇$&
݊[_ėvV|#
H:Iwʎbppխj TZz;(yi*7,&TFp
W}槆cto+д DOsX6t\cvwl +{\bݞEIQ@	~qV/Gφum |%  p eOWݴ Q@y߂ >|=|IУo#!X%e}G'mDҒq{_a|M>+K:Wn[SI
R]U?y+|E=XBF,UH} N@;͑՝?pu[eo<j>e gcȋ17U|Aq;{(cw|d
Qx$x@]9'wLvknpyק_6=Ykpw!6o&dd;_,p#\e6
wiywgus7W0[[e,+"|$m"9a|p Va7=:ǎ1J0~`pS9':` Q47|df t>pk0 u zF!')k)T>@qߠ=Jlߎ/At	88OϿ8VRN9;M _oW@}HH,-br=MԴ>{	uAsE"nreH#A'ʃ\GQRhP_w }@	2>$~ SUm PE ~8cߌ6!+ᶋqux|@FG;hF0JeI¿oGԾ msdsgk4sJ *!ip\gnGcԞ֟c';H=' *<	s}x3SisfŷEy/e@]?Ot#0p9Q``v ,^ዸ]_W|C8:j4+VfxI啄kaveP-Fp`OCNRHRC -ws7qG|v	zlt[Zeq++4r`7iyj	<J\{RS[~$dqKû>Ht«6Gz{EBAqMݝ5|e3J#ZҶEikQPI'>;P0
(/N;
 eH Yξ?n?|v թ*
( 

Wa5FVֿg?jdZTǫ;%I=hI kqݯx%%LW\8`O[֑mm(~T\KdP0
( 
( 
( 
(/N;
 eH Yξ?n?|v թ*
( 
( 
( 
( 
( 
( 
(/N;
 eH Yξ{
[Ɵۗ>&i8ixw9jw;wQLnIQU?c ?x!   ?x!  ?x!   ?x!  ?x!   ?x!  ?x!   ?x!  ?x!   ?x!  ?x!   ?x!  ?x!   ?x!  ?x!   ?x!  ?x!   ?x!  ?x!   ?x!  ?x!   ?x!  ?x!   ?x!  ?x!   ?x!  ?x! Mϊ~7Q P-3@=S/6z]<;^'CR} PE PE PE PE PE PE PE P        6 bob.jpg  	@        H   l JFIF  H H   AppleMark
            	
       	
   } !1AQa"q2#BR$3br	
%&'()*456789:CDEFGHIJSTUVWXYZcdefghijstuvwxyz  w !1AQaq"2B	#3Rbr
$4%&'()*56789:CDEFGHIJSTUVWXYZcdefghijstuvwxyz  !    ? dO?_ >.|\wktm'X_QvYYoeekoPAx$K  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ??Q/ث'__|!|;Ri4&ĒC741,ngE |%  p eOWO  ן&s Sx+SO>3_n<muX:oXxi[j(..hԿ??V+k?h~λiBxo\}=#}Bk%Kp/ >)~t >-&|oZ{[/ş[4:ug
QHA>DQ | 4|N_Q|U3j񶋨xVKoCR~?tGM,/-fy. 2\r[%ݩo+'{ q O5?m?Ş	}G>:usWƷ׿t jFS+m+5Y#( ??fO_4"ZvsO8<mYCyhy'7zuLQfmJEt~_R :WS#Osǯx㧈u-Fln<g\hj#)nSWYn,Ā< |7 j~=_ ?G>xB~'_t5]I|C_|5t-UEPRkȆfրq/㧄(~9uGQL_m=k|:~,/[S7QLԣcfXPV j > [~!ɿxR4}/W=,
jz'ueڠ< f?lߍ_P_	~Z_~OhGuqvm64O×u3/Wn!cNL ^I#S Ė0;Υx֡Lt\SN|oߵc
 ?࢟o6|W|g)hߴ5o&Ц.44֛kĚlq$,&9M} >)=? [3 fKC_Ҵ.-mJɲdĊPT:|G ~~͐i 	dEx	xֺ֚>k{72.4qB Qoo;1.5hYo
MO,*bOC#AR|f < 4k6
7^q{_V5?OoG?d_;翳 
 >6 dhI hk4o
x~.5mOKPv/Ҡ&,]cOK-/aoxlW- x_Mu/_iv$k{iQExq?a8'7㯌.|0c'uU6_hc_x_!K{VMV4[ߴ>ЫMo]n#f8	+_|Vg?Ԭ/?蚢 }!]akxxOC3x?mGti~ϟt鿳
mGtխ֯ijZ,ZֻHl_?ð+T"kYoC? i_V
O
l>Ԡ{cu[fOfXe=b xU?b$<5I
xwĺvY c;(4K۫죻|-Q#9_m~ _Oدv~?~w|gЯ岆NY<7gj>Z[i.㽚.4O	0~_](
CVsWUi: 뚵MIYz6x[k6sX!{+It}W?o6o|Kg[x[jjj6a}S=6#D
)'MG<e^G'f9d>ޟ&ux+:}sc$L\X[E#b) >|g?A/ v=1v=/|m26ޗIhf^ıl`/2CJ 6?e;Iѿa	$Gέ?:GYjCXm&d͞cMkt%.J$ /?f/(O쵥|\Gi> ihqX;'QӵkxxZX.xȡdpI؟2m@ci0B6t+b7:̫[][C`E*F|Y~?n֚!~ݟtsI,?!ŏlu;krљaE{s"ЪZxb߂?|a=B}[Ŀzg|}alKaLgYD04t,ShOhw u=4sV~ablmw$B[+5I+( ?t~[" 9׵_ ghJC<Kq&6d&]Y
bU^i"=o2 %KE ltA4wп✟k{}^ El s_ MiO> ߋ<5/<Oeϳ~;OV|wVmMU|n?a?
iC^	n{o76oaGi3%7q_U?k g Kk??3Cg~W͛,uQZ?G6PLt_z_BiZVjsCnlMws	!)Ud'~Ws9wt
/o?|;"ú_Q%m5-:5kb<qp];M y
	 ~J|>5TOY<QU%ƛ>ͧa^ۦos4qCpU-e 'Ʃ ~0k;/:?߈Ε^KOOͫiz5޷6i,buHڭ[ZЀ~c~	ς?CIkM73_6KhܵMlyK. )x@c'E}=G|ZX>*a-X8VtTUY  P؟2fs?@c3xB ֺot+Xe$Vʭ\]M`G,+ bJԴ_K>j5k Qg}WNJl%Rh1+@)~~  
??e}Dnpo7׻ee?d;/7_ hShNӡ؀a"0cI>2-BgNtߴ\ giz}vpy/$ypymI>{#R f/J f |<7 4yfW|}D_g.oly?O|?a:_?
|9m>fѴa4A#R1tĚ) <-?#;Ο'Eu>g
cmB{kkxUcD8UQQU@ 
 ?# x_&'o_4 
rߵ٫2C74{K(i X I_*okO-S^x:>|izEVnckxE=] A~ wGORumG|KWm4jEPE]k.Si<&K.oS]4x6CZĽ;Zokzt"L+]zo2[	𧉢Լ;kp;(䯏?Ι c
Gm ?_
w
oW?f4[3z}ơZL#EdQB '?|ῂzPWUm/w<FjjzAŧ&1$YI.68
[2i1u㯊|[3V|1Xό|h͵:i JLO6vvlK$m ? Bɧ>6_V<[YW>-%-w%X궾es,r,VDP/(W/t| {Ɵ?m Ef
?|x8ONƅII= ڼ)6]F# 
~Ɵ n%'	_?ڇ5oi6Y_[kVS,[|xo<~J yGgj|]e/_:1xO?<[moiZ>"iuҮ/omt?WR»%'2K7_`f$k/٫k/$K .i mtmB'Ph[ZIWwr̪@??GG4tT1|:YCG}9]Ҵ.Q4I). tOPCǳZ{M~f^@K?֛'<3$4
!lF%kFP?n '_?F?F4|3a O/ƕ&|Gvy{malĒ\!<Q },?b ڣ߂?3 ]oO>|'Ėin$0kAܲAc~NOڻ6ZU:_coE-4 ǧ"i{٥@KowS| Z l?ͯ~_컨jZ9x/Γ_|tċ_OqE}y6cztHbxGX|EOxW𖡠}ևIc%4OshBb'1Yk 
( 
K
 (   @v@	2>$~ SUm PE PE PE PE PE PE QO 5  QJ>> d ɸ|H  V ( ( ( ( ( ( +/+o
k d }E |%  p eOWݴ Q@ Q@ Q@ Q@ Q@ Q@ W_VE??G5*  K	 &#oZ2h 
( 
( 
( 
( 
( 
( ୿)jTm'MG<e_vE PE PE   |) \|O.+VK.e-Z8-_I!,4}>9⻤ݓlE  i
O
_
C@ퟅjwZϢ^S~P֒mAb{tKVπ i gǿ<sK~՜ .ŵ=3^PTE<>-!Cumx6|2xs,6>Ҏ7ݻs-yOZ }w<'+S:Ki 6,rK
$p7?__?AOS\ +h^h+O>!&,ȑ-eM./<;[AkVvڬ)w|EWU,%ʢmR*Npf5iV?#_+ٯӾ%rqxctn-5ŬC):􌂊 ( +/+o
k d }E |%  p eOWݴ Q@ Q@ Q@oE )L ;꿱g@|61&o1?jxvxc>h]Ú髭]n7vcQG)o &_> }A
X> |Qג"+}.;พʞexTT%&7+^Sݔmw{l狧흓zqPM՜Vm;z 3W߀zg ojo|P:U_xr-CH{W=]?U.$h#\Ag t|<B>?m_xNm~&u[ծ/-tM[획ڴmZ\ڙg+a*EOMi웎qmuL=	:xhxJ-٤捭v+lfޱL Y|1𖟨'Rc[/*͠u^@gͭAٕT>M(S<?_p~VPE P_	[ S_ ? Ԩ(/&Oď/jxʾ ( ( +f  ~ x!i
FhPkCo_XIp>-jko<G~MҘ4K#nV Ə	? ??n_P|: j"uV>w1/0S,y?[?<A'/]Gτx3_6Zφ*JW2o7[o6Hvb`45jZim==ߡnUx.b>[/uJ:[Jj^ e n^ _'?1kjz]6ޏ6
@Tx] 6e&>/~_ey.}O񝟉mῆl, Ιou+}!579Hd,㾞XSiBu [}z$+Ⳕ	қ_~[ڷĵQm\? ߇&^l&Ż7{}wBC<!tx4kjks1P2 ht(9VW5^s;u~EhdPE QO 5  QJ>> d ɸ|H  V ( ( ( ;Ek3|%{+
 y'Kzh^:~etbt. vc3Y\|G_x_+_4K[վ- 繽k1DVX2,#bkq
1nS]K|VOҲ_:OI:sQo.TkWGK_lCǸnG<wYYζL:pEyp7zm=c1|:= o4}*KZ/
k%Ѵ.,^+E0.1K,F2Sldֶ{HrZԛ}\KQME?~) `U 
 K-g o뗞Ҿ٩WqRO-79+@?"
( 
( ୿)jTm'MG<e_vE PE PE P uY7 2?m^(=7Ĩo|A,Z/E-
tiQ',n$p-ȒY?'ƿOuhzy,k
kTgie,1*-O:@!̩֭נ_"rOta𸼖tqQN4٩-oWwC&'HOOKƓ}jZM3Aumur]54wIDHۿ% 쿋8ǁ)l>|FҼ[rxtIk'Q-Z#fn*+3K77}6VV]zV_IR`Zwm;˵ _3vohڟatbPKYB-#C=&( (  ) ি@~! 9PݴP_L7_;}@ Q@ Q@ Q@?sOWߋ:')VnRT5
[OSӛzIu1=QE)aGv 	6|  xwX{9mu?![/.eM0c_OGeY̲e8_T}Q6 @^7֧ee=ݶxũyKlmn׶[,O<1pd5o7# eOx6u%xڄ7YnAԵSK὿4]B;gr,	b(˪{=K|O_s6".|ѓ|5~Z+;_[?d p?ࣟOڣ޵4;=AW_R.H`k$D"%0\m}E PE QO 5  QJ>> d ɸ|H  V ( ( (<]x'ώ|M	t[X5km,thkcGI]QQ S?h-vh*_ Z /㗌<?
#DA?.la`VO,Y}f $9״}g/D~־+b5ktlBuX]ꐤ7b_ۘ ?W X
ំEo3jZk jzo-q5&>ngjiy87씜]Mtv +٣s_	Cu[ۨfnkd-l֧[YEH~<Q/l $oσi}{
a po|Gkx7Ph ^ߺĖjVM;;[5};N[4IocZj,-Dwn'Ա8gS);KJto'   ֱ
]Y5o%C{&Ӽk	m5On^  u_O
9ڻZ~|,񶏤j>gaSki%e}B[qs;ehrlNXZWOZ+=
( ୿)jTm'MG<e_vE PE PE 5X+?Q(! Z5?g?h{&\NIcu[I!!5ImF f6S1j >4~5M>4 i'n]>
tu[[o0~+7`X7Ց7h6}%+\ _?W	=? <u>)ռž<>3K-ZnKaGcZ4г8`RII[x\ȥ7 5_]xrɭY2^\e"AYnr-;Q] ?vv/c 33/)x&|x<CxN}HYuki|.ugz7i]%ڽO$$H ൿߋ?E +/ïW_l|Y@>#Wbյ[[F9"Wcm,s^5p9^ s_yz9)Tkiw?+>( +/+o
k d }E |%  p eOWݴ Q@ Q@ Q@9|_ ~:|Mx> -o&Դo	_tiphxF
}Uc ~1|S ?h-u s;Ni->ǆQPKB Ӵ_mmq\DuR]L$?	_{=[O
W2W$loooy[GqMZ2d"/|iwgv |>k}T'q='HR+٠I
|CF.hb FBֻ0qkyٝXԨG2o+zg3#-.7GhE|)Z>q+Z=ZA5TYM{eO?l٣ψ @ˁ5-'N5[
lOJ|#(NU+Q_j=?4ׅ<.-4 n?ˮ F~ j}>/jZO}=U ê[t\Lgk
f~WbPE QO 5  QJ>> d ɸ|H  V ( (o 5|y?eŖz;][ƞ"}&niԭdXג\F&gkbW:M [$ݿ|J#Þ#^X?Ikiat[*Z"_"KyF$_V/qY[iЊRPn[m>8<fLxh)F*Tkemחg' ݓ W Go_GcAwvgC
||gk7bwXXM;F~m:y^1yomq֕ #.|(~w>( wO1 Bx#@J/þ伊g
IhRDTh6qe_&I vI#-	>8($A>GV?Q/%?'x^O-<9N{jojA/t@4FXMqO,Q~P2}Pi.6qM|N+9Z<j_5$WˮۜlҴ<}:l
~<"7}⏆T'"uԴidv5M6$qF#E5ɉ29NǛZK55$&o&o g]>i>薚tY[BYťXX\Me:\CnK=0	lM?e^> >Yb0kE?zP_	[ S_ ? Ԩ( N E~9 U{ )>?4c{{{k]A+	$7̭$/OUx6>:8[zUOb>_;]d|9q֤xWm|MݶW{_ |3Ҿ"w֯}NX~bYפR{Z,I@M<G7f991v7+n$ջ%qf9*qn髻n$ey6J]?o?gE^,e<;EYSʝx7"o4q R	9/6XóDk%2]$$l\4<,ꜿw䯽Qj{^q_җA.qשew⿊>?nǉ5{{Y!=̾T*GY"*.p 5LW Lx.r
یgԝ^)Uj;Pz+e??o6Cž[߂<M^	־7Yj>CycX=hX$TfGWVRA7'wr|gkWT^Eu^Ms4V6ǎ,lmQfe0EDU_=*%,79
" ??u :?a{	<3u㸷;ˈ-t3P< [x$}?ė>XHq`^ҜSoD Ssl~jtI[Z4wNi /~7-|KW+iuOU!I}mB +}K'	nu> ,;]B_&*8E4^_%ks[n; k_B_v:ƙ|UxJVg^6OVxY/.gePGpDuV~֍k~G^	(H^ Q_\7Y'_O|BᎻ\3.-|xZ^ώ$}p<4_mx9TqRRg<I `(  ) ি@~! 9PݴP; pWGz|z7f{Ͳ>]2K9Qgb *4%LMy/E>O/|BeV[U&;ՔW}0W [xA9[}rOYPR6};i+]r0
k0RLnqwߒώF<)Mٿfv_$ߢgk5ow㏅m1{PREմxvI,Iwv-H8?Y ڟM?ࠟi?j|0
\4/a[-gKi	5.Gw/bF)Ãp^mgZZv7o{OO[ƸpϬOm+E뾿 
h
~ F4
E/a4ڗibf7s[[y'H1b1OhR'Ϸcq0gU1>tjF7}n7N k7ηPH?foW6Zl}Mem&7`xRHK Ag?xW\1èisŮk2,ђ"2H+	sFqClӫ	_D-KM_}UKؚyԫSՒ-I/uWWyd'/O
[oXh
l<ky
cm&8!4y$UY	 x_Wo8cƿ|M-gb'jwǉM7tvk)ldRϦ$ϬWok/Ϯ$=oRW
i'~2_u#[6Pσ	e?fb>座5&>skN|9AKo_IƟVگNن?$Z;6i6 f%HmJ>^l]DpYږL|GG
w|);I%Kۛ=2+wxc7G,B({ٖbֶ2?ubrk{M^d<{!eӽzMF*	tRy]fwnk/d W8Q?V'}p◻KC JGf
^!ӚK:gI_ o|Cj֍WjzƁMX7mŋhږQKx'? m5sc+5}>+4?ww W_VE??G5*   2t c~2^7 O y#6 %Jϭ݉pT* l|! 7⏅o~i$ӯ5M#-ڬᕧtM$uF+NNu*mKkǓEPUEԭ_JI9JUI/[EzGq ]ߎ ??W}Z?ٿV4Q7ͪhDX~=ɔRdxy

Vsdߥ/߱Os~ǒ*T <_Pu+6F'	爻%ش&6M|K_VJ4Je񒭃.w oNWmkGw]U: |3t \/|E}[_Ɋ_O
K[½ʼ(7 iZSu kkc J/!eD6 ]5՛xVgγmciuvRi6*rDɦ6q,3Fd(Ep
uO5Anޱ_Uڥ'mx.sw~) _\% i>
 [&56֗0ǩ)VZ=m$ol.o	 A? aψO|Y/ÿk 

u[
KS)>
׉XN'>1y(+RQo</-_Ev~K[1W%̗~T_g:&xM|mǋ^4]>Wc	.\鷺~U\N<Bҧ ?㽧K <4ه:wfѭM7+ckyxzK{{ַK'T㸟)bR#͸JME;J)83Ky9%[77V \4 >~ |9~'Ӵ;,F?I<=yaAkmqR$DWMW]X8Ǻi_ ?Fv `k'umgSpi&̷2K/R*ľrk	|?RԹ%~V^>Wj7f^G8֨BJv\Bmsu;'ku8 uix߲GkumsBз޽mR{(e	3YcH·O (oğ
(؟eÿqS
CxSѴ
%了5Kiƻyz5Q<Ucl36*x:8XQ抌m.nexչ[r)g'
8ֱXǚ.rfMt+KK?
 d
PG|J归})lu;HQ5k)u/,RyjV٢8Ȓo ~߱<)_K㕟|OYɨXijڣ~|L9%3d	c6ꜰdzd{X~&V6+ٽI$'6}h>,
z5;8u
7Rc-fE2RXFWIe`A ]e(;(*pwOTwA_'43&  a oWo?f6}&:dk˕Zw^nުɞ.svCoɯm>Ukir^nY3j  ) ি@~! 9W{gݴPm8 C]?h^/ǎ<gJb,gXm&":VYMQY}ʘBLǷ^ hς8j%&&knZ5sWVuI<e^7;i[eVR}u bk`3ܾ1$Fͧ:ӓUҾ. 3?n7ƛx|5:5:AFӉ,,sC2C>![H#m7AU-yj/㶸{a,dRlbx_q.]a0Redh5_X[Uq4H-$ZYkF m|eAW/.<1j^(Ԡdexѥ)VtR2G*x<AxZ}NmCRԵ..y攗YF%I$xZM'^Tjgx^22oERO_5itnjS b
x	gw^2ojx*
ڭԭ3Ký-_pU
Ug$ ZW?800֯
:5omaNN?7-Us(+- hh{φ_."1?×6[ZZ:Dr6HDE`]ž2Iu=T]f }SKIU]j(ioyu Rj~  K F?exy o foZk/XA%5C}gbݮ #  lo
J 6u/͗<}k? lVh<?|=-K?S}7T[9!2Z<iӯFowPjQjڦM>QN'fMkN_oK
3"׼ 
ЙuCM`R[W[VK+DcC LZi<M/j^'<UxPԵV)o<Hu2L<5wQ_'1Pa"\Kn\Jq\Z; nݺ]^^^ O>,MۃFb:~|ULR&۸:ya\Hx;y~6yy;w|xq?1aFJ0AVRKyUsҡJNSܷrU=?R7M>?'>+춟aY?x
AG+
G/%4ґt<(\o)O  t^:G º.8尿ZZZ%++]. ʁ)`QG^mK][n]=U9k+$I.|$__
~|_e3vx[úon.>;K8<뗒ia<]ݶff$ Yj   *x "?~ O翋}m.>FKk\J+Oq[pw; ۯNVp.;5^ _oqJ
  ?_ q+̯#Q 5ߋ$~Y/5][Q4JתeĲځ
ܮg<Kzz [ S_ ? ԫ,m+hV?@|7y6vMhO|ck@W ej qGG K~ ?rW~-YO j|]w@FKWI𵞓y(Pmu +Mp<w?c gx HAu6Y$ʿx2^ zUVN0vOF-*lmnJ4]JI,ާ)9 
mޑ~'aYL{H9궚$1ios`K~lMIsڮmjTk^\}*Z+&^guye|EEGiZ}Y+'&_ַZo tV1,iǆke:r}_*moib& ײY%&&e,3҇[o^J;]6ҋzlm=䦊½y 
3ߍ?ڟxG_gھ{ߑl<gwn֍OcZk_nw6"{_JVfB J4&|UmO_mBe ߈n-
wu
%ı&oY-v H" } L _ Oſ~g%mM{egecT+ed_WS?ԯOUto_V_ۋ ïi_3⧌F.)-48V]4o:qD2nB7幖!󬖩~-~gęLW# RP}ҔkMGo(+7.|I7SeM_j/\}ݼi[HlV+hbEHv'Q3y8r\y{TVҽ{hGy;>^'15XT2J2Mt[+[<A<>URm^oOB1ayu8ӣVIG;{XV	U	|;6d[՚?lG-X~r>[TϬg w k& W k*kT`.&(Ԍj$o-uH? vm#H^]\~ljR1[ËeO]?wQ_{I\R̸?BXki;O_+_ǟφjgǅux5{
ז߽<K%FKyY͆ic'kF d7omi	{5˿͖Z]qm爑%|I|>Ƶ<V\k-Z2N>wŪ̦[4~B^Zz{Fc| b4]{am-:F}z{\+S%gӺT=pq/K۳M4+.<	I,A?gOږ?OUҵQ)'
IѕYS  ) ি@~! 9V~9Fa;ﲔWNoͷe~+e8#wtsoU+ſ6f}E}iT j}KA<%xOO~6+X[X񕾏-Ŵ)%uL[P<cxbk_9m:q-⸟kƚZ)-sB K6 T  
/# _vlwqo#|{|H ~:\|Xy/o?)4>jLvy-<o+&nn#C b(O)?)>lk͵ukqe)[~Zpi'כi4jk-HQ@ѿï+:D߰7?m?<w^"][参3M8A4i"J,wfg iG:׉>|T=}o
;±/9tKi	tבhLN4Ydyw#,T2\	F;&$=կM=qod8b)sMEt+j׍CCZJu$wÍWM'auKcs=[a}s$rb?6 єi <qiY^jCM_. D]B-c<{B֡H+1:Tc;%''*Tj͹Fhi.E$}6xRI;???G_>4-cĢTEAj,r V"iMFl&:ҡ'	Z\_5a_,5ajrU1wWQriSW|~7~Qo\οͥjlaFgZ2to1I^^*Σ>wq؜)qxTt''|ezUջOE?m7N =+ľ2W_:߇u+]BXuOE=ɧݽyYK4/_uM'][/
k:}LYf(Y_,~gb}W?{8VVgeѷ8[4~)$c~[;.Aѯ~1~Ğ(P% v)5;,I83J-l)dlh\%>9m; V]Wڲ6QrK^q7⿍߶.6xgf~scofXQv}1{;&:7'-_M_[Gox/?J:W]Gy.flv
HFo6f5NlMzkW|gFe2捚JZU ]Z3{'l><h j/x>"ݎxŭp<W2G}$	V݄lj{dGr^+
<=YF3Tm)&i-_Cɱ2,-yB5%&Ғn֒'kwccC *7e~ںv^]G/z~̒ǦZCv[!]\c@q+tOuRqN M-#NNU_%6-Q^Y Q@ Wcox:/xJ>"M{AφOXG}cfhwŲ@|v:3\a))J+HK\iqWKigy|7kj'dӼZa%k%W`+;i
Gdh^+$)IԥZ/I~EùEzåEҵg}?|_/3𗏼!źkiw~LRT	<U}"VSA"֯o\y]rVK[}:Y	T>U* TUG%OhV2K/]FQۭ],> 8Q ̩ B x^% |VuG|;>}mA܊L]I7vjYKoF~k)~qOz/BNwڅPYC9ei$]7l
I< 	}[
+hԵ,2\=kG
.]_ 
fCRߪJ+3ͲFSI+<w
Ii6kg+:N+ qiI <f^[Ч(-6f95¾ p~_4|w.1x;mv;94Na>tews,A28 w m8
_؜e >q帕pǵ:kݒzN+|Cߊ( ?|w$5fȆ_L2PEdv؈¨ 
AASXPG_iIm$kԶ~Y.[.m$'qPR&6U^i?UoF/ʳmY]vk嵏:?I>)ؽ4`0 '/ R??O oo/0֫: ? -q? W NH+/_~ʟw}$Y^l,Ǿ)wrLMsWNQOѴ8UХQ^2Sm&|E`s Q@k
뗚gu
7Rdu2)cuWIVPAfʣ}O] %N*
;+ GR?9 { LZ|^:? kڃ>խ?|A=̑MFH`A^˂_L(^*[*4nWWG<  i=|WPߋbkQkt69[(Ut2Brhí_O_Ry7^I+tiS$>d(T [j? ?a]FgX5;_I:aG:Ek=6%!Ih8s<FUVl2MW\k]GZEBT䤛\i4[?I>)ؽ48 H 8?k=L5:|οq ?\C # Ӓ
_u|e𭝝ǉ!=7lr=VQ]oEPꮌTO#IQ
-5w<5eB:-5}<ڊ( ( (u+ ~	|_SMtORǓeƜmƯ[h$YYf
J46Q /#Kwr5^sUN.C<Gqym{=1^m6o;Z!@`mSQ!`<ӲVIiv3VU\yQI$Iy6AE P^uI'//&_ JGf_  ?X]_( aWu #} ZQ^a Q@ Q@8~iω
~<vs޷ݭ=յk,mf$qoմT
x|3rKwn]ib.-ݻ{OfԗFV&E PE PE _|R {R ik ve o JGQ_чQ ey	<A+G5o>>a퍙ޛ{9wBREi~m˹9=ekUo{V6Q^Q{Oǟφ~i hǊx4\
߽<rʖ	.'c.e!hў":׽6[6ЩRRW䢽d춻G+] 2ޕxoWu>g3%z;#c*kcT}-go}+zyT1VѠM=Һ&ڑ+wҩ{jJkNija|==֤kq޽ڊ(y9<OsG[ >l-9,㿵9Maqԫc1YiVS˓Z 7.骿xO
KZ.t~mQ@ Q@|	hA+Gtzo>a%푕ޥeø؎U_eʜJKI+5v4QP@W|a IKK Iq ґٗ )qEF'P~>׼Y{^yS~%inIqu]M=b8`yeQ#PY (73xG E<9kk϶AWmn50+G?	ͦc>!TQG~#<3-LTK5r[kgM[D$|E|_y3h
~ o_7Vh<+xG'[{/6(fh>w5btlF#/.?
	?H?>ݎgTiԄߤdv~WPE PE PE zO&O
vri7>^9K{X}+ZW(_iYċhfWO6'RS"ʲ٤ʤieͿ?>&>{SWXPm|/=qvQxÚ=wR}H@$o1B:x5UZ)E} )?ɗZjSy->M|¶t͗uC55Y=2ծ Yn.9
d3E5I* 5r1e'h^%1ξ0 $ b F8 H 8?ik mxW\<O~?
7Rd$34d<Rꮒ)|_ϹԥU7}O=̠ފgnu(, ( ( ( ( (`Ԭ'UwVQė%JshC$/ kH|"Vez ^]qi;}mۮ5^uI'//&0_ JG^_  ?X
\߶g߱CF>7|EմGI5mBRFuismukI3A4R,n"H5? og1?W_|)bs,^"I>zjɴ}~Gb|v+:jJ/RWvsM]=p O>? ʺ? l0Ϗb> # O &yT ɇ2 F GU f ц|~  tG @=?L?, K d 73?  # * S?z<Y @?R & og1?WG2 F GUq 0 Px/L? l0Ϗb> d 73N?  ag  J_'ٿa|@ ] og1?WG	  A ʔ0 O>? ʺ? l0Ϗb> ;  ' ɇş )a f ц|~  t'ٿa|@ ]w 'OO ? *R ?  # *cCj/g >h<ݤqX変t򭤭$$,
,qH&ǃs`yʏ Rs]uZIz  og1?WG2 F GU S?z?T ɇ2 F GU f ц|~  tG @=?L?, K d 73?  # * S?z<Y @?R & og1?W\_ğ~Cҿ`Oꗺ5_|d@苹,@ Sѩ<%[ӃN)V
ь)loWE~B Q@ Q@ Q@ Q@ Q@ Q@ Q@        7 	loop.jpg  	@         hW    JFIF  H H   AppleMark
            	
       	
   } !1AQa"q2#BR$3br	
%&'()*456789:CDEFGHIJSTUVWXYZcdefghijstuvwxyz  w !1AQaq"2B	#3Rbr
$4%&'()*56789:CDEFGHIJSTUVWXYZcdefghijstuvwxyz  W!    ? dO?_ >.|\wktm'X_QvYYoeekoPAx$K  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ??'U  >o_z/i5/ƘmnH7Eyj3}#4@_; H ] z ?_; H ] z ?_; H ] z ?_; H ] z ?_; H ] z ?_; H ] z ?_; H ] z ?_; H ] z ?_; H ] z ?_; H ] z ?_; H ] z ?_; H ] z ?_; H ] z ?_; H ] z ?_; H ] z ?_; H ] z ?_; H ] z ?_; H ] z ?_; H ] z ?_; H ] z |?f)oo']'_~'ޏ_>|6OĺvCF[ P?n?|v թ*
( _  B _V_߰/g+k}7>~F6ipZ5	|tgI$p11iؿǟx%g 0 ; M Zx' iֶ~WڼIyo<|Ϗ? W?ōƿHO<-kڎO'
B
Aj\Yn򬚄R.4[3
	`x h%hj6oqީ4izw}&yn@?B D~;2 Q?Z}~-tI?o K*8ݴ+r5)R4Ցj7D_ۿ _^?ߴŏH>iz5#Yּah`m:]yO;v!`eO:_O~S:f_hw.]r46R1F&Y>u >)M h% a~xBy
'gC#OܓY-"\>C w6> x |!i 	o/Ajfy$^|wRx&7 
( 
( 
( 
( c8+g# Ug:  ( ( ( ( ( ( ( ( ( ($ V?c ??#K_v_L7_;}@ W~Zo	 X <s/[m/H/G_hj[7i~_م  - ~ [w
q
?x!:/uk[
6Kk->,//#0(XʬY$ 
?QOsA+dtִ޹y
A2iݢG4d'\B_7cMCm 	'GZRYO^im,)ye
.]Ϧ]Mog}9kp
 П_ ԏ _ ?
( 
( 
( 
( 
K0  ~?V|3h ( ( ( ( ( ( ( ( ( KOc0  R?m |%  p eOWݴ Q@ mc (?8[
_S࿀ b/SO([;&o[6:MC+e0x'Qw+]+w
~:MmG
a RbmsPSOQ6:OϪ=8=SUeeu49W~=~;?g z~O]OC4c
%Y,M$[LK$n_:_@?W> ? _PE PE PE PE P_	~qV/Gφtm Q@ Q@ Q@WoS9ω:.qkƭy
cmMqssq3,pChI+*31 _ ̿d}G3Zu7 O|.+'^1ğa4[& ʐ<_&xfd OE?Q $ ~ Q  OE?Q $ ~ Q  OE?Q $ ~ Q  OE?Q $ ~ Q  OE?Q $ ~ Q  OE?Q $ ~ Q  OE?Q $ ~ Q  OE?Q $ ~ Q  OE?Q $ ~ Q  OE?Q $ ~ Q  }IG	HSP>M&ux+ĺncm}qL\XK,i2<4E6#M P_+%h/&Oď/jxʾ + /RV~؟  \>?<wh𞯧[Z\&','YR?1K
 K=~  c_I'OI    u ;?i/m<#<b| 9	)
C RiڧPW[5C<'cacwóehmllyKqĺ~.𧅼yO>Z}Ɠh7v:m
ŵͼ$NE ~J ?: Uxoo?_3 O	x[uOδQV+XpO& ~ҟ?- xC> >hw|oݳPƿ#+Sg ko+7/Z> ' g0W>ٍ̀4PE PE PE PE P_	~qV/Gφtm Q@ Q@ Q@y߳<aN:>3$vXlt*Y"[OP:ݼ	ʢ?ߵg6~:O+7x3|.yxzY
WZk%ϟwqfҬoMOڿ ?ߋoK@Wk;+~:,?tOD-5s
iti*Z=G[-ӿ5 oAcki?y3n "] K+x1~ t]6}S9aojڶ.ާح.b;kyinDvѼlũ⿄^?k 66zt{hQ_xUår$ԡYvc,x߲W_ſ
kͿ'>>ͭ >~I}w;cSQ0Ieǿ>kſ|L/
Sƺa4H%Rfi$^hb\Z/x࿋h ogPM'\՟)=;[*[]rm-fQw 2S?c-
~ m<mOo>>Т񥎫!K-ICy(1Kn,
X@qN ٳƟ;O iXTT6"[izU:}.BY8y!i>ۿşQxK_] _
u x.kSAumJ{Ȯnnb0#3:4r` Ϻ+ ?ٛN j?6~E>"/ض}_̲O ۽wtߍ'ᦡ_hIomm*i."13Mu* =஥#'/xKVմcV|M]7KRѭ~ݫۥܱuu*6RW ট_ş

 h xK s u ~ 5ڭލo!:)7W9ݶ\G,1} 
[-  ^ 4LtI GA/WϚ|߲h~__Ư?Gv_he[7\j\47ʷwKnd4~U/_ګ=?ENj2[VëkBs+{[ۈfLYU{d `A_e߂|A_1AW>С|rmi=ȴZLQ
 tڷ[ּ{~Lxgt[xHT~43EV9Pxmnf[H-pcb=>Sb >|D  `~,|8Ҽ_gߍEt&TѦ7oyLe28 h|W 㗀kxxl]ɽohww46s<1O4iyeio=\8ՔP_+%h/&Oď/jxʾ ( ( ( ( ( ( ( +/N;
 eH Y΀>
( 
( 
( i_
<',7E?M#GӴ6o4EovO^xNͣ\ P/{w.#?xC?! + >> }$3 <  Kj|lgujj:Û]KMӵ8+DӬ5IUNɶ - ? /]TiZ > ?M McMsΗiڶqsiYJ_"I { {eoi|%??/uu_cgq=c6o얳I.?y.Ͷj k 
Gx3_)~-BZi/?]
/^6Fz[ZE{m-wkYx J>  #PqgIw/~ִMgVO
K[Z<G{F&tOilv/o |{u'Se}y:5juc0O52Y,eO29f7GcI H~4՟>eAKT<7{;Ok\s^]đYjHlĺd3Xp{ 6ޏ)OZd8ݧ=6 ۿ:cu|+V$@|?:Zi -|g uS7< ~) kjrxVҴMg^4y'Cw
֭!Kb2l1FU{C|vi 	7T؟ ٿΟǟm|3Oo>9 |-
=//i	~'|1/!_4cJVX7),Z/{g.y<k'yl&{y WK 7 
 "WZ ʷIW=
?d |EPv fx^]9<QS[-o$SMTZ&b<i.̕^i x[ƝC 3ZK; 70y+y4xmP@Ek¯  /S W<z ڀ=_W gB|<ҵ7;ǝ[+MiE:.{hiڵ
^ۙ#[E!ԚKy?ko'ᯊ_LDKM]/[(m&0Y߉C5ڸT k_W?|aojI$"[eRWMZxb_+_ 
Oc h|_?3ÿUoYGk:7?}*i,"/u=ZR.&]& +!Mw
=F{kC/4j_Mos/ΫLAk{RX1}
AR
KZF W,-ѿO]TsE5KI_jS<?(/?OHݴ'MG<e_vE PE PE PE PE PE PE PE a ' l g@v@ Q@ Q@ W_+%/(ǻ_
>|r.f-3:Ԟ07jKIK)McY["'{d&/uB> ~_a?_ O?gW  _cOP>K i?S|+-9"Ѡڵռ_r'r{ᵼ5#^R_U_k-Z|VG|1ߋ=g'CKjڦeqXu<\ގ3ۋ{?Tj/ E,\ 
V	'uK
GUl5IaR%S0s?#3x+ĺG|Gw7j7qEM(/-=MRHO gĿ	~#so> `<a.IzFQY%6f (Y.KٳO  _i GWy߻ ) Iχ<e 3Nቴ:ŝkICi%×(5խE+?NA+Yه1/}CKON=6ß`}kyo)[+xa_Mqoocwn+ ؿ7/Oſ?hY  -þ(.98Il_F>|EwqQ\ ɓ#|  _4Zd/$~wP-.tncO#KxBJ |1 /
6Fww/-[)?<5m{y.n!5sMtR2A
4Mp0qn?Y○ڟܿG4 |1ޛq^[jּ3<ְjf
*,>llࢫ><?o^;;*kZ.
ovM{AJ:Rizd:]r]>Ha3-_]_(W|'Q9.~>?uFⷄ5hvWZ4@ 9P g_b 7>/xķV~$UH&C^_JZ]J8Px$cs_I  r?f#Wb _KfjZ=zUUЍQ<Q0!P~6ߺ{ wxG cf?&7t)QkW^~,k۽El!o
SC
9OYZ:?E.3Bo5mt5/ᇇxD$'?juCM\'ƯiZ7?&ԭ.flJX֮&n56_  '  @v@	|I ~@~2G?n?|v թ*+)~OյcVI8!4y$U	 ?߲xp>:|b.Ӽ2g|=g5ռ5ƿ{n=Զ:e
$Q?+W  G<>>᏶EMƣi7u彧E}O	H OB >MGD /  g  OB >MGD /  g  OB >MGD /  g  OB >MGD /  g  OB >MGD /  g  OB >M_?( BO{c z^?/=gJ5H-.mmZ>nV
e Q@ Q@ Q@ Q@|%[?i>ݴPE PE PE ƯिOuxOYuG5)|k+-3"yOMwU|f`h +Oٻ;emK⿈>
;P:,?Ğ)QMekkZq
b+{g0chfu>c[ihԼQzŶb,:fC4ng+\$  ( 
( 
( 
( jl%׀/F )6s|/yռiO4M
̐}E |%'R Z> d ɸ|H  V?_Fأ
oQi/Ohx<3?
SнWWMc<(D3iM$)
[4 '+
 e
OUޟ6:y4'H:(g{m"k(R+{d-o${ņ+do3_<{|/_/4k+TӼcϴH̆hM7$*o y   S J ?WaO 	( )_?$ y   S J ?WaO 	( )_?$ y   S J ?WaO 	+ #+пٯ,?xkNt  eo70 Q@ Q@ Q@ Q@|%[?i>ݴPE PE PE _?Z.4?koZƧ,Zi*XcŴr]æ_)HVdF#ژ-~Ӟ(vhrQ\7
j7-a~"i 6ZڝQ<ֳ+}@ Q@ Q@ Q@ Q@ Q@O~x^fz_/k6zVyGowv4BnTA`_?>)|U KY࿄4v/q{iZs> dt#hY^BL>> )X?d ԏ-}@	2>$~ SUm K~_ g0=BQ8K+*i(Oleh!u^$e . (*~۟]?IƝ}o|KhחP>mMcXxS*5޿wYsr[\MaQ l?#/ 
?Q 
D%?G;  ? hD(uG6 H n  ?  G"_ K~ w 7TaQ l?#/ 
?Q 
D%?G;  ? hD(uG6 H n  ?  G"_ K~ w 7TaQ l?#/ 
?Q 
D%?G;  ? hD(uG<7owW* l;6!񏇮O
i>|!-o$Amfn >
K0  ~?V|3h ( ( (>7~ >5xOuexcӴ
mZmRKsog%#nGw/NG}\Oouaq-x)(ǅC/Ǆ MGnu<K&m3_fѬ|%+*GgF ţ#3#_  

 G  h u H   x º | k <Z?]R?>  5 - |W` qjߴ7x~/|OW7ω.QvVpYjݭ}ď0!QC}[I7} eʾ)|3ZGmt"KO-ln-I,/+*GgF ţ#3#_  

 G  h u H   x º | k <Z?]R?>  5 - y _ W_T<π?~/ @+*GgF ţ#3#_  

 G  h u H   xxG|+'g6C5}S:9Y|-wk"eyh&~Sx5^5_	m P_+%h/&Oď/jxʾ (<iK'طo?4?_5 
x^
3Br LaP)
Rxn?x-?~ Nſj0yvwH漖IYg4S3s o)?  ?3 |3GuSe4zH}>,` LԥK8X湞]=C  1u 
w}탠G?ZǋuRU485[	=
{hEլFk{{h湁$u+
|Kߍ'Z lk>ՆIqiue0 >WS~fo@?f}C@1KG[/egKDOj:HׅM|)>.{M>]_xZf\ -nKKnf;[ ?ಿL]<_}`xO.oTo,}VBMO]կ!YkKi&H I~	k_ फ़V	
[e5t4CP?gGMe.{-L"hP{¿X&|=Iy./<S-S^xn
?3ijږuc%u73BE'Oze+C_z~[_RK[m 
Re(idQrp⧁?	~_Fme+Vֹ}q]j6Ixd:lnmn''U?O_O>!h&&ŶvzȖ/>w{1jZmibA,n@=a ~O.>?i&񶋧ͭ5Z~iéhj%6 #l.S$IXuW T|S;
[	oe|DIO\outPBAa_<* >  ᗿz K  
#>! _?i 	'~>j w	c~E 	 #|sIxZdN"[y;MFk@?b*~ ~͚c_||Mj(5*NchcN;odyM5\J;>6 ~i֩:~mt_f_i;Ц爣wE1xrM+$-o닢L(!iH?S _ kw~l|3sCb2=v;#g</yj/L4pL3 O aY
~=<[ocg>մ3uEZ>eŌVxA3#ݴP}Í;	<#O?~9|/~-&~|14S4WZWGѭmCJ--YB
K0  ~?V|3h ( ( ( _ o1+ 
)Lx9񎑠 kO'W-/v>-޹   N   N   N   N   NoW	RSo[f2ݪi_?i?itgG#Eڅ?2&um_NI4͇Пi )I |eo Ǟ2<* Y6wQk=6V:~mecikmoBfp*( 
( 
( 
( > )X?d ԏ-}@	2>$~ SUm PE *
uŞ<^-- _֝dlȞf*|n?*	 m  u 'w#}%?Oϙo??Hx#
g?K []4?W7ܭΑzdrE5
à g?lWo~/ nB_G^~xGNnŇŶ(uOM.h/e[8^ J~?`> &xo__oɨ<5Xͨi fDK7n孰_h W7%6?#G㴲#5;BQ.ymmbH swG
x~8
Cœ^{MдσZ^-SZB%M@[Mm-Yw3mt>6 t~^.O~>c68|5tNżP<Su_ÿcZ[aRS&JI~# n<{  O/guh>+m+ۼ G/־-;_5 ^q\I#^k>%m-B[Q2lUE?WG)?dOw>1xwO/u6oa&uKXKFA4_ITGW kC@?d=ѿj_7N }sڦjZYSRXg3k*Dc4`s < U 5 R o%  +_ wM 6'/ b jJ hjK~~
 jk/D)aODɭc i$w^w	]  QlSu׆kRM#^^{$S>b!;sώoyo6 ]'·ӿ ?/_?_4 Cg쯲Wxo~ÿUfO/Ŀa״Cm7/+#Sh%uHm{9ٵ2K}̠?/ d ~3_xA
CotOIk`Xݼ7Z\-6u4֗.]K+!__ 5/ 
~ɦx+~D<-iI >ٺ$] ;ϱ $yjxow:<Vt]*LӵkJ2F.-!Cw4?M!^:_3ߵ/xCr]
?^4`Z%	/M5'XE ?k??xD& @ ױF6~ŧu?QZ}zơi7湺;nW-M)R翴O~?O:i|]i2e=Ė4rƓ,sF)da>{
hO#~ߴOt>>WŮX_jMv4ȐƯ,(gc E_w  }E PPx~<OO|jאX66Ѵ7721F$*34ͷk(5|#QtBLա#Y#կ|oC*(-3{*|EMc42cKkx%VU !n͜WPG= ־.~"|#/?7,4=ԴO|C%&.x^cUf"$1<DZ3|#gڳixL1_-ɭ5ּ(C%ɷHFa8L   nW ;_ f ڟ}ϝþ+ǈ5){I-n=[A9R+x2!T#[A0WcP; H ] z?ٿ>#: ߅~(jj?xHxk/<0Ghc@u7 ?u7 ?>#?|)xv &PV7C8{-"7RP=&<W㯅_gƿ|&@m]Z?|Qz .1Z{CsKdVu#WWƟ/y/~?aqx-jP"TG[gHfRkpo乂C|J_~1߇n~~/y"߃^-5Itcjit-:u]'R1Yj7T}h{
S|T	i  t+ OڬA{{d[]fu>2wG	>9 z|ּmjj
|-w}_\\\MfO4$ĒMs o%#;
 ?'>/سbǧh0x^x> լ</ٮky74  |~ Į = t߱
k^Un6jw}},6ݢBĖ~lgoo4mlR< 1 Ih ah  u H   xxQ V' |mG7/)tatˡEMutMٸ۝^"", ?7G3Rcwht	5
c>-auoktE.aIm֕bҘGRzm?O { F~ Wi//3_O(#l~_~ߵ xOV\H{-.e!Yg6PF 
(/?OHݴ'MG<e_vE P_	2>$~ ST/Z5 5n|SCCeAIZŶ(ڃq L>0~ǿ3~?|x#5A #@&'V	U-@g-(pI~_K;aeCDxŚv}oi|0w`sEynY^,Rqn>df_[6ž# wO3xG @֩K[[S<CI5;-BGn8ԟ@O'{4 N<}ͳa 5[ Ϸxluw><a &?e/7 Kf~>
^OD3v?&a|gh7+
WH~%O_<-S վ##2MYִYյ&(Z
[Iki+UcWς߱W{G DO> |n|c 1xw~W}S$^snRq  W<oxWj=+N_ 5cy|$l<)ieH]&%e?ڃ b?oOxf>j<:%_x'IN[
KY/mGKY	eS |y~::ڿx,`;? dWd?bKQoC5}yK= _=O<ς6e !ԴmYqEڸS-N{]]f H
	s_ށ  4?0/dg~ilViAU Ak?F E? HM=.ׇ7rökA\P_j- = ]w߄?~1to뺏4ɵ6ˍzTws5m-/
^_jpڋdl?W#}ORvo o>]j5е-bDԃGgaO42Z
+iet s:pßo-? uͫ [⥯I
x! w~U.ּ[ڴ}n> ᯊ_wǯ  *k s?y}hzi}UԵ+ԤOԿF{Y7KP?oooxo??# y 7_jl H I~  
1 
yRٟ O ?$'"Wo7ؿky~Q@|%  S 2< sMk/N;
 eH Y΀>>t?k῅7Zj$_ë!jWFLa+}sPLm Ii> q^nWngyk`Z>k]iM j]To{M>ִ?
[_7_Ax?L<K ̗?hg/]b+1G!7eĭ[C<k,0iˤ\ff6-dib,H E@ Q@ Q@⿴9מѾ~ӿO>"K{}SNMm:He63E'[?i0 n~ɢ+EI᥋'s}Sԗĺm_(ŋ돴_o߆&p'^J)z& CZ4eYE#oO gۛ iڮhk
6y}iv]Yr\跖Ů> iFm}F^ źM֟ge$v"N	.[] [naUXB[bt+IUtw3ifOEl 
( 
( 9
~oO= O'Kþ(Ѭ]/Q&>$o.hb7$Hb?~ jO 5/_LkMGBǆ^o
^^fq,La@
o]FӢA 7zko@ѬuM~KѴ=k6ZmeM5q"]ʨˍA 
Kῆ ?iOك_ҾŠlZy&miv+ԯZ	-?
%4f B|>& &h$ k_𗈿5=C\2 ȅ͵lអ> )X?d ԏ-}@	2>$~ SUm PE  Y f=W{-:<omfx졿5Gt,WW$WE_
~* =-g o뗛>٩WqRO-w91-Ǻ ~&]'nE}"}R\D仒346wE̶4ֿb_#;x@c}?ho<MK{cim35cX9췢_
ghxK~"v
gLҮ6d\¶<q*\Lz>-~#P=KY-;F<Q[hċ5١f9F(T^{ -   g4OCI ;BGo}ϖ:O+㟄|!oxPxkMo[|$\$ywRyfdbz)[8⿆z3o KZgsx_Bλk/«K(<s ?e?ߴO?d:aCK:׈bXVuImf[kuQ.+q )~l   G3 E?xsO?
|341%"Ӵk;mS𵽇H^h`bI|J|a_ \ռxZn}+%K䰛ʹ́mжs ]//ڽM|K~"K5Xmvvj]Ua #>{~ Gv~5մ?xB-=ͦfk27ss+е'4xG_~:N
ixEuW#wm-☣T|?~- G-z?[P,SJ?o`$,~cmq-?bM#~a~jb{粒[mҦ([Q4$Pá)~~+x#ٟ$ᯱ ;
Fhc{?j0=ͯs$yR/,"ᘒ^#S=qC
Sg T+ow*4_iVO5#Py)~z׀*|/f ]3ο/|i۟i~/&u=V05u:I+Io-TP?fύ- 	A^Z_+HЬSM8g[#dt#w32~ nº	/ k diھK7gɳ~ګ/N;
 eH Y΀>C||H gOORIh,-RK۫[-I6j_k
h{?e/u>:XϦOV>4n~%E/4]j{	jҀ}
x[~ǁ
?EN:>icF[[«$qĊ  T Q@xڷ[ <w?ؿH+ggo\| 8o  kfip9k;[faozce.+yZ%s^) & k=w}[úchd\Rٿ
PПG9/ B"vllپV љ Ĕ ; ?]R?>  5 - ) o? h>'Oo7'/wHFL4w0ǟG% |~ sw 0  Y %  '.7 ;  2	}Ѿ\;kw   4 ög)+8 OXZS	: 8_wy_l>6MnJv8YեJy+AJ=M}i%쩥;L?m<ηF?jOfRm_B^s =⿊9GOxXMmas\Z$ͻ͝m36s#N$N*)iv=; H ] z?_  <?- -ǟG%oO| A?Nǆ.7|}'ui}Y:yy _ GY_ 	<-< 7ٿ?,_*GIO  K~ w 7T>/?? Ω5U?GA/ *@Ogos<. R gx
%ψ:'q-w觱yRH9}@ Q@:|n|j^FPi |~?HKFWL_TH8hZ<1>s;֟jsĺdSCkä2$g
>9k6QU"4~$ V?c ??#K_v_L7_;}@ Q@|eHe??%h^4.gƏ
̯$ZlwSҮMKEkxkSO\ /k9WxQO ^O=;Oӯ|_Ŷ
֞"ЮXhZEn[st Q@ Q@ Q@ Q@ Q@r >+|-!-{Ɵ>~OQZ^>}>dE
oqIQY _o_C>>kxǾ5$k]']4k LѴmSI^j33YX[  +/N;
 eH Y΀9+ϊl d_EE>jsi7?m\%FΰT#}GG7SPt-?PҼGjh^)0k>
֢)u(aXe{yfk?^1 +L5uMΆ;/n-tynvzKL L<==R H<y\Qj~Ҵ2-xeQR Os
;  ]	x?KSzO [<MĞY G  c7: ~xt?<k3C跖O=N_E\$W, Aeًfٟ?~ 7_wپ_h?n˷ E PE PE PE PE PE P_	ë> ~!cxOsDyjT]/X/'TXeDW ; þ |X  pk:E;;xItk+|HfccW/7'a oϷxM$,_fY LM$ ??hυ7O
kZ \඲ 4=. uW.{Ӽ5[Žė?i g%V
<uxWX5Wl|?mij	'ei->d.j;-Oۓ	~MᏏ#iq Faؼȵ+$PY$Ztf-V(O?OHݴ'MG<e_vE PE xgs [@﴿]sIBբއ/'[[yc$7_?_j wOߵom?x
'1 Y6wъ#uk+8m쬵
Bm>GN|)V[o ;>5k>֭#Jm|[sey
ŕ[^[Om[ȓY_v E#%wi m~ R>?W|q 枀v E#%wi m~ R>?W|q 枀v E#%wi m~ R>?W|q 枀v E#%wi m~ R>?W|q 枀v E#%wi m~ R>?W|q 枀v E#%wi m~ R>?W|q 枀v E#%wi m~ R>?W|q 枀v E#%wi m~ R>?W|q 枀v E#%wi~o?to ۿ94ug/H$ok##0]Gn
㈃]N }YE a ' l g@M?<_Aw]gUu L_4~q{%E"a,k[mF.]:X-j>>
 Ё 7?AFy 7NK% :앬Xm޿z_?ij<+kw_|7exwB5KRXN^YkZ ҏ	RwUn<+Fbv-jڊkUӮ4/B<7vJ!m PE PE PE PE PE PE PE WoS9ω:.qkƭy
cmMqssq3,pChI+*31 @_gN|%~i7->׊/CkgIǏ5kA.%Mr/%~
/Oֿ <`j'㾺 :u֯kzt֭kl?}+ Ӎ3:~|=y_-[^cL%Я-f'ўh~ '  @ğJa d'	k K	 &#oZ2h 
( <wn'㗄<A4]cƾ%t;#dXy8'DXd`0G=# iJ i |C7 15쏴fW|<_.l | &EOů?/WG|?>45u*7`4m3Vk3운Voۭ4ůEm8Yo-s__>6k  gkS־%xvzߏ/5KkHO
6;$mt;+}:;;+U/e Q@ Q@ Q@ Q@6xA>µjmOuꑫ	-쮭aukzqV6Oُ-o#wmm?&Ej^ǌk>+(n!o4-[^隆e|%[?i> 5 po eOOWݴ Q@?#	}Mi->2~oo
xo,_Wt\-M:TVI*J]%Xw7L;7 N~7x>?igt#b\xF<G7[륶[[k@t?T ??oG ϱo~ӳg<ϴymE 
	txJ/Ǉ(ߋ~ /}~?.| <þ //|X ?O:ERGIt4d+|ǶHfc  Ѿ(~Ԛ=}xt13.-従(t'q$I}nD" }# iJ i |C7 15쏴fW|<_.l{U PE PE PE PE P_%$?u~'?h|: g? sWfx~T6DF  ͨ KǄVf4?uk62}Pwqm) 	#X G37]/  F|߰ih|`((UC

x@"ς?Kp>UZlȣZlTe4/_|R կj7&-}<.O[^^'_`>?f
jC>	$ծxkMno(^K{h6bƤI __U  )X?d ԏ-}@	2>$~ SUm PE Pt|
 uwƟOǿ4	|* h?_Y<!u*J;uDK-RI'gG9Q-@|7j.<}+|OҼ#}o|co[^О=8_\YLztGZZ.z1KN]읚FEK굥> vOH? ߲^Oֵ ?>5_-uM?ھW"mjD/w~׿&?סh?-7k 4 ͭtxo5x/
[<W2BWv}lLiPUnTm쵵]IEn~EiSSo [-.gT>&<1$weaey%ߊ\]Eq+KI&W}>C鯄 mcO>gmwᯈߊ:|_x[DӵwEEFԴ2m.-B[Ae]<
|5*֜yVy\m-vDl5.Y&Fc]~nֵ^!^h+*z6hZ>]ѼayմPn bO]kNQN/^5KO l,<:-.m 7k}hZMms%w/<Re]=4I3OgZ i4k+xK}JO>[o#]/,IiEv6qD֤j?ǿ OOza##	$ki9)a8~(#sqt^'K=YR+ ( ( (
 ˟|Gu	~1~̟h:Mc{?OqڌAf3$`R?ୟ_U   ɸ|7 ' V+ ( ( _ N + 
)39vd}O o/n "-ظM  g| 9A; H ] z?(>?xK Ǉ?}xſYO{kA"i" L.|3·ʸ ??hKG'>G1 Ih ah  {< $
5 	ڿ Ox{?e /Ϳ|hg.ɾº | k <Z ?]R?>  5 -y _ W_T<π?~/ G+*GgF Š#3#_  

 G  h  <?- -ǟG%&  R-  /xKCoN<^X C/ɛͷh%?_U CO? 7?|Gh=}, S-  xC h( 
( 
K  I~?V|KOc0  R?m ~&~߱'~3|D_/ZkhWZ\~O@FkHo}Hcög)+8 O@;kw   4ög)+8 O@;kw   4ög)+8 O@;kw   4ög)+8 O@Z'W>;]s vOk߉6g9mr@F^uS{Y j,;>6_-|!;|_k֚ȏQ[k]ʰ$|wO+IZ-|$bdGp9n֯k__'@%{ߵ]?:_Ə^.<q_hӴ
VHԭc-ko{p躼,O 1uNA?|A׼A7f5iluBU/tCD\M06oJ+o誘7[5sڗw0|↬mmY򧵎{E&;kss,qIsu#-* >~>2k_)gpu xO՗VNTԮn4:R/the%J
|-d}䢾Ik oCN썱zE~?֏ּ_< i/4٧<#x	Mƹeq!_*5Lx i1i B
QE/{E~t¯_Q>'~'isu[GAWP
^Y:5]\Hxf|\9+|k:cG; H ] z;P 8H#sNS {> kI"f5]9.|;bo!0||E,4=Wed+d9RmI=U" 5<yԲhW]KsOs[޽i{ٴ~&V/Mm}⾋3|4_ kH{=;MZıj׶u:<`KkSPqPMܢݟK[zm^SVs?'ew= K;/w?NLψ/i^jZaⶸ^s|t Ge׿
ַ?~ߵ x3LӯPR_mh6Z\/w
[ʥ
g2SuW_Yiꞁ*zsA* EnOzXt0YՑJA4RMm2G4E,2/ ög)+8 O^ög)+8 OG;kw   4 ög)+8 OG;kw   4 ög)+8 O__w__xgw
svk2|LJ/5?>xMj~)S#WZqu>*n$㻲ZY5qWgi  |~ Į =ys᷇~Q ;𦥯w;(f]RO;y5<θ@&D^ 5 po eOOWݴ Q@ Q@ Q@	7?L>?|p>sU5#wdo.b7ڑ"*> S-  xC h  S-  xC k[
aC	xSK7rǍ.|nOռoXwQɎK4I-Yι(:NK/_S
S |ON
8<{׋ ["ZO!a6пf]?Mռk{z^}Vr^[3C[,6.҈e Ŀ{٣|0 \G =#ڇ%[VeZƗ&N\ڷi7][Nӵq`k/  x>Ժw/3ro
E[|䱰յ{JқKu=B
6[-2HE sؿn/gd??  
CN>F(O쿷 E>n[?~ u?x/Ct#"Z g]a|KI2e9'7@3?? ϟ u__ K 
+ǟDoW vvB
 a;|? }O뺦oMב6uzll{CX sߴ?[??d/Oּq῁&6eIj6yqqZћۍM#6C$/,&5 ef/şك%(-oGٶ/[o[Z-v	ppaĄ?M$w<)	9k^	ִ}[G4>
լncYm!hX$TfWWVRAu7 ?u7 ?{-_Ukg߀? v k
"G3v>] q
( 
( l 8$c Ugĺ >$ V?c ??#K_v_L7_;}@ Q@x~<OO|jאX66Ѵ7721F$*351 |?b?|
h~5t{Mg{qumuX-l8[{Z}?_	>~ƿj|><W=\?9k(|I}gB
rM#ضuFqE<[Vmhwo'|/ o~~>^!]xj hq(..ynt1&gsTi҆8Tk+4_{FVoִws9ơ_7hn;-#LNѦkte7^[׶F3pT4yl6pvcn('l`}C<1"eQwn N˚>K~,|UW]kE߇Z7H-c6pkpK \^^Zx窯_8+F*oWy=+$n'v
8)/zèb~0cQIX
GJԴza5%?/KhRN	I?9[{FawMc}˄ 2YYIWVR]IVV	>o񵾡c_xD?	M:tӵm>RVH&D4\E|Ŭ=yaCx4l
]4|i]h |i(OIF_
<t.N_jsaei6a>8% n$L> Ǿ5~<A>үH|;˨>)tjG.좶[M:M=ss(J'mv&֭[1׳V_</-@=/k=+KӼȴH̚if}7I+1'xV_9ӾS_𥆹Jx3Qu>Q5jZt_iq6[Y˖h_|	@~1tx_}:ĲkW67#V/țWr}r)S#{Î˰'Jף[wTf9|-?
>%>ZW࢞'Ҿ}.
ZtR\Kx/ǿfIup<C)3ZyEI7	YO^'u-2KÚcFoe=Gb*eynoQ)+rKVzjJ
k>wB<O
ZO٫wFΖ[Z$2k!d4W ౟WxQ^;ĉXĞMDkgy_:r[ා/ڑ+gmszy?, j*}?|" ඿~Wǆ~"_j>$i,dnbԵ>ɦrLx= Go gM 	W'' h} 4, a^w_FIy}<^_<ZygZ
,R1vj s 3^	>-o湶%/o5jkźD_?$_5
~ӿ rℏ^qh:rYX hFyXQ.'+yGt刊gʤ۶E.WijW_	~qV/GφuHM> ~ Sm PE PE P_L7_;}@~Gg`ϊ__?
s
Z%jzt="THKm3SI|u[ )~)~L ۟=-~_ψ  f|5_?5mRom<MoI{0?gPZN{ +|{dAkYmkw?mJ5cH/>u$&i8? Q ڧ牾_jC<
9hVê^]h\<ͧAjhՖ{36{?>&׿i?Ww΁'ߋ?-ſ>,iq|^k=|/<BFNLWr	Ս  ߶o?]|c	<ax? ytjR}fu+Ayo;-I,2~NoSf>x> w*k%~
]oއi?
#KKI#ŭ`B@ dړ f3(_X ^ϋnQi6em[gO4d;bEϘj?okڳ{>_|!x_=Whrj7Z΋i厍gI{o-ݬOg,	{8   _|!#%Դ\5Cv/[]YMm;[M\Ι'E?n[W_R7_Oo <g ~|i?Rۮou,>^c:X8}tWn/ j~ t~ÿ ?c/P.>9Jy[Ne,-w{qۗʍѦh $ V?c ??#K@v@ Q@ W_wK ] +%h/&Oď/jxʾ (?m٫N?dGW<exz5?E652Yw
HQiDyQGz#n?;D~Z~xg=OS~2xS_47II2
-[|,2a9%od?z n__?lonĻ
O3L|5>+RJ^XXK*B߮^]bkoYL.ϙc<.eL<Y"%?ͳmL~&U4pn1zzvZ3Tcn|w';~ yk7'^McM[CR\\cExnǦy 
_?o|#}_ t>|/y{G{߽x9cQf՛祖/'Ǉ k߃>Ծi /,}?ob]TgG'R]^TJ}gO|CHx"/PM?k>.qu֏hznq-ZJl$եvkJQjRniJZ-7f`z{ɟ{W_8>)y淚R{kkvI.{${yhdH׎2pwZyy΅xYC4OkmťM7osZ@-qjww>5zg<wLKL5uGdM4J[K)fItNHl"npiww謽cIrNgi5{Qi~=g৚ sN?|$;_
667^!sHiUa> C*Z_}ȰH͔_y+55ֶI]nmդSjEz⿴9
uߵmImqi)OHn+g9)QkOZ `;~QX|WYNA h {4X_^DK{Q\Owa]#[rf<
ST	lӳW?>?৞*w+oMGOX	/.5o
ɧG,".ַ\bsK_f? ?ǷDwO:'{XLz}Zo59ZXdycłN&wm56WNEʬSO Ꮕ4O|5Ni>X[CP[۪Giqƨ*ZF1傲2
*+/N;
 eH Y΀=ڣsV<iu
ľ񎛦3xgZahc|o}ZfZIO
# 9xA@?w/yK^״)k^xB	G?gx,K[qmsZr_Z>
( 
( ?<7C_?S?쿉 jwR5vݜMI\\62D[ 	  O;C?'X} S&_ڿc ~! |Kٗ  g=C~_~4~,zOfCuDӧX5Mkg1d}-OZ/G
|/A 	=/#m~J KH\5aXl^oeϞ x>=G
~z |!ݿ|oC< {_Vݔ3GkyR%DY>< ǟOM@ti__w#H~3wz/!Ѵ_j04rPOR?qc~߲CA^ wMr[\.l͓xs	g~|~p*՟F N/); />5x-'Cֿ,YBmY_ĤwnР\gg? <i 	XgƗ-s񝶕iZO9cYaS T5|:a=||<o 's_~ uM4-n|#MߵMzmΈy +f	gg:u/⏄A ꗶs\OLуId0je<v\վԟW	_S-O]N }2J
r.fq7٬_M4mX  ?O¿t??fvφ|: ':ҤՖKzi&s-uEs޻[ R 4߳{A(aHү,U.ͣO_[Zi3Miq`H- Ŀ3f/վ4]k`ڏn|;/ xV
%02ך8uX彶I/U/o'_!>|!_mxNm)i6	u6cZ/g{-~PR6f I+i~ڟ5?+^O[je=_::!hVpoM*D`fYk  ?OHݴPE PE A[~?|sm?ENjƱ^CicF\\L<J쪊@澧~?'W7ß+UcK|J׵{{k^O,-EΡeu}OPʷk-k[Pо$ V?c ??#K_v_L7_;}@ Q@Siڶ֟&<.bYc0ܬ8 S(qpz4k6 [~5YAռgG?>.x6ǌ"He,Phkxx\4ia}tono f	?m/+7<9i<U6|Bl{3i0Kk1֝G-Bi|ֻ+kY+ , iM/> B5McCSASo<*
5guovaE*}DIy ǬOewxOYVK0kմr%F+EQ~bp_BGKZ7tVꜿm:Xk;X2<s  x _c5ckI>@_asc4oZ׌rL]4F_l '~?lox
Ig|Q 
'|1]t	xX<{jn-V]Au/i/e_h&{q`0ի*W4+Y_V&p#IY(Fwʛz%_]w?~"x%7ÿXWHቤH|3mGº<,/n/,K&@7o R_Ɵ5z	RGec.{> nK0kGO][O+xVe:Y;ҷVҒ[llN75(a$JRFM7g3
 6Ŷդگj	x ]Zω"uɶ/Dylh	>'wM?nwyKǾ}SBU~x/S᷇@^Ǣplck_w6OcK[Y%5jnxTs|>|^Լ/\m<MnxJtQmlgh+{XkacwZq
R^4^*TSQb
AE PE PE a ' l g@v.𧅼yO>Z}Ɠh7v:m
ŵͼ$NE |~Ϟ)x :<EqQ>ֵV!k}jIuK=3O8mmUЭ3Gay߈_7ÿI'ox zF ᯋ?ϊ׉RIlIuY{*i
:iʠ 
E'"<) $~"gß[ǥl^.;kY#-ĉ<k3[ ??i
j99xC	$nxM,m)K	e&XF`FaԐI
( ?
<5P?aߊ?NO~ x]ϊ⟃C}ޜ׊!;[)`U`oٟ$ N Y  5+/?o3oi_'O	j^73 <)dcៃ?l7.<%-?m,Qӎz:}hgiMo-B o;hÿ0yUy
S[`m-ŝOj {^E/ٛs(	돊ׇac:d׊eЦ[+Eo\v`YYbҷv|KڗZ =li:#xᗁ*|<
gTݴ+s[[ji26 =²  C	oN¥ύo(>ۮh?i|e?d j͎/&V0s&g b w t~ӺWYo~v>F/éxvf헟fF%SwK@_N]v4PQ~ۖ?uOSM۟? H.u{@;TܒǺ<?MHuH>{2Q)/?fx_:?ċ Y}G<zωuֵ3j,-Ob|N<~۞"Wmටῇ__ŧ6)h}+8oGoರ-ѣsŏڷJן5 k$ 	}#3mmJܶ@e|#b3¯
>$Oï_KIYG}?"C`k=<}Kxa~~Z<I \ OO\ dĞqqxn_M/ZҢX.~aomϐ\̍#VKV;E ~xCׂ|1t<~}c2^ &k&(6XrV)ocO3⧈B_(?X_Z-ē=ZV^+kKV{8@<L?b0?`?3B j[WE<<]6{)mg	uEވn]|>Ծ?|o |ػ 
>;/^j^9\ h+-a׈5i!I4pf _E P_:x? C~:Nq|5umSƲڳm^c`;k{If"orxk  
PA.^m~O:B?PӼw>]L>eaLȱ9 čN6[ f:'(GHֵ?Gomo^imt
ntoTм9x$߉?"ʺq}TҮtoM3KhK
5.~qFUj$ V?c ??#K_v_L7_;}@ Q@<)oi:?3:Lڅ5g
2_M}r7w7SJFfY\1|//?|/п;@Ӽ-77?^mu4\0ƞdw33HQE ,?><uu֛ xY'cZm/oiBm]yV׼EE}%c*tg9]$KݫR2j_!_
oCS>CIӼ1&]x\[̶+yohڡY/$֥o/%Yۤp$_,#[@?;?) t[}nf/^[t減FWaS{ˢ诉aNv'yIZm7ms?( ڿ|ssmwq4kȟŞ u_nƟ^4#e4f6w]:˨ )ʟ?|v?W'|B7o>߇
-iv2i-m<Fj0,CQ%fwiՒ_
uG6?\讁 Q@ Q@ Q@|%[?i>ݴPE  e/o WSg?/ b s#^O hA/߳^D[p~ÿ t?~# 	g ~ ~ҭml𮙫dZ؋o0&O6M¿ٳ7<{P8-<x_/¨4S̆HϓD~[ΞM9xP>| _.sY||o&?tM6דx;I ܬlJ7? 
 Fg S ?7G3Rcwht	5
c>-auoktE.aIm֕bҘGRM񝞛|d>7x:FjO|_5]ZGiix[ܙ&ak%0p? $ ~ Q  _G g 3۸ [ 	f?}?-/ ??KI<~ ??KI<~  _oP-3@=S=WK|Ȼy!˚a}v) ( w~+
D |k=5k]ƾ>д;$)	*Z%$?u %$?u~'?h|: g? sWfx~T6DFGW jeڷKiXo;
!.n%3"" K~ w 7T\lgM a-?Cտ/lmw}3×Cvkwb}34Q2qg4Mg*D\. 6՛OI4??anww>F->z4Sra>yoK 	ށvy lX5nux!<[i07n{E<gy?o?>N]_Mc4wVqj 4
je6d9b8 \ 9bxSEπ:'L/u=&oچ>E;HƗݔ2kh%o1>)x:~Ot}IIaV8!4HUT  	 KOc0  R?m ~xͧ?(x'Zltv:Mu{Q][{]<k=Q]1 Ih ah  <?- -ǟG% |~ sw 0~N| c# 	ρ yDZ>?9; Z ??hKG'>G1 Ih ah  <?- -ǟG% |~ sw 0~N| c# 	ρ yDZ>?9; Z ??hKG'>G1 Ih ah  <?- -ǟG% |~ sw 0~N| c# 	ρ yDZ>?9; Z ??hKG'>G1 Ih ah  <?- -ǟG% |~ sw 0~N| c# 	ρ yDZ>?9; Z ??hKG'>^{'g xߊ# Ji_>(-/hϲ_2A
N˄FaS$;z1 Ih ah <?- - ǟG% |~ sw 0 ~N| c# 	ρ yDZ>?9; Z??hKG'>@1 Ih ah <?- - ǟG% |~ sw 0 ~N| c# 	ρ yDZ>?9; Z??hKG'>@-|n 2|:|W|_Zi5?81,m dHVYD(i`2O<_  _  ;z ?/ ׯ  Ck ހ?  5_ oGC  / ! w z  ~ ; ~ oN_|o>~wo|/OZVyIq7ii̚if}7I+1'п?hKG'>@1 Ih ah <?- - ǟG% |~ sw 0 ~N| c# 	ρ yDZ>?9; Z??hKG'>@1 Ih ah <?- - ǟG% |~ sw 0 ~N| c# 	ρA5@ob|NmtK_I֯t;BH^ҤgjO,@d-_f        _ 
Main Menu E   .on mouseUp
  go card "Main Menu"
end mouseUp
       p X          	       d 
Main Menu Ew .on mouseUp
  go card "Main Menu"
end mouseUp
       p X          	       e 
Main Menu E   .on mouseUp
  go card "Main Menu"
end mouseUp
      p X  Go to the Main Menu screen          	       u 	previous Sw +on mouseUp
  go previous card
end mouseUp
      p 8  Go to the previous screen             @             	       | next Cw 'on mouseUp
  go next card
end mouseUp
      p 8  Go to the next screen             A             	        	previous Sw +on mouseUp
  go previous card
end mouseUp
      p 8  Go to the previous screen             @             	        next Cw 'on mouseUp
  go next card
end mouseUp
      p 8  Go to the next screen             A             	        OK Ex   on mouseUp
  checkIt
  answer "Good Job!  Do you want to run it again, or continue?" with "Run again" or "Continue"
  if it is "Continue" then go next card
end mouseUp
        l T           	     
   cube's response  	`        | P             OK Ep on mouseUp
  checkIt
  answer "Great job! Do you want to run it again, or continue?" with "Run Again" or "Continue"
  if it is "Continue" then go next card
end mouseUp
        l \           	        hidden A                  	     
     	`        P          Lesson 19 - Practice  Lesson 19 - Practice 
     	h          P D        You're on your own now.  Your mission is to write a script which will carry on a "conversation" with the user.  I've given you a head start.  In order for the script to run, you need to have at least 16 lines.  When you've gotten your script running, call your teacher over... or, if there's no one else around, just move on to the next lesson.  I've given you the first few lines.  Click "OK" to try your script.       	`    @ C   B 
   storage  )h          dL         on mouseUp  4   answer "How are you today?" with "Good" or "Bad"     ask "Really?  Why?"     put it into theResponse  J   answer "So you're saying that" && theResponse & "?" with "Yes" or "No"     answer "I see..."                    end mouseUp       `    @ ? e  
   secret  `        d,          This is a secret message.  +It has been placed here by the programmer.  It is good.    plane C         L (                           	     
   	practice  )h          dL         on mouseUp  4   answer "How are you today?" with "Good" or "Bad"     ask "Really?  Why?"     put it into theResponse  J   answer "So you're saying that" && theResponse & "?" with "Yes" or "No"     answer "I see..."                    end mouseUp       `    @ ? e     Reset Ew Don mouseUp
  put field "storage" into field "practice"
end mouseUp
       (t p  Reset the script          	        OK Ew(on mouseUp
  --enough lines?
  if the number of lines of field "practice" < 16 then
    answer "You don't have at least 16 lines."
    exit to MetaCard
  end if
  --make sure they haven't left lines blank
  put 0 into ct
  repeat with i = 1 to the number of lines of field "practice"
    if word 1 of line i of field "practice" <> "" then add 1 to ct
  end repeat
  if ct < 16 then
    answer "You don't have at least 16 lines."
    exit to MetaCard
  end if
  --run it
  put field "practice" into theScript
  repeat
    if the last line of theScript = "" then
      delete the last line of theScript
    else
      exit repeat
    end if
  end repeat
  delete the last line of theScript
  put return & "answer" && quote & "Very good!  Do you wish to run it again, or continue?" & quote & "with" & quote & "Run Again" & quote && "or" && quote & "Continue" & quote after theScript
  put  return & "if it is" && quote & "Continue" & quote && "then"  after theScript
  put return & "show button" && quote & "next" & quote after theScript
  put return & "answer" && quote & "Click on the right arrow to continue." & quote  after theScript
  put return & "end if" after theScript
  put return & "end mouseUp" after theScript
  set the script of button "hidden" to theScript
  click at the loc of button "hidden"
end mouseUp
       p X  Run the script          	        hidden  A
on mouseUp
   answer "How are you today?" with "Good" or "Bad"
   ask "Really?  Why?"
   put it into theResponse
   answer "So you're saying that" && theResponse & "?" with "Yes" or "No"
   answer "I see..."
put 1
put 1
put 1
put 1
put 1
put 1
put 1
put 1
put 1
put 1








answer "Very good!  Do you wish to run it again, or continue?"with"Run Again" or "Continue"
if it is "Continue" then
show button "next"
answer "Click on the right arrow to continue."
end if
end mouseUp
           8         	        hidden  @
         d @         	   	        Done Ew .on mouseUp
  go card "Main Menu"
end mouseUp
       X  $         	     
   	finished  	h          Blue    a #         You did it, !   
Great job!  You finished the program.  Now you know some of the basics of computer programming.  You can take this knowledge with you to any other computer programming language you might see, or you can continue on and become a MetaCard expert!  The choice is yours.      If your teacher requires proof of finishing this program, click on the "Print" button below, then click "Done" to go back to the Main Menu.    Nice work!    Print Ew on mouseUp
  answer "Print this card?" with "Yes" or "No"
  if it is "No" then exit to MetaCard
  answer "Make sure your printer is ready..."
  print this card from 97,18 to 500,307
  answer "Print job sent to printer."
end mouseUp
        X  $         	     
     	`        P          Lesson 1 - Practice    	previous Sw +on mouseUp
  go previous card
end mouseUp
      p 8  Go to the previous screen             @             	        next Cw 'on mouseUp
  go next card
end mouseUp
      p 8  Go to the next screen             A             	        
Main Menu E   .on mouseUp
  go card "Main Menu"
end mouseUp
      p X  Go to the Main Menu screen          	        	previous Sw +on mouseUp
  go previous card
end mouseUp
      p 8  Go to the previous screen             @             	        next Cw 'on mouseUp
  go next card
end mouseUp
      p 8  Go to the next screen             A             	        
Main Menu E   .on mouseUp
  go card "Main Menu"
end mouseUp
      p X  Go to the Main Menu screen          	        	previous Sw +on mouseUp
  go previous card
end mouseUp
      p 8  Go to the previous screen             @             	        next Cw 'on mouseUp
  go next card
end mouseUp
      p 8  Go to the next screen             A             	        
Main Menu E   .on mouseUp
  go card "Main Menu"
end mouseUp
      p X  Go to the Main Menu screen          	           K        T D   
   roster  )h        @ p                   `    @ C q      
Erase Log EwCon mouseUp
  answer "Erase the currently showing log?" with "Yes" or "No"
  if it is "No" then exit to MetaCard
  put the selectedText of button 1 into thisField
  put "" into field thisField
  put the selectedText of button 1 into field thisField
  put field thisField into field "log"
  answer "Log erased."
end mouseUp
       p \  "Saves log report or roster report          	         bug.JPG  	@        }    J JFIF  H H   AppleMark
            	
       	
   } !1AQa"q2#BR$3br	
%&'()*456789:CDEFGHIJSTUVWXYZcdefghijstuvwxyz  w !1AQaq"2B	#3Rbr
$4%&'()*56789:CDEFGHIJSTUVWXYZcdefghijstuvwxyz   !    ? dO?_ >.|\wktm'X_QvYYoeekoPAx$K  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?  |~ Į = GJ?= g);OxZO7X>_^,ln~xU=G_0JbiQPC  p eOWݴ Q@ Q@ Q@ Q@ Q@ W_w  L7_;}@ Q@~h~
~пP/oz~
O⧋f4k=gC\ӵz~}Il׶ھoя͊-N4u[C~[~	MOK	 x_lt ω,ⴆmE ?4uvҭZ{okuidsWO?.AtC?eO/ t
+@߇uOٷsCek

4߰Ime{#' ~>5xP]k{xcӴ5McᗍlFVi[\^Ge1۪,^.'DM}@ WKg0~ן'Z]Əei:ԑ}Dy(U-QCZ8lJ:yUOcF[{B|Z9=_Gڇ[  ~-xWԵg.OT)u-JQnJ29 !,_a*|-F/I)<)%BZz6J:7ZhޯEt8Q@|%[?i>  p eOWݴ Q@ W_Q_'|[Ix:]M
7-mJyaKu;T v??{|P1k/y?^"GOڮoww4\0
os"DU  VطQ r? ?m'ƏKu	|Cះ$֬u2د.q^&,\y
= ,|jि 'Fx n1l|Du'::},ZY{;}GM[msR `|t c 	mߌzurdNzL5/;Oikak(?h>	|R˯+>Ѯu;e!BBm8 W7 C JI~!C|Aťd-\]:ngqMqNUqL:^yK~+)_õȣK/< 9$TtSwU&N4s{՝d v4߆ L=3AMtXXKk}"\oXǵo	 R-	x\4?|Tj|E<zu䚓:ts."As˲|?,SEsztI=v~ČV*x	jVnԱS)$T_+8՝NV|oM<
}Uo3?
K~~ݴgZU W_w  L7_;}@AQ<Oź_V,ȗvͣ05ȢHM@?߁~$ ~zƟ?zOxcS϶7Z5}OH>&d"5kIOPNtkWN?߷O7~ ?h/<Si_+OK}_zeO=֙o#K[A vX)~ 
u? @OEL^|6e{}(;wU  wZ>/bbm7~Y9 ß	)+H~(<1)4 jzޓKkmu?aKɚH z2|
mCX[P<qjד^_xKO׮n$iͭ跚/\]5kmg=ė6y  kY^.?c_x⏋F
DxMGQc;ap!!)ru tUJ/g}Zv.|! Bŏo.hfE-aHWІXo/?* _t
#.?im̲]]iuk#X尿}J=H1X'kS?|R cW y|MqYt77^#xW1YYjOۋ&M
-m'TմKMq>i  ~_Po
CωƋ[ɡ_lo.{t˹	m9kF2ߦe湷<Y͈˝p
Xۍ&`9:'WpbXlcBJvj%(5R<*AI;In	O8+/i+ ^4g
+NEP 
=˭ur)IaC!_?x'th4 lVimo(w$jN76PY~=an4 &Sw?p_\{F.qVtɵP-8I-jsd?k&o-me׏c
j/?7Z_jT]4xc,I?Pٲ? 5ׁ~0xJ?x+&{K}$,xq5UOQGݤ8-Z7_d֩]}|V_8p
u<n"MB2EQrc*IC+BMBSTG
Ww>c_Qﵖ3^AsI[tIVXmbYk\	Oc .<>-OygO<Rˬa'oGKJ b[$Mzt񒫘<<tgt\fGq|7CDgdv}"8ehߙJ_Vu/5өJPJ7Oӭs[<;kוaHG݂Gq/,챤HY%z'Ņ|%[?i>  p eOWݴ Q@	^ /~$~=|u&m<9>4NLH)ivڏbI8 cjMc%?||xW6+n"]sZcǨbKAr5r+aR $#o"tM\F2BR֯K鷑</m&P܅&N'~ٺơ^ߨL<4]]nk.-EbYf>D >!|4a?^_%w-C 
t |?j1ÝV>
X_X6hVYXR7  ~͖OwmwPK>.$miYJڸ:ZEkY}?X]NohqF	_ǚݒW~l_
zbWe71og_1#~_uo1_rFQ~+ѦI壋:uNm[H&{k
o=~*?_@Տ8/;ɯ"a[+ߋ3R}E?Gdѭɫ+>YY{ъKKKM"9o#<X.Y\=JSZ4^rVNHiеxwo=^k}'@y<UgjRk6KMĐGss3C/>17Ǳ⟈0|4<97	ukhҾ7 w'}K#HVAc_Lx3ѧcV}<;MK_Ys^iS0_-
pT1_Z"UV稧kTHԜyTTF.dRSFI*oD>)j=7ŗ.%7:{ L֗2%$Dekf~3 hb¾2>|e#|>^_kuqn,s+̦0#0Y{<\~[ ]z-IV&mJt	Kr8ŨsÓ㳞4rW\L-+ٵI;E%tOMݤI]ȿ$QY
뭏kCq{
Gej.OV*.	Rw+Xq; v_Lt{-;>;onI	DK]FdӮ%%62l@V\,eG'NUkE))'Fӻ]tv=K3"pЌtptӛs,<FOex'(6 bMoǿ
h(wK[>^oj˨-UG?"#E{~߳W[4+񟌭ArRlu	"Q$gnUYnx֛ՔISmU$G3{a䡋Т(c0.5M+)JK} a\xx{⏊"ڧtkݡUfVH&ex$a!P׶~\a ' l g@'MG<e_vE r (h_ڟcj>o/P:2O2'G]ە#ٟ,O[TW"EX%ҼAn-(&Kw֡m5V
"[ 9_OѪ~? s|?CFσEyoK!
K72?ڧ	ѧ۵ðxKΩ:<X`UM\KhWJ4iENWQVWM'y;E&W[gnip6rcӧCCuIU%8*t".jchN2KZ~=࿄go|r}jh~.7[k{M-63^18_>!ѿ x|5F?	L x@m{%ӣPI~J	XWka1tЊ+\IX7SCܧ6*4'gVu(JU)קQN
jujdJkO*%u-Z_!l5>6>/oEgnaxDMt7`=c~߰/Zu/hN8'-ym&F̑^#lx>k	{I9ӃWQnF#; x%,VkgUJaTPb>IV'
+^45JF*z+@-_o|*d>AGC o_3j~ͭ-mu?T-2\Z^-bdUh	$PJY? akq>ytS%{R:rq^Ӓc{*5aRoaUeKgŸ8(եk_ @#/}?j~}-~~z==?B$vAc=Ĵr4eV//(6M36cMj2N\La{e{gMF,LD?ľ^$	d3r/*|tQBT5֥jьREƤY'%ZZ5xy_JuiTrMK>gnk9՟gDE,4Z~vuGaQ#16Eqm_?wC*ͬi_?>)USVNӒ{+>Zo乚f+aRVJ
ݲxXLN7X
R"%NVvJM-_5xA_	~qV/Gφt 2>$~ SUm P_|~7= O :cxᶥs:LiuC{mxe;RWP"6hxWգzп{'wokgO:ėjv)Er"OY/zI^2wwΣ 5>$_}F>xSռA6M-"3OG
"&Qh/mhwe<o)O߷;ŞeR=o	SCs?b%xqfij!Ylj)Si>MZ(&U6;q+::.5\jNĶR-
g8VxC9VEJgowv+IǂuoڦHe=&K	;XI"1/_ ~Ɵ'u]Cmq~IYfk=	[M̰Oh_s܋hʎcωMIESq|+6
VufX\pFjUVsӧZ\땵R\PNrv>D
(oKyg6kn\'Sڻy3xvJѴ$[ΞHďE̡	|	?|eiWğFn7)ΐb++Q,#aBezgѧ.:(a;Ztի()sVUtpiFR~'Cs,^#%&:2Pm7NU	vZu:
\Sg}:͆- U(%mr iy$0ڽ˽`_27 vP>: /}GB[H5'uIom-5ڭbH-g36xß
g<[
Sь^1NP4T+\NHNYpeViT[JQvr+om|2 ~߶bߋ$=x?Z9uh>5+Z!k{(UY~Pgz[qW> 2gu[/gߋb}95Mť]Z?y5CD pf{<+QpГ'4I0sR𓴚nUlڎQ-)ͧfT;:2$4TyiIU7 
?i?őj^4Mb`O2>$f
IRÚ*3^]UשNq٫fha ' l gTdL7_;}@G;?e?}u_>M.u&C6VrjYp<G߰ |Y}F/VkH_IJīdwN!^֬?9UFk@x97oTejj94m:q=\-h~?	 fM~}-V[ml>
i40ݦb`Utd{(ݿAjg \:|'>xRy..pIϩhvVsh-'?m3=< uqgL =8Ukԕ()*0Pf
r溏}[?
Qx	iÜ٭IB,.kRPiunB(JNo;~wڟMŏ .I- ( Dp[$vт!(ZIeWfk11XTnO~/$KDx.KQr\:B4A]*^MO&'yI6ٓg 1fi_Sѵ;n"m&ŭE(8^WXٻ	#eU<ž2,W-1xhn'F}z̓mb-t{x_ȱNQ.!r`⚋{n7v-_+vqG|/8WC$ah֗=\DkTS5aW.iND4V0?fco7&dZ7]OoxK\*4W̔qu"+O>uX+o? t-kcxFHYc'G(cW2aeԪIai8ӻP.nDTו-c?<?G+{L^2:_3秄˞8X՗2IFII-ukֱ.D7O
KJ-=ݲcXr|f4_/h^TNM߀_>" [(%
dozl4ʶ3:$8.mYwQ_`,f\ЕN23	.Z\i)JUxs[c;|p78x:x^ִ[4]RM<F&m0)\G% :?o_)Y||?PO>|HΩgݛet,#ɶUMd$_\qW*c_9b0I5\UZ
NNYTF)TT"
|6MQ[>'n7uk~x 	KQ?iςKn|/S[&dP-$Ɍc(U5~iR2m=u(1l4W *g;8AIɯTaE)6ھzޭ-/UYp \唩B4ԔRN3j+2sP!N1?ୟ_US&Oď/jxʾ h}ǟuس	{ؼW[Kj$Zi.fn2,2p#FH2d??O?_:9#Q^ZK'
c;9/fU!. Z!S^7cvQ[ybqX>+*׭RMRUㆣ7xWm5f} gY}U5O_ |Yb;y-u׋ aαl-g-X-~|$|&|GOQ|cZx& NFmOj{u{,j-l-)W+	L 'ɸ{;sJ3_hIFMIYJRs/f/|X׍+t<<!trttF'Rm$읞)U 'Fۼ+}?|%Hwb}a
4s:%rE(sg 4 _ jsCw埏.mo
xP#Ix7COjzl#muԦ4tv4o_ F?bKY$?_np}GBUwXGʟ($q}>xk(NQ(2nv׳?yqQ2Qyc*8=gu.HʥjUh)7N΢m9nP~o~9 Zk>;NaZ L&%_gMf^hT\6Tt[T%?^_*x׃Ai֒\2-y1EݤQPFHC%ǅF>q+1PB<rOQ~Ҍ
97(rU-.C~}\;d<A+N*XьJYw*Njo!> | N|7cXuincKAsosgqrZOHw_YKms;T:OPm5x2Ou(FIFRMBcS7(I'vJ]z6mEUR v>Χh]7Ekb{ŴI@2K(@p? _$WA',vڶv_N{`(":SX䄦ɽ:p'G
)4(.M]ujSq+p- kZ_On=zU-V[>LxS-]k-n-| W[~_\o<Km_K_OW𝕻js&3i5ri+	˴m;/~JաTES{Jzr{UJ2bV{JAoV;}:E)S֥Ե+>Qw,Q<﹙9R,,rǭO__	~qV/Gφt 2>$~ SUm PY]NYNOx^Vі7n~ђTS  how9 
7~YΓxU#C˅B$@P#2f&8Fkt驪pqd41RMuX'	NTRmy8 a|4>C/H^h5A-oKaDʓqp/_o>~?~<Rcs2Ry̒,1j^_,.y<n {z1J..NM+_x?x<YNgRn1u1ԴJe7irXrQiǿǇzߋK
^ּSkeKfUncs06M.;aaKvgYc}^隝ڕżr*VR*@ 
~ͰA7{ѩwMVRݒP#I9{T7)r>,<of1#;ʜtj}Ғ~\$Tnk -9Ǟ- wJMV](	ⶆXi#}d<d̃ %P|u|%oXFGI+$I9DhG 4Mg(~wZ'b{d EG2<(&)db<$h>+N%sQi8-<e"FғUNQ3Ebz	?7M:~Cm|jt>ԻxZæmcNW}6˶	-䶊x v-]/٧	 o 
.m'
JVw/dϦ7r{J*ͳP,FN.>
[	BPj)Jt41ʔT uIJ,/FjMN6~/7JOK |*#kmfff?Kf]>PԂ%֑op ĭ#g e'?),ѭow1Z=΁^mwҷ--()'+}5:8ե'EviSMj{3?/* h>$:_Fie@I<2-
iqu<`Svo  >_?~se,h-[E,4>Ict Wg<g\V|~YEj֭VQ_܋+^h㧅OW9Jch:B?ୟ_U  d ɸ|H  V +g
y?!^~	𶝪_Vp"MF(mk.a^غ VN]$k϶ùGuےU9q[9*qWn+&>~_߂}7K/.?{,P#JEZY$e%Gټ ໟ/e}9EUo+7m3G!ȧcciEΜI6eo.1mĘʭ<>7&ʔN|FhK\-dEW ??__	o-1/Vbh6V^q$2KHkvk`[ +!qSX4(7N;_fS3<2UөOp5=Tgs?ػ&EgH~FOL|Oik-s\ũC5֒w%Os,ÿ4& X?
|w!IԴiWSEd˂v-.L iNa4L^&#Ԟ'qn0sUόiqM'/cѭ)srS&e=_-oVtN[mJWx9`	WGF ) AW 
Kye#tTeLS)!E%#	:XXk߇_k񾁦xǴ;^9rFkJU½	N
J2iŧtZSM&?ol~8^3~zo:M{?`$!ktUXg%¸ Fy~cO%ks89IM do?CuxUFGxkOFgIq`Ym ZGn RcF4 a)քm%ZbkJڔ$c8N8,	5}dג.
<&n ~5;<E_mOU)?g{᛽:qE4_\wŗK*&O_ ~?M]k 
~,ú,t[TYc[Ke6i3,ZŴ+JN/Mլ3iGgwP15j*a9Mn[rrʛR|EjdP_	~qV/Gφt 2>$~ SUm |l??a_WŔZB
Kq_Lv[Zq3$_6B$[	(ԟi*KD]C7-^
i.Uk5ȿb[[4xXD|W6'GBfr>"'f\IW1<4]\ն뒅Hы/><#]YmR$.!Y>fڹX~PgxW/'jC^jv3K-ݬ"!QE1cm!Jv~m9۪yX)S*qSUEGNyUM5T4'8F ؇W ۓ<3o|]iq%GB(7E{1
ƴ`Z/Nr \1S8s{<*n{49OKO п6ei\7m;Hnna	E-yk$a QH;c'kytW4=jޥVeo)deYԻǽC3;ΦkjU#e*Rg
q\nk)^_W]CjU\cIJ2RRc.wh^S8	EC?1*?M:~?n<]Z>5d [KOosk>ҷKkp/Ǿ5?G爧fl&n>ڲsayk{wI"'XX?|/x{ աç)>V)ΥԦrVtTQ1yv+?eC
1V)RzA-tjƗ(3$>mE+*"1q ?x7_?goI|yxF'-4;QѴFBIYV$.ıOr/"z_{ֲ-j	G٩*Uiy[EYuk*s4)l\{vDS?(f i+a,)Y]xWᏄlX4j[wXڙ1uv.YnKK+qd?ਗ਼|9[}x;K<GEcA95
kX#XQqj1[vk},\OAU%Tp8B_mz-ɥ|gj8ȻUq,u
sܜuF2\?/ij^6OAO/¡=v5ֿAiZٛI3SG褗Mk{v, >|b |!YONnink{6R_$84NU<-NMi{fWd2싈)g4qUiPB2&QJN[
^*rB.Snآ +/N;
 eH Y΀&Oď/jxʾx'ᧈ5o~_|OEKN؍Jm-坔*3-'{>]˦Um&u	}q~П(-|_+Owg[{3IgpnY'28i.UH]GŹKrw{EmwenYiV(XjQPNܱI]*Uj5Vj1Sn09a_)M\'ד	_<^$_\K:lZ4ILC:accieVmIqA  UP 
   c*Wԍ,vNR^M~LW9TZ QiԂRӥN)/BwmZƽеw^F}w6&#m@YNq&6^f ~zWvx]I<kZ"-ʈ#lniXG#DbTe^K}= kkjVI8*u7VUcAҊ1q Kuk
7XӼEa,=:+hn!Tq
+XS/?N/)Wu-6[-Kkk#S\]lnC-Ʉy&ZgxeIpxS'(Jpӳ*9B<8q|G
_5 a X~"yn(~~|6WOtk]*w4]Y4]+c:5to-VYOMgث?
fZw|*|/My!\=)G$,X2*p r9έ>g^V)Uw*PJQPFV[59읶VI۵ھgM@~̿C'
ol-5m.64fH%'xg~ݞ">j
>,xB4F:įx|04Cwmݶ FM[Ta4Z7ZSߊ0Xz0N$aN~ZpR8ݻR
 N~?
j?t*C|8U]h<GipiZl;]_}L
Iwf%??MاУҿf?@ֶWzzujڔv<V y;31$;He
%춂t+{583&!aJUawS*曝[N*J(sjp(Y}EuQ@|%[?i>  p eOWݴ W_4 W,ZgԏŞ 6Yk0$f!mS
ĉ
"X\❯ׯϳcZ|E:)򿅵RVw9xw_i|?[s-ĩC|'8 `cEB+D^*LMy^sNY+_R/Dc?_uM}WU_zj&msVԁ;+$)1#9)~Cѭ.DKu	m72\"G$ͱcK7(dEq}T,٬Tn=,WA Q@~j~Hأe_߁;djZh FopT*؟;*K+?>+	x|L9mwVkc"~̩!AI)%i$ӌԣ$Qvvj&/W@KkV1 Ig;(df!Ts
(z0"RKD%+ׯS)՜)7)JRw'vmެ(2
( c8+g# Ug: ??n?|v թ*RL좹nbx.-dxtt`C+AR h bim;U*?߄-<1ik<^<˥w33dCXx6p<L_ӵp`)Tbd/vַ,RM&F'(qss{jufi$N*)igܛHϓ
( 
( 
( 
K0  ~?V|3	 &#oZ2h 
r65i<Ov#kG5I$Tb:Qh)FP~zKw=*Kѧ{J֔5W;"{|UYu_N
|C{s+?w4(;"3c
mv}Xf|2f39M7P3mAZ0,RW(O<( ( ( +/N;
 eH Y΀&Oď/jxʾ +7><1qjfKwNe(T4!Vϗ"@TPE PE PE PE a ' l g@9K_Q ٻC߳&w?hޭ:͏];>m41jo"Ze|0 b R?  Jx  f %<_ XT3??/ u@,_*GIO /#$ P 
 Fg S   H 3 ) wT  љ Ĕ ;?b R?  Jx  f %<_ XT3??/ u@,_*GIO /#$ P 
 Fg S   H 3 ) wT  љ Ĕ ;?b R?  Jx  f %<_ XT3??/ u@,_*GIO /#$ P 
 Fg S ~|{c|I|9
'[DW/X6695+JYOOp,Qn#PC       
  !   	h         @ D        l Why is a problem in a program called a "bug"? - It is widely believed that the term "bug" goes back to early days of using computers, when a moth supposedly got caught in a relay in a computer at Harvard University, causing it to crash.   
       -
     - 
  #   	`                  Billy's last chance...   $ windows.jpg  	@        @    JFIF  H H   AppleMark
            	
       	
   } !1AQa"q2#BR$3br	
%&'()*456789:CDEFGHIJSTUVWXYZcdefghijstuvwxyz  w !1AQaq"2B	#3Rbr
$4%&'()*56789:CDEFGHIJSTUVWXYZcdefghijstuvwxyz  !    ? 7|h
i]A4/x[CkR,l3Io3GM4Z[Z^\[Y\ׄ~~ ǅ<1wcI4y|#.o!V K׼muk5P<5&kP m~ R>?W|q 枏v E#%wi  m~ R>?W|q 枏v E#%wi  m~ R>?W|q 枏v E#%wi  m~ R>?W|q 枏v E#%wi  m~ R>?W|q 枏v E#%wi  m~ R>?W|q 枏v E#%wi  m~ R>?W|q 枏v E#%wi  m~ R>?W|q 枏v E#%wi  m~ R>?W|q 枏v E#%wi  m~ R>?W|q 枏v E#%wi  sӿaA/W e/vi7Td&eyg6.x]n{Z/%^[j>vzN|I}%ڥޛExMKqgNonu, ?A#xρM^	ִ}[G4nukk{kYct9Q]]YI?<~SߴtOI+\ =57p_Oceu}{KUUinm's5
 KQmWO ' O <~,K1'l|%=/jڮfյ+%uԳ&
`m۫x cDt?h٦u -π?.5OӬ'xZ5-
X.k6wֳ4?S\|~%x+_C/?|^wFxoAIҭͮ\RҒocgg|SgOEEI6c}|k-!y$	krѫ32߂?cV/&oƿ?~8x3Ko[k7Gx}t=iurmn cu~Ӿ?P|'^ƞ/+.|[iwc 
^M?ZsqNM:H5(]N]?QgU |WmCWCԼMz^޻cPZ={sdڝ͌J4ǥ~2 # J/?>5j:?%W5{n{!sڮui}a?#P-ocgz/ m?~^ '*r|_gٮmGGg7z+e
--z٬S-| RBP4 _ց|>y?CnX6 `%{|HZhڄBs\]c'(i)8ng??
~:>,񇌭O
^lPYOgWϩX4o σ? i߈ Oj/z;Ԟ+m<[~	IjQТkF\MiaɃPiߥ/OP  ?;C?? ٟ-oK~O"?5w\~п>'BW-? EhxΝxC@X¶Swuo5/B?೺ اf!ngKu-gZlA°6 UkkrL>cdc?oo''KuZ힬h:*w>w>(Lh׮Fڝ`(o3Mҟnº|w߱ k di:~7_I~폍㯅-[~ijZ ^x-<p<'b;L73xhD_Sv5G{IjTB?nkB  =g_
 I ؿ >_  (h_ǁ3OGMu|S6syB$l" K	 &#oZ2A?e|o?xx*45΁h1%\m|/]XKK.{# s~Ͽ~O
xCQ=8^EhomnTX\jr.ogt:'!({=?h+fmK0V7& d
&I-Au,0%s_5|O<Gx>$	iZu4k
ZiR:ީ|[%A_!(½gIOoC<tueto;4\QѯnfnAvSc6y/ٛ	 +MŞ?VƷW/4lײ\{FnIv-77's>d=s_[yf뚦sKNf}kRVVC--۵>Xz ~G= >l|/[յ
d5RTtguyw-݋^\o5=5ZU5~2};;KVSE=¯%igS
*r;8/ɫϧM(ϟ ?x/ŏ6"x
uiE4?QֵtAo g??OmB4  ~sL.!kEm$pD%g3@/ᦅOΗh񾡪ji
MFM94Y$/dNkVk뛽C?lOI6|7-x?4[V߄4/VFl$eӮlnImW+3-$DH>[/~k:XO{}VS|MeukcZc}qo$>Dcl b־^K>* ǚ3k^6Oa崷{3/l"6Qшm'0=/#??lOkw-ͭҬnno{]<^qd2MjҰ0|  __ ?  =GFE
wy_  @>#[_h|>~+~ҟ4}C5t?xODn4M'Oյ]OgݾӟMV(RG1  ($ V?c ??#K_vK 	0-  %hD  > /GgJ~m??/_a?Z^~7j%?zI>&eھi^SV68uVwCV& K?-y& j,>j> -зRLI'FYnM"?- {i&Þ߸)_~#}s:.d.qmGm?Oo$Z|{vVPt   X<%|^u?M7ĚuΙkO9?ү/ Y׶ڽ_ ??kφ_?hɠ_Wk,_-sX/#x_N4k
Tsx_Zd1g } =k|)߇Z=kxŞ<aA4:+;
FckGQ徹.A{y&~4_v.Fi-Gƶ6-]\1^|;OǆmH1imxy	Pk' _)=\OxMu᥸ӣaq9dA @~~ן<)0~@ ^Y⿈Z:_Gbh5Դc 5|M~UZ_>,+ͯZ/%}^..-m	tbc<rjx=ޅ+_t/ԚZc;q|BաГ <:̯XxKFyc:R_
~ܺW?>	#I:n{[M7=af7P'"oԭ'_ %ǻO(7.N>^1u-?I:O{[OS-cijxC\㟌V߶m~k?)i:nb	"m!mn-|Sxroj Nf:n|g	|ri ixNoR\]~~9![$ɨjP?{jO
|A0ϋƓa;^<ekQۿP퍬,os{.^H_> Zn\+V|_\kWڎj:ȼE.&yM ji ?O%'OW t ~3 	7Mm;Fּ9xAVQhY]i#RDUꚍ< -E P|`O/xZ''(uVФ<&IMޱi<ى` ?J?fKovQOn]oY|"Y5<cZ~u
=<?,7Z
ޟ&5ǅZ`T:uů P_+%h/&Oď/jxʼm ?e?F5 Z[c-|N/5:MFtm"=.=[F;=]	еktƷ Q'#> 	$v7^i+z-?L4k=SYG۬AI.49-]f<r4 w 敨x/U K]KMդ05$Qs
oHmVH!f ~*~O{L_5N?.4ž%$Dc]cCu) ʲF;;
w1x#7xPmsǖs /6K%M?Jl?Ci k
) xo߄~$~i:ߋ冕7! 2XC6)wvh9y-wXǡ|St^%|*ϋ?}[Tխk.tekvAd&men|n6|)GψzkmWP!_j:'kK;)/d֡Ԥ<6aj~ۨ7ҵKh%H ~:'? f|H.4[+m}GVHFӌoW-[m" _ 5)MO[Bi_uEk
[C<-4IOkjs>$m9tmJ47I
}IcYռ=_ښi&Ԭ_Ll4=B Z+b{K;Xig$H~ /
xǛZmɡ&H,uCF{ok4GHd5k9m漐m(~3q MI"|yO?|K_y~[w#dEyϕ~$x jٟ@χ<_|.5H4ƖCTҭBvq)]]w{ $ e$eៅ ?/|ci#m)iQzʹvp2hG?,ɪ.ok5a:/_oS-ɣXC^i*6ͨ_v6VwwrHE 5g ƿj-<!'w4_kxWþ i
6坔Dߏ2ykO{woÞ*/g/GVĺ`n.}2QYդOwX/ 9  D>B~  ,?3 'm<78e׮!m+e׉emډ>ti@xSPo=SP{kBM'UuV5
#jZ>om=ŭq][^Z]FdpI> )X?d ԏ-}@	2>$~ SU ~C߃>2bt x7'_~KzGt])|C[ni{ևƺ̗PtilO>~>/i4o~
&%#Ю
+I|'gGJE\X/ M|1xZ	s uG xu6Y<*h_:[[ׂ%{K;h[8<w_KIkB :G <?ᔟ
ൻֵ9Bb^g#W':_Knj_?u"񥥷x\'7-%d;[_f*^17 c|
 q ?f5 hW^tcRnճf:_^o4Jkoc/a;Ol2?$.t%<tv1$./t5+Yc	bXDI~~
~~:Ú_~/xfO[{ui$"hXA=6h/葻vx	[) ~y?~2  	-?mW ?~ݷQ; _ O){/WOyj+oí_M6-J{oQCixBu9nhA|zJM~  >b|xοoK<QHʶݟ|Gkkq5°i7770_p~/ yxZ]?i;WOiG%𽎋%mM::<:un%P~=ɦi<!#OtɥuhlmnDڔ̳6m;'ǿ g ®/?s/~ym}.~lo۟ mO>aϳYYkj-qIiwVz'4@WWZt//g t 	B O?A<GyuyE:xrŗ,<?immA}6O=|c 	
Wĺ~(xCI[g"/];K"Ϣ\闢K{Ym&# o%o%2ߠ4x<	a/ d> g^|Ekg=i.os\=7O)9<aOaxOŰM-
jg,n[HIΙ&[ᨉMB9Jݨ_OߴKb-<vbIaU=?k>ie&X}^;׶CkVIʚ?4 Y^#l|1[U幙wCcO}\I<+QkejeğJa d'	k 	qҟnº /__#˗o7ʓfOğ(P5 ?A
i</v[hn#Dnuuo/z f~R|]koG~
x mO|AlZ?ujuA/پͧ/s	md|{)O&\xY#ծRlll|sD QԤk	<;;.[#Aenm <sR|Wg>:o3ox,?WԮ>hz YCvC.\R⿸i L?jOV>&&|ᯆ~&C>xOúZkIxbїUt^DmN%eZ;pÏÚO! w*úVt)#c gkϽIn]md^Iw?/C
:_6vj|o66d֊E"$%N@?>?b ~-|)k3Mk~!7nu{]éٮgK{M;;m
 wj>0~ԟ
 ſ.|Ҽ߇tG5?Fgh6zsz{-Ң%oPnNjᬿF ?' 
; 
Oe_)Xh/g}~O_~_R7燿d? ፿
|z{V>0>wZY~Y9e:X ^	M ,|'__ox$/ښ.'Ԗ ]{$wi.9)e\i 4~0~ԟ;.g #h?9.ZS/dڼ{c-\Z- Qj
|1E|o	|Ԓϫ mm[_-
EѯFŚphxU,g9:3
5kv{ gON7~6:߅;:;
UzEiv_izwΫƕl`6w sd~ٶs!coZ/^Bnk!=^cHSks[JҲ;qsi/~4|{ S|.!_/o2_RM&xSv2kGHFh7"QHO(/k #=C)j#4:t障n58SţMaq=7!iqގ9 Oأ	^:Mg/w;?k"O^Z7v^/gRܙf|WR[~># -,[Ə
'dMM!'6sAkKoouykԞ x)mQ<C?Vk{HUfx Ҵ4<]odOcx{Ʒ7Wh<~)|UO< ߋ<KZxv}:O4
B.`d WhcHX±TğJa d'	k K	 &#oZ2?>h g[Pk[ūOd&sBZqm!%

 5=_w~_/}2ͬxVk!MReN"==94KOhM+
umȅŖ*>Ξl[9oE*?jgOO [~?+i>UMOQֵ]6YoG|W-3=ĒZFDК'uខ؟jѬ縹ÿT<dB<y'I<;$r¿ߏ7⿃	iw&sZ(%gY:G$R5	$'4xG_~:N
ixEuW#wm-☣T|"_|s/)kڷ5֚/9},ͅǕYͩK4^#]44BğBǅ<-6Gt'IPզlᵆ[Y"UViH,+wf =go? k_
 CEῈW6֚v^q}t;R6?%km {uXhhw_-=7|1u:Uӛ6ӢT2wBf{|~/}i?&ch^	~qkK<=[AhCs=͌v^6[kHϟ7_ޑCUkZ<? ?-3Ct=?Dkpm^CdQ n~! ?~hg/$Ac{ jh$ޭ
&]>9oa_`^N.xτ4w:oZ֣Ծ4RDu-N
:ȒM/N~$&KQ33 {<)oi:?3:Lڅ5g
2_M}r7w7SJFfY\1k#>

|AটZN}_T톝tD|- }	 ?|>ghZHѬ5MiW7Ư|wƩ}?˙Y:~! ?ou|}ģ_ ek
 ol-Gx^O%Ѯt
"4c.E$@>?e/oZO9%<Es"]So.ݼmBᵶgy"d
@u'G/>BVfZlNbeΊ֖Oo4hm.#ʕЀzMğJa d'	k  {S<~7>_?i:ƏYwcXO76+G<2:+	m+	B(?> ?
xP_I{/cwj[Rխ/6&p֯cY:|` wgඁKM6\ڥ}jIN lk=Z@gMn/lt @o _w~𕾩3Oxr;7Nׯo|>
r9#4I-o`}WPi F d
c_|!	s!Ʃlվt={&Nt߳{eb~
XZYw/?7? th<7|>s50~!Ҽ{q%k:ޟatu;ewT<@<!P>xv|egNc'z$V&+K[[K.7Ko>$ ^~#Sc;gGe/|k_;Ym$uh5xK:L|f
rU|@ҀN>oh_~>}?C5U4p3.mimgsg"FZk4r^'/Oq 7s{ž/z/<+-oE&'Uᵸ{_LӟOw5x-R@:o	KCxT @о/xVoixJ{]Ǩ.euo4ۻkH#oؿΏ
N[@>aok^	Ҵ]B6d[x	@<sv_HN,iǊ|	
߃4=v@oj=
,S}4]پk˝ _졫*/~~O	Y]W[Z&5%&zOu7N mكş|+  ho - hy?>ͷ-"ʀO7>*)?7 uosW 
ދ?_i"x!F5(q-*3}W#_ů_
u?ڇacկ֭-\u>ڮk^Q3^Xڌi,5C~)o0~ ?x?' VSAO>Wg+OAӣpz	N:W>_P,iuoMRK
_QhXo޳UՒF~~?w?<-7CY7߈kZî`n8DU<Oz|晴Y/"ZLE P_+%hC%*k NOF/~  wzw_>ŦZnO^0A|d7
G
%|2`  x&O<Aj>KuJ-:InL]:}-1N^oxy-݀<Z |>"9>1j 
lRό,ӵ)
֓af\XmIdi߷Nu+ᖡoSßxvN]ռ[e;^[}B].-3EE)=ȵI>4xşۓ t|g5݌K:0#
ľLP)BI] PE PE PE PE P_+%h/&Oď/jxʹKO+zoޡx'/5oOmVQ{;I}:k6Ӯ4_SHW۽ zao>x^ Uо'\`YM}/KiCwp i<Y^z~ |SV'5'Z%mi7Vq}CgPL+%TܸP3DcPl x߉t_z givUZV*vy.碌m`( 
( 
( 
( 
( > )X?d ԏ-}@	5]So5xF_K =wNL
 ViZ_:Rt7;}@ Q@ Q@ Q@ Q@ Q@ q X??ҿ/~k?۷?eO3o?u/+px%O8څA1$izSt]@XUm/v^$iu PE PE PE PE PE WoS9ω:.qkƭy
cmMqssq3,pChI+*31 @g&~1|,3m[&i3/gPּC:H_IO$˥B <)x:~kOuVVZ97xՕXHϏ? e?
xc߰ǝ=~O\ԼCcƢI|Q
z֋
U_-md,g b R?  Jx f %<_ XT3??/ u_A̟~xǿdg ~'~ /g?j<#~V}/8[q b iSoW^  ~?:P/|~|6oݱ 
 Fg S    H 3 ) wT љ Ĕ ; ?b R?  Jx f %<_ XT3??/ uG,_*GIO /#$ Q 
 Fg S    H 3 ) wT љ Ĕ ; ?b R?  Jx f %<_ XT3??/ uG,_*GIO O*F fo>W7$_/- /  `Ӿ?m</ ߅mߊ_&x#_žѭOG|	mrgSҼ<7s]^eI\ulc;B >
( 
K	  ko~q6jN3$/Ioq8[G
Eq0A ?|y  x5k_|u>g5}s[[­$K#qĊ	 W_yOx&Z}M7v:k5͵,I̮
 OE PE P^m	7xSOMޠM_2[Gq,Q"X20F м#xρM^	ִ}[G4nukk{kYct9Q]]YI
( 
( mB`p17ž2<_xWK&SJ/Ka6)f*%R+mHweS,S:pi[7V=ҹ ~6O
7恠}uh-[OV|?oaBx-I%XFq 
 O ?~ܿ|_3T|;^uMGȆKKK&ˆf}vN
Z"!9P+O3ie|%9 y G~$|u mh+/'׽|#O L 0?>޿>b -Ɖh]闑@ZF >
( 
iu A~9> H,z7|U- ?xv!y0Lsmun^|gFU֫+3	&ԣJ%ZUjғS'55/iG,12{+|]{Jܯ~ۗGxCD=߂|{|T>I=	9AUbsn.Z%}Z~şfx?7ri#iWs;in'1He_OğT%,έźUprag5M:<S*%:V#x~+,'iFyd(FNE\|K>.<YVR}GSny%yܼ9,ŉHF ׾~74kΣ?ÿ-^1ֻèJ`D>g<Q]x
w<jb*tV"s(5AW5%I(7!5q9NkBJҭ8	GΔ}{^?kd_vߵ/躟9g]@^-dMWDˉޛ|Zu<0ŜR#F_=*Ӆj3RqiikT֍J2d֍>EX ϸ _?C__E]~ߙ-W_Pb? 5o5?tiz×	\:l-tu4)3}_KY[c(V(m%x}[Ǟǎ|
m?ZN>CwcXƳ[\BʌH ?[_?w_|
 &iڥf45o~qo<Yf&H [8k/'R_? ka/9> 	W<쿵~?f( <oٻ~DO. ύ]&(eҬ&(fXK	a[ QGݟ3x
F6YIFl?y6v$}RV{hC*o<L6,<(RVVQT{5wI_g9d3o:9)Ӎ{mk?
 9'VK8|>>j:q~О:u}3J&$8 g=zsEuKh5$Ҽʽ o ۫<KohѾ~-O}ƺjVk[ HwzQKM3N	sq;
乎UG[
YÖSJ1T:Hʜ[7ӗxx."tc*Rpi+(OxŴե|? Gci߳x3ᇈ/qamf/RyaqiX,򽵟E
e៌ <C\.3πK <?;>Xb_=o˷vY?fYL
O+sRVJӌGNJ*){8Bq[nv8QJbnfZ_~z>,o]:RFeZOv4Mw,hҲC+V' aNo্?fߍ>W~'/W>*оǮC{/^hI;ŨZKgPYl_u qWyV3C*ьNRQE57t'c+rK3axņR:.ͥ{K/ρ<3Wc|
*ڬK,K%q{wsq,W7Kqsq<$a_*TS0QRQI$I-KD2');l(Q@ }kK h=
+ _xρ~( o~ 
qYx᎝Mc}}=Rwom!M#G5XqB7a;Ol2?$.t%<tv1$./t5+Yc	bXDI(MTfj y= t~՚-xSt?Ft
CPs}hWkp[K6dKg + %  |wyi8|Z3M;[ľ (][|qx. ^u{-.H_k.o/m5}7Odem]2fj|5?iO%m/	|B|3Yi5
Rm}\[X]|-lMm񮭤,ukgmHӯm_2l۟ATo_
%Jtyr-|^?Ka)7 
W~
w:TQۙ=xشn\^Zn	^++??jO|(Ӿ*xiR[⮕I<_{xCڦe<}k.unmGV,abiO%`pIϞ1njo]굆k__R唡m蛾hGn!G>knXPoѭxŶ%> m]hKn{^C<ͿF7~JPbSO	zCeyQoHXư*#xI٧b3"/tʌ5v9!ORiEdcaCZdԩJn isAo&W.?d?/|k6o:M/P%ƱbY~NYknԫZ[Fcc  / /iωZů_u}GPuMg ړqqu5Z5Wwr<%ɕ!T@`جQT#*UG0IB1RJ)-:vKץ̯~mܾ&Vw?E bo? i|<u:ǁm|AyM}s1=cMԮ!
jiZt&4u!kKkH-M~bc>*io6l~oaa+a)ɤ]/o
+<3?3P8W_ 7zdV7 <_koS.< W<^?~% b#eWh~S:-k/H?<~7\K4 ڋGt&xOM#֡qjyFE٣cqkڍāl|7w$vzؿmυ:E1i~_u>&|=~ooY[]^~uۭ֏{+*Xm h$fk8J}	⇁~7)e~:_fhnR9!7waX: +hJ[۽Úkޮ bYiZ\I]WR[YZy7wv!*M);$4U?"Oٳ@{_]ſ.濄t$Qx-=kv#bI|K-Z#.c?Qْs|=E/^vѣ`j3P .	_MW:lVm}f]gXZʩ`Es֩I&v> :xO	_/x!k "iZw>0h֋Uv¾Z|OAamuu"i[̷r>i3?'AoH 	ILl4dY蚵߆,t Z籶;+5:y0Ro?v/|~/oguu֍o)yi/ujgf[WG|ď~$ 𾯮[ǥx|7ygP.<Qho5Ͳڽ2kDiu7oS_ ୟj9qӾxW֏`4 E-^ȵ	YèêOYA-S]դv_e~l-<4S4U+8:-ryI'5&\ʹL,~]N]^IIUZI+??1i~<>h'[_נcoOEսY
6O_Sⷉ1|׊wic> YHIľ/nM0O+tt,r&kVH.gYvS9j&+q\[kߙzV7ZjE2RWV۳S+~ߵwwXMQMnVxoJ>#xVHl<&ؤVn/#:Օ5ie# iJ i |C7 15쏴fW|<_.l~:O):/NH{5ω͕HXUYKcڨP ϸ _?C__E]~ߙ-QX|7~ӿUO xwZÿivڜQ6K)=n;'*}_<
 Q?^.𧅼yO>Z}Ɠh7v:m
ŵͼ$NE~)+  ?/ Oj|~ luOًȆK|Urdx28a%c}SZ-v} Ï#&$|GY/<Aj7擨ke_^i2O/u]0ۋ}@~X~ݚ)? 	 sIҾ!eZ5;X6mcYH,d9Φ8/տS` ?_6oz {oz {#;y_qzw-|Wb E	K]:u=U׊;iaԙM2
'foz {*҅k+G*Rn3*QUqMݣݬ{_) k'{টQ~?{K7[I}mFÞoB;ir3HE-ٸ	_?)6ʮ4p-~g.Wɨ[^'/
|I	&x66S$vV퇁.ouk{UwO301~zV?ٿg]gmF/o^<z]SQ_iEOTנюD}x,,-J*T`M+EN-ɮ<eL8S''Rm=^Mr'u 	
{ 1xZFMWSCOֵ;-O#o|q^\h?=cğ4;W/Yxg%inNdm/aw4DK%͵ [B#NRVIh[$$|ԥ)nݾ4x[>O@mVu[(/Hd4cEIdP1B ϸ _?C__E]~ߙ-QX|-Rh 9 ŊR W 	SaEzD C i<I?g_zm)ewҒ
S:4z%ՍWA'{k(Eߴ/'wZzOO"naQKᴆv<Csag|b]G$@?bngǿ
j06
&PL>Wd)KGcKa2Ha",W
5xs/S Xi+}B+8EG$0i1X
q.ǛRu]8'e{|c+f8iݯoz {oz {#[y_qῴ_	|Bӳwv,o>)u5RXC/ʍ-3[4᷍5x+־!xfDgxJ
kQxMV;ΟqW+{X1Gצrŵ&tbZ]45^<TR{)%d}omSʼA~,| ?ƯX8v?.u]҆aj_ȹ}2Kmu]i៉Þ#4 
%|E]닡?=9-:!Kf{*(e]'*.6|N+MyRIrzٝ%ZVU+e
=Zv׼|/'ߍ+?&~
~h?>Y?'3Տ_Y[յ^x^藗rntiu=_ھ?i)ϏWciǀ d8xKJVs3rNRrom-marU#~[8+E-sW|y?Ӷ>_>.A>n쯶_/ϳIF3}ݱp|'Ŀ>)_¯|O.<S >Gى|Ccq?'V7zpX&K-n
M4P@q!Ŀ3[ S.<
 Sj߼?> f o폶nt/y~n j>oA?$a56CQ^W DGG?ǟ</~(\</SvaMV bj_ck{߲c@J? O^_IП_O0~x{߈>&x1[RfN^[%G7wZ_=cDr\.:jR[FtYӃMnpS(=?u|  l|O𝍥"<CqJ.|uWWO-MqJ?8>|Lŏٓ}~(񕏈#>0HOٵ-fo/-occkmX}NoT
qV5&ri5f<U~˃SSQ&ޑWe%/ue?{43q\ҹO: NŶV&J}KݫIqjR­ -+j߳eRN|~}t9>@Ǩk:=ݶiw:ot-.[0|N"+7%ov,v]E
):42[SnvN2ԕo%&oz {' -o>s+=޻Iiqn	}S\R(Q^hҋゥJtiʭVVֽl4|9&`>w	-fiwxkJDn>X7אi֗گ|>y/
xcZw
u<MȢ,JUw;I#*YV	R^ZͮEiks<1y-ԋ~:EyuvOcwǙ { ~;c|=h҄h> x:o4_F|3R^:Qs%eRl}yGݟy_S i;)o [Jt??i.kH|7_'On-uuʐ7ȝ bTP} oj *Al3 V?c ? #O__ ȣ or8 xO $𶕭z'_iqk!%$d !Im59u!y}l.#fLϑ co2>>$.$G}J5 ׶$Tk
"|? ׾~`>_  K xxWk}}/<~a3ѭ3X$o*?cs FH2SPv|eRs,3e=Omf7 ?߃?> zU6!ec◍n5Z]~F5mjvח:݅܋gkҵ]kO~Ru?PV5358ʫ\潮+~^Z>??ne^3 47_3 Sp W|~ , kϏ_+MgZ2x^MuZ~|:q.1%}6sO-[
j\M7[.e{ɮګ?.yZtҜURJ~4.[?~/x "/cq׷G~#x_^:^o#?K,S@g}/ocq(&4_߇z=8/ F%ǉﯙ4-KR_[[\SD{ش;hmo'Lw᜖<qTW.kY|m]);RkO~K}lq ŝᏍWZߊrë ,1%wGK.7I
"j2$61ibG'	|_ E/g N{O|KڟioO
_\z
;Jn> 4]4\KR\ZܬmOxvE?k4xOW?;]Rh5(kSK2 Z>* v)K+x~d M/mWڜ
&+,	U~<-?
xcΟ'EGlᴱlmXmUb8EUEEU  (z(>| 5
~CuO~gAEc? +'Z/ Q Uϒ~/~>ߎρ(>'ׄtK	uRY^yOht .O߰&M Aaj @_;H*.>ImFW{/d2Gϗ w ~{ ?߿^|? ׾~ok3Zkձ[]s!/͆}~Ы懨#4~i#CHIaXM)'+4Zi٣k?/3߅noxe?P}>Rkxq5
vھK[㉬! x_<!#iEY.繞yWIn/'I'Y޼&eR<*~ez]f4kwd$v>t oۧl|//OK¿>6chڕ-pz4w)mqe}gqcr%hgHت)'+y鸴ӳGww4?GDҼ)EfVmAooEc(EDUU oߴ
KWƖ5˝KKnXiz{ҭTG徫wMXg0~ ~ s o߯|>| \ ?7 J~ B?[|OKǚT|_؏
2/7HU߆5{dk>W~@q!Ŀ3[ C?HSooO5xŖ5-3~&$Oi~RQxtXN@-:MV@i_ uݏG_㶗o؛%yw7tkë/[9.d_h2j:4S]6ַ3hg|4?C	h%?oN{]CLЯDW5
$αf{*JoQQiƒ_q>d4ICT>,aH:wRˢO{kkE6՜i_: *V57S>ԟ:4oG6O[+;ut]C-`/ ?^'vܢ괗~\uzRvz]>_ ~zwĿs|17; x{A/,|s)-b六I
F7Hteխ6y| ELidoxvsMLռae-z4${m!pEg {t폔 wǙ { ~;c| ?߷N@8o|; 
oZ  -|~߲ ~?&)T 
kOm}?KH>| \ ?0/ ? # ~|=WRoGG_ (鶻tՕm^3-7Ѵ[ Q@ }kK h=
+ _x?>:/9 f1|s|;/{}+R
k\zwCCc;ʥ"|T|?hSzuς?gߊ7'F> ^zoX--,6Ώv>k=Sr7ڢk{	pQU-+954zZ18yRnTwVv]7n~|8+w#?>'i,Yxu<?k^)e{-lk׆nxyV<Swy	|So?u{ۛ/w~X&KkY/caa41Om8,byVV\"_b7	AwmdZ$ƜnowXҨjQSj
4U;u1/7U*<Ac UkWEK/'ءaXWmïijeI^AyM>nc'Ǐ0oJa=WV=F+vQx~{8u.ZpWn3L
\,u䥭gqNSE[:[t?9/ G/xO<1Z@7	xBڃ:f+
^ S:=!/ _|+ox#ö?k]'H4hm,xQF"UUUo>\<#o7Po@Mw:ׇm5_.:F_[oou-29M <'wC{}mG/ʟ_t^<[j:Gt?Zn^˫E|Ws;MY ?ho?5Fm%hx )[bv]]OTI	;}_5}/XwkUO.kK]6BC5a7ѨͰۈh[|kCo(W0If}WN|/xcwsjxofZw:K!,XYL ߳~ο ~Ϟ	ԯ/	h.uIK4p;GhY(!H# ~ s o߯|W⇁
|,w?>xCAGu/"?L7ws6dl)ˉ$vYk?ğ"^/ߎ i>a=*;>Om-I
,$N4.`͠+~Q@q!Ŀ3[ uZ7Wyվ
|^K;Q-?۟GiciG1`a9uUI@B ¿ 5zχ??45ψ14K/=*I,}wRVfkKU
;{?QSi9hU?8	S#i{5I)krϢ kϊ+ ڗoSEx^?fO ]j?<[q-sV}RO~yizvww3[Wz~w޿
~)S>*M᷇9~|c$~}߉4k\[et[S[}Ƒ9S4%[(eJTiJыZ*Sv-݊NO7Y0!zܖѲmGUvO]|s7{ _,~7|(xG_6y2MaxsERᵟNjl к8c3eI2z}l3 8=%[v^v_󧀿em	ߋ4|b6UՆ[kwņ76*Skjno7-fԯuM_ g_i?g׾U[]/Ew-#Nt}7UnT0Q~S>^2]֏?	aoړ
|@eM]dQUx_~<o
gzՄNjj71n-m-1
+jQ?m/?nwx~~63˛h"/qky6hR I[(ڻůx g{ּ %Dm4Eyuh%JX i˥j:
$H s o߯|>| \ ?0 / ?# ~ ~m_  |񷍵~hhW!x?
ZHG.nuI,Vh[-v
( 3?3P8W_ 7zdV7O+նCƾ:&{ť:JCkmokfOӡDkM;]I	৿~#Sz O	Ge}c\<ayizvt4Wi.Y:wF-5+TN!M8&<Mn^U&+벼d)`pj-4tv[-5GU_ nO	8/ڟ֯'.jw4Nu>jG4ZFֺ~|EiweM棢%#Lk_-yпm ٫</hV~|WĞ׼i{^oo-;m6ӵr7
;F|io>"Kk5eO󥎨85d|WzCf|.C4Wj  ohg?xCM_Ϧj:v{'wIsoWR\' h/_G_'oVO|#_6ҍ-G7myַZ6S[BW)pgSW
ȯ-RFZ,!7.gnUηծ,g_ؓ R/_u g^FF?^{%[]çɩ[I4\E?
x_~<o
gzՄNjj71n-m-1
7|dm.v֩[GUmi>O>aW'Zt[]}O_'  |-g}@/-g2.^_QD5ImR;"꺑RYxGNg&PJ>8~6vvvf3i5:.qmsoR{_<C,m'߱gNZ%ׅhឹxJI-(\YxY iZY,/!Bn?:ڏ$n^z;D9t%ƗamqEmuBд~# ~ s o߯|>| \ ?73o~X]6^:Hqwqwqq4֖veZE56E,$r x7F/]뺆~	<IkxK5֫&a
-s=rw PE gfq/io(o}?(>g)

<U3vx.ƞ<8u9ytzE4b	ˉ
|x_C?eOi^ɦx_]].g3i^_GX@;oHAk^=(.yE_oyR}l.[/R6ब|sM{]{-mo~x_߱WQ/_OOabVl4oO컋~/[Og\
|>?f _ n|W-߈uujlDK4rzcj
+دcxI}
8'Xn]e>tyrI/w]$L٥+WˢRR'
14-'~<]BK@[/:Es?PKEo4#&v=G[-ӿ5 oAcki?y3n "]\;*`*_[\դ-ѭUX'/#n^W쯺n_  z>+h.F فexVt˻VI,#[^l2qƇ g>x{Ʋ'gVh:NwDmrÖ${Y4d}>kh༒KR,B5kС(5ݥy=}՜~U{j;f-W{?xg[+OWلoy^d7_Q ?߿^$ h߀_gwuZU1Ocq%%&X96* ϟ{ O>$վ$;խ g-I_J^p1W>+5:8-+K^l.R&V8ۿK9Ae#Gl5mޙ3Nv W4R4+%k˥5Z~3hcǧQ7?|
|C/X}$x฻kKK;K_2h-mlmx"Y9 >?n  ~O6׭  DoqooV{X\`zOxė '~'~zhVkV_uii`ЍEյ{NQRœAr[ZڪZ  Q@q!Ŀ3[ eoS xW:_~7h<gkV+ƉOOl> OQ~`+~7|k</Chw06&9wgkPccX{Eׯsqc׵6,%JmY*n vku`1Ҕ%mtݟ߿?lo
P?sㆁox^6.-^/ֶSi5KM`)eao ߋ?1 |	+M|D>PŮ:<WTmjAmMx^ߺh*悂Pܶ4U i)r%e;ߕ  n| 6ggxr_ŏx Ļ>/'it{k a^O&A
YP
>0?x<%[x1×^M
Ϫi3HӠ%!h  2FGVY[Zf麊FP{E((%>OXfPYv63Kw)Zjvvvߵ i_hSyiQz~=2[I{N'WiaoCs^Y[zڇRK-;+?x |9
_	5{HR|UK^]
XhpI":εdy?"^ӚɩtܚWggXJ}eArӚm&5> ?߿^|? ׾~o< Gϗ w ~{ڻ4I~  boퟲ'[N_gG3c߷nݸ&?tڃٛ~54ľ)o ? -;K,#Y}+I𷆾47M{kqq%/=~ 5"4 _wt'׎ xO¶ ~,EamUɆ;ْYmwLko< ( (W>#WZiks5宏gwjYd#绞\D5VvU?^!_ S/~x;ImXp֎Mh#v6֒<ȡW֥,d!i{hz+gSF5gFJ/gk/ߡ?Tħ߀ I|]G~ oN}g~'<iګw½[oU~k?
:8:lS/{{hQ{h^G-KutSi҃7s$[}b~+ٻ+ZO|}O|  s?7įj'<k\YN$I,4K.5=NѮUW=s~|AEVIoO3Zuڎq{/ZkzxgIԮt
g8jӋyBzEf.y$i'6룹7߳燮9{C bdS n|s|0I\5gc࿇,g$wX~5;InI/%)~˿\
x
H!|D杯 g֞%e:qm+L{b:0NR䂴z){JQmYy"Z[=v__<#`
 |/ᱢEcb:.|quT:ZjVѥ|A74&MSY
%o?l~)|v<g t^x?ǖkY[j|!jW7֚iZ tmoA}	YHz]e:ԳWK4gu~JR,(\N#V5q]W-L>^3q1_!kϋ4-cþ4.MCLh"ma5Kq}>̟|=ſ'~Y={NΜ[}J,i}u85\$"$?&̰̋S ┡Q]5{&鶚^T^JSlz9-WER[S]mg/w~Ko)/Wx^xKT*sNMB"m%I.bacoҼ:5y4	x'MFR<3M(ea c0s.M.fC?aW9:12][^z
v)/inn}M*"Uu߁tP֋NK<CZOݖ͖F[c?SN~&ӵM×?awDӥAK{펡%ryj&/99Ue5VSqa(-yyuI$nQ\f>ȢM.e/}ݯd E|/g,Dī
Z #ꏤXnn)^PKfKG(a/"x#W% mm.6`~46U$NdiߒvxwQzJ-̮qvi;nlv]˪XZ Gf}xK'm;_xg5dZ/oZ>5KqwOrld+h"{_8B ( ^t>%{  Z/gxѷeYY
TT:9ziF?_Nl)UW_%~|2-#
u۪#l, "+XIW>_Y?:a*Uj}  W4|> wN1/io[#w ӿ<+OO
xK}_u[62Kk&	74?'?
 j~_l.4!cxMͿOGm-o-ܲu^ݪ^VO[FI^"?G/Vߋ>
xoVl/mm|5s>
0Ii=FfMaGԦi-iǟ
 
K_㏊5/mO|?>)xG2H|7IMhZ@oeνYGUo;Jjg8'm8pZ~ KG=O|yg'7^7ǚwߊ5>[[߈W]9|EiN5<j3i-܇)}OT|5V*o6\r]TԠms\^XcQZi-g|[EKE'yr{Jm}nMrhȳh<=wjsk]^׳kg/} ~? 7} ~? __  _ _x2 g +7Vp_X$7H&hGԱVV `@ Glp9BJp4ORN2?9O><3gjIo
S<#6n౏kF6W;[-tw,-cH?Eg w ?~8׃65rUŮm'eksT"gIkh fc<^,=	9'z6㴢ݚF5XX+ҧ.YO_}5fR ?VOH_^$Dvϧtyw/	fw4$]%wp"Yďiw_yOx&Z}M7v:k5͵,I̮
z,v1S?MuNlg|=l5YQ.vkGО1
({ v wQ O __ O ?3,3 g_'i!A,RJ<NPT`=,yk></ÚmRͯ/|[jji,MSgpa6"XZ(URm%-mەһZIE{ajZԧv]VUd 1  N6?঍Mু_G~*^Jl!dhGuVFFV +z U :FfQ5FٗsTe   / %_?G   / %_?G /j<?@e gfW_ ?tw#>wپ<g~?mI;@W-Ju(ӫ-ӺkM]x π? h
x!x.5k]~ӵkhR;{襍&X1(PfAð*'NJtԖ;5Z3s쵡 =B+R#M-lk_'M6( [#Yu{v2Mxq1ѻ_   <IǼZڷowOEed8o9?z=Zwpe/ C/}  _= _x2 g !| ?ʿ#x[W4}svo:o|Ih^+?Z-:f[C
omᴗ}I|gOCg߁&ڷ5kN&B|c}Kak_ig~}w/p}3W?cʖI5m5Zh|oi1xQrrm|`~^,~oo<~(x<-i#P]|6/c/gDb%T9-b5[U~ /n.L˶gL֥Wlmx^I-Lg	qfK^mTRܹi9JVrNPTggou);٨壜txhI+Rn譣}_?w&|U5&++1uI*ˆCq']$qnģh_#f>:l"t$}j&+l-ܿt;g'+Y5VJko.Y$'{1+<'ٻWKe^#>!Z];]KȭN\I#*Z9U\)c IS8ZxNzS٫՚ipBygC{ v wQ O __ sO ?33 g__   2 g .; _6/} ~? a?_   2 g " xo/^|!/쟴e W7V gdy>gwy1;o'|  4ßӟ^6ҍ.: hƤwwdw~z08*u+a)=ی[6
 >oo ss ?o'|  4ßӟ[9 ڟٙo "v^d_~.{Pqyaִ}\ZI#m7#	/} qxꊮ2I+'99;jv۵vgE0pWd| ?{  ?˞ o}__ _   __| ?q?~$OWgu]ei	D66'(n-9)9#G](֩
e85(i5FL
*ir߱y?ً^/+>"uC}YזQ$1yQE)8̾ \ uif<#*IE4h4LzQGokARjaK}Mc2}OcsI:sY(oiZQI'd>6ʰ{<c(F餹w}>e9 g/^gƿ/¿mO_վW;>F{RMh^IUm{s-3Z:Gbߵl{  ?7䙟UE*xTR\wQRkfkM5*J1zYJjzkn~~c
K;;{
VO%0? N! # "~J|Mm?+/skW4ZMӤUd0 $Aϧ>&k 5_z~-3q]Y94)ٮga,hSOWۏo|,cᮻ`/7ω6> 
w2 B *i O  $
o͏]  L>&k 5_z B *_ At 8 @>&k 5_z
o͏]  Lg - i O  $
o͏]  L>&k 5_z B *_ At 8 @>&k 5_z
o͏]  Lg - i O  $
o͏]  L>&k 5_z B *_ At 8 @>&k 5_z
o͏]  Lg - i O  $
o͏]  L>&k 5_z B *_ At 8 @>&k 5_z
o͏]  Lg - i O  $
o͏]  L>&k 5_z B *_ At 8 FE᷈>"22xCg855"ɣ.n<zyA:"/|Ԧ.kIEuoyI&b3OfONtj)Zi[KK[5dooxi# G<O'rMb.n\8:fįи/p(T^qYtWM59ZuZ)MJ/;Ǫl(<
( 
( 
( 
( 
( 
(      
  %   	h         < <         Interesting Fact:  In a 1997 survey conducted by ZD Internet Magazine on annual salaries, the average software engineer (computer programmer) made about $57,668 per year.  That's more than $28 per hour, or about $225 per day. 
       
        & salary.jpg  	@        @    W JFIF  H H   AppleMark
            	
       	
   } !1AQa"q2#BR$3br	
%&'()*456789:CDEFGHIJSTUVWXYZcdefghijstuvwxyz  w !1AQaq"2B	#3Rbr
$4%&'()*56789:CDEFGHIJSTUVWXYZcdefghijstuvwxyz   !    ?   ( ( ( ( ( ( ( ( ( ( ( ( ( ( ( ( ( ( ( ( ( ( (?-6X񇉴'IPaԯ![llmeV,wU @ Q@ Q@ Q@ Q@ Q@T~&hg?^"Fgizw4vwo0M)%Df  9 $ g|K_D2G.+G&/og>ӷyVՍni,e'H6KcJTZ}䢾nM%~[uО{a*xo@ z4ebmcFy~w,-IE2\D֟Q'
'n_o?l[}Yvq5KzF[{
ZŐAVɧK1]=癇bX0ҍ(JOMQ[j`xOOټn!JS\%x4ӹy KK
qxxj<
OP~+{Ctܛ;%J,n~ ړ^OƟG_a7uo k
VY:zZ{)YKfA;2<9	PPqvqk~lMӳ>g9Q^yԕyWv֖h(6@) &PM&XtH-(f	,V#R,ͧ?f?sZ|IP~곬f'w_lqZn"{j
''d "i"X%?>ײr,lj(Suah-$kxc 7v?e
?OumB{..k𶒚}ݿֵ?ZG	f5
B=Ck(<yߑ)F[kI9%~^Q@ Q@hw4 ?!	5.I%w< Ŋ#b<~>+<
;~ |}kM>MZGW-r9"dDeRCMP@>)yx Ǟ%Ѽ
i:γw1YV<77HBCQ#1
I Wp?
3 r>2^I/<%Zj_<gzJ,ƳhڷagH=hV;?6J]֚2l?k.k䚋Mߦ;=z }~|$%~wx~5;NA-cI lShH,"vXo縖ڏm~;~0Z|5߀
 % zǏ.=UUGͭzޓ7^_xMӮMl0tViSTg%dRj/89pJ	Tܣvܚiߪꕕ 3 fW	*?<=q6VZ֕uj4txqh^PX|@ ܚKS tM?_oCZ>Ԯ |Skj5S^qxn7Guv"ߨjz?uL=Z8:.ir-]b֝-)$bGzUpTܔqzwIcv +< l>xk߁__4C𕦡{\l$C5[BKm #Q.cx_Bc?㿳SF(mW{yX#G m~ߍ?+m݂X =<>Vce.:gm5BY4.kX$	/^??ࣿ|	7ė n;Ěɑ-|)<rxZiÞ6=K}y\'$XN)]r=VoA'߳ߊ |#S}3X񭶉m'|GC=j5Esqs{s<3gR\C^UZ+O~oElI->'_kρ>,"Pc{{y5zT|?l|D671[%ҖmBou8uakchU]T}ݴk߮[Z
-5(1
( ?*T6(8~|~ooE&ׯ_eY^M;k"
xs젭޾{[3Gu,c
{&cZ?~<|]hռH 5mȯ|;mà;ȲQii)m*W7|ׯQ{{?M=|-iwSZjF^N!#(6j9;xC7MBoxm^!Z[GqZ)si[.[{)@e~wY6|-im[WxNLt[߰jw?l1
|KE"1 __27 
C & bGE Ǘ? _ N ~
e?[wY+]Ii=I׵i M/G4?OMf-VR)Y!U4QG'){{>!Uk/QW]~GӘy[ޝ  k ?~6E<Tſ>[PtHYGönoe6=n
CZ]CY-5*[!+jߓ+Q&vm{M>gx	h[NٴWIka'WTޯ׎9iT}~+|#}sKgYӭuOguk;YHl^T` b)?_ xG|Y_}kzXɠ|d$ѦIMc
w:u_dop*q~\{SU}N޾Zex4f[܏3 KڿqߴOƏ~߳O':~w|mZ1C-͎e=v4F4p:Ư,jXgPK
/]B
KAte{wƺĺ5+o28pkWڕB[ܬq[$)\YWI% Z}?\ <+Wľǆ5VNp7176xe9"ueuvV)8ӳ^Nw  eO= ,SLa 3ghy|]SºW8Kn4[ǟssx.>YPҼ	i ek 󿴵oxn@.4]:a1Ff-\Dq)ԏF^e}^jRZ\# 1a_#( G @~n>rWS?A7|q쟲lOR{g|y?Ӷ>Pg {t폔wǙ { ~;c 	P  dתx?'Ҧoϑ 
 i1̟ƀ?	?>-
 gm
mK6>^]i<N[Kk[ԵӴ#Urm6C)<'UN=[ޝ  k ?Y>74)ϝ%w8kf"mzK+}ߛӿ߱~`Go^/o#{~.&q{:ލ6yϥb[ųIIKծi{Z/e(Vqm+dI6IY&ɟB< 
05߆!cZxGǈ[4xWFִxǓiv2O}okCnԺ%Ocߏ%k
kȼ/aixO[zmPBGgic$Qtœ	J4'~^ܕveԔc9긫um/~Q_h|o!gᏄ@|{	]{_rkv73X;6&[TI'k{{|ԏ+Ḳx[o꠽K _yQE Gb ~aE}PE ;_V/~
ֿmx{Ķj>>qs$QMV,{vX>!rGb-&+MxycG.+X<  hWd^
[Wq>wǙ { ~;c| ?߷N@;vL xN/e:\	Y#$|GҞpCZE կ{>0o~=fB='LmVuriFosS-ܑZ[Y\yLWSN	RJ1WrvI$-Xri%vϿyğBӾ V+0xEټM.KHu+Ri^kx Jly]sn~!3;XcįjR [Ziԃ*Mn[ߨ't'O,xq/,S_WN*qQzEէzKyE&>&p;)+7~^\c߀ߵ4/|=5-MMi?/ug
:k~O^#s~ %=BYO%iG}%Ejk}n'dLL CXR}N2;5khot<ˇenџ>!&/
uJuτum:[oI鴦Y<>}Xj>;x8u}0T𧅼Ox_}M6:Mk
*QGH ~pJy{St~.Ē~ڌ9\ݯRZm}_X|/x)xKP3!'=#Bɸ K=E>ԥa&>]۲8YL%~{̔	~-w:/p(_+Z˄/ j gWE PKÒ~9iCK/|I2q=牮[G<{ɕc3/Ht^/~t4@'Qy]>&Ȣ8=ş_şZh_G;Go,ݒ(ZIdxTg+Yo_On9kH[rfXxT)$8KVcIX?✃CccF3mE;R)NJ7\E^FUڥ)|' /%'|%
Q7$Zυ縃W
xcw?:{I7-Զwdxӯd|_KCygmTi,CFZTMOSMwãY=ռNR*ajVbTogJ,gT99nap.u['ey37MG7!X.k}+خZ8V ~+iR#n
tps[$ٛ ; N݆Y6߆mM̗gtNtݛٿW*j	P#J*Q;FtԝIU5ZNI(G[+y |.C~9f|U'\Cx'~o[Csq{.kZb￳ )Omwg?OMOƺIeMj^5=_\B(M7Ěr*4%ցJe9Ol~!qQiGhԕ(I֪B2pQ	SJ6cM7̪U2ʊ#ȽqsR~,y$$QF"xǟgOz  3갟	[-Z"x^Χ}Ǩ7ᯣDt?{k:YnTⓜc9yI97ܬIxYI^3$(Ŵ_{zWy?*wO|&~,N7?3O>?@<SK?fo%MI4\1H\Hp@?q\nHW:  3>~ G5 O!ѻ?=:P]ןsy'3_@WVQI&ݗMR(+Z˄/ j gWE P~  j,'P6[MA}jm"IOiegwwOo#۬s</$/οK*/?|!]u}BХEmJnUh%w  y|CkO_㟍Ip_zmGR7,s}Bhi0\Gnu8/H/ٻWRǋj[<16a-7Q6&mu2yr(S'd?/O-'W)AUmF-51R#乖Yba:N)3t۷e(7?I_GnaqڶweoMqssq3,pCh<ʨ H g~گxC|J6x.jt/{fPteԮ浲ӆkg=dd0,>3S%F
&;sZrO59Fi5sQ986oKe?ž 'x_^Mv<5ᛍ
KR4q&{abZLuYH\&
Fߑ  j ?  
7wxgS"eu_Xj+o/l۟YëևXJbW~jWٕ&JQRQ't>enOkeAsAUfW_wᮩ;~~|I   `~˚eK%Ӣu&0svux\4Xu;=>m{Կj ֓L| 
KFi^&msXjZQ[xBKMTi:=:ǆ5-0K4Wť Q.*QPu+׳SH>Z^^U{{YCuT1٤"2撄aGjI|Jq-7+; vs_>
|NXG|5tjX|7l5V>E!z&qg}`Dc|Ta$׼O2Ʃj}5M6fA[~?|sm?ENjƱ^CicF\\L<J쪊@旋ି;H|idRn足{sgnMƦ!VIHͿ-ٷXa/0Z]{%vI'l.#UQA^_{%<3?
Y$k^)Q'5KeM"YQ/6vxżp6]AK7WQF3}xxW
|Nw 	W_;^L^i^[4~T:Yag58gX9rFnѾѩ()5{]v#	,
Ia;)_I^k}Ey0 _xkWp ۟_#( +
E}ǿbCAx1{5]×:XwC}uK9.{-:NMG(NeU'%t[<.&?HSV{'ޞ=W} jK_#fcV?)xPuA<=#TF+F[kV{c45ޙ{p8g0Z8$ִW	'hkY7o7F|{}&~?g 3ڿ2o>+`дүܟ6ӥ"Xܳ[ǹ|SxOkD C!x[nf׉<%
|(Au}P5{YV]M]3?zpyX5άZ09i':NMjk}\7a82Z4h(&)/Dսwo=^?Zm;Ǐ<=+$ީn6x]5	n=gyI/5%ҧSI
+~#xwMCֳcgcC.y3%{+XRP'ٯ˯ʸgH֎|μc[ݺ.
i4]IIsJv?C%K6nuw>~ /Z?~xL񆵥xWLĞ/
Yk\ϴ}iPQk|or|*h?h&
|p wSL<:4]kOմD5kKXbZ\^+*՗<7%f%N-htM<.NҊvl)9;)'>mZG-o/Am! 0vŮ=*woqBn:\zSkP鷾$i9 
_>k&}\-m妛whWɏ:/Ao,2Gs	ne2凜9KXFɤT%i%Va+la/y1Rյhr)^'M9,>#_ i>(xv
x>ቧo,st.Of3K-Rs
Os,vVQ1Wß-ٮB<[Zpx{KU̒Iok*̮V8%e2ufKhvi-e'>MMFvvng$.Q/M ~ .xvy/;&uSMƤl_Y2oO
KCXx:3$Ovn ?4c^* ։bِ<}<є>hߕs2w*e\M8[GK}`Jr_+Z˄/ j gWE P_ʧǟ(ߴmgM9>|!񿁼1xcQ-ǣ=ͅyK]ZH9;ךmӈ2Rcb${uo32f>3-XJ1onk{{^ɻ^ڟj|:Ѽ{-p_xbebXeI`$POC,2/no_ {VjwiOT?ЫS^q{ztjǌ~?
?}>E 	 j}_ٿV76h</n˜#/|C M~|bux[j7/Zuk_lm7IxoVzr#Km5^,a0u>hr˲?{+3*ĸ:rsW%ڲo[ӡx
a/h>~$Yw*]~&(KttKL֬7	$3E(_!K$~/#^E\6?|}u f,|5jOu#zUόce:Vle/)p.||fq^(TXF厪ͤ\?s<E0ن'dUt_^RĶ]Tg-c	[Ǽ3_4/\xFD)sW<1__q,WW7x6;xkLHIìqE}od_xE_i/1eZ1_j/mmgJ2k	R,CZ~bjJ[Qt5BW< <(*5 {$dzoNW}U|B#Pwơ}{\oob5˴fⲵ/դ+Y--w l/KG>/mSҾ|8|bzS
ޛqiX|w1QDajgٔplԩӌbK܂MܬTҺWQ^8yqɶ$fI7es_GǽZ״'G\o<1gܥk!Mkɱl|=xr&>)xռ;wOZ㯀ۏjXjeōbJ}w{mRŚ{F}sj^iO> ?2aiTzKɽl⢮)4$ԧ3sW}? Cl ~e? Zm_3Gtҭ;QԮn#^lVM6|g;+  0r⏃f+i~'ڞFm'WCDg|?մM6LK)#'zi^.nRwmKC^nGw+&/e'o.~ϣĽK|I<_i-k&|I[żv`n? U vC !k"ڟ oeϝ]bu)p~m&="J0H[j㿟_e? ng5
+p
( ?#G/_~a-FI|Ctإ<=GAWl4XuY].8@(e<a(~# >
7;m&B-~zEWpo(
o<LFVRI
 d>mv '_[Faڇ|{:h1qek~:ZK.#zcUˆ(+M+kgq6SKf*uen^i2ZһmY6oGwۡkZxvi5 -xNGiIVPPeya࢟gg? n~&x::{]ZTU;=ŭWڬP: _`.'4̢j1o.KcL,%G&)'k%+_
ۚ;~>,>d? ;7G:H:^dOi}o?ڮo-qe8
4O^R,7׉帞uk SMyt%2	P;kG:Uj`չiErmymݮg"x|=')b]I7~dVr~~_O sZ_#?go__e h^/|#isq*[Ij0^K]L,tՉ9Yd|bªRrnfnK[h-O1J.]Ov/=}{i.z~ >&iWwt?u_/>K5?¾=5wT_ikcq8?>)~ͲX\	eDfGMt㖵ibiu?,ծoq^kU{%46V ePharЄRj.WurQ[G\f+b[o^I]}>]I?~8{xƟ_'?MՕ֟kKi͠\Z\̺φ {-O͒Z8~XFZ>&;>xG+ѯa)C}fwW}Ki/2h gF/.Y5
7R{(.6Z]s_kWckg~C^'?Z >%k>,u{hȶZf6i5$2_gjbA>35<]T=}U5&h!.He)z8(5׫-,mo{->> ||/>T߁4φݟ#6v <+yӄHy7?闂n4j2h
cykᦷ.sx_FVkM;ö6fJ<~/z<J]9KfY>ϊ/<+᛿hw%XJmFCq
]H{kvU]E+wgPV} _ (9 (y d 	W:-UgXF.4;N`k39K+9d ?Gs %?I W/ _¯߷7h<=M[Eh?
Z5
Kc %-sk}&h>i%O; )?졦jj?o^.=Ľf_>0Ѵ醛kv öϥ[ZQX-~e_eD߳6O+◃|?xm4&\/~!]FO7%!7zb,eH<~ IeIMNOggVE Z:yQcJ)M[TM]>i=}ػ&ϟ>w:qc⮃.a|H䐻Gx^*K=%
Ndь"hg4O/ǈ?1S,{SZȺڤx<M3#̟71otgWSRXld҃zZ36EWuԏ+AQ+Sau'7o惼x{_ʿ|_|:GϊWb']$CEiuE7-'h2F{/x⧄uO|OO_?nu.Phk)6Kr.8tVk̭e{hNEiE]׻(itU˒JqwM]5zTy?gc×ӭ_Ohf<vEE{ XN{h[{y"ya|'
	~H~8xw?=*vpi֐cĮ%/g8^+itTYݨ줩۴OEo
QJxI8Kz KzצM~+Vg_'[G\|9wuɸW J|FѬ~ia*GDMOUڗYO|yxu5 |{iuu|/s\]{/Mm6i.l4%󜢞")Mjm+Ee9FrvO!%by]5dwSI)5ǿ,! aCS: ~%k~&6kZbiR b$xt4I/eV[bzQ-*M$I$͙aqhQVym z 
(V} _ (9 ( ି?''/_|jlHNm%Ŗw6k=safL	b4)$ 6R(/ <G_xw񧊼ao\mQoKgH+Qy_6vɬD1[hI/gO+?#Z[Ϧxw=F=ڿ5O__k>:.l#n"OӠ{x^FCV ~ßPi5č>I4u]E]lWڶ!u%!HY0>=H e4߉v??	iŞyrwUq>uOgcSᵿgazτ_>#xZ?>"kwZW_XxoZ6x[FS~!,*MJ܎JKU++}4i#\I Ⱉ2tFjQە'	5SE(ݸ[=3wgVw 7|ho#>"
iƓ?}â~$}A55K$]ͧ|/{ >3|2ۥ]sŏ
Fz_oGퟋ4bVʚI>sØ_m;)J*i[m%)rxIƟQ%*Sx*XLdii".]I+5yIYWD_>~>íCOլu]fe#ִ-LD5Kt6g.WS/Ѿj>&w,|bxg#%ZYO !kX^cir`"vd{i	uaINk?isE)?ԩc%}b**vg}3w}n},~_O s_ _?<_
|G5-V zWԞ\w<A]bkn6Snm/Mok,fcYJB
>/~~?5 6o%.O
x,w:Dl;zq$uH5&C,{v_IajT.U-u%թ)+9(̼|%c)rTv7fұ  ^ivikH ڌ][AoiǤD(tJxnM^(6ğxK.dεصwar!n,#e
Kih4rFhxJk5~IsC3`1X)r)tkXkgi[VQ[_@j. s o9Q_ds Q@|pO7P_B= g7	;}PMQt?iZKC8ƇYK,])ucGU}SKjO59|Sj&<@oyxN
XNԴ[U$i.ukWkH.~!k2xSYSpZ
kXΞ%kOR!ZW%Kh.n_ko*.+/oWč7o+׾-ˬ|8ޝj ؿ{'4{k/rEJm@?*Wே_Z>/|$}@^xGEqz#Cq<pRX(WRxi41J /	xTgjzuW6ex&96WI`H U0oxKmWѧw<W,	{`ݚ2I/y ?<So?h'?b+o6?
.ȁnX"	'G;_ ׁB?uE5xwZeΧ xUG36^ik;
V́o{0,U4הʓu{[1yf/ShSgI|߱g G-xb^#'|ikY'۟M]kN49צIo"MjDk~οZ;~.$vsݤrm&+yV1ɩh[ggIDWj֦ԥ-RU`(9\pompkU%t}k	s)&t泷U%R* F/Ĳa<g,M}*ji~WK1ɪfO}
ҢO|}+-Z-ԥ{o<}qA$1uțVGKmTKخӞ񔥊)bc8Ƽc OQ0nnXW~	*4ZiM ӹ'.^4"okeֵj
4=i
U5Jyb=/`]<N g*M~O>)^ymvĐMFkkr	h90ʲƍTʪʜ*,E8	kyQ\[sEISG蹜m'-I;K]W?h޷{jV7$.Ldd HSa9Ӓ$[4 3qHTI}?ڣ;[m^йwgઅUxPF oF>Q
^(vzMw-U_1V
JgR꼴|?7n>yk6SKiqȮN:ᇭuu5#$|i}6|n*%	Ŧх(Q@ Wz\>?~~.Yό|'0ͬ|3o;xM7X͎-ƥh_5ͥV}6}F>g cxOGƯ?~VZC h|@<1j
՗+ִu/n
wDnO]2W?VWyV־%}*Kῇs|>u+C>4w#9٥3kPʑ̆`S;~_gİ6Ek\jg>+%KouIon//nK?ટ k~03[Nm'4DymVf}6(,OZ^O"Y{$vk^5|6{/ڦ6>4:[%w}wh- m
 &{7xW0]<ib.Gm%ѧ2?[½KO6/o$CW3xAju͸>Ĝ8ZU{М*$#(ɿ.=Q|޿UgG ;ޣ'߆⿀uK\Vcxq40ޟOou$i` bN8*EBKW򻶻K bP*J)7I'{$z_gR ڿ>">_<YW^
ˣKxĄkW~!5hڎ?RŬ쎡uecu9o1W? xa3|3˚xxT%uuIm9ekjgg>apoutDn-sըۙ~?Q xO /z?^\7OiMqOKs[wm,S"\HEsWRt-H;58 JZ4kG8kF[r=	  >g+^$x~7nl<4m|7-icwxz'hwu,iߢ~=h> !6ƉC¶0qFUea"LTFYTlSi^p6ج/-c'JrCTpum?*Ѭ)I+*m k>.{(۳;lg!U/ fYFeTs,<7$ekf>a0T^}i_t
w? ?U/ ~u 7>OqkSἶ<R6e4ddhԐ̬3nh8 'qj_Yþ
+䂊 (_ۏcC-|RA;}{cI״^ZȿԥY;Y,m{t@?$__*D[5__6pOK#]6yo0]_ZE'tqlL[z +
i nx7_ό?a]SW|974w^Z[K&6WrCw
Iq
rYx}1|hO3Ge<Y[ou?_Ftj76Ou$ h/.mkm2 EC[~8KՅ#/W0ѵKMfhHPcMƚZYqҕ_aV+Nի;0PX5l+eF_2j뽟_[o$ҾxO
}zFy|5jW-C]I+%g&$I5ěxWCu ك_k8Ӭ?>k:tmGMMkR[rBR82[ĖH fjxrԅH;GJW'5#
s:TNMErIEk_|5Q~ǿ?_ٷx :lbE݇y/ec%́k{nU/ q6[x*^%쒽fEn^0a4i.dm,KkK6*ߗ g ?;_O;5wyu]Y!튕	)퐳I0ٹpԣZ3zw%%ߪ˶]IE5+] #_ /]_ Q'u
_e Vu3;gnvqhkbJ&gdӳIgNJ3U(KfM|U',o/v&ݼms>r'mKcĺ~n6\#ZO$YHBQ ̳
0S}ͷd$orMՅ1_]'ٶy|F7߆Vii="okQCыq<>aպ<>qU~0SꭺjJ髦9O
[
QJ<UktQ_0PE PE P߷/kثoGm+{ii/ͥǎH˧趲,S4opбɒ;Khg	mi< >5_gx7^ot'{[kSԲGPwKԽ1g[8QRQ]](iڲNGtϨᜧ勨څ7egf&V[g<|'+sxP[7Z |C$qpR+=&ծu	idhA
#QQ6W 
<E<Cc|HtOsGDjWLlVw-O߭-'	bg)"6;yu߫GĹxet')Fo-Uۢ?J?୿)jUj}?S _ G _ }?_N_kۯ[  5~ _7/3뫿qk G I) _@~9ݵX~:PE PE PE PE |nxU?<gm4-RԮVY6!a^k+{{H#{cYQ6rj1Wl ; |IGx i\AwIJ^`^m`[ZAiZK9H%\\7<?_x@sο{:Tד vI5դ3jwX5hH~!YJ:|ukuT~~Ia|.k⹻{n+ W0a'ZMͣi-}.2Wfqt^~٨;N{0޿d`:X*N׫zwwgX\تNt薽>  ) ি@~! 9Ww? ?  W q\ 1
w? ?_q 9~_nooKܼϮůڏ3	% ( ey _vaQ@ Q@ Q@ Q@ W[o/7	w7?ψi
XͨåxAկ9;kDuDPw0,E7VJQQkV45N*Kd' RK>+x	I}86FC<vs:eQvw~¿7wÿ<9|!>/<USjZn-b1%̧dx8tio\H\9Ï'N2-Z&w}tssrQéFէIeSJ+ꏜ>t>?lچio|UVhm]&K9dHVIѤdF
1ʵ_ + N s o_ 	|*_CCگ<ᯉ57,x_*Y6EݱV$[Nu^ʚ
/7NIu>5
<z' /3/ v/'/[ↅ3|oii4:o.hdO2'tmH'?
( 
( 
( 
( 
( 
( Ls?
#\)W{.~~_O dos[ZNc.wW=_ h&w: |ig_ڟ)l}?;w~bn۷z5";IJ{;=z\S?鯏~_PE PE PE PE PE PE PE PE PE PE PE PE PE PE PE PE PE PE PE PE PE PE PE P        ' 
virus.jpg  	@        <     JFIF  H H   AppleMark
            	
       	
   } !1AQa"q2#BR$3br	
%&'()*456789:CDEFGHIJSTUVWXYZcdefghijstuvwxyz  w !1AQaq"2B	#3Rbr
$4%&'()*56789:CDEFGHIJSTUVWXYZcdefghijstuvwxyz   !    ?   ( ( ( ( ( ( ( (K ~?ƙyUyc~Y)#?5X{~[q	TvVVKv۲Kev֭-Gqȸ_,N)S勌TaSaݨNQNrsb77>K״]kJeVwQ$Iʫ${tm8`E_Z)ʜեZ3a`5xԧ)BJQm5utWM*m E o4_#TC/mwS7quܻdPԔ%R1n1ݴW<.&Te*t%gh4gWz"E PE PE PE PE PFxD5nhlnon^8mI$!HXbG
@.1rݤzR*aF
'&QWnMF+I-[HC>#njOZ<Omab<YinjsOmWyddSb`h"|$!xj٬|y wbҧ {Q>ImK#kF!~ז`0<-`2BN&7VMz%Nmp!Ƽ-Xj'01RNZ䌬۝(<FX~oiRS?_<7wTm
ftk*Ǌ5>]=ڼ9j9	c05'\)qe8yRWIEԓZ~OQOե᷃uak_&Ide<Bim+ 1~ҿ?A;]3¾,7.WCx0IKe3J^8%P\enʤn\1QQ^'xo?G
}dëkRJPL^"|SN8S/j+3(( ( ( ( ( a QۣOO|=/JAoևͣ鷑xͳoepqo̬R06@|_MOw=OWD៲xI9MKpW{D.XZ)#r#o͸kOy5.X:nϚɵ}Qxs	xQ朜j:ܰ2i(:oWi~  c |47ړᧃ?]^i~5x]dƷw	kċquzO,`j8YwH Nh
~x+8^F-TS5Z  ҽeܿ;ΤSjMߑhrn<-}87/
5X:;F)4-)JEQ-Oy{g*nP a{~c}-tAfIZ78[VE+:Ue}uk}QZ.{S-Jy1z5y3RoE(Qcgh   3|V~x:⌗W7xl:	cx	̒e9}$p9F*Q&Sri-vJ-9󺴫긙ӂ	U:ۍ8ڊSnVV'PE PE PE PE PE 6_>ƿ'kZ_ %5o
k>.fiETWx}#ʈd2yw 
 <&Zu͵#P&MbaL¼S</09.2JRzVQq-^)JE я37߆|8ҩO1I{𒡍NTRejt	*1\R;u=	OZ<rxS*i$Dًxn"HO#E'O	W}X~<kD5?)Zѣko-Kawnh|JK,[,8VHN-6a-=K&?1opqQ)Ыxޢ_ҨNQjnp}WW "ݿ٧kJվ"n5%ՔnyՄ Lc5|	__'a_KYms2&K&3ڥ-Ǔʫ$9W.qV)IE/M%'f{]_~|w\G上x}*tʥ9s{
NFYJTSB<* Oُ6+SK>u#y%
W~[\Bdb-dS,>cJnu&I-[z$m$/dymĹ!ȰK89ɨB
Sk?h2[;MNS>+o&ow$Ѫ[F+务
5mړ= |HG:.yuۯ^{cRImŵK_1tا">n1x8¨՝̣+k%4rZQK>{
K
XN]9XҪy*NUtV]?
+( ( ( ( (_8$?%kz~ޕk2'䷿Ӓ][P37qU4?% b/߷ŏWc\ߍto
x[0\Kw;wUPto<GNΩ|=p9+%g;ɭ/5g#a#|N#4JMSI֕S-#KQڜ^?,uM+TM1h6pJs
췑ߖ&c<P3Ĭз/ W_|mii]ͧh\Eٍ:H[[޽W2'IcgT<SK&T/8Ԟr\i].Smp-*3α4cK]K{'/.K)ւ]x_*bJe_K[߇>>|`мCZ}e`~\?I<DyB,V/fx4;]ݶ-9+qqK #b)8JV\J0Io)$ݢ)$Os3?M/z\~杺IvS]Zyo1Ί?1Pn\5_|gz RfOܿ4{=ʺ[	XU[5AnEfaiI;_{kRv |/.<È}$֒˕O-aQ˓ߤN8VU#.K7g Se⻭SS[xk=t MJ#m4$LXc}qY7ğZt߲~ݟ
Ί
Fp׳GXC̊*L1HA#5rR\[JTGew	5(.֙qI 3TT9,>*07QRV:d9h5?Dּ5!uOuy LXf@)Ցee E{~-g(94ֻ?~"JfuJYIu$MhZh(c
( 
( 
( 
( >"  k_~@-r TYflI'9fnk	&vS	
xoG|=>!$5}Qm[QmlP(K
!HI<2(}SÏ"GޝW9٫%^^NmZu|S
~`_,EzjQpi{5M;TQN˝ןv7?WWiSxo;Aw[yL8-e{YEdx+rVm}Ky7%ݽm|~w|C޲|b:%gF9=#r__gkF?g$_(Ц֊][kcѼ2;16̱դ.Y8~ ି'o↗|CKy{Z+Ǟ(l蠖aWl&FiaV+#S)8<?$tVn2Q&˖Ua<xYG59үU%.egMsqï?Դ[|di΍{mFٌo%qK9E"e.`Yaz;
՟
4	XGnik\ɨhԤW'֗\$E@[g	?jj֋RzN55HKmTV>9VM̿p#S`iEJa1BWJ.<O {?gߏw}#K>$E( Ě<ı$%8k4Oo<f/[[oko?4|3] ixŞ~x||ɦsʈ2|,6',8%:< 
KKEi\)x7` 0ʶwSӋpMU˙"V~*ž&>>|OCG :ϋlfz}Fc-mQvOt<_ks& M -xKCo/Io-^Y" L-+·ͷ~,`x#N
swZ7JQM+ļu!ȥuK0xXN-T'8R;^G:ޛH,  }fY^/ NϟEG|5?켟;Of?]R?>  5 -|º | k <Z?]R?>  5 - y _ G 7eV/ F/HKnG/|' wڡ ?b R?  Jx x>>$x,OuwE5M/X4H~ x2hVYj[&d͊ ?R<#xρM^	ִ}[G4nukk{kYct9Q]]YI
( 
( 
;?|BxD6:j\HMŕ4DYG"nѕ}(3QsUީY]-Ϯ?VxK/xԡ&Q2rV73Wi55M ?h>Mi߰޻.oOt,!K}m<wwQ7Iϲ]q
|ٿH>aL:ig
S]M*`AG)CNXԭü=01NqorSH=|jg`T<%3^gPYUpQa撔	aMrj2N\1 6k?kSRMYV;klgk."uD;"X|g_Ǌ^15e={JQ91	dHJRFBk岊qҧQ+hS&b?M|;qψ\Z,F
%N3q:N1S:T]s%*Q b~_  ρu_6\V64R{fȩ5r/\'oG"# _46ei#@RxMZLӧyng[-#EjLW"O{+9BO_|ӊ;fE<iI(CUp%uQvi|u+
+,|\/;_|_wI[{-Ltk'&'_2 r?o>	 
GY"m.%\}P7hXf_K(`*u*1ф_3qI&g^WcW3xR9zt)TXg*j<)GsםJ)RK U `_=Q _>4c 7...D̚o]?÷:aim.^II|V\;B9[/j$oЅKg2kTHoRu-&쬮dKv?8gҟ$T#'.XGh*Z.+ 
yjzgZe=q<NENB؉f_0Ǔ{hP5PsLgԼ5W_}>]OW1]/wa{n"g<M߷۟)^q 2 N?ho(X7/쯧|XmmKH61%kR忖G$^F[p~T?~ 1 gs}qw,,4S3MjvIŬJIVV̂ Q 3w7@[~~[j6c:]cyok2ɮXYbYL|÷/ u$Mወu mrv},,ŞV&I% ''O#~>hf/2wY5r˨xZ
0Gp;2ZI<~|v PE PE ~ {ikែ_nn2Fhg)K(^K&-d#NV
ύwZWMzUE[k9b HI%YK,d79.cp4TvGގۯgm[cgÎ. -^SƔQ jfRUiIUZI8FNQNu⽟~=H ogxc4ssFKk[oFygYn `զdQ/ڋ?rooD w>"jzv%<:] Y-#vhWɽ~/0ugWJP{ɷJ3o}UJme?=bN61e050%*~ZNRU#Jq]*V&7
Z嵴[[w~sKu̖9Ywx²Ie=
#m[Xwow}sv{gk%v4vuix_.91Yr-%RhmTvwd߻xy׈ti=c1.njb0U9)¬jJd)wtK ,i׮@m5}0syo4 $;fk.i4 u~m(Ƌ/?43rqA$|Zs3N^мǁ!-Z(Zv'9WS,	ʤGO3JRv̔uѫs|;/<+8>HkԦeZXT	Û[
c΋A>~/x5DҭC}+k)CC:]ō4,wQIn/ "Am[P;wnl9}WE$֚xBU]yG整Xn,kΕW$&hɵmFce V*V4rݹ]MP*qYqUk/]j 4qݝq͢[ke]64iڿk<8|='=M{Oռ[FOѣ"ݾiZiwe H>\֛u+JuʜO^ɥyZֺդ4⿤>p.e2ܮuTh(ci*nNZ.e+sӨF~ƭZP_'O''[Ŀjz?4}?wD8pI|I5o)+fokQa *|'fGŚ?]G'G-
ʹ+l&ue*TSpu>

ijiJ򔜚nuWW&xxq6>Y^+3:8FUYѥAF*0NjU!;+?4~?q|2>&׼=xtmksܤ`$g֭LaQsd*Wk7mF4|a[K/E>mcĲBbF,{7[,IA_G`(~&STZj2In|fI>7q&od97fUYcv-{Z*{)ԩ-c
IM%+z;|?o NG-B-γgc+Z|^k4i~ s>5? g*kMO-G5/36x|Mr,5O-I,qZ1<MN9V1aN1Y=#~MEie kVqpUX5*j$hJ:4RNJi[ LZ] Ǐ$k3Ğw<oi6~oKJm66wq_]Ko8ZhC
 k<7be%}S2UJuM7źxAh^4r2Y^.jJjl[MOC¾4sXyi
ԣNvR.SnpjRMPo>+?)Zo^S=N|[ZZ}22^xY~Mq$~
?koxៈZ<
sOH&h/-.`g2-Օ彿~}AE PE P2{|e"yAq%IID,v\vpII> 0M| gGxK$!]>5۩luX!'y~}aRY8{+oԕKlG	cђCuq^6s8ڬ<]N^t۟\'#g!CH|_ꉥ~U[̹yd- Gؖ6&E < >5ox4Rz̯4g\<.&5!Ƒ>ץ槊em*kr-vފ9af,kn`a949֫A%yO{|Tq_h eٿV_x?ĞQf=OOY6]w#m:$I+d] S=u;g׍u>/}Z=$Vmbn;w(FSI,^81fγ|]U,'4
UWQjKE~?<%;\ׯ֣:9cFb?~FksBq~W_+%O ^;s l # O?h(w;?ÿz f4_H?xTզ.>f(d+\'7AJN_{VZXŸEWbRʕE7	qՇ\ecҫ	FIWo;
WƿO.&ӭ'MWιMkDhye<j#Ox7Q]G>j~ηw,,Y*쵙n#xfQdu"8"Y<~[xP6nI^.Nwn>o/\kɈ(QSi8Q
qVpWN$iMP޿T?C
9
7G|7wuAxRVQ#g&IR	 VnFH-;I>&/  d]/Gi_\,Fyڕy4JHk̿hJzi3,neyi/uE)BQJNM)%S<TLÎ
kVx\43De9VUTcIJt+S*j	A^ :|g k:f57k{
FјRPkn"[iD o' ח_~2zww:r^:r671<x,QX7X>s˕i	qoI7kI%]Q F
8Sjewh0'R#|)iO =/	h:w!p|9Լg1ïXGqkZ̛~׬ZN%tcJmʦYS	rpWiTvhss5H//9x7*H7W~k):J%fx^Ю?Lvxn]s]Z9BWH``Z0-oʯ Y>8Q܊=JVXVxM>Y8/^R٦џϿW'6,+Ė!~FkGHwO:؁om-Faiykqkit͕LMڷ_<EZ.GxKZOĽwEo
s]ƎַmCi^=Q-'mT Q@ Q@h%5xG<=Zca}o׶ҡXf@RXVV 
_o9o.s\]ZguxzYZMc){-+5ݳGh7q)gJ&N[-9? F2L^KxG(%QWjq*:٧R Jڿſh~;	|), *|Ee&-7R2ᣆH#H\oߋwm/X7Mq{W d``m3%,G1K(D)qp$+ӄԧI~󕸧fb}yK</w<&:8Tۣ)RGN|J| OMD|3hޏkwN8-mAP`$Q*  
+IJRݟjկVuMrmMnm[zU G o   ?_( Łe?2H?&m?8G#·!4+CR>Ehtko%Ǚd.nhb60hr\2
JG1Ķ$ ihmm3Vi꿕Y4dq9F#1x:soRq4e(|_t
[W|m|/|>n<}r]z	5]"+/kg,o( of𪦕
 ѭv]:c_PY[8.#	+=VRN
F.xQ\˙^M7ncÌ>yq;	,Վ(³FU!^x5BܪBf] NW[t-[4$ԠVӮkvwlLOxk
5Z^}V?s\͎&_Ix,^TrlH 0\=\ќjUi9TJv"Q׾~*s<fY**`Q818,[3T㉄ҡ&t?l
Xk  dolm%&o۫x]FSҮ4hďg5Zt,q.# _ \?{OU\ūZk^53뺿Mc>ix	'IHk:ݦInu;x-[|	fxe*s>hISJOvQ	m𻎸:cⰸ.\/*"0I11֜c(!GRNүZOկ~+-_ĿY7F%ޝq?<g[֡OWVԢo&]D-a} iτ[H횗yElK4XIsmp°Dl,Ќqkz8ӗBV)KX)U7*OS(_?ˊ>enqlJ2WְiQ12^xRҥZ> ?tۏE}/,	jWI~:|cqjeas+Il=ggkg<6ia; j * dJ+zrB5y97ԻVN3I+%f*3pMJpi5M:Th`TƥJR/ūۓr?|AoE_S#߆l35+7:nu5]3{|!1^iZAl-YCoF|WoxO7]χ)$P^bO%|H]$Umnm 
 ( ( ( +/?OH'3 [v,. G~=?9O?_6_'	jSE5
~>kiluIԴ;U}\k{:XaRI5̯E9G}%egƬjըRziS*st$ޕiBT_5
kSU ݛk3G
(imKCƛ-:Oc5^}gi$?e٩f=Kែ
x⹊O5?Zx5Qme쭧"7+__Nus
K
pԭRVVg8Jrc**kܾ 7$bqI(x.ccJTa4RF(UK1V:nXdH~S_\ں?iuke/e5}G-~swuhʇ"]'_ 5_vԮ|-ߺ%co;4K93D>b}|i*>+J˯W?0yOގsNJӳ|1nϑݯǿڏ?_~!k 's7cd/hfh3VVM2^	Qt׫CJk2nrrnRsRzWG7g8g9V6<z1iB4iG:Pvi1qM^MW W_t}sNImd"SX`k8UUdi4iL^+/QkJzRq'QjQdM4w8'_ {-B};Z-k53m;k#HR(AbcW & U? 'UOѥC=thAFQI$KDE\xQ4ξ"+)ԫ9T7e97)?6??nOl Y#~#~*
~Ծa'O5-[A G Ӽi(I<K?_IDd#Ýo$5լ$
شm=͎W7hK\eTGk@ Q@ Q@ Q@|%F
y 8~+ $|
 mhxS'>ɱw myz}ɸ  xRhO㟅z׈oio]OhWzKuZV;[Z.n?e/[\v;⟅xN h[Y"PҴ(C~5)5#! 8+|UD(J-]Y8tvw93r1˱p΄NT1yj'rUkr$Z(V~|7 xR?|mORX|K=:X4~k{-t=ޕwK]sZx'ඏMk dzg ;?Icskxt=7Kn-Km;YG0W:fMӵ){%qyh*ɼu)JN*-S*F5wjSJ)n-~Y&]I&JnQT	MYMOg	5!ξ W  ;_;xSELOUE=Ŧt9h,S:eqhf|mf8!ٰ\[[com,Cyqke{ t+*.^m'9dp6O\=	RUgY~ߗ:3YK_ꮄ0د??ؓr75-EntY#]v DNzt{amozMيC5ԆO؊X,2c(.Z<UJNUT|EA(F1J1I+-89K\Xujr(tcK/'RQUYʵLUJfZZ*֜SW~xj5e^9VIt	C6>9եx$īr7L[  VON9*K
	zrFZ詂G$MRWXn_ϿW'6,_F]oTdm亼=6A׼{o!I ̶|.ET |~ io?Wƺ<eZx 
˅8HBp Yt Q@ Q@ Q@ W[_''f|~W$(l.<yp>xVO.XҒo2 <"|L?e_6.i?SO%ht[R<'h^IH{K;$p+%-r$w
Ѷ=ev |W5_z'úk}o{kW{ԾaXk=nIߑfmj/SoUi6Ki_p"[Ux9}jZ?ܽN6}ud~Ak5/ٻΉ
|c4 _<q<QxL /ou	n&aY:D"I =6~U-3/G]>y|4|)
phznk
SVlͧ,=Rh"v"ӒByF72%NQ8{(4`ԕ5~"+-cR8AΎRN*4)Is89TRZ~<x _t>Cͪyqv v:܈[[!uv/*/ xh D|hE"<!y{*Xv66)vgGдkd.c&/T*T~JI)NVNM{IJ.M9ho
XLY~SxУ9OSBэEJhSSMATRND࠾?ߴ?o㟃w.7֕ej>Z冝5i~qpzɨK\H&؟&~^ cVk
.om_.&Aom}It$hJ)KRuWRh{Hʯ:E(ANM79kʛ%M~(,.ʫTpx<G+,4儩GNp:1is$Ս8_r+ &R_,gٿXN?m uw?c9옸W;R߲&#ᯈ??3[E_Vmj،f2$fEUIi% 1ms8`?l??75*/kZw߭e{/  A&֭|4O]_Ikٯ̈́дR$V)$[Uk\
~_
j_+4>4v]NkL \Aen[(lcpaO,Nm\⚓W\jI+G͟.Za墄ʢwQvm^ iwE  [Gp\:Q7n5MD'~냤X[?`
( 
( 
( u,#hUމD>,cn֚cQxovūhEWf{os>|p|3_­zA7|Y㯎75i{3𧅢-Yojwv.	Вѫ%y%JN1JsQsMJ}
d*~VsI$ӓ|ThCE8NܿMj<;k G[x5	|kwMoxOCͨ%6rIhhV2&ma 3  |k,uj|UּC߈76޵.%k3@o<WCN.'tyaTII_w]ҵ[z+ꢚV|[ªl+KEfNI-tѶ  f I|m?Ew-u
JxV𖛣Kc|QjCT+k
*i>F4cQt CEO}+NN*1]3IrmVs$ @|F,a7 
l'3,sxCzB0Zb7oHB%~z,8 S~k®1 6 S#$E  6
3Z sĳ^'s%6K"uQKK_di} AM6&W_Y^RKOӣ"i5h,  qQ 5z_"|M4>Y{[ 
]hW03O-Ih򵿍%j:@qa48Aeo""yᯉ 5LQ\6opOfq'ͳ,\L{'W̖/pS[TFi]zs?l?Z'ũ>/?n<;z/^
*8G;YΚZv>0.Ry6r{ i `n3 l gᗱ =Zw=dk%{-5ݬ$=NܯL/0tJ.NNrrP%M%)J  5>'x_o(ۿJ'?^NYCX|'B;e[K(I~8-O >x3Ϋ=NN(mn,xU5c3Q =qLḣVN%1VYylN<Gᩥh2g? x?`?~^%O~5kmc`	tԣx[U5&k7Wzk`
( 
( >; k
Wτ^!Y&ou4]3B̒jY>osmeY\_\2٬+˟|9ﵯړߎ
KEfKc)υ4K}7QKIqy=e4q]|յ+'ʞWjݴN6wnu7GM99ЎOY;tODN_u燼=h^exOIM6+[M6P[X8Q#EUU@  _>5x^8k7Ş
G6qo#W ֵNhυM:V7zՕQ<8
Ӄڽk{]ܵFW9CIrA-,iV-/s$ 8xW?GW4(Rx[<Q'%s}S-u$뺋Cu5M^O~A 3|-?d|SҦ['EuDu|J-SZio7i+3I4	O0U%U&'v̿
~'ϊ/t)|9_¿_Έ-x鶶Nu#T]-%2zag=C qڧ ;17E~ۿQOkhE:$tl즸Zx#,`_4?(]4G񟈴m^
}7.<84-2M_gҭqplI <3 5?~տM6HL	i.u-Q%ռP'U63	~a߅_\?AD L^vuτ8y vk:%͢)2˸%R%@cWپO^<USm&jQ3!Aq5v d{Hcy?foڞ];xoŗ<VrxI8WbS[.#k;-#x5@=3
7 _@$|EY ϶jwfDU\~mԻ]v6_Pڋ!ؾ|"_~6uVOH
֙N;<GX~?  f_ > k
7x[8;7|{m#PխԠx`uR
5omj^{?>k6ZwƝ{:Z _Ѣ."umVFʇsih#<>uԧUWmE6]fg+Zߧpu\N#(a/&wMk]+ B4?	>) =|% f!\}~.u}kH!{ʖk?|
j%~WV3n"߭gu]ϳ/Ա'HNIz_N-P 
( 
_QI5 <3C{%ߋuM]LݍJMv$u،BI-JJ1Wod~b)M'W(Gk]nXyI'h![m3OKM7MӬĢ^~#|G{4oOݭVӴ/6Q^u̩[8s
裒 hׯfqԭ6U'V}^B]C(RNNZ+Y=,3KJN<qq 
^v|Gɛ6yZGUk-D n>O~VxW:~(_
g=x3OGu+[8Y=M&t[#O5]Q/f֧Ҵ8cg'z-*MUnމy3*ԡu}deZٷ ύPmK'/x jVOw/AZHaOiN<h')4[۟v/oٻ~;xP. 7t{ZXeҬ(fi"K*QBk"9~$
qx_|uxkǾ95gWH9}`ek!uX<Mkh+wYl  H 3 ) wT~_Y? u~˞~jo~'/ ߆
cY^{W~,dWKB{vJ֭4_ ^j=z1o{ޫmL3}rK1^xNi!m>go+2	.ZDP mRXXZK{<v0|/xB!tH@o#ʊq^}@P>!п׀dƱ kA1z
=AoxzPi{}-Fe|C~?*n/^ +rjWė./{mDOpvOwuy,+;7WR}?  ??jvM$*> x]3Gi<EcZ5w-l啃DX\6C9R6lOF
q%ZNդnl WRS!*\
q	{:͹ӍhJP=Xߗ5| ߄wKH{=}k#Z_xZHK%E[	 OO_|\_׏|gǀumoZVǋ_^ӯuuiRLJkH%1{Px ᯇ=|w 3NþMO</m 	uv5k/:.nmu`Wo_ n?$"2
VJ_x	qqKZtqW/
% x_9|&
} V{KHjS^Zxjy6̓9
ׇ0R?|Y.7 Q(<
( 
o4/@Aj?_ h om#W$DFH^ZRx-ԯ9WKBo	-UԕvҍjzЯIpjIӺvzoC l >
 ԕq^osǚ?ş|T WAON)ȧsavZnouM{ӎm+FkI.rDqxL"Hܧ+y)5;]t=l_gbq7(7qv H)~ڿG/ئiGVmKqmNGtgضk
֒dQiZ𧅼Ox_}M6:Mk
*QGH {1 O_/~[ṽLώ/῅"y3H֮o,ۈXxmFU@ K|c=; 
@/ߴGø_>^?;F[Dy.t缶u[eUhS|c߁i?u\~C29yϦGmi|At"o	k} iF<_^lg h{kOh_/[E,
o4;H֚dRRFӥKӮ,|c)5|c |q$_} G⿆K:uoú]P[Ķֵ_}{nw{pxf'Hkvluu\ZzG<'z3$p>˨&ov_Qw\<FWOggEm-=+ßoZ8&I.5eE pg%Fkz>VZh< w:vez!}̯qs
WKuo5d sXAi<<7;}S[_
~h>ǈ߇
ޯtvvdh>-kbTK 8<'wO7>$cƏo]RfC
[ZYHe-Vk\I̶^tZ?<w^:杽tKwVKF"-kiVvZ\W"9nی7wr`o) *xW 4xIеO֣k;f.|Ck=jZuPxn-sx| xKQ 3> ?<[i i_3hyq< ^u~AƼIG_3NTRQڳ6ԹRVViFC~.s`('Vo]r{o|Tjb 3=֓S.,&x=ti9"1j'{sqm,6&!pֆObkƯP׳rs{I+kϗ
.{ZmI[u4˅ Q@ Q@~x B>$кf?|<|N<ejuW>mUe[K5=GQ-ch[leؿf?7swGF 3I 
k_zkoҰ2ik:C^hEg}:ǚ)<
w#
[MQh[sg
ͬpKtiYhPb#<xr+OV7ǈvxUM¤P[[Z[Ed|T ?<{|/r!/>%xsJ4>!.27ܒ@?O;߰>	- =>5[Ǟ 7{3_Ҽ'!6Y&Xl4Kb8|iq*y^I4SWz&jjx_<qmFakehVZčK5ޡy4&# _ZɟS_s?מҬ3
#E]~Ǧx{m$~UnI$>?Cqz U' gs}q >'Ɵ)'sᎧ 	x^ii:4CVuMvNР U%g[&-z@5 o( Ş=+/??AĚs71i>2h֧em5ƍwZ\[Z?.~~V97\a_Nm`k-5KMJ-
[˻+um5m̖7DӼsLFU(v|hz8ߙit8qkVfҭR<MVeiQu5MsZ-j'>ioM P/Y&idUHHm3Pz/] hh>-TpI~;7De#3ZHa+z"coJrKym*O`mdUyyY,2O+HݣߏPr
CVZ45Pe	4dSFvTc=4@~ܟQO(㿏~Ϟ&c]>(;Kt3^dK[{ek9	iS@&E	VͽrqtJu&RM]SminWxfTa8{Ihɶҿ,kY BB+R~?	 i;_Ke{a|1g iz%ƣZǈ<;߭՘A܋j Nh '^@Uv
,&	]ɭܦ&޺m~G,V&h+E)Z+Iie%Q](Q@ Q@ Q@pm_ů(V h
<	ÍKZvJXmtIku%0dо7~_ d/ 	h?Z55/Jso_Ic
IbQ-YI00 >1{?lO*wK &<Gvڟ _Z	rtCQ=[̲SjHˡ$qO󗁾 _KWß8[H lg f+O2FO*{w31@`crJ.O( RcI^:8 Rװ _JQ+O ?Z~/
nCwg-{_U"gȻ;d᐀CӦc
1 RoR O?n_۟ w|U}Y|E[-.5IUkQuhv-._
O.rIv1IiK݊>IĹ0~7,akJzB"!j)ErSI%
wrB p~jzokΡM=^T^x`kT&֬,mѬKyksD¿J~-{w9>!:fpu 9
G`mt@\.AuqM~s4\/EW`NW)Oާ(4e+N+LǊ̳)PZ8L\լVB8rS	#9A{XN'?j~dow)s^$77x[_񮳡i_a
rV>%w~-W(IZ /E?g}[5\tKL.Mhkqkrh
	ůLNq.mq\(}\bo*d-PR|ܩNOE<#RF|P<Owv|ަ+g5[yir!\y5o3ſiuy mz
t_|M bj6'̚mݵ5jmKq$
P69V
RPV"]yZ+5_㸋 v&pu:SlLu7ʥ%+{NJiՔ[ R$_K?Z/|6~"s|E^m$_iK"0PH%~~(PE PE PE |%-ou|( 7??'vQ6~ wwM6	`^8^?o 7~8xo
s5ھwSX8LyetA: 5ۏŜc^&v N  n<Sq{o9 ? #]OY?gm  c#  ||~_'*WK_4mk:L۴	mVIfX 9?

?h_wWw߅G#$Z/oWHMft$mel?v:1
|ŭY$)3_jPR+j+hܼo)$:?ſS7&  %5 E=K?\>m%t˽[<:	7,qӷ%ڇ?߉4
k__Lҿco^*žy'q	ԢխC%7qܲ(Ӛm{XQZ[Ti$9(qi7Ju^vQR+i_1xGӾ
 Ëw o߳o]ğ~8Լ8TєfheK |T g5 u&yŧA5TdQ;lnIj*	I/vU!RJMi8Ҕ_k~Ĺ^U4NpI)9sqn2[l~>iG⏌j3ᮡqG
AuVլ_
+O[+N?]]X+KzrCsw8DǗw?;c˰P˰|
4-d۲wzv*xel\nro^-މY%}"c?on]|5/㏉xgU /Zio33[[ņdŧ\[ix^W-گ'&ф+U6,m)GJYH d_5 S 
'ؾ[i j7/߳W&w7jfPE PE PE =?So*7w㟂yJ']wOtVo-B f'M)+5_?N  i?ګ |]r>5 ~˟+}/GvV>H`7tu=bēY\71] s
<-x?e_[j̑!͸$5,꣒~9|[  |/){oMJQqrQk++XΗM7E.2)>%7ɤx:^ <Wgu9lFji;V%RSsW <ߴ/|y~Ϟ:]3žMռ!
2ss*qKk0Z5v7
AIpK~?|=Kw#m} hC_;=WYC[iڄ>%#_ g%?
 P_
>5~W#e s秗+/ʓ`П~':??g?Kq̷~K7K=[ĒK4ƌ  ~ػ
sWF|xT(<\ib9u,vZfkO%285hs&;v\ZNQSI8Kݗ,+=Gc^qqw^*JQ*.5$RUa9G]'	 v?i ؇PI]j~H_h]Z#̷&Ge46I
Oa 4-_
Gl~
L|m¾,_?
<)c>OZ$$U=[B5~B)u1fQ_T\\9P\)ƒj
}1`px3&Ы
jbjZIRzu%	ҞKSQjSk* ;?>2/?׏֑1ǷN~?O|aƱO zaetMGJؠV h%ńk}Em=??σ>gO)
9f縸{˫In.n'yY]
( 
( 
( >^=пqg+Y x_ROM{ccO3V_nЪo71Y g/ ࣿ-wOuLWTF c-.-ً)Vmf '-~Կy?h@xRƏ */oVᾴnզbൊKTm%o4'/[i&SÚ
 zNeiOcsym\C?٭Z_xgJ/wOFӿKkyAb^ojVVOGjIu, I_^)׋uX ZvcmcYI
h{}jݿ?gK6 ,?#Ztv&=3M^x	YkxbHף:;5u}W<	Qq(5	l
h ~: ÏiFOQ<v5'A&|2' O3kƏ_Von|5_k!ٝu[.u峒I5I-%!|#|?]ѼA^~ Y*7uߵAo3j)lY I fs Eo?|qh9k(a}F_Ie62]7p:ե%(&wM=SMh[19SM5f5Ѯo -R&|6u;VvWu?̲fw%ݪƧgdMΝᏂfm7O?ĺg߀wfqw~{tA5y-t뉤ծPe\g6!n܎Ok,CFS Ơ_y򯇼qOU1Ҽ?5n(cn.68s*1 <{Mr ᾥ/K	kom?A{,pVEՍ2Σ]YtPE PE PE PE ~#V?m/`k>+ֶMC^V-HյM3MmB-> M_<Pzg|{~K?
m⏆v'~x?#^1?O4M׊
B(-/_N:dڋ_cqx2ʊj.n~fe	(6rViVZg0zRγ
nTyySN2RIWR{> oĿ|Ś_ۇ5֕sė{o
iPi^UZ^K^,z]ūjIA-Z7 ~۩/_π:A=:5_&l-J
63jW7#<̗i^oxyUq(ӤVW&Z|<W+գO&֩:^Z7ՒQZ~.i;j݈G	OuwL%\uq'oXkto<*HSxsĿMo!߲ KKºcG<9繿4]2fMWW {hh'lKԎ|V[cOn2~Կ#JVeeirxa;s7I^ҍsѫf I4zb|MѾ Ǻ#Z}) -J-6Kmyw)??R/_ ׎jOSD,@o^}1R	gƠͩrVϲ^'gQRsF-^7oKvl&p3&WZپkT?ڷ?j?~*+ Ki/:b"K
_B5?sse=aOo ߃?{(xce )5Bo?c*x;EYu72OmkX_Y{ɪwgwy&MIUR'%8J4Zn2|ܪI6{{
Y2Y
nRpe4\rŤmV=kg ¿|h?c,!ȵXiV5UnM&X0K憊KXßR* wN>5m[|[tMcWø|EcbZsZmEi:}S$0I8>6ʥ\\+9)r̔NvjQR|qpӧ^Χ-bcnWiNMRq\Ks[KT~_?3LSg^>^wsZOR_<5sS]+FVѥ~BP^)4gWW]sRtkNn-Q@ Q@ Q@ Q@gWh-oM^.Ӿk> mk ][VLC7!wQX%<ٮ-%t ~͟ a+4ojvW%Լ}[G3Ѣ01i^-F<0|IG2Ue{[_<yp_edX/Ӧu)$%go_ n?&/-Gߢkڭ 6:ߋ4/jws|XqO+'c_2hfK#{_2/+USJB^e9-;[[mϲͨөORnZ䠞g%{k쏳6~џagz7&F|Ev-ccsu%3e6E,mQ5;+'_?`/|awao5;WҭaxHo%h\AUx`xz*4ɺO=9}R]ԣʓviJgk-s[i=m> ?dߌm?ᗇay/|G5}Z .GmZun|.
h_Wl[
T\ԓOoF}p
8G+ٴqKUoUG5~_k?|9f|}_|do*[kw,l .dS/$ί)I|'?"k }k:`ߴ6=[Owjmޗ^vqrmqvv0װ*8q`߳iF6mrlS U`y믩j1Js+is+-+F~Z 쳠9x>(~wusE?mo,Z5{<'- gv6m2uu,˟/G+Á&޵PiM|ִ٣_&s-7 e\R+7M׭6id>
n](%Ƞ9EI')NnmJ*n5LdሔI+B3~ 2"yR%V6|?o/Mu/|-E%mQ.ySԥ(Qy.knkUdrmvb
( 
( 
( 
((_u	|.~:K7\"=ټwg4Xk7Β=_
j_
?	 m'Ϗg[-7ŏxk9Yf_Aik=\N)#I`xÇq٥L>c?Q<9Monh-%(ٶZ'禫L_7Ɵ-i+ s/ xKSn[-Α#U58k`5WJE{5=kBԴk5-")eҮͮ-h%6WVD*+a_fSŨ(JqqKJ[JMYX8^<w+cFxg'8ŧ4\$&q)4ӳ1_WZ9W7|lk}[[|8uS׵~+$?Z˚J.kUwn~-q;(FV[s=/_8~ԿBz>LjGE+a$_ZELi{{&Ub4}GW	84ת;* m߀] |pPz 7C <SZM
ַ&>wɫY 6-Mo
|k|W㟌 qg{_Wvц(4H+4Gh:~RweV$^s$uJy\1:u/ʡM>nݟLo UR ĝ*5熾*[]omZo%\Aj7Z^;o\>`tm oS<
o/t]>I}&K&5X(#$UTTUP iɰ˲4"-,QUҶ1[>k;VݵK<mZ^ Q@ Q@ Q@ Q@q_;ko?>-{@mSYtxЭơ-p]<1^k

w2j12xj[ڏQռ iPE4 4ѴZůKzI4iMNMLԤIX-Ϻ>L~eMP)M$RQeMMGpZ֧ݹ6ܣHnIZi_~߳چwѼj-͎e/qF4p#HjXTPBI͂ ha/ ~=
S\|7Kϩxxek\ԤUMR;3^ytm<BݿU5#G:ѯc3E495*rױImkY[7\#m;z~ЯRqRo8zi+jծszp/:R[T[]YKQ@ Q@ Q@ Q@ Q@ Q@ Q@
|a i~_4xOGbi$<	/2X6,cfy %!$?_٫7^A۫="PVo5MoTmjDs꺴:2Kuq+Gmikla4DVJj+4rhEXDG
*twʞu}UB ( ( ( ( ( ( ( ( ( (      
  (   	h         (0 <        What is a computer virus?  It's basically a program that is designed to manipulate your data without your permission.  Some viruses are harmless pranks... others are not.  Some viruses can actually ruin your computer's hard drive, taking all of your programs and files with it. 
       
      
  *   	h   
        |          Cube's Response   + billy  	@        q a   JFIF  H H              	
       	
   } !1AQa"q2#BR$3br	
%&'()*456789:CDEFGHIJSTUVWXYZcdefghijstuvwxyz  w !1AQaq"2B	#3Rbr
$4%&'()*56789:CDEFGHIJSTUVWXYZcdefghijstuvwxyz  a q!    ?   
 z?_?
. nO^i^>c޼pue
򵵍M$[
=ծZNod63=CэrwkEul!U  b|c7Yuҵ]6K'-*"&Gӡ+6C,OtuV}W gK<ay]_IIq1x9(}K{먡
Y
GFs_|_8S}M/v?SU+;{fcw9T,+Jk7v3fHhgmo}?8ƺtۏD/?ɼ6?i01<WXV?\GR(P̰"iˣkzw? ͸?ʖ'JEX'r)95]ʮ~Q^E PE P_
'_5O=+
֕6s֩$mjb}Bk7
\iv$xş#D[>^x^!u-T
EO<yq"ڊ 7bG
~~M
8:XiQp}=qrk[>i;M7w⻂s5ie`, I'xi69N47dmv}?_w7%MA{E
b(ʺ?6eI,!{}8]J*$4o8>+j*P ߯X,sJ:'m[IROjN7 X/'aS_/|Cwmh$>qjf_z"+{M:=זlc+2aa9? +ΜeR.Ytk|Q@ Q@ )4ѣ/j$ g `}kS9=_oGǅe'w96oW{oOeO<wZ
z"vO(\A!X$9dR%_7|?'4<Wuys๾xk[Z~}
ͨhz̶dzZƖ7v<0}ڳ?޵uk;r-~nÿ3KGQ%"-)` B|CMj̶mvwc@m(i-X /#~\~߲,[LFtmoP,(b' x^Mӈ9BTZ] g(bhf0kDﭢtC |C b_BӾ-xC^tY.n:nekk-cYnE4'X|0<-Gk+u}/WD2iW3:ڔggwsikM8ɧa%/<ukSiƕ)-owRoIE{gE P޾i_N/_?S)O&]SWڤA.we[Zv_<wcxi.$	Sj).9VT&^oD s h~_<WKíb^Դ[{o-N
>k܂.m%ddn _
Y3xƿ6?5_
^u8OiAjE2Ȧ;"zPT4u}ow?dOyMԧ77,vK2mgf$i ,?i?B*ǿ i>1 o
2\j_j5?
i3xv@tqul0j"Ms a	eh/߳w_X j7~3]KNOL4kf8<;_ZiSN{/抵㊕Ys5w}?kyxkXΈ.{|*t|=ohƩ%,O[[&	 Xmmo=3ܱw5\]Dj}ӫ?R|-_?3?C. ]</'ne<7X</nWR}%pgX[n61G+\9Ru94x?ѦģUt//`5}.SHmHn"y-栣JTl{ٜc*byN6SQW[eE{E PN{2sxoxVT>jZ͏lkiKZƞT4
4
-;{q=}U=9EuLX|]FIK_
xľn_:{4+K>%xrSE{x"i&IcHK30P	 W}1?z׈(~NnE;+O彾_ڋǈ|3ǋ/eeq|BdMB9dlABuRRxX*DY$P?O!l?? awDaltYd#nX*#yZ(s. kt}MtH:WgW/VxoOs>:??1V j}Gپ4^ft{g;x_|^<?~$i9}Xxo[h^f
>okevW$jSHͭ<\0Wq߼֎zm'E{!E P^e	7xWOMޠMO2[Gq,Q"X20F 
 7|  /L>5|$sU5#?.&--.o.e!ڑ;*>Я3Cџk¿%ھ(M>#<ҾxOm-z(xd󭤒ea-Tx O>#~wVPþ5I=Suuo\XjC!X7#+(Tiylˉ;ZKrvRWZjg~>m_L<'j^"E+ۼRI̱n4lFgWXI4%F*N
8|Izÿ~!OXr?jSx-=<3AҵYA.7rD{%&VQ#k~ߵxOV[H{-.e!Yg6PFO C8%A#+
(  ӿf
|A ^-P]iIMռ弎WkkHN/v1vidӤ :o?n?k?*ͧ+^Aik

PYBojO<Yw  t#7f=/Do577 e |Giwn'+ GRxz> ~=cmsWo*/Ətymd}FȭgjU厥-mGmxzi繝qHqdraߝTv[7h&;59={軷k^֫j~_/VUG3խG㶷MsR;\e/mlb@\E4%oO	 E_~ {5)G:3&0ռek>[+;?a^g	 gx+M$uQnW7syh"G0PCQQXNRr{ӣFzPMZ1I/ M|d߷<E>|/C.-:kxEѵ;!moweYw-ZdiV2Zk f?ڗ~+i??f: >%I_nwdZۼ7Qo7XF++ƽ\^+2ep )fZ5Pw\- ~ }? --CN>xCG˪͢ff[hxZH-缌XCc6kj2r1^ W S e?ᒾ~ wiv4j:F^Ht{֙}N(涺dR_P )s S?>-{čj>ԄFhE[ZZ[<wWum{o$WCq:]zn&bhKp	EU3߱goq
gDS5߁>-]񖉯a5;wVtzi8Юeiw [L_ڿG#A֍X}υ2;<Q[ݖya^huKOe_E*sw[_?k
^H	BW"0WkY ,r7g,шi0āa~C>2rFluxύ_&w-u/XOj1-- uw6Y^yy~U{>FյR+]"yuzrʱyīXhJݶ+vt[RgI_~厑{񾕤i:]6Z]᷶V8!4H$UTTUP 1^LR'YGV|3> Z>9 w9?kW~ǖ~[y<M.Z϶I3 ;kh ۯ/ oSOwS៌4
;^Ծqm]ܤsCC4o:* ~q]\|e?B^Ik٧UZkkhGiO>3>99O ׍]&)og&YwX呂rΨ_5S _:)A  ӕOO' $>
(*
G d' 'ǭ~_1 l~8'Mqx [v Ǐ;
CTY]ȓYGatPnGxMyOTPC ~׾o=~_/k>B]*R=b.vTdH%B:d  P )?q C_ko ׈ ʧE~jv?[Q{ #  G
 ֿtE Dq}o2#~( 6u/:hL7Z᳹7,ERonU8o:( ~4x[2uo|7rKȡHn{$viZEP$m  _?9߰?k#~
9T_~CNТ> /B| _|z ȣ _Ȟn7㏠WosI1gb_]W' 	izt74GqeqJ_gRxhbSyB?X؇
LSowiW 3 ~x[Kú]Z[Me` t+wgGoOu7#  u7#  u7#  ?n 'W)M_Í3/xᯉ43O-^dnqDf  }G¿#)1
,JTb%$=Gk5{4G	RԤg_ϜWв	 ȝ^ڗu ~(ξ 9в	 ȇGğRxN^
vxX1}+I4RCi'Y#HYUA$
    g} ; Aټ5p9^*:JUn(cJ矌e8# SR?x k&K
;?)_>8 zm|m.kX665k<J쪊@!PE PE PE PE P        , billy  	P on mouseUp
  checkIt
  answer "Good Job!  Do you want to run it again, or continue?" with "Run again" or "Continue"
  if it is "Continue" then go next card
end mouseUp
         q a   JFIF  H H              	
       	
   } !1AQa"q2#BR$3br	
%&'()*456789:CDEFGHIJSTUVWXYZcdefghijstuvwxyz  w !1AQaq"2B	#3Rbr
$4%&'()*56789:CDEFGHIJSTUVWXYZcdefghijstuvwxyz  a q!    ?   
 z?_?
. nO^i^>c޼pue
򵵍M$[
=ծZNod63=CэrwkEul!U  b|c7Yuҵ]6K'-*"&Gӡ+6C,OtuV}W gK<ay]_IIq1x9(}K{먡
Y
GFs_|_8S}M/v?SU+;{fcw9T,+Jk7v3fHhgmo}?8ƺtۏD/?ɼ6?i01<WXV?\GR(P̰"iˣkzw? ͸?ʖ'JEX'r)95]ʮ~Q^E PE P_
'_5O=+
֕6s֩$mjb}Bk7
\iv$xş#D[>^x^!u-T
EO<yq"ڊ 7bG
~~M
8:XiQp}=qrk[>i;M7w⻂s5ie`, I'xi69N47dmv}?_w7%MA{E
b(ʺ?6eI,!{}8]J*$4o8>+j*P ߯X,sJ:'m[IROjN7 X/'aS_/|Cwmh$>qjf_z"+{M:=זlc+2aa9? +ΜeR.Ytk|Q@ Q@ )4ѣ/j$ g `}kS9=_oGǅe'w96oW{oOeO<wZ
z"vO(\A!X$9dR%_7|?'4<Wuys๾xk[Z~}
ͨhz̶dzZƖ7v<0}ڳ?޵uk;r-~nÿ3KGQ%"-)` B|CMj̶mvwc@m(i-X /#~\~߲,[LFtmoP,(b' x^Mӈ9BTZ] g(bhf0kDﭢtC |C b_BӾ-xC^tY.n:nekk-cYnE4'X|0<-Gk+u}/WD2iW3:ڔggwsikM8ɧa%/<ukSiƕ)-owRoIE{gE P޾i_N/_?S)O&]SWڤA.we[Zv_<wcxi.$	Sj).9VT&^oD s h~_<WKíb^Դ[{o-N
>k܂.m%ddn _
Y3xƿ6?5_
^u8OiAjE2Ȧ;"zPT4u}ow?dOyMԧ77,vK2mgf$i ,?i?B*ǿ i>1 o
2\j_j5?
i3xv@tqul0j"Ms a	eh/߳w_X j7~3]KNOL4kf8<;_ZiSN{/抵㊕Ys5w}?kyxkXΈ.{|*t|=ohƩ%,O[[&	 Xmmo=3ܱw5\]Dj}ӫ?R|-_?3?C. ]</'ne<7X</nWR}%pgX[n61G+\9Ru94x?ѦģUt//`5}.SHmHn"y-栣JTl{ٜc*byN6SQW[eE{E PN{2sxoxVT>jZ͏lkiKZƞT4
4
-;{q=}U=9EuLX|]FIK_
xľn_:{4+K>%xrSE{x"i&IcHK30P	 W}1?z׈(~NnE;+O彾_ڋǈ|3ǋ/eeq|BdMB9dlABuRRxX*DY$P?O!l?? awDaltYd#nX*#yZ(s. kt}MtH:WgW/VxoOs>:??1V j}Gپ4^ft{g;x_|^<?~$i9}Xxo[h^f
>okevW$jSHͭ<\0Wq߼֎zm'E{!E P^e	7xWOMޠMO2[Gq,Q"X20F 
 7|  /L>5|$sU5#?.&--.o.e!ڑ;*>Я3Cџk¿%ھ(M>#<ҾxOm-z(xd󭤒ea-Tx O>#~wVPþ5I=Suuo\XjC!X7#+(Tiylˉ;ZKrvRWZjg~>m_L<'j^"E+ۼRI̱n4lFgWXI4%F*N
8|Izÿ~!OXr?jSx-=<3AҵYA.7rD{%&VQ#k~ߵxOV[H{-.e!Yg6PFO C8%A#+
(  ӿf
|A ^-P]iIMռ弎WkkHN/v1vidӤ :o?n?k?*ͧ+^Aik

PYBojO<Yw  t#7f=/Do577 e |Giwn'+ GRxz> ~=cmsWo*/Ətymd}FȭgjU厥-mGmxzi繝qHqdraߝTv[7h&;59={軷k^֫j~_/VUG3խG㶷MsR;\e/mlb@\E4%oO	 E_~ {5)G:3&0ռek>[+;?a^g	 gx+M$uQnW7syh"G0PCQQXNRr{ӣFzPMZ1I/ M|d߷<E>|/C.-:kxEѵ;!moweYw-ZdiV2Zk f?ڗ~+i??f: >%I_nwdZۼ7Qo7XF++ƽ\^+2ep )fZ5Pw\- ~ }? --CN>xCG˪͢ff[hxZH-缌XCc6kj2r1^ W S e?ᒾ~ wiv4j:F^Ht{֙}N(涺dR_P )s S?>-{čj>ԄFhE[ZZ[<wWum{o$WCq:]zn&bhKp	EU3߱goq
gDS5߁>-]񖉯a5;wVtzi8Юeiw [L_ڿG#A֍X}υ2;<Q[ݖya^huKOe_E*sw[_?k
^H	BW"0WkY ,r7g,шi0āa~C>2rFluxύ_&w-u/XOj1-- uw6Y^yy~U{>FյR+]"yuzrʱyīXhJݶ+vt[RgI_~厑{񾕤i:]6Z]᷶V8!4H$UTTUP 1^LR'YGV|3> Z>9 w9?kW~ǖ~[y<M.Z϶I3 ;kh ۯ/ oSOwS៌4
;^Ծqm]ܤsCC4o:* ~q]\|e?B^Ik٧UZkkhGiO>3>99O ׍]&)og&YwX呂rΨ_5S _:)A  ӕOO' $>
(*
G d' 'ǭ~_1 l~8'Mqx [v Ǐ;
CTY]ȓYGatPnGxMyOTPC ~׾o=~_/k>B]*R=b.vTdH%B:d  P )?q C_ko ׈ ʧE~jv?[Q{ #  G
 ֿtE Dq}o2#~( 6u/:hL7Z᳹7,ERonU8o:( ~4x[2uo|7rKȡHn{$viZEP$m  _?9߰?k#~
9T_~CNТ> /B| _|z ȣ _Ȟn7㏠WosI1gb_]W' 	izt74GqeqJ_gRxhbSyB?X؇
LSowiW 3 ~x[Kú]Z[Me` t+wgGoOu7#  u7#  u7#  ?n 'W)M_Í3/xᯉ43O-^dnqDf  }G¿#)1
,JTb%$=Gk5{4G	RԤg_ϜWв	 ȝ^ڗu ~(ξ 9в	 ȇGğRxN^
vxX1}+I4RCi'Y#HYUA$
    g} ; Aټ5p9^*:JUn(cJ矌e8# SR?x k&K
;?)_>8 zm|m.kX665k<J쪊@!PE PE PE PE P        - billy2.jpg  	@        812  y JFIF  H H   AppleMark
            	
       	
   } !1AQa"q2#BR$3br	
%&'()*456789:CDEFGHIJSTUVWXYZcdefghijstuvwxyz  w !1AQaq"2B	#3Rbr
$4%&'()*56789:CDEFGHIJSTUVWXYZcdefghijstuvwxyz 21!    ?  dOG -\w[tm'XX_Qiֺv[YYoeckmpAx$I ?} ĭ =; ?} ĭ =?Jߎpv E%oi n~Q> Vp 枋÷?g( +~8OG;sx   4\.<G [ z?۟?v?Jߎ ?} ĭ = n~Q> Vp 枏v E%oi]-|o? ?~<~ѷ.#֣Wh_C>*]%ɠo\"jol;GL%4o  BpG; _, 9 os ';, D p u ހT'ø?o`< K 
v ?yø {P1& o=o¡8#|珯
 _TM ÷ o ڐ|"a o8v  @*?0Gx ` D;<` =Ʒ oy÷ _z?P q? /*& \ H>0k 7;` 	#O<}R ¢l|up?i[=E  `?GM[[f3 gh?/mCʌ4d/&O3M)Q@}fcO
jχ[jGڣYk`qOv E%oi n~Q> Vp 枋÷?g( +~8OG;sx   4\.<G [ z?۟?v?Jߎ ?} ĭ = n~Q> Vp 枏v E%oi];sx   4÷?g( +~8OE?۟?<G [ z.a ?} ĭ =|/s ?jOVҾ_?ǽ{ƺI,_i|/ZCorKkg2gCp՞5   5 W HA   5 W @k 7_o  *?] T ƻ  x w  P   5 W @k 7_o  *?] T ƻ  xx+	cǚ}|jռndþ'l5[!'ZnM	KZα} ?} ĭ =|]>>"O|m=+jߴwŭnTm'Qӵmz۫i"	pC~QHG_L7_;}@ Q@ Q@ WƟ ŏV+2o>uwk)xZT)Xŝխnڦ$m}6W G~*. (|{0_?dxgxź6GHu?t65={]g5ܫį2PD}g ȿIxן_:.ku+4-CUX LkH-.VmUnYۨ>|G;~waTڞ#.ۿt2MsÚ嬖l_k+%쬼[2M<O~	k:4~~V>(񎑥\ipsw<o
85ĩs#*c+O-oj!J=:?!kHeUDQK#G
#اÞ,|6 	o"_t xrO hr^d%Ht3& 7~3xGy|Uм
y]:VH.6c.aUc,qi9'>O^ af -?mkOϼkO<lcj9Sc_?_؟l,<OjYZechcW>,3^qqoWUWcjdng{	*࠿[a֕xڍo"Go4]WS]٬u9YLrdG ?GC /춟۟ؿۿg>oy/cؿgogOB?<!xGբ+kVxR%&XERY0`~M (C~ x/>Υמx ]OGm,kUK;gKg	-G|	_-Z7>jƫ
JUm-Ƈsq5h%Ί y' #LK?%  ?  ϶ l& a'͔X,टg~_}WƯ1ݗ<v/# DMW6 w"M?M]2ۮ
t? wxe>S/$֩
ho-nuh&P&gup,갰<sU) Om
/ ?tAXj=Q-o`зk=Iě'0MG~_i]O?<kaa}^k?{uY,CG<2.4خI{gu>8|P/
}C|_//o/4;]rkMBL${-GJԴf-Zvwnn~ ( ( (_+O|h'|-yGW4|1}~w+f%vy#,/~%]C>i>Ml%5ic+WWޯ,NYY4},zE( ( ( (_
l&7M
u?'K'5]3P&>$_.hb7!$H^ g ~^LGm|IwrZNk7jp^=ػ Ӧ̈́VM?<@v@	2>$~ SUm PE PE P_	~Z?S xmXUm׭[I#okG4  U lo	AO/
>ş~0j:g !t+
-Z5^:ۉ $=~Hړ_?MOǿ? eOO|^kk JzV,-/)e;+v<X< ?Ih=?hs\WX]/L
J{OãܫG71	&efdgf ~~)_?f_ƿ?7M߉mm?7|WڽuBK˭hpEuvc0ÿW/~f]7ao XxRè5写s{۶X|9Zƚ7vw0[>,))4  ooڃ? J|L0}#}mJouI'xtUT  5W|
 1k^о#KG⻙k!92
'MkyQyoK3Hcߟ;J`Pcyoz۬{Dɾ:Ngcfi_䶾[KEщ&aK+Ofk_
>+}_	uz?h^Ko}k5on~Gɓo_E ڏd<}
Gg~>l]^_|5?d׺n>jo7ȷtϖ7J v5{හ>=\ֵOj?l5=5MV=.k;M[9Mj-3 / Q v A b '?E??bO}o'w@?dz{ >|PC
{Þ"zv}CmL7VmѢ8M>i]_<{_}?ij*Zj:]Ei_On~j0(!& u 2|{:^]|jŋ[ƾ? ǤDW4;>rw\ݟ5DZ~
81 ~ȟ#Ge;oֱُh)umZ\42}8Cuq>çQ(Pb?b _ o?%__ em/
kW4x+k{G׶{_ qg?+஭1|k?g A&yxj֧m6ay9Ѽ!B.t.v$$WNN' ;g
 O~	WZԼr	4@l·vRtl!d`ƿ|% X_G?j O?@<Gc}n/ |ϲiWOh 
( 
( 
(/%U?PYuyfݿ%li]~Qntv=z)?O&?gOƿԟ|5υj O\^u874qYd Yl
5??~//߲?h)_i61|;Ӿ)xC6Q[Z+_]JKǊh=?ٰ eÌ~?GV:G> ) ր>[ : > D<ok>ֿg/F^CwexcPhX$IQ]YYIǟ~  	 Wd?uY.O%%ןs02'3 G@i_|G io՟o-x4>:|r ={ډE*>~a4Vn c j⎡Pow'tm&dγ=Eu:+xoⲵo
:l K'	 r_?쿳~maKZ0,^gg]jZmO,Ů&y>w U}G_F<MBo~?}V:7vSh--ڶz۵1 xE H~,h\ ڥ?jM/|_wkNͦkwmu4jdd[Y>d_k1+7i *B xsVuo%5K<1xZhdͲRSYb
K>'~տ	+ rMMzW<'5~ӴۭNK+FZ̩+7i *B xsVuo%5K<1xZhdͲRSYbA ?߷o{>!|F|:OA4=N^'^\tҴC/!RUS a K?7c_m~W]?Hx⾱\Fa<55~ɮ?ءtpGď
O#7|" ~$~V?֋~%烵/H.H<7kg.2nw<!S?ߵ'$K 8</c{y[
&N	>b\$fy\( IͿ[_&uc,qp/kqaq{_iZKŔ4R"H 8 N 1?aSo?X?<w߶dkB_q}GQٻbgh q> d ɸ|H  V ({`1  V=]==s\ԝ6pTUT@O4<pm<,P"# ~|L?_-<?/؃?]ᬟHiW\Z:}ͼI@nnF&SOO)=xOC%Ɠ_ǯi"=U?2a{=4jG4WHŝ(k]q?I b۟o_8Y<G*AU>F[i4iJ
.ck$O	Y[D W_w  | @ 'oď#&?  	GO_+ 7~~߲yۣ6|ݓ  ٣߲Ni_׊-xn zlR=[L{F[>uyhl'#{.	y;FgI5G[hf?_/~ V=k[ş65-gY
xo~&Q{(\;Xd\Y-bZ( ( ( ($ V?c ??#K_vE PE PE P_I/E?+G4
( 
( 
( 
( 
(  ?_h :Z(/&Oď/jxʾ)} tjZmi?xrOn]tRXѴ&	\\ד/ <o?x#dѾZrh>Q޳^dK{
:d4K;;~9"fҹ ⯇o	| ~^2wQ^ /bPmJxtLKe4%5qѬ7/7xO֚I^k:vo+H|C]iV6>k$xEi
#2O?)'ݖ /FO:?Gn:l|%IcW173PP[+n];|h#?||
	
=1_[XP_[r,i2:,ȡvcRܩnzM$|%[?i> X p{
CCFw|Kljj~"HՠӟF4YPD'ӮREw/b_H/ៈfScW
jN.<#Ox{X4I ]f-[
磊},z 3Zi߶g~z]Jľ!sMHֵ8(0гܼQ+Ȳ9þn˯V.0 giwwRXhi|KqȡQ@ Q@ Q@ Q@ğJa d'	k ( ( ( K	% ( ey _vE PE PE PE PE @ STE |%  p eOWԿGƏ  ?#~w xCYk6:UڤEbA, ?O#Wi'^4 ~?tcǗS>	CӚjHiGӿouyIc4QGg(
?? 7 Y~ʞ/ ?+"ib	'ZHuml_>/lr 3b C |  ~~ g ؗ
/oA>~l~7{H>%xAi4_Yjm$vr4cjz _օ=Y ㏄|{MBM"W_tn8KY.,%4c	"R~\w#	ٳWjՏ_xVm{$[imI#dyTѺM/N;
 eH Y΀>
( 
( 
( 
( 
(/?OHݴ Q@ Q@ Q@KQO   Q6 ( ( ( ( ++ $??֊ K	 &#oZ2c+_J(j{%~k.Qյ ھX[Y,wv6
pʠfP3χ<=
xw>M&L42+[M.H qD*
 zTW[ lkOG&
?
u8fbZ}j+ouܺ"8 O>0''^xoL'#c_	<? eOy*wɍ[Ȳ,$eZ x }~?J߶G}?O5뚏t+߇V:^'ѭ;VFqZDحI1rwx14+J;OWtUwzvѤmß?e 6?7Ï~)YwAǊ<I2i:L>c47ө=TZԦeO [b q^?b "?dcx_Ǭ
Vo/nK{%Heg~m
aT:?tm~&7?/ ÿ  ~!Xx=sMg1]YՒEY`)Hf#	cHً(k
cU,X:Vm[H!ouK46ɑm Q@ Q@ Q@ Q@ Q@	j_]V<U_ uH> bۻZk<k|?͟ vE P߶;;~|#c[
uRH#<VZl-!B7^ǿ t9 :׏'C?k>sZ by^OIwkfF>/f?37%j~Hs;e^ziЎ{sI7oKw~[%g3CE?ЦPiVxtkS\Akݥ7wMsEc̿9&X+[RNJR<.X`*+6gtwaEhqg	  |!𧄵n4MsG_L׶7wv7Vx%D7Qm PE PE PE PE P>,W_%Ѽ\jھCieX\\L<+*31 _VW?Jxm OuVIn-mU	9"uVFFV (N K	 &#oZ2{)Ox	+ ,a?Va#MZ]JbnU%VU@E*tV #>-|5yWh"е۴h-N4[deR!s@o؛X>xZ QonmN%dpA95}6{  /
hf_x~ 
CPWҒm;,X,aW{7CAE"O  ?Uo&7eqxm^VxOOЬu-'G ;zGOgv^/ b w '4emǺֱGWm,ҵ)/$0ͧxym,
)s*'*M%gw] r_o'׈ c_g _&xc]晦~>eiGvb3^-Ms߷_m~ܟEjixCH񆇯]xWL&/n^]}TaNk,m!7KgGa#V8'+8N]%̭罍9SO#/g ~ E*YzP{G]Øm#{;;
bٖi^IMs[$ϖn>b__kkOwÍBSguY,_{[[
Nᴽ#P8Dx,oo1QoM5w7{O|
<CK/	VZfj4ٌnpwk[xeP9vb
( 
( 
( 
( 
~Z RPѾÖ/6^ObjwiBh7P;|kW5T__5
Y^YwZ֚}ou#ȖZv4[.]]\3}U@ W
	7C#/_M7Ï=Zw۬-/cPm*"yթ4Vn#+̳>9%d费boi@u/ߴ|P ."VZ*^ILVD4fW7G'Ҿ"YכQ|	a)04ihVva&hQe(zn}k
}w2G6VLxPР[fTi#YK"|^#+_~yA3L*4o+Ŧ׮O&w)Mx>o(ηe_ޡ*xv!SN-㷔[1Aki4R4i6XK
>&x'Ok_|[Xx@~qm6;Yhw,oH1Kk?B
RGh?:Σ/מ?5	j||T[{?N<ZI}N[<aljͽCme PE PE PE PE Pɫ?U_'g#jZGĽ>kό:ؽ> MBSF;B{=YuRP S_7 _ e }E |%  p eOWxo¯'_
<ajo
/P:/2dO2'G]VV 	 	GGűk~K4o>Q5VKui#[I,L]Ns  u ;l ĒUt/ x Rfp4{/0~RۏtQ ~В|M_6]eo,S7t.ͣmMN`{. ?f+շIq<9j?.j:]]֙hɫAR{X=JE~$b(f*1Ǒ:1v޿uZۺ7T*Ss	= ώWw @>O}Xxb9W?LU1w-Q=  {~7w;,P՗Ok;f-
ͥ地ѳ<1h3x.~ݧDcٟ1cPEap_jͧwu-5]^LU#K<2C)X  !k?F?k?O}ޥ"ǺǇfK*iFEI.kjNۓb<Ǟ*嶖KBjG?J+c;
eoů g? k {ڕ}2O z^1knoɞ(^9#7&__ m__ړ ំ:$\+Ie۵][Nlr?tmR6-LV tfڬ ǟ?% = ,{ ̻; Z  = , -'1 If ah {C Y> ww 0 oN /'1 If aihK7 . _?hK7'~I yC Y> 9; ZB  o ] -ǿ?%	 yC Y> 9; Z_c˿c 	߁~ oN| ?P>:oZ?|h^l<G>e*JA~~΃7
|
 f :Ƨ'_|g\꺿cH-u?٠+o
$j( 	Gڠw~PόI6[G2D>"A,A%-rPK<7WTq
k??:'=B^vw]tLГ׹==3\%
2I8
=P?Ϯ>i&In~'EʤJ]$ k><po%ӟOR BAk6gI۬2C;mX$o_(|~`8xa$$,;$Au"˱mv"zStZ߾GxRՕ5wӕO3xS]|1 L6y=ꖓ]Ph.-$"oee*@9 : j~ ߲.,f[B<,wkkjVʄ,zQﮔЋxyC<\tf~#ҡxo?+O8>||D 퇊~xOm3\$c
%ՕЬM4E:I:> ~s῀_q26>x[ѐ~}kJ50
z,kVQ~~5  _ڃߴ??x+ᯄuҾB5e6q[jx=2{{ԁYZp'MI?i'ǿj߳YOx&[ƍwڵǆ=G=>q@pF('$,O*?I/  C 6 %wth=  C 6 %wt  ћ| Ēw ;?f  $] '$ѠXT?3o^. wI 
 Fm K4'$ 
 Fm K  ћ| Ēw ;_XT?3o^. wF?bP ; Ix !wSmyk_|&V?ω:M![il.|)fxRk_g7O/S_ԼY\]jzx\Ԧ3jZq^LU&ˊ)/jx2>> d ɸ|H  V Gf ۟^tzjI7qyV~,snc;k*;F|MQG4;oc?,v^
|nnoo5❶OipEi煴"+ew_M[&[ 4W Mҿd_?a~_uxFjr]ڝ\}͙լ|..GJ. |_ ܞ}UI7L4Ynnk෷ M,:FYN}
Z4Wvu~? SിG~_^k_|RZNg,/tUK.a3Dmy&<`9V*㪬='ﲷV+ '	 ?|J_࿊.Y"$Tl!KIb{f 9gg(Ӿx
rO|=g/iz (=ZnfV[A1y7Hb^6̨є]ԓniumD??!׋~|2_?|K4
;Q _EIN}Xo~3IbP^b|h~1ğ~;x˼5;GzXu2s0ogkɭt~3I4X>X:>>/uQcya줷_zݽm{VM'KcoZkOSυ	WP;SZOό5c)-Jh7#F
( 
( 
( 
( 
( ӥ'9\Ѽ1
S.yi]]SH#x!Vi^GTHY*$
1][.LΤa9\W`xWK]O*5}WSΣiAciz̷ڝķ]IXR.u+$>h d7DW!  恥||4WBt4?fVG$P}>)\Y]8GUjR{5{/Êx_y|\(SQ+vWCc[ @?h_ۇo;^Ӽ?JG]/U}J<?wo_k%no5+մK˨ek3S<E(T IЬukhm>%4ެ:L׺S=xaN#
iǡ^u_t]C9 \'k~xȏ▉mm2mףVͶ[u%~
 b~7 ڣ']n{oZxz^tN&4fj&cG-p$^e*rhi^:+#Wjr+X￮I [ǋ hؔ<m/ƞd<⛍c99T3T<EY[o.6~WNNP{EP֥@> ؿG I52vAy/-VVW:}5(4(]uП'^O/uMgtYTIIw4{w1ڦYkm縈>/|A~*~64IKx_J3LMSUgS:%JF*
( 
( 
( 
( িn
 |	 թ  K	 &#oZ2h ??e~ WǺh M{FXGCgxd^*uDE<:#xboT#K
=xOO&/_d.-.mn=K[
/J㷺s3@]WKueB8|ujqz^ }ߩxM_ǟ>%!P,u]f\\WL_Y\
MqePzڇekz׌}/
YgsJ륽w^;jO^yEp nAx6/oVݴ]}P9ğ	L 0>?	~=x*/j: Z-4k+-cZ\Gi3-%dڭM? S~ gߎĿ~4|_j:avcY\jp5.&Ie%(Wex:8387|<G|G?ܛOA+x~o< j gSv<Yɻ߂_IO&o  Ǆo)'|io?<R"y")xKR)P'P%GmD~Q@ Q@ Q@ Q@ Q@ Q@s7?jwk/|+eO.tmNUTw,R'&>	{ #>F4_ۇڼ]mO,D[y-ZBd7pi6׉1[8嚿+XՊSi]mnJ>|mtz
6ÿ|(/7m$KuiMik{iuŭݥͤf+M}gycWOC%m6:On9s6.iZ-7~)IRπ>*·35#⾳**[nzi"95ÿWğ >:&_M%=nk߇|Ejb<0[Iujm
idiƧK^> &o"Oȷkm4>/neܭyo\LFOGx5k_ϯ܎ |3x;z]Z}7S5+X5+9hgUd)#xJ$W7σ~|+&igt
*L3%ľU$Qoi%rnyIlRJڣ
3
A7MžxS5K>I	gy?Fԙdakh&E3jyf;}|Iٟ g_G}k >>ͭ>i˫Mg5ż:^ƹYИot&xS>$߳ /7U<u2xO^hL>u-gł P4ٵjI%W j~Z'Q'м'Au|y
Z!__B!Lip}E PE PE PE P_	M> ~ Sm'MG<e_vE ~<e???k ~ 7o[~?7ܷ/?#sTӭuM.iʂ)c|f7_bokZoOyI "4Nf6&w@\'I#GEJOBfg ?g_
~#  CKL㭆4	5141beOYn/T\Ic=F_X5*'>Ug$_S\cfWh~MjfiO gi~$]/?yDԳqW>]SQ%淣ͩihkvtj߷  o߳ > =
hz!3;<idy&WyYfI\/jRm5ewc\( ( ( ( ( ( U0|Y<K\0K 0ƙiiRŬAYhp-w
u7?_ٷ~ޏx7گ n>.; rTYjQ,Ϧs<C<K]u~0(?k{U  ׎>4x+Z>%|' xR_xǆu"Em=&veM6Dl9 u>;#ӽ+B|5>4۾	Og[i_|IKic?]%<Gvŵo;x-,9%T#)NH$1iIGQe:qmgfkߩ!`w[o\A~ ?jg~ok |]utCskvVx-i
bh?auq]
q;Ihpf,/([{kZ g[W G񼷩kc{ψ[ZWwz֗4f{;kk;,l`>eb~2 | <gj*.և.m>5΅!kh4324_Q%NSzS  ?|{kEK&FuoxBMiẐL0G[&g=?~/%zg׋<IiN,Ze׉-um';MoŜjAmo6.⾚ >|.%M~y|=}J4 >i.g--8b&Yj
JrI( ( ( ( +/)/jx2>> d ɸ|H  V (cO 	|N+@]3M+Lϻx̚hM7I* 0 >?_~xKUkw|{xgnm!=\]ïZgMFwYӓQ&fdWA_?UYfKw4
,uMKS
,TR\f]JpGnnm廁^
D(wi;t]_ݩ-\ _t[lϏ~.񙬴a<C1Ö3A5ԓiL0[ׁ9o<QRQJ+S 
( 
( 
( 
( 
( 
 ``&GfW|mh#<WnDT63+[OMgo4Nm x=5W-ᣈt/RD
l؏gd2?/
ͱ *hzF"O\js_EzKf.?jh)WSnz.ڳj:h788 W  ??_nS~\W-wMD[0miLTܜ&}:3G`4k&sOU9|(>ƻz-_Gw_]K1GPHUc)fxट&I9\})ׅ(5gcqT5ZI[F*$ǽ!_X,S <K_߀|E/x+@i{iIyuIcke ۥD.dh$tQE 4/S9s濳~[?U r)1i5zO(Hƣ<Qkj'U}IKmw#->T+>( ( ( ( ( +/)/jx2>> d ɸ|H  V (Sѭ~/|w L|!}'>wW> <M?Gmk;K	Gzƕo}uwe/>%~_?h
l 6Ƕ7ϟwM{x_QE~ɪE8u noa,%rbhᱴ焪ӵI>w:$k{;_s! ~?s6^/?;M>_ſ)Z>3Ōm2m+za8|#WUЬFfw&~  ?<aU^^K=6vvЂ\][[F<PN4D*|/ b/_5|=/7$kIb	SڥG=j:L.av8{
L[KW?ʫ#N( ( ( ( ( ( I 8L }C~/noͭRykfx-n7mGLUMFV[ˊO_ k ~3|I]+U0K^(o5]SPa^]71DH@KXk,gƿHo5݆c_[Hl⻱l<3xn-mVxe7ԫ2 _Ǔ.hoRMO~emßY⏏O<1?֖V-/x=SPx[-yf-kGM?	McŒ7tl<C_M4_xd\g[zWRv.!"tvY.w0TfW=oJU{l>.aZԪ;|o̖at' j|Ox3~!񏌵'EڞWqZiv7V8a4wyb@ʊSӜ%>m&|rvX 
 >^6xOԼ!XGѬ5]sXDe'2j85/Au|)o ./,.,5B_]jZm/&x-I..Fȯ|QʰsTG9&-Iپ7PNy3G~)1xP|mi7Z_i7,6H$r+#*@#z *^ 7xPg"KC}#j𸹋E

5^U[_;A24{+E PE PE PE PE P_	M> ~ Sm'MG<e_v_ O jhe'7?h{K7S隃xjA5eݲ>Gd?$Tnfr"-4*vI]Ο'쌿oj>2<Ok#^knMRVk4O1
SΖy$_>>0 F/_I Z ^ G⍯.+JMK_3_jzM4mk
/$3Ek?VVICnt^Iig]5sF'QN8nZ{;w?_	)~>:w_O|T}g¾.𕾡лZ\}x`
]\  l(Z l5؃!oML#c5/];k0ZB]B_rc9E~?_'~׽ XSG_U_: f/N-|?}VugueV|$yC7r~y)Rߝ
AE{&aE PE PE PE PE PE   &G_/OZsP$TB&4-se$[ Ke?jڇǟ%H4Znvv|0[G/Ļ͹٘  e Y|x ;Z?vᪿ'H/~ "<~43rtai:Mϓeygٷ#,F5i[gI3?<d|n.I9  ]W? |K|+4=BVޭKŞ#{$YRCm&18d[iZդ.m1gBxFJϖ (I_^.U*MrΤ&q㩯gؿ# /	W2Z?\OYWo'q9 ~;OZoxoH[yAq	t	 u~ǫ^ZNn"f-q5 I4PE PE PE PE PE M?<@v@	2>$~ SUm  |lo^EVtWxnn)<>;AsiF-9|u\O<>#[1^\KD?JNI=35 o%l?k/'_
 >Ηuo|nxl]|
h>z4~bra'R7vi[6G
s  c߷ߍ|G<c_دq|>){+>{y{J-%f9.ma)a .'>35 # +Z aѭ|bnW1˨)QZ]d9l*>kt}~kY?wџ_ #PA_j^⦚/&Nu;K
XOak-W!z 6-#:wD ncMiwY%)Xס-~/oS*PE PE PE PE PE P_ ܞ8 
bM^ ]Hռ5p-_ZڤBi/6i:i;MA`5[* +3/Eǟ/:I'T(>W<G JӀ?䤣 '>',	hS?c>6E-mXo&oYm!e	HFVFEe k?\jW#3Bƾ"6^'llEM6]'C>ay<+<b&(I1'u PE PE PE PE P_	M> ~ Sm'MG<e_v~?<-7?hi߂
gŮ2\VS\GlIo3GjƥuS?ݿП?`_&wC
mbW{$tG
Md~EWɋ8jCOI%㊱ryN)~/L䢿0?<__<1g௎?<1?[&X#%K{eXCEA7	7ׁ<K|/o"ox?Ouʓ/m{m0/Ge=8lQX|DJOqY;0gQ8F.*OM;w>[P~џ	_^& hd<Ax _x?
x|Qx2xji-l6L77pgifI ǌ~/k _/E+u)|DMyp|,弫Y|E~ͪZXa}u<ڮT8:*t:$GףSqf_R
nI-'f-5U|$_
~|i_ i3񎁧xúٮ-tB;9h|fcG]eV
( 
( 
( 
( 
( 
 ?b~ j%^ Զ\^Koc?l4EeiO&P@we ( e\ {µ^ 7Wp ґӄ2ם W1  Ǘ  Wp?$ -O h/"wxO!վx~	$}JO$viZEP$W ( ( ( ( +/)/jx2>> d ɸ|H  V 7
ul M/{&AOO[8|G4+-uMRϔ1ylG<>xw_o'y}q?cK>$2^Oeg<IO+G
dDRĐ0_sAuY/?6
wY/-n(?4
( ڋQ_	<#1*:uⷊ#IGuoj֗]<^$ILo fY%K`1hnKZiw[u?w[(垷|ѷJҷK
+=
( 
( 
( 
( 
(N߷Kzuk: i/}-R	{iTHWhfy#HE  (;	eι k@ n 8O/yW~P_(3a lt7<%|Ĵ??$ %9 'x7 ڄ	uj~%ca}{Ἱܷaal_
( 
( 
( 
( 
( িn
 |	 թ  Mfߌ?[ž ^>y/}T^NtOIOPo1ѧ:l<da#OhK7'~@qW	#G/
RZ։8[mtmNXf-fl^6th_	O CQ5rc(KY{_KGfm(OCY{Ӎْ  IE ?  IE ? 7OS <7? *U  ? ?X  ' ß * a  IE ?  IE ?d
  7? *U 1 |>Ə(_ -%iƏ1\JdR2"G4W2KG,N"g&Ofo> ~і
)`OJ?m3mRUmA
fX!("	QX</Żzz~WʩJ$[\zݏc = , -ǟ?%ϑ_??hK7'~G1 If ai |} sw 0~ oN  oN c 	ρ |} ww 0 oN _??hK7'>G1 If ah1 If ah < , -?_??hK7'~G1 If ai |} sw 0~ oN  oN c 	ρ |} ww 0 oN _ Ng__>
x_Z/?c-t s˛[y?w*UO /?} §P  / _?Sg / _?Sg  /_> Sgk	 ? |[=~Ϟ2gŷ^4񖡦ޥ͖b6VDzlcfU3|
e%ӼZOGuk.IR<OѿG,{I/G#?_¾?!B[  +:>W?  K;c =e ) 3ȿo
>W?  K X (VG|B/íWGQտכ fA~^7ɻ~WoNUca*sjpkUnHR<+?*|! | O?9?
? ?ዿo?>5 _ ig}_דVoϻjm	 = , -	 yC Y> 9; Z_c˿/ǿ?% < , -!hK7 . c 	߁ < , -/1 Ife߁1 If ai??hK7'>@__c˿ |} ww 0A!??hK7'>K {C Y> ww 0A {C Y> ;; ZOc 	ρ |} 2ah = , -?_Oc 	ρ_~xPߋ8,>GQ*K<ω<4O	廬×n~Q@	2>$~ SUm PE PE PE PE PE PE PE PE PE PE PE PE PE PE PE PE P_	M> ~ Sm'MG<e_vE PE PE ߴ'^O/uMgtYTIIw4{w1ڦYkm縈
~_:_:jU_߶/<KohVoKamwS[9+7v)2"iê??_g|! >w  \ 4>    \ 4>  w.:	s H wG:	s H wEp%#C%#C}ê??_g|! >ê??_g|! >]  \ 4>    \ 4>  w.:	s H wG:	s H wEp%#C%#C}ê??_g|! >ê??_g|! >]?M;a{ Ek]@[EyjT]/`yQ%XEq|f
K: _ y<W⏉u?i)ku!>
^{>-eImA=C{3V(?=u=\]7pdud,M$3[J4E,2ƒF辏HAE PE PE P 
i
>F?Q'-RTQ}|ii=jL!-[+O'?ۓU & ?hK_x3C|{{ͧ{\G"k}R++u]#3<G [ z7|*8~>>|k< M3 o `Ǩj0x|iOa7m{eh\<G [ z7|+8~͞>>|l  
7@fȶ$ I3v*ϡ?۟?~_'??w ƿaݳ}CJ I	muFK7b?jb h/  ko#??ng$b  П?JߎҸ^ ?} ĭ =?JߎӸ];sx   4÷?g( +~8OE! ᠾ> L Oih d}?s??+g_B÷?g( +~8OJ{;sx   4 `CW A|}  #_?w? ~~VϞW`O/7?i?ٯO%o. 
7@ lƟsx\"\{*c?_~;dϊ>/$7xV&Ӭʹ# ٳMgZOG _J؝NIo+-o͔zxaҳo2[kg^[מw 5 po eOOP#(/&Oď/jxʾ ( ( +/_PgOtT[VQ${?Sx],5+dc񯈬@O*gWğO	x@~ eM>!ЬK Kv_v}fj 眗"7.G /=?dCߏ,|kS\_k-zjBlOC,<010+y  8K?ko >%~'F
uMSfcsj6նWmh.եw&}ש~	 t ߷o_|B2|/`6,:Z]4+utҁi2Me{yoxX,}K__?j/߲/>*7a|e PAQ-?
{ku}xf{5ONӆnඍyp Os3z>k?
c3ƒxğz
K/^fmFYm'%.a7J5+ ]|r  <-ᆃowD/|<3yF^hHu]IodwӘ;H5=ſY ˿?G co?kS ,aveӦ i$n`KMbC2B?Q T U@z  R _ٿe GǏ	 7I-1/[ g2/Q>/qGɤe05R,$[[chi\ I3 ??h~:ƟM~1_
15+9doύffOoT 9hV.t Z&[G%ڄF[xd۱f{4g  C
q~R O '7w~n詿VI{-1}_}_:| ~ǿO&5K:Sx#n-Ė`ϢZߡR[256Ǣ 98 Z<;7²_zOZW[kOjtn|<co#la[Y- Vk  ~=C:4-?rChL0v}{Gmjh;to4[@jҭP_?~ F~N<b2&
^=C$^^9c[St\-ݴ Q@ Q@ Q@xO >"|i x6oj^lm7vhi*]x;}@fl'OH??
 oO8/W,??'{M>KU'%!dkpx7	խ_&;~ wx6qSk\K֡Ezo7;o#_? 	WĿixL/+5kz-È#PђKg=7얬jP8?V.	] +]gSZ]6XEj,K'PamdM?q~$~"*@l<%mx¶_o|'dπ-<S2® h B N~/xG  ĭs$?sNƔ9ߊ5=WQE֟5ݕ67E_iOmEs?c?'_O
Q<h	5h
|?[Xi7R5!oK%w~Jsv.aB ` i   
_=;FM??;yGyJ*_R Fox?dz}StZbV3]izT[n#S]SN=q\B%f	\ៈJ/Tp9Jxkᆾf_Ss[7/	x[CC?
hzxzLף8/ijQkkooA?oJL4
`umZWTCy{7C k91&p]Jgϱ*7?Q|?kFY|d+߄l<uk׶Zujx_F-/Z P } 
 h?WeAk kjڿx>sy\qɉ4ۇU<as n$/~OkU߆֓}+]ֵ۝JMEuTjD72H|:RO3U ^gGwĿIk>4ÞWNO&xR1jZnAqV_ ?_ T >!kfϬl?&Ek_N-ıyi `hpwÏ(<hs
 5/iixCڂv]K{t;{<HP
3G?W-} A|Al-goW~MsOrm#Ow/:' h<e#~x #QxGƾ3}&?-#a 
s4W:ImBBlI  R5Z_]S> fn5O"ٿ|1I$_HXn|o/O AW|qoiς mXү!ln~'*k{kYbt9Q]]YI~@?n?|v թ*
( ?5l,+ړtr3wN|AiXtѳ-<o-iCr/)_Ǟ*ς<
 	%xZ-H~+xZUaidt8YUA$
,{e@ W_w  y g	7ⷆ4
W_ Sş| 	mxBVzmGsaeksv j)_.f߆?'? ğ+/	Ǯ࿇Wrk}RMZV$r%vo H/< j zό? 	ڄxoBlZOӴ/t{ߵk=qtz ?ͫU_xRC:ׅ|'tX55;=3O"[V "ВJ\.}E ?`/
t @t
;ៃ>ܐZ-C-]-Jձ{oyAJ_  OѿuO~B/M-'W%+6[M2ZX`k¶wL%ǿď|( O泧[@f5K+/"
Y|571  H$c?t½.|oj:WuSχ.t?_o_γ9㿻%Q.?A~~Ϳ~ʟc I>
k:w?x=CCӣN?%-hΞJ' ¶k= ?aFib|j5{ϋ>kx	5:z߄l$nWz-BJmYZ[BH\.~	7 ?ٞk
KJ]oB[+?X]SJfS]J9d]Eioa>% fOv߰ǋ,|5)aE{Yf[{wM)e@>~
g|5
஡6|mmf|wROF&s}wy1UH.%V,BǠп׆kM;"_[kX6]i֧Pb[9w@ c#MF~.?xS[/_گt<17/5.%.nIy+$XOώ=Cg~/~'+OQO	;>h&!ey,#K&X)qݽOBO-oj!J=:?!kHeUDQKO@ KOc0  R?m PE PE PE |%  S 2< sM͏-/ۣZ~sֿf+~HH6dI=^`3%+ >|}xSv6 3iQ.ɯfŭ.b\K*m'ñwio$ c?(?
 Tu?Cio}>K?^-Z~߷ieʳT>vcga] |; 7Gu
{ཇq~ I}={YբԚ7 ^M2fQ
żcSuC| N//ρ_[A=/~
|3}T,,M3WM妝6\9B<po9O	~:1 xúT5$>4bx+Q?d\ ~E>x/9uҴ4NfhJd>Xn+6$hX,χ%&W+ ~j lf4%[Y?&[9Kszo~__k|1i  +ud|uu}JjsCy[Pm:oI)`K~ lj?U?S|^?osA7,q?d jʒ_&Vn8൧)|YG]5 ;kn\xb[Ӯ<IG>vgL}WiӪkdHoE? ߰_  	o~Zǅ<9}kX n>sMkmi=񩹔'ew]qyx<g+Ǿ	]o"oAhZǆlsګ};;o.`x %Y`H
'  ~ Gx3']hZVچKoOY?ڭ,4n]^i66 0I_߀|5Yk:ց[=C\I٧Oe%[ݵ'bZv?.-U 
O?wL<}k'}Zcey k#[؂2_69/ ` } io_^ei d h}ϱ  n_{lXw[ H~7E9jzxEn|]\jv	oWD-..tݷ1۸ /RKFRHA_^   1u@P_L7_;}@^/|KF^aqjy
coMqssq3,pCh<ʨ M~W pq^ l=+U桢i~"VXwf^(<YMX,,F{D9dGUB4% 7]CV7ZǂKkv6m%ńƓ,s!`Faԟo+~M1=?j/?ƃ2?_%޵_:O7Wv<FKn9uIlw@~هᮙ|KGv\O-y<pj.[ۧ%<R$Q-~Ͽ[6T[+n崻Esmui$W6^	cfybcDj/|o$g/~H'?tx<iiru/ٗΊyt2!)RhM&$KK	ȷ2 O/rE!|%[?i>翈 fxcdq[j^|S1_KMF @񝎲ͦj1M%d;-o.osndΏ'Wc~ jq'to_ Lw.q}w4MRkK1w <5 7g I]~Ѱ/Ov]xNՏמ_ͤm8
m|K1f'ǃ3  ,?j
h~߱}__b^QԴM:]}}[LЖ-^-(j^D)  
xk&NOڇE<99~j&>ag|*\_w4,ШApc[G,~9?ك >~ڗ|/W|Qj~(-gcivIg6[˛ۤ  r{ H* 	+ hh<ijM;/6k:o,;˼OzlW:uq2Gǀ:'Q5'Ǐ ->j^;ԓ~xZдve
حaQn.T|Sl '%ꚇ9q_ %+x5E_#P?_C
u
ZOi b5I]x	=ْpլ?j=h_7r\K7ltEΘeb%^DFS,?o)/୿Կi?fy i:o!>,a~j^?>8Nvֳg$> 
lO~!Ѻ7[⿆?ƙxoÏƾ)O[TӼ>!5-7QH$I$xg>  dZ,!k?ov}&{WV#?o'GK hψg|R ia$v7myip:m{ZnҰߣ| ̿E؃n-__eŸ|=m70T5	ӞX5E`inKmR[U
_-V- h1h¿>-ҥ=З^Pi:w}Dۡ<a' 4&y+OCg
 K}2+MLC
xY<$}h > )X?d ԏ-}@ Q@ Q@ Q@	$ L ??kO.x⯄|/xҼQmi
xo*ϥG6%q2@z;E$EƝ  ~߲خO g|)aqk
vJIbkVbMjDzVm&{gt	a_G~~a:x @UyFV{wG᳒#Ih \S\_۟CRM:bulu{y/ߩK)F1-|uO#+?{OWHmST,-[TU4{#6rJcH@s O=O_KP~"Rhtȵ5MNZm֍
QOi82?j?fπ^|%u?MR6⏈#.2pV])o֖vp) Id?<i D>?_+u|S//Kx?
xzM߆X%X텕ʰKo GSMx@ xW>&׵5m/u,egaJX4RIe+˻yp'%|?) 'kWx]|Chi}0Y
[$HM_߿_|N_K_˝gB
Fw^Zi2+]jW:g)3N=w/ ~ƿ
5ω =k_ZyxsZо蚆vwoj:Mڬ Fhi )~k/|_c_x]]TK\w_i,&9&kfGHS[*ܟ{1~	~OP}&ﬥxo,fE%I&xmo  7>KoxB=)]v/_kz͐Nt緰6rI5Κ:m5-བh|l1'ujC7+;PGVHMܶNkxV. ?o@?  #?o ?b G۾  O/e;??O߅^}?υi׺ΡiS=ޠ,Cn~WW H/L~P'MG<e_v+Z' о|?M$Fj6eazoouF;wOiVVבvVR_+M8ֈmY#
 ?c- ԿdP/nJ񖕫GX
7v˪jWq0QCYMkyjpm"a
 R>
.xx{ᇆVH4a
@ffrM,,3<4;1jJ͞EAy lO?+3ERΟ_ "<W?>4]:MRKM
FoV%R84y- WUxW^7Gl5VWj76G<2"JH ԉ
K0  ~?V|3 QoسE2ae Gц~%A}uwviw-wu
ڤfd <|eg/fMCF|Ok~Ң/^LL+˨nh}A`_X'7l i'á|gu}zRMMOMVK=F=FK;GWXf1>  8~<<YHl k+c>NïRj~&H->[˛=.ȭ2XA{޹vc>z7Tubw|{ß4+2H,ƘEͬW6=6O"7m_ 
h/_M? c7_ > W1/[㿇?W@%x? P.u?hB rMeUatQB> ( ($ V?c ??#K_vE PE PE P_I/E?+G4l| Z [~9>|~4|25KO^χWhzMY4_^Yk(BS
 ~ ;]x{ѿhoO;P_#<7H=6}?Rԭlu];E[i.4K
D7/* ^.;㯳ߴOƞ4/Z-Ē<?o{4K[x 2 ^ ?DC3g<'!KB4og_7]dݤ^":`ľIdk
 3g;O4V;TN37?< Ѵ沽Z;X0Izn ඟoۇBQ
Ꮃ'c~4,7wY~U i!ub1ʲG~](o  i> k;|"<O௷X?oXԯ7i!7%11φ ౿R) UO3C# u_|] C³y>$mgׇseǡ e]_mW{
SI' io  fx|h>>C׼ IK=[M|-id cs{R#e}_uO~ oď eyƚ]S 5H$־-1Oob/E6ZH.e? #_s oQt
:gK<+5ޫM4VVe٭/y&(_[~  6w??<% syoHڊ&jCj%H( ຟů=Cᗋ|W
1o~,xP=蚚MqX^D/^lf0>X  G|EA?WԴk+M:r.
Sh~ug%ꚿ5}K?'?ڳ	~ߴ|!
wxI|562K,	|z\O(g+[(RB
(  ?_h :Z(/&Oď/jxʏ+o
k d ~q~  c[e:|-,J]{Vki|WqGܫ4mđ
H!aPFS*]m A4+A6=/Pp0կ/<\S|ךc>Ѐha'%$p7|K$=xb Y񞷨x7IѴ}*{RŚ6I<q";:H\;	S ~4nVaA> |<CgsuZxO7E׵ZXntUH4SQKO3KkyY;sr~MemY^<_T?	E8L $ Oai心|[M @φō:hR/[qqi7 ) ߴYv j>-:ÚEo-mk
SMӴ5ٖI&J;
9\]vaXZrN~%ۯk䭶_	~qV/Gφu'Ǟ: 3xGTE4ߊ/5 ĺ~x_ĺݾ=>xVYƑqzm$Z]%R޾Ozsğ~	Ɖ>+c{V^u	#}2;W[UKx'
O0|S
[ƿ!F}'NӼ-"W7i>%ILV駑柏?l _?& |VM;Ӽ3~YpgqkK8m䱵k]R-Nksu+QPПݟ~>3YƟe]^+k6.kbk	.aM!죶{{v23M O<~g?- C 
?> _b9?~ >O5}WE! Q@ Q@ Q@	|I ~@~2G (j ( (_&Wi&~#|V<7 .|x+Y>5$\],
dMlO|V?I~ ^:7-F{:W|<4Oj:`ڌS.2M7W>kD2:ڿ3~>꿴7L|{]x+Lkei1nA)pc?
|>5~ <ak?	5s-b{6,).#u@ȭϊ6Cc^4_XtCȚKiG|l:2-迷w
%&ݗ^_)fWZxzm%m8Ciyp-eDm֊Rx
й? F_ρ|N>/xs>&i#	ZXxc]ZZ[^ue<ed췆M,;uۃBO=/z=ec-wE@[Z-\wVJ{ ˟_S |WG74/HDb<ar ѾޡoYẗ#OԼU`P geg) ƾ?
I|10hmPu,K^\S*0xUvg^'׶ ^/Oux2zma?o;8溎I ->٩Kieqrf?)O 	|N+@]3M+Lϻx̚hM7I* 0gC4KQJQawxY
};I˛ˇI:Ďlm[W5/'z?m~
Ҽ/ÿں%i&K|5-F!<Q翱_95_77-l)}ey,...ΗWwP4w(<"|y^. mx[Ebo5{_Pӄ6]LMh'yv?
Wǟ$:|^|MvG'ƻ+7Mzyc-j-!'o
WHA_^   1u@P_L7_;yߍݞҤ~.PůkQЮN[M^OZ[S 2{O|on'.آ{-6[&xiZ8"d[# |*O' hj~1|AּWu9$[m-djǫ^NkFk]*fP/]IQ'}
)~a~޺>) C|
/jE5x~S#[Km6Ģm˦~fMOſ:
G_,E >#>#1tI(g4چotFeƑ~b5.gQ{ZiKgM|`o_"<V[/ â|C:FW&oc%MiOOе	uo-HgtȑA?_WOw{	 O-)_zG<':%Z1w_!.8+W	0Si6Y?&kg  o74S>'_>_?	?h~O
4eynOn`2k;9P\iGi߲7¿Z xJԛ>!յ]8yw?i׷
(ڇD&N)YU{k[#6b
( 
( 
( 
( 
(
KCE}FAX
*JԼuytb%)=S^szCV + j/'<_0߃4Kj 6p|ьAeho&	/.hm-`yc.!0i&eҧ*!Jɤ[?η
 ~/?د^5K8h/"4oxSxJ.qf̖4n%CFA|;'<Oki>_	e?{3ۿȋvv.>K֭UʅIF=,+!G2R]r엦yo   ~4^u+<4?!VڭŽĖz+/&{[ԉHnX\fiBzKi36~(I,txi.uxA	f7M=8ebȧJkބ&BꭾoE~!IsO5qҼ. \]X\3]jBf޼ҫ
Zn韎9v/)TcRkO}
+CK	 _ bg_)gs|>M=$iv^[hmmԧBb3i-Կ> :xc X w?|]ŴR
s_OKEG~+:*|l o흥~_~(|1ýCm|NֽMdt'ZNų^ua[_Y­hG O g ./O#ow
oM,&o
K]
POi^W`Ikɼn$j^; 9~ٿ??) hxC4?F]YIcT#}G$}>;NiWNK(t&(
Й	yR?<A_ |wÿWC׿o{x<,lqy.Wlϓ>% 	 
S_گ???+G}'7|=| R
Koucxg|T 
S̩ԚW·6L&s->	쬑y(kbx\u 	u v~v%}gmsEksgimguW 7 L?_<A[3 7F=SQ @?Hf慚:k}AO17k {xk??N>'V˫=9<!c~/T5iv57k {xk??N>'V˫=9<!c~/T5iv5 6Dן:=W =[ÿJǿRVm_{iam"$%!Y
|R>_
@o/x?{kwG$6z-O.osxBHf]ka '/  [_mM"TǓj+-f{>[	`G3{jK~۟fxKec{U-RV?֚nψ-dOq<h.#߂ίk\<~i>k&>xK>h(FxJ+Esqw"$I<s.\KI _K]  @ )  
O/W۟۟ n?پoONߞ>})~ޏ %F:CM<3~*xL )TM+M[iMlMKRVVVH ^ ~('h
~ÿ>$?45Kߴi?`2y}(v&?_?f?߰6υ2%
]^N{I_iy\Զ[4S6%~|~x75|_e3w¾~qs igrM71,#mI (/&Oď/jxʽ/G(goj} |1Wt{ZYty.^!Y'F)(b
@?o#Oߋ?c|
Fhזk$ۨ0D.+5n̸n5l 9;o
 dw % _+>) r  tO:~{!=??^<"	W+Z<Q{M<hm9O} X2Oa<R7K~ߞ%/ 1<S<]}O{^
]`\?u9kYZKi'qhicn;Ykm[ % x 
g-osSe hǮx%>˪ϮZ	^7 ~i=''s yA}?'}qqIcw^Mï^]f/B70eW"$4[_m5apL?&/9 5٠i m>h|7vI è]Ϩ5QN[tmK K?Pga_hiB-;iZzO|E
E7\[eXXrAF[+y]of~w&jP¾ׅ|KjY^aqFg
ݖcqCqmso2s,nNE}I~:a?<
f&ύ>/6Zkr/u敠VWu}zmɚkdH~k?~| ax6zo<mhWSxZarG/3Xl/3 L} w 7T   /6 Hf?Ry6 H n? hD(u@[_l/3 L} w 7Tba 􉏏Q  L} 3n L} w 7T?"c-/6 Hf?Q 
C &~> G; ao1? hD(uK 
C &~> w 7TbYJ= e{xip ,Rw:W;{%r<znp	;!~ 4o]߿?ڶ'Lksc5u-naH1%3Ki1GE! W?౶Q_Ze8-t!xzWIҼiEMu%2o+]kDԕ%xi'<aZO (g^
T6:=?C s P,\_|}/=wE~:cV[=>Bv*M9?nXevR7e? P? ><iO4mt}l]kU{Cx~7yR^[3 4KUNy5LK%/im]}?KCoÚ<_Tҵ]:[k.TxH"JC G R/"	,t
xkدd}ZCw
}qyi` lIVc}k}!8%y},UgEyO#<34	r^j qE}G2+$o_GQKkĚ-Ա?Bo{omy
Ŭscso>7uWK`/p|ZxOw>#蚚/f7P.(Ps\vbp`?
W4k+>.h&n9Sյ_ivPg{xXFa]) o?k3?#/K0
Kþ'+ScϴheTރrH2	z_ ?;S`  .%  xC %$/wϰYz_ ?;Q W \ K '{,`  .%  xC %$/wϰYz_ ?;Q W \ K '{,`  .%  xC %$/wϰYz_ ?;Q W \ K '{,`  .%  xC <F g_a-_bk$	gq%{OcVw'KH,O߳w/V_ui~iOE|6<އC.@j:0jQMK3
k &Z#(/&Oď/jxʾş(3V?ࡿ|abWßt{-FQR,:_z5Ζ>j?3+o~_kwz'ŝ/Mw\Z]\kn
-⸸qʲGzsm=f=/B橢(u{{[Joj7orKA+[]ZN#ps"a|T#++/ ][jI+OwiWp<r4M,
RDb
l؟WgO_t/φt {MMviipM/Q+ܳ3O}_TRS[<
o
x'>X[:FYieXư[[«$i*** [.Rr`C ۏ OS
&i5'h̺N}+څ|][\Eeז7ܪ2[N첯В h)+ţ^+)x~kOմ}cIUf97I#ՔAo|P|M&i?7Ө\(o%QխA%o-
O£OXgּS{kÿo_<uVWaC|6w3^I1<gSKi,%d1{THAE PE PE PE PE Ps\dll l*#,G5gå} C
/͛:x^?}Y-J,滽$Xm-mVY8cVwf
X_	? saExoMKƚ:h/&Imxn)\K=NX
bTVy}\O-|n$E8d߷ڨ-.1CN$!m;Pua[{c 	Ni5/0wWs}q?|*_Yhi2l@:fD4RGsey^BC4S\DFfT%J*Mos<.:Qn]wN/  dx
w5Suz^ϨraY.4{I'kQ3JgTaq<]X	~>ow߀|3sRφ|s-K'Utu;aN5j$$ lD"IfxsE˕;7nnr߱ǯ|r}]?N|p'	M&9ů㷽I^o"OG4mn;1sxI2N}$d%2'FKx࢙c&O/ڛ}˯N3oixEvP떓]IK*[;*B v_N/~V O➘5}m{_S@ާqorz^_׋;h 
( 
( 
( 
K
k &Zh?n?|v թ*
( p~˞"ਟ\;O7)DZ$.gx5WFVkaĺ#][I[
`C#; >-|5><m6TtuUE}?QS/A t?Y/>-s̹tl,tۍ?RyYR7ͼ/jBXZ(5k~)&pWgįxV]Pt i[[4Vt+<ZX^߹lOf_Y[_8
/ >/ 9{._#^W6Z+ɭy/h֟efl56O
:ZUQ]V=_vZu"3ŏw
 " Jx>FO~[NvW.i/^5WnD*/	ooןA 
 ǯ|-c#DөkG)=ev-W-f gn[ݘKϾ$[|xK_g_ZEG>:K|9G,"5?+m@B$D_ b*O|2 k? fsPt{/
xVouKxc^ivڝMp&ZR>d`5^+ %`O<S4e+jrxkJml?a<Z-6s*OTPE PE PE PE PE P淏?m+x_U֤|T<3Ci1֡2{X=;W3c! 
~ҺOZ)Xߟ 4;]V%2YjniYG9kn[XO#0*j.ܬ/j%ZA(fO;鵼'g7V/
͇?xo}%\i\H7\~ȟ/H
w'Iݽƕ%ν'8~>Ww/yۦ$Vt^r>S51ᨷY7k'~E {㏌{[m=/JHu?W:vckw{[I[+__j[;i֛MCo=_BѮuKZQ&]K,w@C2b*t],wޫGGGogb=|G|^gеo
kkUTffOMm!0"7? >B -61ΐt϶ hjڧzP^ֶ	vՓnھڹ՝(Ssn)7k=Sr°<0w'!,Ǌ|m 9SV(Ef5__(O0O惡ϊo5?QVFo&OݼC߈ࣿF?q<bW˗1wI?e>KS"M.MBcB
( 
( 
( 
( িn
 |	 թ  K	 &#oZ2h ? ?43|c n?+~^;kچxU)kqYicrMw4iYbU
t'D>7> | ud߲{.SRk/
j#^	{i"ŗ"7rG1ҺeN:Q  `Hgc|1w>}oUl5U=SmqPI%m_ D& >̗柫U.]\ME|"I
]2mimc"l'[{heWvO[u۹U%-
+2
( 
( 
( 
( 
( 
( ?#>#hZow㯊_ x^#ek$~o7kwy{_WKirmf~?6x	unL5mƟ_l5)u.ce%2ɦjaG@*p+ίFQ[F}Qaaa\ xgc'r}39?|w៍7W_XՇuxþ㽑W(z0`F')YǱ)r?MQ &i'~9^5]ث6'_l?|+?3g56&6
!N89}k~j7ß^-z_j_xKEV+y}nMC󣺳/o5{ݽvNU%<F2
һ}巕϶cO6Ǣ
/ VmaSI}
{9;G].n V;zk/4;> 7K |#/_mxĺvcqz2[Gq,Q"X20F#քTb1u+R; ~M|T  ;<5w
};Ȟ_Ҡ.g$1%Ε4 UX,/] Gu 	 ؚ>#}kYn/d-[n &yEӵs[V~؋!~( 
 2'/+\eSM.*;{ֿkӿKE"B ( ( ( (  ɸ|7 ' V((/&Oď/jxʾ Ş𿎼+_xVς'W5[8n[kycwueuvV+v v(Ab ~O	Xu%P@E j].쓬C&뛞Lv38Y[.} |.T/ xS>>x3I&Kw@_jwm*d1[yLMqp ov^&Z^C`!oϏl</{jz湩;lidx$yXI5N:w &,[}~ZO~~އi.6q>y׺휮3}$XG5.p)Ђ'$&ܐ
( 
( 
( 
( 
( 
	qO5χ~+<=wOq}ľ%d5M*np#u_
 nWiOV7뿄𝆫qk:2jz\WA
It t#)qd1Ԝ{ҿ
 G|!<Y|@{jM{cúWRYyPeEHDl#W(In18rK4?
c?_
ǐڰo?hڟf2}a?>m'n7 HB5 >Ҋǫ,.+^&cI9qR[' ? ৿
YCh|v>5%kn#	|ٻ7ll^/&pgk?h~K^6?/o
. fR[vɿܧn>{t26=s j8	 OZ7t[mWG4^үmIm!Y )#HFVFEe k>] ( ( ( ( +/)/jx2>> d ɸ|H  V (' ~ؿ a-K i??EW=hSZ]B iZYnȷGm$E5 qi  V
ifa|5-Z4kAXihX[]7&XB'3lLn~jIwկ{ғQҊ&ΠgO?Y?٥ 1ž/F(<SAxח:^_ɢ	tjk+szg};6KF<,k⽴{}ߝK6?_	W|
Xhl-#HҬᴲҬmXmUb4UT  NP
( 
( 
( 
( 
( 
(_(?b j~?W/~t="K.k-e{}oG
q<v"9nVU`W?V8c ~.׾#@i Z#_KOߴX&m$|SsDj B5_g h$'sxo~,q}uK˖Xm.m4uoaus^H}i֫uLE>crc(ϕƥ; s-~Z89J(;5}z};^
Լ!E zյWI{utߵ[_I&~uٵA?l&g7t~, gk/x@LӵHmgIK9$Mw6\Q,-=.5Rx]4~Q1QsBVK ~6|+,%fuM
Q7h$Er4LDJ3*G4eeaTl
 #N],	gyůA-ƷK4;DеMsXo9g6vqL[<vv72YP >a~#xXmKkok4
D֗W4̐\˪jzGt(f8\
iʯ;J1nޟ֞^?WXhw~w	c . |&.h=vEv4Keq<7+krcɔ+E''?k ?_|;t4Kq7&y۽!'?B~TR 
( 
( 
( 
( 
K
k &Zh?n?|v թ*
? g }?P_<!Wb[*{i"hu^XбPΠ o o| |:m_O>>6b$)},˫qHgn+}:h퓵 N~ֺW O_! |[Oñ^4Wt>Vյo64Z3ػOJf˼K(룳{-e<KO0α|YEJ6ߝi7I:l&Wƛ(5??MkZ]FmkI	A.5so|[<L=OO+ ~!<AknG>A]?ϧK7i!dР}ZuM2XySxO?>[mNwVgyG ߂5 _mQ+x $񟇴)ae4:H[<f97_߳w/v6]' 4oZ}scYAco%Q2E,U (4WdPE PE PE PE PE P^o@z9/|@~ |jz滩l i'Y^8!i(b? $ ~޿8x>?8 8?'l_iYi kOII/2)@guǁ U\ wµ^ [Z JGNO?fٟ X~<~43p(4w _h6o_# 6mǻ;-j?ǿ.-GMD1xkU%l{gԵf+? <]ek^~լЯW>z/}?F1 Lg#
Cxv^ C%^UFF^]xJYj|ɧ\:yl]i IѥXZ&Sxz;h'oH=	5\aEEʿ3ς?" KO};ğu}3O>/IeyX`Y!iaB+Xm-m A xJ.19FNK<VS% " >|Y߄w~4=7Syl%!BKI~Imr<2( ( ( ( ( +/)/jx2>> d ɸ|H  V + g~;D?`%$*GϏWi"y+x~e k H}%hq֯&<,_m(OMw?ŔU %n? >"|;~+W}0`9m6vW-$3[NnU%$_d9vcK]7]F-s3q#u7Ek}?n q|e~~)&;-kƚU׍.<qeh-quRXY5=f%di|'O ?iq^[CI|e3~ []ͨY6@7uoy%X\_
êZ9_tIu]pX>;f|{;5{;=Ouq ~1a/T
i6'_~>kzt-|mks ]OX[ı6$׭}|$_
~|i_ i3񎁧xúٮ-tB;9h|fcG]eVXJrxݵM<u;EHQ@ Q@ Q@ Q@ Q@ Q@z?Q{ %
/?5Y]xvPM?J$I'4ĺuJ	yp Wg_/?^uG+_u)8O/y_Q@|y.? } IG3 N|OYױ~ᘿjٓ [s׏=__#Q>._g*Ml|m?IꟳƏ~ #}
=1[XP_[r,I2:,ȁvc Q@ Q@ Q@ Q@ Q@|% 5 po eOOPݴP_L7_;}@2KzWV4Ծ4\|CˍD3{h*3-ƥ-Cq,Ŀ7ş&'Ɵ!(gio <}ZA+~ 5OZ🊴
ZS+.,N$v<o-ӥY#
u,o
}S?Ɲe&f_)u. [K&}$A[̏,Yv1oRokV+m<G.)66sg3[ {:oҿg>vVk|@Ӽ1{VH~}[Kn1K<'@( ?|= ~2 mW_IwN׾NӦ@辶keo)9hϖyguf b58k;_[T9ÛZ_ﶿ#: ( ( ( ( ( +J?ൿo?*WS|/xwn<ˆ}>Dv[aӣ4+%eb +3/Eǟ/:I'T(>W<G JӀ?䤣 '>',	hO$ `5sP1	 +ր
( 
( 
( 
( 
( িn
 |	 թ  K	 &#oZ2h?+Z T Lu? !u* \7? O{{<QxZ;ZvwRkzꚵh<"*8$27qe
& }S<@aM ^k(9=(?	G-|Q<N֮|HuFy⸞mb;z,A=E.Ɂ\O0_c߄?w ]C5
UneKy\4<+	X#Vy|9gBSZRm{7W{uH\CԢ[ݧfOm]tM-	px2}c-4|DuxtC@Ӭ-'}[M_:EMOO{ۺ~i08xmS;wNS
( 
( 
( 
( 
(k?_7J- 
!/~\eO/߳~o&>6k +3/Eǟ/:I'T(>T.8xJӀ?䤣 '>',	(O$ G1 sy? IwhE?fǕE77vG ( ( ( ( +/)/jx2>?# fψ_ 	& ?'/_L|E5OY^&-NؼsЯ˓'6 Hf?S7\џs_J $:EexjZU爴e7%`[Ʒ!r|DKn_%GƬ
qO?EyіRzIkkE>/sV
0OIn%-t 5M 
}i?b~?T| ҾsJ̿?@ K ,OM=t  S|i £ 6Z?Ԭ} c y ?P?koE?Ɵ*>	 iG,OM=tf_K  / K 
	?nᧇQ	 @x wz1iZ/NԭRM:XpY#~Ͽ_
ùj# i~_vKfFNQC2 6hs~!yf꘹VqmMb}w?AᬳeZMǕ]z?l/3 L} w 7UCo1? hD(uK 
C &~> w 7Ta 
C &~> G; Ol?1 
?P L} 3n  ? 0?"c  ?{ ; Ao0  ? '6 H ny 
C &~> w 7Ta~ 􉟏Q [Ol?1 
?R a~ 􉟏 c  a~ 􉟏Q  L|} w 7T  ?{ ; ?᰿hD(uL-'6 H n᰿hD 1 [ P/c	Nʿ7{o1xOӴ-cV
6l,fmn4 p!Ӣ%ehdTG?/.y  ̗ 4?.dχ! ыL{ ˚ ?/.d
?kkE ĝOޫ-7{E<2}OiwW0鬮g<
[8-fLҺZ&M/8Ӫ-S  b ?' ʔ3T?غ 4b qOJ_}j~:& OO [ Q[_.//&-x*o?٣Pm37_~}wp
g^yKSQo4kץ:N13 `b> ! 
 K{ ˚|G
 HahO	p|E>/ 7Ky_sYl.]ԯ6 Hf?P;6 H n? hD(u@[_l/3 L} w 7Tba 􉏏Q  L} 3n L} w 7T?"c-/6 Hf?Q 
C &~> G; ao1? hD(uK 
C &~> w 7Ta 
C &~> G; Ol?1 
?P L} 3n  ? 0?"c  ?{ ; Ao0  ? |IB i+M 5~/xc.j G>fhgsRqi%#gw؁~l3B
( 
( 
( 
( 
( 
( 
( 
( 
( 
( 
( 
( 
( 
( 
( 
( 
( 
( ?        . billy3.jpg  	@        y4   W JFIF  H H   AppleMark
            	
       	
   } !1AQa"q2#BR$3br	
%&'()*456789:CDEFGHIJSTUVWXYZcdefghijstuvwxyz  w !1AQaq"2B	#3Rbr
$4%&'()*56789:CDEFGHIJSTUVWXYZcdefghijstuvwxyz  4!    ?  dOG -\w[tm'XX_Qiֺv[YYoeckmpAx$I ?} ĭ =; ?} ĭ =?Jߎpv E%oi n~Q> Vp 枋÷?g( +~8OG;sx   4\.<G [ z?۟?v?Jߎ ?} ĭ = n~Q> Vp 枏v E%oi];sx   4÷?g( +~8OE?۟?<G [ z.a ?} ĭ =?Jߎpv E%oi n~Q> Vp 枋÷?g( +~8OG;sx   4\.<G [ z?۟?v?Jߎ ?} ĭ = n~Q> Vp 枏v E%oi];sx   4÷?g( +~8OE?۟?<G [ z.a ?} ĭ =?Jߎpv E%oi n~Q> Vp 枋÷?g( +~8OG;sx   4\.<G [ z?۟?v?Jߎ ?} ĭ = n~Q> Vp 枏v E%oi];sx   4÷?g( +~8OE?۟?<G [ z.a ?} ĭ =?Jߎpv E%oi n~Q> Vp 枋÷?g( +~8OG;sx   4\.<G [ z?۟?v?Jߎ ?} ĭ = n~Q> Vp 枏v E%oi];sx   4÷?g( +~8OE?۟?<G [ z.a ?} ĭ =?Jߎpv E%oi n~Q> Vp 枋؟L)e}gF|__/[O<Q-S^?􏈾*4'ԵI罻=I<?m!	2>$~ SUm PE PE PE yߏ g
Xxx&4mcƞ%ӴK׎Y;bhAba1- g'81E` N>> )|p by D"f),G<8  ?_?f?E/Q #?|} R 0 N>> )|p by D"f(Y<x q K 3 g'81E?_?G<8  ,a #?|} R ?E/Q`y D"f( N>> )|p bن t
?]_s@4[q̷~KCK=ď43>|U] |5ŞjD[O]<;dᔀk= Q@ Q@ Q@ W1K ~>'|fxGᮙ ixŦi|ݼpM4Pe=_	s I/ (  .%  xC ;>ó%$/w   NY> W \ K '{? KI/<^ qE`%$/w   NY> W \ K '{? KI/<^ qE`%$/w   NY> W \ K '{? KI/<^ qE`%$/w   NY> W \ K '{ ߴu~|#Zjk._GS=L"RUYE> d ɸ|H  V K	 &#oZ2h 
( 
( 
W 㟅?$ߴO}}4ٰZ\{XvlvOh3DwNͪ2 5߰w_ۧ ?i_|_o+:;Q>G֑zmݦ.gK9Y.?B> om> < lo7-~7vOz 0,C^A	Z1\"H6rBm˰Ϲ4_ۧ3 Z<] =>H|pwgٮlNmޒl+e0kҴ0@ +[?eO~͟ $g|{KE g:|1e\xf,=gvFY
vW_J ۃA|V  	S_ ٿơ ٭|3>w` ?
O 0g>4 k=}KB_ M?|#
-D,/?_:3ikq,Z֕anfjVr閗S]+g?&o-َT ~^)?i px VuPmUKVr]X-'TOm4Y$xR65~Һw ͿF [|@+{fku{kY.I7Cy
O`|3  \xW +jZ<GB|%ey^f֠}:9A[&iSgU¿6h0
&>!->!4/].k%CYu+{EDhevXܳ3>~?/.Oj)꺞i^ԡ..oH6Tg;hZiByQ _?`_Z/#'|6/n[	qiuŞK[J,~K^߅|3YVaohƕy
ݎcqosmq4s,nG*3+) SQ@|k(~'iߴ??imA5]C>XGh4t=?:PfnsIMtו #c #QYx
u |a5
x޳Xj>
{7hXP1{:uFF+PE PE PE |)M|k_ڧ)(xWQ8$j?znv &=SYM?KZ^q楌Z~_
 a ῏4?4|M=2Cv+)Okmcnȅec)( ( ( (v̟U|CO	i_t9h6K$M>-$+˸d='dL,.>%_OJsO5[']&`R[N,a!ҵT{9MO6g_L7_;}@	2>$~ SUm PE PE P_	| y_?
OwI : j WX]F /MY6`^ Eַ ~o*ۋoÉ|B*eXi-ͭ\6	6`4q&TŽ?{  4[$y}Xеo쿱 i/_'~} = X    
+O  ? nd/4 ~) B~
~ȵs;/|@w?nz݅Y!
>l"+?k?~|AsK:Y{\ɣhKq3ZDܳ
[Erq<&.	ύ + av #.  	!_#__/cPտ7^O'{( g, Oi¦ wQ  hwǛ !Gy_g⾄/'
)5/}o b
_(կ n<Sf},Gؠ$<;ǿc_7gnq[j(e?[XI|:͗]X;iV{(-
q|G Ϳ7!XxVw
30M$:YX24S}u,,B,1|! p~/x_1ĺ a7+Ꮝu?
WPxzVC[
Ag*q_8 ,?# Կן  & l y l h\ W 3G] K?BG$ؿ_:ơǟn/Oowl_ eO٧l'S-
kXy ?7P[
fZCYy-uil-v&&KQp /7  g߂
:=֭,2\VPXto3G4FE(B
( >ӿ Ou?i\~xK<iZ]Χ,Kl<iXt)a^=m
}@ Q@ Q@ Q@	3_/\K~?l|#g}*;m6y<%
\ ~_9 c
 '_Ŧ@j+~7_JG3g}/
` sM*-㿎]
EfZm?yRj
~ i]C /3O}SY~xnki>I׬`S7ĶKu W t]GQj7=Bռ+47/>'uK+m*K?Oghw|  G g)?:럲Ox>0Vax.?t;}+X܈qgyo&e G	uS >jois}i̚9t?]I5+  [<;<xc?mC^լ?g+7^ռ=Zբڿ_Lm|dBm .wmA ?do4?iٳ>%ǈ>xItVFP}b}J9$k;OnѷG{$|)5 o*?~xƟdԿwf|Cgyae%w?k">X̊Ί d?>(} u ^__pj^5pxzKMt
kUקotxMU.}I On_Z<54?ww'k>}.M'5nKX7i59DH@<V?L)8^g1|?|Z4 5_Uyjuƛk]xSpj:{
(^H? ghi/ j֥wK~oM6!{+y+88(F[wOMWL<I ֿy/`k6zgzeٝ{k.crº ( 1⯏߲u
>uMZYBq}JʎS$6zՎy$-rG-;h!?<
 4ohP}mcA}oC$*K"a:-2>$~ SUm |%  p eOWݴ Q@Cx_/o[
z-ƭ6ZUm5̱Q*34+35G	w㟍n~cxKYeYV$ꚭy,my%Fg: m>~>%߰ǿ|\=[Ɨzu3Q
^qxsĺh-d%(cY'v_ Ǐߴ BG iza#$dhI!TI)a47EzB
( c8+g# Ug: 2~$ T೟M4?g%ߋ#Gwǲ?*˿\3sZOu뮍-X,.bͻLRݿ>57 xN@_ |U
⯈&5H4+Y[OBմЯ.v)mi<Ѭ(=Ϩ fߎ_i ¯g<MoxC6x7la:u`SYY\X7k%s]Gure\R 6|	}m  |/Ծ8|^־ S 
þ(_OH)}syzqMswD{%Hs k?~- >~֟?<_ox[,|WO ]7az{}`Aiv6Ow4]2, h>7Rm3 O	1.~92@ymKĐhKCk?24,ַ+y۪ygx?>?k?ۧ'¯,oaό~?{KxK@9=<Ym^*z{}yo,*DjR%E டO(g4ξ uOzVotPaX[taG%:Xz*yCw
 _ÿ~?ҿyxGmv%[ogJ[۩m3-tqqo̷A@x a?l_r~ҟ<G ANú.kwN5=
.+?IQE,1+@C/&#	   "F 
C $ d~_i<_ %?e/?ٟ gO_ XLɾl.7h<Gf;9 .Wf| |:4o2 e?_F}iĺ׆dSK[7\ه.,5sc}m,hS	$ψ)x	 Ɵ|L>S[Ե.5/iv0]uz!$yҮ{-Bj?mo_ ?5 L?-5WT|wo$yp)DU ~]kp/IPk߆~|\;ukk&Σ&Y4yWY,ӭmZ}SN /[\/P?i ~=OInuK=b-+S)-CVmkiIh?"K
  l/>41 J\Ewqs2&}>dg#j/> )X?d ԏ-}@ Q@ Q@ Q@	$ L ??k (,ǿ:|\~xY~_hڵ-_,{I2!1@ş|O<Ao _>ԼSV[ŵWÿkŗS_:Ow	1S&>~~ӟ n»K 3, <OysE+ @x \( 
( 
( _&Wi 2>$~ SUm |%  p eOWݴ ~
_ho^muxE4#MVidҘmc9"7nz
[vxƗ^ Dj|/HƯYĖ7RE6 OaE,4d$.H/	 ⭧ZgWzῊ~+g|![MV=o@TSMyԣ[yloB!-_Yx5h?hߍ?|}'Ix^]:wɫZ+FHBP{{jQKQT~.~ӏ	'^ xR~~
{O>XipiQKdu7TԠMͬEqwQk6*gᆻ_fh'nR9!7Du݆U`@RZ=$|%[?i>Y:mi>6?7ύ f5;$}y_z':|ir~nh
C fQΩɭt qkk?Ty@hJ^?e  h 
[i kn`_϶&ÿ
Kǟ'Wᦁ|J?+[j~'υ?nA5١f9F(T@=K+g>8?d?^WzǂhVRIm%ŅR<-,bf*^،#*~˿>*x'٣>$ᯱ ;F?c{?j0=ͯs$yR/,"ᘚ > ~ʟO	Ch>4k_vkz^Zsk\%^T#Hf& 
x8gƺτn~ƭ:U̍5Ƈsq4M$d3I%@Ś2I4  X? !u _z{
i.Jå6N2cch패wğ #-;@.~ m[/[uԮWΜ|߲/if  J ?'  /}< ? ki 'S?go^*ǈu{7ҵɆau6oq?~OkVx	]~Z= wk[?tGF<_MsQ?׺|/'ʹ]N.UYe){/~6şN
|$-4jOڞ}Mw_+cqv¦k<Zix_>|.%M~y|=}J4 >i.g--8b&Yj
JrIU|4>;~>?bv,/}۾\[m yq>k >?em[$59_U[jڮ࿇>63_Aqe?d5" EƟkOeXhrGfo
x	s#xPտg+
F-7c-o kEc
+D[ E> )X?d ԏ-}@ Q@ Q@ Q@	$ L ??k ( ( ( ( ( I) _@~9  p eOWݴ'MG<e_c|Zo_
&|g f|4~xZٮ.>KdiaݶU@?& c<o+oa$gō;U	m.t;B~ņg./5uIvY_od7? -_{ _
Ɠge>>񧌭,$M4eQW:ŝȱ\2]4/ qp'f?M_)3~5hy{ע _,c/~ */xW:4S/ntY,|Ui#ַii7f77ZվD
r"m\ǈ*|/1_ĭL 'CXO
_ gZJ5١eo%FT'O_	~qV/Gφt^  i_;t߆_׆?j^_aqygе;r?W?~??|# co A ;/O7x>
G į?;	 y 	Ef5OZ߉--}\.-V3ejzbHI4}:Ms/_O*/OԵo_xyu믌εg.&m>i%Lbӵ5:}4; ~~?Osg`~Ϻ:
IԾ+M7NMbj|;ԡ#H޲nm>7  i w⿉߇<?c?A 	u Ok^/Ťj^N{n:[ %lKo >x7:N U}?⧆<HVAQ֡x4-eo eo&~վ5پ67) b?>/xCdsuya4ٺcf<=  0nؓE~_>9YJO_˟Z.4{[Ŕf%$3G,10 _G, ?j-H_ߏ-I|= Y'^Zyݮ2s@>{S?~ g?d?_<A} 	s 
SYWMj4tJ[CO@B'h BKϋ lm컠E$J'j0<gkkѭ湵[,m$7ArPϰGE E4@ oxNCMS8XuF;_d0_XۥE6B/X_#k~:>0  'fJݤ/n~ͬ5͟ bK3[  (q χ_<Y!JAMhϊ]h(V餼ۤV?"}_oB;G7 &'d"F mcGŝ;NkƷ{cYՌ:Ei ~9ſJ/ۣ_4>>Y"մ
xw
|4eũImֽ&hWZ7k5kmw+ V_C?#
 z3O~|[M]Xl-&OzDSuDZ\f2G=lP)j4Z Oi,df5w{	mhYR5F1"ms= |%'R Z
( 
( 
( > I) _@~9ݴ Q@ Q@ Q@ Q@ Q@|%  S 2< sM	 &#oZ2h/&Oď/jxʹ,-$X񇉴'I4n+ma GWZk{XbtOHTxI/</sBq?ش(#K;l];1''Tcoz]5_?fxS_bH/4KN%'Z1}˨jg=j?1 @tH(I uq	ٗ@v|G㿇 
"ֵ{$_.8.eXbUF6_8^S)~= gƊ%)L-ƥe}M0ךƛyoq#<xyxa9A]Ͷyog~e]6Ir/٫ g]O_h:O8mz >'tk moo?NCϳi_'&>	]b?ا Tj?=-> ->|v!⻽_iZE[k]2q]i	,hMo{u%l&"^M&6:'o4K$c %¾ǁKa/Zմ}cJUf97I#ՔA?e/l*/xY ~)֟Լ_yռkO,K
Ŵz&g_ o۷ ~)Ac~|Ic\i+hڸ6?:H.~yĊ&w=Ï
?ƥ
jDx<?sYzݾӬھyb=2嶷iHdh|R  3 fO
/g ұ嶗~ip]\̻|ϙڤ*=k 
~͟Fϟ~'^_>;xoƕ_	h4i׳
/_HM iT+ì oe
~x fK?EExsD[kYn|5Gks&A:hyq]ۆz'$?kOǌ|;
h!}Շ+k1_S4-cM[
si7);4 \ ~ | b5ߴ7yvIY<"\_'vro>2M࿉x+~Ҍ
%kZiu
%z!{T}Ic5/"e  |\]VKL\_jz,&8![7hP), ) | c|:Ǆ<_i#5
:|3a0wGX ೑-lڄ!tF[[~( ~'j'_ x7P-ׄdӴx:nWD,)-/omt,cKbE!wwg,|6K᤿^¾/WJӼ,urk-#kK
o,5̱8xT%sd  :~:5O] D:?m-nkyln %]X.;5}>+I%uO۷	S<q-վ%|N>xOC\Z+^XGHavxgH Nχc ? G@-6z՟(ݸto#@moq?; ˿?o/~>3Yx?mM<OMX͎aUoGgsmLOD1,g~ pӿkOcx//|dN41w}gya7gE닣ap-ZX A`R΋? 
>W.öxڭP9V[mVxo-3!u,>ʢJ?, > H }_ O&## O3 o; ( ~~ӼeG<m5_OѬ^9fKh罖8f	+)  L~G߷W >_AO'N 3 s秗+/ʓfSFJ/ͥ\3A`UѸBRWtE<U{ߵgÏMZH]b).^IRCOP}24ב__UҔ&^> I) _@~9ݴ Q@ Q@ Q@ Q@ Q@|%  S 2< sM	 &#oZ2h/&Oď/jxʹ, ) ow]CuK:I9josg,SE-Xݦ+Fd`3ψ=
xw
MZS5=2+MRtI`"t+A?_?I6VW>*W<G2QY-'ӴtH9&"1e,~ a{g៊Ku?x^-#&;`,FFr7$͸+*/1RD=QHG_= ࡿH=~Z?Fjm)Ə+UM	d.xV;^@Of¯ fo:}~jiV~_j/Ѵ9blZ;J̖W'dm	3:uP_(u6Vzy]?q/¿k|C+GӾݢx[6ZݳIyq$[_X-7B}O Fdߵ٣ /ؿ>|:'E4}
WU,-|33W
%2-V_8ZժЗ)ʹɧn3K6r@
zӿhi >j
 g=77>.Oʷ供T53HD76vu~ #G?!trY^yupvVzχU<K=KVpwks u|>x#|l *+_&o]q$&	
<ȓ$;/|- ( )?쿵a a mn?~O|NW~=d߱kO
Hi('~yMiommTM#Tsk+  O`m  W_^13Dg$:xTn#Ԯ-;7 moY] E8;T+hcw?I~7cO y tMCY_ݨx^zw}VPX dkR]iGuj16gVt("E 4>o/1x¾fPIa l\mٳk;\?>x;B|j7Kᮣ 	#_FWkyv^mF	|ݍlRo
tL-SLo~#ImE,4OǍWBkȬ5	I_E4D$~{ 1~˿?l' x BZ恠GOT_Wvwocwgm@3 n /û_~(;QSo^(hޙqjznj׺^O){9I-2E ++/YG|#|<me!/Mg}7R;MD0jP[]X̭/x
|eo^9Ծ'NV/4+}gB}cqҙkKhVfh,ӽ.g| 4Ο >|lc?^7K
/[E<7ugkǕep}:K{[w{
c)
x?ZO7reK-'FRKm>}M)m6ё1)rs_mo>|ߌ'x?>d~=|= 	-|M6 MLMC`w]Mom޳ 0V~ }ভ߅_~x'گ~ѠO[6V:1ʩ
oFo+c_ ;>%c&Ʊɢ|5<Ay+Y-5Xf.~[9~WOoO%/tiv6:4HU.fAy\O+Dї~|C'.Oo '#N<~ų? ϟ?ڿ{<'>]Ϗg
/OtA4]i/|GKZM!}N`[QOwrRd|-!=>1XW_'I
Eú~巀Xˠ^R򑦆5FhֱM߅eE  ] 4 p~ȿ>1&[;K7v{`ieŧ=ݭƣeq}O2?6Alg5N:pXiqtpۜWzlvFߴ.sM"/Þ!A"7&ifKu,1qq4M#$Q<kh`L¾#^xg.Q`<<~XWkջ%5oV<5 j_}BW5]6[["EYm"VH獕uVVA/ i]C~8ۡ|F{(xAE9vfE^Zqх+"4O^}'V'
V7)^2N: f|Z͠| 5tji|)= K+Mfk >fTFkQ5%UxW>7O,5k6WjW6G<2"JH `pZIn?^pa,45)k	˳褺^WY];;~ W<O ᮨMkϷ}OK6뗁b5
1kD ( ( ( (  xN?	 ;t{!~њ~+m魼;#1I4Z^,4ɮXZ4HKvh Ch/&Oď/jxʾ?n?|v թ*/C;P-< k>	.aUKW9cI9ݣgE0ʐ?	]όׇm <sew}/mWƿ	QAC&e}:N$K
t	 m~>/ Ut/O (g맊)k	쿮/켿T)Gh߲?u*Oо,j75T[,-xYbԬdՀmf>ͭ :?x/~֞}'hƺ,2qy4^-ݩAdo6@SGψp<<'g;9o3e $_7A g<9w7Oڒ47;%kGOMbL N
75/[J
z^M,=SYYiMWżUeH\;Giu~O^y)3 f/e%o'Auxž#>(AjVA9+{ha/go{˿__|=_~ !fԴ_ iW.ZD|py$9$қ4(OʵgTOv^uMHE}y~8~_ |"(xjG3@P|k<
sxWC<exD,t}fk0]Y__]bM_R~j-_E6~<^:ֵ.uO[iKFV?fh 

< nwN P?] P '8 mw\ D; '~Q??_j?^P 'm.j-A?] P '8 mw\ D? |m߇Oڍ@ y BGLdͷxt x ѶzS4; '~Q??_j?^P 'm.j-A?] P '8 mw\ D? |m߇Oڍ@ y BGLdͷxt x ѶzS4; '~Q??_j?^P 'm.j-A?U K5oxEe]f޵eZ[$eΫMNk7PIUk;B2]h_~"k  #LE՞>t2eiokgγt:&};x^S)T@ ;*#; {_ @ |H ~Ѷwo	|)h+\Llh5
F+˩o]G,RRa+ja5W9|1ll 45yifh9\x>(S@_\^_/kKZz_'o']t^.v,%Dm?DriqjfOo(⯂_ߋ$OE-o;MKGFl&M7-noN8ݷۧux젣ek)9>'ʗmT"$̲Bܫ!0{ J n_oK
$n5+KF&eI;6Kkw1fvc2k*mn3Ĭ5,NCGߒilտ~j:/:z|۝
4O#T{iT[b&Rw[綹_ +`¾>^Т~+[;+y1<mGA{s gυ_>>|n[O^#յȴ=2K4X_^h&0Z}e{̩W@Cpx 	 ` ý~ vz_Ήk<Q˲[/!TϰOl?1 
?S/6 Hf?Q 
C &~> G; ba 􉏏Q  L} 3n L} w 7T?"c-/6 Hf?Q 
C &~> G; ao1? hD(uK 
C &~> w 7Ta 
C &~> G; Ol?1 
?P L} 3nK__ :<Leon,5K9jK.)Zf;hR_'M|S.6_BաԼC)-෴,,kKQqp[72=> d ɸ|H  V K	 &#oZ2h c|
|io|l'No
ZQ:Ewi%M߬=MlM_"[G tjA7>x@@;k}7Roy0}iKfjKs\FRw_7D:w٫iW/?){mr]Wbiմx7@N!/C~!r:'75-3Snӯ!%h2"#C+(`AEt?
cݝA_Q	Ox3I%f{~l
oqv¦1-ϕq
hUT(i=Ca (a |_|yB-/^=?S/́-TH"^T ~"x'_Rԭ	~.=WxMa6j[56Xc[v`03VMoju2iŴ~|$-O?(o]N#+ӿ}S eg{yr"n;rp?h?f>?aoS5ICgeEUD
$K#6#<Q"7䷃?hg?ϊ7&tG麿VM3U5zjMajvֺżNYԴG<|.>*Q 	G}_[/h6~hd/FEk4Wnn'/
BChAE PE PE PE PE Pqρ==2pF#F`*z :WƊ[0NnF
9]mi O5t_x/⏇	+b<qKڷ==ķZr_KıitWڕZY\<n?lw
_x+Ҿ)x/cskzWZOYj.Ejzo=|{Be:{J>4׫ ;xӮWO^IFO^_?>:~?i  l?OÝG/g;\S.3Gu"7"MKt۸tutmExWSᯏ>a0R4]F(+Kɴ
J[bov-&Cl\:MI=>G.Q[v]g  0_ &6ibǚc_jB"[[٣Yd2?vJ OuٳM^>4_:ž{|Pw>cK}o5ܞ}[ú:Yb-'͡	QJO}e-?ifk~ׯ'İ]|m~%xP> 3u}^k{䗲rO2I'Xܒ\_?U 걖Ҿrݟb_VtU_Sf,y}	|z',{kxUtFM?&Ic |>	JI$vwWGmiigij\\R]\\AoRM,q߰|;
A{XmS\R5o;5o~[=C,V}S@ Q@ Q@ Q@ Q@	2>$~ SUm |%  p eOWݴ Q@7؛ .f;ooofX|nhY̚ω,E\[REoT{
 g-|{mhi>,Z]Z]kuPRh4MԾZIy,C)?~yaGg~{qwH~+xU[/Kg}E΃[zdE76f1.~ir k Tk;H? L|#ԵmoKQx{@^QH}Y DdH[H
DaO?.̰ssM6=mw)BR,5iٿ q:Vߍ>F{{=wg%͌Y1"nVR| M d o{ S7 )xO>|a-Umkqj}WqdRi>ʪ"	;Cy{ŏE}??k N=j Bնy>[f>~'b?/B 0~ʺ ?į>,hşվmCgͧh1hqF\GMk{y䳝%Ǡ?
~|=
4?7þѬ3Oo"#/2i $,Ğ
( 
( 
( 
( 
( 
(T#K|Uu/~8Q	x  
h>{Lec.\Cw\Ksh7[x庝ៃ?S>v =/iNc`.aiuEw$3Xn-
-8
PYW
ʮQ\%GzJZ&W].n~_J׾jмuYxw<CoG^_K 	o>XX,fg?«ٯf(|':
Ecgkoi=Ŗc042rm_.IIcގ%BxنISuM({ieg KPվ#?cO|MO5Sƃ}J/^IAksqatw% |Y5/E&]I.l
*1&+Fw2<vifVĪbadzRI;ZO6^_>|@QjN}vMn/y-na`t=J7W]''kxGfגzZ7׿f7~Y|6<UڡB_>(EC>	s)ֳsI~e<vO^!'Gd^f>6OHѼϷ_uPn~*] ?iwouj-L5]SZ0L6RgVi|)v<T~?h׺~О=%~zOxwzT0\h^t7:Ƴܵi0K{&AKzooU\~?[ͥ;NĞ!ko-1h-v/6bf3B
( 
( 
( 
( > d ɸ|H  V K	 &#oZ2h ?? Gُɾ9-B(*x{Ð[Z隄XGGjz׆Ixk-l_	PjZ^]ugΫ-Ŵh"1VV	\O_ O۳
A/C	i /΅KC<=?7O"!b][ڦY#yŞ^ a+sx$._;hK;Wh; \}wp 	u?/ahxS~!oK47
_wthb'%.|>_v5Myyws1
kX(Qd(bT>#R	:mI/Gޚk~5WyX& ( ( ( ( ( (wPD|%>=<wxQЬ.ukm>Kl5k-3U?L4{ilgWRwC |k	x[֗>
J]%G$%QsXW"JUS>&\,T輭Q9Q9o?~ND[㟄>4'5^+OgkT"U<:şGU
|+[$!>V 44 AW?xFWIt_K>&VfC78~oǠ$
Fݶ*>eR&ݮoAX7<:g+_F~._ g MxM˸G/^"
kM}%75X_\imfti*9mL!n?
<	?؇><|Cx] x#]|CA&+,,t-`K!I.nxw*7X|/ iψ~,u=#@|qgz+=JIq<y#(&/YFIV*M>|Q j&x\y- /M·Zeck-WCn-[On{kX; "KG} -Z!h']̲Zi?iQjC+OtR\\Mi=G0
)So_7$)5=G\??VUAm˩[x|Q#_h 
( 
( 
( 
( > d ɸ|H  V K	 &#oZ2h 
? &G_N
߃._j&/|O.='IN,f};jw GѬḷ\y*x\NV~v=zzRWQ_uj
w}/ gk?g
?Tnw K ].ghXm-/.V	ta<MXP][j| hQ~ ~~nK_ڥ޷t_=ަ?!V;;E$Z]ҿGT!-QT 
( 
( 
( 
( 
( 
dؿگ5OOz孭r.b[zѬY<<f|S i>=4 N 
#|D5KM֚n
Ɍțofވ,? V
C%oxB	Hǩ]wf.lPbl46|?IusRK;0);-#"W^>U E_'ㆡG?ڛŲW[?6r@M&-h˧1[;Qfϳ*e}(k~>V M|V/%U׈*i.YS-ܻ3B8 4yecItS6O;y 9'ڝjQҽ 1y%QpKO8P{}}/
A o#G?eV{<gogú;:IMIo>KRa{	Y/bsX_⯙͞ ȶW3o	 x@?mw/$TԚ뛻K׷XiPMH>7zG Q@ Q@ Q@ Q@ Q@'MG<e_v_L7_;}@qߞ>l%u>'OeTVm.)aG>Cao&tVKHƚ5ջٕ?k&?H#P߄uCj~׊~4	\:mB.t_Yamd9c+<v;TOm/.w??o/Ch-4jz.`GLH9L?j/="2ž2ھy5UkS~~̿!||Oi!2*yxib$y$DoOP_e ~/$ע_?!o=ǧ=޳a5ce]j;9ty4aop%vVOeVV\8Q@ Q@ Q@ Q@ Q@ Q@t  ?"#oғxocCvq$pE4{y,S'Lo>~?|SIMBKXlmm,,+xWy4K#~h/|d 2~&h
Ys~o2 ¾ηt2dO2'G]ە#꣡J)gFz_F߇ |SOi
<U+?bGQ|5HetsirQW3O ^v]?oO׼=ZZu 31ٞvMX7CN]l$1xZ]hIQī=&[_;8%!-۩` >ڻnw.j ƿt˛;CXdR4:wv[FtbjW|kh#=?:O 0tⰟĝ{:卭x5.^okk-ȲO@C8^INU,Ҵ]j=֖|wz~ƞ_>ދ?/{?ÿx[5-sMtYՒ@Mm2<3,#o_
wO)
{{},<"YIZ[[G:vQ69g	]~HAE PE PE PE PE P_L7_;}@	2>$~ SUm J'(|h^OZᎃ+:Dm-Rhn5;ۛe=>?α
܄ڊRc);$~>~_Ov/P7ƾҬ<qf
.QmK ~Z$ bo|K3Đ	M?ߵWC	xdO:|M7lg4C\'SJ-y%ʛkˏ3ϬxRg*	ZWS',U}#jVVk[[^~J j n㷋xGQhV>,ktxD-.-<A
C	Hɶu7*VZ|&T?h U;dfNYLE6uMuX$yyq2Y<VYY]?OElkw u9g{  h'-#w_^Kmcź&$eP.t{-F[cIr~K'<3gOѼN6pXV6Ѭ61Fq" rjjד昪R' 
( 
( 
( 
( 
( 

UlW	||cmCĚGl-$A.!U,aiwt%hdHgtX\\  (_qkK+Zigz\DWw3.`tϙڤ"@fV_?kV+ݸj #	e?+?{ĝ{ΉT0{_RWv7~Y,1~eG i!fxX
ԗi&k񾩧&Ԣkў='-zG/ C9$_ O?x?h;ŭ&FoGhMCKec+;X[R1đO5@ѕ*tBMYJ14{ۚrK ʑpgg}_k=i]6Z]k
1FD  _K]  p>'9ɶQNyഏ5+

oN|W5kIxZKImo3j`Y[y::*+o$ Z( 
( 
( 
( 
( 
(/&Oď/jxʾ?n?|v թ*
k >3U Dر?gh-'jkVs]jDlM뵹J}3QwŴկIJ9!3d09mzw<|)b'+QY5d M%\_Po& ( f|G3U_>:EԚli7w2E42ivA,-F$+.S-GE'(I]U4}òξQ9R^i=ǂ o n/si?h/O,w^ 08,tm'm]@D-mI&?CmOׄO>~>G%5Ƒc=wMc%$I;Jf;GK}/{Yn>b\a9kI_c ~o'?!xOi5XASC𞳠N_	j]VH1[PNɨMs(~???e?ٗ [/<=__N/|}|ݱ3uңN߫ =6cڨPE PE PE PE PE P_  AO g%AK4yOX漸\K--"-\	ia;P➊ +3/Eǟ/:I'T(>W<G JӀ?䤣 '>',	kIC_>+|2]NOu/[ gj}wvs7)$3ysCrpH?I_LM`_CU,|@M]
m}m3`WIfFY_ ( ( ( ( ( K	 &#oZ2h/&Oď/jxʾc |U3?w3ᧃ
C>"Ծqs]$MĎ
>;_m}9mHtoEmo$ڶ-bei|~ge
=ܢ gqJOYN)z#ӥ~^~4|gb g_K+e/3yay4^T>h.R)U"2%h wFh"d %|ig>xCY$C.l$cj7-Uo6\$Sc}Lf|aC[qwq[ݫۚϭr)rtZ߹#Zݫۙ&{Io=' 7⦙n_|7Y|YƷ펑&67S\\2Krq~O{sK?W?w 3])|yWv:TW%HuB{#s[	.m-3|"s{i'g{_v^{ŬCiZI_iiK~߅|3YVaohƓy
ݎcsosmq4s,nG*3+) Sר{AE PE PE PE PE PE PO?Dɯj6oo/&
Giits;{;?cyH9 -@we ( e\ {µ^ 7Wp ґӄ2ם W1  Ǘ  Wp?$ - P/ o#_6xekpo'͆OBdA,9?j ( ( ( ( ( K	 &#oZ2h/&Oď/jxʾ 2B K(V&_}w |-ZvU֙iֱ닻[+khI=0ƭ$#?eه7Ce&{;JMWfmbgXe3Kvin$gFfv4j8l:{7d=׈XZ<*'dv~L:  H9{
#9yk ѼQ
DD5
:U2y(˲XbwN5)ɩ't֍5OANJ3ZmQiSMkt>:|L k? o?`φg?:֥P^}ERJn<88O#1eq1⺵]WLf^-$M]uZ 
( 
( 
( 
( 
( >2 |{e'_@xoxSᏈ?뚓؈lD,'MU/[4
 ibG!#u P_ Y q/s Q
x $_ J:p_3=P?|͏I׸WKh I9?gIE~y'  <u|) 53ះ xH~nd5mbQTICI廲'wF_ ( ( ( ( (?n?|v թ*?5>~˿O>3`#ᮩxMG_꺦 	75_Mk=a%e%KK}'#oQ<O Wë_4
hp-I}$-7O)x]'Qr@ b?m߂9:x|#f<Dio|sx*.	wך2~ Q>3o| 6~~ > E1m GO /Kʿ_
dV/1 O?{1 6lsڐ~ Q>3o| 6~~ >Լ~  !M ?P a  ?n'? җ 
'= t??~ 9G ڿ?X>ɿo
 T~?/[gi|$᷋R <Smwi$3ukso(46$Y"g,K<m3U>|yT 2χž>A{bټnukrЉ	giY2̯Ж)8yc|
aԜ)s{.;Z1=##wQ 

 G +'#oR »  | nw <J4 

 G )?] P ~ 6 % y  ] WT?<. FOWT?<. K 

 G (z+*O?FĤ w C  x »  | nw <J?] P ~ 6 %A?] P ~ 6 %/+*G?FģA y?  |] '#oP 

 G ( w C  xh- w C  x y  ]  ࡟?ů?Kki__w ;-R"K¹$}Q
CG+ 0 t_ S J?WaO 	(  )?#  J<  ~="fNX} n߷3|ϟ`ٹ^ ɖ}.u}|ܼ;xf{)#^?C , /u{  k ^F !  Y S? C#_    ,L?# r>D }  {Yafp̾9T/[~y~Fuq^ ? WaO 	)??__ߜo_7Q!G  	?8}#Gesn6WT, |Owv OA? Ͷ   w CO< Ͷx K@_WT, |Owv @w C?O>m.4y?  6j'/+*>c'm;Ch? Ͷ   w CO< Ͷx K@_WT, |Owv @w C?O>m.4y?  6j'/+*>c'm;Ch? Ͷ   w CO< Ͷx K@_WT, |Owv @w C?O>m.4y?  6j'/+*>c'm;Ch? Ͷ   w CO< Ͷx K@?g<Q[Ʒh77&.K&d՞5{ج*b4	        / 
other.JPG  	@        }1   h JFIF  H H   AppleMark
            	
       	
   } !1AQa"q2#BR$3br	
%&'()*456789:CDEFGHIJSTUVWXYZcdefghijstuvwxyz  w !1AQaq"2B	#3Rbr
$4%&'()*56789:CDEFGHIJSTUVWXYZcdefghijstuvwxyz  1!    ?  dOG -\w[tm'XX_Qiֺv[YYoeckmpAx$I ?} ĭ =; ?} ĭ =?Jߎpv E%oi n~Q> Vp 枋÷?g( +~8OG;sx   4\.<G [ z?۟?v?Jߎ ?} ĭ = n~Q> Vp 枏v E%oi]-|o? ?~<~ѷ.#֣Wh_C>*]%ɠo\"jol;GL%4o  BpG; _, 9 os ';, D p u ހT'ø?o`< K 
v ?yø {P1& o=o¡8#|珯
 _TM ÷ o ڐ|"a o8v  @*?0Gx ` D;<` =Ʒ oy÷ _z?P q? /*& \ H>0k 7;` 	#O<}R ¢l|up?i[=E  `?GM[[f3 gh?/mCʌ4d/&O3M)Q@}fcO
jχ[jGڣYk`qOv E%oi n~Q> Vp 枋÷?g( +~8OG;sx   4\.<G [ z?۟?v?Jߎ ?} ĭ = n~Q> Vp 枏v E%oi];sx   4÷?g( +~8OE?۟?<G [ z.a ?} ĭ =|/s ?jOVҾ_?ǽ{ƺI,_i|/ZCorKkg2gCp՞5   5 W HA   5 W @k 7_o  *?] T ƻ  x w  P   5 W @k 7_o  *?] T ƻ  xx+	cǚ}|jռndþ'l5[!'ZnM	KZα} ?} ĭ =|]>>"O|m=+jߴwŭnTm'Qӵmz۫i"	pC~QHG_L7_;}@ Q@ Q@ WƟ ŏV+2o>uwk)xZT)Xŝխnڦ$m}6W G  |͞+'[YυzYY>X-̓ܝJmz :ڃqr Y-"kx+Կ? ?kxw-kTm'2$YmDmB%XuHZUcgz7S x	{w;|_:3x{]jQ{IIym76v6S&6?WZ|;cAhxLǌtVQᾓKS+Iy['@b[E*g' f eWMW>
mS'6 4;[Duffwfx/X	-KNn?a ا?ς=NA
YxfcNK!ӭFQ1`h'
~m/6_^ou o_m;>-^Ӝ4NBkw$!atگ]?4 J	z:DιƷGigo-BmXeEpO?ڟcſ>]2uxB5%ަbזj"Ubn fT+ ¯x~^"l
rg߳;2?6]&|7 S c=k xᎩW>+ִ)|-/V4Z/Lvg)\AI*/ϊ6Cc^4_XtCȚKiG|l:2<A eOa_:ī[𝯇|cO1\kzdvf{>!%TWs?k <[C_+ @M'\ͧt)=_;["[]ipm--yf)%V& eL-?c_xWľ8yFVBҼUoKqMp;`쳢3F &
+|.=jo/fM%Eݣ\sHHE %|u?0y;/>nd{+
/bӯD1%h#w$C/¯h7
?~(hum5{24+R5"c$j9U
( 
( 
( ??ړ4?x|E]~КþuM?YK dh[΋Ņ ,?aυ?toG5k]0&OzXSZέa2G_i4$c]x NO[tikh9S FއCQ/=
{I]|D1
V/bkan--wwk-] aci S1᧎|?i
7̞[9ewI;YP$y7DXS6xпkW~NOSx{FvD[LZDRJM ʙ= 
  «  
$ _ 'ß؟۟g_gھ߳ }|l}Gx_/o[
z-ƭ6ZUm5̱Q*34(ǚ/K| _O5]OQ!"IY_b©#tگ]?4 J	z:DιƷGigo-BmXeEpI`>:c"-#%~,|k&rCqa:Gie%,"FO=  ῆ0~ 	%|^/?Ct%L,7WSwute%vH g?eٛ^<y] ,  dizD }B}?dن3> 8?ho{;5S+?*_6>&MFS׭uR-)R)D%V>gk6j>&
&jO&fhtՆXZam1mE  cP\/6x\cᦁyGqivC/41L$qP@W/x?dax~#$k'B5 SѵGm/I]Y^^f+
k &Zh?n?|v թ*
( 
( 
( f?m)
Wz A࿂vpz?,|cmq*kֿ$aI#koCڏ ¢j/\>>!x"+ K_[\Y_y/Z]]clށQ	 o?_9|l]֫.hwH`%M=aU221G /  A b 'J ~}b7}~_'o_ϗC!a({W?g ُſxƖ^\|LYl>[jWd[ϕk3RY~?1 f _|Ma.|;յ9\L,qol4֋mu%l
m4k,.R~͚r ]O<m᮫W2<uɬ^uYZXOkmkakq]Kzٰ?#?	I <?o:7Ѻgqo<Ox{V6׉dSFiW&
~~/?bo/G~@[/?g-}cste^I'$yO;ǟogx|X&L?|Yggk߼qĚ6Mr`2~
 {jMw	 0CO4O<O@Xt=;^Z]^6v)s%+u_Pl ?j  ǿ U7 hpj:ŎcǦdӴ'-gFZn0]?3
5{x><1V?&gĭ2WO=ܥ֬(; (u?Ŀ|kS</uy}O~keKQT򡳊G{+,lBY? ?HO?V~ϞQ kvb/x0YAg7Og~hޡ5ʋK,ʨ]O ~Ԛ
aƟ h4x<;>zw*I.l.SbOKV2 gD"وz  ~ԟ	|rnO??ؾ0ޱst2Dҽa$y3Ak<G/,{j4VRQ@	j_B V<Z uH>}b۷ekk<3oyS ( ( ( ~x mE|_п{@~&xk.4E-:%ΥuwiVOb#x?/G
r~*  >3E<}+6uԴ_Lu4{ OC4?'KGǧS	I/' _>. L>*~^  i~ӟKWXMR=ށizݼG"yZ13E$k!kv[
>|L>-i43v'%^,-u<vz?1t߱qnDf]ƙ>~ʟ$ï_⎯
E~kemk5ee
]ݲIly6> w?n]' ~ZC> UԴtmLV6
~UMHGG	!?fǞ
ៈx/zo
+x=~mebvi.n_MsfVe ko^ ^e\?dlePH[w
g5O_H;ױ:M-osqJUinRKfT;ھ#'?''{E	/|mC>~&lt~!K@IT5	;xFյYSs-ͮI ~Kگ'6jeȞ*5>"<? Οjڛ~<riEc"6[b%/Пo |)'@>Ⱦ g<Yy柪xCo.(wMbi$#~}F?_?ll'n>%|w D>
>F!'.Km+ژqZ>w 1gAK	81OxQ-#Af! j79fDZ12Oz _?o؞2|<?j|cG
:NU_ivqًHs3MЈ/.-aԽ
( <[ 
'6jo
ĚՎℲ]ǃun%k,sA,WPKH"{ 
; ?iOE b h/~z~+_Gf퉝Ɗ K	 &#oZ2h 
كO !Xx[tsRvQUQI<
HO4Co$C? |q b o/~8i[\zz|m,:<ku\II)OJ Cg
h<] |g(:V0j'V\MϨY藾Fa F;Es
r~~߷?t|:<pxMT/|9Ԍ6"J
.Si$M[B +/N;
 eH Y΀??f/7σߴg X|n^$1I|A>qK%.y&qs5({%b"?nړğO esBL.H=fM&mԦed5uNva /m//a χ3ml>! Uqw|&,CtE7Wb9?/ ; ?~/W+ 
S^-5MjXpG=֣Y^m&Xlo4;O9
ͭͥʹr2\+0|->+~ʟ>~'uj~mm'\Zmj1JY~$x<u_ٶ~	 ik1~[|K.a
^<7zW/4];(,4u6n$X?੿SS eau|Y>#k_=3Uψ*/^>	5knnB\ E?+oGWj?)Gï 
<!M㟍!`4[{xͭ@kkӴY^{5Uh_	?i©e _ 	"l4ٟl I|#_3O
ৄgZ?
VZ %;}/;K}sVµ{m~GVKmuaz-q%}+ p?) a&z߅yc]=Xn#ФRe|ַQe9ቁ|\ |t-?࡚6 o|sb>(z'c=CFԯ'(ȰYK I,ƪ;tqYW,|! 2KSx_N{m7V6KMa0]D`fY>V_: P 2?j(G~/?:꺦{FtbG]K/n#ik%΅g// 
|D?-䶷ʽ[{%]ۏ!de	|] (^ h:- ^/3KC-nKH1plY.&Ǚj'bϩ> {t ?¿;
]; aa\:U햝ewYA.wyLsxvXK#}C >* [ൟ_|u 	Q  fi`njP`.nOf=JƊ|%'R Z
( 
( 
( ?~ t  Oj%|9|2-LmVJZyr8IZ(|( 7_	wட//<[x>jMmݎdIYjegCpt\w] [
ßψ.)"&vv~֟V;ij^\$wRhIg4S\=??#{ g~ tِ|7:wf 	\ǤA6 JCMO]3r,n0_'/_ aF}x^L	X
@:F'Pծ ⴶд}@[Z W
x	 | u_[zX.j>ttV7Mc.jj=`.ܾ 8'|2>@+IsT4کCg=mNU~RQ@ Q@ Q@ WW H/L~P'MG<e_v?
> :_5-P}64_<;}^w.}Ʃy{,phdyYx-V j5l|
2 -u
Mj>:u-f|C[btɊ,Y\G4q	4usȾ3 _b_7 #eW3oohmPmJxMdyOI8hqy|/WǣOĶzI^^aҽEiu+f,uՍ[I'.QZCY8} &qݺcMAZROM
kᮍ߆Ɵa.t~-OX÷wc,~w'5+u-
[JgogOB?<!xGբ+kVxR%&XERY0`rf)+/N;
 eH Y΀>] N>x|aSǞ
a.Mv6]>-'tZ2YY%A=&mHO)޿~Ϳ?x⭦msS_
xE4-kjmVF㲰VVhYc[DQ}	 ;~$i?`xŚ$(ƕg;t.tߦ(g)Q/8'ٻ*ᗈi3ↀÛ:AŲ$:6?"8^IݍC[>B* Owψ5L>_k彼1j?跚έi{ghNBy3DdAx d|'G4h6t^G[}O?&}R PRxHB{y> /?&޿~kkM⏉ֺvj	[Gs$3%_K~Q(|CFֿt[l`jnNix_Ϩ&6hXoP ~;d  xP|Y 6y_?{> g; b~_><x϶|i<}W$!?,l<5}ho~mys!f눦eV ?d39|׍u	gPt;fm/Eldv3$<??Os4~7>'[i>=5mk[,m㾊;k}v3	RHUe[Y`i_G_'7mm f;oGSyK95cӣӭ#-$HEa#W_ 	oxŚk:%)OjtOϱ/'ATZB<9  xSgO:ͧO 
k:ܶ*t
^]vWjWSʸCe>ogǿ"i.⟰i[>+/oCIaF&[}-Ǜ" EğJa d'	k ( ( ( ~_g/l<Q_3\$c
'[+Y )9h&)t4u-3	^W^  \7:8uMz{6qvN" % .lC?UO>}BdI^ka&5QM3W7֑\*$p@	|LԿmS-?ZKCt+Va{5l&+'r) ; 8cHIٿm5 xx6'uOgIC&jZַw}2]A3+knz],%[ѣDöwzn-fGҭ/-9n,bXDjv} 
ÿpik `3OK5?^gڿ~|_dg?u( ( ( ++ $??֊ K	 &#oZ2h g G4B^ mbIolt)#I75ycRC:X (G_??Fo/v~=<GZia$MKK43 hj55Ie4Q% >cHmd~O?e  aWй65+;ȷKM7=0I='D>kg2~gߧ$Ew~ ޼{~ /=~  Û?k:_J42>׆,?߁߲ # k߇Z¸o/n.|Kk"&yd$tin#!ZXldɵtGkO o;º g>5	4_~%ӵki-dXex$h4lFIsT'Wfυ_|gǣV>|OeYڮtqmmI$R>cFꨛuW_w  ~: 0M#A 'O4+ h<Oc |i d/goa`h[xc	NωF >_xr0xR6ukgL5i{7DXH[ 5_
?_)x0: _UѴ+-&Ob]V) Oj °ۿ(?| owo~9Ju?g _O?yW<xs>yxoXRa khn.l!?֯98xÚ$|Eh	OomdrK,ʫM# ?i_ؗ e߉jhg橤8u|[_
ZjGl'/uK
J(=.m5Z5dI!- ?i=+ C~~վO6}g CVna4ATy%~if]ZJ< h ( ( KOc0  R?m PE PE PE |%  S 2< sMh 
( 
( 
( 
( 

?c	 v ê > d ɸ|H  V F
y K=7Ln]vhqK4zmB9TVe /xsþׇ|%~Ҭ3Lma-mmA#(M(UU 9Tn'U[l;KG._
gM'ëVkiAjNe?ǧ鏪r0|~z~({z~4Y 𗄾2ƾEkO?=eO5
G:T'"geuIIJ$`o[ x }~J?{i>3׮>Я~X2YxG5YƣynͭI-4N'wrx=YUpwlwvND>??
>xkw{<]7^o+?>G4FM'[?(HլtFu1GQ"\7S*~߶x$ ſx=f?hv^o|Cy{w[/E{-8?m7h0HSOW=
TZt g ?i ??a⏃*S5w	fGVIHC5MrF,_E~_S5 g5oxbmu[ zF{=gYh ( ( ( ( KR 
 ª AHg 
]_^yl g
( >F?_cMP=A`h!
6Ѽ=w  ?	υּ<jiY7|M>_71y|+1\<+ToGp{+.Nu[ۚIzX{  +?i/ ^7MMJ״kãXX,-!k+]eq2!_ڕZuRv7*QYt{;ӿ
+C(?L'χw{<%Xqk>meG綽,*$h 
( 
( 
( 
( !g/_
7-V}VK-*6fX(y]QQ 2🊼	 D Tx4oh ~h֗M~qmso2M22@tP_L7_;sYO
x[I_)fjVpCw}cr*vP覂)P  Ꮟ!kϊ xE~-}1Z\"KV*#~dHt|Ao؛ X/># bli}DȎN毩u |??|Eǋ3i>ߨǪi1ͶG),|F|owg= ϯ9"8}}V{ __sձE Ǆi*4u 	>}Sx_kD
Q|1y_oGٟ*	u I{iݗqğ( 	
9[|1x{F[{)/$fӼ	4ߋuu[[ J~c3|dʋIYWm0W~gAoZOc c.l?KxK4O:ܿ;?mt/Q_Pxfi. l ۫6nOw"/?~e^M"oܽeqC&sZX\C<oV4xF	rpN{JJ}*RF'/'_ǋ>|@g}G=!tO b7kvI[a{}$I5lo>[WOiٮ=>5MOCIǾdn.ml5;COH[y౽zHB*	em]ޝVsn=l~!΃{3QҵOl7T8m[k5ݼ2r(Sѻ{EP ( ( ( (wk_V5Ծ0A/4o~:elcE7춚u'Ĕğ(|U
kF~>>
kWzֹ5ok[H%iF#-&;˄WWUPE   |* q )ῈKnM-Ou6;KxbXJ$^ujF)UH5s,)NIY;i}uz-.[Z~?K36_.,m,6ֶkg
SQ#M4󲙧IVuTzeJx
.ZpZ+շ݃fxJ<gۯZ9+  |] w|Mծt$^+}C)h<Fo!4(!YH@ȭ&_gkdL
8'g8iC	 J~^Ϡ
3xJ3ݥ|ӋxLPZd
57h.
V2 o	?ßV&5\[}Mo&#rƒ.~5b{8%øлT#{}u:Z+γ  eMgZ>&_>=&7ӾvSO[<onxp@ Q@ Q@ Q@ Q@rjox	?/Of/aPѧ9PkOko.]kT>"6 M?<@v@	2>$~ SU7ůgOhECK-ζx̆Y̉vU <K ~, >\^*[*Y~-tedZƟ__[N;ՒI`->   wI.U]'Ŀn?  R.ѻ.~m _U ROh 6]]_^Yxo鷷]%
2M:={	vz_؏>'M'gjMV4xF]Z
B"z~$b(e:OɌpNv޽^.w^eƕ N 2|]+
 %{|goN3W5#8m{!ӴȮCW{ܕw _}4ܿ~<ckmUtɮba)`6hg-#uE-b.Q?dgX|>Xx;\Z纺做Yf*%iaPƉ ?b8 T-ua~gM>Rucq
óJ%4]N]#HҢ$
qZӼv丹O2+ʢi5{]sNE}~GL|-
վ/x;RޯY I/X:ޡm{3C[ZX5f$@K?x/Rxׂ|3Vċi>vi>
GNF\EDNܼb[U |} sw 0ǿ?%~@ǿ?% < , -!hK7 . c 	߁ < , -/1 Ife߁1 If ai??hK7'>@__c˿ |} ww 0A!??hK7'>K {C Y> ww 0A {C Y> ;; ZOc 	ρ6~*cs'T>GԳo{o6:hקC̷eIW?xOxXw+/, 5^kWW,s.4mDAE P#y;Tp2xnC
><&uh}[XhZ]CڤH%$XyY
	g񳪎4!M}]W4g(Ykn뮉 zz'kC$FI'G$I-TI]/?~ğmgǟ
7ĿsiPj_[-{ӞYݛ"C{uHw~6K  q>~ϟ5$[ ŗ; YbĖ{H5Y._v#~nX<Z8*n+^ {bS&߼r е
kφ<Q&o'tR{K:1żdXVuH5g_MWoڛOd|-Iwj
h;AkjV̘Yv-stiPЋxPO*}ӿəJ+)5gַ^#E}9)oߴ  >?=Oika	#&h'I#G_o|7n>ZGz2coi^ &TUS%Mu4" /ƿQ_~Px'|5cºWhW&n4mVoǦOqcz4+Z '7dOy~k>	a~3ѮzVׇHGCU(?n3[  ћ| Ēw ;@  C 6 %wt?f  $] ?f  $] XT?3o^. w@'$   ћ| Ēw ;4 
 Fm K?bP ; Ix    ћ| Ēw ;?bP ; Ix OXT?3o^. wK 
 Fm Kz,O*?I/> |bͿ>-x௄}}9;x;I$+m-υ5<AMwXl~~|76k5OQuOk{KT59/KɛjqCaQ 5 po eOOPݴP_L7_;}@(s;_xMY&4*şu5zupq]scc>ϗ1;tM/W 3wMTԼ
}2)|y]ElMs$ב-cN3
w? a?f 	Žq]c ?xK~C|7/~|%SZvZsw^MCoomAY$*.X	RAΡ=
 +I=Yw|gaæ/]Eywk
#m0yʶMl%luXn^Z __&,j7. *-~Ú>*hKdDI}qOCm4	*({f 9gg)Ӿ
q}ş |mY/ rjZVas
hO rXn\̨є]NqM6?]	(6D	<C*e⿊hv/	 kG%`fġ%X
?g_cO>&vykk^#<#,w'񅾏l.Ѵ5٠eaW[[G,g!6gE|iL|<u:}|_Ť?
 g
oIn3{jښNRJ֟/𮡡w[5[)k2SjZGo3GG1Cmimmkeg E PE PE PE PE PE >1קJ Oxs_Fxc:]N;
?Nm&.GB$Ҽ;URHK4b]%
I'h-۲r#?+Oş=¯ٯ6Uj/KFNH+ۙo;om⺓N,\VH|oECq ?1]A5Kw iWKki46 :
I|S]gJ%಺pԤj__.)`QƦyV-z: ~п/~ /vx/8^v
x~uOKXjWhPwikoks
׆gxQQ© 	֓X^*4|+%-!]:KiaXt/t{/o-ԝFӏCr'b5滍s -eO(7Ym-/eůF'l-b8##KKqmy<' ok G%O 5Wr/:%Lihiu=L)[{}8$ITO*Oǩu,VGG.WV]z-	﮷Ï)x_<
Ex+74rrfxO;kM#*\l v7:J;& EY|%  /~k3
9~d?fr_4[t5jP h5OQ	$/?iOOw-Ɵ5l^z٦m+CҒh!cLC173[q=|O_Umi4ifI_xWg9Ƙ}ΦuKu<U PE PE PE P_	M> ~ Sm'MG<e_vE 8P zy˦ ji EѣOj
k-/Ŀn'PN%.EF5ǧ Sⴏk
O6O? ï|]"~Oⴻ+i-NkkX4/O}v^V-3gn^빼 <)_?:jETOˋy!v{a~[m/uo&S k|2(uk
CCukƞ>]3keҞ;$ym^[6H\
+ e5+[vtZ_}umykp9) ; eL_>
z -4[;-cZ\Gi3-%dڭM? S~?gߎ_φ~5|_jZavcY\jpM֗qUwhE$t+хzNF]|v~Ѓ£Ǿ#nM q7V 3}Jyi|d/$k7o7 |^?ƾ4)_<Lu׼G%xRJ\Y̓#?B ( ( ( ( ( 9wGWCnF5{>~k:RK agͪYv)nmiLI= ˟
?/m^]?Z{M Fk6Q"-Җ-!24kĆk{|KUjr_s|,`) .v~~ҟ6:=UCw߈>_6Mmp%R&3٦1^
ᎡM|YkKO~AO4̛ꋤsomiAkda[ZXWÍicq_YW-շ~M4gh٫O |Y^xu/٦R{5oþ"m5O]x-[4^~iSƥx ſ|o7'|Pd[6~jd7HVNYess<wj&U`k'JjsidGs ƾ׼Sg>隕WV3A*MѼnY]+q i?D߁43mX_*(4
7<$yr)I%mQ  Gw\¦Uּi隥֟$˄|^IjLKo	ư}zTq5<Ƴ]䂾W lυ ֯> T͟IQU}}~4զ/Fm\n,Lf7<QI
h tmo
h ઞ:<E4oCi\j3zb
OWlea$Q+?i-B|QQX^ G>Y<IoBmuݯ/šŦYL4@>ꢀ
( 
( 
( 
( িn
 |	 թ  K	 &#oZ2h ? O _O mO Z{rܼ>2` kSNg/f"<'σ G})qK7OZ߈l:f0Px]/rZ8[$$UZEcه3 k
|7,| i{uO5SO-6TԖEk?7t1XY$__-~M?jgiOgy$\/?yxDԿ>
<a&n}#Q[kGS,:Tϵo$o  7كÿ ~x_t4=MGBٞBO4<Ms+,J$JRmsՕ/cd( ( ( ( ( ( U0|Y<K\0K 0ƙiiRŬAYhp-w
u7?_ٷ~ޏx7گ n>.; rTYjQ,Ϧs<C<K]u~0(?k{U  ׎>4x+Z>%|' xR_xǆu"Em=&veM6Dl9 u>;#ӽ+B|5>4۾	Og[i_|IKic?]%<Gvŵo;x-,9%T#)NH$1iIGQe:qmgfkߩ!`w[o\A~ ?jg~ok |]utCskvVx-i
bh?auq]
q;Ihpf,/([{kZ g[W G񼷩kc{ψ[ZWwz֗4f{;kk;,l`>eb~2 | <gj*.և.m>5΅!kh4324_Q%NSzS  ?|{kEK&FuoxBMiẐL0G[&g=?~/%zg׋<IiN,Ze׉-um';MoŜjAmo6.⾚ >|.%M~y|=}J4 >i.g--8b&Yj
JrI( ( ( ( +/)/jx2>> d ɸ|H  V (cO 	|N+@]3M+Lϻx̚hM7I* 0 >?_xKUkw{ڽ	C%{t^2͵,<|\GOҳl֒잊cOA_?UZ fKw4 
lMKS
,TR\^vvPB [w\71IۢKQ7er$/))|SXCe{}oeacZu7xrh&m3I6<_]G"-生LRTWC(E PE PE PE PE PE   ~L3T/Gx+Eүu]s]܈m
fWPib	4@W?=Kռy?dzI?OziYF MtWMPI#~" lR zq'j μ4o ?`5Ƨ=^:פnM_i6N,~&yIE6':-uoLppA?
/q} d?Ŀw_׉4$[k]q,6{Y$aJ?٥ʙ!礩8M\ulfAMiגM?ʟ r Q 2|-ọvZ>_4-DPԖ8b5v*搪R I>Lr>S
PkyX!)(k~pUqIzBYڧ	K|x߲ÿ ^2V~8uk>";-FAK\;,I袊A-iX_rgJZ~
 Rck"P
WC.F/x?Os 6a?2F[o8|<W|0Q@ Q@ Q@ Q@ Q@ W_S_7 _ e }E |%  p eOWݴ Q@Ưs|^ C&⏉;;|\
T?,$PEQUݔ~;o音'O/C
톩 : l.b|~ɪC8u?nnoa,%rbh烪ӵI>Mu:'(=Ws" ~_ߊs>/?7Ko| k3ɶtS,oiqOrG.cJ:Vkk^OM=QX e  Ǜ~3OP]*/%;;KhAUi.-푤xF^ia^Tc	$|O
`>,_ O|ӷOuoiZlA4"k}{T{G] 7}a_ʻ52H
( 
( 
( 
( 
( 
( ?8)?P__k۲sk~{h[MQ.mUSQU/"V+|W u |JL'R5WT<cnMQ&;R4APþ9 K/3s>3w|7a;X=+V5[8u[+^kycwu*̬$WKZƥ6TGFzzo k_[A9x!;_kO5uŇŞ T$v&}<fxZ|sOoX9d[gWu
^>k khzV]?h|ȝK2jO[Ҽo^=O˳V*N'n'%&<p=dn	_߈|c-~Ic6jVZ]m-cG`X2G(s=th? 쏇o6/k1fk
f\>.#t	L
K$ ~h
~ &<KAg .K,4;kPZwmkiɮoxRK+(g|_a5QI9rf||vo9!Go7ӷ_|x&4_hM֗M5͵,A4R"Iʬ ^6
G `o
;!/j~/Hڼ..bu}s5_{i`Wf7E/>k
@ Q@ Q@ Q@ Q@ W_S_7 _ e }E |%  p eOWݴ WS ښcI|~43ǰ4#!%zfĐMiwlϿ&e&s8JݒW#{	#xڗjiů#ׯgzvTUZi:A)K<|?o P #'/BQ~>k닽>JҥEڞec
[CiZUqh46{RKKk릿b1\IqM*Zimz;k&c#s^пi?h:S uxV3Bkis+uny.__gO	|~ ٶ~+joxrg;m{^}3͂-Eٱ%-ne,>4c5w={u9t{ ]ڣ	-qk.B<1x@>۫KH+>t ˹?r<	y+YYû ( ( ( ( ( +C1 L' ڿG4
S^z_uHM{hZSIfn@
q~՟/;?i_K i7 ?Og-`e_wy{s1 +3 3  e\ wµ\~U)8O/x^^ i?E gxhfuѤ'e ~n &=1FX%WNkgtϪ=FVgͲ4?fy.\s 
= ; dÞ1Wuhz[○<GH·qFMc$p$
nҵH\Bc(΄񖌕,) Qn\TI5M}>S_+.=wG^Cd?%$6Os b|'m=~O2ސRX\ArVE6}[ky ~<h ( ( ( ( +/)/jx2>> d ɸ|H  V +e
?'$Y߳커-VtoW]]?PiFW@G~ыX1m7Kgߨeu-]l/f,ɱMr/g-mg;3scu|?e > d? !::}}^s[|ϱow6!1
aR7{i°V[7.Z՞5խQ* ]8 n? O/xv+ h4
x^^Dҧxo5KIg9.ma)a  . k#/GW WD?G}>l_m~œcjYu]d{Ikw?z3ٶS"uI5{.	9~ E )(_?5~*4?͡_i*io4S݄ZGl\5_ dڂV.A h ׿uɭ"ײ3N}]<K$+#zc+wwe>AE PE PE PE PE PE ^yo㏋P7$e>|%4[W
. MD!ffis۸[e B; Y|y =Z?䛫8H|ΊB + 	q ԫ8JJ?s>_<soj/]BV&kK&EY )Q$TeddVR}<?_ơu2?c?ڋ_.k/Ce{NmOZThb~36±cɖ"b~PE PE PE PE PE M?<@v@	2>$~ SUm y  Ɵ]+|mZ1C-͎e=v4F4p:Ư,jXgPK
GoUM|Ro|R;.&v0Ė^N(ˡΐZ[hD#E_QS_ڒK>7ƖD/8z/~X~*yg ;b~c~MN
'ŚyrDoy " u	M c%&4QO*h_#Q-gz#n40\
"R|ufSg9^Ⱈ1wQR|]}n|7~4>/*O ǬxT/ gO6$^
G7-x58d[\ٛ繷mn)d/߲7]ד	wcUj2~
KdSyvTkx-oAo\
J*t{gN]{kmO#uJ}*7]$ѫK;];?
W?5?04 wR5ŷ[Gwi?rѿ*#2O_F}`Q@ Q@ Q@ Q@ Q@ Q@aIQ?i?ƍ[sj[./%6VkiEik'omA(h; Y|y =Z?䛫8H|ΊB + 	q ԫ8JJ?sO C4x[;߁?
<_^E
Cw}>'KB;I-"tSBI+E PE PE PE PE M?<@v@	2>$~ SUm | f	ox<I ~k
<7oe"NXZ/?͚HG~{'ÿ~|!+ۏ	/:_ta{M>+wx8V)bHU޵K^]O+,7w)>Y+t_gO8 ЖgO8 Ж??.gO8 ЖgO8 ЖgO8 ЖO\KMn=G * >~y
: [W^YXe~#\Cv'-{Y9Lo fY%Kd 9eIr[KZVsm2w\:]赒w
+=Т
( 
( 
( 
( 
(N߷Kzuk: i/}-R	{iTHWhfy#HE  (;	eι k@ n 8O/yW~P_(3a lt7<%|Ĵ??$ %9 'x7 ڄ	uj~%ca}{Ἱܷaal_
( 
( 
( 
( 
( িn
 |	 թ  `	ࣟ|#k%oIҾ7!oF;iuoޘMt3:+*o!Etǟ?%;qW	#G/
RZ։41mQѵ;=cM̶Lr~}?Exѫs[
'4#x'7<mweGy^m8O0⬽ 	 6~ 2M??  > $/OS <7  *U  m@?_qA??M?/ g_i  ?  S8o _L?(sA?} I m@ |} Obi ?  Sxo _L ?G?S㯂?EĖ/>|0B̮Y|ȑ2KG,n"L~|; R,~xRtSOu3Um
1<̰AHe<7]rR4n%c??hK7'>G1 If ak/ǿ?% |} sw 0A  < , -ǿ?%c 	ρ yC Y> ;; ZA {C Y> ;; Z??hK7'>Oc 	߁ {C Y> ;; ZA  < , -ǟ?%/ǿ?% |} sw 0A  < , -ǿ?%c 	ρ yC Y> ;; ZA {C Y> ;; Z??hK7'>O>{ǟW) ,O%֋Og-o?p\ǲOʻfS?%  3Ԅ*|! *|!  *|! ~0_g^2|ƗW^24ۻԾ^81MLlۚB\fo᳼\wIM~ө*R7 i% ( vz }/W 2VP gGj_#?_Gl笿 ?y  C j_#?_¿"?E[
Xh_tExuj:w~:~</7o~	ʲLts%ZqMZN
j15*Gc  [ ~ O?  \q }  39  1wƿٿ /B|] ٻmM?ǿ?%!??hK7'>K {C Y> ww 0 |} ww 0ǟ?%//1 Ife߁ {C Y> ;; Z ǟ?% = ,{ ̻; ZA  = , -'1 If ah {C Y> ww 0 oN /'1 If aihK7 . _?hK7'~I yC Y> 9; ZB  o ] -ǿ?%	 yC Y> 9; Z׿`ࣟ|]xoVҾXl5:;tވEj,0;os2B?        0 guessNumber.jpg  	@        812   JFIF  H H   AppleMark
            	
       	
   } !1AQa"q2#BR$3br	
%&'()*456789:CDEFGHIJSTUVWXYZcdefghijstuvwxyz  w !1AQaq"2B	#3Rbr
$4%&'()*56789:CDEFGHIJSTUVWXYZcdefghijstuvwxyz 21!    ?  dOG -\w[tm'XX_Qiֺv[YYoeckmpAx$I ?} ĭ =; ?} ĭ =?Jߎpv E%oi n~Q> Vp 枋÷?g( +~8OG;sx   4\.<G [ z?۟?v?Jߎ ?} ĭ = n~Q> Vp 枏v E%oi]-|o? ?~<~ѷ.#֣Wh_C>*]%ɠo\"jol;GL%4o  BpG; _, 9 os ';, D p u ހT'ø?o`< K 
v ?yø {P1& o=o¡8#|珯
 _TM ÷ o ڐ|"a o8v  @*?0Gx ` D;<` =Ʒ oy÷ _z?P q? /*& \ H>0k 7;` 	#O<}R ¢l|up?A?[ o N p~8y Eg? q ec5|  |=%n|SWe٨?KZ ʌ4d/&O3M)Q@}fcO
jχ[jGڣYk`qOv E%oi n~Q> Vp 枋÷?g( +~8OG;sx   4\.<G [ z?۟?v?Jߎ ?} ĭ = n~Q> Vp 枏v E%oi];sx   4 Mπ>*L7'>=[J{~ -$}M+kS
-vwsHV;y
Vxk 7_o!k 7_o  *?] T ƻ  x w  P   5 W @k 7_o  *?] T ƻ  x w  P   CU&Wŏh_	o{VGGGxaK]op\Ak%6W%-k:7;sx   4w(pOm<ki~SFNյ+n,onx$R7!E!	2>$~ SUm PE PE P_Qڟ? '?;xVּk__xj;[xX_Gjvq_iZ~Ok6w\B> h*O g|&x6jƏ /W
Kg/m.,ʹǟx?kMgxN͠DəL+Z],%Ewmkr[Dֳ?A'.x>>|OŇEg\?gMX_hV_hHx"toy+_x/t/O>7xZoI'|hzpx˖h"Մ2ZN`J؝?I4/MĽP ccYqsyqF>xlo0ٮ%	vHOOHG
xDUkxvh6Xh:XǨ\K9wS4rη:I~߲ᗀ4ω>&teW?m45n i#/^|5Jv|?>?~|o_|d6^&[}oiR,6ZhL2
>y
 i|R/ i_	hxRU
ﳬ6BAO?)mobF#~~߲O?(<7 	/-;#+/-> egֱqFWCH<Ka}7떶w6|mvŭkK;Xwlk *m 
fOF	xY?5=k/~[<Yvn_kenkφ0?
/~"]K	!
RXmۥM%R$WF&ix.@~߱?|JGďᏇim[F
¶72Xms[\$0&*+hI0 [w-_Q4]_ g i gOؾ/wwWƶ5;~.u~/#h>>_!4Z7n#W/o̱0ɫVv]As-.#i |, eߍ΃|_źecj
\ڜZO#eR=F)QO*wi>\cG=>4  j/oBt+?\ؤNN#[[_ML8aٳ<_w~Ⱦ<9oC6< !xRLvj2A.^QV+MF%w'imc;^|/=w_,Ike⳩ 񶧬iMYuw<qY<,{ "|h~O_.<} 틯xr5-Ofɪipiw_m"ux<Ioqoso|FWG{xo
|d5SG.|KƖ> N&6rK71\h^@cY~ğ>(|eU
𾁡>/

ou\]F=jZFLd-Z;;7V
URQ@ Q@[ +Niן>."o_kxORjwI,z:;iQhQn>>
ڟM?g#h??Qk~,ޱhg<G]VBufk-.Fԏn٤ynv/?o 7;-Sᯄ> 	_t><1;[Xht}tx`<70"  	+ۋ?狼C'ÚgzٮPyR?1w8([<{/3q|"wW>$sU5".&--.o.f!ڑH
h u
?O*1u΍/?cQ6jM{[[VUxdWW>Z̟7_|>=sl~5Z<%5^;]x.\]p~x^/|KF^aqjy
coMqssq3,pCh<ʨ M! ~ź_'O] 	"P_WcR{
73_})mʸX?~|}p?TW}{Fփ6 T]f//6SyZNC}'xᮧ7>,]3P&"_.he$N ߴwu|#jiZKkv6Zqa,Hh،:|
I.=f 'y_-gA 4t?⢃{}Ks ^ɣڟcſ>]2uxB5%ަbזj"Ubn fT`<wQaZߴ.x͠jm5{Q?m ?MKo0m?uP\/6x\cᦁyGqivC/41L$qP@W/x?dax~#$k'B5 SѵGm/I]Y^^f+
k &Zh?n?|v թ*
( 
( 
( /࿅l_?ZOM/t~Do$ex.s3^y6j|Sr&A|b/OFizyukjǶ k6dm >[{K
}ɤ~
ԿfgY'?km4
zL1*sws<g,:v*æ<uc>-~?kNj<G |@/vh_.s] ˿oXZ͏lDk	b9q_gox  _- x]ym_7#d'w1q?gO??(׉fl#|L ^WӴ5Mc\W5ݖv[i:0k Z|'o?
j͆H-
+MNX\Mmg5Ԗ {YQvB?m~׏lkς#?<!>'ߗFZ3Sz0Iloⶍσ7_
-[N;߱iԥ_9?&sYnEgN%k[;h߲
+g?cIoi563xlmψe֮t]JdmO;ImQ-goSh_|IvzJjB$ި5	cM1b^SikمG #Yǅ d߄?m=R	Qy[iKY֗
n5UCյDyOhl k7- ڧei>)|O6M&IҦ,m|/ݍZgo*-۸~߰ٛ:Eo!<;ڝVZ[2E%Is5kN"}ei5=&&h_wMCP}@o 
u9t?V|wk>/<Wq
տlMGN<){qw`uX	50.}G$ + ٓD  
כ   >
|%.߶7 >ndٿ{j8?0j-g<7kicyqa7׭4}{(g,&hMNX0GEGQg_
ZxY|iziiW渺;spѫ*4ҕ.k` -?Z? 	-[<>'|?h& y#B| F   5O) Y 
/O~ ӯ /4!?~2_U~)c[o$}΋  ¼xGs< ~b\^<^O'w=x	\5Ƶ <#x 	O	|Z.ﶏ+  cy7lY	a 
tkkxc-m5?G6^5X|CҬx>yd|	%յM_q W
_ϭ3x:6 g ;ş˻G%n6I}& 2?d __->|'t-sS𿁮|W-GP[kߴku=İy#MK(_*ǂ ?y W 	~o =#[v~w,w~g}M*}@ Q@ Q@w='yOz/CYQ g|uS6wm.5ͬV{{=| ޿  h/ 
n?|9;=3E {3ipK!_Yio-7-)pv!]ogP'H 
,O#o_d? j#7gǿ~Ѿ:'+3_+ikk/_yS|\.' 7A7𿏿g/?W_PxVFy i_[.7ڃ GI "Gb G
;↝ 	, hǟ\{wz?^>g{FbO6/6gӻ? ߅?>jq-?~(>5/}׉V_8tO:UFtUhNo'g?JZo_ m\iP;Qj>=Y!lɣOI%y%7<O/W~~"tڲ OdFfg'gFxM\%SSW {_G?7Ŀ;_ͮ}୺_?|u)4!6z]CI%YDQ~ @dyl _exGOt>1oZMiyx{4mN)F=JQFX~nctm_?_ d/_j⮏ŭNI @
QbyfV߳b7?	[	CSÿ݇MWU{y}XufLCFo ><~-_xOo|mS1^X𝷆|G^!kXm;m Z0/C-vs_퓨xS
 _
ZxoxwAkhŽ׋nHI'[kh[f.n_C+ÚSo%  +_ wM6NxC3x@%Gijށ]i#Nu)Bb^;Dy"D#<[ 
'6jo
ĚՎℲ]ǃun%k,sA,WPKH"{ 
; ?iOE b h/~z~+_Gf퉝Ɗ K	 &#oZ2h 
كO !Xx[tsRvQUQI<
HO4Co$Q3 |t b w/~!u]r_k6&ʚ[w%H,Lo??߷=O O|xW*ˉSz-ѪA]#tghYav)'nٿw7~xd<V^,snm<Ek*;+6<[<%eoP_ ~#x߁j5>'74&a}c3&$d6WlR)  iOᖁIxBWh^)>ö~x[XѼJ/t(mt e_u-Y;
/
~ߴ=Hm"xF𾳤v6SjP晠Z\hg%|^Xz?jؐ^jtll[z>7\/4=D[wI5iagy4ƻ{q5'ៅ Uڏ) K⏄Z'?
,~&>}cqxWⶽ͍π5ӮcmDbXuis>!O=x )
֕Gwmu(%WǾqa_[Kiewk} M.;A ~>j6wo<'CLVЦqxjqXkm໋+_
E໹:ϤX,oK%?{'gƻ>>'n>ë~Ru;+UlJW/+/[V~,
g?O·:>_7>OxVZm{WBX-W~eD JJКgQ~ ૿~/|J<C|59/uk\WDU4'ծecjZi&;ŖЋYc<'uK?h>Юawmf槦ڃxRu
OgMρmh伱]NRVӴqڇC4~ _
xG4~%mag^5%M 帆<C˥"|`e@>%*^ԼC}"G<O
wA]i\>#{2K܋hڱL-OZ쯬|HŚW(T-*msk춵${xc"a8V+O3]_=/|Lcu/^/7zͳ?9 n;ב.7je $X~?J.>KzOS nŞ6 Xj,Mxo?od
wo/)'o?-j>4ڬ~ZxYآUڛ_ۛ`X'
99?k^_ě9|*AWZ|96m-"nyZѣ[ONzώ>Q'
zl|gi?jz$桩huup&Kiyܿ>&|A-na?Nvz֯}LCiu/EO
ߔ* OI~^	xÖ o~~>yk7>25/i3PQQ.1鷖1:TOڷ¿/CBWѵ?j

KY5?xgI67>Sѣu;kJ=[NdckS3/|s߅_W?"MO|E?{}W}R{hӾl߳LAI|1@VzB> )X?d ԏ-}@ Q@ Q@	$ L ??k ( ( ( ( ( ( Aݣ c?}h?n?|v թ*?) টWo	ӭ9h?k:Y>Uw5KcF'<H%r3mr^OwWPOiٓFykɠMGzΣYy.
6钘y,#8愈ZYCJ|g %s
M!x޳-F/xPъA)u1-̗tZLFp{__o ?ZhNk&{y|#WټX!vnXmy4*I? ঺ vZ? M>>|2ti\|]%^X_4BAlt;C!t?gߴ/6Zx'4ohP}mcA}oC$*K"aKr4T. ǎ<Max+Eakƭy
cm7721F$*347h)/?~8C	ec\.ac[즶Ԯ.%Hf=KN8dg]BՔ<eZ# G^ 	g "k7l vc IX,ϟ>&ך?¿gS7ѦpcJۛ+-#Oo5^jU26ZٻGx~xO|!qᖹ8t_P𕼺lsk:biwvzfmҚ!mKxó;ګ]Ӿ*~Kx:?w&񎐚ޗsiqsڮu].
.g{ 
|'x8xEk{IΎ$Ӎt	$]|ɴ!;آWkV`HG~ڿW>ä4Iu/t$7Icn4QKl] /<Ux㏄5k^Ot[·2,6嵼2w(~	
GxWQ>=]&u/ĺvcm}qM%L`fé)?x+Dǋ& T1C$}ML파%5w3,#C i~xOzfVOxi-O,h5	.5[Jx/~~xS_~$qm'ƹ]:·1Mmm\\J,z$qLκ("x3 ?Deo 'g#o?O^}~ io c\ߋcci7wz\Γ(![Tierar|M 7u+m# |#jx6tYM7:6qisou
|#{Teǟk?m>%@ž3όt?qCĺh$V#R'.E$3~.~w~0$|3GS_5M{o-ش˿ gA̼-l
s~ߴ__|`u?~:u]\\xD4M\̳]C+uLi\,ѩeX/|?W?78xGV
7ti^K╭VfY2m(rU˞'?_uz_HL98z|
sF23@>}	7_
?j cIr u_څ֫{%]4e6)^_~5o>06_I"ajq{E̟vw׷|0Ψ__d>_1? !&  g? ;#d4|%'R Z
( 
( > I) _@~9ݴ Q@ Q@ Q@ Q@ Q@~xP1  G  ~@	2>$~ SU/  Ɵ]+|mZ1C-͎e=v4F4p:Ư,jXgPK Ss?߷Ý>utZ&i|x4^h/w{X=Q?n})  
 V~s1xoŭȹ2iIַ'i[-aϰG>($=  5~ؽ?*G?_?,?߁߲ % kχ>[6v7~-叉|-u^$oln-vWwڤ:Iں^OVf?+x.PH];[8K	e&XFpFaԟ< H u|GklUhz5c$GU_I7vtH,*4ncs_ߴvΡZx'NuW:V7[<LN<R(`Tx ؞=Ǐ?mVf>rjezGc⩰rMNK	b߳u||_Ҽc'E᏷xZoї]:<vrڝi^8n#wþ>7~~.|@GO$^X.8$-VY-RLmmu>wIO<xuߋ>5x?>]KHԞ2%o#1tE[+m l\G:㗎kx?O?(ßk:5OK?ue4kMW66>K9`ydխw |gz_<S'N?|D~ma<Q;z~$Ib-s,[38~KOw6x>[|B~ٴ>Ǒx³Kб1i"!"}>FKB[S RR*|u'ŏMEt_sVx>Ij:^Ԭt(M:WSIKkcmgl\.}+G> _ucO2k{NnusS-][ƹյMq[ZcB|8߀?O_jVo~d{~_7qgGi߱Gn c_:5O.iV_X]{mߴ&^{hdkePgu lOc 6@Giyltw	}3KX|9{}w_5o2=ZxTyt۹&JGq?_K(˯g_:<5/}Ěַ3㰻Jȷ1qN_ws?P< (rYik:
g;XS	:Wr[?L-$}n;ǟF㧍Y;,u x׍	~6_Ao@?Z/Q&syiy=o \~-c6~.
G5a`/Y -g7fnuoo˅Ϩf?a~0k&?u#bIjZjs9/oxnL63w8 {F]|}g	c 
|NѾ7{37}O&C.k ΛYi畘'n'cI   >4)Ӽe5jƊ~kZLҭF ۬j%7>8_w>Қ|kԦּ6cxW~'5h-մ$_ 闶Bv\h.t_-㟇~>V7?hEϰ MEח>O+r}Y  _
7?=ƾ#_'5x~(|N]jZ7zh-3Sxv,$\[Y;h= t|4~/j_
GƷt My-w}|U]B[]MXíj%[l/nL2\/}c|c=?Fxȯ{[+)]j1jv]6K[PFBgOc0  R?m
( 
( > I) _@~9ݴ Q@ Q@ Q@ Q@ Q@~xP1  G  ~@	2>$~ SUe|YK	O MUodz7z;W4K{k8Yn=N69T~燼G>|)fZEki@D8b0UP@ WOTʑ<|Aj+y h<aᮧ1>ՌQc{+]XtBex[DW2sIR$ xK c/
ɞ$|7|v'?#QԼSNy1+yVw[%P] X_S/~Oا	Yc;o;IƽsQ{Q5yyn5[[i&8nN2&&iUpyIN|Z4??W
~sg<]3^q7+?>G4FM'[?)GltFu1GQ"\zO;~ K_N?߷[_g쓯Lok}<r<axjY"
ީodilmݡa=jS.߼㭴[zoRӦ?y=Ow +|Vi+K2:H,E"I$sA4R,qqB  	<9Y|T6?կtٵ='Lּ)g5ochuOzŜS¯iqa,Lɑ՟_Ø g/RJ>	msN׿GWxAwq\.
&ɇ
wew>wt@O
e~~:|WYxoSxWSt}u;O{K>K6IM
 P&? /6x+O=k^}S:g=YVټ̆:ZHO&,K=~\s 7+	êS?_xi,5!M<Gٯ7Z@$Um6'}- %iGM?/x/|+Kg~!hi>"xoSy4ٴt+( .U/-^Y.?S^!Ǿ$oG<!ĒxR_
>*Ꚗ{)5u]i?o.{eOo
mBڟsPڇ_1|X[ 
|4񏏴OQ|<]=TU߳LiEkh$4f?(?|[YřCg-2}RִO]}ok
f[H4[K=3q[-B<ߵwƯ _a I4k\it_w=lȽ|9g-ķ׉w#~[ h?/?h
/<{o_׿h<9:l>*躇.lotJ׵+ɩj&b./44=]s_YL.b/|(/<#Ohwlii$ZF}n|0l:-7iĲMk>= L>:h/uho~%<G[g
'񅶢msFxm6_h1-FSi@?d~ךgk +(ĭ6z=㟈w-ޭ;ZMifQ>kt[	 	־=Y@ oxcwauu{h_XڃjZ]ɨeh7,w6$9Tdϋ㿂>xCMᮬYYm7jn&OH[,E;
-~?|_%[*[wbN2z[CqiF-g{:_u~Gk  f>2 ? Qx-|!h%NAsOY6ͨŮOuZY]Y'υ) xB|AeaO/ĽJm%<2Tegm/n5/6\CsRcQ~۾,!~W/ZxA4^È/_+}㾗pkgh鶗zMƑ$mopf\mWz!xB(qt/Xç	i-!$EGԦoFK84RQ@	j_]V<U_ uH> bۻZk<k|?͟ v߶;;~|#c[
uRH#<VZl-!B7^ǿ t9 :׏'C?k>sZ by^OIwkfF>/f?37%j~Hs;e^ziЎ{sI7oKw~[%g3CE?ЦPiVxtkS\Akݥ7wMsEc̿9&X+[RNJR<.X`*+6gtwaEhqg	  |!𧄵n4MsG_L׶7wv7Vx%D7Qm PE PE PE PE P>,W_%Ѽ\jھCieX\\L<+*31 _VW?Jxm OuVIn-mU	9"uVFFV (N K	 &#oZ2{)Ox	+ ,a?Va#MZ]JbnU%VU@E*tV #>-|5yWh"е۴h-N4[deR!s@o؛X>xZ QonmN%dpA95}6{  /
hf_x~ 
CPWҒm;,X,aW{7CAE"O  ?Uo&7eqxm^VxOOЬu-'G ;zGOgv^/ b w '4emǺֱGWm,ҵ)/$0ͧxym,
)s*'*M%gw] r_o'׈ c_g _&xc]晦~>eiGvb3^-Ms߷_m~ܟEjixCH񆇯]xWL&/n^]}TaNk,m!7KgGa#V8'+8N]%̭罍9SO#/g ~ E*YzP{G]Øm#{;;
bٖi^IMs[$ϖn>b__kkOwÍBSguY,_{[[
Nᴽ#P8Dx,oo1QoM5w7{O|
<CK/	VZfj4ٌnpwk[xeP9vb9
;wzZ>}ǅWxkSɚ94K[\Jɸ̌O9|/_
kՆI4*K-*5X(#HUQQU@ 
  ( (87];4CP\:zΑkuoaqzΙ4sIΑ~7Jg( 
( 
(  hթ'o/?u߀9b!Σkk%Y[)X(MƧ{-d&o-cq% s' ?xZQkOuCZ垇uMmiR<ei:nA3庋IK˄WWߟ[+G¯'d|-4</2۴QiSnθ+-AXKZiSY;$W3(`AIY;i}uvJ!V֟RLMWm/B +K+ea
qZ¥oHM<iwxnDx}+*՝yfKm`h6R ֿN~
 a?<W/~ouk= |_`Z+He
HVeF5$+k0ɪ2ǚ.xS4ª	N6Zmz gҟׁ3> v^5|7ia4;yEE#Mn,.;og~4.mᦷź
Goo㺵ɹH|2\k* }>t& 3N/p:./{tz]|Ζ>@3? y SYωO*wI
xg}S a=ۤ6 PE PE PE PE PE ~yܚ^ vxO:|Kîٽx#r,4i㻎,w˸EZ-ȍ 5 po eOOPݴP_L7_;}kᇁ6*_~oiii-.9!D"tuݕe` Q  W yO|[ַGMFSP[kedZƟ[L;%g?(_#6ϿI/WBO (g맊)k3I'߳] * gH(	/= heޡ[}3xL,;KiNjҾ
[~ğCÚv=|#R^6\%]i(E'/ԭWF,bocym^}3uIru7?LEI kw~N3_5#8m{!ȮSW{ܕ׿s|W|#ɵ]Ytfb^Y
ݜZHM<3yQ\^c:ǌg-}QKO; a??eVW֬}wR^ܰ3\^^K5R8#$0A?7{ )oS 	'Z,n<{X]xviDkkiT[FV4<6.SyJ򨚾[io$&}Cd?#_ZXks[ZxW, $EoPlB-Ec3xoe%u<|<_>cxEς\_}Uմ#F#h."tlFn^1- yC Y> 9; Z_c˿wc 	߁~ oN| ǿ?%~G1 If aiB~ oN|  |} 2ai |} ww 0ǟ?%//1 Ife߁ {C Y> ;; Z ǟ?% = ,{ ̻; ZA  = , -'1 If ah {C Y> ww 0 oN /'1 If aihK7 . _?~3j. |}<'9uM#
K6gм#cyz};{&T~0n+ 	'uOQ|O⿲c_u<[}@V.H287A'' _{?࡟Am> Qضi:e:}DY`K녊[吠yXn:B:usLN6{҅f'rzzg񦹊$2K1Hdp{\|MN0I4}I |y|K>.
 ׾(m9
ٸ(4;Xd|wsmInߠP7:[|pH5IYsv,Io:7U(Eb>wEr}F+9+Z*1Rk+g-
\𦻬cm6{
GK-'Ӯs\[H%Eh7PTs_ u ~&d \X%ޅx5Xl^!ԭeYv-s2])@*xSGCÔ3Mkub4Wӟq@|=O VfHK++Y )9h&)t4up|  n
em~4|1񾷣 66֕
k(aIuX=RYMZJ k  gh~,W_>?<+|
F}k
mFNfzd<	|7JO@~O~9~ 
ggᖳ/Mη?k
x{ď$z}5X#;QQ],O*?I/4XT?3o^. wI 
 Fm Kz 
 Fm K  C 6 %wtA?bP ; Ix /,O*?I/A?f  $] '$Ѡh/,O*?I/'$-  C 6 %wt?f  $]   ћ| Ēw ;C(,׀
Mٮ~M/,t2B\SSޤq-fهo=g_ch:xZWTLgԵMSS T]]M/1/_S_7 _ e }E |%  p eOWݴ ?ȼ'ԒoHYQ3ZǩwWUw663rHhwDߓ~Y_.	G|4jk7;mK8ΊIKiwEV慨2MyA#Lis
w~ a~gսյ;L3Xp\\]F+s
<-UVnijsבooAY$uD3 _בh^
  ib%
5ҿhO^־$ƝY_pjQ^]mffFLy|rAӇUUXzOWenW O//g
5=e?o4][T:DI}qMCm4	*(7 r7Q|.4(>{π^
, Qk{9l-+F03
hO bXnżl/	Q('u{86̉I86D	<C*e⿊hv/	 kG%`fġ%X
?g_cO>&vykk^#<#,w'񅾏l.Ѵ5٠eaW[[G,')6gE|iL|<u:}|_Ť?
 g
oIn3{jښNRJ֟/𮡡w[5[)k2SjZGo3GG1Cmimmkeg E PE PE PE PE PE >1קJ Oxs_Fxc:]N;
?Nm&.GB$Ҽ;URHK4b]%
I'h-۲r#?+Oş=¯ٯ6Uj/KFNH+ۙo;om⺓N,\VH|oECq ?1]A5Kw iWKki46 :
I|S]gJ%಺pԤj__.)`QƦyV-z: ~п/~ /vx/8^v
x~uOKXjWhPwikoks
׆gxQQ© 	֓X^*4|+%-!]:KiaXt/t{/o-ԝFӏCr'b5滍s -eO(7Ym-/eůF'l-b8##KKqmy<' ok G%O 5Wr/:%Lihiu=L)[{}8$ITO*Oǩu,VGG.WV]z-	﮷Ï)x_<
Ex+74rrfxO;kM#*\l v7:J;& EY|%  /~k3
9~d?fr_4[t5jP h5OQ	$/?iOOw-Ɵ5l^z٦m+CҒh!cLC173[q=|O_Umi4ifI_xWg9Ƙ}ΦuKu<U PE PE PE P_	M> ~ Sm'MG<e_vE 9~ ?t)t ڛ#EѢڇZJ/۶6.UvyuQ:F54ީ!GuYzM_ؾ.h?'b]Z]z4
ٽ^otgr+nʄp;uۿSG_>|K7CZX4̸7iw廬s
ռeO?)T^tK{w弟X$@ 9l_-%&ޭh/vmi(s??)+ `|zU^
u
Y [hWZg[\K9[o9 &w/Ͽ o
.i?
6uJR4=^7k7Z]V5ݢMKGPOF5 t9ZqvgqnyB
96|Vǂߴy[ Χay)'͓w˿M)  cS{Ox|DE1S^ڤSK)rg2NK,ڈ

( 
( 
( 
( 
( 
(o~?kM_O?<#>_V=\I/"ڝ6g{XOEM3$"|G.|4 hyt i6--6YDJ[ȴnmb;Eq-U5~W4?ikJ|-Wm߇~ Q|_oI5[KȚ;[KHWf#Ưax7:5Jg,mu/
>
rm]?TҴ[2nS.Ϳ}Un#mibg
j-_G7%}fU\TV6ɞEs/k?f? |ufM{=ԿfK{{-J5E>ux`n{p/oeÍO}  MD)Cn0i}_"Ϲ[-9eM]]U*ͥjֿ_ϋ3 g^w;-OºnjV]ZjVsoq4RG#FevHoÿ:WM~LcUcdgK|kdH4J(;=ȥ$GOg3G߄?
n<!sw
}WZ񦧦jZ|.K~y%2-,&+oןMRgtv
_>Z  h}S6}'GÛ[MW}ӗVkxtsQӡ1LE&|5Iӿg 5_n xOd#Ѽ
7|1q[t5=\ikw7Ko}G1Oۋ	GEcOxOD1gxA%3K{u	<CvlCe0  ( ( ( (  ɸ|7 ' V((/&Oď/jxʾ x >~"~ ho٣߶~=on^oFn[ZW]7Rǁ}3og߆ߴׂ߀,+<EeiڝìmMAY--OmpFG
!v~_τG g 7!7[
e=shjcibŦʟڲ^{XլbkᳬUN/|I>~E8( G~Ҟ hI^Ff|ڣ}#QKoGR,msSսo g f |{aL=5CifwfyI<M5̮O4+;d_ԥۗk9ǣ^Q@ Q@ Q@ Q@ Q@ Q@_ǯ?!֫o`x▸ax-Xak2TҥX MN+l-n[=1_o jo>*:Zo_m|]aqksm}w 2$,?"ɈYU[Mx:x.~Z2a~Q;x#~īϏ  m|hW쵮|JO_Ծ-5^ռEvqc+6{K<Ll%rA;}UNw(G{__Wvku@|i|Ɵη?x~<KxWۋkjvZY/q=rK.GnR%}윐IcҒG{/pu n^];RB?7 ޸ '_J6~ ߴ 
?6,'>7,<SP+[%/lw5MRv1UX_P]jG߲¯-yoSZRãş5Ԯ[/Li1ňvv0X
|e #J y߈5~N/>%|U]\}FkY
Cy,i;fd-$iKc'9T7v~ > |~:_֋?Mƍ?>~q1yAҵ;Ҙ`E3ZL/.{MG>&=_J Ϗxx-s_Wv&X˛Z?5O=vߌ58(l-]}4?Q|*]K
45<{=i|\ZZ$pM4>嘓Q@ Q@ Q@ Q@ W_S_7 _ e }E |%  p eOWݴ Q@/	\VgVGowv4BnTA` | >~ n(~.|-^Xχ< C%{t^2͵,<j-&M/f)/xh:ҿ0૟~ZiXꚖ]RY#,̺A
w.XPv躿R[_		?o?.ٟ]{3Yi0âxXcy/,fk&4n.`o=r"yI_WC(E PE PE PE PE PE   ~L3T/Gx+Eүu]s]܈m
fWPib	4@W?=Kռ{j??dZG f>(_"gK6	]6C8Ϙd/$_c
U_@4m_׆/Dy練ZZY\~3#)ŏPR5)(ݕ]gՅ,u9koLppA?
/q} d?Ŀw_׉4$[k]q,6{Y$aJ?٥ʙ!礩8M\ulfAMiגM?ʟ r Q 2|-ọvZ>_4-DPԖ8b5v*搪R I>Lr>S
PkyX!)(k~pUqIzBYڧ	K|x߲ÿ ^2V~8uk>";-FAK\;,I袊A-iX_rgJZ~
 Rck"P
WC.F/x?Os 6a?2F[o8|<W|0Q@ Q@ Q@ Q@ Q@ W_S_7 _ e }E |%  p eOWݴ Q@ƧsZ^ BO>&|?|}sØ<Ax~
fjv("(*_?W;I}KN
~~ ml5O~o'?hFapݼ/STp
s g\$Y Kyci	Uk6W}m{;;k*uGI9FWWIuvC 8m'l_w|:~S߆|gmsqaq+e.<IV(+<%q,FYYyNM=Q Y| e ǫ~x2;At{l-UxF^ib^T_	#_ `>-Yj1'j({_|3oH>O'ЧK頎{u\z'pWG8Q@ Q@ Q@ Q@ Q@ Q@  qN X b X_~ݐ߭[͏&FppZjnڎsjiy[>(fVa:Qj?hwo.b71ڑ*Yύ߃k
gƿZwc\xg[\̭oWVe`A"7'*\=:5)ꤚ:0K|?Z>|gixb Z,P[^,>,z$3a0[44[ޏxϋ$o"x:h"ȹ^[C"/=D \CD\a{T:z/~}]µUv;v=-^91#pO 3/@gCk:O4=[UԮ⵲-in.n'ph;UBā=9FK|ۣLD d|<S}l񵖟xCX6Xk6q˥Ojd- pj_'DS	1]
_:?Yr]_aYkZľ5;k[O_^Ms}t[\]M w_9C=
`̩rM˕[4}uc|o֡;ygS?c>6E-mXo&oYm!e	HFVFUe G  T3
?xo6{U	|DPFqs뙮kK7r1v(ei~]V ( ( ( ( (  ɸ|7 ' V((/&Oď/jxʾ
 Oo|3~ў=oF/S5՞$kH<˻e>}6HE[-Y3iU&쒻?Od߃^,|eTxK>-|G}>4mmRDh
bt,I|| ` C _ 
F   _\]V,-Oxf+?xhH^Hfϸ8_<XA7kwO׌qM'Zw@WR|u<;?Sþυ|]+}Bv4G{պI)QO'O ɠk_Cڛ><Gwu~>mkñͥ^%66v:`7:̿]r~N?'{N.c޿9T <e7u ~__߂>7>['5Tn.k"ISlo.ɬ:R%;Y%g}WvL ( ( ( ( ( +C1 L' ڿG4
S^z_uHM{hZSIfn@
q~՟/;?i_K i7 ?Og-`e_wy{s1 +3 3  e\ wµ\~U)8O/x^^ i?E gxhfuѤ'e ~n &=1FX%WNkgtϪ=FVgͲ4?fy.\s 
= ; dÞ1Wuhz[○<GH·qFMc$p$
nҵH\Bc(΄񖌕,) Qn\TI5M}>S_+.=wG^Cd?%$6Os b|'m=~O2ސRX\ArVE6}[ky ~<h ( ( ( ( +/)/jx2>> d ɸ|H  V + e[/ۇ
/'$߳콤M;wc J?Sy|7tw([Mr979ezvW[9hFx|G<'b"V~1lrzgk;	K~_ ,O5h??t }.;o.͟غR7},i;	OogdtѦmj-o2	q>oyǡñ_@}iSW^}&&=yZK<qr\K2S\  ]O6|f<k#/GW WG ֵ (ãZ_W?>6cQՊS{i&o?vs
ٮUC^)N|QI8vw '4_?h%7 'Fu^RԼ9+7M4^M杢v氞Z;SخCZ =?i?l?[G.um9
{y.\/{(34/ݣ$KۼR7B1[q[t_6ާtU( ( ( ( ( (-<qs
ĚAouxj[R}IH,^lu-69.vwkq, U Wg_/?^uG+_u)8O/y_Q@|y.? } IG3 N|OY~+ǎ|
mCE񶋨[>Mi}[H[\B$E*$ʌA 戮?n&GgQk׍|ElO}MJmZX,O}FxV5y2LPbO ( ( ( ( (  ɸ|7 ' V((/&Oď/jxʾ6~4x[o:~>8xύ]&(eҬ&(fXK	a~'>.~5iM?>'ĮMIe"QE!qt2ڒKWcO$R_E~`~8y'ς<xb_~xc~MN
+Ś
iG$Kpʱ*	,o%;ox
_mE~#&_'Q-a=^7܎zpٖ?'t-vas| *p]T-7ww|3> 4. *M ɬxT7 gO6$~
G7+58d[\.m〘nn?d 7Ǐ^ד	w
_WR~
YyVTkx-oA]7q&u0TRuI=UiG}V̾l*w$[N]^Zkm6S4IC2]gNOu/\[hzwvs7)rƎʬE}AE PE PE PE PE PE 'G5?5oKψ.AlYi,M+
 L2Qeι k@ n #	e?:+3
( c /%  R)( Iω?Z+?֟
o_D~C|4Iy)
#I-
H$"_yN
*I'@ Q@ Q@ Q@ Q@ W_S_7 _ e }E |%  p eOWݴo _LƟ5*q0hV[ꚥ)Hb٤$y~
|,>N~	Ɨ-.}NHdMx8V.Ȉ!T`Z'_~m{C'^ZǪQ_~hPJ	R#?$x ?GcU߈t$o^G{eqc5+xխ. yZIx[A2hJ%~cѮ,E~ÙQC'y=noEnW{E PE PE PE PE P7ޝ2 +oό
u3 ^;7ZZ[Md6{`ܮ:F! Q@wgs Q
x $_ J:p_3(OT(>Pf	t'oxK+ۉhIω?J+?sN_o<) 55߉	|մKɚ?ys
o.)9eU
"[+!@ PE PE PE PE P_	M> ~ SmͿ7|) 
}_/©/ȓ[~cNuy&Fc oN <GƏ	[x#_ስqcۨڝ[x&9?s}ai>"lп{
>I2?k8Q2;/12P>;k$7 ? ?/c# o $yoT ɇ;w%
~ G;w%
~ G 7OS 7? *U  ? ?X  ' $oT ɞccB|'/P![Kӵ E4be*xeDh"dbX$Ea~L>|7 R,>xRt	5f0ڥۛa1<̰CPD(Ex&_MwR
>Hv7- {C Y> ;; Z??hK7'>]#п~ oN c 	߁1 If ah < , -  = , -ǟ?%1 If ah = , - ~ oN| c 	߁c 	߁ yC Y> 9; Z ~ oN c 	߁1 If ah < , -  = , -ǟ?%1 If ah = , - S  lπ;iO)g|/ؿ_ ~{o[=6~Ul21 _.; O?A _- |~ §Q _- |~ §P _.?|} §W	e>,> z<e-gϋniuu-CMK->l#T͹%*fN;/J
xt]:.xX_Gl笿 |C,m^Vt}ve ;c =e ( vz }/S g?X}ve 9c =e +#
 QqD_[:7!gg}_oӯ7̃ovO'$G0Uդ֪!SRyV? %TC ?% *=_^s 	>*~||k 	/W_ؿ/+'uߟv {C Y> ;; Z |} sw 0ǿ?%~@_?hK7'~I yC Y> 9; ZB  o ] -ǿ?%	 yC Y> 9; Z_c˿c 	߁~ oN| ǿ?%~G1 If aiB~ oN|  |} 2ai |} ww 0ǟ?%//1 Ife߁ {C Y> ;; Z ǟ?%nٷ7>o ࡿqY}!EUy!yhwYɻ/
x> d ɸ|H  V ( ( ( ( ik>>6Cͨk	~&K[ֳ/Ṵ,5+[k{K?lN y?h$Yn-ei/K<El%r$\c 	߁~ oN| ǿ?%~G1 If aiB~ oN|  |} 2ai |} ww 0ǟ?%//1 Ife߁ {C Y> ;; Z ǟ?% = ,{ ̻; ZA  = , -'1 If ah {C Y> ww 0 oN /'1 If aihK7 . _?hK7'~I yC Y> 9; ZB7  @AEe	п~ӺH/4y_Ce/?w߁ k hdx^[i6
sGXUH|IE6mn+m]C>
( 
( 
( 
( 
( 
( 
K
k &Zh?n?|v թ*
( 
( 
( 
( l ):x?4'|i+$DG8TldhζpФ:/ct7>:hmּWk爵=BR5MNsw͹qq5? 7  >>?7,}/H#?Wg%?w7پ׿+y98{=:?٫~ ??&]'|k_xjJo. L;9c.Y#Y14  ek_T[<Y?::ki0n[Y]aX,~,o4? >%.kM=WL<Ȼy!˚a}v) Oٓ
y7~?iύ-K௄_>ޥ":ci\YwqjV.,T4l
 P>쯬|R|iB]t}oBEmm2RA#=&[xnV73/o)ş^<~}eǚ|\HO-u;WKsgrַvjV\Ha𗊼/
g-jV*V5hX$TfWWVRA~ mO_1B^i:m<{MSKim1k5I*7p 3*dkW$>(}|6ot?a}g'g۬}}SwPE PE P_*_B*_3{#>>i}4klN>u΍{
ޕZs6^a&1K~ </H~  h
=1_[XP_[t,i2:,ȡvc Q@ Q@ Q@ Q@ Q@ Q@ W_S_7 _ e }E |%  p eOWݴ Q@ Q@ Q@ Q@|%g $k>%ݵ >ߵW	CP &+" w9lۣ5ԒjzaHW˟fKx^ .&kB*/5 ^3KLUi%T˩ ?eU 8x?٧}g]
M'HפqyC<5C"fd$_@ b/mo|N~0~/?G~@Y'?sk' !( 	AY %#W #?. g? QB=Dt
Axwė>y{:fO6/Ey> <[_燗GƷP7ºuMíxvfn:j>ͼrB'̆xN? j_B=t[c^2>w/OcIզu
f}kTNS$6%c6-
S0xtxoƶ=Ql̼YdD/&M[zqm
Km%Ȅy x\ O$&>%Oڵx_^\jFE_.5a7-
t/7:o߃_|= ¾4؛xt~N5I.z}lRo'ƿm
V?fIѾOQ|ψ~/i>xxRb֟Z(ou(MgJm,5.񇈿j/\!#W%6 j ly>>_f^>Ǹzu>;[o'i$ӥӭ{&G3( Q@ Q@'MG<e_vE PE PE PE PE PE P_	M> ~ Sm'MG<e_vE P  e~<aR~׺.@Z5M+ZΟ6z%g
弰}!B9h|W% + q^G?kZOo]2,64,+3$Es( 
( 
K  I~?V|KkF_/!g}T  <F|wrEiӴKo>t|tk.JNL˩j6
RIGgaRx LϽCw3MOhp\ZKӚ[MZ:<ZyZA7G?% W>iy`>~uxĚޙ&ya𞝬\ۋ?Gtw"ԱT[YdR?{
_|'ᯀ|IƁ6( {KI4j5찤0YڋO*WC5Ͳ
~q7go,dC? 5x/ZOO?IgiեnڥɂMV	 1r4y]Ϩ f,>N B.~|~
xW3WyrT4xZ{WJ,d//]
Οf,<ks_ Xn?|@Եn=g )GO-}rkarjZfl݋H"AktP 
( 
( 
( > d ɸ|H  V ( ( ( ( ( ( +/)/jx2>> d ɸ|H  V Ş*|+_Ķ7[[W[m,xkcGvUEFf k ƞ2~aZ5
K
:ǃ;6E>meb73r$"<2oa/ h 
8>8GǾ
I<];[8{i.,%4c	E6#~_įoŏً	QxwA4?:!.j Y.y=V&G2^kq˪Ke&6][=sx~?
tυ?]>:~hQuw/2<VЉ/.Y$fjk}|Xᴷ]Kuo-+kI"2K4S#Q3叀 +#>!|#gA<A ׵xKK~̾tSˡ1Nf#Bi5 Z\hH~Ex{
)( +/?N;	% eX Y.>MS տf  _$12)4+zzյjgw唗oorK1 ſ~7콫<~ռ!qºJ>cgm9U0"vġ|Te)oGGٿ;sYok``QK˫)죊i(S\p?a/O~_
 F,5gB4}Zm3VRѮmoEmwc}bh?O:}RO?.umuK,ZNvV
]N4k{Hm+Yx#UXV
A1BG+wQk>XuP䱰յ,-uVH7S l-aTO4tg>m?M7RS+}GzmZ,4}{o%dPE Q@ Q@ Q@ Q@	2>$~ SUm PE PE PE PE PE PE M?<@v@	2>$~ SUm p_ |]q HtmᶡiV>!i]mn7z$=eomywen%ӋުmhՒ?832~+NKMе
 H>"4iZz5|7k
캦w45ַ/޼+C7
=xjl4#OVD	vfg-$+<#<,H#Tq c Rc?_/E / b/|Ѡx~C
Eӯ~,٠l_m͞6aX.cK, יR~xO^ׅ|5xY^aoiy
ݖcqosmq4s,n$̮
MH
( l 8$c Ugĺ  ( ( ( ( ( (?n?|v թ*
( 
( 
( 
( 
( 
( 
K
k &Zh?n?|v թ*?୿)jT aoHK}*uZɭ^r,yD+M %6A5Lv??d_o  Э7C}VsyO-^hE$B}DKt0GT~. /_<
gzޡ'F)uKۏh0[[­$K#qĊ	 W sy 'OK eoZ#t/e
։i?^o5ia/V 5MF[-<{,F4eydkE7fzKP o_
%3 {_?{OZm<!
m4{>6v-KLAo%Ť  ~ӿg :wP_OiѼ
Ѭ5M6NdfY$+,Vh4cesuuهai:vOni3!E ¾(࿅7|9S%e54'ӴVMCSԼ-}]Un[vYmHbO^ׅ|5xY^aoiy
ݖcqosmq4s,n$̮
M@ Q@ Q@ Q@ Q@ Q@y _N:>3j$vXlt*Y"[NK{+1"ݼwʢ<*1⯀?߆
>ikM&Y]q6J͎#7y+q-BDP
: ( ( ( ( (  ɸ|7 ' V((/&Oď/jxʼyoIOB[Ri?u_(}EbfWM^Y]g-
l-)^=⧇>7^WOjvlQIy=k-n<q^DR2E- ^k'Ol_ ^+Ku궖
5cկ'A5ģP.L(.$(>?0o]? !x}k׍
"YͼIYj~)Ց%qbQZ6oe|ǇrJ3|&'C ]#R~o|"Zj ciĺ$omCSx2H?1To3HBMIRm4%ߦFV~~ u+O-ga>!#PxV7&^ZAPDC$3\dHRثV~Z f i/#ƞgd-R;ɯ[ΗzZŌr	oiJ)\Zv5]3 w j 7~)OI|g?'?]<7W'70}5f.cQArVv^~\{U(] ?;YӼ=|Y_	<>~ zW),K[J}'Q5e?Io?>k/;߆ݿAyo6əd/[{VeGz3   N   NϰYz_ ?;ڏz_ ?;ڋ>g? KI/<^ j? KI/<^ j,`  .%  xC   .%  xC }   N   NϰYz_ ?;ڏz_ ?;ڋ>g? KI/<^ j? KI/<^ j,`  .%  xC   .%  xC }   N   NϰY:/	J:_
(?=ghW_j2$64,Gq";:HU!US]f?m?
ZPҼ#P̖Z@MΎeӼ?VkWzm86K/ڇw~1_<!c._ֈ5$mwŚRLݧis$X=к)+
 ?|1G?kz*1kcVOMya+;R5ZzR=9f#9(V7g-rm7} } j:ޝ^6t-FjV~it#(8%吣M<,Ig¿7ǌ<5Ŀl"}KO<@/.RsuGľk,k#51sUd{&c?Y	K	<	')S}[n:N9Wlz,Jh1IKp/yGfZ?_;2w?e7t?	IN}FJt)̳$k?i{8C6oWOs1_ԧ]JN2O~HZY7dk>|r-Yx᜚Α%ݤ7|k+ء+0ḷCE<N A׶Rg)΍IQŴѦMtkQL
( 
( 
( 
K
k &Zh?n?|v թ*/ۓ࿊iأ
i6^	ifUnmxcDdFH`) y?~-h%7^Z~_Y|onkxxԺ|֟i2kźx1{(c _/ 
 3ǿ?5I_D~H8 x{Oċ%_k F56S>}f/ۯ\l>|VKI`?لH.~xrHOw;=?:λx)upO_Yek.i#Hţy,Sg뽭n.KC / ۛ

7x6ោuMH|Cgo Hd.>j[;@%xo
|r??`o&xZuƉ%sey4oyv[
b_:s7)^PNm}5_/0 ƿWf
3i~*CLeiYXxZF&w>YE;lhkρ/wsG/0 @>x⅟>Y|qk<:W#C<612yqmbibsʜmEoduܚ'8Q@ Q@ Q@ Q@ Q@ Q@+%?/?6_zC/ojp^akOq$	,F2}@	) S ~ 
	'6zn<Ye5w5$R<#<)m PQO(? e@?sxn~4i:Χr M,6쵴wxSe3'	 ?_ڇv{MߙZ=-# Ecf\V6oQ^uiC?\(+:_%7uty[GgKfxyRONytd갷n-~|GM5vc? Kޟ6 V H/6ݕޅ5ռK<FUqENT7))VJ'~?~(?-aK6skqsksb{{Y9UfU(եMT孽ϰy*x:
WM%ʥk]$7WUީ \_?6^ KngK[kk]B}?ry0ޘdl/M;>3]k
OG/\[ hiwv7	yr:* {5g<<w?韐	P҂kC[nkutW~lPE PE PE P_	M> ~ Sm'MG<e_vc|AIhP{>0{1x+ Dό=uZũ_^/=_욌CKkf{sg
Ewj?g5|C໽΋&.-.57\@GKx\\YeY#i=OKu96~?_xTuiR˥]5ŷD%'RbLm	G*x_R|oϊ| ~.-$'ӴtH9&"1\NUGO~+:g_h:=;L㴴θy&ˆ(̕nY'*JS)vt
x[𷆼
hѬ-#HҬᴲҬmXmUb4UT  )IIݰ
!  UY4]~]'MQ|mB>.."kdUib{-'vYWIuv /[~ώ<m?YV>CwcƳ[\BʌH ϾgfxOB E[OYPҴOh.K W۝+TN~q& ( ( ( ( ( (|Y_¾%G5a/Zu}#UUZ97x'VWWe`A"9 {x2~ 'P>:||qjד^_xKO׮n$iͭ跚/qt֭\翱~>?ࢿ]/>/kPxfy/xJ̰"V->? Q@ʗ)vn~]A=E?MVnv^kR?~7Oy/<kŞ9WS񷈼5a-ZO'nڭͭsLDc72Apo3G2,?btx3w\Cq'nG6Kygw}KV[VK7˪1i~q'e)$.7wmi$[Y3>;xF4/o~կ];2%q]ȰiK{U{n"yⷶsyygos	
71wG~xYdA!夷1E,.y P*Z}ꏕ3:XB䓳vkvg_>;Oڇ$zK
cHaĶ(Lex]
LM4N#a_cS|S ¿>Ӽ-7axsNo_ڍ-\s-STC%/6U%uc.i{}F9jRjМk~~VV+?Z+ ( ( ( +/)/jx2>> d ɸ|H  V (	.x) pg;m>x_hh
t%]Yul%o+A¯z7<Sx[D}OKk|wISt2:9VRK[# E GLc/?|;9, dxGL_2㻺n4 IgH65"'An[N|~?Q_?H1_/O <?jQ>-?lZMcioZm=B
q>YEѷ;zm/~^wc~6
4wբn4Z`ZFn.4ؠg	41T4%sK gߴW4$gxOT<%yl>myq隗%xf\Koۈjod.ldx
_WVtٙԕS<-O
xgΟx+EGlᴱҬmXmUb8EUEEU  +_GOكQmG g 71kӮ|=-gP֮|KCc A}4~&\uk'5Ϡ ~|gW?)- |3ak|i'n/Y5}3Rú<7>n\t-Qm$ D
X( ( ( ( ( (=?l7+(φ.]
__O4|olPI
=CNmIy
ޫu;[t' :uX cO\ο5,){\V0KKq48bmFx/UxW^7Gl5VWj76G<2"JH 柴/ƿ	~>$|lއ9Jc]SV+-+Li"[JK{+O1Z;QFÌ\ e~@িCG
m {ֱ+6?5
huu,w\yHErvߙ@$?~S{~W~+oO|Nw
ivu>Xf;ӚHd6/b#͌&/d  OW;W$SNS72z[G*Mlٟ|8?O)HO⏉_
|g_	ߊm+Xծ[ZPu\zMwɹ];SMG­o/Í3S4x^Դ_?B57úVcu\ۅmuH-,0AyF.X/SV;ԍ:ɽmW~I*ן
ȿo'> |Y/|?П$|><Aqi۵
[:趛m|wp$Z[moiq >i
|!=xK:_-"ག(tXmc_]GXWK˹6.'pҷ6*%ʢ|?Z.;+5mS K9 m/𿋭 xZxq_ZNiH/ hRLW0KHc@3V-xy㍢*_SU&}lnVZh?Ox0__x'P*O$^xSYG -?JniHVj1z&K ( ( (  ɸ|7 ' V((/&Oď/jxʾ   xoU=xI_'vj-Voz]Ǖe	5
eT5Оj}#xk	 ~ 5OI|zм){S'[\ixfk_j@0YvϨƞ;WsJ몵Nm8Wh/[?c]|m~> 7>_>N>8uX,i5>imŪ\_jQVz Kq7	* `O湧 no<]\ME}$.ݙac=2J29իuj^液Kf[lG5]P¾ׅ|KjY^aqFg
ݖcqCqmso2s,nNE{&G['ǟ t*~+;Zōڮe ˭CT@g.u9,c8cY5&p}:=d_#|QO%ZjZJ[4kBu;i4iJuմP!ߘ\
 ( ( ( ( ( ߳/~a<! 뺅Ƶj4[uԷ'Nxu3n(x.nlĲj  o%/v:	Oǥ(m6OX,^vo}mG&]:YɣOºC*PE!vÚQ-ƕXHxƙ{v&7ʎoD~%]Z7Ģ^O
kaJ-b"oiiIŜ2G4R"Ȩqkt~i(
τ>3ο4Zs:͏
G&%uCR
p##[8>]>;Yuz\C6.f%|R$EuݵH y3*Z560ccj3Vz}c½Go6Nk'ƫ#~7k:'|MA<CfkՖ,ʗufHJ!`\]Χ'#	9>.ڧ;o#Z&C.Io;eV[X}W9.&Jot?~1|?>_}RφlS/TeV% heDI+N>/~ZFQQ+@~g>'į|2#|1{a>0ѪKoWsmmmO[ݭҍ)Ti;3%?u$[?|
K_?4/φ4 x{MM~iipM/1+ܳ3OO^wwaE PE PE PE M?<@v@	2>$~ SUm P>,u_#|X\i:weF[\̭o+ _÷ G?৿
'~3x
JT-tz- WF"iwwdf7\cQtktc?߱9qO5=zX
OS&?*ShaS!bkH&g۵|jq5j:[yߎ?fO>|{a>S5ICgeDUD
$K#6#<HHfIqշd~ 3|P l ej5 xc;خ=Lyu/flq`f}E%"9p#NU9'.i6V¾ׅ|KjY^aqFg
ݖcqCqmso2s,nNE|uO5 gO|$|/oh^O-A5
7Mӭ#6Co y"(mWZZ< f/Cs5
*Km%𷇴+Au7d^%6˛;I]gKF/3 zw;` T. C } T. C }}Q  h| ;AQ  h| ;A]uG ?ޏuG ?ދw?KF/3 z?KF/3 z.p T. C } T. C }}Q  h| ;AQ  h| ;A]uG ?ޏuG ?ދw?KF/3 z?KF/3 z.p T. C } T. C }}_:?KVo[Sk%OVN{_ ixB5ƣcxQ~ڃzόj&x7ox#\U5DhbmcA4o
ʹ\J{M Q@# 82o|9_@Ŀ
h_u_ڥ[{f
#y6G5&ո?F( 8?f|t<%WC\vďk\2jMi
uw7Wmob\4pm+FgD 1ẗM ?
]A |9~ta81֓麮w|vwַVw6	EY#eφ+N5e6{_/C|	Gx{WWvPb)$qs$myfڡ_Fׯ~3W{>ڧj7n..'@igIG%zp(ޟ#1Xc8	Z)ijm7x7^m
[M=(դ)oBSj>VP,^g5(YwΚ88JIæm4*\,3+	-  RW	 Xia/? #?3 giO~?< #ݟ=u`]]c O@ >P( ( ( (  ɸ|7 ' V((/&Oď/jxʾ ro()k?OԼ?/nPyo Ve5/uHn<x.DvM4S[|	o7	 k֟?i6_կ]I_Ve֋5ݟrme$"36&{]Z7M)5j[}(j
{&|  ῍^#<[ k^mR?|=ys,'@֭&7y㹹dko#ƾ+Khko7Τcc|/_
gՆI4*K-*5X(#HUQQU@ 

( 8|B#뗿
>hPqo?[G\%t 
Mtԭ%ƾ"{- >9Ӿxw 	x_Ӵx :U殖Z猵M/sZk=9d R^SkZGqFĎ [\q~ѺGTd'O:?!sXմ_	ܭuL*Mu
@$7χV >-|%|boA
_>Ymω?&};VxnZTX#ԯXd6.wg_	>d^7?x rx.Kxxbm?uɬZ
F@{?Nt><zpПǁaE?
u[|bOtkfXl#3GwZĚ5^~!?	OxT|Y\|-y˝#z~4%t;Yo{_:a, %~?f% [>㖍d7Fo+6m2+?px_ʁV=wMd5ק#W'࿆>
I⟋:_-#vjiV~Mo<,+xU%?>'No
(GfL>	״_:[M2YMm]KyomFSK}:%yRk_R'2
鿴g<'E|OFky?톆
GR-kMiN4
]ɯcؾ~Ο~/ǿ"⿂^Ix7'sCRc7!VZe1HM΃_< K񇃼M{GO:Ə3Ovcx4kxsz֗o}4
Zjw/6|j?ϊ|_NxOw|{>5<<5z-Ǌ|Ue+qu
V&R֟o%>NxOTC+׾)xv_
Mq4+;O3Gm2-t>Iy4g=\?|IG-
 W 'd#T\_ -{9"ѭ[C$_?m\Uٗ~#~~O,GStqcij)i	557]ք_ |)O 5ß|ME/|dM'Ę|h&</{!-n
6:ԷӯķӮ?J (!? 
?
C:met9-RP>(KJ%Y-?>ݠ( ?-/	|mkmmRx:\7up`g۬d[W|Be# Kh~֟w _ =nCQ%].İҡ}!UX"EP}F+>|4sⶍE|&.xRm~+xC¶ ~c/BXwz.鵍A.IOf(U*ѨFwPnKJMݨzEoVuvcMVUҵ]2.l++[{ifheDՁ |Q  C VYūjwj/vgHeub;x"(*F(cR/}\b<j٦. d?1Z:_bԵRQ/5IF54/Je1Q4Ӻ"Q]J2sQ)JszF:T[#|AO᧊YxT}+~4x|6-Vk2XkiqluZˬi]Ɯ #)υ<1O)7	ՆW4#HҬᴲҬm$i(TTUP /®a_/O2m;ɿuZ!Z!u
>}C ^?ཿ>
O9 /K^.<
}oӣ4Gefl-605<>! JzYE! Q@ Q@ Q@|% 5 po eOOPݴP_L7_;}@y  񾟨]/|k1C-͎e=v4D4p:Ư,hXgPK 7෾ gKJczc'tjrXh]@le{tarѴMwwv '?k]+_ ' >-n|I|}y/x+ĺfm^X j߷b|B-]m3AOyn}niΥZTm~w{uٽs䲞%gXܾu,ҥjon4e}??G+MώƟb	_-|KGk65դԗLy乷hiieM''@ ?| ֵ 
7#Ɵ
~ r~.ӥU˲hPMY>nb&bs<u_w[϶;3?{	g o ?/6?Zf兼x^Oh0B[{H-3v/oٻ~;xP. 7t{ZXeҬ(fi"K*Q}J_L|H+2
( c8+g# Ug:  ( ( ( ( ( __U( 8
9 ; e/ωo7#Ҿi᫋:WS}8o<Jma\@?+O<WچmkPյcVVIWy$ٙ٘I
 |G Y!rqϽ~UZa݂# >dx?|LV.#|5׉5yk5KZ;>x!{;Z߄PBi<%3g=6i:π5u
KYͱMoi*ind
00jZIĶZK+a=Y_f0O)b	h_\gB#InT]|fS?.]'Ě-m!t0֐xvPntK氇̼B<4R=.Yͷ6z}Zq}ߏsO|GqxOƙf:Mit\MZZ"C4nyKw
1 S z ZxiV|NcZ.Vmwm(E# d7_
??K <~?Oj>"?<Kh^zιlr겥1c[Z<Ί ( ( ( +/)/jx2>> d ɸ|H  V + g~;D?`%$*GϏWi"y+x~e k H}%hq֯&<,_m(OMw?ŔU %n? >"|;~+W}0`9m6vW-$3[NnU%$_d9vcK]7]F-s3q#u7Ek}?n q|e~~)&;-kƚU׍.<qeh-quRXY5=f%di|'O ?iq^[CI|e3~ []ͨY6@7uoy%X\_
êZ9_tIu]pX>;f|{;5{;=Ouq ~1a/T
i6'_~>kzt-|mks ]OX[ı6$׭}|$_
~|i_ i3񎁧xúٮ-tB;9h|fcG]eVXJrxݵM<u;EHQ@~yx~?o~85{Muy
ts|lO/u?hdO iZ{Mq-o
( 
( 
( 
( 
( /x &~~+o!⎰lR",mWOYm 
 -Q ~ߟ?iM IUiai,M+.^ZkAѤ05[%[ڊ +7(|o_w~E~Jw  T  ^  CWG7Ꮹbeo߷ վ<Rz>N}k{Sxnk47677gkX#0\< y4PE PE PE P_	M> ~ Sm'MG<e_v_̷_)k.i
5/:'4D4 ^%
LqKe<Pj7 K9-q/g/8gj?E~Z~.~[ C`~־;~8
5߃{Sּ''EVⶊ)%l3[o%Ŵs?l'k_»g=xohxg1YxIJ]K!u	jIV#][Zի{d|oO)˫ayne+;JMuͫ$LV oz΀ ,~_4^=yfye۽R37#
?OLgU|ӵ飾>'6{iZ[ c:6lds7?YY XN<vW?Vj0֢n>vW譎
*|07_k>#_o休uqiqkqo4w6vwvͅ0][KŭżKG"|;c4۟|B /඿%|WI<#oZCqu4V:ƍϤvKUɮXO$B_y D"f)v g'81G<x q K 3X,G<8  ?_?f?E/Q #?|} R 0 N>> )|p by D"f(Y<x q K 3 g'81E?_?G<8  ,a #?|} R ?E/Q`y D"f( N>> )|p b g'81G<x q K 3X,k?[xo f<W'|S۸mGѴoXwl;΂O<
ozÏ<'osququqq47wwww/%_\-$샥~& c$mx ğ|\CSVWv?,mDg}Mkl 
 |75G[W qF_E 9>}kG _?)?CÍc|9_r $+L/?#k?f ( ( ( +/)/jx2>> d ɸ|H  V O
֥ ?S5O/C -J5 ?M  g}^hݝԶޥ,n"H&Bʎ<)̍iYGBI}k+0kSr bק><?*
3OJ   tuΉ_cOAӵ>m goQx'XKwQKo2`W i<xxPw4
CC|x i:ûm:
O
mcգh(#9aД{Tk}R=*yhaW5(6i٦W~]KC c~/ &/_GX/KM/5;]^'4IVouFvmn-ι`7En>wC筟~a=&z?32?GGNӷT~h(( ( ( ( ( ( ( )_"w%?ռwݿ ˧Y~ 	G}n<
 P_ y(C}j 3_+S('O S z _c\?6p~
_yGiOd? xlӭˋW<7ʏ~;GPE PE PE P_	M> ~ Sm6|B f/TM5~/x./i >fjg<s-Mx7YjvGޅ~\?᰿hD 1 gɿ_
 WnW'!|UZ+-cV"ү<E\|k) GԴ-$C5Y˓'j[r *>5d Szx,Ό"M[[Z/|UØXZQzMv֩(l۠Xo?T| I  Si £ 6Ve  <?
_?b~o= h) S֗'mjO?f_K +C~  ʄ [)4 QO J?b~o= h) S֏+2z_| < 
_oIt
<=⏀_N?~j#4][Jxдvjiֲum,3G+} W_P 'X~#OXU|k ò_#24tmVqѳ@eh<(\K9_0_T2+m$k
e/x,uHn<c a~ 􉟏 c _?"gly 
C &>> G; _l/3l/3 
?Ra 􉏏Q ꀷ_?"guG6 H n   /6 Hf?Ry6 H n? hD(u@[_l/3 L} w 7Tba 􉏏Q  L} 3n L} w 7T?"c-/6 Hf?Q 
C &~> G; ao1? hD(uK 
C &~> w 7Ta 
C &~> G; Ol?1 
?P L} 3n  ? 0?"c  ?{ ; Ao3 ?W+GYW/3_O	/HcmMr]KP/ml|Oym-IIä gƎ`  t?ſ&|=  F- 3 .h `b>  _\>b-RGο_qCgp,;?7k[qcV݄  OS _}?ƿ; Q8/L. >غ 4S @_R &Z߃  ]R m?ƿc
  e~7~  _Z<= -]ZOj4^d2\KS,ʇQ	^VQGǟ?W 2g\?.?񂧮?= ~q
[?f؟=s wo |-bIGIlno&KgH;FnTdRJ᰿hD 1 l/3 
?Ra 􉏏Q _l/3 L} w 7Tba 􉏏Q  L} 3n L} w 7T?"c-/6 Hf?Q 
C &~> G; ao1? hD(uK 
C &~> w 7Ta 
C &~> G; OӞWG j^]*<A|"ú<Ku.JG>gPE PE PE PE PE PE PE PE PE PE PE PE PE PE PE PE PE PE         1 lastChance.jpg  	@        t4    JFIF  H H   AppleMark
            	
       	
   } !1AQa"q2#BR$3br	
%&'()*456789:CDEFGHIJSTUVWXYZcdefghijstuvwxyz  w !1AQaq"2B	#3Rbr
$4%&'()*56789:CDEFGHIJSTUVWXYZcdefghijstuvwxyz  4!    ?  dOG -\w[tm'XX_Qiֺv[YYoeckmpAx$I ?} ĭ =; ?} ĭ =?Jߎpv E%oi n~Q> Vp 枋÷?g( +~8OG;sx   4\.<G [ z?۟?v?Jߎ ?} ĭ = n~Q> Vp 枏v E%oi];sx   4÷?g( +~8OE?۟?<G [ z.a ?} ĭ =?Jߎpv E%oi n~Q> Vp 枋÷?g( +~8OG;sx   4\.<G [ z?۟?v?Jߎ ?} ĭ = n~Q> Vp 枏v E%oi];sx   4÷?g( +~8OE?۟?<G [ z.a ?} ĭ =?Jߎpv E%oi n~Q> Vp 枋÷?g( +~8OG;sx   4\.<G [ z?۟?v?Jߎ ?} ĭ = n~Q> Vp 枏v E%oi];sx   4÷?g( +~8OE?۟?<G [ z.a ?} ĭ =?Jߎpv E%oi n~Q> Vp 枋÷?g( +~8OG;sx   4\.<G [ z?۟?v?Jߎ ?} ĭ = n~Q> Vp 枏v E%oi];sx   4÷?g( +~8OE?۟?<G [ z.a ?} ĭ =?Jߎpv E%oi n~Q> Vp 枋؟L)e}gF|__/[O<Q-S^?􏈾*4'ԵI罻=I<?m!	2>$~ SUm PE PE PE yߏ g
Xxx&4mcƞ%ӴK׎Y;bhAba1- g'81E` N>> )|p by D"f),G<8  ?_?f?E/Q #?|} R 0 N>> )|p by D"f(Y<x q K 3 g'81E?_?G<8  ,a #?|} R ?E/Q`y D"f( N>> )|p bن t
?]_s@4[q̷~KCK=ď43>|U] |5ŞjD[O]<;dᔀk= Q@ Q@ Q@ W1K ~>'|fxGᮙ ixŦi|ݼpM4Pe=_	s I/ (  .%  xC ;>ó%$/w   NY> W \ K '{? KI/<^ qE`%$/w   NY> W \ K '{? KI/<^ qE`%$/w   NY> W \ K '{? KI/<^ qE`%$/w   NY> W \ K '{ ߴu~|#Zjk._GS=L"RUYE> d ɸ|H  V K	 &#oZ2h 
( 
( 
W 㟅?$ߴO}}4ٰZ\{XvlvOh3DwNͪ2 ;lzƯ
  h}OJWkMW}_H{xtfDӭLBT<E PE PE PE PE أ5~ |s|,uVcӥӬ CˏŚd1,Q$֋
7Q^WA hG1e_|)<L.5zΥc}6lyݣc{}BGyhQ@ Q@ Q@5⏍~+jE i]GRW:[w3u؀lMf4.kbizǚ1i= }Gli <#uMWC2کbic2G}$AWNmƫ?٬-dg?C*x^Z7.Ka5[O$oolrd%rʪV6V ́^VOKM:V4!k.᳹73a}RI0Y 
( 
('_  	oĽK S@Ş(,ok7Qu6ȏ.߸oO@yƍ 7~3xx |,V<
g]:o.̗7zbJnea,wo߱ Zw?,$a`VCAdK/ٴkZl.n.Ho!Yb@\̎ fO	dΡ"U d[J?4XU1u`]&
N-%%R+UG$ Ch|%  p eOWݴ'MG<e_vE PE PE _?_W s \  gğO񮳪YJ%zݤiBoCf|  |~?ů>|oG^%ӴQiR	.cWm03"-
GW|@a~~ 𞥡'z΋|9$.MG$o
jzO9<9a	|A]]vWoc2o~" xN~%~ʟ	xzG!u`;Rm}JKƾMK}~*~ş[_
|@>3}7X;  ki~~k]i?ۺA}[}F6v70:㟷_#LxE/ǇS	? ju{qRzF_j:;IO]˪N~߶G>
PΗ;^MO7/5A2kE-N_f'ԦKMFx"Iq Nx/_l d_ۯKK[M6Dz_sZ5o Ҽ'i:Rizj^ I*犵Zx_izGy^w
ȡK╔,epI¡3+-TK_~:Bi>/ [>dվ$mc:֨㻏EvYZ.y^{c/W  |Y a?~>  =|Kx(#YkKQMcko#mWRiB)(5/+We { }xDŧ#/ kPi)ewFV0\jQ4W?7ۖ퍼И-^#@-ߦZC45_%#/lDRc
Tb5 Q@ Q@	ij ৺t?n[ycoo4.S%_^j4,da/O6l ( ( (jO#Wƿڷ?gmQaK+ca{kx|'yn-Ɵ<qrK{; l7­[¿Ӯ5þ>>|D5t;K^Z `?u+=NOM,lQK_?i
y=x'[kC( jGhxZ_yZ%Z%=l]"%MG
x
[%x:	~Xu
b;9^c5|+"4erʂ>>i ??i:ү
W&xư^}ڬyorLWYq_~z7 ڵA>0]Z#z i iuH~9G6si#H4:K/G|Z~zOh/|K/5h:okĽ.=DfhzM֗ig֚imjq?؟]ǡj:gq4дM7RfՖ/M>ept:k=$,ӯ-<+6Iy{z<7rjWks[V4ω>/Y,:/G}0KlL~Þ ࡾ>Y|D>'-u<o
xS4\YZ{&5GBG5u
ߵ& F?~?;_/M_j:ozKB}uA&u|w_gjsxx~%$o|U\'n|Gt&d7	F4C?h|k NNCZM?|)Qׯ|Hk++i֬_@n4tP-^?߄ ઓw?|~M#>/U{,-{ɦg72 {}~ m* \3-Ŀ~zr|4Լ_Gx>*Cޤ^{[kB+Ğm6|_]MG5/J  3EM_<IEln/bŴMi-o=ܠ˞ࣷOk~'h1K*&N񖟪.fJ%6k^0X>u-;\'|ia_h.}E/|O?|C]Y_+YE^jv%ƍs>4P#oWǊ?~~|94/OǮ|=5ifKƺE:+*9LV:e䐴ʶ  />Zx+ѼmCewIƓ,sȩ,0Wa'@|  p eOWݴ'MG<e_vE <UWľ7l4o귐YiV67721F#쪊@,/[xN?%ߎ~6!<U/fC5}gs[x#j%䱵6po?g?G y/xODO~
^msOo]D){7Ydhdhbv~~ >~~|~
Uk̎	$kiQ&hXH(?ୟ_Uо6 `[~?(ε%]GޏDD<LLw{Rۤ^q:[5oNIc=\heݥC%R$"%hcyA(`>} ~~!<ACxGU;X<W]C{oe}'A{u=NVӯ-᳎}4FvrQ|@_!?>&h _=?{\=2.j˓ʵtlmv [/F % l'XMsM--O>7Km瘫yvS/j_
5N?mgG#H}Uͷ~ͨ,iZ$o&-6I6@矴g.̿_0|vmþ"_O "+k5ki7j,$w/??j=4S]^}Dt>K!EHmS$Xۋ~|U] |5ŞjD[O]<;dᔁ(kC :W >\zƿ
__c*i:]kjq6go5I? okGĺ<~_'4XX\x_k?G&ckk~%W\Cgpn-gж_j?/>Ua>//l{Xc+J)!5 o[uǀ!Bf'Odax565퉭݇n~56[$" 87 !|[㏄o\.4:7^4;IJmw{gj,$+9{E ;is~˺xo6i.~<#iܷ:w&rtH,"hB47 !|[㏄o\.4:7^4;IJmw{gj,$+9{E=ϊ6Cc^4_XtCȚKiG|l:2 :z(/?OHݴ Q@ Q@ Q@KQO   Q6ݾ?cwu µH뚍y94ŊQҴ'{[Y^}k/,tzGv+↵a[ xj
,7N
xUBe^#Aigm?|}φ:Nk:G fԴ^Qf{{[⺷<0k/|% ƟI<^k<kZKowqsiJ,맆VOhc~?<9 zOmV
Ú[+z6:c,]וs$7񿈿S >got mD,:'xd]3LR
ψ/ӭJWqʿR|?~M_	<{}[j_`K-S*xRZͼ+
K>kɢ=ċv|?~M_	<{}[j_`K-S*xRZͼ+
K>kɢ=ċ Be |N]]?/
_hZjuiTk:5I4>Kc,B3xw~#=f H`uFXa9tYHK}1R[sf~_x
.i hV/5O?:\<wc>^Oע%ћQL氽KCii\{ ۏ᷎?j+KCAxSCucѥKMYƦjׄqO}M"}@-˘}{g/gN?f?/o'7g7&i ~V]?gٿ>6jv#׬4}Rt[
F]Bx)mmm>)-/cVxc I^[iz^k 4+"ǉ4ˍKKO-ENYlI-.k2\iaoĞ1+þ!CnxtZ5ltk;xsamH+ W_I/E?+G4 ??n?|v թ*> d ɸ|H  V  ˿O/?7/G[}6OsI<M]"ޚvګI4HiL6{g|=w -nkK "5h$vWeK"TNl'ĢKsCeWaX VOixG+JO?PKh)KnrQ7p!_w 4oƟ>>DOe.o;|UKcMmZz~{ZQi]J*I??is Z~
xGS<)u{i?sZ=4u˨:曪_XPMf"ݨK?~|3]i
OOu/\[hizwv7)yr:* Sܩ-NB?ୟ_U 	aO_[Ꮘ<iOKSWUm'Q[)2xC\3[O@翋?JO  n#O|@#׆{x(noio#E:x R渻&^ח3*;Ac 4?jO- |C/x_ɠ|Ayi~(ójiW7 )%uo$Pb F b ?^U -G/o=}6_fҽeWmmڝ<# o~"7/į쟂<E
<qm*mZ:1h[Z[^Iosԗ1\WX]&-^~ x׋t=K#f=&eKkS¿wa(`w?Al)5mCOW-ZY/-]#}1%7i	dottkrb~lֿL_ܿď~w>0:#C\|+=Gq{?>{4!	A9|:|7a^/ڵď|@)Lxߊ<_'1-H-4m0Yo?64j/?Ŀj >%|Ew־*+ΈMV=.m>
M2KiVu|9 8wΈ:x[-uK?R :ܖplY.&xQ;?4cJW@t
GǷ^(ԭǏwrM_Z :<v/OZդD>
-/'?~zo~6y5tQ2Z.
^Ll-~}]_Iw,|?ִ3@Ŧ\桦x 
|`ީAsbk{X_۷wֶ[jQH?mڳ7~@?4SWx\5^ivZp[͋(o/aYtbvz^O)%/,4Eu|A-M
ѥ:2Om4ڬjq^F@~*K	=N{wśփh˖4xO]5H.lU-ouvKxcmV;ʋw
)KOc0  R?m PE PE PE |%  S 2< sM3|zoG:OxGk|#ڷ>j:S^"c=-4M
Ӱ1 [W? èX_'(i:T>uǅvӭngUFQCY]<V_R~Ŀ#+t76Wψ'e᎗/Z=g-˘,`i'y|y 	bkMǀg/cw*x^_[O<-nc< Ծx'=OZ׆?yc"s~,u_^_kq[_8NKMM  gůᶍF/A=^<a4!dimm
ximN{e'fg.<MuaEe% !W>(Kj{iv&
o#ܾ[| v   jھ񆉉<V ZjHlI7ټ}| F   5O) Y 
/O~ ӯ /4\.|%+ɪ~̖g<ǎ4~߶.o c}[_n>]%x/}A _~hZ_mzMoSZ6WvJQmk<Qj	%n\.Ϡ4o/Z__zd b%?  W~_:G1`C   	./E?a 	!_|o_??g>
.gO1ʟ/<S>x  4m?_f%?3dٿn&)|G|]ĭ.YwgTƺ%̖<i~nz圱-^{%&_|) al O^&>iOռk{z}mv˘?_?-? ϵ a ey?cW_߷RgC;YWV7l5EaoiZluƢkk9.4jʍ4K+/$	 dm L7_;}@	2>$~ SU7ů%ggO|E}?KɶI&ˆˉnY nA 3! N|XӵWmOӴ/	hXjVrW]OQ\ P:k}% C{# Po	 i6v_o<cxOxoDa^MUsYL-BȏP
)~ c4b> cV׽z/[?/ ¢|xM/;GV>ky&sj/cqcu[Op-R)Vx 	xJ4ω^0"~5KmO  u^YQ`Nita ' l g@o O*//R _gW,j~
 Ug j}s|
|wK?oOm"G>>)_
h?6Nw}·[Eq$vcω h?O_u
|al
bshzίu]u.`kul5hM͏?BRW[~3Oſ794Ŷ|:qQ]4N)m[Rk<yEcӴg|@мKhχt]v^Lokݠ-EuX? m؟xW@5 /j~<YKW'G~sywWz!Nߊ: 4P>&x|S-K:]O$pM4"ª }Y@ ( ( ($ V?c ??#K_vE PE PE P_I/E?+G4
( 
( 
( 
( 
( _&Wi 2>$~ SUm |%  p eOW= _  k063|
֥y
2_v66Mswsok@i;c 	>=SE[hZ.'ev	gwmBGw`f$Tc L~>-oO+ƣkѵ
|+}XI摩i$S8uR7ǭ[<^C	? ?_>8 =O2.д |w ᷄[_6Z֣br$K̫SJF | r|kj?ǿ?X_ľ 53iԯi:Xo5S
n$x'oO/V1g5+ҏ-.W5 ߲wIz ~ѿ5IGm]_'^$.{

"ivs[M: d+GJGwǿŧſώw<Ww^-+HmkZN+>%ɭo;>mK٩vDmtUW>8?l5ViW76G<2$r25  Ek>?=:|9+13yMive|׉aoDwa
x{7S#^.5}OƟj ,&m˛+=NyLqWOm.w>OS>#:оy?|wqsXG&kC|9e\:TV=˽Ɲq{_
g:WO^kKWVUյ[\uWQukɮ/on$yr78oكgs?] ?'.?< i q>ģ͛Bc;Xx04Wz/-SC[yZR0^CpL;c>>\|7kB[tPռSW5?xnK-nZ6XDE`.z߁
~
Oρ~iw_|}=VF;`ky;颏M+ۥ%7+.D@ Q@ Q@ Q@	xY W.|? 
-L<G/G><  
>g +6wݴ Q@~;3xƏ
xj/Y^r̖{,q"V,R# n l}}ƞO j f O/>W_/&̧^7j_K;Vgԫp5#폃'@xjχ7񥵄Ƒ1R\Ē,+%v5'.\eh;#(Mo'SIF!E |%  S 2< sMh 
( 
( 
( 
( 
K	% ( ey @'MG<e_v_L7_;sY_	- S @Uk|=_yꗺuޓrX[MOLM5Wg{>#-[jzeWVso<E)#*"1VV
xW?dړwl|U xźeZOyiWp<r4M,(RDb Y )$?ײ~>O[Gu$Mv#VXl]o6IpVT_b{ ڿI{E C
zߊ[bSV&wee}]ivw."_>3t CI"ҭ|yռ_irť7+l4ص}7+$,Nfu`ԡ;kEm~Qmd/$_~
#@W}D/&>lkf.Iķ"xZo8
`Wk G i/6^|uOxiU.<Y\Zfgko'!KHeZ<pUѡ/~1MSiN~fQl k!~>|'zon|]=&6;o]}6)khf6L%-nl;K__ G C<kö]n%,-gܫ_y4zkZ_k%J>YWwh|K<]SƛzyIm?whC/42\'CROT 
( 
( 
( 
( 8]? !i&r%ic[}+I=֯,}2)Y
C a|+UUQ"M?\MrZMe|/iyHCch#gmkX
o 
  D~8?d_h[wFVeӞQ>'
 3	NN8,48JqmIY+^^KS??QK
YIFx&ahm^cm4H%縸Y(̞E0~}A_<UGV{(ʰY],oݒ՚x_5{/z>ou-o"owkq,H$s+Wi .f?|mо#h=z<XE"FK3" /-8p}/>쓈CSH^r]'nW~ 3?-|f>B~S?5	m>D[c5ԐB3Y[*#5?~*ǎ+'Ėǃ5}[Hn[+k{kYct%Feuee$kxbs$]/8w0oneR]RӯRj+W.?_`[js' Tm&5Mk>%jz_Q1iφ{"~PE PE PE PE PE ~yG<I|K Eh?ZUmbL-/Qd,ok$rA%\'MG<e_v_L7_;}KD|!?sqj
 5ZL}mcOcq%ѳ"
YeH g_6 f~9RtѶ_gC][2oo[~l\}% : 6o~؟l *
 3ǿ?5I_c^_*_r4o: x'Wh_5險-w~UP,jVWO2jFڳf\eͼzkOO}>}Hc]ncUؠ2g k8xcp鿙qM/k 3
\^k;xmI ݝݏrḻͦZMs~qx?R'O @ i׭%e/UΦZڬЬ4Om&kWtt쪲Rcs.|4'm<˄m3?߲ηb:ԼKmwL [۫x k0a37=įدy>ѯg oጐ^jZHO4I"KfXmk8
ExyM[הc'Z';/D&}Cc??n_
|C<M5x#~(~Ѿ
9ռ+mŞ2ռMZj:>5φ|?no.&|?hߵU"?eoxB|/xZay:vխwGG%[dO#w\` y BGLdͷxt x ѶzSz
~ Po?Y 	t 5 x ѶzRT>qd 6j'F¼ gO#&2?ۼ]ӿ:OWT<?|]?Q=)
~ Po?Y 	t 5 x ѶzRT>qd 6j'F¼ gO#&2?ۼ]ӿ:OWT<?|]?Q=)
~ Po?Y 	t 5 ग़JEn".o}y?Z--]2UaozKA5ޛ[5aA[|.O4/5yL"Q:mfĲ3YZ]OӾ/}h I= G$Q?h;wm·~Ѵm&6Z4}k7.і)nb)|mg5\0ʚO+6hJ4~ps<OƔ)y/?OHץܭn=/ؓGr
7k{x஺llu\}UgENyn6"K4㸵xghf3'7
W/co~'i"GL_O&ڣGpghJF|s7
tnVPQ䔜vKWQQhY!nUu= O_/U%CZ~

ķޥkk2F%{;e?n5ን6OgV'!4նjjOssſiߵ_ᗌD>m΃w'=hzi
;rMͭs\A/ 0S_h/hQscZuuVzQ}V6rãG=Q~¯>7~-]QǯZo%i},mE-gYDq
T+G~!<Y  C޿gox;=/ND5(oegڪowEgM'6 H nv L} 3n  ? o1? hD(uK 
C &~> w 7Ta 
C &~> G; Ol?1 
?P L} 3n  ? 0?"c  ?{ ; Ao0  ? '6 H ny 
C &~> w 7T}`ů/AE?ƏXq&2WcIfqq3ZI)|/ٓ^|Ew)PP/!j^!֔^]Z[XiM}tZMx[f	2>$~ SUm |%  p eOWݴ|1τ>47|Mk7W("^YH Q&{& xO
ψ^-#A:|w? 	]hϠOŵxK7fG4ԥH5%9^A#N)X;
j?N;lմ=vz}s14L<]Mias_
!?? |[~JVR]אqo4E^cD!0 [Πm(a 𧁼acym3B[
KRf?6vLxaSbkdwW_j4*j*W4! G0 S>/><xI֡CTGXk$\y^Lor*~o?</	aNjVƏ~IKg+m_lk{y5-TכhO뱭h0TqLMI&ѵ~:ԙ4?y>x_?	7 	.xh>ũny3c78ǟ߳?B
!2yhib(IC[VCk}^#zE_ᎁ&ĽJ?AH&5;k]bt[GcOZC~	>x~( /|c-?~M?O2MXlto+7W7jچx4P 
( 
( 
( 
( 
( cw8Xv#RY^ Oo~+E- CeU̧7dd϶ '횺/<gyGÿM_Ş8[~֞vf[J9/nbX:+J-,eYg6;/Pi_X15+g',[k}FVo5=7SIHJMLΡQಝ=}Dk ÝQiXާ /$ԣ'^vN/?l?O
Gc}Σ~3~.~aNV:[{k:mw:y6xR<C)eBIu[_ku宣i-t]X!_BS۟#g\JX -.S  w_
q BO|4NokL15yaT-сp,
Be;o'Ժ{h/bI𽏁(xlХOmw-ao,Є%V>2SxrԟW
X.6?Sk~_躾w5MrK|9suq'$IcxnInn/ͪݐuX}_A	9AIűt~G[w
*s/)Vb?>_>Kt=afs=폄m<Qs#qu$}S
x^] %$;[I.onf)n.. )&8gᏎ] g|w|K͌Vz6^K{s@V	-f!+x ( ( ( (?n?|v թ*> d ɸ|H  V (?uM  x
3O~VZ7ŏ j7^i
,>7keMgĖW"CC["O7Hod|=  F|]a3=w^fu-NX.A.:xu^ϩ^4&B_-$Y!oڿ<0 VU[t_?=p?<o-3Ծ"A-=y{?joo"K
J}ΗND洹PaO W??Ɲ~_ >cZŶ<=i/u$Z>K"B\G$zTZ-"`ӗfX\֦ܛJuYz)iߴP8 j_+^oƟ{VPjOv=mnfI7yAԫ) l  ſ) 'u߈>06J5	>}+ImLiowoqq
[J4keUG֏F]cv="~~>c 
xs|Mj<-}?h1?e]_şkWߎt[4mo
bA֡
WFfӴkx.tżYΒG¿?B__ខ_zVIs7ih4nWsbOQ@ Q@ Q@ Q@ Q@ Q@٪x*:?k |(wq H4=ACjBծ!.%l|m4ݭrNKs
)ǂi	|E; 	u4z'gQeofŬV7byM|,+W(Nx%-_+~?rmU~	k^:K]Ş!|7l EVo,o,mbmZ\Z3\vU3O>]f1Kc֘tOyww96/$ҤGMBQv<l$:e]4 ox%j˟	&rĚ֩@Ak
suօCfl$ [y廆sAcogl,~"nzB.rxspLbbAΘkAޣ;;[H3N+bUJ|Z˲Y`NY${/|Uw/
> |(5xG`n&}0:KtU sW5<#Akt-u߳?}},^i>ybPy/FdYb;BL'/#/?m 
$_g|:(
7??Zyk.W~ҟ;z7?~:5MMomj-sRAciz^
y3+kio4\SJTGY|MѿfRk{_?hOg
K';*.o/iZcYnZTŴ[t%N %=7@7I*?m ZO-QO[5|J
[4G;n3UE! Q@ Q@ Q@ Q@	2>$~ SUm |%  p eOWݴ Q@[Շn~ g\
u_<yg޽-tB[R]I
,q#?#xk^$5C6Zk(5-/S.⺳UxG4RDVD+
R.'/i   ! 4 ٗB!cqŎmH]FKISO,T/9<cVo/%ޝu
+4? .>8|o |isu4_߈<)M%x/;:h{}ZM{FDCs[?_Ww>~ɟ W	loi&S5ˬI(ӲC1*DsҩOI6K]M5S}E{AE PE PE PE PE PE Pٻo~(|@"i>[j;<MV:e[Xi[=kgs3{ )|xwxG>5Ǆ-kKxQEa#KGhd䨊ddR+A%*YfJ_*{_[^VOppzg7q~'x ~"_|-	iG
wvu}zBg35[L]bϣ>V}߭m~+IF @~x | v ׼#eu[:}m漏
j\K
[³Z!̜F?NVB
Lnt~2fnM~U׷m,Gx3~#~ۿh/ ~&n<&e~#į_?Hv~隬RhYLn463:4Iٜن6_C7Mkw}ПC_wj!O<A z߅!n tdMv:e%Ԑ$7S;ǂ,>?k~ξ8пӽVQ񕞋Y٤8[BKed~}VTY&>|S <{|< _&Cu2 d1Ֆ7Z Gp-'ַ=SYAzj	 oՑ|V_% {mOҴ
.Y-45!'_xu[)..o&Pdl~	~ο)7WOxeƿMs ey e f>\(RQ@ Q@ Q@ Q@ Q@	2>$~ SUm |%  p eOWݴ Q@j #'w h?oǏ/5yxƾ'YEs\v3>ɵ;C#p[Hn.<<.
S+JME?]]h=M)+(:| ; 3 c??3Utq êZX[Eiam% 3Q,6+A0&(Gyi -ݵ>U 4~z(?Ei??%xSZmR[Y
C:/SHfِw+`Ѣ-.Ai_*Xn(Q@ Q@ Q@ Q@ Q@ Q@|R?W_DWGCzL=r\N9oK-VhXG٬fiETV 3>) 
4'Wu ?ڿ>"YbM7RddMoDI\M+f 7}c|z.MK_3j6ztIj|Df
\Or֤9S)ZN%Cfܝ+ Q{ *Y _/	Pk	qyuM~+ۭtK K腦p4b	[-TX3nVgq2>y+| +~Gw|Mz4G,n]!G<J1$:FA)B' N(i^ 8%{a( ʂy=   ޷
#V|N3÷KZΝ$$a~y%0̬9/W[+_7  ~?TxGK<gxWGO[sjMuݥ۬4O$saν#B ( ( ( ( ( K	 &#oZ2h/&Oď/jxʾ 8j6zowO:`oXū_i6zb#Q!U+
դwcMkʟKYU$~~ۿJ
o:ǈ|!i5?xk?.ZRo|Q6{{F:/۬簶Q;Ot*z	rпsv!ȿomуOX5=|0C]Www&Ab~_VL<Ҏ?{5yώ?f_>||_sRvBQQI<
HO4C<"7g(/kF|2 п k/r}~7]Ec՞Yt0}]zJ;+'2+.SҊÜ( ( ( ( ( ( {?^ ?Jx?tfj7iI	<J7}1!{88VI|M}
뽼aD )n7 ?k)am{6v6D6֖VQiegcQq<Y΃|?J I?4ῂ>2k?4??,xMMŷ_[M'uQ%]o
I3TO/?٣A >)'ആM*񕟏1ƣѤj2a{(u+'~/x;E.⟇aխu-: șwl&}vF.pٶ-D4_i$O{^cUKUpΒ~_JIUv``p0p{ c]v7;ij5?W׉Caa_}͝ơYk)@O컻#}:K
15+Ծ
o5_ y' ?:tqXOfNr}~xw/nncbYYZXC' D!Q|C/$*qiZ.ɵw̞Ku>G;ƽ?cOXǯoE_?C<-z	
 hXH&Xeѿط/ ;cT=M>_tti$-RkxZ;sx~Ksg3.?dh 
( 
( 
( 
( 
(/&Oď/jxʾ?n?|v թ*
OS>4|U'DkAUύFysh647Ͳh iXBmE])J1??`⧃tڗx
_V8^^(dm ĿNӭfg uH~r&ڟMoګ	! ּcƿ'tOi>&~[Ŷ3fHi˥H^K C\]M5sE)F]n]m*u~뾑5++5֭M][j%?g  nx<#IwH4kC5Eb<Sj ͡dLk+	->G?*b?~'_xkɦ|"pZhѬWXMms
,W+	,},.i"J˵:  gOOQᯆu
\%Qm2(nm:={Ȍ19?p%Ox?3
t}'G8m,th{kkxUcD8UQQU@ 
y
9S55kLU^^ѐQ@ Q@ Q@ Q@ Q@ Q@|g *|+ ?پ16M#6Eͪ__Z0mk:pP$3,..PC/a|eIg-n?=."+0XϺǧmR~Y??/^G|+_5Wp ґӄ2׉şwj_N
gDN?Ǌ|xȆ;{O훿MVn{̐yk4 ˳<~Qx^YljKM5TqjQm5h# w `gW '<@OW֍oxZnݦ2DҬqe[H' guhʕ:T&Ϛ=9% XxeHNRO>5xs~펏J4.[-.5UcD"EUEEU  o ʁ/%Ϯ  T
SҜq{ݧw}<OZGK_҇ Gs 7{'TU>+Gi5<-%gK԰,ۭRwŷu Q@ Q@ Q@ Q@ Q@'MG<e_v_L7_;}@5R  m* e\Xß oG59oymuak6&>;bj$2yiom >}]1ߕ﬚ZGXo(7K _#[ *ԯ	j u"M6o;"4i p͒v⣍o֪{>vg_(S{)]y4fc Ə߷4ܟ']^ïxRiw^:[]_Wڮ"GKbE$\ď^_t
Oŏh?tKG	HZ»Fk澗˷c|1y]G0|] L?a?	7׼mᧈ4O~ )OY|M/v.geGᘭu\qOz`dV&?dӟJ- /~[_>\_hT{nؙ:QEK wTV
( 
( 
( 
( 
( 
( Y  'Q? qx3v ya|z<ާom
s^\.%
h.4OE es Q
x $_ JGN^tWgP_+ _K# _iRQ  |$㯂|i_ eLvxú٭M>;9ctmee$O$ q/&wq߰/ZYXMw ]&Pg[CzZuT+#,e PE PE PE PE PE |%  p eOWݴ'MG<e_v1k	|*~j_fi.mIGGvۅVbS i/Yi~6|~>wXD6MZi7mGm[C1rpf4|3ŲrQK38pE%'wAҿ/?>3a3|%V^u
伿f/*a
4)`R4;42~d|C p4fּ!yBxw!QӶJ15{ުзk.W)H\0ŭgn{99U:xl-oߑ-j̓wў
?J	PSL/t,,s[ h}vH@Rl.%iaty'ɽO%ګ; 访<fkxIGejI\Cmhˤj:=B6sf NyKҴ=G/=`cb!$yn4|%¾ǁMa+Zմ}cIUf97I#ՔA=
( 
( 
( 
( 
( 
 
_('lvds	5}7̷K#Ҵ:{tL1 gI; Y|y =Z?䛫8H|ΊB + 	q ԫ8JJ?sO J~(x Cٷ~~ׯ_wQokIn87ʊXӧ!2 GXIѵ PE PE PE PE PE |%  p eOWݴ'MG<e_v V!%+D/žѭw;Vum*LҴXݭacVESOßq𡲓HW ֝Cë
P632\%˻43#3;|GV6=ܛײKo,G-?RײI]y;?&}E|Q@tؤzqp <kŏ h("*QRx[xe,1Lx
NtԓkF٧ѠRƭ6(OT֩{_>&5 iO 7߰j_vRY[iqx/_")ln7vAuy~v'͏_8q]Zoho&b\RVvz&v٭Q^ Q@ Q@ Q@ Q@ Q@N>=?<?O𷍼)zID6~"]EDO4B#:
(  , Y|y8ι k@ n 8O/y_QL>Pf	r}$xK+ĴWg $~<:վ Fj <Sif_jŶi*	컣Tie/E PE PE PE PE P_L7_;}@?e	|~T<ux/]SN Ě&0y	@s^ 

 G (z'A?Q+կo~m48|M_>sNZes.ʨWZ D1q<O|^>i3yӞ"sir>9yRL\q[?c (v t?n?z? ࢘6 | W_Vxo [  + 
'= t??~ 9H?c (v t?n?z_^W ?j P a & ( ? c 7O K  d ͺx?K _
?dV|Y*?lu3fK)g|t)⺵x{{,3X6o~ટ|<EJxz~^ lKj7V~:d	hD4,{fWhK[tKY>M0jNQf읭K{ 

 G ( w C  xz	 

 G )] P > 7x %@ w C  x y?  |] _WT?<. G+*O?FģAh'+*O?Fĥ w C  xh='#oR»   mw <JA] P > 7x % y?  |]  y?  |] ##wQWT?<. I 

 G (
 w C  x»   mw <J4»   mw <J_WT?<. F u?P{G5?/;Si%ߎa\c>_(!T?ǣ
 W :/@ YJ ) %e+ 0  _¿ X K åe~ uxg_?}NҬ>^oyj۰l/d>g:>n^m3JU=sK? ^F ! ?v  u: 5 O G#_  , R ~?~ z &rU ¹
m "G OD e ]l?8f_]K<#:i[| ?e+ 0 TY_ C7	/  m \o؟?|>o gf9fvEnww+*>c'm;C
l}|] D {» O'p|]<Dh/+*>c'm;C|; 'o~?Q?^h	 

<y mw\ 5җ?y1 64
l}|] D {» O'p|]<Dh/+*>c'm;C|; 'o~?Q?^h	 

<y mw\ 5җ?y1 64
l}|] D {» O'p|]<Dh/+*>c'm;C|; 'o~?Q?^h	 

<y mw\ 5җ?y1 64
l}|] D {» O'p|]<Dh{q?o㏈V(ߋemc[t	KxW%v^Im2joVf|        2 billy  	@       | q a   JFIF  H H              	
       	
   } !1AQa"q2#BR$3br	
%&'()*456789:CDEFGHIJSTUVWXYZcdefghijstuvwxyz  w !1AQaq"2B	#3Rbr
$4%&'()*56789:CDEFGHIJSTUVWXYZcdefghijstuvwxyz  a q!    ?   
 z?_?
. nO^i^>c޼pue
򵵍M$[
=ծZNod63=CэrwkEul!U  b|c7Yuҵ]6K'-*"&Gӡ+6C,OtuV}W gK<ay]_IIq1x9(}K{먡
Y
GFs_|_8S}M/v?SU+;{fcw9T,+Jk7v3fHhgmo}?8ƺtۏD/?ɼ6?i01<WXV?\GR(P̰"iˣkzw? ͸?ʖ'JEX'r)95]ʮ~Q^E PE P_
'_5O=+
֕6s֩$mjb}Bk7
\iv$xş#D[>^x^!u-T
EO<yq"ڊ 7bG
~~M
8:XiQp}=qrk[>i;M7w⻂s5ie`, I'xi69N47dmv}?_w7%MA{E
b(ʺ?6eI,!{}8]J*$4o8>+j*P ߯X,sJ:'m[IROjN7 X/'aS_/|Cwmh$>qjf_z"+{M:=זlc+2aa9? +ΜeR.Ytk|Q@ Q@ )4ѣ/j$ g `}kS9=_oGǅe'w96oW{oOeO<wZ
z"vO(\A!X$9dR%_7|?'4<Wuys๾xk[Z~}
ͨhz̶dzZƖ7v<0}ڳ?޵uk;r-~nÿ3KGQ%"-)` B|CMj̶mvwc@m(i-X /#~\~߲,[LFtmoP,(b' x^Mӈ9BTZ] g(bhf0kDﭢtC |C b_BӾ-xC^tY.n:nekk-cYnE4'X|0<-Gk+u}/WD2iW3:ڔggwsikM8ɧa%/<ukSiƕ)-owRoIE{gE P޾i_N/_?S)O&]SWڤA.we[Zv_<wcxi.$	Sj).9VT&^oD s h~_<WKíb^Դ[{o-N
>k܂.m%ddn _
Y3xƿ6?5_
^u8OiAjE2Ȧ;"zPT4u}ow?dOyMԧ77,vK2mgf$i ,?i?B*ǿ i>1 o
2\j_j5?
i3xv@tqul0j"Ms a	eh/߳w_X j7~3]KNOL4kf8<;_ZiSN{/抵㊕Ys5w}?kyxkXΈ.{|*t|=ohƩ%,O[[&	 Xmmo=3ܱw5\]Dj}ӫ?R|-_?3?C. ]</'ne<7X</nWR}%pgX[n61G+\9Ru94x?ѦģUt//`5}.SHmHn"y-栣JTl{ٜc*byN6SQW[eE{E PN{2sxoxVT>jZ͏lkiKZƞT4
4
-;{q=}U=9EuLX|]FIK_
xľn_:{4+K>%xrSE{x"i&IcHK30P	 W}1?z׈(~NnE;+O彾_ڋǈ|3ǋ/eeq|BdMB9dlABuRRxX*DY$P?O!l?? awDaltYd#nX*#yZ(s. kt}MtH:WgW/VxoOs>:??1V j}Gپ4^ft{g;x_|^<?~$i9}Xxo[h^f
>okevW$jSHͭ<\0Wq߼֎zm'E{!E P^e	7xWOMޠMO2[Gq,Q"X20F 
 7|  /L>5|$sU5#?.&--.o.e!ڑ;*>Я3Cџk¿%ھ(M>#<ҾxOm-z(xd󭤒ea-Tx O>#~wVPþ5I=Suuo\XjC!X7#+(Tiylˉ;ZKrvRWZjg~>m_L<'j^"E+ۼRI̱n4lFgWXI4%F*N
8|Izÿ~!OXr?jSx-=<3AҵYA.7rD{%&VQ#k~ߵxOV[H{-.e!Yg6PFO C8%A#+
(  ӿf
|A ^-P]iIMռ弎WkkHN/v1vidӤ :o?n?k?*ͧ+^Aik

PYBojO<Yw  t#7f=/Do577 e |Giwn'+ GRxz> ~=cmsWo*/Ətymd}FȭgjU厥-mGmxzi繝qHqdraߝTv[7h&;59={軷k^֫j~_/VUG3խG㶷MsR;\e/mlb@\E4%oO	 E_~ {5)G:3&0ռek>[+;?a^g	 gx+M$uQnW7syh"G0PCQQXNRr{ӣFzPMZ1I/ M|d߷<E>|/C.-:kxEѵ;!moweYw-ZdiV2Zk f?ڗ~+i??f: >%I_nwdZۼ7Qo7XF++ƽ\^+2ep )fZ5Pw\- ~ }? --CN>xCG˪͢ff[hxZH-缌XCc6kj2r1^ W S e?ᒾ~ wiv4j:F^Ht{֙}N(涺dR_P )s S?>-{čj>ԄFhE[ZZ[<wWum{o$WCq:]zn&bhKp	EU3߱goq
gDS5߁>-]񖉯a5;wVtzi8Юeiw [L_ڿG#A֍X}υ2;<Q[ݖya^huKOe_E*sw[_?k
^H	BW"0WkY ,r7g,шi0āa~C>2rFluxύ_&w-u/XOj1-- uw6Y^yy~U{>FյR+]"yuzrʱyīXhJݶ+vt[RgI_~厑{񾕤i:]6Z]᷶V8!4H$UTTUP 1^LR'YGV|3> Z>9 w9?kW~ǖ~[y<M.Z϶I3 ;kh ۯ/ oSOwS៌4
;^Ծqm]ܤsCC4o:* ~q]\|e?B^Ik٧UZkkhGiO>3>99O ׍]&)og&YwX呂rΨ_5S _:)A  ӕOO' $>
(*
G d' 'ǭ~_1 l~8'Mqx [v Ǐ;
CTY]ȓYGatPnGxMyOTPC ~׾o=~_/k>B]*R=b.vTdH%B:d  P )?q C_ko ׈ ʧE~jv?[Q{ #  G
 ֿtE Dq}o2#~( 6u/:hL7Z᳹7,ERonU8o:( ~4x[2uo|7rKȡHn{$viZEP$m  _?9߰?k#~
9T_~CNТ> /B| _|z ȣ _Ȟn7㏠WosI1gb_]W' 	izt74GqeqJ_gRxhbSyB?X؇
LSowiW 3 ~x[Kú]Z[Me` t+wgGoOu7#  u7#  u7#  ?n 'W)M_Í3/xᯉ43O-^dnqDf  }G¿#)1
,JTb%$=Gk5{4G	RԤg_ϜWв	 ȝ^ڗu ~(ξ 9в	 ȇGğRxN^
vxX1}+I4RCi'Y#HYUA$
    g} ; Aټ5p9^*:JUn(cJ矌e8# SR?x k&K
;?)_>8 zm|m.kX665k<J쪊@!PE PE PE PE P        ? lester.jpg  	@          X  JFIF  H H  XPhotoshop 3.0 8BIM     x    H H    S[ (    hh    t 2H K    '                        d         
        S6008BIM      H     H    8BIM            8BIM'     
        8BIM     H /ff  lff       /ff         2    Z         5    -        8BIM        8BIM       8BIM       Adobe d      		

				
	

 X             	
         	
 s !1AQa"q2B#R3b$r%C4Scs5D'6Tdt&	
EFVU(eufv7GWgw8HXhx)9IYiy*:JZjz m !1AQa"q2#BRbr3$4CS%cs5DT	
&6E'dtU7()󄔤euFVfvGWgw8HXhx9IYiy*:JZjz  K   ? ~L\EW嗨^T~/!Ě|5+t?}6M jȫB/IR
M;mG"\AvENE )O٭w;s1͖[]njPנф3YjV~"h^e"%[$
vZ4ļf[  
7 HZ6HGAA? Sw§'[!}RDH0ib_T
bv5#<IJt*2J;BAo[If5T3KV7JWƸo<?71 ,򞱨h߮k43n*z,VMj {z'c8S+ߏz<)]S+jP0#krv)Z <N :UXi]u8و%b 7<yr3b6h~ߟz'O͟.[y N/-wx+Ȳ  U ;OOܐ|A*D;zHP!>3y3) G@/- OVG%qP]Hƒ ' +#  _ȟ>{Wϓm 0um>  h[ќoE%k`DvOhjF
N鄹L(_tՆn˜be[ A=gUu*So}^\fEmգx{.ǖ17
:WO9D~Z;y@ŹƭXw\㹇;K 9;I݇PTUcC?)   - 0<|?娽-?Zs}
XvnjtZifiyGs.	Wn$u''HqN\ =/ϻt7~E 8yykͯY㭼h$J	vRA؎<G7n<@#~[}o 8ͺJYɽZ|UW| Ki?Ĳ͟AI?gY; 8i]/V CR?/O*yfYx,Tyn̑o2$7E7  GP00MuRg wݣQxB#;ώGr0hZV-GKԬeh/}tb9b>JAƹxF (#-N  992847#)ɭ8[ʗ[Q5ޱ빧0z/?cǛ?,YGFKa^NLsiPc65ݱ/GY9_+/~;p
|XlĀ!VSQzSx_h8a-H$y A"  Н+"c#
7O3u:GZ?J? dR} (>_i 9y9>zބ/d+AYIzm̎Pg +Jd>_  ~[^Qӓ6;0dմ]<4\A/ ?Nsg}姑9	*$}s>p<`s. ְM$>kg$2V{c2庚 JX+*UH.iBc߯׾'ZF>*LX1ȮJ @ۇwtd3՟y[L0-5V/R%I2Z%>ԭ a8Ok=Sφ&=?֏	 y;~blr˸}X:_ݛT?ԤJhA|3c4cJ~} <Hg b?t?YT|k?5!u/dXKtԲKs,\CqO
go{YXqFBB(¶gjvC>+lrx
U-Q"2$Q+ӈ\tЭH?PhnH(Pi~?zr_aH#nX
<aiŤjתI$Oj}89-*E T7RC@۰<˳#;U
yr#riMwVP͊	OZ~*'́y2(;u_ l
WfY]][hʩtvJǓ<,9-[>[y 쵒:
&6QȊOAxID#֟jVدۂ;	,Ph* z`*PA+"׳232BK;)SV҅ƞ=pW91UQ_kl丢<\tR	RA;4xP* GJldl hT (+S7jQ}]#R B@\&$hd7ERHhvXH*
6Bధڔ*ُ,7QU5ބ0RPљK!Vڢڝ*ԁJШCDq ʸԢ9OLʄٷ JvBFerI"qRi
s@Yոmi׾)DN!>cBjz@$DJ䤑FlEPI*
-I
(*OJ_psiR@O$ЁOJSƎ^Ph| wp?{luUzYGImu,rl+R)^jjA]V-+Braewd:MkҴqU8j*((큰$fQB4lcuvTa#vyw&riY
mҵͯovƧ,ndEa^Mp,XqO(8zzVr
PXI
z{%-{OUAv O/:U7/??pey M`%Ts l3' ̏oj;'R|QvD٪ǽϠ$7s~R\G=#<,RxdFVZw;$4
F%WƸGD7ϘѮt>Bӻ?*H'O|61<GO~_qg_h| ^}WPzn|NEcjs$y wajt`yy}CQ =F*'i}fj10GmW?hJۧl}ͱ| 9 8U 9't ОsOOITNḉdd~ ;q~vp8KXūl_ϯ㾨L'I1>wӕTW$V
%	?f|Om{3\&~@86>[ܺIzŎ _-[fH GmO|붧 )Eܨh{jE[oۋM8\QuXxk	#o^4(OU/g28 wt}P_~IC~X~'YA嫢"l]OwZj|=SDx鉮^Cuqg:^ÕOSx}zmOՏ| 9 8Y 9`:݈<~}64[*DZڍ+.z_?Mf1r #u0?zӫíEO>  4?/\SG󥂼u߂b7>c ɤ-cFǽeJ
ڹSuN%mgO<֚4t,VP\0cC{
;XxZ$FCwٴG   u	"P5#,sK)`Jf=3j}g3z	?Dǡ;ì3C"v=
:mw;ϳ6>,  )^ґ<CHu9w={o+黉?
y{<p} Ϳ_?/1
M2f,tN:c{ vZ@xhWvӍF zy?n.'QG>fEY^iv}7r,j ##0&e"˹1lC{q~'yCrIi-(Z!QFȣ!7\n?5]ŪǗrq򄿫>Ogc:K`=sE6ey{SִN%OlIa&u;;ugD%q$-? x刜M -GևPG-H,(|3ڿ 4 'm,O'77U!et;~ g}ҢuwF^LG mBݱRmlR_
FMo(F/3˹QE6$~U##-k_ۡuArՐPN>;*l>"CWcU"jzۦ<?"8aMy(;a_M}E
6>ԯFQ#`-OB
(G$SGfPA 4w~
cQ9-jzrzb2!(	JiMVʻ
Z
Em:(!X'_Uu%it߽{̅6ȹ)UMwa:`^'GrК1$ʛ?ΞO4A5TN%CV 1ZZõ0~?KVF$%AUxz+CM<qED˚cX*չj\<)%}y$bT*8@  ?,,yNdZ}V8uEr˰aJ&S@hw߷LU}C@=E**v*ۃJn}늯P^H:)JQ'~auFs	m#˭>#a%$z^rL@UZA'`)||KƪK57^!M{
w B,eNA"Ԋ0YB܂o̪*3,?Ӌ+Λ vZ
w(k{;͐r2W\VX:TRPԚASIpvǤ|grREb@cZB`@3~-Sj{2x.(ZP]_&Egz(ۊГ~9-2Yu2I&|𲴗\܃,dmhzw8ئ{
6LE=GJUC15a^*J
P|AICfZvtt-!X,*HRhEw"fmjBE`ŷbJ*7P4;o0z+c#s^0#)Y cnUz?x?ݮ
=Ϗ(? ,  "9ў?4ZB>|UQ@=BhW(7_&85MuD?#yӫg6>ߑe˟^JٿGk1M>:Pmt Ă9-~%s~Aۺad>q#`ǡ~6x6B	ZFonwlr,R<3FH\P୫xE ^ >u|-ڿ MR><l/o?5-OgQ$W| "m|ývԱ3Y~?~;>R퇛</2y{RꚕSAZ/q\3{[ڃ<G|O#ا&ȜI#Gپ)cMMִmJPbY vA98DؔM;Ld,o:<"U/,e⏶F\9TE!'Ϩ} n-_(%?z|S}</_z:揭ZNLb4Ț	z
CϠXF}me	DDsIarmjLf"kh~yLIeYJJv$OBc1uzL:RŚp[1f)	_La ǦݓN?Y@\?vOg͞ NX=.'ya< <{^9==^Aյ\YN\(Ò8%H#pA>vͧɆrǔ<]<lOðHm~93HEN}yI4mN#}jtpGNAoݟZ3,y#Q$zˆ rg}}9?#Z5̜bGJA>u:n֬Y
}$w'_f%Ǧ7e-iU֛Yϧ24771SE"2H)#=M !\W=y^iVwvAhIE] eQ.bBn&	&$u?W0F_-}='Pr(94f	;23_n?1F%Ɍ_#D {'ڌyL>}Ҕ$X扃G%dEk_qO<XLdc A1_M
~9]dG.*yx!I7R6e"huC	uCChi1ja<CB  snK;y\X U##Zz}[?4=ÃVFIvI'ߙ|˥&xpG;hG@-e  '2U˚<rռ|ShdfOAraƦqv2M?>L[ CP>U:wuY|	{i[K2)2r
v; w{Gᖞb9/16T܍z>:xvה8fQ(䁛!>!ȭ v#l1Ĵ`ň(G"I@l5H沅	u*6Ȟ5Y0rWQ?\Q[l{`@qG+ĪנM;oٽ:H_g;ԓW@U
X#o
w=k^­9DW-Pzl*Ԧ
SHyxJ|4~~tӖ(y^JjN3ˉ'`@ͶHP]H[ ެN	L5s >?y{NqyM.\CO5Jݟ ŬHPp]01d-FXxr
sّ	^M?fy)sʄj;
>9n1DaF 4K!m>Y~; j+_s qgǿ-nDlZOW G59C{ïaרy}>L<14A onf$,r
ᚆ5 j"7F&$(kJwʭQ;Û5XҼw{q_(b
?VtS\lyԥ+RXҼXcHaɕDt
JmT8YR"^%Lk@	(~'IYHAb(̡Q[$f<@;w]~?Q9(V5-PSSZڝ#~'V@ ǷP]P8(@(@Oj1KEI*;;@"qB#j$ܐ;|Hܤ+)V#/ hx$;eE*\"ZvSuJhG%EFǭGt8;<G/KGF"Z'PvzBOzmE17M$x6J} wn1~5+d6VWuR:?f 2,9-H^#SWr<I$/DOԈ	 PI <yيX_z
CCTOq;0An-cXr	 qZAtQdDU.
B8քwf2!?H/	(U&ORh0/}BdF&*j9 4wc>HծG?XKF]=6 Ҕπסe[(cI >u6jڅ>
()=ۦygfJey  .?3|y[LҼ˵#pYchk<swY۝m2'p"cƏ#cgDy(u/WCˬj}4aFSa}``rp>̼ƻ+3q븱+ :v|'VL	T|88/@1?/㒀F=CKrq QA-eח.lnӯgt:#;':h4OQ'e}/Iɤ?cq r?G>s>j7
Z]J


{7ϑ iM4eN1G}>kR*^\ns>?\k&oW?d3㯨|TyH/v
v ?ăoȝ6Y<ɫh'`&:oȓan#n=3i}hpg˧J'.4Z]`@O? : /O=ᑴO3h/-cM8U|
gomilxc=a{4GB7-9<:s fpLK_4?Yvl 0S~> p G}V8[(_pwca9F0hPZ5 iqz{ϣ }P==ߊ~Y~~[kyb̺F4mt
>~<9#n9o6S<;x)FQDk˽t}Q! <@o8DVj+Z6"^sgG * ~o
g~Q5 6A \ SϏ>S  x U״o-(vETT%^	|ezo^{M죈 2Xckz;Oz'Ђ>)&gW	DG >>ՇkiF2B1%.
1yYǙC/A፤ 
}\:\W4ENIF41~IqrI<(?вw-{F:BwCEQsÎy+Gf-MႽ^ wev}ww?f]N-ߧhjΚeVMktRE`G'|ڟ4A͐GHKJ"H{?1 ;ԡoX>Y0Nfiޛ\ h"k?S *rĹ?zK p;ZaSw4=rW ='?G? %  ?7 / /#`2NjVkj2ӗO;{s/vX46^C7<>yn,!>Tj_o7㞹]V4{-^MLyFp4/
Ͱ)D`'4T; {wɈzϻ) y֛?Z^1OX^0hn/u}Q-I(.mgFވPBB{ɳ"O J*t((sbڪ*jĒҼ@ Mj7Bze(TPkN@ƾ8r*7jȤoL|(& BGȝ
]E5$QPm鷾W*Jהs@aSʽ
M	,;,w!vJAC:8I<!J5hv;'ϒ­**@ vރzkKyN){):Tm~|zl&I{ Gy7'!O'y\Ȱ-"8^۱ܚwۦ}gײZog 9eϬ/I<֣S,ҳtbQэ@!odkc[5ӒV!+C3C26?nd>jYH?M5zn$_%!LD]k9l4?y O|6I>x xI=?}9o$3+EU K($p@w9Lr#	4G*vD_Tx"p"vX ^[`Ƞ@{v ))h"$-Ob:mJKa؏Ҫk׶⃮
zl	`Hۧ<Ems4kB'?
hj&6McƇP8zRx5BfWuqP7$M:o+S; `ARM
(AM?FoAB80
4 xu邒iP,.aJց%r ҵ%h*@wWB	,c`xty'aɍ
**h*/|о&ؐф>aPi^4ߕw?-/U9/,iKP|_S9R]`#v8WFGTVj ӭ?ӛ{0sgxjZ)NW~UxI
X@Ë

B;
EQ^	$@Ğ;1^=i+J'B%Zg!BqSOƘNVpU>`9ja~>26aԹ'"i$\=HqAm>*w PwհPuR{"d._ըb5`WjI;'s?\m?#u+7QNXY)fGRVbklcشj2^Oǖ ռ
WF|9$yFY篜Mu3>GʛyOۭ7Cكĕݔ+?^nVĞE~qJg~kK < S6 I y9w]OOZ u;k#޼Gh/,5H3Wkֿ|"ru+5Z|?QeO޲
Fz'Տ^"5m^ԛ?<r+eiu:G'C̧cV_җ|I_ZJ:WlxWD7gޞ;(.:MNtMk_Y"VԪOB}WT]O#uϸ=G\<gxZ" _kV^z\׎]B
{p@$e~ N " P_\c߾2KP5_GQ	o/F^GP4慈Յ:dJk_ٽ]봌7^xw
뀧^upq2%_og*
BJ\u-DM냈[B [n:֞uHn #ಋz_?>3^H`U5AMv&9	o]g?4OLe[}|>͗n״%xiى*QԊ`ՈT&UBLC^6ZqsWBn
|;cIG،*cR@L%
q2## 7 |7g#"J3 wSڦr2Q;{TR(nq殗r>%Z3-zM)C"w
U bĽxǩ9T|0_5M*Z⡹
5hM; +frAt|<wms#LhsŊҺV, B+MݨkIm7n}9~Q3bv o;W-![@Hc+S<NH$mᜦ=vW<#8$/oﻀn7v~71RRx콡8|HxwWyoɰBG~Ck33L1+Ps/OV 'gJMe5 @A$t Rsy *Ii4(K-Ȋ])
&vDt`*9>\q_;;}^(z2HY/^W`{;5N{>f
aVGM
g|ZCNMHAГO74 =`)#*WH5A¸ Dq2 PqއaJت+xT*ԣ&P
P^$W+걷'*OگP$2TC"+p`ۅkI۷od
BC38QQM:M+G9CcJ	cZJOov4+v;ǒE1U-#P
-R]}FB5eI]P4N=WR]􀫂*

	 r #y%YO$IU$s`J;)W|U tʿAi8WZiV'xPTl;W:">czG	4䄨y$ZЩ۩l7IO5ZFW}k/FbY\ԧI&o'oDŦ5P*ЍQB ?$Ja˼L$fy v?6aKu+EH vj@c_xȢF-/iw~ TPk⳻4IdY=CtZ'mLI̗S*Qh~SS	!rUe.ŕOPBXjw>8J| 9;I!_R]?{]^v~~<;v*UثWb]v*UثWb]v*UثWb]v*Uث4 KrG^r?G9`)=Mkɪv f`ܪGƢZR]-,"7PQ45z T]ՠD
v3 f<Zn5ZR~HL*wyx-'4U yaQi,btBkҪU
>aPW\*~?֬|hKA$4=ISo;FJs Mߏ~ Ḓ(+F@z#B⤯Cʊ0^#a4;lHdkq7CԲ8bp9~8FTRnI@,et$=}FGM>.\0c}
_KZ]c-̉?+lPRX S`j˵~z -Z<!k?jtz#Q*&FSË(}sN@$e8оBVҵ̿:^}w Xt}:!nkWWÉ3=Aɯ<n8LxiJCgSٟ-'k`k;7@FR22C>[dRyB/J)E{` .LPh#D@9n~|`9cC#&08zRhsۓTuO!GYtP2!#9O	ݓ 
y5F17$w^ɍٵ
i]D`QZ8 nH53	L
F x(ٽ)tzz/O"H 7.|=QNHjX-9uHwGGs;
lZ9`Ipؑ$zIr# 4̞9gDG2	&bRȦTuݭbXI~$tCm?ொ̍ogGJ`U[p@ϟmd$
#RhPVnGმ.  8BZP{o^pV&5j0ANiDAY 1IMhT>;r2H dH@Bw),rQ%ýzRvjV|euRZ@
$jǦ$_S4ZoF".m状V@x<vbhA؁MztW=IU0? #}1^kGVeS%VsON~D_G.Wí>bV<p*w"AcbWP1ef&DT݃ 2o^BP}Ww唯 *q(g{MbH_FJS~`?9G3	(y!]
PvP3Mb>>@!!`
 l7T*]H*Yk.O
7i֠х: t?3J	fUKR(
 r ~]!u;x(AcS} 2盙Z$n9ۮ(K][t[FZ
  =6@Y\lV Q1EFWp|+
~?f.q%uݕӪo_- `^ R'lc+BAU>oOYu]v*UثWb]v*UثWb]v*UثWb]v*.<ߥrn>y)yTS8$<s07DnHRwpEP+Jҕ7'`N5ޛ߾<!C3wP*hԩ^تu BܡoMtCCكҀքPRIf9~?uqSEj =:ǦN_MTPPƀU	d(VlԯZ IJ]Bī~,hZCZF	Jܪܛ7w) Z
tw_cx@Vۃ(u=HMuOGK1yFq'WpH^O-NHh(2Rh|k~NH?bw~o-{:<\ÚyxV`y厙[yQ7mw5zu
[d$TSldbqՂ6eB-^{cX-0"@p@uem&/b~h#/mH|c[ .<:S5?/j7uΨ+FG(JFdOHi͋+K}OSQ_
:wr1+On}mN1<=zd{eikG]FPx HKf-4lJ]u7γ~ꧧY"}ߎ[OkWdŋ8E
}?&}l
DQI
DH*	/A{xaZm`*@ܫTH;"}:G *8X
J2VU^^K,:v!n
Ksp8j=7RF%Yېh$}d B{´*WZ*pH?GM*lQ?M4pڑjR4|UСޑ/Jq; E76 dJ(B:PG-|	TH1vodhƾ_Qmj!>A$ԍh@1բ-Ŋ BJj:Wn6W'-%x+Un55~-a_H~*TZ8ljHT~  (:|k ):,0ڤ}^?FWjW*}?H=2W<$Y@>dP*k79h4RI՟կy*n(N'a #`?	cZRA(kNiH1GX
+ I6tYnJVK/QNaxl|]etrjAcL۷ApJ 7oC]6q7ua3SRZ5>	r3Ӊ$(j?[o#'VH@I´Ǌ| 9k+Gr\Jw5=s[>mZ?i{Wb]v*UثWb]v*UثWb]v*UثWb]_ )ZOJ$#.7bdT:Ӟv+^|34rٻɹ47L~Ep4jT
t=+|9PPnItSր?ܥ1TPaIaQSoŔw~?gM`1E^O߮̄h b5-hkj
71%+X"RnD
JנޟG\Xيi"ԧk+p)f1@*cb6Nh6֣`GO2Zh|ǨBy$I uOzS}Y 7aF#2N>w }9Q6&t V܁[a"ӈdNnZ.l2<Yx]@=FghgޣC-7^-CpkjA\cqoQݪE֋CR$CGΐz@5p˨w*9Hm Xk_
W{Qwǆ#.ײ=5(Tv,مM3vhPry
A4ldS%fsG"PGZr|(
<Ć`s TX6@JTA5\8"*h* &w$X']J,Noc~=ɵ0jV Z$صG C5&?,yWJD` Np{ri^Uhj߮UfvTTZ1>ҝ:րUуTXq/J
QPwƘm$UUROxUHʕrGP5M F E[P ˰O/i?ߵUHoD}vsТJ*U() |&J4z+&JP ؍0DW`u`#Ayp ߶H*D`גq@xr
^VHخdϋ`(MQMP}֐Jq+ك#ҁEz
AC|C+@42h8TW~<G%%YHU2I8#'M߯#kd'&X%*PrEkoM2W}ee+ơusֽ6N62 U]C/0HW5k#TP_~#>~gfv*UثWb]v*UثWb]v*UثWb]v*UثVi{_~B?<K<
0{m5**ܨ-J֝~e%

Q]Ձ;
}8Fh
IUܟ6	痉MV͒$QB}6`jϷrP_W⧈nv5^l#3*yQ^T
M*~{Պ:,J*fEV>oo|Unf$Zxra@@#o$#uD|hJTާW,>f901\fQ;$ 3H SP%ڌ_hc//i5&<YPV-Cz=O\:oݑu<<]OlԊu.??|Usȣ `cbYҿw''g꽚'+S +?c3_jGMf ?:Y$i vgV$Y^]>YT=Tz[IƭP$l8ڝtY{7">ܳV
 ET 
<3
NՎ1>fRO?&tJIH$H;<[DgI) jU3#GPz1oS`jzӭq;#vuHʱMsڨF>XӕI]2" P:
J~k0
B
;%zKՔ4BM^4*ZT*ҎH5
;PPFIUnr*AAP)PEptdԯSAZ܂Oѥ&
R@ӵA  <N=ZFV@|By@^,Uh0+A{C|vA]BܫJTr#4ޡF=~@(_T0V ԩ?D}v!V9@*AM֣兟813fԞS؝ALw,hioGP~-~?[D# JpP!j\!FeZR(|d nԨ'dou(L\*#(/P4Lxyuh'Dg*F?eƤFC#+}eD
b0(L$uT1q+B. 4$TZJxI/Ū]MEP | 9!37
S
裮È{}?՜_fv*UثWb]v*UثWb]v*UثWb]v*UثVizi(޹ܿS.lEjQU
EA|wv7"*UP
C7a%VrymHaJq*=3 XqI	ށj(G(M!v߾Np=''/T! r;P P 2e~?j3]+Ğ]v$Z7aCLZucF>4k!:n\ڥ8j(jWnGݑBrvT0+Pz}	V{n4[y%ky[DcLIq  7z]]N-FXc<3)ُ꺿'Sڸ>s<a!}NUF'˾{֧$rbwnt6
S<)ݚ
ܚ
8}Y
">j6g#4'?Χrz%֧D% D$*	 ֵl58(Ǿ2'R[
x2KV܁xm]Ϝ}c|' lTczc|<fOdjU>xPn5Nع%]'ng
(4"oSPCR4=i)
}& ,yIڔڛ
$`nz3w7xc~?%L~f/@HWv P 5MY[,LNA
Zִ;{bycu0Rl͖R(( Wȓ%TT!a*xWܰڀO	-EB;
w;|#})HNJt WsˢuHc3u&O{mM%m]Y}j)ݺ_ b)&)#Ҫ	%IbIP:+7'Bt-45=vo}>>HeX?TD>H5(i6鶿IZyWsZ 	xaA
GW6
GJ V'mN:~&%SpT ynIvĖV)BjHުPHEI%VBS ڻv)!{?Jف+AQB
	26ÑM4>@8Q-Nv00S/TrH' kʆk_
|Hت9
ŀP$^|'<r.F?-CJ)H^j	v*UثWb]v*UثWb]v*UثWb]v*UثVizvZRLOQ`(p*P߹ f`ۻjW<UPzuI~?@bF&o|BJ,˷Pi}TKڨĕA5jvGr=%"[׀oN
J |s!
`I`/@(~M{~)Zx2( 
$
)BDcI ?R H 8]Ӧy%q5ڽILO;J㖛(O1r06a{VгYehHUbHOobi?S)Hs |$b,Ǽy-v92}I$|'E<7> 4CI
oj,1L|9p-CfgÌUukqxu<rܴ]$;ǩj:#b8ǔhҼ?2li40?Sֳ-t}<ЯDM>dLj=U#~Ѩ*GMo^0gN2=0o`MVI Se_l:dL)|i_eFu$nƴ7̍oݏxN<#$L)W-͘jb6	t}/96,u ;&cEeV?i܏>k=OcL$\gW[FQ	 
ۢkcD/ɛ>.V6w^F^~ݝ 9~?z9R	9,Fs~6
EZ	e"HPůZR
av5~gD"4AM;֦{;(5,H$j^Pc ҹ|922CwqE?jG)iēZqTTl>pl#LǡQZ	'jz>0ʛ\I{ʬizh#oMMI'7d`9z)5
l JDJ(8 (* t$De$יb*Zj(qJ!Ӑr+^%Kl( ||𿓮.|S(SXUqK@vA CjWp	ޣ~lm&WfRĚ{t\Eo0_-5jՁoA^HX5=L̢K4#+-&
e@m[s$V3^\[p4	x!@a_nǻʕg	H1ebT
 l#t
,F rf<2zP4IJ9P*CBm<N=W>IjŸ,bToz*M۩&1L VB?	EkR|)NqLYUFX5ҝ:=xbȇy
דs-$uZv=~wc8]v*UثWb]v*UثWb]v*UثWb]v*/).ɥNH= p˴ XeoeI9&`H3G&KME۟6*
	X|*j>-Г۱bcO
A u⧒sZ@9/DV9%黷:cҤ/0 6y8ԧV1jjFp
}J U2=.3e{q؄M&1_hG|:#OIrjJFi^ȃ`>C>e{3q}R˨ɚW"=ibvk@7ܒz 3<Q1;~ ;ݝ[iQY1i4`{9eC}"Kx[?$l` J
>=FG9I#pje`=R,`W9d  Hu K>_9L^kk$wWbK;rbĝ#}eU'Q?JdSFR!(\~ F)"kRՙ<[f,9G?[1UOku5~`,o51}$}BqD}{R[&)pOMϦ5؄a Eӄt
i 	P(mM)+y?_?ͺז [\TNfo *3ct=Qk
n3؂"	-mjb>ڦ7k+rBaH>v	=#"bdGG9re$[
/ #qLsv&1 9}9v
3/~gyJ(:͊ZVYO]j< W4F5la(rpcc#Hh֗XǪX`ҒE-hj0S] qϙs}WQ=bh^xfSd^T'%9AZWvPF3(
Ebh+S*iP*0%`iT=d $^ B*he?Pw,CN
wtۦ<ёU1ڊXRM2TU3JDhw"b)@M+xbEhR1Zv ~VՋ"U-B+ ۽}
ʖ#UbTֽ 

Rp(Ydܞ P$ /p!7
6E_s5
E;u/{G/S{y,cuf11Z-ɦdkbyvY"iKUvm=~~-%WPkb ҂&. 5u$[Ӝ(OR*"Ҍh
oӷl~=̊#Oim B`ZPob1aE hIOMڐ*rEKE[~,jQ'dr<Hn(>ta R~RCI\k.QFcʣނI&wc궭n AUs0Eyfv*UثWb]v*UثWb]v*UثWb]v*UثViyO~^;uAQ\q  Ӿfr f%?dxV@^JmQa,B$W4O*M#jK'x38m (R4yeB{o3lÌ\!;-e!C_=hF8ifraQ좃?@{/v6<1DYt GRrɫOR^JwdxG@fIH449KN) /%=gUI8/FnD
/?,	fǒ`$C߸q+$/=ԒMWSS,/#"Pw[2k7&L4?*^rȪHSRƻqi3<%6aᚉNśFOH&Co۶b<ݔF.6};1j%ޚ
*I(
hHݘ.W\ZCw*%E`~Ea}<u~>_7g$gr*	c43 j H.Ltb|_NM/զZ3J3q ΣK-&nO/j:C1% LPn/{68璢ju_6韕>ZѼKjBŮ"?R-@%+Zj#\ޟ{ܓ.5ߑ<w囹h&_QUiPH}=T 9GŉW $oqW#Cߩ<zuԡ6;}-#w>MI 75j=xI;|hY=Nd@A UTh+qTL6A5
=klٖ:HC)1 {㱯|FČ	*@r_@$Jq$TШTqh}oO(*>. qȏ~<S6߯ʔEd ΥJ$֠>uCTpR9, 
)5 7K#=$f9hY5 t7X>GNnZ	JClsP!^
k)eRxZ)fOZQf?gޛv*r\ AjfdlVbnHx z5;0{<$1tȬMCqE)2R`e#40L=a1V UYI J"CrBR4tbw(*d
(d$#<7RTu$&u Co"(GiV[SG%A'&"T~_#ǺSUUU~!/'řq݊v*UثWb]v*UثWb]v*UثWb]v*U~^ ]l	A$_Gu
m:307r_PO'mbWޏM*TJ/X ֢_w:m9ԠV7H۷nC1Ht-qc^?7$nKq {mg:cw rFD
Pte<#^uŧ76ʍTvϿ;gqg8ǜ<}oP5WҴ;njwgZq8E||LIzmt_)Ƃ8ur+t#kĞcfjGFX8o<m>{E~ECyqYy~Fjj3m'eƲGfE<nJY).Mh#X fh%WLޛc8Wɪ]еiRvڛw'ӹvinM)Jw9&konno
sgEw
T7b}R^k9ЭZ$
,Ɯ?s0izA -],ǒwpZD@V*3EV4ˈw7wٙ"6%_j:YKet$>&} k{
'Q&ouݱ1Ă-"tH׻
ŪEtp$2=&O&2Ι]X\wg;[E؃Ofj	 Ljךu+ݳ+璚h30 Ar"Dݖjlƕ k??jߏʞ
HP@Q;#dyF@56?䖥 SƸDF`#׋D%F[LC"H8⦌Jjs^/Pzd%Aj i
	VUJִ 7(oe$ZjhJqӷ|ڧ+}>e)  Zҵ6"F ħBkr+v%y?OޞM)eo 66ޔ7XF["tQv[c iC*Ph˷Ӊ6̣-UmJCzhOǥhi@zָx"J
˩U HH&9J4/OŸ@(?Bo~!"5ԡ[(f 	R?fWQZ9҉\!R3Vxpǖ2 jEK'}C$x蓲1Ț`ZiُS<5:hBvߡW&
FYx9
OmL%;$xXTA܊4Pu(  b&-@NZ( ]YC^^O3Xv*UثWb]v*UثWb]v*UثWb]v*Uث5 yI$Mzq%r?֐XKrS+TN3AټW B|"
VT^m@փ iZ(M>=أV 4OcmViORA7搏Ĺ-3G	8SVTSZf)[		%P l|$tjH$|7dTG<n7U϶25faؙ "8z11:g#4D 
^~{w9PUT.cF(
=(gMr{_n_b21Mn#3jqGm6{ZEӿ\ux581v,>(Mgqd2k>jS}ryMsᚬ  t}̌.fثRZ.>1Ր	kxU{`fv6 DBw|o.Kkos䑳""T?mm0eY
vP{%J»+Y=+\#HŸRIZ_ٱ(9.)7
lIüPц--.9{YwYF6+K$sy!Uܗe@w}% .oMd.Ck[HZ7D<+"s}]{#Q)G4"Lyͧ#$XLBXSpO4oa.yG7%:
F?0kOƉG0C $vjOV R3Rv4>XU-@
m
4jB2@QbK0B+m!
j\l({r}=Xum0+Ȗե(**(:Tw!EC;4e4!iZ|щ%mgjxA4ZTOzjKO':^ dQR+sqT#rb6	ROd_9."NE@^_	aWa);[6 ^sHTw,HÍ(OqPC&y%q;AŖ͢VU
*7~j)iFBV`9ЃQ_楻(aY.=Fޜ6ڴ
jW;& .j)n12HI!(E")4݀#nġ|duoꢁZ} \A))p*+ɾR ;Jt6z8Rx-Z.x5?1Hxo=Pn$M71ug2|uثWb]v*UثWb]v*UثWb]v*UثWbY?źY-=Nw99mƕ"zfXϛQ#sÍ}{S ~OP{
qUf^.K(IMiX	+l _'r~ƻkZ-iK[hdhەއ9gh7ii6>Ns <4#61Lj"'20c^iڽc<`/KsnSƽw\Y'zBzEOo"Hf-G  [<2r:~< a;79-%*i3ImC`Bh5BMlj*ly)WL-e5ҫGO+^3suzO.}8*]ȧ
FV;~I2Mz[<Nj> }"5 	?r1X0nu0:3/`L^S\H"_`K"HhwvZR2b8 6 m5㑄=#T򥏖3PWu	nTH|%A'jb OogI,(œ1xO{v^Fch-Q[8#
<3FQ5!Rÿ週޽UC#KjoU=O
U$!j҂SpZ)u=EH4R6GPrfPơ?|)ڦlF2#R "PAvK+UVV>#FTՍNv،E)UiU@ $V;T4=d?ޒ)&D)6Z
eP
v=】~9 (f6r/BYH*9=od%W<EBA!$Wꡦn1==ΐ`3<@I@{ !<hyal]T/Ve碠E+IbUɭGR~y\x9#x#q3\$_OvEf'FP'cL}Ֆ(K_e`,KHRnK1d ~ƊRI?sںBheH_$MLLoS olH7( HPlz?3̱څIר=(h
[*$vVE(,|EF?
zcBOc`Ą 
~%~?{?=?^T#SKZ¦>?/'ǹhv*UثWb]v*UثWb]v*UثWb]v*UثVkxH~@_GT3wڿM*I܌M{_Q5AUS%iܷ"T6H"1CBd$Rb-KWPm{(s3 `oRb$#hsJGϤ4sK>(b̰_6Op i"IOn	 ?g>pc<P v/-)qI`FVFj[8hV2l7ȼzQ> }@ ׫o}>=O27# ngxu{l3MC?i4M
EϚl*d/	)D&mpi KNP^luΎ{lV;^$7^vjS;c?/nўVX-߫97_1X?CMv
ԭ4"Oن;?vo 4t]/WvpUK(V%h*Os:`,gxa!Kdo2ǛԴCleHu5	$TSjӶ'Z8rqo}zF(']ɐT0CZ:PSfl @;}z(S.YKNn(
MGS\Qh.8~e)9#zt$KL!bObw Pu;1W̶J0+E9FƠo`
r%.6i31⣍h(JMrLځ*
-*1cSCSZCOrYXJU7 ^'c4
 Ǘ-^lTt ޝzS;fprc{
+Om-aO_J&T6;o{ڞfjgn&loodϨMD?8|ڡUw-X?km;׿`Ǡ?/#_@P@Aʆ0b3w}eZRng=՝Gb/<fU~eīÐ:,TU R=zSwuV4)B*kQi%ku3eXwrI
Z<Gzm+bQTq ׈Fï^ R8*qQ]Mi 7ڤ
CHrP);ҟwߘڿ>>9q݊v*UثWb]v*UثWb]v*UثWb]v*U_r a*) $Xeo}ðz
}ٖ9-S=:xR*~ۏBv]^SFb= Rm*{fpJW5CP*3{-#qyg\xcF<<FDy,E4%àEEdv
zc@t5]pL?7o@wlN

ޣra;͸x2ƒls4=uzhgp?aeS&-DͰԓ6dtohD&<42W1H>EE <vwRG*Ԓ ܊wXg[.g?[ C3	lJ	ɾ̩4jcH'a;<L.vr*Jb>9TZS7z|­6rC<3Fmcγtr)zgzlђf<eyg!]=>C7Oh1$2N~>CdefHG΋NL#GڲP3=SNmK.Dh	 rF|\g%E6Uze
i2='Wm%Ioh&'yAx!,}!#1'eU8}dO[A˄jB/:UO@@{nB@tFp"tj5mT؉>(~	V\`P=V'(	;w} ZoLY)aĸc̖+QJW|Y-Id ԰˷S]h<d+c`
@ĝqz+?!M"޻|ݕhjĸ@>!kZ
b(&ĢHc5m~!&<'5qmjw*z,ת^i	?	-pZmJ.	ԑdCIQF~	IOgӸ,dw *Յv;
M ,l(yj 4rۣ#Qŷ45k@HJQ'
U4ڟlSܷWe
`wm7>Q[Ed%@aROJȯfN@w=	<P"6ƨPjP jR´M+_1G}2|ևb]v*UثWb]v*UثWb]v*UثWb]fyJ @6 tIPJ[UE@JQM+~?NdyaVΤ/&ARiy *
BU!AO 0U`>g&5X G*ԆޜAlg ̂X@Nb\F?N8Ċ?QgvKJz6k[4+;o꺲2<nOoϋ?siĞ ,CxG7\<Lq x6%N1iĝ٣`c
@ݱylfS1s(&ZUeBUf ArX@;穆1'o!Dx	\ix(_47~]S?y=Z1"7PU<ɫĒTV4~=8^^]\rZp9HA]Gz|=RVXƟ4j*0
瓭iWT̚1HeF̴
YbNjf9͘i'}Ö *3jׯ-WK*t:m\ZŔKE-ҕ?ۦ8HMKt W̼c܂?'I}"H491[0Byz=SE0[s$2,,# +ʄ֞9vVaD?4{[v8fqnӍxpo7TcNKko,QV0.<;!ht~^g(l
X{;~,e9e`o\Cl!
;q*PbMh;B5| ydоimǤ_(klCRۈ<=WglmFKv6OX2_.%YiPFk2YQP'}>R [k_0[y_9o~FEmPЀ> Q4v6NËO!"x8(dF`9:yyxcۦ:ͪϥ_Gs`P *hAG˽ؚ0k1S"qcc8C(2~#Fbv

nHf]jmThDc@-r JcE ߾hU%4}&!*F+q=+ s1Sw!E|w?j7[)*x)M[zTZ8"#lP)A]%mLJ *֔m* |E*4k>*; |LGr#ɔRJ:ו<({~!O!XtJA8Lk8"H7HsQ;EӴ-K"q#\R}\ XZEE=3 YK:(( Fwkiљ90wzх~
i
91nLC
֢lnֹ-
/$P 
;xc]*	p;#qM<k+FIkBzǐN n4'Ur 9EH#}X}?0v|b]v*UثWb]v*UثWb]v*UثWb]f7$v;z/^vyGp_@WzNG_ܪXUbAJ[+Z
zBoV']aKO6[9@Zʹ<dRՉ?lCq$@'yT,ۻמMRv(;ڼ:~#F\`e "NȚu3ۺ3?s4U|sǈ蟗^kZ\<rá-խT55z}8hoo>+2d|6AcrjP΍fkŨU[w*֕Wؚ12Dz;r grڌZs_OQ. v~fG#xC<g>S(BҤ֟GmoLH }I퇟50v",;nӶjsvlLOchP~+1,QCRv$53Ёg)m'iB A:K<}|C|_9XZo/hEwZa4ox^ruoֶHPzTj:al&L腓̯*2$]]^çO|št, m"R5yH֊J)Z
1&ǟCztoPX<1^H*AQӭqڸyFwiJR6pnycV$튄cU8PT^ GL6<ZYu <[f#R7]}4	b6]_3g2-̚ݵz9:04.R{k>eb=VP C}C("R<ʨ6,J+osMq2 LOYAfS$EUkO+S9"="U|$^H:-w3Ψb$P PGOh43.92[Vo?MԵGiɧE cZu
ႏ
W&upN\sgu|G]ݙ<UAF@,ʻ )QcNqJ!S`j*Hu)LʘںR) :g?#
]vW	`Tt$Qj@;*v35Z*iJV֕ǒT

OI)m';S94~T.	 55܀~_~!VUE<h7پMG9)+t,6÷Oכ|b=ߡɎ9
%9(C
4<{dSq}5r_G(J1F+M>.@ce/KR74bjԦ NKެSR՟NAtNI	+Z	ʌva#IiarEgV>H:x{6C: Z5vSC^'F¿CJyH@w 	Z5p殒(YBs'';kNFp(Ò4zmOvQL*Q5aw&t
?<ofy
Z r"xu}XG''9hv*UثWb]v*UثWb]v*UثWb]v*UثVgtF̷  `/l%(	$qFeǐm^9܂[+k%+؟M@%C ;<ѺgEZt"A=-vV
\ ·ٟiu~j 7>	DT_F@n6F|8d)OխӯLj$ۨ` SI$wS>w,2d?>jt?Kǚƽ坞L*z6V6supbX=_&=.3)E5C܈>ZnRх24Р@8ܚyj{i6.<0Q=/e		Zd3HpZ$9?kᵛ߫.K/ 3hR}BoOM+rĆz"S){Gfh>@p~d[vscv6cXrVԡz{OG` $cp?;<Z%B_/לU,P>ǈ$VE+gS y?9O1"M8ޛ}3#fGȆh%Ri׫քov_~z[tr.|1`OOSg]){}ҹ3Q!wwݸJҢW8rN?ǔt5_P[v_M#h;x*anMe}v1ikNG=ཤё1^1m_mBʗQ24S[Ii W!@Hc
p{ŧHd\ꅣX%<fU&k}X!#$M>I	B41>gno-DBz5=}MlA$	l1}h-B\83 2sІbY94Ibn,DdPwતjM@ڝ9j=ͩrNuy~ `di95*~ 
EMzs`_e	ԺN4bMOo|<GfeiUH6TYy"L\"YOB`Oޛ{,Z܈F5Jn;m`*]"Mzm^'돒VR$XTb=OjT/<A~Lc/+PiO|FAЏ
o 
]Cr%Hzˢ WፌfPv5#伆9UjǙOJMas$jvJKP@9;+
mOyL3"cԭ(6rHCGf.hĘBH¼
dU$;^Adm
fdߟ&bTmNH>]KJ$Ѩ{ib(
OPPթ:! ㏒`LrڔW|G܌%v*UثWb]v*UثWb]v*UثWb]v*UثVi{S$) _qOĞ9vyP}&G7*@^ѹK
l OjDf?
 C(;t1'@(-EJ8$ B1Iljh
۾\0IvyZMԬ;`䒓1D
lfG.,1O=z_4nk儉sЙb B:q~ Rδ?-h~\l"Y$O}s^6W>v<̫?Xn}@Uy86R7 oj9uWd]aGKxk4EZ1jGOyf=wr{=l <̰jZ։{hzaԖcƾޤ5hDw v}\6?[) :3X15͋M [njS
w;/GoKّ8}\7~cy;MnX+
!۷JI힇/rK 7Z<Fa"f&'-(Y@I~GeGy@UOE[yje&;V%TeC VKfT8PRr^`ɪM
Huh`o*~q;
d`G7eA躜m1R+εOV gy[\h<ͥܳIVZ1,6L5y<a_9xD}>x9>:n퉰>ʉ}`VW|݀J5Gq_y,"e%q#
ffsu#X'{mSNM?xN,>znLH9ۨeD3˯w{gNhÐWÊW7dLC9X%X>Mo.{صK5G
URiCCқnkG۞ڝfiz_>}zmai#lz.48dj84ֽ@߷\ΪYATx$z@y(mLaV~fhSv9DYt!=UnD8ʧ~=+Le+zmֵO T/)گ^A׾%WFb*{V#O!q
ʤ#V H4AL	]^PTA
5S* S?,
'GI
Qo"<2($cQJP o2}i
@XΛ8

j_|y,YtE?dR 6)yνze&%lTQ r5)wk8$)_jmӾh~?k0+gseS @@VE^2@n^$\k_%fRcV*+UjlN}N@Y7
釪/!hdjP04#5<@O(<IB%kcw}2K4;v*UثWb]v*UثWb]v*UثWb]v*Uث3J>E/l+FsӕC5ol
wU@"r P~_jU] rS!
w >NiФ'Mߙo469ŏMW?"4;׮< <"h3;Řf3"FDŇ*7"jt=C.K3QQLc@Wƽ\דF42;-(#$f@I o꽊LKO)pW	85|]f_}ķ:<0#PxZPg;hg>,|[_1əf^͆x)%Źu-EmE Ckm]8yw\ mDcz}s/?.єǧDm<ā4;?cBZs&svʓ8Gu?8Pono.nYظS݈͎9.-L53a1g4{]_!Uc֊^m6>'?fF@>u!p%jUlz
L&/fayj?ܲED0C eN7C03mԊw Y<	#r occw22_'y֩-bf*
ʤ +ZT^O:a)iz"e"G	I5uF&d'*z
3B'`A tN
q^4fC-S}*ǸN9oN-4YRޒDCh
I둦Ϗh6qݸ߮rXͶy[4RO -C$7p6~4ڼPj(wff_PUE'ƠxmUQG($'Ղ:IU5
HU$* {7kvMioi7h+^߸AqDh]IƭĎTnَ?r4dԕCkTVZt.ت޿U Tm{nCr5,ZZփ1U۔x5> _Dklm:;?{C{P>,ĚP.JR '`q,d$PA @A>0Dϱ@lV=@(7;{ޣՖ@n4_X$4@7=I#(sݝhhI(+ZNHfntS
'ᩦǶ<[RS' HnF]jB9Ҡq5NsኞKðflWF{tl	W~v2 " ((TR9u1_GņOkZ]v*UثWb]v*UثWb]v*UثWb]v*U__6i

TV	7˴ XgnH#P*_#'3&pO>b* QXi!cdgkR4PnMN\@H?Fa&m_ڬZeQVO@ R Pz@t#5ŭRjabsf*^@Fe՜$
 KMzS$kޏ:}$7&};?MzcyHB?1Dty"j'jqJݽslC>@q[g=qC$wXfe@J ,ֽ]P˝h tcxeKfULd3PNZ횝L,lU4:D!Igiji#&adlEAߐ뚭N#lKyn쥚6Fte>EaWoI59Hy繺JGfHjBX4lcL`wiSgbGJ
I#}37A
e/ӕMfF֭-cW`RJ)74Nц\LIؑ>-QɁ伉@ڵZlw=|e^ qbAj0 TwkeGZjv,($#upGb7	7~bKD^]6~ hd
cucZӶj	|Ti0#W
W`hj=sl)QCGPjTjZu޸/P25z
 zޝ ʦX.=X(X55"B>_n<j][Iz?O
`k3UEKXjMT+s2#V*XV?d;jkli
m"pRT$}kl* ~WfFfeP)DM;v=@~=p8j;Q$щiz兒אI
ʠзmCJTzkxbmTe`JPqowƽ1)^JIv$Y Pc@贘ۑaRM:VN}Du

|L}〚O[_%b2,M@$NFѲ$(#_sH oG4^ΞcqvZ(NwmYGד,4v*UثWb]v*UثWb]v*UثWb]v*Uث0
?ŚX$ ޸u˴ XeolO njݳ3jĄR6y7m_Ռ&_,CQ	Nb*INCO
5Rwb6~']\}vV猌AsJ
Ԛ.`dTC짼pAfZ7d{/1>!$?Szɝ)I)"WfT	ǫ 7C,zEC@4B&HH5}GjOɦeϑۯa^_;(=;i<&A}ʈ/D7H5pۯΧRFO!C>P69gAj=[}X3Hv\n~mgj`[@ՠ $6IN=;|4.rA Ӕg}73qAI7.O:Ӎ73CN"
2,-]٤=<&KeAnKe4/2iyM2v-V22"|c
91,H4
稡̸JOp@_Hq)ME[c+Hhj x NeDa=	?k&cPֵK]>%e&tgTQ:ԒAzVF]\49sKw<xDn}h1r5$qn%Bix8[
v FR?Ϧ,m5r<Mt{t|Zm7P~U"N@o&)#|+ᚽD8dגd\WS`%5@kKfv)Bك|_Ww`"¿<wm~qӉ!c*55ߥ7W4W 5 	RWZPn<[v*/E (vA=P*Wj:З@7j7Vj:~*ev?\=B~
ң	{b_*ya*Jr޻q k7\`TRZRN%[T<5 =5޾UEKQcvB+@A4iت7ف{OE\̀
5zVA@+OSx.6V )ĂEhK硨˚jT1KLpA5ڤ|ȪeVEB)Q)JwHs0`5Mz߮4A.ON
SS]]W}ckv*UثWb]v*UثWb]v*UثWb]v*U0OЊ֖OQO>ʼE5k&ebKPG!Yw*h(9pAp',(4n ZBn^
%k]E+Nmˠȭ$Ǔ(O:dU#E*#5j<G {d5XPB-65$8iNl$K0R&#1|mA_o	3u~Gꯈ!jڔK*ƭs"
ݫ{۝t}Ǉ$H{܏8tU'Thзkf:}?g^eF[ǧ֕Qbc,[Xѯt.%oBvz9Ϙ6PH܂@}QNSe䉳Ӯo	6vNCI*+PX6~}b7I֒7,'`G
l
Js|at923wyOPev	lQiBRǎze˕~B
Ĭ+ÈSXi0OudOgS7דlt;MfS]Ky+GT(z;{gU9gͥ$bE
Wuu{`Z!!UGI`F vrQHp7j@»~%iIYʅ$HJG)$!c>sGm4X9Zh(ŠwzmA/&ha6-.Ij֟'6ƊۅVBہݘ	UUY6[vGc|˶UaʼYcr
)鿾#fKRYMOBvm3ݹ|m8($
CRz̚J̷6G?qPf>H(U`WqUZJSG|rMZt6Hxn[*pcr"*Prz
ִU/O.MI4)5Zt3o	j lBhv^2Yy~?*˹*j!

I;׉}%Ć% G%#~*~"V \PH)
	ۡNkZ!ʌj 
N^YkIwb!YFdaƤPֽF jfq5FE*Jr^<4O$-CU]F7TsWˮb꾟^AL4v*UثWb]v*UثWb]v*UثWb]v*Uث1^CNBOe><IQCAʽfMߏP
)nekJ5۩x>OG
\*	4,)JتH8)1)ǶN	:VB(^ӷZ[tʯ|
P_y^TIKM@9S;֟<iffX+-hO~^dv}>!`VyCŊ'2=Վ%
>8cTt.I3B"*0#Wvn2q<]@Qg)-ۋo̦"sgǎTyn6^ c}/t|+;$P@nkNsKׯ1[ X@M*	`򣍊'zu!grYϛbE$d'o^C#)d5gdJQqyjEr׹կ|i?{ɰZgmM-WrNjr"SkyQ7|<wUu*oij! /GSEd]CKeH	,H5N7k#roU,A9

TZf
*I &2+{﷏)-"sb:ч@ .҉f{ib	cVqH~<ZI]iyۂ)%$qAb	0wr_U!ޟLQTUuW  5nsA8y(X.j;1VB2'mBB*: <
uw<7S톡?f}6"6IyϦ$њ r٪87q5PdCZPƆՠ
(>_j(:L	5Co* SK	;T#{ɒ '02 ň5@}2A<hkB((M(;׶R A t E0*l5cBFw~?^U^4IٶjTv;FIj(jiE50iQ=6%|~悲܉KFcJHZ1~>M+R욊Vk8xY+NKB*r;_'s Z1&߭65?GņNOs\UثWb]v*UثWb]v*UثWb]v*UثWbAOza82?GuUS wkO*<yq|)Rj^ېiLڥ^cP0v"8J (j"ر .0:*W{YD3c&$Hz
h"A;=EH?ъd"|=Nw4QP)2xb#C"}sOep70Y:H7ϭ{d͖"B${#G(tby\S#`m|h f|lSV 5_ǙחQ!.)tf9^V-M Vr]GM,F\;oTt45}&vnYd#DАw\BVCd
SP%XH«̒I (yמղL
7s]?4#v$(tGDc6w;b䁪<Idwbv
&#>},mwbR靎؝ɖ1ߠ2O]^JO膳Uo
GpI:;s٬ݝ9	vev]B{}{4MU(c_ZϜ{r=, }MFCRS~$oA
p%RksSſbڨrAt*vaaDv78t}AE@ƜcO
V9j$XEPO5ʆ6MH|h=n:}8IP$¦hEJsCUK
"c^jI:%
!

Rvv1l!mc6t8$.wؠm:jϧ)nsssa!\UTB $l@?|@WK4NlQEȏ&Hjua*Ҧ(O&
V9إ)^d)Ҧ倮*Hԩ^_hWkM_Z[V	 iǅOCԍ
cܮ XJ;CՉvRƅT֠R56q_N`VS&JT\ v5  +BI'kVTEenb 
~#cvG`kJU؂z}^OJ /((ϖ3^UثWb]v*UثWb]v*UثWb]v*UثWb>lav<InK"=}u4?3 H5ө |~ͻ!ZЮ١t[ZH)j\TTO;GYMs?%` `IÚ,BJ)ZMև}ﵖ24FBjT SjM^[%Ѡ/Wjn?fofW#M@qYMhpEM!|&E

+_ΒZ\#̫HyLRgp|/CIMVocbwo:r49rqxtew b(*\2-91~?Z|]
O09rOI[D·b3p-.5"C[*mÌJ֨)d`:aܥPrLG>gfNڅƵllFm
S={Djbȸ,Ey泸R6;sIn2,;t~Č(Ϣx=ωi$tP=/Sҿ.1/<
Fx`W6j7 :4jza#l/Ww0deN%%0J]%f/giɴ} 1^@C|
Ii_vC2>2/Yre,_7:TMLՒjB( B HHrdVS!$jT׉5&`(<\^2-cvBhU
rW<FjMKA|~UW)aRScR j`;? j<gVE4<_RWFV$ӗ;PW KR4\S*B용RuFx+Nw$R(5-VN	XjnTuݲ&[1>jz<"a@4Vm^(2^*G/M {֛ ZDS:M' mȏ&DÓ$R' rROCɍh*~R}0y$7Gʤq>"h~"<;8k71	fo
c]T *i¤E?җ5[fI ǧV*vMEߏzOjӾDE(Z61x*vܑQ\ !y`OZGRxdysr
xqb)|^O_!^&7BMwedg5.]v*UثWb]v*UثWb]v*UثWb]v*|4İ>Beyߏ0s]YXp+@
TO*:IaS PvS_<qQqRZ0jG4OR
:R׶*yf5 T@<c͛$Vb6n 	j#,P ×ޛP}TXI$ҵc_ViXWHۧ3/,pd<8ѐF@ud5GA.Opsg=\ 
 k(΋dW)yϴz	ԥqS Q^WG1b?#:7Hlsa;0B%4bg>&ɚ!5}z	k)똲kB	?9>aܓ/Їl+POnv1 6(ZS%~TYCItqi]WmN1-nlIavVg$2vLgpaE,6 azI2>GoK{2h#
m=|rZ_yzb=U*K=2
5ې`xЅ2A^ƀmC%M8Ȳ2ƭRj7@r`ǖ=)"+QV'Bh$y| oǦ'IWy4rH"釚?87eXMIX+Qc'h5ե(>c8n* 
È܊O%P(md<Qx
B@$׿}H&u5/%A*	ҋ^5'|s~B-IҊĮƞml:rbzڧ"kl_*tfO
Vm1#Ǔ"Pi%wZ

} u&n&*1`
A'ca_U*>PEC"T7\Ҕ$PG}}A5j8ҪW7{+!T:Tֵ5*"#*$rI"*Y#(PK)䴍`8~@hN$
X#+#$\ȨZ;dy-<ʐ3(Jq 6]$ҹ>,rr|
]v*UثWb]v*UثWb]v*UثWb]v*|_fJoo˰}lr)ˈxlz3'TSZ~(EΊW6Qj;׀ 
:1@6uE=8&w4 Û [ \0B$
TV#fՊ쫽@#cZ|Jy2I'PO
h"8$9 ǹkv@_( IPv߷oh;_[ځ3$&d1H;םY"O3izFR4B}s7f[{\}_
vG{qlXE:|irhqSoTU{^b:"WZ$ ȭYUEPB5=u>5 z>lWGL]4uO=?nQ>t1fn#I6EOVR̍4M?-<muGZluQs]>4g}h0e{NUFgJUD~qSʀ} 	wl֎Y0
B]q*Q7ݟi6H*'⥔Qʵv#NݒEf 2.D֕:WIrWUը   zZR7-ȳ<iV'zT :cy:R5
$T׭(:E.;?B p hEE6;0գ(2| T˨ץi玑qk*yƃb]9;'pŔ*kp:Z1˘BxqA =道T^I@>^{taC>+-PVJُoZl7~YsLM(ĳÓwc^]HÐrGz(j*7AR*EZ@CS߭xlK Ad$Pu1^(zt "kV@x0lAkS
oTdDqWE?j߷]PF.P8: l/em	4;WzdܕQ^2EJ*I$="ߜ*ۊrEG)<~''ـUثWb]v*UثWb]v*UثWb]v*UثWbt U ȗyWyU թȁ ̰V0'yyA }}FR~퓔O5;vR<d rT׍7$|^?@bQL*ёB! /
Q2HYdZr&?.<\\P;}Rj+QU&bkvV_4,y'@5jlH#~@~iډ|^KVe"*|
CŇcv6I	d6c# >i<>6L^{t"3MٺMx$|136L~9Eo:ah8KMۚ\q@/*;-ĠMn/u\cjLu+s!Gˑ uaA>h{ޔk2UX޾oN| >;e󍼾xK}\zled1呬v/r'F~,2>7C~h,/u8<ţ[lq;v$2CGܺWyǮ
Ub|LDwwy(yCVm"at>Hg`3
=ɺizONUJIE|i}xagW<`=ĺx}6'g`UZQzQe5 A4=0 Ǜ|n$n'jֆS,sf5!	=^0xOS*)ʪ	fJm*5qfa#⪌#
qZ~[\|)MjSL&HᑨA5¤VnKrAd;@;nN յcjytypbj/B}"I%c5U\P)JS(k$FTH7 @|MU·PiƤ$mF>Y<lnsk rWCˉ:7o*ْժr|cF;JC׀_TnN`[  A$*Щ;xև\)-Un鹩|Sm|V*Jw|Nȵ	^@ʐT} ؑT,,ޡVbj] 2}h䓘Xk
w+|#sb:@ =?rH <ĺ? *P;l

>S|Xd5.]v*UثWb]v*UثWb]v*UثWb]v*̿/Էt"z i_I߶_(}CeR)Vh_|ʏ&xlB "7**A*۪sR[B .tTGɛeۓ @q߉޼ң*|AqM4C޿NN!*Md5X#pҤ
,d8)2SV;nQA{B$ei`>}$]jw71Axqb<O^cA<ㄉ7XrS[sQzSyk뉷3RYg겜"P#Z f;FǑkYriw?K
FvaG7!c0J@?FS58^qx#{Ow+eB]_ }u("*0 Iyس;1%$|K-fB.l}{[KcZ}&ZeOI.. yf> 0aoi?g-1NUXZev1x3B7B(AO?'FF2eZ+;P*8"&BjO)ȊU)Ĩ;/QZb=Cz#אzֵ#ST(`ʯ*H;vh"DJ@ZZPU1&E-I;)zಝ.Q
(CrVFII
 L`M<O:Fw^]na]քWBzl#d Cد8CcL+[U6 {-!(M-MJm^GjR6 '[,y ٻuysL@QGyLҕ
I5n[~Ja^}  ?ޢ3&,ÉaE)N@8Bc	qƟl G郪Nu2 e P;PnzWj ^EUKĚ0;tjBѫ_*C]׮(+TQdB7h>AB+
HUE"05 km]޸UTP,WKúy9򥰐O1U+i_nmQ2>db]v*UثWb]v*UثWb]v*UثWb]g_yLGR5QM_27Ӓ#%"OAۦʠ-UE}~%V!	o9ni^;ޠ1RA
T`kxq \
9']!{*%~y"Nj))!#fd>!c伤.µQMw-ɭ+@4Z
<g)@`@ :u{$eڝn!mQ> Q.=<8Epuz}=_4oynOq(RK)عq)Fa^-.9i4[˘3,ҕT&9`fŕF ZI>[+e?HH e#?;&g!FN\OE)0d1l|}{:2qYsO@Oq9bovcJطq9SE}S?//=i@)]W he&?_=?lߡg}EdXI+Mo>r6ڪItzT
AiUsę
U]jՠp G}VS8Ri%P`+M$b;ճ; n`*(uk_ڸO%vELjGA@;PCA!Ԛ
CjG)UCs]SZы|X^3
DË j_
?{jP(<-VX^
h|j
Z|[Pe3vc"<05ҠSQȪc9UI|: k  K)IiQCRҀWsץ;m1GtP.$dZ-m\J	T<K8dZ'p>-+~E8)u? ҝ6Jj>%.AIQR54V8b4jQSMHlғ^
ՅZb
@
JZl	?j+ndcs]ȥ(<1*GG.ʼ&v`[(d RUVMwQL*!_,[75 12G)'66kڝv*UثWb]v*UثWb]v*UثWb]v*U]a~ 4*.(h
'9~J QVd]< *)ԚerV
+
aڛUJz`UM ;һ}M2T0QȒK Irk_a*
2.ɹ]HO.TP~"pXt<0U eVJI _NǿSq	Zt-ҕP7m\$!ܪh#ibeYn?HjgN)B*>.[X#Xxv5끦HbDla'6?>'#ksn\ldJ<I ]MUQ".-:^pbW
OMsOJ#^lڭ$n_҈p*305<~
h	5ݩOl;]_1~c\yL`O	1(G<i(яsSfCOi8-oK< 5C^zŘӧt!U{5|椣m#(	X盞fO_!{@}gf4,ImqivKΠЍW 쾯G#]7#D2c7~93nX1Ju3y)
'qRcHp/d<r«ZT gs^ *@{m~` w#S Wn89օ⢐U)=j׽;+y<ꬄ);PGUp` ES<
	'lY~?iʆZZ(*@+ޛ0;XFzaA~9޽Ui
GU<^fhh6`),RİC6].*X%C	mb7I~?auLǒe	*+}=	_2~XjXtP[zЃQALr#'f#`Z3S6aM\'rJi&ƾ#Ƈo_$l(CbOΝ[Ur%)֣*qDP%hTtJX9W =ڣzӯ|wU
"3GfH%ixnQ\h7$nH8 ĵ;QM )JZPHz5BA8-^]ἳn
B @&0SQ>?A\iv*UثWb]v*UثWb]v*UثWb]v*UثVa4EAOBJG}QҁjWcCpܨ%9+VX~6_i]bhHAmb2DV\ujbN/n̵,:)&'Ak$G'p(hMb|22̪ې:uZt"SiV(BE#S|U6Iߡ`<#" 䚯/z	=)_j77'l.ɇev~>X|^>_$z\iqY&,}{>4Z2nn]X1Wp@!}'mYAZ,ßy93!Fj|,3&Dj>He5R6U웭Xȏ,%Hcj7SNZ~ɾR(	7rr|I$;Vu B= tm;Z4[ou ́ ^:Gԟ#rϖF"?<j=jg x>M1(7z<
J$iRXbTvv w5	bv(ãv~O܊\yyg)'5G5:`G,%!r|Hmn?2D>⪃US9VAҵ=`rpZ*Vط#JZ%mzJǋΥYXFqgI3/
cVf @
EvEMj:`0
+ǡ'i%LݰaB	K @ƞ>UMH&UHW f~/E7 <I

>0Vƻ Z 1Ђ^a1nÈV^)jJ1қҘԯD!Ff@ҽFbձ?4i-y
Z1*h>cQ~	 XQȣU5o2?H_arm2Ք1Ĕ4*h)6|'lWNlp`TPQޓUąW(TȒC
R`Y
T" RIڻ,%V;uzc\ cٕ
H˯]P(WE%d doU`C=	5:cu}C:px$VQF=ȯP(9FVvu`7B
IxT*<f/	4aP	)vCʿ7_*[(F
(zv99ϙثWb]v*UثWb]v*UثWb]v*UثWbY't&N($.}I	ԷZNΙ:6!wnHzc" ֵ
H>=LaXNH8 ).q^L!?9MliH,y^\u4ӽ.D9,H4bT'Y4wHwIU] ]McM$<w%9eg QB+[-Qȧ74*UHs3dtY9_M$%]1I'JAVSFt=ژN ߛd)tu9^P%};[VĻVgr;)Q)Z|6PKܵm>J4h;EOP6Ƥ^Qy&h1Dx"i1ݽaf_=Rhu2ө$&?lAnah	.ǎrhlso%jVV|gUG=I_bogGp;*ڀHkZ
χ3$"@
Lc}@EiҼ:2cBDPZȴ,E_M4ROl6V'Ÿ5
 7:8rx4DwBĚPWǯя;C,Wַpʟb 4FFAUë*%j,R^
,*EGs@

QWh~?4ڶJrA5$k]5B!vP9Z]ԀVb $[ 5xQ^_u)HV5j%H:Dzfh@߿- n 4+mOL㩣(z/T4HYU8^5!8j$w
V@F9(Џg5
['M
!PXA%TaC.2T_M挤WRpD*;F㢼E$u*EkZ|cw,%/5nD]F?/LAz$eTT#Sn'4;һxxĒ+Ik4aR7 ֪~cF&rC7op&Q}jqڴ4#n/=xޘ@$9z=b4]s!"4QUu:(@ze
w>{XOu6h].cC'@~!O	£N's\cKgvƭ3n` 'ϿE4~a$R9wkM溻a"`.(X?g>Դ&|9+7'zF-r_ɓjҴߒR$ii<IUZ7(?~G7'֖䷘Fyu-:%fyx=/N?ɹ; *s
[ԴWoIi  b|?ɳoM,Y$a#ehjȍNݫ7'֜z
ZccBf*#>ԅc79&j	!LOgO}4 rԴU]q{>)}Uj_\WџGfjEMLSX
В oM#$^mXqEiר= 'OkHT\:VA:M"[o^5;)O*܂byB1MȚB7>Bͤ?eATxj?6Ʀ(AJW|0'ϼ$n~QyUpw枱Z|,?#Yi
*]aT('m>_YEV-HLRI'B3|)&b
܏}Ӯ+5dOԭMcqNުuR:ΙjNT'?oT!9:JJ ~[[{%CПTmO&c\2KX3(<QOkOxRTn~T5+)T=?ū$宥26xj_aјmivYB2]K-.);{فMl"A-$igj$34sKƴuؑr=7dbDPQQH@_jɉH7kUg`wzt!
M&CtChk^_r0ZT]59Y51 ^})<%HfY
/ͱڄNkLRV1O@cH
)ĨE~x~?g1t+SVKi5II"j" zx_a}91dd ҄~"==^\Cyl Qmn>[4%Q^?QYK/@ROcZǎē |EZ	e>TǙxl";tʂDPSTviG-#@9<IP}3hM֎J[iAuT	@$!P7jdJ|<Q >_}&YȽ+Y^;>!t#qԞvٰ*I'=-7όR֧ڑK5w#3˪LN@"b u M)Qzt1YdeB5U$S!^@b+OYl;.x eXrF"3D7yY:NYOYvO~K+tH{,.n vb(r~xBخa_Kw$H+{vU`Q.+S5!9DRG T>K(Jj1#xxBy	tԧR@IpT-w޿@#|!'x0QԎ%A R鏇[pKx](O:Zu58"yyVImk%ONO%Rn@)Z|}2+ԭ[vncPM2 ܃÷\;B״ʖy
j8CԦ2;!g`Wf	jȷnAMM@t+H[#h%8fP@R	>'$Fyah(
MCuˑv9DyqyDf8
+F4tmN<W
H1AUU#sA
cw;'#0QS"WX L䳻OJ ]/7=J P,ۖh"Uו My|P;pܥHF7^4
&GCo<̀(q벪
1`ڲQ0E"XA1+1Q1=n
z2\r6*\'ʑsZVt3"&`(ԩPY
zS¨I=D)9"
2whlo4|f48PW0()@9@cOI"w(5%SOPG q^|-k8bDCWg1QԺX"5#^%jx]	Bʖ": -wxI+|k$Eu,ed#4ހSsjE-qцߏ1f5    hA{:qdoob*͍/ENJ4Чx?S$$9 fL$HE´vEPE#m?}SiRG*3IC\iDT`Bl7ى=0kI+ՙPvzqa$41ĮHwHS}E;
q#t
شUlTHj=
#bgdFPքuaჀ'ܗn&NK

EO_PvL̒:3G( ~(S U!'qqr^×^C[I,p7(nbQ/:P4mxB|OjGRTჄw12T2NEcRKciNr5۾Ff_Ԏ# z$rOl 2er
۲"Z=)J~9+0
PFܘMtZ/֠,ѳ-)J'Rn䍌r\܂`YqJ|j𠤖zzǿ_x+t[~%4RKv;1dolxmYkh>j?a]-BeZϖHҞhȒ+wH+aB]oM2HGCO!n#4?,J:z|6F#mL<Aw0Msީo!AC)p]Z% 	%Kc|˲ѫza/4Tua{oBצNuN%kdPåkʵ5{C&Q0R_MDֈ\dq޹=?Xh2=:z8 ŵ//Xa.yߦO:qN3MA@y EԑAYP(KQZ6o"j1Bb
뻮Drhɗpivv";x8A<т^@9jMA PS9]wm\$Kn_?w8
bWYR+H]Y/SS|6sEom$C]-zT<}^[})NUe{]'#w[L29?^u=<RIO@{Rc$DX网ݷT4#l mAzV`V}o` /e5s/[EzH*P@>u;\_BFFOvsNϗ4/S8co& # 
=z)`:DtNt0pdl$n劥 @25a9"GzIKgs(@I-%h$d+rI葱u5ՇiP]ȨPG8A#RjZK~ q!6e.*Xf..M< G]PO9Kǚ.$~JXFCS6^uӠ wzRrF5y-1!-JYzk1P+˕ _!˽A*'W}gg#y}EeF=HO]^$EmJQ[P'A@=6fPW#HfYe񥍓ዑ,oE:"	f@[
4`)Xtb7ZmIA1+4bBJF9bO'_iXeu=*D-PfmgI>Lz0Ak$^1! ^Z84L5QV-@g
(?,ok\K5Y9 `ԟe mC|RDUYb<		${6B 5XNZ,A.Qď` ]?uoBʡTn+ȜU7NڬސFɌ Չ< bgwfiVі<ԍA>ޠjSW/R!ZӕwPn,3Y'2G@,	Gщ'M'IcJ#p<>bW[@\,6i-F	1ڀk@);r,ٕ|,S5<cI1",6jx:N=JD3$N`Z	UlxC
HB&q"0˷]$Ru .cje#eEgiZd`#1r;Z+E5HibA
PN!?1T!,NxǮ7`JS=wBckVXDHĤrƬP$ޔ ֒.U䓋E =|0ZA}b#͝6 :
TuIHͬ&D%&;kMmOߋ1s]1oPHʙT$Q4%L,k؅ztDMw٠19dUU=j
ĸ,Y^1G`6f%i7	 x;[NrSN0LEߵ$I;xt~?d$rs4ޛԝ*`6ĢMEF
ɺcym£a+	G\
֗Kc<JM
  )P:TC;@VU  
'#ovb#k3jvڹ l $p$#}+Emޅ"=UE;Ҁ|N6Qc҆"h!w 
Pm0@	^9uSB(~6 l0!TLxQ=Ixt?}G1d#$|@mǛUm<"~.([c+!aq	[4љtN$ F#qWڢRVU4L&%ک;cvW h⧜h~zV8GFf׉~OHLƤRʴl")Y@4
$+OWJH~[լ*ZZ@re4!Ǖwa7)YB6yN	<ץ6Y}7J:^n<3kcc*7,2GtBRgWE REUejcNW2zEY}n[_*Miz%<RWv<
QDepp:ӽr;qt^cop$$oZU4OA%&]̯BM^&k
\>DUSws^8% F79ZQCsd57޷o@C3@E<Z/>"EJDu"%GH`rQRe[ JᖱĀBH| Fx0I w R$NʚkbOm7 m?aQ=DqOn/-NE#
չT q^maXчGlǛ0x}VxJD[?PV+xL%Ol75x2T9/TP(Nr$6Q5(#7(ϏAA|Cq
&MÏB4`
PZuP۽YUuVI8AO^)gw7L)N;vǪۍ'rX4QA
P$xbwLGdEZ0HMުPvJljY$24
2F%SxUq
Ro/)VsTrUI}в,a*(%
1N([I4!K5y4׃Cz,pwpE3hꑫIyF"r-䮖ąg[Ԇ6bHnިUp",TDFeb:-[q);~?yE2QW\Qq8o!O|rC^_ %=6ƐmڀH 8)U}1GSC}MH?kjHXYrQА7:4Q銢ծب&,MCG#~+<VQo&+}1^-J=į@C͇$mԪ29G`G1~9jT$TJUXfZ O)l-"!baw,J~﯆TY!²
7~EVttxHMʤItW&WFF8ZJרGbV ӓ|6b}7ӌZ+ܓԹ!]~`r0BHb"WiJ43/4p\rRBFA+L6[wC1jHXmh~OE2$U∞wSBeެJ#}e m`
+5
z~ACN;"\ ǚi u ":<@֧||mpIi#R%)VߗhhQZ"~Pl<+ؤ~p!HRFI	z'LQ5Z
K)TփтU3W.lGB3
6G5"TS=IpVD$1䅒ڜَtH]";lњU}ȥ~SzA\̏p^UZ>"@>8ɵOsFI3XTj<OeցYKG-AlX}8{bn>%?nƟԥmC4Dգ}wIޔ渁A1p* &EI~5osuFM-SUFt,Br#d2#u<iÕdX 
fڄ
tpSg"N]ԪT|' 
ƶ^hiOKZy^9&.%ɺ CVk%Y8 S"qhl$#okzXdPrvՔ:C;"Qdnlxrځ/rÑRަTJ|pdo[KqZ$&BJڌ`I
EFQcﯿ*<]?ϾYbNU-cY"Fڀ5Nl$T~s_f~OVv}y1TאwO&yJj	Z`k\uΏ;?MWKn
G.k cȍg}%$ u|K4MmJ잔~"UMIQ
>!*y/"lnԲ1Mq&I'r٪#wLi\"Gy<i4/NL~%QQn(٦Ԝ1=B}G 953ki-;M<:A6
dhISBZ)5ͽ9"TrkP{FW?/Fѭo<JȄЎ*ԩ
l2~?k9&y)qk1%@+׿JY'[0)צ)#rѺMX֔5
3mpkqvf$nLbHy(^ѷCO`A#rH4[.y)ɩ""/k!5=T] PX,@+SZdӂSuvEmK#VFT%Ə4 J?<|Lnkg<W-KR"pˠE*
3R
x(92/e4c&Z'E~+_p74i/2#!;V.]4@ms?C!'sJ$.ʳM5!?e!X|M{pFVYmNa5>hЕ4+DTޞ$1u_=2H9MxϝQvqLtNvb=C jk*}RA% [~N>:Oڡa$[\K2[KrAC$B$uې6&gK7٠PO||9.*X^DIb=Y兖&"4;{^KHqj8IʑmTJprnL4<^h[+CP|}dKOc-D0dQ܂h)ڇTn}4 WCߊ:r@+NCD%NN~$ >]M?զ8G(}9IƊ|JW Ua)?h
GHC&Ԑʰ
G%*;Du 0;
M:!jc=y "$&92β!PcVX]0]ҍ$KOT>-	Ahf$Oo
4[#b9%>p*Riz1"h`k" f=wSQiz隝߸+0qUOc@?/_)ׯ`@nV|=rVDHKC#
Ezq_YݢeD!bh7P{r^M
yp4px6pC*}lF$p5kmaHY.I;F?l| Lmt+I!i~̪^SBj(mxJ嵂]iH:E29h(G;-m8XͿz-2ZYC\RN1J=;tǀ" ,n.l@aPi(&y~(⣣ XQ$=cAs٨~ (jT$BjpxW,O/Ks$BTR)#cº=
(C;4@~5\|4ӛH
leӖ[5U؊H_BxRCezQIjaufaCZjVDQxi+]N|-"*A24nKK$`{0zNi۩a"m+8X$a$8վ N7)eߡI!uu=o)EuYO{ ntbcQ@'uQͣYW<'SGK*K.@<HO6kN% .<wі_P"9nEm])BӜojm(s;dj֢FQelYMs+`Jzv'z2[ 1eP<Ii.
1ZOʶe4Jg\܀:wˆ(!WѴq,%v&`abq!"zu
v(]GJ/XWs
(ɧ2¾E% 4#Ԟ]=Bv.kt"03_~iixɥ7k6M4JT^[d?~Lnٶf;ۨ/C" v=69)G74[f$)0^+uX𩪟6~0e2?Yivk{Q$dnJV6˰߈>NMsaTu[iX3*
bU4gcsMK=6|>>o;\rW&5vgWAMoWՌO==Ƭ(G?~jN)SFء-o/dKHge]+(MGAzGz&xnT$1-ThT^bvlˆJsLaf_JKE_LR6/N <NFF)ݬiPR]>'Tϒ1̨EMۋ5Rk#3 چZ:xxaT'-敧!gqń2栓M=ilR)7Wf7jƈ,joʄ1У'Vѹ%0Amr+w¨ϫO5k%g ȼ$n""S<1^$ʰ:CEI	(	4{ī)pLk(+~!V,	v
K>iqYKwjS~bezmߏӅ)=X[kj%	rjzdPQ[ƎXᘙ:n	PÒ֔TuԺ}'~ H8f0>WZɥ~xGltkm7FdkiZI#j& f l+m>\I'FGZpڪmE[x?Gkj ggtG(Ua8 +e?^wd᐀9mN>[/pZQ @y6f:?)oFI_/t~ֶ 7O6,,{x?o[\wflt 	8]r߮ Z?{?mߟ^nu^in	jxpOqV?:H C1Jl)ŧ5^H <%
r-[/t~ֶ C`h~^)??++#K1ni'nlֶ nNi<"u*|A[I߽qV>ֶ +́ƏAD&v*:'?{?mWW =6VQ&V}\>^*р8H'ValZۗ*NtXn~7?o5IhHō+ *o[CC(t5R.A[a?ʹ{jNFI FX&H0'm8 *j0m$:.̌P\ 쫇[/t~ֶ6?'<};	=#^?^t];G!	!Xc?o[V_ȟ;b%Ӵd ֩vEc?o[KV:&$k<7,қsя^cJΎYҧ%@
ph1U>t="7X]"R; *oBjh:
jaRj.?N?ʹ{J @y\t-z7C}v8 *o[^!|Xi*c\khH ><
7FeOA9Q?qU>ֶrΒG6ȡUvVGkh =<.:NkN!V8?rGhj_6Eĝ7Hg
r,Gjj~|`]@r'C8>^Z~}R='CeGH?o[j_ϯ6L85LևCpV
+C=RAg/#2Zm'/AΓ #{b;S >ֶByhB%yviM)v;U>ֶ?6"Jt
Fw@=/@?N?ʹ{՛r7nC7<շ_c}<EA !W_{=oE 9	
&j\$}mQ !*tVOJb1Ty[Jnϗ. &(c/ Йm.w\xG	RDwT=0|6] +jUӴ]	(E}OA] {[	6}jpj@_O3,tQN4sB;q=o6v'R/C_ky|&L[wIJ4rA" "O_/m`Rp4ȌlZ2u׭ }2~lP\iU9$[}֪1S>֛WOϿ9 
,tQRr4;SLhC珛ZOS:b vNTC~}y1t>!xFfbZrp*oMfT4p{28=zvҜ?/ڶ]kQtQEсAd~_m;oOO_<jPķR+?\#'Q[ :v +) *eoB`nmhD`AޅM\?ʹ{
oDuҴH P\*(+T>ֶߞmfZ?b jqvQ}mX~}Ë<+}/ߧ\?ʹ{$lM/EPMۥ+9Zc}mX~~y4g+p]`.A4|r篚عN"Gt:.?ʹ{ܟkOUtޅ/2kh f-hǓ#ҹ;.AA?oPT#KK!ĉuƃ䝻o\r'כ&pi$!
t&8 *o[\ shm?Etd);ޞ8 *ߟt.nc	Az?ʹ{ km)
5>M{}m ]v*UثWb]v*UثWb]v*UثWb]v*UثWb]v*UثWb]v*UثWb]v*UثWb]v*UثWb]v*UثWb] ]v*UثWb]v*UثWb]v*UثWb]v*UثWb]v*UثWb]v*UثWb]v*UثWb]v*UثWb]v*UثWb] ]v*UثWb]v*UثWb]v*UثWb]v*UثWb]v*UثWb]v*UثWb]v*UثWb]v*UثWb]v*UثWb] ]v*UثWb]v*UثWb]v*UثWb]v*UثWb]v*UثWb]v*UثWb]v*UثWb]v*UثWb]v*UثWb] ]v*UثWb]v*UثWb]v*UثWb]v*UثWb]v*UثWb]v*UثWb]v*UثWb]v*UثWb]v*UثWb] ]v*UثWb]v*UثWb]v*UثWb]v*UثWb]v*UثWb]v*UثWb]v*UثWb]v*UثWb]v*UثWb] ]v*UثWb]v*UثWb]v*UثWb]v*UثWb]v*UثWb]v*UثWb]v*UثWb]v*UثWb]v*UثWb]        @ mouth  @       = (    JFIF  H H  XPhotoshop 3.0 8BIM     x    H H    S[ (    hh    t 2H K    '                        d         
        S6008BIM      H     H    8BIM            8BIM'     
        8BIM     H /ff  lff       /ff         2    Z         5    -        8BIM        8BIM       8BIM       Adobe d      		

				
	

   (             	
         	
 s !1AQa"q2B#R3b$r%C4Scs5D'6Tdt&	
EFVU(eufv7GWgw8HXhx)9IYiy*:JZjz m !1AQa"q2#BRbr3$4CS%cs5DT	
&6E'dtU7()󄔤euFVfvGWgw8HXhx9IYiy*:JZjz     ? 7FW.ڮF~O5 i{Sr&\19"7D
&GQ:XbY }fJDQTޣϛO21"G[INN:HG6.#f~vc CV-JuadrE
<?f轴?ᘱv(p1=$'?/Wo{tƱ	7g!ڸ_2p	2D0r@$?S6ʾ@i˽s h#=O/o>.*Wpcq𻈴]<g&)>7ٙtԡ)8#-̉n> $4̽_NUNZz
'Ÿ
TSbs?C(QϨ>AGٳ hRkZ.O*ߋ{pe      
  A display            Blue    c )          7    B New Button  @
on mouseUp
  global speakThis
  put "Greetings, human.  Nice of you to drop by." into speakThis
  doTalk
  put "Solve my puzzle and I'll give you an item!" into speakThis
  doTalk
  put "What has 5 wheels?" into speakThis
  doTalk
  wait 1 second
  ask "What has 5 wheels?" with "car"
  if it is "car" then
    put "Great job!" into speakThis
    doTalk
    put "I give you the gift of dynamite!" into speakThis
    doTalk
    show button "dynamite"
    answer "That's the end of this brief demo."
    go next card
  else
    answer "Try again."
    exit to MetaCard
  end if
end mouseUp

on doTalk
  global speakThis
  put "" into field "display"
  repeat with i = 1 to the number of words of speakThis
    show image "mouth"
    put " " & word i of speakThis after word i of  field "display"
    wait 10 ticks
    hide image "mouth"
    wait 10 ticks
  end repeat
  wait 2 seconds
end doTalk
       \ 
 A         	  7 	       C 	dynamite C       ^ C -                           	       D New Button  @
 5on mouseUp
  answer "Don't touch that."
end mouseUp
         Y , j         	  7 	       E 
shareware   i             I 	Register Ewon mouseUp
  ask password clear "Enter registration code:"
  if it is "70993TFTCTC" then
    answer "Thank you very much for registering!"
    ask "Please enter your name:"
    put it into nam
put "This software is registered to" && nam & "." into field "shareware"
    hide field "shareware" of background "Practice Screens"
  else
    answer "That is not the registration code."
  end if
end mouseUp
       l p           	     
  J 
shareware             Black      <           RThis is unregistered shareware.  Use it for 30 days, then pay for it or trash it!    Lie   	`      h      ~}|~|{~~{}~}|~|~}}~~~~~~~}}}}||}|{{}|{||||}||~~}|~}|||{|}{{}}}~~z{{~|wz~yw||xz|zy}}{{~~}~|y~zx{|yz{z|~|z~zx}{ux|yuwyxxxxyz{{{{~~yz{uw{yuy{{||szouo|}sqvyvps{zqu~}v{}|{|wry~xos{|ww~stqhxvklqusnorqv}vowyv~~}zps}{liyypwyirhfqrlhdjskfqvrsx}}}yw|zlbjxvect~v|{jv{ma`gid\[hpfbowxzzmm}z_Sdvq`\mwyusXdrkZMN_j]OYmtrpsjiyu^PXhnc[fzo^szeUQV\WNQ^d_`mz~zqng_[Z\\Z_lstxvxt[JQ\[RHJT`dfntw~k_^^ZUOMR\gotx~xqeoz];=Q\VKJT_gkzzraVTRMGHPZ_eo~uyv[Q^]LCCLWYV[htxxpdRJMMIGHQ]gq|~nniTLXXJBFNX\_grz~ysl^KDIJFGNXchpwol\IQ`VECJS[\cr|}}zspk_NHKIDGR_hipxpmbOM[\NGMU\]ao}{soh^UQRMGJU_hmvvl_PR_^UUWUUXcr}{sjb^\YURSVYakv~~urj[X`^UUZZ[]bluzytpjc`^YTTVY`gmvytj\\b^WY^]ZZ`iptz|wsojfd`YUUUW[aiqvzzrnbY]`YVZZVUW]elqx~{wtplhea\XVVWY\aglqw~~~{sxzqnturprw~}ywusqomllkkmorux{zvkchi`^dc\Z^`bhmqw{z{~~~~zvsqmkjhfdbaaa`bdefgjlorvy}xtqhelnhfiga_cgjpuwxzzz|}zwtttrpomighijlmnoonoruwz}|yqostnjmmgflqrvz{{~}~}{zywuutstvvvwwwvwwwy{{{||||}}wrtyunmokfjruux|}}|z{{zzzzyy{||}~~~~~wz|trvvrsx{{}}|{zyyyyxxyyyyzzyyyzz{{{{zzzzy{~}~zyzyvsstsssuwxyz}~}|{{zyyyyyxwvxyzz{}}~~|yxwwwxxxyyz|~~}||{zxwvwwxyyz{|~~~~~~{yxwwuvvutuwyz|}~~~}{{{zwwwxwxxxxyz{|~~|zxyyyyzyyz{}~~}}|{||}~~~~|zzxxy{{zz{|}~}}}|||{zyzz{{|{|}~~~}|yxwwwwwwwwyz|}~~}}||||zzywxyzyyyz{{}~~~}~~~}}~~}}}{yussvwwutuuw|~~~~~}||||||zxxyyxyxxxz{|}}~~|{~}yxtqqtxxssvwx}~~zxyyxyyywvwyyyz{zz|zz~}xvvqlntxusvywx}~~{wvvvvxyxvvxyz|}}|}zv}wzxngn{{rt{xszzyytvxuu{~yux{z{~wx~zywskku~{x|~zz}|wuy}{vvwvuw{|zxz~~y{vpu~iRc}p]m{fXt|yuvi^ertnnu{|wtusnlr{xspnrzzryt]B:Yrx~dTavxhituu{x|~td_^akwilxysw||~}~vwN/NjmuppTRepqwzylgebbfkr}}uieq}txxvrvd-4V^fyrK=NVZwy~w`NJOUbYLTYbrnWQd~};)EYXur{eGNdhpslqgTMZhn}afvqWj}zjra*@hZYĩ]jtIQnnh~}sY]}p[cnpzxygw~w|qm{{}fBGYq{f]bhgkt}|h]fotigc^o~``}rovtkkqo}`W_knrybguplkvwinpwsrsd`smfm|x~l`_nJKkjVfålJYqmfzyzsuujZYd`oeWf~~w|sOKWhmqx`Wcjht}nklbG>`Ŗ`Wq}rw|n{hbfBcyaPvr_ecNV{zlhwsaPARxpQTnwy}zyyRAizsn|jxlTj{}qhzuI?aÒmkxiZqkkrc=\eSU}^Nose{}k|{rxp\3=jԡoZVD?_ܶR>39mճl0-::X{tlNPj~zqrrdXD]}ov}pacplNdwhʙhupQ=hxt{qfrtgex{vzmov@9hڥ_GUYSb˳xcz}}}{h``p|xw}|qlw|oq~vhkeCRjvlq\\z~|^:Ccfniaei_e{zwkdhwwF6\ΥsnmM^~vڞszhNQ~wbKcqr|wxzrkt}rlmseJLmyrme^cnyqiencCEgou|ymosytu{vkgrvpnYSpj[dsuryyuwbQbTGTfw|wxwpdgz~rosthEMvŵtiNRX[wǷe@Opwoưs_M<J|pp~|a]v||zvqsuxmkbQeĪbDCitvzrnxxuaO;EjgZjossu~rjrxxfTnwkhD$=ͳ~VZd[FZaOKS`nn_bt~~}~{u{wuy~zwqemvmt~{vz|yunu}pnuo`Vawzzzux{x}xiins{t_hs\cx}ykdtx|}~hOO]\ttad}rfprjxzutsii{v_j~on|rjz}znclynhv|mj~qov~yz|{{z{zsuwwoyxjo}yv|zlcx{tu}v^`|v}|jtwz{x}ulyzqwzsw~{yxuzsmz|yx{}yss{{jflou}tgdly~{{~ytw~{||zyyz~|x{{xtwlhu}|wzvoty{xqponz|utphm~yowwoy~yow}x|w|~|}wsy}nclxlompum~|~tmz{txo}}qkrmgqutysm{x~viqxoywy{ruy{rpls~iyx{nqopskoy}~x[[~}wzwrw|ou~}y~vpv|~xxynp}wkoz~d`}uuuktw{~tr~xzrpu{xru~zuxvt{{tw~}||sp}~uw~~}{}ukt{}{vs|v}sxqymffJXs{z|jkrvz|wx|xs{zz||xpzzzqypu}~z~~~~yrx}~ww}|uz~o[e~win~~vt{~z{}{~~}|~|y}}}{}z|~||}xu|wx}np}qi||rx}|qnx|wy~usv}zrx}xz|{w{xzxxsq~~vyvhy{v~zsv}|r|zrr||}{t}|qj]^z~yvio{{uy~~|{{zwz~qq}{xwsy|vz~vz|z~z~|wz|zzkswsxy|{sirxz{w{{st}~wx||{~~}|~~~|zz|||||}}xzz{ztx||xy}~}{{~~|{~jJ`idzpy^d|||qw|ppy||~vz~ytx|}~~zzywtuxz||{yvx{{~~{z|{y|{z~zlXqcl|qevrtwpu}|vyywzzxy}|yvxyvuu|}||zxz}{}}yy}}~y{uZuY`uxp~lo}z|}wx|||~|{}|z{}~~}yy|{wy}{~{|~}}{~~}~{|~}{z{~~||~~|}~~~}}}~~~}}~~~~~~~~}x|xx~z~}~|~}~~~~~}~|}}~||}|}|z}~xy}{~~z|}{~|~}~}}|~|}}~~}||~~}|||~~~|}}|~~}~~~~~~}~}~~~}}}~|}|}|~~~~|~}z|~}~}{{}{}|~|}~}~~||}}||~|~}|~||   +   good   	`        p܃P  !~~zy~z|wvm^o{wpw{ut~zuv|{y{~{yy~{squ~ywztuyzx}y}~}~{xsu~|wspuz|{vspqz{|~xxz|op~||thfkjgny|wsqvwrv{|ztmnswvvy|xoin{zvv{|{}~}iBig]E2DVHGkjguŴgEOlqcZSUdttmz~rwuwzsjjqzxo|ڱW,frQF$1H3=yopĚ}vi:7eeQKQ_v~}mdig\[jӇ-@>+.79+\mj٬laK4!\lH<Vnzǽo|cNMQG@Srztyb 9IYE}Ǿ{▁[kg?%	(pO4Y˽q|b;(4FEATmvw܋ Rm
>lVnjھ\5QG+6Qz]5Űĕz|i?3BC83+,Oy{ҽd  ~L 
+*QOޯl~ҴN4yU+dT'-Tvmh֎vsZbud?/14GrjOiE 5! d0C|yn=NuY]{orz}sosxyskhrrgjv~yrpsx}zpq}{ty||{{mny{qhltwqkjpwwpnrttuwsqvyurv{yvuvx||z{zww|}yvxyy|}{yz~~ywsy~{rntywqnrxwpmswwvuttvx{}}yxz~}|~~}{~}~}{vty}ysrvxyzyxz}|z{~}zxy{~~zx||xux}{urtyxvvyzxwy~~}~~~yy~~|zzyz}~~|z{~zx|vy~upv~~wsuyzxwz}{uv~~xz~|}|~|}~{x{}ww|}yw{~}~{}|x}wv~}uv|~wsw}|urywv}{|y~{~|y{{vzzz~|~||~~zvx~~zwy|{yy}~{x{}{}||}{~~~}z}}yy|}{z|~|}~}}~{{}}zz||zy{|{yy|}|z{~|~~~}}}~}|}~||}|}}z{~|z{~}zy|~|xy}~{y{~||~}~~~}}||~~|{}~~|}~~~~||~~|{{}|zy{}{yz|}{z|~~}}~~}}}}|{|~~}|}~~}~~~~}||}}{z{|{zz{|{yz}}|||~~~~~}|}~}{{|}}{||}xlt{dvozyyws`evVob`wRfo^qlfe~wvwvszt`^us_as|xwyxy|ӶPy
qc:aaIc͖QctsXWXO`u,fhuzG9Jc`@,9M[hwz~~sLE 2cUP_XVmiS֋aɳwkzgZosI)Euve^oucbopYILNIIXmyujmzxĳSgfQ_\FCQ`qvdTeujszsmqtphafuxvy|}{wvurrz~yy{zwz~}||~}}|zyzxutvvttvxwvuwz||{{}|{||{}~~~}~}zyz{{{|}}~~}|{zyzzyy|}{z{|{{||{{{{{{{{}~~~}{{}~}|{zzz{|||}}}~~~~~~~}}}|{yyzyyyzyxwwwvvvwwxxwwxz{{|}}}~~}}}|{|{{zzzzzzz{|{zz|}|{|}}}~~~|{|}{xwxyxwwwwwvuuxxwvwzyxxz|}}||~}~}}~}{|~}zyz|{xwy{zxxyzzyy{|{yy|~}|}||}wx}|wx}|wy~~zz|}~}}yz~|z~~zt{smytoztozwpytq|yv|z|z}|{zvv}ztw}~ytx|zxrx}yxwrvzffkqyxzpoxcl{pu~xy}||x|tqqnlortumix}nu~Ttظ#
^frf~uxiG˕5KTW{t`guh[TrzkzvggYAsjOmxk|{mzimylskn ]-KX^luIuøP-w0ikUZWa`^|xrlLuxNSvoginxkgns{r֙A"!WT`ud[IR]F`ikNu]hn{~z`xQZ}\bwsixmjyktZ@&KM]s\eqE{DfvQz]RhWk|p~dja]v{nkpuy}xs{|zŦ2C̿1+\T~g|]|gVOlxay{\iYhsozis|pjdq~sbd|uesy{y1l֕!MNZ}rjjzVt^Xmhvlia_xg~psmnpkvyf_twblwu~r^3c%w|Jcu{}wsdVnegvyzxlh{lsx~xzqqptwkcm{yjh{|p{~IU>1W<gh_SrZ`lc{sszrl|zixxvxxhwrimnnttik}so}yfG^(k<urdk{vg_ogerr}wqtlu||zr|uoprvtmovxyxwglaYn_uwmv~ytwwo~~nwxx{|||~}z{w||xz~}z{~}|~~|}~}}}~}||{{|{zz{{z{||{{}}||}}||~~}}~~~~}~}||~}{|~~||~~~~~~~}~~|{|}{{|}{z|}{z{~}{|}~~~}~~}|}}}}|}~}}}}~~~~~~}~}|}~}}}}}}}}}||}}||~~}|}~~~~~~~~~~~~~~~~~~~~~~~~~}~~}~~}~~~~~~~~~~~}~~}~~~~~~~~~~~~~}~~~~~~~~~~~~~~~~~~~~~~~~~}~|yz~{~}~}~|}}~~}xmln|u}yy{swswwtrurij{z|she}|Yxh|d{lznzxy~|y}|~y~y{}~~|zw}]c]U~^q|qi{znzq{oftmnuzy~mhtzr]zU~paYQv`Sjl^gqvmUnUfRsxUwh~xy}}ro^l]lunqrzmzreVffolzjicgWr`rcwU`of{hla\T[bicndi^xvwwzsxxuxz}}~w||{~|}{uy}{|wtw{yrqvytoornhgf`YXYXRPRUVVV[^_dihiotrsutssrpnmknpkhmw|ywybVVfxMbr,@nK4XqYASw}bQ_yzjclytc_ieXauwhdxvs|xwvqvbo~tzdb"/=ޣjvxⵁxuwu{pį{qx}ooqoy|vz}wz{poz~{wz{sllmkkoqqpsy|{yz{yvuuqkikljghiehwwfexsls{qgpyukfp{ytv~}{|}z~{x}{t{z~yx}~zxyyxz~{zzzxvvvvwz}~|}}||{ywxzyxx{}}}~}{|}{zz{zyz}||~}||}}~~}}~~~~~~}|tu{{zmw}ww{}vy}||~zy}yg]fwwmvxzxhhsxtrv|}tpvzuqsz~|xxyvqrx}}{xvuvy||yyyxy|~{zzz{}~}|||||}}~~~}}}~~~}~~{yy{|~}{|}}|{xx{}|}~|{{||}|}~~~~}}}}}~~~~~~}|{{|zwy|zy|~}}~ynnqkiu{ux||z~xx}}{{}|ywxz~~}}}}}~~~}||||}~~~~~~}}~~~~~~~~~~~~~}~~~~~~~~}~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~}~~~}~~~~~~~~~~~~~~~~~~~~~~~~~~~}}}}}}}}}}||||||||||}|||}}}}}}}}}||}~~}~~~~~}}||||{{{zzzyyyyyxxxxxxxxwwwwwwwvvvwwvvwwwvvwwwwwwwwwwwwwwwwwwwwxwwwwwwxxxxxxxxxxxyyyyyyyyyyyyyzzzzzyyzzzzzzzzzzzz{{{{{{{zzz{{{{zzzz{zzzzzzz{{{{{{{{{{||||||||||||}}}|}}}}}}}}}}~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~}}}}}}}}}}}|||||||||||{|||||||||||||}}}}}}~}}}}~~}}~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~}}}~}}}}}}}}}}}}}}}}}}}}}}|}|||||||||||{{||{{{{{{|{{||{{{{{{{{{{{|||||||}}~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~   +   Print Notebook          e '#                
 U 
Helvetica   U 
Helvetica       @          #        @          #  
   Notebook display  h        ,           A& - The sign used to attach text phrases and variables together.    5answer (command) - brings up a dialog box with text.    aanswer with (command) - brings up an answer dialog box with a choice of more than one responses.    Oask (command) - Brings up a dialog box that allows users to input information.    Bcommand - an order that is given to a computer by the programmer.    Jdate (function) - gives you the current date, accorting to your computer.    +exit repeat - leaves a current repeat loop    Mfield - a container which can be seen on screen, and which can contain text.    Qglobal variable - a variable that is remembered until the program is quit out of    mhandler - a set of beginning and ending lines that tell MetaCard what to do when an action occurs.  Example:  Jon mouseUp (when the user has clicked and then releases the mouse button) 
   Notebook display  h        ,         PAGE 2         end mouseUp    1hide (command) - hides a field, button, or image    lif/then (structure) - a structure which allows a program to go do different things  based on user response.    if/then/else (structure) - an if/then statement where you test to see if a statement is true... if it isn't, you do something else.     :it - a variable containing the response from a dialog box    Hlocal variable - a variable that is forgotten when a script is finished    rrepeat (structure) - a structure which enables the program to repeat one section for a specified number of times.    qrandom(theNumber) - a command that chooses  a number between 1 and whatever number you place in the parenthesis.    lrepeat with (structure) - a repeat loop that automatically uses a variable (usually a letter) as a counter.    2show (command) - shows a field, button, or image.    =syntax - The set of rules that a script must follow to work.    Jtime (function) - gives you the current time, according to your computer.    1variable - a temporary container located in RAM.  